      SUBROUTINE STORE
     I                (LUSTO,X,Y,Z,IE,C,FX,FY,FZ,TITLE,NPROB,TIME)
C
C     + + + PURPOSE + + +
C     To store pertinent quantities on auxiliary devices for future
C       uses, e.g., for plotting.
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'SGEOM.INC'
      INCLUDE 'CGEOM.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            LUSTO,IE(MAXEL,9),NPROB
      DOUBLE PRECISION   X(MAXNP),Y(MAXNP),Z(MAXNP),C(MAXNP),
     >                   FX(MAXNP),FY(MAXNP),FZ(MAXNP),TIME
      CHARACTER TITLE*70
C
C     + + + ARGUMENT DEFINITIONS + + +
C     LUSTO    - logical unit for store binary output
C     X(N)     - x-coordiante of the N-th node
C     Y(N)     - y-coordinate of the N-th node
C     Z(N)     - z-coordinate of the N-th node
C     IE(M,I)  - global node number of the I-th node of the M-th element
C                if I is between 1 and 8
C     IE(M,9)  - integer to indicate the material type of the M-th
C                element
C     C(N)     - Concentration of the N-th node at the present time
C     FX(N)    - x-direction material flux at the N-th node
C     FY(N)    - y-direction material flux at the N-th node
C     FZ(N)    - z-direction material flux at the N-th node
C     TITLE    - title of the problem
C     NPROB    - problem number
C     TIME     - time
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            NPPROB,I,N,M
C
C     + + + DATA INITIALIZATIONS + + +
      DATA NPPROB/-1/
C
C     + + + END SPECIFICATIONS + + +
C
      IF (NPPROB .EQ. (-1)) THEN
        REWIND(UNIT=LUSTO)
      END IF
C
      IF (NPPROB .NE. NPROB) THEN
        WRITE(LUSTO) TITLE,NPROB,NNP,NEL,NTI
        WRITE(LUSTO) (X(N),N = 1,NNP),(Y(N),N = 1,NNP),(Z(N),N = 1,NNP),
     >            ((IE(M,I),M = 1,NEL),I = 1,9)
        NPPROB = NPROB
      END IF
C
      WRITE(LUSTO) TIME,(C(N),N = 1,NNP),(FX(N),N = 1,NNP),(FY(N),
     >          N = 1,NNP),(FZ(N),N = 1,NNP)
C
      RETURN
      END
