      SUBROUTINE SURF
     I               (LUOUT, X,Y,Z,IE,LRL,
     O                DCOSB,ISB,NPBB)
C
C     + + + PURPOSE + + +
C     To generate boundary element sides and boundary nodes
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'SGEOM.INC'
      INCLUDE 'CGEOM.INC'
      INCLUDE 'CINTE.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            LUOUT,IE(MAXEL,9),ISB(6,MAXBES),NPBB(MAXBNP)
      INTEGER            LRL(MXKBD,MAXNP)
      DOUBLE PRECISION   X(MAXNP),Y(MAXNP),Z(MAXNP),DCOSB(3,MAXBES)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     LUOUT       -
C     X(N)        - x-coordinate of the N-th node
C     Y(N)        - y-coordinate of the N-th node
C     Z(N)        - z-coordinate of the N-th node
C     IE(M,I)     - global node number of I-th node of the M-th element
C                   if I = 1 to 8, material type of the M0th element if
C                   I = 9
C
C     LRL(I,N) - global element number of the I-th element connecting
C                to the N-th global node
C
C     DCOSB(1,I)  - directional cosine of the I-th boundary side with x
C     DCOSB(2,I)  - directional cosine of the I-th boundary side with y
C     DCOSB(3,I)  - directional cosine of the I-th boundary side with z
C     ISB(1,I)    - boundary node number of the first node of the I-th
C                   boundary side
C     ISB(2,I)    - boundary node number of the second node of the I-th
C                   boundary side
C     ISB(3,I)    - boundary node number of the third node of the I-th
C                   boundary side
C     ISB(4,I)    - boundary node number of the fourth node of the I-th
C                   boundary side
C     ISB(5,I)    - element side index of the I-th boundary side;
C                   1 = left side, 2 = front side, 3 = right side,
C                   4 = back side, 5 = bottom side, 6 = top side
C     ISB(6,I)    - global element number to which the I-th boundary
C                   side belong
C     NPBB(I)     - global node number of the I-th boundary node
C
C     + + + LOCAL VARIABLES + + +
      INTEGER           MI,LS,IQ,K,MJ,J,JQ,IEQ,NI,NJ,IJ,LINE,I,NJMN,
     >                  NJMX,MP,M,NB,NP,NII,IEMI(4),IEMJ(4),KGB(4,6),
     >                  JDO,MJDO
      DOUBLE PRECISION  A1,A2,A3,B1,B2,B3,AB23,AB31,AB12,AREA
C
C     + + + INTRINSICS + + +
      INTRINSIC   DSQRT,MOD,MIN0
C
C     + + + DATA INITIALIZATIONS + + +
      DATA KGB/1,4,8,5, 1,2,6,5, 2,3,7,6, 4,3,7,8, 1,2,3,4, 5,6,7,8/
C
C     + + + OUTPUT FORMATS + + +
 2000 FORMAT('1'//10X,' **** COMPUTED BOUNDARY NODE DATA ****'//5X,
     1 6('    I NPBB',2X)/5X,6('    - ----',2X))
 2010 FORMAT(1H ,4X,6(2I5,2X))
 2020 FORMAT(/1X,10X,' CAN NOT FIND A COMPRESSED BOUNDARY NODE FOR'/1x,
     1 I2,'-TH POINT OF',I4,'-TH BOUNDARY SIDE  STOP')
 2030 FORMAT('1'//10X,' *** COMPUTED BOUNDARY ELEMENT SIDE INFORMATION',
     1 '***'//5X,'   MP     DCOSXB         DCOSYB         DCOSZB',
     2 '     BP1 BP2 BP3 BP4  LS   M'/5X,
     3 '   --     ------         ------         ------    ',
     4 ' --- --- --- ---  --   -')
 2040 FORMAT(1H ,4X,I5,3D15.6,6I4)
C
C     + + + END SPECIFICATIONS + + +
C
      NBES = 0
      NBNP = 0
      DO 390 MI = 1,NEL
C
        DO 380 LS = 1,6
C
C         Store four global nodal numbers of the LS-side of the MI-th
C         element in the array IENI(4) for later use
C
          DO 120 IQ = 1,4
            K = KGB(IQ,LS)
            IEMI(IQ) = IE(MI,K)
  120     CONTINUE
          IEM1 = IEMI(1)
          IEM2 = IEMI(2)
          IEM3 = IEMI(3)
          DO 220 MJ1=1,MXKBD
            MM1=LRL(MJ1,IEM1)
            IF(MM1.EQ.0)GOTO 220
            DO 210 MJ2=1,MXKBD
              MM2=LRL(MJ2,IEM2)
              IF(MM2.EQ.0)GOTO 210
              IF(MM1.NE.MM2)GOTO 210
              IF(MM1.EQ.MI)GOTO 210
              DO 200 MJ3=1,MXKBD
                MM3=LRL(MJ3,IEM3)
                IF(MM3.EQ.0)GOTO 200
                IF(MM2.EQ.MM3 .AND. MM3.NE.MI)GOTO 380
  200         CONTINUE
  210       CONTINUE
  220     CONTINUE
C
C         after looping over J from 1 to 6 and MJ from 1 to NEL, we
C         still cannot find a side containing the same four global
C         nodes as the LS-th side of element MI.  Thus, LS-th side
C         of element MI is a boundary side.
C
            NBES = NBES + 1
            ISB(5,NBES) = LS
            ISB(6,NBES) = MI
C
C ------- Compute the directional cosines for the NBES-th side
C
            K  = KGB(1,LS)
            NI = IE(MI,K)
            K  = KGB(2,LS)
            NJ = IE(MI,K)
            A1 = X(NJ) - X(NI)
            A2 = Y(NJ) - Y(NI)
            A3 = Z(NJ) - Z(NI)
            K  = KGB(3,LS)
            NJ = IE(MI,K)
            B1 = X(NJ) - X(NI)
            B2 = Y(NJ) - Y(NI)
            B3 = Z(NJ) - Z(NI)
            AB23 = A2*B3 - A3*B2
            AB31 = A3*B1 - A1*B3
            AB12 = A1*B2 - A2*B1
            AREA = DSQRT(AB23*AB23 + AB31*AB31 + AB12*AB12)
            DCOSB(1,NBES) = AB23/AREA
            DCOSB(2,NBES) = AB31/AREA
            DCOSB(3,NBES) = AB12/AREA
C
            IF (LS .NE. 2 .AND. LS .NE. 3 .AND. LS .NE. 6) THEN
              DCOSB(1,NBES) = -DCOSB(1,NBES)
              DCOSB(2,NBES) = -DCOSB(2,NBES)
              DCOSB(3,NBES) = -DCOSB(3,NBES)
            END IF
            IF (NBES .LE. 1) THEN
              DO 310 IQ = 1,4
                K = KGB(IQ,LS)
                NI = IE(MI,K)
                NBNP = NBNP + 1
                NPBB(NBNP) = NI
  310         CONTINUE
            END IF
            DO 340 IQ = 1,4
              K = KGB(IQ,LS)
              NI = IE(MI,K)
              IJ = 0
  330         CONTINUE
                IJ = IJ + 1
                NJ = NPBB(IJ)
              IF (NJ .NE. NI .AND. IJ .LT. NBNP) GO TO 330
              IF (NJ .NE. NI) THEN
                NBNP = NBNP + 1
                NPBB(NBNP) = NI
              ENDIF
  340       CONTINUE
C         END IF
  380   CONTINUE
  390 CONTINUE
C
C     print boundary node information
      IF (MOD(IGEOM,2) .NE. 0) THEN
        LINE = 0
        DO 395 I = 1,NBNP,6
          LINE = LINE + 1
          IF (MOD(LINE - 1,50) .EQ. 0) THEN
            WRITE(LUOUT,2000)
          END IF
          NJMN = I
          NJMX = MIN0(I + 5,NBNP)
          WRITE(LUOUT,2010) (J,NPBB(J),J = NJMN,NJMX)
  395   CONTINUE
      END IF
C
C     compute the compressed boundary node number for each of the four
C     nodes of a boundary side
C
      DO 490 MP = 1,NBES
C
        LS = ISB(5,MP)
        M  = ISB(6,MP)
        DO 460 IQ = 1,4
C
          I  = KGB(IQ,LS)
          NI = IE(M,I)
          NB = 0
  420     CONTINUE
            NB = NB + 1
            NP = NPBB(NB)
C
          IF (NP .NE. NI .AND. NB .LT. NBNP) GO TO 420
          IF (NP .NE. NI .AND. NB .GE. NBNP) THEN
            WRITE(LUOUT,2020) IQ,MP
            STOP
          END IF
          NII = NB
          ISB(IQ,MP) = NII
  460   CONTINUE
  490 CONTINUE
C
C     determine if the boundary side information are to be printed?
      IF(MOD(IGEOM,2) .NE. 0) THEN
C       print boundary side information
        LINE = 0
        DO 695 MP = 1,NBES
          LINE = LINE + 1
          IF (MOD(LINE - 1,50) .EQ. 0) THEN
            WRITE(LUOUT,2030)
          END IF
          WRITE(LUOUT,2040) MP,(DCOSB(I,MP),I = 1,3),(ISB(I,MP),I = 1,6)
  695   CONTINUE
      END IF
C
      RETURN
      END
