      SUBROUTINE THNODE
     I                 (TH,THP,PROP,IE,X,Y,Z,KSORP,
     O                  THN,WWRK)
C
C     + + + PURPOSE + + +
C     To compute moisture content at nodal points.
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'SGEOM.INC'
      INCLUDE 'CGEOM.INC'
      INCLUDE 'MATL.INC'
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            IE(MAXEL,9),KSORP
      DOUBLE PRECISION   TH(8,MAXEL),THP(8,MAXEL),PROP(MXMPPM,MAXMAT),
     >                   X(MAXNP),Y(MAXNP),Z(MAXNP),THN(MAXNP),
     >                   WWRK(MAXNP)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     TH(I,M)   - moisture content at the I-th node of the M-th element
C     THP       - value of TH(I,M) at previous time step
C     PROP(J,I) - J-the material property of the I-th material
C                 PROP(1,I) = distribution coefficient or
C                             Freundlich K or Langmuir K
C                 PROP(2,I) = bulk density
C                 PROP(3,I) = longitudinal dispersivity
C                 PROP(4,I) = lateral dispersivity
C                 PROP(5,I) = molecular diffusion coefficient
C                 PROP(6,I) = tortuosity
C                 PROP(7,I) = decay constant
C                 PROP(8,I) = Freundlich N or Langmuir SMAX
C     IE(M,I)   - global node number of the I-th node of the M-th
C                 element if I is between 1 and 8
C     IE(M,9)   - integer to indicate the material type of the M-th
C                 element
C     X(N)      - x-coordiante of the N-th node
C     Y(N)      - y-coordinate of the N-th node
C     Z(N)      - z-coordinate of the N-th node
C     KSORP     - sorption model index
C     THN(N)    - moisture content at the N-th node
C     WWRK(N)   - a working array
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            NP,M,MTYP,IQ
      DOUBLE PRECISION   ONETHRD,RHOB,RKD,X18,Y18,Z18,X45,Y45,Z45,
     >                   SA1X,SA1Y,SA1Z,X25,Y25,Z25,X16,Y16,Z16,
     >                   SA2X,SA2Y,SA2Z,X13,Y13,Z13,X24,Y24,Z24,
     >                   SA3X,SA3Y,SA3Z,X17,Y17,Z17,VOLUME,XQ(8),
     >                   YQ(8),ZQ(8)
C
C     + + + DATA INITIALIZATIONS + + +
      DATA ONETHRD/0.333333333333333D0/
C
C     + + + END SPECIFICATIONS + + +
C
C     initiate the working array and the moisture content array
      DO 110 NP = 1,NNP
        WWRK(NP) = 0.0
        THN(NP)  = 0.0
  110 CONTINUE
C
      DO 290 M = 1,NEL
        MTYP = IE(M,9)
        RHOB = 0.0
        RKD = 0.0
        IF (KSORP .EQ. 1) THEN
          RHOB=PROP(2,MTYP)
          RKD=PROP(1,MTYP)
        END IF
C
C       put coordinate in local variables
        DO 210 IQ = 1,8
          NP     = IE(M,IQ)
          XQ(IQ) = X(NP)
          YQ(IQ) = Y(NP)
          ZQ(IQ) = Z(NP)
  210   CONTINUE
C
        X18 = XQ(8) - XQ(1)
        Y18 = YQ(8) - YQ(1)
        Z18 = ZQ(8) - ZQ(1)
        X45 = XQ(5) - XQ(4)
        Y45 = YQ(5) - YQ(4)
        Z45 = ZQ(5) - ZQ(4)
        SA1X = 0.5D0*(Y18*Z45 - Y45*Z18)
        SA1Y = 0.5D0*(Z18*X45 - Z45*X18)
        SA1Z = 0.5D0*(X18*Y45 - X45*Y18)
C
        X25 = XQ(5) - XQ(2)
        Y25 = YQ(5) - YQ(2)
        Z25 = ZQ(5) - ZQ(2)
        X16 = XQ(6) - XQ(1)
        Y16 = YQ(6) - YQ(1)
        Z16 = ZQ(6) - ZQ(1)
        SA2X = 0.5D0*(Y25*Z16 - Y16*Z25)
        SA2Y = 0.5D0*(Z25*X16 - Z16*X25)
        SA2Z = 0.5D0*(X25*Y16 - X16*Y25)
C
        X13 = XQ(3) - XQ(1)
        Y13 = YQ(3) - YQ(1)
        Z13 = ZQ(3) - ZQ(1)
        X24 = XQ(4) - XQ(2)
        Y24 = YQ(4) - YQ(2)
        Z24 = ZQ(4) - ZQ(2)
        SA3X = 0.5D0*(Y13*Z24 - Y24*Z13)
        SA3Y = 0.5D0*(Z13*X24 - Z24*X13)
        SA3Z = 0.5D0*(X13*Y24 - X24*Y13)
C
        X17 = XQ(7) - XQ(1)
        Y17 = YQ(7) - YQ(1)
        Z17 = ZQ(7) - ZQ(1)
C
        VOLUME = (X17*(SA1X + SA2X + SA3X) + Y17*(SA1Y + SA2Y + SA3Y) +
     >           Z17*(SA1Z + SA2Z + SA3Z))*ONETHRD
C
        DO 250 IQ = 1,8
          NP       = IE(M,IQ)
          THN(NP)  = THN(NP) + (0.5D0*(TH(IQ,M) + THP(IQ,M)) + RHOB*
     >               RKD)*VOLUME
          WWRK(NP) = WWRK(NP) + VOLUME
  250   CONTINUE
  290 CONTINUE
C
      DO 390 NP = 1,NNP
        THN(NP) = THN(NP)/WWRK(NP)
  390 CONTINUE
C
      RETURN
      END
