      SUBROUTINE XSI3D
     I                (LUOUT,X,Y,Z,XP,YP,ZP,M,
     O                 XSI,ETA,ZTA)
C
C     + + + PURPOSE + + +
C     To solve for local coordinate (XSI,ETA,ZTA) of the particle in
C       the element given the global coordinate (XP,YP,ZP).
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER            M,LUOUT
      DOUBLE PRECISION   X(8),Y(8),Z(8),XP,YP,ZP,XSI,ETA,ZTA
C
C     + + + ARGUMENT DEFINITIONS + + +
C     LUOUT  - logical unit for output data
C     X      - x-coordinate at eight points of the element
C     Y      - y-coordinate at eight points of the element
C     Z      - z-coordinate at eight points of the element
C     XP     - x-coordinate of the fictitious particle
C     YP     - y-coordinate of the fictitious particle
C     ZP     - z-coordinate of the fictitious particle
C     M      - the element number where the fictitious particle locates
C     XSI    - local coordinate of the particle
C     ETA    - local coordinate of the particle
C     ZTA    - local coordinate of the particle
C
C     + + + LOCAL VARIABLES + + +
      INTEGER            NITER,IQ,ITER,DONFG
      DOUBLE PRECISION   EPS,OMEGA,X1,X2,Y1,Y2,Z1,Z2,DELX,DELY,DELZ,
     >                   A1,A2,A3,A4,A5,A6,A7,A8,B1,B2,B3,B4,B5,B6,
     >                   B7,B8,C1,C2,C3,C4,C5,C6,C7,C8,XSIO,ETAO,
     >                   ZTAO,XSIW,ETAW,ZTAW,F1,F2,F3,Z11,Z12,Z13,
     >                   Z21,Z22,Z23,Z31,Z32,Z33,DJAC,DELXSI,DELETA,
     >                   DELZTA,DIFMAX,DIF,DIFMAX1,DIF1
C
C     + + + INTRINSICS + + +
      INTRINSIC          DMAX1,DMIN1,DABS
C
C     + + + DATA INITIALIZATIONS + + +
      DATA NITER/100/, EPS/1.0D-6/, OMEGA/1.0D0/
C
C     + + + OUTPUT FORMATS + + +
 2000 FORMAT('1','* FAIL TO CONVERGE IN COMPUTING XSI, ETA, AND ZTA:',
     > /1X,'ITER =',I3,',   NITER =',I3,',   M =',I4/1X,
     > 'DIFMAX =',D15.6,',  DIFMAX1=',D15.6,',   EPS =',D15.6)
C
C     + + + END SPECIFICATIONS + + +
C
C
      X2 = -1.0D38
      X1 = 1.0D38
      Y2 = -1.0D38
      Y1 = 1.0D38
      Z2 = -1.0D38
      Z1 = 1.0D38
      DO 190 IQ = 1,8
        X2 = DMAX1(X2,X(IQ))
        Y2 = DMAX1(Y2,Y(IQ))
        Z2 = DMAX1(Z2,Z(IQ))
        X1 = DMIN1(X1,X(IQ))
        Y1 = DMIN1(Y1,Y(IQ))
        Z1 = DMIN1(Z1,Z(IQ))
  190 CONTINUE
      DELX = X2 - X1
      DELY = Y2 - Y1
      DELZ = Z2 - Z1
C
      A1 = (X(1) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) +
     >     X(8))*0.125D0
      A2 = (-X(1) + X(2) + X(3) - X(4) - X(5) + X(6) + X(7) -
     >     X(8))*0.125D0
      A3 = (-X(1) + X(4) - X(2) + X(3) - X(5) - X(6) + X(7) +
     >     X(8))*0.125D0
      A4 = (X(1) - X(4) - X(2) + X(3) + X(5) - X(6) + X(7) -
     >     X(8))*0.125D0
      A5 = (-X(1) - X(2) - X(3) - X(4) + X(5) + X(6) + X(7) +
     >     X(8))*0.125D0
      A6 = (X(1) + X(2) - X(3) - X(4) - X(5) - X(6) + X(7) +
     >     X(8))*0.125D0
      A7 = (X(1) - X(2) - X(3) + X(4) - X(5) + X(6) + X(7) -
     >     X(8))*0.125D0
      A8 = (-X(1) + X(2) - X(3) + X(4) + X(5) - X(6) + X(7) -
     >     X(8))*0.125D0
C
      B1 = (Y(1) + Y(2) + Y(3) + Y(4) + Y(5) + Y(6) + Y(7) +
     >     Y(8))*0.125D0
      B2 = (-Y(1) + Y(2) + Y(3) - Y(4) - Y(5) + Y(6) + Y(7) -
     >     Y(8))*0.125D0
      B3 = (-Y(1) + Y(4) - Y(2) + Y(3) - Y(5) - Y(6) + Y(7) +
     >     Y(8))*0.125D0
      B4 = (Y(1) - Y(4) - Y(2) + Y(3) + Y(5) - Y(6) + Y(7) -
     >     Y(8))*0.125D0
      B5 = (-Y(1) - Y(2) - Y(3) - Y(4) + Y(5) + Y(6) + Y(7) +
     >     Y(8))*0.125D0
      B6 = (Y(1) + Y(2) - Y(3) - Y(4) - Y(5) - Y(6) + Y(7) +
     >     Y(8))*0.125D0
      B7 = (Y(1) - Y(2) - Y(3) + Y(4) - Y(5) + Y(6) + Y(7) -
     >     Y(8))*0.125D0
      B8 = (-Y(1) + Y(2) - Y(3) + Y(4) + Y(5) - Y(6) + Y(7) -
     >     Y(8))*0.125D0
C
      C1 = (Z(1) + Z(2) + Z(3) + Z(4) + Z(5) + Z(6) + Z(7) +
     >     Z(8))*0.125D0
      C2 = (-Z(1) + Z(2) + Z(3) - Z(4) - Z(5) + Z(6) + Z(7) -
     >     Z(8))*0.125D0
      C3 = (-Z(1) + Z(4) - Z(2) + Z(3) - Z(5) - Z(6) + Z(7) +
     >     Z(8))*0.125D0
      C4 = (Z(1) - Z(4) - Z(2) + Z(3) + Z(5) - Z(6) + Z(7) -
     >     Z(8))*0.125D0
      C5 = (-Z(1) - Z(2) - Z(3) - Z(4) + Z(5) + Z(6) + Z(7) +
     >     Z(8))*0.125D0
      C6 = (Z(1) + Z(2) - Z(3) - Z(4) - Z(5) - Z(6) + Z(7) +
     >     Z(8))*0.125D0
      C7 = (Z(1) - Z(2) - Z(3) + Z(4) - Z(5) + Z(6) + Z(7) -
     >     Z(8))*0.125D0
      C8 = (-Z(1) + Z(2) - Z(3) + Z(4) + Z(5) - Z(6) + Z(7) -
     >     Z(8))*0.125D0
C
C ------- MAKE INITIAL GUESS OF XSI, ETA, AND ZTA
C
      XSIO = (2.0D0*XP - (X1 + X2))/DELX
      IF (XSIO .LT. -1.0D0) THEN
        XSIO = -1.0D0
      END IF
      IF (XSIO .GT. 1.0D0) THEN
        XSIO = 1.0D0
      END IF
C
      ETAO = (2.0D0*YP - (Y1 + Y2))/DELY
      IF (ETAO .LT. -1.0D0) THEN
        ETAO = -1.0D0
      END IF
      IF (ETAO .GT. 1.0D0) THEN
        ETAO = 1.0D0
      END IF
C
      ZTAO = (2.0D0*ZP - (Z1 + Z2))/DELZ
      IF (ZTAO .LT. -1.0D0) THEN
        ZTAO = -1.0D0
      END IF
      IF (ZTAO .GT. 1.0D0) THEN
        ZTAO = 1.0D0
      END IF
C
      XSIW = XSIO
      XSI  = XSIO
      ETAW = ETAO
      ETA  = ETAO
      ZTAW = ZTAO
      ZTA  = ZTAO
C
C ------- START NEWTON RALSON ITERATION LOOP
C
      DONFG = 0
      ITER  = 0
  590 CONTINUE
        ITER = ITER + 1
C
C ------ COMPUTE RIGHT HAND SIDE AND THE JACOBIAN
C
        F1 = XP - A1 - A2*XSIW - A3*ETAW - A4*XSIW*ETAW - A5*ZTAW -
     >       A6*ETAW*ZTAW - A7*ZTAW*XSIW - A8*XSIW*ETAW*ZTAW
        F2 = YP - B1 - B2*XSIW - B3*ETAW - B4*XSIW*ETAW - B5*ZTAW -
     >       B6*ETAW*ZTAW - B7*ZTAW*XSIW - B8*XSIW*ETAW*ZTAW
        F3 = ZP - C1 - C2*XSIW - C3*ETAW - C4*XSIW*ETAW - C5*ZTAW -
     >       C6*ETAW*ZTAW - C7*ZTAW*XSIW - C8*XSIW*ETAW*ZTAW
C
        Z11 = -A2 - A4*ETAW - A7*ZTAW - A8*ETAW*ZTAW
        Z12 = -A3 - A4*XSIW - A6*ZTAW - A8*ZTAW*XSIW
        Z13 = -A5 - A6*ETAW - A7*XSIW - A8*XSIW*ETAW
        Z21 = -B2 - B4*ETAW - B7*ZTAW - B8*ETAW*ZTAW
        Z22 = -B3 - B4*XSIW - B6*ZTAW - B8*ZTAW*XSIW
        Z23 = -B5 - B6*ETAW - B7*XSIW - B8*XSIW*ETAW
        Z31 = -C2 - C4*ETAW - C7*ZTAW - C8*ETAW*ZTAW
        Z32 = -C3 - C4*XSIW - C6*ZTAW - C8*ZTAW*XSIW
        Z33 = -C5 - C6*ETAW - C7*XSIW - C8*XSIW*ETAW
C
C ------- SOLVE FOR DELXSI, DELETA, AND DELZT
C
        DJAC   = Z11*(Z22*Z33 - Z23*Z32) - Z21*(Z12*Z33 - Z32*Z13) +
     >           Z31*(Z12*Z23 - Z22*Z13)
        DELXSI = (F1*(Z22*Z33 - Z32*Z23) - F2*(Z12*Z33 - Z32*Z13) +
     >           F3*(Z12*Z23 - Z22*Z13))/DJAC
        DELETA = (-F1*(Z21*Z33 - Z31*Z23) + F2*(Z11*Z33 - Z31*Z13) -
     >           F3*(Z11*Z23 - Z21*Z13))/DJAC
        DELZTA = (F1*(Z21*Z32 - Z31*Z22) - F2*(Z11*Z32 - Z31*Z12) +
     >         F3*(Z11*Z22 - Z21*Z12))/DJAC
C
C ------- COMPUTE FOR NEW XSI, ETA, AND ZTA
C
        XSI = XSIO - DELXSI
        ETA = ETAO - DELETA
        ZTA = ZTAO - DELZTA
C
C ------- TEST CONVERGENCE
C
        DIFMAX = 0.0D0
        DIFMAX1 = 0.0D0
        IF (XSIW .NE. 0.0) THEN
          DIF    = DABS((XSI - XSIW)/XSIW)
          DIFMAX = DMAX1(DIF,DIFMAX)
          DIF1   = DABS(XSI - XSIW)
          DIFMAX1= DMAX1(DIF1,DIFMAX1)
        END IF
        IF (ETAW .NE. 0.0) THEN
          DIF    = DABS((ETA - ETAW)/ETAW)
          DIFMAX = DMAX1(DIF,DIFMAX)
          DIF1   = DABS(ETA - ETAW)
          DIFMAX1= DMAX1(DIF1,DIFMAX1)
        END IF
        IF (ZTAW .NE. 0.0) THEN
          DIF    = DABS((ZTA - ZTAW)/ZTAW)
          DIFMAX = DMAX1(DIF,DIFMAX)
          DIF1   = DABS(ZTA - ZTAW)
          DIFMAX1= DMAX1(DIF1,DIFMAX1)
        END IF
        IF (DIFMAX .LT. EPS .AND. ITER .GT. 1) THEN
          DONFG = 1
        END IF
C
C ------- TAKE A NEW GUESS FOR XSI, ETA, AND ZTA
C
        IF (DONFG .EQ. 0) THEN
          IF (XSI .LT. -1.0D0) THEN
            XSI = -1.0D0
          END IF
          IF (XSI .GT. 1.0D0) THEN
            XSI = 1.0D0
          END IF
          IF (ETA .LT. -1.0D0) THEN
            ETA = -1.0D0
          END IF
          IF (ETA .GT. 1.0D0) THEN
            ETA = 1.0D0
          END IF
          IF (ZTA .LT. -1.0D0) THEN
            ZTA = -1.0D0
          END IF
          IF (ZTA .GT. 1.0D0) THEN
            ZTA = 1.0D0
          END IF
          XSIW = OMEGA*XSI + (1.0D0 - OMEGA)*XSIO
          ETAW = OMEGA*ETA + (1.0D0 - OMEGA)*ETAO
          ZTAW = OMEGA*ZTA + (1.0D0 - OMEGA)*ZTAO
C
C ------- UPDATE XSIO, ETAO, AND ZTAO
C
          XSIO = XSI
          ETAO = ETA
          ZTAO = ZTA
        END IF
      IF (DONFG .EQ. 0 .AND. ITER .LT. NITER) THEN
        GO TO 590
      END IF
      IF (DONFG .EQ. 0 .AND. ITER .GE. NITER) THEN
C
C ------- CONVERGENCE FAILS
C
        WRITE(LUOUT,2000) ITER,NITER,M,DIFMAX,DIFMAX1,EPS
        IF(DIFMAX1 .GT. EPS) STOP
      END IF
C
C ------- CONVERGENT SOLUTION FOR XSI, ETA, AND ZTA HAS BEEN ACHIEVED.
C
      RETURN
      END
