      real function afish(nchem, cf, molwt, kf, acw)
c
c update: wed 15:41 27-mar-1991.
c
c this function calculates the chemical activity of a mixture
c in the aqueous phase of whole fish
c
c notes:
c . changes in the computation of activity (option "tobserved") should be
c   propagated to the module "Afish", "La50", "Owpezall"
c
c variables:
c -ai  = activity of chemical in solvent i,
c      = aci * xi.
c -aci = activity coefficient of chemical in solvent i.
c -xi  = mole fraction concentration of chemical in solvent i.
c -xi  = mi * nui.
c -mi  = molar concentration of chemical in solvent i,
c -nui = molar volume of solvent i (liter / mole).
c
c input
c     nchem, kf, cf, Acw, Molwt
c
c output
c     Afish
c
c declarations of subroutine's formal parameters
c
      include 'water.par'
c;;
      integer nchem
      real kf( * ), cf( * ), acw( * ), molwt( * )
c
      integer jchem
      real ca, csum
c
      csum = 0.0e+00
      do jchem = 1, nchem
c
c calculate aqueous concentration of jth chemical in ppm = mg/l
c
         ca = cf(jchem) / kf(jchem)
c
c convert ca to molarity
c
         ca = ca / (1000.0 * molwt(jchem))
c
c convert ca to mole fraction
c
         ca = ca * nuw
c
c finally convert ca to activity
c
         csum = csum + acw(jchem) * ca
      enddo
      afish = csum
c
      return
      end
      subroutine agesort(jspecies, nage, edadp)
c
c update: 17:24 fri 4-mar-1994.
c "sort" arrays by age, j-th species
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'fish.par'
      include 'chem.par'
      include 'fish.def'
c
      integer jspecies, nage, edadp( * )
      integer jage
c
      nage = xmaximum_age(jspecies)
      do jage = 1, nage
         edadp(qq_fish_age(jage, jspecies)) = jage
      enddo
c
      return
      end
      block data argblk
c
c update:   19:13 thu 4-mar-1993.
c purpose:
c - set the default value of the "ask" parameter of Getarg
c
      logical doprompt
      common /gargl/ doprompt
c
      data doprompt /.true./
c
      end
      subroutine aux1(issue_formfeed, nyear)
c
c update: 17:24 fri 4-mar-1994.
c print fish pointer info;
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'page.par'
      include 'chem.par'
      include 'fish.par'
      include 'idfiles.def'
      include 'fish.def'
      include 'globpar.def'
c
      integer nyear, nnn, xslen, addlin, xquery
      integer edadp(maxage), jspecies, nage, jage, agep
      logical issue_formfeed
      external xslen
c
 9110 format (///,'## after module Webset ; year: ',i3)
 9120 format ('   ',a30,2x,a14,2x,a4,2x,a4)
 9130 format ('   ',a30,2x,1pg14.6,2x,i4,2x,i4)
 9140 format (//,1x,a7,:,3x,a)
 9150 format (1x,i4,3x,:,3x,97i4)
c
      addlin = 4 + 1 + 1
      if (issue_formfeed) then
         call opage(tinquire, ' ', 0, -addlin, xquery)
      else
         call opage(tinquire, ' ', 0, addlin, xquery)
      endif
      write (jout, 9110) nyear  !123456789=1234            
      write (jout, 9120) '  species name  ', '  initial wt  ', 'jage', 
     &   'agep'
      write (jout, 9120) '----------------', '--------------', '----', 
     &   '----'
c
      do jspecies = 1, gnspecies
         do jage = 1, xmaximum_age(jspecies)
            agep = qq_fish_age(jage, jspecies)
            nnn = xslen(spplab(jspecies))
            call opage(tinquire, ' ', 0, 1, xquery)
            write (jout, 9130) spplab(jspecies)(1:nnn), 
     &         vv_iniwt(agep, jspecies), jage, agep
         enddo
      enddo
c
      call opage(tinquire, ' ', 0, 3, xquery)
      write (jout, 9140) 'species', ' edadp ...'
      do jspecies = 1, gnspecies
         call agesort(jspecies, nage, edadp)
         call opage(tinquire, ' ', 0, 1, xquery)
         write (jout, 9150) jspecies, (edadp(jage), jage = 1, nage)
      enddo
      call opage(tlines, ' ', 0, 3, xquery)
c
      return
      end
      subroutine aux3()
c
c update: 17:25 fri 4-mar-1994.
c print diet arrays.
c;;
      include 'xglobal.par'
      include 'fish.par'
      include 'chem.par'
      include 'simul.par'
      include 'page.par'
      include 'idfiles.def'
      include 'globpar.def'
      include 'diet.def'
      include 'fish.def'
c
      character*(26) alphabet
      integer nk1, nk2, jspecies, xslen, krange, ii, addlin, xquery
      external xslen
c
      data alphabet /'abcdefghijklmnopqrstuvwxyz'/
c
 9110 format (5x,'*** DIET stuff:')
 9120 format (10x,'Gnspecies: ',i3)
 9130 format (10x,a1,2x,a30,2x,a15)
 9140 format (10x,i1,2x,a30,2x,a15)
c
c all info fits in a page
c
      addlin = 5 + gnspecies + 2 + gnspecies + 3
      do jspecies = 1, gnspecies
         addlin = addlin + 6 + range_numof(jspecies)
      enddo
      call opage(tinquire, ' ', 0, -addlin, xquery)
c
      write (jout, 9110)
      write (jout, 9120) gnspecies
      write (jout, *)
      write (jout, 9130) 'j', 'Species', 'Dietlabels'
      write (jout, 9130) '-', '-------', '----------'
c
      do jspecies = 1, gnspecies
         nk1 = xslen(spplab(jspecies))
         nk2 = xslen(dietlabels(jspecies))
         write (jout, 9140) jspecies, spplab(jspecies)(1:nk1), 
     &      dietlabels(jspecies)(1:nk2)
      enddo
c
      write (jout, *)
      write (jout, *)
c
 9150 format (10x,'Spplab(',i1,') = ',a)
 9160 format (15x,'Range by ',a)
 9170 format (15x,'Number of Ranges = ',i2)
c
 9180 format (10x,a,'. ',a)
 9190 format (15x,a2,2x,a10,1x,a10,1x,99(a4,1x))
 9200 format (15x,i2,2x,1pg10.3,1x,1pg10.3,1x,99(i3,'%',1x))
c
      do jspecies = 1, gnspecies
         nk1 = xslen(spplab(jspecies))
         write (jout, 9180) alphabet(jspecies:jspecies), 
     &      spplab(jspecies)(1:nk1)
      enddo
      jspecies = gnspecies + 1
      write (jout, 9180) alphabet(jspecies:jspecies), 'plankton'
      jspecies = jspecies + 1
      write (jout, 9180) alphabet(jspecies:jspecies), 'benthos'
      jspecies = jspecies + 1
      write (jout, 9180) alphabet(jspecies:jspecies), 'cfish'
      write (jout, *)
c
      do jspecies = 1, gnspecies
         nk1 = xslen(spplab(jspecies))
         write (jout, *)
         write (jout, 9150) jspecies, spplab(jspecies)(1:nk1)
         if (range_type(jspecies) .eq. tage) then
            write (jout, 9160) 'age [years]'
         elseif (range_type(jspecies) .eq. tweight) then
            write (jout, 9160) 'weight [grams]'
         elseif (range_type(jspecies) .eq. tweight) then
            write (jout, 9160) 'length [cm]'
         endif
         write (jout, 9170) range_numof(jspecies)
c
         write (jout, 9190) ' k', '   Lowb   ', '   Uppb   ', (
     &      alphabet(ii:ii), ii = 1, gnspecies + 3)
         write (jout, 9190) '--', '----------', '----------', ('----', 
     &      ii = 1, gnspecies + 3)
         do krange = 1, range_numof(jspecies)
            write (jout, 9200) krange, range_lowb(krange, jspecies), 
     &         range_uppb(krange, jspecies), (
     &         nint(100.0 * fdiet(ii, krange, jspecies)), ii = 1, 
     &         gnspecies), nint(100.0 * 
     &         fdiet(pplankton, krange, jspecies)), 
     &         nint(100.0 * fdiet(pbenthos, krange, jspecies)), 
     &         nint(100.0 * fdiet(pcfish, krange, jspecies))
         enddo
      enddo
c
      return
      end
      subroutine aux4(jout, xlab)
c
c update:   17:32 fri 4-mar-1994.
c test "inquire" on unit "Jout"
c;;
      include 'xglobal.par'
c
      integer jout
      character*( * ) xlab
c
c
      return
      end
      block data blkfgets
c
c update: 12:42 fri 9-sep-1994.
c
c IMPORTANT
c . all lists initialized through the "blockdata" will be binary-searched,
c   therefore:
c   . "cprefix" must be sorted in ascending order;
c   . "untnam"  must be sorted in ascending order;
c   . "Comname" must be sorted in ascending order;
c   . "Fpname" must be sorted in ascending order;
c . generate the data statements for "Comname" and "Fpname", and the computed
c   "go to" in "Setvar" using the program *xgoto.f* with the data file
c   *xgoto.gto*
c;;
      include 'xglobal.par'
      include 'xio.inc'
      include 'chem.par'
      include 'dbphysio.par'
      include 'errors.par'
      include 'expos.par'
      include 'fish.par'
      include 'habitat.par'
      include 'helpid.par'
      include 'inkey.par'
      include 'menu.par'
      include 'noval.par'
      include 'numbers.par'
      include 'ode.par'
      include 'page.par'
      include 'phylum.par'
      include 'physio.par'
      include 'plots.par'
      include 'prompt.par'
      include 'setcodes.par'
      include 'simul.par'
      include 'srch.par'
      include 'strings.par'
      include 'token.par'
      include 'water.par'
c
      include 'blkset.def'
      include 'chars.def'
      include 'chemp.def'
      include 'chems.def'
      include 'dbrec.def'
      include 'diet.def'
      include 'echo.def'
      include 'examsrec.def'
      include 'expos.def'
      include 'xinclude.inc'
      include 'fish.def'
      include 'fisiorec.def'
      include 'fluxes.def'
      include 'globpar.def'
      include 'h2ovisc.def'
      include 'habitat.def'
      include 'heap.def'
      include 'hits.def'
      include 'holling.def'
      include 'idfiles.def'
      include 'idsdb.def'
      include 'lab.def'
      include 'obsdata.def'
      include 'ode.def'
      include 'odevar.def'
      include 'options.def'
      include 'page.def'
      include 'plottmp.def'
      include 'prompt.def'
      include 'pspoc.def'
      include 'show.def'
      include 'stealth.def'
      include 'time.def'
      include 'token.def'
      include 'unitdb.def'
      include 'units.def'
      include 'vdefined.def'
      include 'version.def'
      include 'work.def'
c
      include 'fv3vars.h'
c;;
      data x_version_date /'12-sep-1994'/
c
      data xstealth /.true./
c
      include 'unitdb.blk'      ! load units data             
      include 'show.blk'        ! load show-able stuff        
c
c - generate the data statements for "Comname" and "Fpname", and the computed
c   "go to" in "Setvar" using the program *xgoto.f* with the data file
c   *xgoto.dat*
c
c - define command strings and the appropriate place of the associated
c   variables in the "data structure" .
c
c notes:
c - IMPORTANT: "Comname" must be sorted in ascending order;
c - read "IMPORTANT"  section above;
c - Comcode(n) == -1 ==> not used; this code is generally used for
c   commands that need individual processing, e.g., "/cwater",
c   "/temperature", "/fishpar", etc.
c - note that *Pka* is disabled ("~Pka") - 13:03:04.01 april 6, 1989.
c - parameter "maxcom" *must* be set to the exact number of commands,
c   e.g., "maxcom=500" and leaving *Comname(n) == ' '* for some n is not
c   valid; problems will occur later since we are using a binary search
c   to look up the entry.
c;;
      include 'idsdb.blk'
c
c set constants used to calculate physiological rates
c
c assumptions:
c -specific dynamic action (sda) for fish is approx. 17% of their
c  assimilation (see stewart et al. 1983.can.j.fish.aquat.sci.40:681-;
c  stewart and binkowski 1986.trans.amer.fish.soc.115:643-) or 16-19% of their
c  ingestion (ware 1975. j.fish.res.bd.can. 32:33-41)
c -carbon/nitrogen ratio for fish is assumed to be 4
c
c Cn:          carbon/nitrogen ratio
c Nh3n:        ammonium/nitrogen ratio; (17 g mol^-1) / (14 g mol^-1)
c Sigma:       fraction of ingestion respired as sda
c
      data cn /4.0/
      data nh3n /1.214286/
      data sigma /0.175/
c
c fish function definitions
c
c Fpname: function_name
c Fparg: number of arguments required by the function
c Fppos: starting position
c
c tref is explicitly input for each command that requires it.
c;;
      include 'fisiorec.blk'    ! load v-physio stuff         
c;;
c
c variables to read from database; the format of the Fgets database is:
c
c database corresponds to "Vv_pval" format
c ###.01 species/family/habitat/ecological_function
c ###.02 reference
c ###.03 s1gill   s2gill   rho1      rho2    laml1    laml2
c ###.04 pl1      pl2      pa1       pa2
c ###.05 lenwt1   lenwt2   pred1     pred2
c ###.06 cmax1    cmax2    cmaxq10   cmaxt
c ###.07 cvol1    cvol2    cvolq10   cvolt
c ###.08 fsat1    fsat2    fsatq10   fsatt
c ###.09 tsat1    tsat2    tsatq10   tsatt
c ###.10 assxeff  evac1    evac2     evac3   evacq10  evact
c ###.11 rq       o2x1     o2x2      o2q10   o2t
c ###.12 gamma1   gamma2   gammaq10  gammat
c ###.13 wty1
c
c make sure parameters are given sequential numbers, i.e.,
c  vs1gill = 1, vs2gill = 2, vrho1 = 3, ...
c
c records '01' and '02' will be decoded individually;
c records '03'-'13' with a loop;
c
      data dbstart(1) /0/, dbvars(1) /0/, dbxrecxid(1) /'01'/
      data dbstart(2) /0/, dbvars(2) /0/, dbxrecxid(2) /'02'/
      data dbstart(3) /vsgill1/, dbvars(3) /6/, dbxrecxid(3) /'03'/
      data dbstart(4) /vpl1/, dbvars(4) /4/, dbxrecxid(4) /'04'/
      data dbstart(5) /vlenwt1/, dbvars(5) /4/, dbxrecxid(5) /'05'/
      data dbstart(6) /vcmax1/, dbvars(6) /4/, dbxrecxid(6) /'06'/
      data dbstart(7) /vcvol1/, dbvars(7) /4/, dbxrecxid(7) /'07'/
      data dbstart(8) /vfsat1/, dbvars(8) /4/, dbxrecxid(8) /'08'/
      data dbstart(9) /vtsat1/, dbvars(9) /4/, dbxrecxid(9) /'09'/
      data dbstart(10) /vassxeff/, dbvars(10) /6/, dbxrecxid(10) /'10'/
      data dbstart(11) /vrq/, dbvars(11) /5/, dbxrecxid(11) /'11'/
      data dbstart(12) /vgamma1/, dbvars(12) /4/, dbxrecxid(12) /'12'/
      data dbstart(13) /vwty1/, dbvars(13) /1/, dbxrecxid(13) /'13'/
c;;
c erase physiological parameters ? default: keep user parameters;
c
      integer kb0
      parameter (kb0 = maxfpar * maxage * maxspecies)
      data vv_ptyp /kb0 * tuser/
c
c set provisional file names and unit numbers:
c
      data pgmfil /'Fgets'/     ! default file name              
      data dbpath /' '/
      data opath /' '/
      data dbfil /' '/
      data infil /' '/
      data outfil /' '/
      data errfil /' '/
      data ucffil /' '/
      data audfil /' '/
      data hlbfil /' '/
      data tsfil /' '/
      data cwfil /' '/
      data planktonfil /' '/
      data benthosfil /' '/
      data cfishfil /' '/
c
      data stdin /5/
      data stdout /6/
ccc      data stderr     / 7 /
      data jdb /0/
      data jin /0/
      data jerr /0/, errused /.false./
      data jout /0/
      data juif /0/
      data jts /0/
      data jaud /0/
      data jhlb /0/
      data jcw /0/
      data jplankton /0/
      data jbenthos /0/
      data jcfish /0/
c
c hard-code data option
c
      data data_mean /.true./
      data data_sd /.false./
c
c!~14!      data Xecho / .true. /
      data xecho /.false./
c
c header page
c
      data page_header /' '/
      data nheader /0/
      data thispag /0/
      data pagelen /66/
      data thislin /66/ ! set to Pagelen -- to eject;       
      data lines_in_header /inoval/
      data linesperscreen /23/
c
      data block_data_loaded /'ok'/     ! block data loaded? test for linker;
c;;
      end
      subroutine bnd1(zz01, nz01, zmax, zmin)
c
c BND1.spg  processed by SPAG 3.14A  at 14:40 on 26 Oct 1992
c
      integer nz01
      real zz01( * )
      real zmax, zmin
c
      real qmax, qmin, zjj
      integer jj
c
      qmax = zz01(1)
      qmin = qmax
      do jj = 1, nz01
         zjj = zz01(jj)
         qmin = amin1(qmin, zjj)
         qmax = amax1(qmax, zjj)
      enddo
c
      zmax = qmax
      zmin = qmin
c
      return
      end
      subroutine chaindrv(nerror)
c
c update: 11:22 fri 9-sep-1994.
c drive constant food_chain predator-prey mode;
c
c tfood_chain mode: constant exposure *always* ;
c two scenarios:
c a. one predator, feeding on one prey, feeding on [plankton | benthos | cfish];
c    the prey grows until it attains the length (or wt) required by the
c    predator; notice that the predator and prey times may become asynchronous.
c
c b. one predator, feeding on [plankton | benthos | cfish];
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'errors.par'
      include 'fish.par'
      include 'habitat.par'
      include 'numbers.par'
      include 'ode.par'
      include 'phylum.par'
      include 'physio.par'
      include 'plots.par'
      include 'simul.par'
c
      include 'chemp.def'
      include 'expos.def'
      include 'errors.def'
      include 'fish.def'
      include 'fluxes.def'
      include 'globpar.def'
      include 'habitat.def'
      include 'idfiles.def'
      include 'lab.def'
      include 'ode.def'
      include 'odevar.def'
      include 'options.def'
      include 'time.def'
      include 'work.def'
c
      integer nerror
c
      integer jage, jspecies, jchem
      real len_prey, tbeg, tfin, tkbeg, tkfin, tbreak
      logical found_prey, done, noprey
c
c euler variables
c
      logical stephalt, trne
      real tmid, astep, almost_one, arel_tol, tbound, tstep, qeuler
      real t0, t1
      integer jtimes, ntimes, nneg, newstep
      external trne
c
c errmsg1:  truth of "error message 1 not issued" ;
c           issue the message only once;
c           the message will be issued if the integration step size is
c           too large  --  detected when any of the integration variables
c           becomes negative.
c
      logical errmsg1
      save errmsg1
      data errmsg1 /.true./
c
 9110 format (' ?? Chaindrv: integration step size too large; ',/,
     &   '     suggestion: increase "nstep" to ',i4,/,
     &   '                 and repeat the simulation.')
c
      call initchem(simul_beg, simul_end, hstep)
      nerror = tnoerror
      time_beg = simul_beg
      time_end = simul_end
      prey_maxtime = simul_beg + 2.0 * (simul_end - simul_beg)
      tbeg = time_beg
      tfin = tbeg + hstep
      jage = 1  ! for both predator and prey  
c
      call envget(tbeg)
c
c *************** initialize simulation/print/plotting parameters *************
c wt-dbdtgf equations
c
      call initpez(simul_mode, gnchem, xcelsius, sigma, nh3n, cn, 
     &   xplankton_standing_stock, vv_inicf(1, jage, fc_predatorp), 
     &   simul_beg, simul_end, vv_growth_model(jage, fc_predatorp), kl,
     &   koc, kow, acw, molwt, lc50func(1, fc_predatorp), 
     &   lc50par(1, 1, fc_predatorp), vv_plfunc(jage, fc_predatorp), 
     &   vv_iniwt(jage, fc_predatorp), vv_pval(1, jage, fc_predatorp), 
     &   qq_wt(1, jage, fc_predatorp), qq_bf(1, jage, fc_predatorp), 
     &   qq_jgilup(1, jage, fc_predatorp), 
     &   qq_jgilex(1, jage, fc_predatorp), 
     &   qq_jgutup(1, jage, fc_predatorp), 
     &   qq_jgutex(1, jage, fc_predatorp), 
     &   qq_iterno(jage, fc_predatorp), qq_iprint(jage, fc_predatorp), 
     &   hstep, qq_nxy(jage, fc_predatorp), 
     &   qq_kf(1, jage, fc_predatorp), qq_lenfish(jage, fc_predatorp), 
     &   dtfish(jage, fc_predatorp), qq_igamma(jage, fc_predatorp), 
     &   qq_iingest(jage, fc_predatorp), qq_iassim(jage, fc_predatorp),
     &   qq_iegest(jage, fc_predatorp), qq_iexcret(jage, fc_predatorp),
     &   qq_irespir(jage, fc_predatorp), qq_isda(jage, fc_predatorp), 
     &   cfmean(1, jage, fc_predatorp), cpmean(1, jage, fc_predatorp), 
     &   fish_la50(fc_predatorp), qq_death_day(jage, fc_predatorp), 
     &   qq_fish_alive(jage, fc_predatorp))
c
      noprey = .true.   ! if Fc_preyt == [tplankton | tbenthos | TCfish]
      if (fc_preyt .eq. tcfish) then
         call setcfish(gnchem, ecolab(fc_predatorp), cfish_pl, kow, kl,
     &      cfish_kf)
      elseif (fc_preyt .eq. tspecies) then
         noprey = .false.
         call initpez(simul_mode, gnchem, xcelsius, sigma, nh3n, cn, 
     &      xplankton_standing_stock, vv_inicf(1, jage, fc_preyp), 
     &      simul_beg, prey_maxtime, vv_growth_model(jage, fc_preyp), 
     &      kl, koc, kow, acw, molwt, lc50func(1, fc_preyp), 
     &      lc50par(1, 1, fc_preyp), vv_plfunc(jage, fc_preyp), 
     &      vv_iniwt(jage, fc_preyp), vv_pval(1, jage, fc_preyp), 
     &      qq_wt(1, jage, fc_preyp), qq_bf(1, jage, fc_preyp), 
     &      qq_jgilup(1, jage, fc_preyp), qq_jgilex(1, jage, fc_preyp),
     &      qq_jgutup(1, jage, fc_preyp), qq_jgutex(1, jage, fc_preyp),
     &      qq_iterno(jage, fc_preyp), qq_iprint(jage, fc_preyp), hstep,
     &      qq_nxy(jage, fc_preyp), qq_kf(1, jage, fc_preyp), 
     &      qq_lenfish(jage, fc_preyp), dtfish(jage, fc_preyp), 
     &      qq_igamma(jage, fc_preyp), qq_iingest(jage, fc_preyp), 
     &      qq_iassim(jage, fc_preyp), qq_iegest(jage, fc_preyp), 
     &      qq_iexcret(jage, fc_preyp), qq_irespir(jage, fc_preyp), 
     &      qq_isda(jage, fc_preyp), cfmean(1, jage, fc_preyp), 
     &      cpmean(1, jage, fc_preyp), fish_la50(fc_preyp), 
     &      qq_death_day(jage, fc_preyp), qq_fish_alive(jage, fc_preyp))
         if (fc_prey_foodt .eq. tcfish) then
            call setcfish(gnchem, ecolab(fc_preyp), cfish_pl, kow, kl, 
     &         cfish_kf)
         endif
      endif
c
      tinc = one
      call ksave1(zero, tbeg, .true.)
      do jspecies = 1, gnspecies
         qq_new_day(jage, jspecies) = tbeg
         call ksave(jage, jspecies, zero, tbeg, .true.)
      enddo
c
c *************** prey *********************
c predator growth will drive the simulation;
c first, grow the prey to prescribed length;
c
      stephalt = .false.
      nerror = tnoerror
      tinc = one
      tkbeg = tbeg
      tkfin = tfin
      almost_one = one - mach_eps
c
      call uotty('## food_chain', -1)
  110 continue
      if (noprey) then
         found_prey = .true.
         go to 140
      endif
c
c find desired prey length for current size predator
c
      len_prey = vv_pval(vpred1, jage, fc_predatorp) + 
     &   vv_pval(vpred2, jage, fc_predatorp) * 
     &   qq_lenfish(jage, fc_predatorp)
c
c grow prey to desired length
c
      found_prey = .false.
      done = (tkbeg .ge. prey_maxtime)
  120 continue
      if ( .not. done) then
         if (qq_fish_alive(jage, fc_preyp)) then
c
            t0 = tkbeg
            t1 = tkfin
            call kstep(t0, t1, t0, t1, nerror)
            if (nerror .ne. tnoerror) go to 160
c
            astep = min(abs(hstep), abs(t1 - t0))
            ntimes = int(((t1 - t0 + hstep) / hstep) + almost_one)
c
            if (trne(t1, zero)) then
               arel_tol = abs(t1 * mach_eps)
            else
               arel_tol = abs(mach_eps)
            endif
c
            tbound = t1 - arel_tol
            tstep = astep
            tmid = t0
c
c at the start of the loop: tmid = t0 + Float(jtimes-1);
c the purpose of the loop is to ensure a finite number of steps;
c
            do jtimes = 1, ntimes
               call chainode(jage, fc_preyp, tmid, nerror)
               if (nerror .ne. tnoerror) go to 160
c
c take euler step:  y(tmid + tstep) = y(tmid)  +  tstep * y'(tmid)
c
c if "tmid + tstep" can overshoot "t1", or it is within machine precision
c from "t1", adjust the step size;
c
               if (tbound .le. (tmid + tstep)) tstep = t1 - tmid
               tmid = tmid + tstep
c
c make sure values are non-negative; keep a count of negative values
c
               nneg = 0
               qeuler = qq_wt(1, jage, fc_preyp) + tstep * 
     &            qq_dwdt(1, jage, fc_preyp)
               if (qeuler .lt. zero) then
                  nneg = nneg + 1
                  qeuler = zero
               endif
               qq_wt(1, jage, fc_preyp) = qeuler
c
               qeuler = qq_wt(2, jage, fc_preyp) + tstep * 
     &            qq_dwdt(2, jage, fc_preyp)
               if (qeuler .lt. zero) then
                  nneg = nneg + 1
                  qeuler = zero
               endif
               qq_wt(2, jage, fc_preyp) = qeuler
c
               do jchem = 1, gnchem
                  qeuler = qq_bf(jchem, jage, fc_preyp) + tstep * 
     &               qq_dbfdt(jchem, jage, fc_preyp)
                  if (qeuler .lt. zero) then
                     nneg = nneg + 1
                     qeuler = zero
                  endif
                  qq_bf(jchem, jage, fc_preyp) = qeuler
               enddo
c
c negative values detected ?
c
               if (nneg .gt. 0) then
                  if (errmsg1) then
                     errmsg1 = .false.
                     newstep = nint((8.0 + astep) / astep)
                     call uotty(' ', 1)
                     write (stdout, 9110) newstep
                     write (stdout, *)
                     stephalt = .true.
                     go to 180
                  endif
               endif
c
c save stuff: Fc_preyp
c
               call ksave(jage, fc_preyp, tstep, tmid, .false.)
c
c prey dead ? - exit
c
               if ( .not. qq_fish_alive(jage, fc_preyp)) go to 130
c
c have we reached t1 ?
c
               done = (abs(tmid - t1) .le. arel_tol)
               if (done) go to 130
            enddo
         endif
c
c here implies: finished loop or prey dead
c
  130    continue
         call ksave1(tstep, tmid, .false.)
         if (qq_fish_alive(jage, fc_preyp)) then
            tkbeg = t1
            tkfin = tkbeg + hstep
            found_prey = (qq_lenfish(jage, fc_preyp) .ge. len_prey)
            if ( .not. found_prey) then
               done = (tkbeg .ge. prey_maxtime)
            else
               done = .true.
            endif
         else
            done = .true.
         endif
         go to 120
      endif
c
      if ( .not. found_prey) then
         tbreak = tbeg
         go to 170
      endif
c
c *************** predator *********************
c
  140 continue
      t0 = tbeg
      t1 = tfin
      if (qq_fish_alive(jage, fc_predatorp)) then
         call kstep(t0, t1, t0, t1, nerror)
         if (nerror .ne. tnoerror) go to 160
c
         astep = min(abs(hstep), abs(t1 - t0))
         ntimes = int(((t1 - t0 + hstep) / hstep) + almost_one)
c
         if (trne(t1, zero)) then
            arel_tol = abs(t1 * mach_eps)
         else
            arel_tol = abs(mach_eps)
         endif
c
         tbound = t1 - arel_tol
         tstep = astep
         tmid = t0
c
c at the start of the loop: tmid = t0 + Float(jtimes-1);
c the purpose of the loop is to ensure a finite number of steps;
c
         do jtimes = 1, ntimes
            call chainode(jage, fc_predatorp, tmid, nerror)
            if (nerror .ne. tnoerror) go to 160
c
c take euler step:  y(tmid + tstep) = y(tmid)  +  tstep * y'(tmid)
c
c if "tmid + tstep" can overshoot "t1", or it is within machine precision
c from "t1", adjust the step size;
c
            if (tbound .le. (tmid + tstep)) tstep = t1 - tmid
            tmid = tmid + tstep
c
c make sure values are non-negative; keep a count of negative values
c
            nneg = 0
            qeuler = qq_wt(1, jage, fc_predatorp) + tstep * 
     &         qq_dwdt(1, jage, fc_predatorp)
            if (qeuler .lt. zero) then
               nneg = nneg + 1
               qeuler = zero
            endif
            qq_wt(1, jage, fc_predatorp) = qeuler
c
            qeuler = qq_wt(2, jage, fc_predatorp) + tstep * 
     &         qq_dwdt(2, jage, fc_predatorp)
            if (qeuler .lt. zero) then
               nneg = nneg + 1
               qeuler = zero
            endif
            qq_wt(2, jage, fc_predatorp) = qeuler
c
            do jchem = 1, gnchem
               qeuler = qq_bf(jchem, jage, fc_predatorp) + tstep * 
     &            qq_dbfdt(jchem, jage, fc_predatorp)
               if (qeuler .lt. zero) then
                  nneg = nneg + 1
                  qeuler = zero
               endif
               qq_bf(jchem, jage, fc_predatorp) = qeuler
            enddo
c
c negative values detected ?
c
            if (nneg .gt. 0) then
               if (errmsg1) then
                  errmsg1 = .false.
                  newstep = nint((8.0 + astep) / astep)
                  call uotty(' ', 1)
                  write (stdout, 9110) newstep
                  write (stdout, *) newstep
                  stephalt = .true.
                  go to 180
               endif
            endif
c
c save stuff: Fc_predatorp
c
            call ksave(jage, fc_predatorp, tstep, tmid, .false.)
c
c predator dead ? - exit
c
            if ( .not. qq_fish_alive(jage, fc_predatorp)) go to 150
c
c have we reached t1 ?
c
            done = (abs(tmid - t1) .le. arel_tol)
            if (done) go to 150
         enddo
      endif
c
  150 continue
      tbeg = t1
      tfin = tbeg + hstep
c
      if (qq_fish_alive(jage, fc_predatorp)) then
         done = (tbeg .ge. time_end)
      else
         done = .true.
      endif
      if ( .not. done) go to 110
c
 9120 format (1x,'?? ',a,' died at day ',1pg10.3)
c
  160 continue
  170 continue
      if ( .not. qq_fish_alive(jage, fc_predatorp)) then
         call uotty(' ', 1)
         write (stdout, 9120) 'predator', 
     &      qq_death_day(jage, fc_predatorp)
      endif
c
      if ( .not. noprey) then
         if ( .not. found_prey) then
            call uotty(' ', 1)
            write (stdout, *) 
     &         '?? could not grow prey to requested length'
            write (stdout, *) '   predator time: ', tbreak
         endif
         if ( .not. qq_fish_alive(jage, fc_preyp)) then
            call uotty(' ', 1)
            write (stdout, 9120) 'prey', qq_death_day(jage, fc_preyp)
         endif
      endif
c
  180 continue
      if (stephalt) then
         haltsimul = .true.
      endif
c
      call kerrmsg(nerror)
      prey_maxtime = tkbeg      ! prey last time point;             
      call out0()
      call out1()
      call out2()
c
      return
      end
      subroutine chainode(kage, kspecies, ztime, nerror)
c
c update: 17:25 fri 4-mar-1994.
c
c this is an interface between the ode driver and the Fgets ode;
c remember: integrate one fish.
c
c ztime:    time (days)
c;;
      include 'xglobal.par'
      include 'fish.par'
      include 'simul.par'
      include 'phylum.par'
      include 'physio.par'
      include 'errors.par'
      include 'chem.par'
      include 'numbers.par'
      include 'habitat.par'
      include 'fish.def'
      include 'globpar.def'
      include 'odevar.def'
      include 'fluxes.def'
      include 'lab.def'
      include 'options.def'
      include 'expos.def'
      include 'habitat.def'
c
c declaration for arguments
c
      integer kage, kspecies, nerror
      real ztime
c
      integer jchem, agep
      logical notdawn
c
c if the fish is dead look no further; maintain status quo;
c
      nerror = tnoerror
      if ( .not. qq_fish_alive(kage, kspecies)) then
         qq_dwdt(1, kage, kspecies) = zero
         qq_dwdt(2, kage, kspecies) = zero
         do jchem = 1, gnchem
            qq_dbfdt(jchem, kage, kspecies) = zero
         enddo
         go to 110
      endif
c
c calculate aqueous exposure conditions;
c the only (returnable) error at this time is a warning;
c stop simulation and output results so far.
c
      call envget(ztime)
c
c update morphological/physiological/prey concentrations parameters at "dawn" ;
c these will stay active (read: constant) for this day unless
c "Xupdate_continuously == true" ;
c
      agep = qq_fish_age(kage, kspecies)
      notdawn = (ztime .lt. qq_new_day(kage, kspecies))
      if (notdawn) then
         if (xupdate_continuously) then
            call kfupdate(kage, kspecies, qq_wt(1, kage, kspecies), 
     &         xcelsius, xplankton_standing_stock)
         endif
      else
         qq_new_day(kage, kspecies) = qq_new_day(kage, kspecies) + tinc
         call kfupdate(kage, kspecies, qq_wt(1, kage, kspecies), 
     &      xcelsius, xplankton_standing_stock)
      endif
c
      call kdwdt(ztime, vv_growth_model(agep, kspecies), 
     &   vv_functional_response(agep, kspecies), 
     &   qq_wgamma(kage, kspecies), qq_phi(kage, kspecies), 
     &   qq_gmax(kage, kspecies), qq_alpha1(kage, kspecies), 
     &   qq_alpha2(kage, kspecies), qq_epsl1(kage, kspecies), 
     &   qq_epsl2(kage, kspecies), qq_mu(kage, kspecies), sigma, nh3n, 
     &   cn, vv_pval(vassxeff, agep, kspecies), 
     &   qq_wt(1, kage, kspecies), qq_dwdt(1, kage, kspecies), 
     &   qq_wingest(kage, kspecies), qq_wassim(kage, kspecies), 
     &   qq_wegest(kage, kspecies), qq_wrespir(kage, kspecies), 
     &   qq_wsda(kage, kspecies), qq_wexcret(kage, kspecies))
c
      if (kspecies .eq. fc_predatorp) then      ! update Qq_cp-predator
         if (fc_preyt .eq. tspecies) then
            do jchem = 1, gnchem
               qq_cp(jchem, kage, fc_predatorp) = 
     &            qq_cfj(jchem, kage, fc_preyp)
            enddo
         elseif (fc_preyt .eq. tplankton) then
            do jchem = 1, gnchem
               qq_cp(jchem, kage, fc_predatorp) = 
     &            xchem_in_plankton(jchem)
            enddo
         elseif (fc_preyt .eq. tbenthos) then
            do jchem = 1, gnchem
               qq_cp(jchem, kage, fc_predatorp) = 
     &            xchem_in_benthos(jchem)
            enddo
         elseif (fc_preyt .eq. tcfish) then
            if (cfish_chem_func .eq. tconstant) then
               do jchem = 1, gnchem
                  qq_cp(jchem, kage, fc_predatorp) = 
     &               cfish_chem_conc(jchem)
               enddo
            elseif (cfish_chem_func .eq. tequilibrium) then
               do jchem = 1, gnchem
                  qq_cp(jchem, kage, fc_predatorp) = 
     &               xchem_in_water(jchem) * cfish_kf(jchem) * 
     &               cfish_bmf(jchem)
               enddo
            endif
         endif
c
      else      ! update Qq_cp-prey        
         if (fc_prey_foodt .eq. tplankton) then
            do jchem = 1, gnchem
               qq_cp(jchem, kage, fc_preyp) = xchem_in_plankton(jchem)
            enddo
         elseif (fc_prey_foodt .eq. tbenthos) then
            do jchem = 1, gnchem
               qq_cp(jchem, kage, fc_preyp) = xchem_in_benthos(jchem)
            enddo
         elseif (fc_prey_foodt .eq. tcfish) then
            if (cfish_chem_func .eq. tconstant) then
               do jchem = 1, gnchem
                  qq_cp(jchem, kage, fc_preyp) = cfish_chem_conc(jchem)
               enddo
            elseif (cfish_chem_func .eq. tequilibrium) then
               do jchem = 1, gnchem
                  qq_cp(jchem, kage, fc_preyp) = xchem_in_water(jchem) *
     &               cfish_kf(jchem) * cfish_bmf(jchem)
               enddo
            endif
         endif
      endif
c
      call kdbdtgf(gnchem, qq_sgill(kage, kspecies), 
     &   qq_kw(1, kage, kspecies), xchem_in_water, 
     &   qq_kf(1, kage, kspecies), qq_pa(kage, kspecies), koc, 
     &   qq_cp(1, kage, kspecies), qq_wingest(kage, kspecies), 
     &   qq_wegest(kage, kspecies), qq_wt(1, kage, kspecies), 
     &   qq_bf(1, kage, kspecies), qq_dbfdt(1, kage, kspecies), 
     &   qq_tjgilup(1, kage, kspecies), qq_tjgilex(1, kage, kspecies), 
     &   qq_tjgutup(1, kage, kspecies), qq_tjgutex(1, kage, kspecies))
c
  110 continue
      return
      end
      subroutine chemprop(nchem, clogp, logp, kow, kl, koc, acw)
c
c update: thu 15:43 5-mar-1992.
c
c this subroutine assigns the following:
c      1) Kow = n-octanol/ water partition coefficient;
c      2) Kl  = ktw = triolein/water partition coefficient;
c      3) Koc = organic carbon/ water partition coefficient;
c      4) Acw = aqueous chemical activity coefficient:
c
c notes:
c -if Logp is not known, calculate Logp using empirical regression
c  between Logp and Clogp. this regression was calculated using data
c  for chlorobenzenes, chlorinated biphenyls, brominated biphenyls,
c  methylated biphenyls, chlorinated dioxins, and chlorinated furans.
c  for data see
c  1. bruggeman et al. 1982. j. chromatography 238: 335-346.
c  2. chiou 1985. environ. sci. technol. 19: 57-62.
c  3. miller et al. 1985. environ. sci. technol. 19: 522-529.
c  4. doucette and andren 1987. environ. sci. technol. 21: 821-824.
c  5. gobas et al. 1988. j. pharm. sci. 77: 265-272.
c
c -calculate Kl=ktw using empirical regression between Log(ktw) and Logp
c  for data see
c  1. chiou 1985. environ. sci. technol. 19: 57-62
c
c -calculate ks=Koc according to karickhoff (1981. chemosphere 10:833-846).
c
c -estimate Acw by functional regression calculated from chiou and
c  schmedding 1982. environ. sci. technol. 16: 4-10.
c
c input
c     nchem, Clogp, Logp
c output
c     Logp, Kow, Kl, Koc, Acw
c;;
      include 'noval.par'
c
      integer nchem
      real clogp( * ), logp( * ), kow( * ), kl( * ), koc( * ), acw( * )
c
      integer jchem
c
      include 'vdefined.def'
      include 'vdefined.sfn'
c
      do jchem = 1, nchem
         if ( .not. vdefined(logp(jchem))) then
            if (clogp(jchem) .le. 5.0) then
               logp(jchem) = 0.986 * clogp(jchem) + 0.0276      ! (n=59; r=0.970)
            else
               logp(jchem) = 0.601 * clogp(jchem) + 1.933       ! (n=90; r=0.937)
            endif
         endif
         kow(jchem) = 10.0 ** logp(jchem)
         if (kow(jchem) .le. 1.0e+5) then
            kl(jchem) = 1.274 * kow(jchem)
         else
            kl(jchem) = 212.8 * kow(jchem) ** 0.571
         endif
         koc(jchem) = 0.411 * kow(jchem)
         acw(jchem) = 7.357 * kow(jchem) ** 1.149
      enddo
c
      return
      end
      subroutine chkfpar(fisiopar, growth_type, simul_mode, fpl, f1diet,
     &   havit, fisiostat)
c
c update: 15:40 wed 12-jan-1994.
c check that all required parameters have been resolved.
c returns:
c . havit - truth of "have all required parameters"
c . if parameter "vxx" is missing then "fisiostat(vxx) = tunset"
c;;
      include 'fish.par'
      include 'physio.par'
      include 'simul.par'
      include 'numbers.par'
      include 'setcodes.par'
      include 'globpar.def'
c
c declarations of subroutine's formal parameters
c
      logical havit
      real f1diet( * ), fisiopar( * )
      integer growth_type, simul_mode, fisiostat( * ), fpl
c
c unset_so_far:
c . number of unset entries;
c . variable initialized by the calling module, updated by "Isaryset";
c . we have all required info if unset_so_far == 0;
c
      integer jj, jprey, unset_so_far
      logical xneed
c
      do jj = 1, maxfpar
         fisiostat(jj) = tnotneed
      enddo
      unset_so_far = 0
c
c gill morphometric parameters + o2
c all models require gill exchange parameters
c
      call isaryset(vsgill1, fisiopar, fisiostat, unset_so_far)
      call isaryset(vsgill2, fisiopar, fisiostat, unset_so_far)
      call isaryset(vrho1, fisiopar, fisiostat, unset_so_far)
      call isaryset(vrho2, fisiopar, fisiostat, unset_so_far)
      call isaryset(vlaml1, fisiopar, fisiostat, unset_so_far)
      call isaryset(vlaml2, fisiopar, fisiostat, unset_so_far)
      call isaryset(vox1, fisiopar, fisiostat, unset_so_far)
      call isaryset(vox2, fisiopar, fisiostat, unset_so_far)
      call isaryset(voxq10, fisiopar, fisiostat, unset_so_far)
      call isaryset(voxt, fisiopar, fisiostat, unset_so_far)
c
c respiration & assimilation parameters;
c all models require respiration/assimilation efficiencies
c
      call isaryset(vassxeff, fisiopar, fisiostat, unset_so_far)
      call isaryset(vrq, fisiopar, fisiostat, unset_so_far)
      call isaryset(vox1, fisiopar, fisiostat, unset_so_far)
      call isaryset(vox2, fisiopar, fisiostat, unset_so_far)
      call isaryset(voxq10, fisiopar, fisiostat, unset_so_far)
      call isaryset(voxt, fisiopar, fisiostat, unset_so_far)
c
c fish length to wt conversion; required for all burden modes
c
      call isaryset(vlenwt1, fisiopar, fisiostat, unset_so_far)
      call isaryset(vlenwt2, fisiopar, fisiostat, unset_so_far)
c
c predator-length to prey-length function:
c if Simul_mode == tfood_chain then required IF the current fish
c    feeds on a fish;
c if Simul_mode == tfood_web then
c    required only if some member of its diet is not
c        (plankton | benthos | cfish)
c else not required;
c the diet array (for food chain) was set in Chkinput;
c
      if ((simul_mode .eq. tfood_chain) .or. (simul_mode .eq. tfood_web)
     &   ) then
         xneed = .false.
         do jprey = 1, gnspecies
            xneed = xneed .or. (f1diet(jprey) .gt. zero)
         enddo
         if (xneed) then
            call isaryset(vpred1, fisiopar, fisiostat, unset_so_far)
            call isaryset(vpred2, fisiopar, fisiostat, unset_so_far)
         endif
      endif
c
c feeding parameters
c
      if (growth_type .eq. tallometric) then
         call isaryset(vcmax1, fisiopar, fisiostat, unset_so_far)
         call isaryset(vcmax2, fisiopar, fisiostat, unset_so_far)
         call isaryset(vcmaxq10, fisiopar, fisiostat, unset_so_far)
         call isaryset(vcmaxt, fisiopar, fisiostat, unset_so_far)
c
      elseif (growth_type .eq. tholling) then
         call isaryset(vfsat1, fisiopar, fisiostat, unset_so_far)
         call isaryset(vfsat2, fisiopar, fisiostat, unset_so_far)
         call isaryset(vfsatq10, fisiopar, fisiostat, unset_so_far)
         call isaryset(vfsatt, fisiopar, fisiostat, unset_so_far)
         call isaryset(vtsat1, fisiopar, fisiostat, unset_so_far)
         call isaryset(vtsat2, fisiopar, fisiostat, unset_so_far)
         call isaryset(vtsatq10, fisiopar, fisiostat, unset_so_far)
         call isaryset(vtsatt, fisiopar, fisiostat, unset_so_far)
         call isaryset(vevac1, fisiopar, fisiostat, unset_so_far)
         call isaryset(vevac2, fisiopar, fisiostat, unset_so_far)
         call isaryset(vevac3, fisiopar, fisiostat, unset_so_far)
         call isaryset(vevacq10, fisiopar, fisiostat, unset_so_far)
         call isaryset(vevact, fisiopar, fisiostat, unset_so_far)
c
      elseif (growth_type .eq. tlinear) then
         call isaryset(vgamma1, fisiopar, fisiostat, unset_so_far)
         call isaryset(vgamma2, fisiopar, fisiostat, unset_so_far)
         call isaryset(vgammaq10, fisiopar, fisiostat, unset_so_far)
         call isaryset(vgammat, fisiopar, fisiostat, unset_so_far)
c
      elseif (growth_type .eq. tclearance) then
         call isaryset(vcvol1, fisiopar, fisiostat, unset_so_far)
         call isaryset(vcvol2, fisiopar, fisiostat, unset_so_far)
         call isaryset(vcvolq10, fisiopar, fisiostat, unset_so_far)
         call isaryset(vcvolt, fisiopar, fisiostat, unset_so_far)
      endif
c
c fraction lipid function parameters
c
      if ((fpl .eq. tallometric) .or. (fpl .eq. tdatabase) .or. (fpl 
     &   .eq. tfishpar)) then
         call isaryset(vpl1, fisiopar, fisiostat, unset_so_far)
         call isaryset(vpl2, fisiopar, fisiostat, unset_so_far)
      endif
c
c fraction aqueous function parameters; always needed;
c
      call isaryset(vpa1, fisiopar, fisiostat, unset_so_far)
      call isaryset(vpa2, fisiopar, fisiostat, unset_so_far)
c
      havit = (unset_so_far .eq. 0)
c
      return
      end
      subroutine chkinput(nerror)
c
c update: 11:45 fri 9-sep-1994.
c this subroutine checks the validity, completeness, and consistency
c of user input;
c
c notes:
c - the values of most options are check during input;
c - Wtunits, Cfunits, Cwunits, Tunits need not to be checked because:
c   1) they are initialized to defaults
c   2) module Setvar makes sure they are not set to a Null string.
c - the fish labels (Spplab, Famlab, Ecolab) are initially set to *snoval* ;
c   check only that they were set (i.e., value different from *snoval*)
c - no intelligent check can be performed for *Toxlab* ;
c   it has a non-Null default value & *Setvar* will accept only non-Null
c   strings; apart from that, it may be anything the fevered mind of the
c   user may desire.
c - module sets the fc_*p variables;
c
c we do not know if errors will be issued; do not use "Opage"
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'habitat.par'
      include 'noval.par'
      include 'numbers.par'
      include 'ode.par'
      include 'phylum.par'
      include 'simul.par'
      include 'strings.par'
c
      include 'chemp.def'
      include 'chems.def'
      include 'diet.def'
      include 'examsrec.def'
      include 'fish.def'
      include 'globpar.def'
      include 'habitat.def'
      include 'heap.def'
      include 'idfiles.def'
      include 'lab.def'
      include 'ode.def'
      include 'options.def'
      include 'time.def'
c
c declarations of subroutine's formal parameters
c
      integer nerror
c
c miscellaneous declarations
c
      integer jchem, nchem, nq1, xslen, pq1, nage, nspp
      integer jspecies, jage, nss, jrange, krange, ntox
      integer jprey
      logical valid, treq, tjfound, allset
      real tlow, tupp, tj
      external xslen, treq
c
      include 'vdefined.def'
      include 'vdefined.sfn'
c
 9110 format (1x,a)
 9120 format (
     &   ' ?? must select "Laboratory", "food_chain", or "food_web".')
 9130 format (' ?? Laboratory: only one fish species allowed.')
 9140 format (' ?? Laboratory: "',a,'" option not set.')
 9150 format (' ?? Laboratory: Food_bmf for "',a,'" .le. zero.')
 9160 format (' ?? Laboratory: cfood for "',a,'" .le. zero.')
 9170 format (' ?? Laboratory mode requires "maximum_age = 1"'/,
     &   '    Fgets will ignore all other age classes for "',a,'"')
c
 9180 format (' ?? food_chain: ','`prey = "plankton,benthos,fish"` requi
     &res only one fish species')
 9190 format (' ?? food_chain: ',
     &   '`prey = "Species"` requires two fish species')
 9200 format (' ?? food_chain: could not find ',a,' species "',a,'"')
 9210 format (' ?? food_chain: "',a,'" not set')
 9220 format (' ?? food_chain: Food_pl required')
 9230 format (' ?? food_chain: Food_pl .le. 0  or  .gt. 1')
 9240 format (' ?? Food Chain mode requires "maximum_age = 1"'/,
     &   '    Fgets will ignore all other age classes for the ',a,' "',
     &   a,'"')
c
c******************** chemical independent Real inputs ***********************
c
 9250 format (' ?? Tnstep < 1')
 9260 format (' ?? active gill not input for "',a,'"')
 9270 format (' ?? "',a,'" : initial wt required either for ',
     &   'age class one or all age classes')
 9280 format (' ?? plfish not specified for age ',i3,' of "',a,'"')
 9290 format (' ?? temperature not specified')
c
 9300 format (' ?? must specify growth option for age ',i3,' of "',a,'"'
     &   )
c
 9310 format (' ?? tbeg .ge. tend')
 9320 format (' ?? species unset for "',a,'"')
 9330 format (' ?? family unset for "',a,'"')
 9340 format (' ?? ecology unset for "',a,'"')
c
c******************** chemical dependent inputs ***************************
c
 9350 format (' ?? no molecular weight specified for "',a,'"')
 9360 format (' ?? no molecular volume specified for "',a,'"')
 9370 format (' ?? no melting point specified for "',a,'"')
 9380 format (' ?? either Logp or Clogp must be specified for "',a,'"')
 9390 format (' ?? cwater for "',a,'" was not specified')
 9400 format (' ?? initial concentration in fish for "',a,'", age ',i3,
     &   ' of "',a,'" is .le. zero')
c
 9410 format (' ?? warning: "',a,'" was used as a diet item ',/,
     &   '    but its chemical concentration was not set (use "/',a,
     &   '").')
 9420 format (' ?? warning: concentration of chemical in',/,'    ',a,
     &   ' was provided but ',a,' was not part of the diet.')
 9430 format (' ?? no diet for "',a,'", year class ',i2)
 9440 format (' ?? "',a,'", year class ',i2,':',/'    growth model optio
     &n clearance requires plankton diet = 1.0')
c;;
      pq1 = 0
      call heapush(pq1)
c
      nerror = 0
      nchem = gnchem
c
c set these first for error messages
c
      do jchem = 1, nchem
         if (toxlab(jchem) .eq. snoval) then
            write (toxlab(jchem), '(a,i4)') 'Chemical ', jchem
            call compress(toxlab(jchem), -1, nq1)
         endif
      enddo
c
      do jspecies = 1, gnspecies
         if (spplab(jspecies) .eq. snoval) then
            nerror = nerror + 1
            write (spplab(jspecies), '(a,i4)') 'Species ', jspecies
            call compress(spplab(jspecies), -1, nspp)
c
            write (qhs(pq1), 9320) spplab(jspecies)(1:nspp)
            call compress(qhs(pq1), -1, nq1)
            write (stdout, 9110) qhs(pq1)(1:nq1)
         endif
      enddo
c
c check simulation mode
c
      if (simul_mode .eq. tfood_chain) then
         if (fc_preyt .eq. tspecies) then
            if (gnspecies .ne. 2) then
               nerror = nerror + 1
               write (stdout, 9190)
            endif
         else
            if (gnspecies .ne. 1) then
               nerror = nerror + 1
               write (stdout, 9180)
            endif
         endif
c
c determine pointers to predator and prey
c
         fc_predatorp = inoval
         fc_preyp = inoval
         do jspecies = 1, gnspecies
            if (fc_spredator .eq. spplab(jspecies)) then
               fc_predatorp = jspecies
            endif
            if (fc_preyt .eq. tspecies) then
               if (fc_sprey .eq. spplab(jspecies)) then
                  fc_preyp = jspecies
               endif
            endif
         enddo
         if (fc_predatorp .eq. inoval) then
            nerror = nerror + 1
            nss = xslen(fc_spredator)
            write (stdout, 9200) 'predator', fc_spredator(1:nss)
         endif
c
         if (fc_preyt .eq. tspecies) then
            if (fc_preyp .eq. inoval) then
               nerror = nerror + 1
               nss = xslen(fc_sprey)
               write (stdout, 9200) 'prey', fc_sprey(1:nss)
            endif
         endif
c
c "cfood" stuff
c
         if (fc_preyt .eq. tspecies) then
            if (fc_prey_foodt .eq. tplankton) then
               if ( .not. xplankton) then
                  nerror = nerror + 1
                  write (stdout, 9210) '/cplankton'
               endif
            elseif (fc_prey_foodt .eq. tbenthos) then
               if ( .not. xbenthos) then
                  nerror = nerror + 1
                  write (stdout, 9210) '/cbenthos'
               endif
            elseif (fc_prey_foodt .eq. tcfish) then
               if ( .not. xcfish) then
                  nerror = nerror + 1
                  write (stdout, 9210) '/cfish'
               endif
            elseif (fc_prey_foodt .eq. inoval) then
               continue
            endif
c
         elseif (fc_preyt .eq. tplankton) then
            if ( .not. xplankton) then
               nerror = nerror + 1
               write (stdout, 9210) '/cplankton'
            endif
         elseif (fc_preyt .eq. tbenthos) then
            if ( .not. xbenthos) then
               nerror = nerror + 1
               write (stdout, 9210) '/cbenthos'
            endif
         elseif (fc_preyt .eq. tcfish) then
            if ( .not. xcfish) then
               nerror = nerror + 1
               write (stdout, 9210) '/cfish'
            endif
         endif
c
c make sure maxage = 1; if maxage > 1, issue a warning message, hardwire
c maxage = 1, and continue.
c
         if (fc_predatorp .ne. inoval) then
            if (xmaximum_age(fc_predatorp) .ne. 1) then
               xmaximum_age(fc_predatorp) = 1
               nss = xslen(fc_spredator)
               write (stdout, 9240) 'predator', fc_spredator(1:nss)
            endif
         endif
         if (fc_preyp .ne. inoval) then
            if (xmaximum_age(fc_preyp) .ne. 1) then
               xmaximum_age(fc_preyp) = 1
               nss = xslen(fc_sprey)
               write (stdout, 9240) 'prey', fc_sprey(1:nss)
            endif
         endif
c
c set the Diet array for Food Chain: Predator and Prey
c . one range, by weight; the weight range must cover all nonnegative Real
c   numbers; the lower limit must be zero, the upper limit is arbitrary;
c
         if (fc_predatorp .ne. inoval) then
            krange = 1
            range_type(fc_predatorp) = tweight
            range_numof(fc_predatorp) = krange
            range_lowb(krange, fc_predatorp) = zero
            range_uppb(krange, fc_predatorp) = 1.0e6
            do jprey = 1, maxbiota
               fdiet(jprey, krange, fc_predatorp) = zero
            enddo
            if (fc_preyt .eq. tspecies) then
               if (fc_preyp .ne. inoval) then
                  fdiet(fc_preyp, krange, fc_predatorp) = one
               endif
            elseif (fc_preyt .eq. tplankton) then
               fdiet(pplankton, krange, fc_predatorp) = one
            elseif (fc_preyt .eq. tbenthos) then
               fdiet(pbenthos, krange, fc_predatorp) = one
            elseif (fc_preyt .eq. tcfish) then
               fdiet(pcfish, krange, fc_predatorp) = one
            endif
         endif
c
c Ditto for the prey
c
         if (fc_preyp .ne. inoval) then
            krange = 1
            range_type(fc_preyp) = tweight
            range_numof(fc_preyp) = krange
            range_lowb(krange, fc_preyp) = zero
            range_uppb(krange, fc_preyp) = 1.0e6
            do jprey = 1, maxbiota
               fdiet(jprey, krange, fc_preyp) = zero
            enddo
            if (fc_prey_foodt .eq. tplankton) then
               fdiet(pplankton, krange, fc_preyp) = one
            elseif (fc_prey_foodt .eq. tbenthos) then
               fdiet(pbenthos, krange, fc_preyp) = one
            elseif (fc_prey_foodt .eq. tcfish) then
               fdiet(pcfish, krange, fc_preyp) = one
            endif
         endif
c
      elseif (simul_mode .eq. tlaboratory) then
         if (gnspecies .ne. 1) then
            nerror = nerror + 1
            write (stdout, 9130)
         endif
c
c make sure maxage = 1; if maxage > 1, issue a warning message, hardwire
c maxage = 1, and continue.
c
         if (gnspecies .eq. 1) then
            if (xmaximum_age(gnspecies) .ne. 1) then
               xmaximum_age(gnspecies) = 1
               nss = xslen(spplab(gnspecies))
               write (stdout, 9170) spplab(gnspecies)(1:nss)
            endif
         endif
c
         if ( .not. vdefined(tank_flow)) then
            nerror = nerror + 1
            write (stdout, 9140) 'flow'
         endif
         if ( .not. vdefined(tank_volume)) then
            nerror = nerror + 1
            write (stdout, 9140) 'volume'
         endif
         if ( .not. vdefined(tank_nfish)) then
            nerror = nerror + 1
            write (stdout, 9140) 'nfish'
         endif
c
         if (food_chem_func .eq. inoval) then
            nerror = nerror + 1
            write (stdout, 9140) 'cfood'
c
         elseif (food_chem_func .eq. tconstant) then
            do jchem = 1, nchem
               if ( .not. vdefined(food_chem_conc(jchem))) then
                  nerror = nerror + 1
                  ntox = xslen(toxlab(jchem))
                  write (qhs(pq1), 9160) toxlab(jchem)(1:ntox)
                  call compress(qhs(pq1), -1, nq1)
                  write (stdout, 9110) qhs(pq1)(1:nq1)
               endif
            enddo
c
         elseif (food_chem_func .eq. tequilibrium) then
            do jchem = 1, nchem
               if (food_bmf(jchem) .le. zero) then
                  nerror = nerror + 1
                  ntox = xslen(toxlab(jchem))
                  write (qhs(pq1), 9150) toxlab(jchem)(1:ntox)
                  call compress(qhs(pq1), -1, nq1)
                  write (stdout, 9110) qhs(pq1)(1:nq1)
               endif
            enddo
c
            if ( .not. vdefined(food_pl)) then
               nerror = nerror + 1
               write (qhs(pq1), 9220)
               call compress(qhs(pq1), -1, nq1)
               write (stdout, 9110) qhs(pq1)(1:nq1)
            elseif ((food_pl .le. zero) .or. (food_pl .gt. one)) then
               nerror = nerror + 1
               write (qhs(pq1), 9230)
               call compress(qhs(pq1), -1, nq1)
               write (stdout, 9110) qhs(pq1)(1:nq1)
            endif
         endif
c
      elseif (simul_mode .eq. tfood_web) then
c
c plankton: if used as a diet item (Dplankton = .true.), the concentration
c           of the chemical must be input also (Xplankton = .true.);
c           if Dplankton is not set but Xplankton is set, it means that the
c           user provided concentration of chemical in plankton (via
c           "/cplankton ...") but "plankton" does not appear as diet.
c           this may be a warning or an error: at this time it will be
c           considered an error.
c
c benthos:  similar to plankton, above;
c cfish:    similar to plankton, above;
c
         if (dplankton) then
            if (xplankton) then
               continue
            else
               write (stdout, 9410) 'plankton', 'cplankton'
            endif
         elseif (xplankton) then
            write (stdout, 9420) 'plankton', 'plankton'
         endif
         xplankton = dplankton
c
         if (dbenthos) then
            if (xbenthos) then
               continue
            else
               write (stdout, 9410) 'benthos', 'cbenthos'
            endif
         elseif (xbenthos) then
            write (stdout, 9420) 'benthos', 'benthos'
         endif
         xbenthos = dbenthos
c
         if (dcfish) then
            if (xcfish) then
               continue
            else
               write (stdout, 9410) 'fish', 'cfish'
            endif
         elseif (xcfish) then
            write (stdout, 9420) 'cfish', 'cfish'
         endif
         xcfish = dcfish
c
      else
         nerror = nerror + 1
         write (stdout, 9120)
      endif
c
c check times
c
      valid = (simul_beg .lt. simul_end)
      if ( .not. valid) then
         nerror = nerror + 1
         write (stdout, 9310)
      endif
c
      valid = (tnstep .ge. one)
      if ( .not. valid) then
         nerror = nerror + 1
         write (stdout, 9250)
      endif
c
      if (xexams) then
c
c if "Xexams", then module "Iexams" did all the checking, or set the
c error flag.
c
      else
         if (twfunc .eq. inoval) then
            nerror = nerror + 1
            write (stdout, 9290)
         endif
         do jchem = 1, nchem
            if (cwfunc(jchem) .eq. inoval) then
               nerror = nerror + 1
               ntox = xslen(toxlab(jchem))
               write (stdout, 9390) toxlab(jchem)(1:ntox)
            endif
         enddo
      endif
c
      do jchem = 1, nchem
         if ( .not. vdefined(molwt(jchem))) then
            nerror = nerror + 1
            ntox = xslen(toxlab(jchem))
            write (stdout, 9350) toxlab(jchem)(1:ntox)
         endif
         if ( .not. vdefined(molvol(jchem))) then
            nerror = nerror + 1
            ntox = xslen(toxlab(jchem))
            write (stdout, 9360) toxlab(jchem)(1:ntox)
         endif
         if ( .not. vdefined(mp(jchem))) then
            nerror = nerror + 1
            ntox = xslen(toxlab(jchem))
            write (stdout, 9370) toxlab(jchem)(1:ntox)
         endif
         if (( .not. vdefined(clogp(jchem))) .and. ( .not. 
     &      vdefined(logp(jchem)))) then
            nerror = nerror + 1
            ntox = xslen(toxlab(jchem))
            write (stdout, 9380) toxlab(jchem)(1:ntox)
         endif
      enddo
c
c check species dependent stuff
c
      do jspecies = 1, gnspecies
         nage = xmaximum_age(jspecies)
         nspp = xslen(spplab(jspecies))
c
         if (famlab(jspecies) .eq. snoval) then
            nerror = nerror + 1
            write (qhs(pq1), 9330) spplab(jspecies)(1:nspp)
            call compress(qhs(pq1), -1, nq1)
            write (stdout, 9110) qhs(pq1)(1:nq1)
         endif
c
         if (ecolab(jspecies) .eq. snoval) then
            nerror = nerror + 1
            write (qhs(pq1), 9340) spplab(jspecies)(1:nspp)
            call compress(qhs(pq1), -1, nq1)
            write (stdout, 9110) qhs(pq1)(1:nq1)
         endif
c
         if ( .not. vdefined(activegill(jspecies))) then
            nerror = nerror + 1
            write (qhs(pq1), 9260) spplab(jspecies)(1:nspp)
            call compress(qhs(pq1), -1, nq1)
            write (stdout, 9110) qhs(pq1)(1:nq1)
         endif
c
c check each year class has a diet.
c
         if (simul_mode .eq. tfood_web) then
            if (range_type(jspecies) .eq. tage) then
               do jage = 1, nage
                  tj = real(jage)
                  tjfound = .false.
                  do jrange = 1, range_numof(jspecies)
                     tlow = range_lowb(jrange, jspecies) * (one - 
     &                  mach_eps)
                     tupp = range_uppb(jrange, jspecies) * (one + 
     &                  mach_eps)
                     if ((tlow .le. tj) .and. (tj .le. tupp)) then
                        tjfound = .true.
                     endif
                  enddo
                  if ( .not. tjfound) then
                     nerror = nerror + 1
                     write (qhs(pq1), 9430) spplab(jspecies)(1:nspp), 
     &                  jage
                     call compress(qhs(pq1), -1, nq1)
                     write (stdout, 9110) qhs(pq1)(1:nq1)
                  endif
               enddo
            elseif (range_type(jspecies) .eq. tweight) then
            elseif (range_type(jspecies) .eq. tlength) then
            endif
         endif
c
c age-dependent stuff
c
         allset = .true.
         do jage = 1, nage
            allset = allset .and. (vv_iniwt(jage, jspecies) .gt. zero)
         enddo
         if ( .not. allset) then
            if (vv_iniwt(1, jspecies) .gt. zero) then
               continue
            else
               nerror = nerror + 1
               write (qhs(pq1), 9270) spplab(jspecies)(1:nspp)
               call compress(qhs(pq1), -1, nq1)
               write (stdout, 9110) qhs(pq1)(1:nq1)
            endif
         endif
c
         do jage = 1, nage
            if (vv_plfunc(jage, jspecies) .eq. inoval) then
               nerror = nerror + 1
               write (qhs(pq1), 9280) jage, spplab(jspecies)(1:nspp)
               call compress(qhs(pq1), -1, nq1)
               write (stdout, 9110) qhs(pq1)(1:nq1)
            endif
c
            if (vv_growth_model(jage, jspecies) .eq. inoval) then
               nerror = nerror + 1
               write (qhs(pq1), 9300) jage, spplab(jspecies)(1:nspp)
               call compress(qhs(pq1), -1, nq1)
               write (stdout, 9110) qhs(pq1)(1:nq1)
            elseif (vv_growth_model(jage, jspecies) .eq. tclearance) 
     &         then
               if (range_type(jspecies) .eq. tage) then
                  tj = real(jage)
                  tjfound = .false.
                  do jrange = 1, range_numof(jspecies)
                     tlow = range_lowb(jrange, jspecies) * (one - 
     &                  mach_eps)
                     tupp = range_uppb(jrange, jspecies) * (one + 
     &                  mach_eps)
                     if ((tlow .le. tj) .and. (tj .le. tupp)) then
                        tjfound = .true.
                        krange = jrange
                     endif
                  enddo
                  if (tjfound) then
                     if (treq(fdiet(pplankton, krange, jspecies), one))
     &                  then
                        continue        ! ok                                
                     else
                        nerror = nerror + 1
                        write (stdout, 9440) spplab(jspecies)(1:nspp), 
     &                     jage
                     endif
                  else
                     nerror = nerror + 1
                     write (stdout, 9440) spplab(jspecies)(1:nspp), jage
                  endif
               elseif (range_type(jspecies) .eq. tweight) then
               elseif (range_type(jspecies) .eq. tlength) then
               endif
            endif
c
            do jchem = 1, nchem
               if (vv_inicf(jchem, jage, jspecies) .lt. zero) then
                  nerror = nerror + 1
                  ntox = xslen(toxlab(jchem))
                  write (qhs(pq1), 9400) toxlab(jchem)(1:ntox), jage, 
     &               spplab(jspecies)(1:nspp)
                  call compress(qhs(pq1), -1, nq1)
                  write (stdout, 9110) qhs(pq1)(1:nq1)
               endif
            enddo
         enddo
      enddo
c
      call heapop(pq1)
c
      return
      end
      subroutine clropt(option, nopti)
c
c CLROPT.spg  processed by SPAG 3.14A  at 14:41 on 26 Oct 1992
c\begin
c     purpose:
c        - initialize the options array option.
c\end
c
      integer nopti
      logical option( * )
      integer jj
c
      do jj = 1, nopti
         option(jj) = .false.
      enddo
c
      return
      end
      subroutine collapse(xbuf, oldlen, newlen)
c
c update:   15:46 fri 11-mar-1994.
c processed by SPAG 3.14A  at 14:41 on 26 Oct 1992
c purpose:  get rid of all soft delimiters in "Xbuf"
c;;
      include 'Xglobal.par'
c
      integer oldlen, newlen
      character*( * ) xbuf
c
      integer nchar, jj, nss, xslen
      logical havenull
      external xslen
c
      include 'chars.def'
      include 'chars.sfn'
c
      if (oldlen .ge. 0) then
         nchar = oldlen
      else
         nchar = xslen(xbuf)
      endif
c
      havenull = .false.
      if (nchar + 1 .le. len(xbuf)) then
         havenull = (xbuf(nchar + 1:nchar + 1) .eq. null)
      endif
c
      nss = 0
      do jj = 1, nchar
         if ( .not. uwhite(xbuf(jj:jj))) then
            nss = nss + 1
            xbuf(nss:nss) = xbuf(jj:jj)
         endif
      enddo
c
      if (nss + 1 .le. len(xbuf)) then
         if (havenull) then
            xbuf(nss + 1:) = null // ' '
         else
            xbuf(nss + 1:) = ' '
         endif
      endif
      newlen = nss
c
      return
      end
      subroutine compress(xbuf, oldlen, newlen)
c
c update:   08:54 fri 11-mar-1994.
c processed by SPAG 3.14A  at 14:41 on 26 Oct 1992
c purpose:
c    compress string:
c       remove leading and trailing blanks;
c       convert runs of tabs or blanks to one blank;
c
c input:
c    oldlen       (integer);
c                 if (oldlen .ge. 0): number of characters in *Xbuf* ;
c                 if (oldlen .le. 0): use Xslen to determine the number of
c                                     characters in *Xbuf* ;
c    Xbuf         (s*(*)) character array
c
c output:
c    newlen       (integer) number of characters in *Xbuf* after compression
c
c note:
c    things like "Compress(Xbuf, Nbuf, Nbuf)" are allowed.
c;;
      include 'Xglobal.par'
c
      integer oldlen, newlen
      character*( * ) xbuf
c
      integer nchar, jj, nrun, nss, xslen
      logical ignore_blanks, havenull
      external xslen
c
      include 'chars.def'
      include 'chars.sfn'
c
      if (oldlen .ge. 0) then
         nchar = oldlen
      else
         nchar = xslen(xbuf)
      endif
c
      havenull = .false.
      if (nchar + 1 .le. len(xbuf)) then
         havenull = (xbuf(nchar + 1:nchar + 1) .eq. null)
      endif
c
      nss = 0
      nrun = 1
      ignore_blanks = .false.
      do jj = 1, nchar
         if ( .not. uwhite(xbuf(jj:jj))) then
            nss = nss + 1
            xbuf(nss:nss) = xbuf(jj:jj)
            nrun = 0
c
c replace runs of soft delimiters with one blank
c
         elseif ( .not. ignore_blanks) then
            if (nrun .eq. 0) then
               nss = nss + 1
               xbuf(nss:nss) = ' '
               nrun = nrun + 1
            endif
         endif
      enddo
c
      if (nss + 1 .le. len(xbuf)) then
         if (havenull) then
            xbuf(nss + 1:) = null // ' '
         else
            xbuf(nss + 1:) = ' '
         endif
      endif
      newlen = nss
c
      return
      end
      subroutine dbnfound(stdout, zspecies, fishstat)
c
c update: 17:39 fri 4-mar-1994.
c issue message as to missing parameters
c;;
      include 'fish.par'
      include 'setcodes.par'
      include 'physio.par'
      include 'strings.par'
c
      character*( * ) zspecies
      integer stdout, fishstat( * )
c
      character*(s40) idpar(maxfpar)
      integer xslen, jj, nn
      external xslen
c
      data idpar(vsgill1) /'sgill1'/
      data idpar(vsgill2) /'sgill2'/
      data idpar(vrho1) /'rho1'/
      data idpar(vrho2) /'rho2'/
      data idpar(vlaml1) /'laml1'/
      data idpar(vlaml2) /'laml2'/
      data idpar(vpl1) /'pl1'/
      data idpar(vpl2) /'pl2'/
      data idpar(vpa1) /'pa1'/
      data idpar(vpa2) /'pa2'/
      data idpar(vlenwt1) /'lenwt1'/
      data idpar(vlenwt2) /'lenwt2'/
      data idpar(vpred1) /'pred1'/
      data idpar(vpred2) /'pred2'/
      data idpar(vgamma1) /'gamma1'/
      data idpar(vgamma2) /'gamma2'/
      data idpar(vgammaq10) /'gammaq10'/
      data idpar(vgammat) /'gammat'/
      data idpar(vcmax1) /'cmax1'/
      data idpar(vcmax2) /'cmax2'/
      data idpar(vcmaxq10) /'cmaxq10'/
      data idpar(vcmaxt) /'cmaxt'/
      data idpar(vfsat1) /'fsat1'/
      data idpar(vfsat2) /'fsat2'/
      data idpar(vfsatq10) /'fsatq10'/
      data idpar(vfsatt) /'fsatt'/
      data idpar(vtsat1) /'tsat1'/
      data idpar(vtsat2) /'tsat2'/
      data idpar(vtsatq10) /'tsatq10'/
      data idpar(vtsatt) /'tsatt'/
      data idpar(vassxeff) /'assxeff'/
      data idpar(vevac1) /'evac1'/
      data idpar(vevac2) /'evac2'/
      data idpar(vevac3) /'evac3'/
      data idpar(vevacq10) /'evacq10'/
      data idpar(vevact) /'evact'/
      data idpar(vrq) /'rq'/
      data idpar(vox1) /'ox1'/
      data idpar(vox2) /'ox2'/
      data idpar(voxq10) /'oxq10'/
      data idpar(voxt) /'oxt'/
      data idpar(vcvol1) /'cvol1'/
      data idpar(vcvol2) /'cvol2'/
      data idpar(vcvolq10) /'cvolq10'/
      data idpar(vcvolt) /'cvolt'/
      data idpar(vwty1) /'wt year 1'/
c
 9110 format ('           missing: ',a)
c
      nn = xslen(zspecies)
      do jj = 1, maxfpar
         if (fishstat(jj) .eq. tunset) then
            nn = xslen(idpar(jj))
            write (stdout, 9110) idpar(jj)(1:nn)
         endif
      enddo
c
      return
      end
      subroutine dbnorm(dbpar, nerror)
c
c update: 17:40 fri 4-mar-1994.
c standarize morphological/physiological/ecological parameters
c
c nerror > 0: one of these temperature dependent parameters was
c             input without the reference temperature:
c                 Dbpar(vgamma1), Dbpar(vcvol1),  Dbpar(vcmax1),
c                 Dbpar(vfsat1),  Dbpar(vtsat1), Dbpar(vevac1),
c                 Dbpar(vox1)
c             nerror = number of such entries;
c
c declaration of fortran parameters
c
      include 'physio.par'
      include 'dbphysio.par'
      include 'noval.par'
      include 'vdefined.def'
c
      real dbpar( * )
      integer nerror
c
      real rho1, rho2, default_q10, exx
      external exx
c
      include 'vdefined.sfn'
c
      nerror = 0
c
c standardize gill morphometric data.
c data stored in (Dbpar(vrho1),Dbpar(vrho2)) are lamellar density parameters;
c transform them to interlamellar distance parameters;
c
c calculate the power function coefficient and exponent for interlamellar
c distance, d, using the relationships,
c
c    rho = # lamellae/mm gill filament = rho1 * wt * rho2
c           d [cm] = 0.11815 * rho ** (-1.18862).
c
c compute lamellar densities from interlamellar distances;
c the same formula should be used in "Dbnorm", "Ofishpar", "Ospecies";
c
c    s    =  gill area [cm^2] = s1 * wt ** s2,
c    d    =  interlamellar distance [cm] = d1 * wt ** d2,
c    laml =  lamellar length [cm] = laml1 * wt ** laml2,
c
      rho1 = dbpar(vrho1)
      rho2 = dbpar(vrho2)
      if (vdefined(rho1)) dbpar(vrho1) = 0.11815 * rho1 ** ( -1.18862)
      if (vdefined(rho2)) dbpar(vrho2) = rho2 * ( -1.18862)
c
c calculate q10 coefficients for temperature dependent data from known
c or default q10s;  assign default q10=2.0 as necessary; standardize
c temperature dependent data to standard temperature ("ref_celsius")
c assuming an appropriate q10, either the default or user supplied;
c
      default_q10 = log(2.0) / 10.0
c
      if (vdefined(dbpar(vgamma1))) then
         if (vdefined(dbpar(vgammaq10))) then
            dbpar(vgammaq10) = log(dbpar(vgammaq10)) / 10.0
         else
            dbpar(vgammaq10) = default_q10
         endif
         if (vdefined(dbpar(vgammat))) then
            dbpar(vgamma1) = dbpar(vgamma1) * 
     &         exx(dbpar(vgammaq10) * (ref_celsius - dbpar(vgammat)))
            dbpar(vgammat) = ref_celsius
         else
            nerror = nerror + 1
         endif
      endif
c
      if (vdefined(dbpar(vcvol1))) then
         if (vdefined(dbpar(vcvolq10))) then
            dbpar(vcvolq10) = log(dbpar(vcvolq10)) / 10.0
         else
            dbpar(vcvolq10) = default_q10
         endif
         if (vdefined(dbpar(vcvolt))) then
            dbpar(vcvol1) = dbpar(vcvol1) * 
     &         exx(dbpar(vcvolq10) * (ref_celsius - dbpar(vcvolt)))
            dbpar(vcvolt) = ref_celsius
         else
            nerror = nerror + 1
         endif
      endif
c
      if (vdefined(dbpar(vcmax1))) then
         if (vdefined(dbpar(vcmaxq10))) then
            dbpar(vcmaxq10) = log(dbpar(vcmaxq10)) / 10.0
         else
            dbpar(vcmaxq10) = default_q10
         endif
         if (vdefined(dbpar(vcmaxt))) then
            dbpar(vcmax1) = dbpar(vcmax1) * 
     &         exx(dbpar(vcmaxq10) * (ref_celsius - dbpar(vcmaxt)))
            dbpar(vcmaxt) = ref_celsius
         else
            nerror = nerror + 1
         endif
      endif
c
      if (vdefined(dbpar(vfsat1))) then
         if (vdefined(dbpar(vfsatq10))) then
            dbpar(vfsatq10) = log(dbpar(vfsatq10)) / 10.0
         else
            dbpar(vfsatq10) = default_q10
         endif
         if (vdefined(dbpar(vfsatt))) then
            dbpar(vfsat1) = dbpar(vfsat1) * 
     &         exx(dbpar(vfsatq10) * (ref_celsius - dbpar(vfsatt)))
            dbpar(vfsatt) = ref_celsius
         else
            nerror = nerror + 1
         endif
      endif
c
      if (vdefined(dbpar(vtsat1))) then
         if (vdefined(dbpar(vtsatq10))) then
            dbpar(vtsatq10) = log(dbpar(vtsatq10)) / 10.0
         else
            dbpar(vtsatq10) = default_q10
         endif
         if (vdefined(dbpar(vtsatt))) then
            dbpar(vtsat1) = dbpar(vtsat1) * 
     &         exx(dbpar(vtsatq10) * (ref_celsius - dbpar(vtsatt)))
            dbpar(vtsatt) = ref_celsius
         else
            nerror = nerror + 1
         endif
      endif
c
      if (vdefined(dbpar(vevac1))) then
         if (vdefined(dbpar(vevacq10))) then
            dbpar(vevacq10) = log(dbpar(vevacq10)) / 10.0
         else
            dbpar(vevacq10) = default_q10
         endif
         if (vdefined(dbpar(vevact))) then
            dbpar(vevac1) = dbpar(vevac1) * 
     &         exx(dbpar(vevacq10) * (ref_celsius - dbpar(vevact)))
            dbpar(vevact) = ref_celsius
         else
            nerror = nerror + 1
         endif
      endif
c
      if (vdefined(dbpar(vox1))) then
         if (vdefined(dbpar(voxq10))) then
            dbpar(voxq10) = log(dbpar(voxq10)) / 10.0
         else
            dbpar(voxq10) = default_q10
         endif
         if (vdefined(dbpar(voxt))) then
            dbpar(vox1) = dbpar(vox1) * 
     &         exx(dbpar(voxq10) * (ref_celsius - dbpar(voxt)))
            dbpar(voxt) = ref_celsius
         else
            nerror = nerror + 1
         endif
      endif
c
      return
      end
      subroutine dbparam(spplab, genlab, famlab, hablab, fedlab, 
     &   gnspecies, xxp, sxp, nxp, dbpar, dbtyp)
c
c update: 16:00 tue 5-apr-1994.
c species-dependent parameters: morphological / physiological / ecological
c
c on output:
c . Dbpar(1:npar,1:Gnspecies) contains the parameters for all species
c . Dbtyp(1:npar,1:Gnspecies) contains the resolution level of the parameter:
c        tuser:      provided by user
c        tspecies:   species match
c        tgenus:     genus match
c        tfamily:    family match
c        tecology:   ecology match
c        tgeneric:   generated using all the database entries
c
c tuser < tspecies < tgenus < tfamily < tecology < tgeneric
c modifications in the values of these parameters must be propagated to
c "phylum.par", "work.def", "Dbparam".
c the values are arbitrary but they should be consecutive integers, with
c "tuser" having the lowest value.
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'fish.par'
      include 'physio.par'
      include 'phylum.par'
      include 'noval.par'
      include 'numbers.par'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) spplab( * ), genlab( * ), famlab( * ), 
     &   hablab( * ), fedlab( * )
      integer gnspecies
      real sxp(maxfpar, tspecies:tgeneric, * ), xxp( * )
      integer nxp(maxfpar, tspecies:tgeneric, * )
      integer dbtyp(maxfpar, * )
      real dbpar(maxfpar, * )
c
c declarations for database processing
c
      character*(stdlen) xspecies, xgenus, xfamily, xecology, xfull_name
      real xmean
      logical done, ok
      integer xfopen, xslen, nerror, jpar, jresol, nh, nxfn
      integer jspecies, xresol, ios
      external xfopen, xslen, xfclose
      include 'vdefined.def'
c
c select the lowest level of resolution for the parameters:
c tuser < tspecies < tgenus < tfamily < tecology < tgeneric
c
c examples:
c     resol(x) = tgeneric ==> species, genus, family, ecology, generic;
c        i.e., resolve parameter "x" first by species, then by genus; etc.
c     resol(x) = tfamily  ==> species, genus, family
c     resol(x) = tspecies ==> species
c
c data for sum control:
c     g: geometric mean
c     a: arithmetic mean
c
      character*(1) sum_type(maxfpar)
      integer resol(maxfpar)
c
      data sum_type(vsgill1) /'g'/, resol(vsgill1) /tgeneric/
      data sum_type(vsgill2) /'a'/, resol(vsgill2) /tgeneric/
      data sum_type(vrho1) /'g'/, resol(vrho1) /tgeneric/
      data sum_type(vrho2) /'a'/, resol(vrho2) /tgeneric/
      data sum_type(vlaml1) /'g'/, resol(vlaml1) /tgeneric/
      data sum_type(vlaml2) /'a'/, resol(vlaml2) /tgeneric/
      data sum_type(vpl1) /'g'/, resol(vpl1) /tfamily/
      data sum_type(vpl2) /'a'/, resol(vpl2) /tfamily/
      data sum_type(vpa1) /'a'/, resol(vpa1) /tgeneric/
      data sum_type(vpa2) /'a'/, resol(vpa2) /tgeneric/
      data sum_type(vlenwt1) /'g'/, resol(vlenwt1) /tfamily/
      data sum_type(vlenwt2) /'a'/, resol(vlenwt2) /tfamily/
      data sum_type(vpred1) /'a'/, resol(vpred1) /tfamily/
      data sum_type(vpred2) /'a'/, resol(vpred2) /tfamily/
      data sum_type(vgamma1) /'g'/, resol(vgamma1) /tfamily/
      data sum_type(vgamma2) /'a'/, resol(vgamma2) /tfamily/
      data sum_type(vgammaq10) /'a'/, resol(vgammaq10) /tfamily/
      data sum_type(vgammat) /'a'/, resol(vgammat) /tfamily/
      data sum_type(vcmax1) /'g'/, resol(vcmax1) /tfamily/
      data sum_type(vcmax2) /'a'/, resol(vcmax2) /tfamily/
      data sum_type(vcmaxq10) /'a'/, resol(vcmaxq10) /tfamily/
      data sum_type(vcmaxt) /'a'/, resol(vcmaxt) /tfamily/
      data sum_type(vfsat1) /'g'/, resol(vfsat1) /tfamily/
      data sum_type(vfsat2) /'a'/, resol(vfsat2) /tfamily/
      data sum_type(vfsatq10) /'a'/, resol(vfsatq10) /tfamily/
      data sum_type(vfsatt) /'a'/, resol(vfsatt) /tfamily/
      data sum_type(vtsat1) /'g'/, resol(vtsat1) /tfamily/
      data sum_type(vtsat2) /'a'/, resol(vtsat2) /tfamily/
      data sum_type(vtsatq10) /'a'/, resol(vtsatq10) /tfamily/
      data sum_type(vtsatt) /'a'/, resol(vtsatt) /tfamily/
      data sum_type(vassxeff) /'g'/, resol(vassxeff) /tfamily/
      data sum_type(vevac1) /'g'/, resol(vevac1) /tfamily/
      data sum_type(vevac2) /'a'/, resol(vevac2) /tfamily/
      data sum_type(vevac3) /'a'/, resol(vevac3) /tfamily/
      data sum_type(vevacq10) /'a'/, resol(vevacq10) /tfamily/
      data sum_type(vevact) /'a'/, resol(vevact) /tfamily/
      data sum_type(vrq) /'g'/, resol(vrq) /tfamily/
      data sum_type(vox1) /'g'/, resol(vox1) /tfamily/
      data sum_type(vox2) /'a'/, resol(vox2) /tfamily/
      data sum_type(voxq10) /'a'/, resol(voxq10) /tfamily/
      data sum_type(voxt) /'a'/, resol(voxt) /tfamily/
      data sum_type(vcvol1) /'g'/, resol(vcvol1) /tfamily/
      data sum_type(vcvol2) /'a'/, resol(vcvol2) /tfamily/
      data sum_type(vcvolq10) /'a'/, resol(vcvolq10) /tfamily/
      data sum_type(vcvolt) /'a'/, resol(vcvolt) /tfamily/
      data sum_type(vwty1) /'a'/, resol(vwty1) /tgenus/
c
      include 'vdefined.sfn'
c;;
 9110 format (5x,'physiological database: ',a)
 9120 format (' ?? Fgets database file could not be opened.')
 9130 format (' ?? internal database error: pa2 > 0; please report to au
     &thors.')
 9140 format (' ?? Fgets database errors.')
c
c initialize sums and counters for statistical calculations;
c "tspecies:tgeneric" levels of resolution
c
      do jspecies = 1, gnspecies
         do jpar = 1, maxfpar
            do jresol = tspecies, tgeneric
               sxp(jpar, jresol, jspecies) = zero
               nxp(jpar, jresol, jspecies) = 0
            enddo
         enddo
      enddo
c
c open Fgets database
c
      if (zioerror .ne. xfopen(jdb, dbfil, zioread)) then
         inquire (file=dbfil, name=xfull_name)
         nxfn = xslen(xfull_name)
         write (stdout, 9110) xfull_name(1:nxfn)
      else
         write (stdout, 9120)
         write (jerr, 9120)
         errused = .true.
         call errlog(.true., ' ', 0)
      endif
      rewind (unit=jdb)
      read (jdb, *, iostat=ios) ! first record is an id record; skip it.
c
c read ith record set of the Fgets physiological data
c
  110 continue
      call dbread(jdb, xspecies, xgenus, xfamily, xecology, xxp, done, 
     &   nerror)
      if (nerror .gt. 0) then
         write (jerr, 9140)
         errused = .true.
         call errlog(.true., ' ', 0)
      endif
      if ( .not. done) then
         call dbnorm(xxp, nerror)       ! standardize data;           
c
c calculate sums of Xxp(jpar) for species, genus, family, life form, and all
c fish (generic);
c
         do jspecies = 1, gnspecies
            if (xspecies .eq. spplab(jspecies)) then
               call vectsum(maxfpar, xxp, sum_type, 
     &            sxp(1, tspecies, jspecies), 
     &            nxp(1, tspecies, jspecies))
            endif
c
            if (xgenus .eq. genlab(jspecies)) then
               call vectsum(maxfpar, xxp, sum_type, 
     &            sxp(1, tgenus, jspecies), nxp(1, tgenus, jspecies))
            endif
c
            if (xfamily .eq. famlab(jspecies)) then
               call vectsum(maxfpar, xxp, sum_type, 
     &            sxp(1, tfamily, jspecies), nxp(1, tfamily, jspecies))
            endif
c
            nh = xslen(hablab(jspecies))
            if (index(xecology, hablab(jspecies)(1:nh)) .gt. 0) then
               call vectsum(maxfpar, xxp, sum_type, 
     &            sxp(1, tecology, jspecies), 
     &            nxp(1, tecology, jspecies))
            endif
c
            call vectsum(maxfpar, xxp, sum_type, 
     &         sxp(1, tgeneric, jspecies), nxp(1, tgeneric, jspecies))
         enddo
         go to 110
      endif
c
c close Fgets physiological database
c
      call xfclose(jdb)
c
c calculate appropriate mean for physiological parameters;
c note for power function relationships this implies that
c geometric means are calculated for the coefficients and
c arithmetic means are calculated for the exponents.
c
      do jspecies = 1, gnspecies
         do jpar = 1, maxfpar
            xmean = rnoval
            xresol = inoval
            do jresol = resol(jpar), tspecies, -1
               if (nxp(jpar, jresol, jspecies) .gt. 0) then
                  if (sum_type(jpar) .eq. 'g') then
                     xresol = jresol
                     xmean = 10.0 ** (sxp(jpar, jresol, jspecies) / 
     &                  float(nxp(jpar, jresol, jspecies)))
                  elseif (sum_type(jpar) .eq. 'a') then
                     xresol = jresol
                     xmean = sxp(jpar, jresol, jspecies) / 
     &                  float(nxp(jpar, jresol, jspecies))
                  endif
               endif
            enddo
            dbpar(jpar, jspecies) = xmean
            dbtyp(jpar, jspecies) = xresol
         enddo
c
c give default values to the length-wt relationship if none are
c found in the data base; wt = 1.00 * length^3
c
         if ( .not. vdefined(dbpar(vlenwt1, jspecies))) then
            dbpar(vlenwt1, jspecies) = 1.00
            dbtyp(vlenwt1, jspecies) = tgeneric
         endif
         if ( .not. vdefined(dbpar(vlenwt2, jspecies))) then
            dbpar(vlenwt2, jspecies) = 3.00
            dbtyp(vlenwt2, jspecies) = tgeneric
         endif
c
c give default values to the fraction aqueous relationship if none are
c found in the data base; pa(pl) = 0.80 - 1.25 * pl
c see barber, suarez, lassiter. 1991. can. j. fish. aquat. sci. 48: 318-337.
c
         ok = (vdefined(dbpar(vpa1, jspecies))) .or. (
     &      vdefined(dbpar(vpa2, jspecies)))
         if ( .not. ok) then
            dbpar(vpa1, jspecies) = 0.80
            dbtyp(vpa1, jspecies) = tgeneric
            dbpar(vpa2, jspecies) = -1.25
            dbtyp(vpa2, jspecies) = tgeneric
         endif
c
c check: pa2 < 0
c
         if (vdefined(dbpar(vpa2, jspecies))) then
            if (dbpar(vpa2, jspecies) .ge. zero) then
               write (stdout, 9130)
               dbpar(vpa1, jspecies) = rnoval
               dbtyp(vpa1, jspecies) = inoval
               dbpar(vpa2, jspecies) = rnoval
               dbtyp(vpa2, jspecies) = inoval
            endif
         endif
      enddo
c
      return
      end
      subroutine dbread(xjdb, species, genus, family, ecology, xp, 
     &   eofile, nerror)
c
c update: 16:32 fri 4-mar-1994.
c read a record from the database.
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'strings.par'
      include 'idfiles.def'
      include 'dbphysio.par'
      include 'dbrec.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) species, genus, family, ecology
      logical eofile
      integer xjdb, nerror
      real xp( * )
c
      character*(s255) card
      integer nbeg, ncard, nval, kpos, jj, np1, np2, xoffset
      logical fread1, notok
      external fread1
c
 9110 format (1x,
     &   '?? database is corrupted: expecting record with id-number "',
     &   a,'", found: ',/,1x,'   ==>',a,'<==')
 9120 format (1x,
     &   '?? database is corrupted: unexpected Eof: record without "',a,
     &   '"')
 9130 format (1x,'?? database is corrupted: record id-number "',a,
     &   '", expecting ',i3,' values, found ',i3,'; card :',/,1x,
     &   '   ==>',a,'<==')
c
      eofile = .false.
      nerror = 0
      xoffset = len(dbxrecxid(jj)) + 1
c
c read fish's taxonomy
c
      eofile = ( .not. fread1(xjdb, card, ncard))
      if ( .not. eofile) then
c
         ncard = max(1, ncard)
         call up2lo(card, ncard)
         nbeg = index(card, '.') + 1
         if (card(nbeg:nbeg + 1) .ne. dbxrecxid(1)) then
            nerror = 1
            write (stdout, 9110) dbxrecxid(1), card(1:ncard)
            go to 110
         else
            np1 = nbeg + xoffset
            np2 = index(card(np1:), '/') + np1 - 1
            species = card(np1:np2 - 1)
            np1 = np2 + 1
            np2 = index(card(np1:), '/') + np1 - 1
            family = card(np1:np2 - 1)
            np1 = np2 + 1
            np2 = index(species, ' ')
            genus = species(1:np2)
         endif
c
c read reference for this physiological data
c
         eofile = ( .not. fread1(xjdb, card, ncard))
         if (eofile) then
            nerror = 2
            write (stdout, 9120) 'reference'
            go to 110
         endif
c
         ncard = max(1, ncard)
         nbeg = index(card, '.') + 1
         if (card(nbeg:nbeg + 1) .ne. dbxrecxid(2)) then
            nerror = 20
            write (stdout, 9110) dbxrecxid(2), card(1:ncard)
            go to 110
         endif
c
c read rest of the record
c
         do jj = 3, max_db_records
            eofile = ( .not. fread1(xjdb, card, ncard))
            if ( .not. eofile) then
               ncard = max(1, ncard)
               nbeg = index(card, '.') + 1
               if (card(nbeg:nbeg + 1) .eq. dbxrecxid(jj)) then
                  np1 = nbeg + xoffset
                  call uvalues(card, ncard, np1, xp(dbstart(jj)), nval,
     &               kpos, nerror)
                  notok = ((nval .ne. dbvars(jj)) .or. (nerror .ne. 0))
                  if (notok) then
                     nerror = 1
                     write (stdout, 9130) dbxrecxid(jj), dbvars(jj), 
     &                  nval, card(1:ncard)
                     go to 110
                  endif
               else
                  nerror = 1
                  write (stdout, 9110) dbxrecxid(jj), card(1:ncard)
                  go to 110
               endif
            else
               nerror = 1
               write (stdout, 9120) dbxrecxid(jj)
               go to 110
            endif
         enddo
      endif
c
  110 continue
      return
      end
      subroutine dozarg(xbuf, nbuf, zargs, nargs)
c
c purpose:
c    - split the strings in *Xbuf* into arguments (see examples)
c
c updates:
c - [lsr] 11:57 sat 2-apr-1994.
c   . issue message if string is longer that the length of storing
c     variable (after being burned (badly!) several times); should
c     have done this a long time ago.
c - [lsr] wed 14:02 11-nov-1992.
c - processed by SPAG 3.14A  at 14:41 on 26 Oct 1992
c - [LSR] 12:42:31.52 thursday march 10, 1988.
c   1. history: initially a quote character could be any
c      non-alphanumeric; this caused too many problems so, at
c      this time, i am limiting the quote characters to the
c      ones explicitly recognized by the module *isquote* .
c   2. "+" and "-" as command flags (as a result of 1.),
c      as well as any other character *cc* such that
c             isquote(cc) == .false.
c   3. general cleanup
c - oct/85 [LSR]
c
c description of the arguments:
c input:
c    Xbuf  - character*(*) variable with the super string.
c    Nbuf  - number of characters in *Xbuf*
c
c output:
c    nargs  - number of arguments found.
c    zargs  - character*(*) zargs(*) array with the
c             actual arguments.
c
c system dependencies:
c    - none that i am aware off.
c
c plans for the future:
c    - none for the time being
c
c examples:
c    the input string (stored in *Xbuf*) is delimited by ">>" "<<"
c    1) given Xbuf: >>  abc   -i file.ext -ofile.ext <<
c       then:
c          nargs = 4
c          zargs(1) = 'abc'
c          zargs(2) = '-i'
c          zargs(3) = 'file.ext'
c          zargs(4) = '-ofile.ext'
c    2) given Xbuf: >> -m "abc""123"  " c6   "  "$str$  123<<
c       then:
c          nargs = 4
c          zargs(1) = '-m'
c          zargs(2) = '"abc""123"'
c          zargs(3) = '" c6   "'
c          zargs(4) = '"$str$  123'
c    note:
c       . that blanks (or tabs) determine where the strings start
c         and finish;
c       . runs of 1 or more unquoted blanks or tabs compressed
c         to 1 blank.
c       . double the quote if it is part of the string; better
c         yet, use a different quote (e.g. `abc"123`)
c       . quotes are required when the string contains embedded
c         blanks or tabs.
c       . if the trailing quote is missing, the rest of the
c         Xbuf will be taken as the quoted string; note that
c         runs of blanks or tabs will *not* be compressed.
c;;
      include 'xglobal.par'
c
      character*( * ) zargs( * ), xbuf
      integer nargs, nbuf
c
      character*1 delim
      integer npos, nb, ja, nextbl, lenz, tlen
      logical errissued
c
      external nextbl
c
      include 'chars.def'
      include 'chars.sfn'
c
 9110 format ('?? DoZarg: truncation -- increase the length of "Zargs"',
     &   /,'           in your application.')
c
      errissued = .false.
      lenz = len(zargs(1))
c
      nargs = 0
      npos = 1
  110 continue
      if (npos .le. nbuf) then
         if (uwhite(xbuf(npos:npos))) then
            npos = npos + 1
         else
            delim = xbuf(npos:npos)
            if ( .not. isquote(delim)) then
               nb = nextbl(xbuf, nbuf, npos) - 1
               if (nb .le. 0) nb = nbuf
            else
               ja = npos + 1
               nb = index(xbuf(ja:), delim)
               if (nb .gt. 0) then
                  nb = nb + ja - 1
               else
                  nb = nbuf
               endif
            endif
            nargs = nargs + 1
            tlen = nb - npos + 1
            if (tlen .gt. lenz) then
               if ( .not. errissued) then
                  write (zstderr, 9110)
                  errissued = .true.
               endif
            endif
            zargs(nargs) = xbuf(npos:nb)
            npos = nb + 1
         endif
         go to 110
      endif
c
      return
      end
      subroutine dwdtode(kage, kspecies, ztime, nerror)
c
c update: 17:25 fri 4-mar-1994.
c
c this is an interface between the ode driver and the Fgets ode.
c
c ztime:    time (days)
c w(1):   body weight of fish [g live];
c w(2):   foodg; mass of food in stomach [g];
c;;
      include 'xglobal.par'
      include 'fish.par'
      include 'chem.par'
      include 'physio.par'
      include 'errors.par'
      include 'fish.def'
      include 'odevar.def'
      include 'fluxes.def'
      include 'lab.def'
      include 'options.def'
      include 'expos.def'
c
c declaration for arguments
c
      integer kage, kspecies, nerror
      real ztime
c
      integer agep
      logical notdawn
c
c calculate aqueous exposure conditions;
c the only (returnable) error at this time is a warning;
c stop simulation and output results so far.
c
      nerror = tnoerror
      call envget(ztime)
c
c update morphological/physiological parameters at "dawn" ;
c these will stay active (read: constant) for this day unless
c "Xupdate_continuously == true" ;
c
      agep = qq_fish_age(kage, kspecies)
      notdawn = (ztime .lt. qq_new_day(kage, kspecies))
      if (notdawn) then
         if (xupdate_continuously) then
            call kfupdate(kage, kspecies, qq_wt(1, kage, kspecies), 
     &         xcelsius, xplankton_standing_stock)
         endif
      else
         qq_new_day(kage, kspecies) = qq_new_day(kage, kspecies) + tinc
         call kfupdate(kage, kspecies, qq_wt(1, kage, kspecies), 
     &      xcelsius, xplankton_standing_stock)
      endif
c
      call kdwdt(ztime, vv_growth_model(agep, kspecies), 
     &   vv_functional_response(agep, kspecies), 
     &   qq_wgamma(kage, kspecies), qq_phi(kage, kspecies), 
     &   qq_gmax(kage, kspecies), qq_alpha1(kage, kspecies), 
     &   qq_alpha2(kage, kspecies), qq_epsl1(kage, kspecies), 
     &   qq_epsl2(kage, kspecies), qq_mu(kage, kspecies), sigma, nh3n, 
     &   cn, vv_pval(vassxeff, agep, kspecies), 
     &   qq_wt(1, kage, kspecies), qq_dwdt(1, kage, kspecies), 
     &   qq_wingest(kage, kspecies), qq_wassim(kage, kspecies), 
     &   qq_wegest(kage, kspecies), qq_wrespir(kage, kspecies), 
     &   qq_wsda(kage, kspecies), qq_wexcret(kage, kspecies))
c
      return
      end
      subroutine envexam0(wvector, nvals, tdelta, vtime)
c
c update: 17:25 fri 4-mar-1994.
c store points in all arrays -- exams exposure file
c
c vtime:    current time
c tdelta:   difference between the time coordinate of the point to store
c           and the previously stored point.
c
c propagate changes: "Initpgm" "Envexams" "Envexam0" "Webtemp"
c                    "examsrec.def" "iend"
c . size_of (Wvector) == maxvals .ge. number of entries in exams exposure file
c . number of entries in exams exposure file == 3 + 3*n, n == Gnchem
c . format of exams exposure file
c     time temp plankton_stock cw(1:n) benthos_conc(1:n) plankton_conc(1:n)
c                                      cfish_conc(1:n)
c . module "Envexams": character*(329)      card
c   from exams -- exposure file format:
c     - 1x, 1pe12.5, 1x, 0pf5.1, 1x, 1pe9.2, 30(1x,e9.2)
c     - length of line: 29 + 30*n, n = number of chemicals
c     - 329 = 29 + 30 * maxchem
c
c all errors are fatal.
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'numbers.par'
      include 'habitat.par'
      include 'idfiles.def'
      include 'globpar.def'
      include 'habitat.def'
      include 'examsrec.def'
      include 'units.def'
c
c module arguments
c
      real wvector( * ), tdelta, vtime
      integer nvals
c
      integer nn, xslen, jchem, nv0, nv1, jj
      external xslen
c
      include 'circlist.sfn'
c
 9110 format (' ?? Envexam0: exams exposure file "',a,'"; line ',i7,/,
     &   '    expecting ',i7,' numbers, found ',i7)
 9120 format (' ?? Envexam0: exams exposure file "',a,'"',/,
     &   '    point ',i7,' is out of sequence.')
c
c *** REMEMBER: Exams does not provide Cfish information;
c
      nf1 = nf1 + 1
      nf2 = nf1
      nf3 = nf1
ccc      Nf4 = Nf1
c
      nv1 = v2r(maxptenv, nf1)
      nv0 = v2r(maxptenv - 1, nf1)
c
      if (nvals .ne. ptotal) then
         nn = xslen(cwfil)
         write (stdout, 9110) cwfil(1:nn), nf1, ptotal, nvals
         write (jerr, 9110) cwfil(1:nn), nf1, ptotal, nvals
         errused = .true.
         call errlog(.true., ' ', 0)
      endif
c
c set time in all arrays
c
      vtime = t_conv * wvector(ptime) + f1base_time
      f1time(nv1) = vtime
      f2time(nv1) = vtime
      f3time(nv1) = vtime
ccc      F4time (nv1) = vtime
      tdelta = vtime - f1time(nv0)
c
      f1celsius(nv1) = wvector(ptemp)
      f2plankton_standing_stock(nv1) = wvector(ppss)
c
      do jchem = 1, gnchem
         jj = jchem - 1
         f1chem_water(jchem, nv1) = cw_conv * wvector(pcw + jj)
         f2chem_plankton(jchem, nv1) = cf_conv * wvector(pcp + jj)
         f3chem_benthos(jchem, nv1) = cf_conv * wvector(pcb + jj)
ccc         F4chem_cfish   (jchem,nv1) = Cf_conv * Wvector(pcf + jj)
      enddo
c
      if (nf1 .gt. 1) then
         if (tdelta .lt. zero) then
            nn = xslen(cwfil)
            write (stdout, 9120) cwfil(1:nn), nf1
            write (jerr, 9120) cwfil(1:nn), nf1
            errused = .true.
            call errlog(.true., ' ', 0)
         endif
      endif
c
      return
      end
      subroutine envexams(xtime, xfound, fxm0, fxm1, eofile)
c
c update: 11:45 fri 9-sep-1994.
c
c get next time interval from the exams exposure file until we hit "Xtime"
c if Xtime == rnoval then read one point and return;
c else read until Xtime is found.
c
c ftime: time just read from file
c assumes Xtime > fxtime ("most recent entry")  ! not anymore! tue 2-apr-1991.
c
c we are at the beginning of an interval;
c read the exposure file and return tbeg, tfin
c
c example: consider the file
c
c     time     temperature    concentration
c     ----     -----------    -------------
c      0           10           105.5
c      1           10           115.5
c      2           10           125.5
c      3           10           135.5              ! double point
c      3           10           185.5              ! double point
c      4           10           140.0
c      5           10           155.5
c      9           10           195.5
c
c the file will drive the integration;   it is assumed the file is rewound;
c example:
c
c     call Envexams(tbeg, tfin)
c        reads 2 points from the file;
c        returns tbeg == 0 and tfin == 1; global variables for environmental
c        temperature and concentration are set to 10 and 105.5 respectively;
c        user should integrate in the interval [tbeg, tfin];
c
c     call Envexams(tbeg, tfin)
c        returns tbeg == 1 and tfin == 2; global variables for environmental
c        temperature and concentration are set to 10 and 115.5 respectively;
c
c     call Envexams(tbeg, tfin)
c        returns tbeg == 2 and tfin == 3; global variables for environmental
c        temperature and concentration are set to 10 and 125.5 respectively;
c
c     call Envexams(tbeg, tfin)
c        returns tbeg == 3 and tfin == 4; global variables for environmental
c        temperature and concentration are set to 10 and 185.5 respectively;
c        note the spike;
c
c     etc.
c
c --------------------------------------------------------------------------
c the logic is a little involved, so it will be implemented using a
c state-variable approach;
c [initially the logic was involved; now it is almost trivial]
c
c note:
c . all states require a "read point";
c . entry states: 1 (very first point) or 3 (subsequent points);
c . 2510 is the normal exit (no errors detected this time);
c . 3110 end-of-file detected;
c . state 2 is very similar to state 4; we will leave them separate
c   for the time being;
c . by the time states [2, 3, 4] are reached, "not_equal_pts" is defined;
c
c xstate == 0: terminate;
c
c xstate == 1: read the very first point;
c              xstate = 2;
c
c xstate == 2: read another point;
c              if ("previous point" <> "current point") then
c                 xstate = 0
c              else
c                 error "no spikes at the beginning"
c              endif
c
c xstate == 3: read another point;
c              end-of-file is valid only at this level;
c              if ("previous point" <> "current point") then
c                    !
c                    ! this point may be used as the end of the interval;
c                    !
c                 xstate = 0
c              else  ! spike;
c                    ! get another point; it better not be a duplicate;
c                    !
c                 xstate = 4
c              endif
c
c xstate == 4: read another point;
c              if ("previous point" <> "current point") then
c                 xstate = 0
c              else                 ! another spike;
c                 error "no more than 2 consecutive spikes allowed"
c              endif
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'habitat.par'
      include 'noval.par'
      include 'numbers.par'
      include 'ode.par'
      include 'phylum.par'
      include 'plots.par'
c
      include 'globpar.def'
      include 'habitat.def'
      include 'idfiles.def'
      include 'lab.def'
      include 'ode.def'
      include 'work.def'
c
c module arguments
c
      real xtime
      integer fxm0, fxm1
      logical xfound, eofile
c
      character*(329) card
      real tdelta, ftime, tlow, tupp
      integer xslen, nn, ncard, nvals, npos, ios
      integer xstate, nerror, maxm, jm0, jm1, npk, eolcom
      logical not_equal_pts, treq, trne
      external xslen, treq, eolcom, trne
c
 9110 format (' ?? Envexams: exposure file "',a,
     &   '" ; initial double spike not allowed.')
 9120 format (' ?? Envexams: exposure file "',a,'"',/,
     &   '    more than 2 consecutive spikes detected at line ',i7)
 9130 format (' ?? Envexams: empty exposure file "',a,'"')
 9140 format (' ?? Envexams: unexpected end of file in "',a,'"')
 9150 format (' ?? Envexams: line too long in exams exposure file "',a,
     &   '"')
c
      include 'circlist.sfn'
c
c if Xtime < lowest recorded time we must rewind.
c use cwater arrays for time.
c
      if (trne(xtime, rnoval)) then
         maxm = min(maxptenv, nf1)
         jm0 = v2r(maxptenv - maxm + 1, nf1)
         tlow = f1time(jm0) * (one - mach_eps)
c
         if (xtime .lt. tlow) then
            rewind (unit=jcw)
            nf1 = 0
         endif
      endif
c
      xfound = .false.
      eofile = .false.
      nerror = 0
      fxm0 = inoval
      fxm1 = inoval
c
  110 continue
      if (nf1 .gt. 0) then
         xstate = 3
      else
         xstate = 1
      endif
c
c propagate changes: "Initpgm" "Envexams" "Envexam0" "Webtemp" "examsrec.def" "iend"
c . size_of (Wvector) == maxvals .ge. number of entries in exams exposure file
c . number of entries in exams exposure file == 3 + 3*n, n == Gnchem
c . format of exams exposure file
c     time temp plankton_stock cw(1:n) benthos_conc(1:n) plankton_conc(1:n)
c                                      cfish_conc(1:n)
c . module "Envexams": character*(329)      card
c   from exams -- exposure file format:
c     - 1x, 1pe12.5, 1x, 0pf5.1, 1x, 1pe9.2, 30(1x,e9.2)
c     - length of line: 29 + 30*n, n = number of chemicals
c     - 329 = 29 + 30 * maxchem
c
      ncard = 29 + 30 * gnchem
      if (ncard .gt. len(card)) then
         nn = xslen(cwfil)
         write (stdout, 9150) cwfil(1:nn)
         write (jerr, 9150) cwfil(1:nn)
         errused = .true.
         call errlog(.true., ' ', 0)
      endif
c
  120 continue  ! repeat until Xtime found             
      if (xstate .ne. 0) then
         read (jcw, '(q,a)', end=190, iostat=ios) ncard, 
     &      card(1:max(ncard, 1))
         ncard = xslen(card(1:max(ncard, 1)))
         npk = eolcom(card, ncard, 1)
         if (npk .gt. 0) then
            card(npk:ncard) = ' '
            ncard = xslen(card(1:npk))
            if (ncard .le. 0) go to 120
         endif
         call uvalues(card, ncard, 1, wvector, nvals, npos, nerror)
         call envexam0(wvector, nvals, tdelta, ftime)
c
         if (nf1 .gt. 1) then
            not_equal_pts = (tdelta .gt. zero)
         endif
c
         go to (130, 140, 150, 160), xstate     ! case statement.    
  130    continue       ! xstate == 1        
         xstate = 2
         go to 170      ! "break"            
c
  140    continue       ! xstate == 2        
         if (not_equal_pts) then
            xstate = 0  ! done               
         else
            nn = xslen(cwfil)
            write (stdout, 9110) cwfil(1:nn)
            write (jerr, 9110) cwfil(1:nn)
            errused = .true.
            call errlog(.true., ' ', 0)
         endif
         go to 170      ! "break"            
c
  150    continue       ! xstate == 3        
         if (not_equal_pts) then
            xstate = 0  ! done               
         else
            xstate = 4
         endif
         go to 170      ! "break"            
c
  160    continue       ! xstate == 4        
         if (not_equal_pts) then
            xstate = 0
         else
            nn = xslen(cwfil)
            write (stdout, 9120) cwfil(1:nn), nf1
            write (jerr, 9120) cwfil(1:nn), nf1
            errused = .true.
            call errlog(.true., ' ', 0)
         endif
         go to 170      ! "break"            
c
  170    continue
         go to 120
      endif
      if (treq(xtime, rnoval)) then
         xfound = (.true.)
      else
         xfound = (xtime .le. ftime)
      endif
      if ( .not. xfound) go to 110
      fxm1 = v2r(maxptenv, nf1)
      fxm0 = v2r(maxptenv - 1, nf1)
c
  180 continue
      return
c
c --------------------------------------------------------------------------
  190 continue
      if (xstate .eq. 3) then   ! shift time values of file
         jm1 = v2r(maxptenv, nf1)
         tupp = f1time(jm1) * (one + 2 * mach_eps)
         f1base_time = tupp
         rewind (unit=jcw)
         go to 120
ccc         eofile = .true.
ccc         go to 2510
      elseif (xstate .eq. 1) then       ! empty file.        
         nn = xslen(cwfil)
         write (stdout, 9130) cwfil(1:nn)
         write (jerr, 9130) cwfil(1:nn)
         errused = .true.
      else
         nn = xslen(cwfil)
         write (stdout, 9140) cwfil(1:nn)
         write (jerr, 9140) cwfil(1:nn)
         errused = .true.
      endif
      call errlog(.true., ' ', 0)
c
      end
      subroutine envget(atime)
c
c update: 17:25 fri 4-mar-1994.
c provide complete environmental information at time atime;
c all info will be returned in a common block;
c all errors are fatal.
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'plots.par'
      include 'chem.par'
      include 'fish.par'
      include 'phylum.par'
      include 'simul.par'
      include 'habitat.par'
      include 'expos.par'
      include 'idfiles.def'
      include 'globpar.def'
      include 'odevar.def'
      include 'habitat.def'
      include 'expos.def'
      include 'options.def'
      include 'work.def'
      include 'examsrec.def'
c
c module arguments
c
      real atime
c
      logical wfound, eofile
      integer f1m0, f1m1, f2m0, f2m1, f3m0, f3m1, f4m0, f4m1, nlen, 
     &   xslen
      integer jchem, nfile
      real pslope, kfplankton, kfbenthos, kfcfish, exx, sineeval
      external xslen, exx, sineeval
c
 9110 format (' ?? Envget: could not find time = ',1pg10.3,' in ',a,
     &   ' file "',a,'".')
c
      xtime = atime
      xnerror = 0
c
c if (Xfcelsius) then we need only the environmental temperature (centigrade)
c
      if (xfcelsius) then
         if (twfunc .eq. tconstant) then
            xcelsius = twpar(1)
         elseif (twfunc .eq. tsin) then
            xcelsius = twpar(1) + twpar(2) * 
     &         sin(twpar(3) * xtime + twpar(4))
         elseif (twfunc .eq. tfile) then
            xcelsius = sineeval(aatw, bbtw, a0tw, a1tw, bktw, mtw, xtime
     &         )
         endif
c
c compute plankton standing stock (grams / L)
c
         if (xplankton) then
            if (plankton_standing_stock_func .eq. tconstant) then
               xplankton_standing_stock = plankton_standing_stock_conc
            elseif (plankton_standing_stock_func .eq. tfile) then
               xplankton_standing_stock = 
     &            sineeval(aapss, bbpss, a0pss, a1pss, bkpss, mpss, 
     &            xtime)
            endif
         endif
         go to 120
      endif
c
c if (Xexams) then all the info is in ONE file.
c set correct interval and jump to evaluation.
c
      if (xexams) then
         call envtime(xtime, nf1, f1time, wfound, f1m0, f1m1)
         if ( .not. wfound) then
            call envexams(xtime, wfound, f1m0, f1m1, eofile)
            if ( .not. wfound) then
               nlen = xslen(cwfil)
               write (stdout, 9110) xtime, 'exams file', 
     &            cwfil(1:nlen)
               write (jerr, 9110) xtime, 'exams file', cwfil(1:nlen)
               errused = .true.
               call errlog(.true., ' ', 0)
            endif
         endif
         f2m0 = f1m0
         f2m1 = f1m1
         f3m0 = f1m0
         f3m1 = f1m1
         go to 110
      endif
c
c else, if reading from a file, set correct interval for the appropriate file.
c we could use an "elseif" but i have too many indentation levels already.
c
      if (iread_cw .ne. tfxnoread) then
         call envtime(xtime, nf1, f1time, wfound, f1m0, f1m1)
         if ( .not. wfound) then
            nfile = 1
            call envread(xtime, nfile, wfound, f1m0, f1m1, eofile)
            if ( .not. wfound) then
               nlen = xslen(cwfil)
               write (stdout, 9110) xtime, 'cwater', cwfil(1:nlen)
               write (jerr, 9110) xtime, 'cwater', cwfil(1:nlen)
               errused = .true.
               call errlog(.true., ' ', 0)
            endif
         endif
      endif
c
      if (iread_plankton .ne. tfxnoread) then
         call envtime(xtime, nf2, f2time, wfound, f2m0, f2m1)
         if ( .not. wfound) then
            nfile = 2
            call envread(xtime, nfile, wfound, f2m0, f2m1, eofile)
            if ( .not. wfound) then
               nlen = xslen(planktonfil)
               write (stdout, 9110) xtime, 'plankton', 
     &            planktonfil(1:nlen)
               write (jerr, 9110) xtime, 'plankton', 
     &            planktonfil(1:nlen)
               errused = .true.
               call errlog(.true., ' ', 0)
            endif
         endif
      endif
c
      if (iread_benthos .ne. tfxnoread) then
         call envtime(xtime, nf3, f3time, wfound, f3m0, f3m1)
         if ( .not. wfound) then
            nfile = 3
            call envread(xtime, nfile, wfound, f3m0, f3m1, eofile)
            if ( .not. wfound) then
               nlen = xslen(benthosfil)
               write (stdout, 9110) xtime, 'benthos', 
     &            benthosfil(1:nlen)
               write (jerr, 9110) xtime, 'benthos', 
     &            benthosfil(1:nlen)
               errused = .true.
               call errlog(.true., ' ', 0)
            endif
         endif
      endif
c
      if (iread_cfish .ne. tfxnoread) then
         call envtime(xtime, nf4, f4time, wfound, f4m0, f4m1)
         if ( .not. wfound) then
            nfile = 4
            call envread(xtime, nfile, wfound, f4m0, f4m1, eofile)
            if ( .not. wfound) then
               nlen = xslen(cfishfil)
               write (stdout, 9110) xtime, 'cfish', cfishfil(1:nlen)
               write (jerr, 9110) xtime, 'cfish', cfishfil(1:nlen)
               errused = .true.
               call errlog(.true., ' ', 0)
            endif
         endif
      endif
c
c compute environmental temperature (centigrade)
c
  110 continue
      if (twfunc .eq. tconstant) then
         xcelsius = twpar(1)
      elseif (twfunc .eq. tsin) then
         xcelsius = twpar(1) + twpar(2) * 
     &      sin(twpar(3) * xtime + twpar(4))
      elseif (twfunc .eq. tfile) then
         pslope = (f1celsius(f1m1) - f1celsius(f1m0)) / (f1time(f1m1) -
     &      f1time(f1m0))
         xcelsius = pslope * (xtime - f1time(f1m0)) + f1celsius(f1m0)
      endif
c
c compute concentration of chemical in water (ppm)
c
      do jchem = 1, gnchem
         if (cwfunc(jchem) .eq. tconstant) then
            xchem_in_water(jchem) = cwpar(1, jchem)
c
         elseif (cwfunc(jchem) .eq. tsin) then
            xchem_in_water(jchem) = cwpar(1, jchem) + cwpar(2, jchem) *
     &         sin(cwpar(3, jchem) * xtime + cwpar(4, jchem))
c
         elseif (cwfunc(jchem) .eq. texp) then
            xchem_in_water(jchem) = cwpar(1, jchem) + cwpar(2, jchem) *
     &         exx(cwpar(3, jchem) * xtime)
c
         elseif (cwfunc(jchem) .eq. tfile) then
            pslope = (f1chem_water(jchem, f1m1) - 
     &         f1chem_water(jchem, f1m0)) / (f1time(f1m1) - 
     &         f1time(f1m0))
            xchem_in_water(jchem) = pslope * (xtime - f1time(f1m0)) + 
     &         f1chem_water(jchem, f1m0)
         endif
      enddo
c
c compute plankton standing stock (grams / L)
c
      if (xplankton) then
         if (plankton_standing_stock_func .eq. tconstant) then
            xplankton_standing_stock = plankton_standing_stock_conc
         elseif (plankton_standing_stock_func .eq. tfile) then
            pslope = (f2plankton_standing_stock(f2m1) - 
     &         f2plankton_standing_stock(f2m0)) / (f2time(f2m1) - 
     &         f2time(f2m0))
            xplankton_standing_stock = pslope * (xtime - f2time(f2m0)) +
     &         f2plankton_standing_stock(f2m0)
         endif
      endif
c
c compute concentration of chemical in plankton (ppm)
c
      if (xplankton) then
         do jchem = 1, gnchem
            if (plankton_chem_func .eq. tconstant) then
               xchem_in_plankton(jchem) = plankton_chem_conc(jchem)
c
            elseif (plankton_chem_func .eq. tequilibrium) then
               kfplankton = plankton_pl * kl(jchem)
               xchem_in_plankton(jchem) = xchem_in_water(jchem) * 
     &            kfplankton * plankton_bmf(jchem)
c
            elseif (plankton_chem_func .eq. tfile) then
               pslope = (f2chem_plankton(jchem, f2m1) - 
     &            f2chem_plankton(jchem, f2m0)) / (f2time(f2m1) - 
     &            f2time(f2m0))
               xchem_in_plankton(jchem) = pslope * (xtime - 
     &            f2time(f2m0)) + f2chem_plankton(jchem, f2m0)
            endif
         enddo
      endif
c
c compute concentration of chemical in benthos (ppm)
c
      if (xbenthos) then
         do jchem = 1, gnchem
            if (benthos_chem_func .eq. tconstant) then
               xchem_in_benthos(jchem) = benthos_chem_conc(jchem)
c
            elseif (benthos_chem_func .eq. tequilibrium) then
               kfbenthos = benthos_pl * kl(jchem)
               xchem_in_benthos(jchem) = xchem_in_water(jchem) * 
     &            kfbenthos * benthos_bmf(jchem)
c
            elseif (benthos_chem_func .eq. tfile) then
               pslope = (f3chem_benthos(jchem, f3m1) - 
     &            f3chem_benthos(jchem, f3m0)) / (f3time(f3m1) - 
     &            f3time(f3m0))
               xchem_in_benthos(jchem) = pslope * (xtime - f3time(f3m0))
     &            + f3chem_benthos(jchem, f3m0)
            endif
         enddo
      endif
c
c compute concentration of chemical in cfish (ppm)
c
      if (xcfish) then
         do jchem = 1, gnchem
            if (cfish_chem_func .eq. tconstant) then
               xchem_in_cfish(jchem) = cfish_chem_conc(jchem)
c
            elseif (cfish_chem_func .eq. tequilibrium) then
               kfcfish = cfish_pl * kl(jchem)
               xchem_in_cfish(jchem) = xchem_in_water(jchem) * kfcfish *
     &            cfish_bmf(jchem)
c
            elseif (cfish_chem_func .eq. tfile) then
               pslope = (f4chem_cfish(jchem, f4m1) - 
     &            f4chem_cfish(jchem, f4m0)) / (f4time(f4m1) - 
     &            f4time(f4m0))
               xchem_in_cfish(jchem) = pslope * (xtime - f4time(f4m0)) +
     &            f4chem_cfish(jchem, f4m0)
            endif
         enddo
      endif
c
  120 continue
      return
      end
      subroutine envinit(no_errors)
c
c update: 16:00 tue 5-apr-1994.
c
c if exposure scenarios are supplied by an user file, this subroutine
c opens that file and checks that minimal information is given; it also
c initializes variables for mean water concentration & temperature
c computations.
c all errors are fatal;
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'numbers.par'
      include 'simul.par'
      include 'expos.par'
      include 'habitat.par'
      include 'idfiles.def'
      include 'globpar.def'
      include 'options.def'
      include 'chemp.def'
      include 'habitat.def'
      include 'examsrec.def'
c
c module arguments
c
      logical no_errors
c
      integer xslen, nss, xfopen, jchem, ncw, junit
      logical isopen
      external xfopen, xslen
c
 9110 format (' ?? Envinit: cannot open ',a,' file "',a,'"')
c
      no_errors = .true.
      f1base_time = zero
      f2base_time = zero
      f3base_time = zero
      nf1 = 0
      nf2 = 0
      nf3 = 0
c
      if (xexams) then
         if (cwfil .eq. infil) then
            call errlog(.true., 
     &         '?? same files used for input and exams exposure!', 
     &         -1)
         endif
c
         inquire (file=cwfil, opened=isopen, number=junit)
         if (isopen) then
            if (jcw .eq. junit) then
               rewind (unit=jcw)
            else
               call errlog(.true., 
     &            '?? incorrect file pointer for cwater', -1)
            endif
         else
            if (zioerror .eq. xfopen(jcw, cwfil, zioread)) then
               nss = xslen(cwfil)
               write (stdout, 9110) 'cwater', cwfil(1:nss)
               write (jerr, 9110) 'cwater', cwfil(1:nss)
               errused = .true.
               call errlog(.true., ' ', 0)
            endif
         endif
         go to 110
      endif
c
c
      ncw = 0   ! ncw > 0 ==> "file" selected for some chemical/temperature
      do jchem = 1, gnchem
         if (cwfunc(jchem) .eq. tfile) ncw = ncw + 1
      enddo
      if (twfunc .eq. tfile) ncw = ncw + 1
c
      if (ncw .gt. 0) then
         iread_cw = tf1func
         if (cwfil .eq. infil) then
            call errlog(.true., 
     &         '?? same files used for input and water exposure!', 
     &         -1)
         endif
      else
         iread_cw = tfxnoread
      endif
c
      if (plankton_chem_func .eq. tfile) then
         if (plankton_standing_stock_func .eq. tfile) then
            iread_plankton = tf2both
         else
            iread_plankton = tf2func
         endif
         if (planktonfil .eq. infil) then
            call errlog(.true., 
     &         '?? same files used for input and plankton exposure!', 
     &         -1)
         endif
      else
         if (plankton_standing_stock_func .eq. tfile) then
            iread_plankton = tf2stock
         else
            iread_plankton = tfxnoread
         endif
      endif
c
      if (benthos_chem_func .eq. tfile) then
         iread_benthos = tf3func
         if (benthosfil .eq. infil) then
            call errlog(.true., 
     &         '?? same files used for input and benthos exposure!', 
     &         -1)
         endif
      else
         iread_benthos = tfxnoread
      endif
c
      if (cfish_chem_func .eq. tfile) then
         iread_cfish = tf4func
         if (cfishfil .eq. infil) then
            call errlog(.true., 
     &         '?? same files used for input and cfish exposure!', 
     &         -1)
         endif
      else
         iread_cfish = tfxnoread
      endif
c
c i may need to read the files several times;
c open files once, rewind pro re nata.
c
      if (iread_cw .ne. tfxnoread) then
         inquire (file=cwfil, opened=isopen, number=junit)
         if (isopen) then
            if (jcw .eq. junit) then
               rewind (unit=jcw)
            else
               call errlog(.true., 
     &            '?? incorrect file pointer for cwater', -1)
            endif
         else
            if (zioerror .eq. xfopen(jcw, cwfil, zioread)) then
               nss = xslen(cwfil)
               write (stdout, 9110) 'cwater', cwfil(1:nss)
               write (jerr, 9110) 'cwater', cwfil(1:nss)
               errused = .true.
               call errlog(.true., ' ', 0)
            endif
         endif
      endif
c
      if (iread_plankton .ne. tfxnoread) then
         inquire (file=planktonfil, opened=isopen, number=junit)
         if (isopen) then
            if (jplankton .eq. junit) then
               rewind (unit=jplankton)
            else
               call errlog(.true., 
     &            '?? incorrect file pointer for plankton', -1)
            endif
         else
            if (zioerror .eq. xfopen(jplankton, planktonfil, zioread)) 
     &         then
               nss = xslen(planktonfil)
               write (stdout, 9110) 'plankton', planktonfil(1:nss)
               write (jerr, 9110) 'plankton', planktonfil(1:nss)
               errused = .true.
               call errlog(.true., ' ', 0)
            endif
         endif
      endif
c
      if (iread_benthos .ne. tfxnoread) then
         inquire (file=benthosfil, opened=isopen, number=junit)
         if (isopen) then
            if (jbenthos .eq. junit) then
               rewind (unit=jbenthos)
            else
               call errlog(.true., 
     &            '?? incorrect file pointer for benthos', -1)
            endif
         else
            if (zioerror .eq. xfopen(jbenthos, benthosfil, zioread)) 
     &         then
               nss = xslen(benthosfil)
               write (stdout, 9110) 'benthos', benthosfil(1:nss)
               write (jerr, 9110) 'benthos', benthosfil(1:nss)
               errused = .true.
               call errlog(.true., ' ', 0)
            endif
         endif
      endif
c
      if (iread_cfish .ne. tfxnoread) then
         inquire (file=cfishfil, opened=isopen, number=junit)
         if (isopen) then
            if (jcfish .eq. junit) then
               rewind (unit=jcfish)
            else
               call errlog(.true., 
     &            '?? incorrect file pointer for cfish', -1)
            endif
         else
            if (zioerror .eq. xfopen(jcfish, cfishfil, zioread)) then
               nss = xslen(cfishfil)
               write (stdout, 9110) 'cfish', cfishfil(1:nss)
               write (jerr, 9110) 'cfish', cfishfil(1:nss)
               errused = .true.
               call errlog(.true., ' ', 0)
            endif
         endif
      endif
c
  110 continue
      return
      end
      subroutine envread(xtime, nfile, xfound, fxm0, fxm1, eofile)
c
c update: 11:45 fri 9-sep-1994.
c
c get next time interval from the exposure file until we hit "Xtime"
c nfile == 1: cwater file
c nfile == 2: plankton file
c nfile == 3: benthos file
c nfile == 4: cfish file
c if Xtime == rnoval then read one point and return;
c else read until Xtime is found.
c
c ftime: time just read from file
c assumes Xtime > fxtime ("most recent entry")  ! not anymore! tue 2-apr-1991.
c
c we are at the beginning of an interval;
c read the exposure file and return tbeg, tfin
c
c example: consider the file
c
c     time     temperature    concentration
c     ----     -----------    -------------
c      0           10           105.5
c      1           10           115.5
c      2           10           125.5
c      3           10           135.5              ! double point
c      3           10           185.5              ! double point
c      4           10           140.0
c      5           10           155.5
c      9           10           195.5
c
c the file will drive the integration;   it is assumed the file is rewound;
c example:
c
c     call Envread(tbeg, tfin)
c        reads 2 points from the file;
c        returns tbeg == 0 and tfin == 1; global variables for environmental
c        temperature and concentration are set to 10 and 105.5 respectively;
c        user should integrate in the interval [tbeg, tfin];
c
c     call Envread(tbeg, tfin)
c        returns tbeg == 1 and tfin == 2; global variables for environmental
c        temperature and concentration are set to 10 and 115.5 respectively;
c
c     call Envread(tbeg, tfin)
c        returns tbeg == 2 and tfin == 3; global variables for environmental
c        temperature and concentration are set to 10 and 125.5 respectively;
c
c     call Envread(tbeg, tfin)
c        returns tbeg == 3 and tfin == 4; global variables for environmental
c        temperature and concentration are set to 10 and 185.5 respectively;
c        note the spike;
c
c     etc.
c
c --------------------------------------------------------------------------
c the logic is a little involved, so it will be implemented using a
c state-variable approach;
c [initially the logic was involved; now it is almost trivial]
c
c note:
c . all states require a "read point";
c . entry states: 1 (very first point) or 3 (subsequent points);
c . 2510 is the normal exit (no errors detected this time);
c . 3110 end-of-file detected;
c . state 2 is very similar to state 4; we will leave them separate
c   for the time being;
c . by the time states [2, 3, 4] are reached, "not_equal_pts" is defined;
c
c xstate == 0: terminate;
c
c xstate == 1: read the very first point;
c              xstate = 2;
c
c xstate == 2: read another point;
c              if ("previous point" <> "current point") then
c                 xstate = 0
c              else
c                 error "no spikes at the beginning"
c              endif
c
c xstate == 3: read another point;
c              end-of-file is valid only at this level;
c              if ("previous point" <> "current point") then
c                    !
c                    ! this point may be used as the end of the interval;
c                    !
c                 xstate = 0
c              else  ! spike;
c                    ! get another point; it better not be a duplicate;
c                    !
c                 xstate = 4
c              endif
c
c xstate == 4: read another point;
c              if ("previous point" <> "current point") then
c                 xstate = 0
c              else                 ! another spike;
c                 error "no more than 2 consecutive spikes allowed"
c              endif
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'habitat.par'
      include 'noval.par'
      include 'numbers.par'
      include 'ode.par'
      include 'phylum.par'
      include 'plots.par'
      include 'strings.par'
c
      include 'habitat.def'
      include 'idfiles.def'
      include 'lab.def'
      include 'ode.def'
      include 'work.def'
c
c module arguments
c
      real xtime
      integer nfile, fxm0, fxm1
      logical xfound, eofile
c
      character*(s255) card
      real tdelta, ftime, tlow, tupp
      integer xslen, nn, ncard, nvals, npos, ios
      integer xstate, nerror, maxm, jm0, jm1, npk, eolcom
      logical not_equal_pts, treq, trne
      external xslen, treq, eolcom, trne
c
 9110 format (' ?? Envread: exposure file "',a,
     &   '" ; initial double spike not allowed.')
 9120 format (' ?? Envread: exposure file "',a,'"',/,
     &   '    more than 2 consecutive spikes detected at line ',i7)
 9130 format (' ?? Envread: empty exposure file "',a,'"')
 9140 format (' ?? Envread: unexpected end of file in "',a,'"')
c
      include 'circlist.sfn'
c
c if Xtime < lowest recorded time we must rewind.
c
      if (trne(xtime, rnoval)) then
         maxm = min(maxptenv, nfx(nfile))
         jm0 = v2r(maxptenv - maxm + 1, nfx(nfile))
         if (nfile .eq. 1) then
            tlow = f1time(jm0) * (one - mach_eps)
         elseif (nfile .eq. 2) then
            tlow = f2time(jm0) * (one - mach_eps)
         elseif (nfile .eq. 3) then
            tlow = f3time(jm0) * (one - mach_eps)
         elseif (nfile .eq. 4) then
            tlow = f4time(jm0) * (one - mach_eps)
         endif
c
         if (xtime .lt. tlow) then
            rewind (unit=jfx(nfile))
            nfx(nfile) = 0
         endif
      endif
c
      xfound = .false.
      eofile = .false.
      nerror = 0
      fxm0 = inoval
      fxm1 = inoval
c
  110 continue
      if (nfx(nfile) .gt. 0) then
         xstate = 3
      else
         xstate = 1
      endif
c
  120 continue  ! repeat until Xtime found             
      if (xstate .ne. 0) then
         read (jfx(nfile), '(a)', end=190, iostat=ios) card
         ncard = xslen(card)
         npk = eolcom(card, ncard, 1)
         if (npk .gt. 0) then
            card(npk:ncard) = ' '
            ncard = xslen(card(1:npk))
            if (ncard .le. 0) go to 120
         endif
         call uvalues(card, ncard, 1, wvector, nvals, npos, nerror)
         call envstore(nfile, wvector, nvals, tdelta, ftime)
c
         if (nfx(nfile) .gt. 1) then
            not_equal_pts = (tdelta .gt. zero)
         endif
c
         go to (130, 140, 150, 160), xstate     ! case statement.    
  130    continue       ! xstate == 1        
         xstate = 2
         go to 170      ! "break"            
c
  140    continue       ! xstate == 2        
         if (not_equal_pts) then
            xstate = 0  ! done               
         else
            nn = xslen(fxfil(nfile))
            write (stdout, 9110) fxfil(nfile)(1:nn)
            write (jerr, 9110) fxfil(nfile)(1:nn)
            errused = .true.
            call errlog(.true., ' ', 0)
         endif
         go to 170      ! "break"            
c
  150    continue       ! xstate == 3        
         if (not_equal_pts) then
            xstate = 0  ! done               
         else
            xstate = 4
         endif
         go to 170      ! "break"            
c
  160    continue       ! xstate == 4        
         if (not_equal_pts) then
            xstate = 0
         else
            nn = xslen(fxfil(nfile))
            write (stdout, 9120) fxfil(nfile)(1:nn), nfx(nfile)
            write (jerr, 9120) fxfil(nfile)(1:nn), nfx(nfile)
            errused = .true.
            call errlog(.true., ' ', 0)
         endif
         go to 170      ! "break"            
c
  170    continue
         go to 120
      endif
      if (treq(xtime, rnoval)) then
         xfound = (.true.)
      else
         xfound = (xtime .le. ftime)
      endif
      if ( .not. xfound) go to 110
      fxm1 = v2r(maxptenv, nfx(nfile))
      fxm0 = v2r(maxptenv - 1, nfx(nfile))
c
  180 continue
      return
c
c --------------------------------------------------------------------------
  190 continue
      if (xstate .eq. 3) then   ! shift time values of file
         if (nfile .eq. 1) then
            jm1 = v2r(maxptenv, nfx(nfile))
            tupp = f1time(jm1) * (one + 2 * mach_eps)
            f1base_time = tupp
         elseif (nfile .eq. 2) then
            jm1 = v2r(maxptenv, nfx(nfile))
            tupp = f2time(jm1) * (one + 2 * mach_eps)
            f2base_time = tupp
         elseif (nfile .eq. 3) then
            jm1 = v2r(maxptenv, nfx(nfile))
            tupp = f3time(jm1) * (one + 2 * mach_eps)
            f3base_time = tupp
         elseif (nfile .eq. 4) then
            jm1 = v2r(maxptenv, nfx(nfile))
            tupp = f4time(jm1) * (one + 2 * mach_eps)
            f4base_time = tupp
         endif
         rewind (unit=jfx(nfile))
         go to 120
ccc         eofile = .true.
ccc         go to 2510
      elseif (xstate .eq. 1) then       ! empty file.        
         nn = xslen(fxfil(nfile))
         write (stdout, 9130) fxfil(nfile)(1:nn)
         write (jerr, 9130) fxfil(nfile)(1:nn)
         errused = .true.
      else
         nn = xslen(fxfil(nfile))
         write (stdout, 9140) fxfil(nfile)(1:nn)
         write (jerr, 9140) fxfil(nfile)(1:nn)
         errused = .true.
      endif
      call errlog(.true., ' ', 0)
c
      end
      subroutine envstore(nfile, wvector, nvals, tdelta, vtime)
c
c update: 17:25 fri 4-mar-1994.
c store points in appropriate array according to file option;
c
c vtime:    current time
c tdelta:   difference between the time coordinate of the point to store
c           and the previously stored point.
c
c all errors are fatal.
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'habitat.par'
      include 'chem.par'
      include 'numbers.par'
      include 'expos.par'
      include 'idfiles.def'
      include 'globpar.def'
      include 'habitat.def'
      include 'units.def'
c
c module arguments
c
      real wvector( * ), tdelta, vtime
      integer nfile, nvals
c
      integer jopt, nn, xslen, jchem, nv0, nv1
      external xslen
c
      include 'circlist.sfn'
c
 9110 format (' ?? Envstore: exposure file "',a,'"; line ',i7,/,
     &   '    expecting ',i7,' numbers, found ',i7)
 9120 format (' ?? Envstore: internal error: called with unknown mode ',
     &   i7)
 9130 format (' ?? Envstore: exposure file "',a,'"',/,'    point ',i7,
     &   ' is out of sequence.')
c
c tf1func:
c    file contains: time temperature cwater(1:Gnchem)
c tf2func:
c    file contains: time chem_in_plankton(1:Gnchem)
c tf2stock:
c    file contains: time plankton_standing_stock
c tf2both:
c    file contains: time plankton_standing_stock chem_in_plankton(1:Gnchem)
c tf3func:
c    file contains: time chem_in_benthos(1:Gnchem)
c tf4func:
c    file contains: time chem_in_cfish(1:Gnchem)
c
      tdelta = zero
      vtime = zero
      jopt = ireadfx(nfile)
      nfx(nfile) = nfx(nfile) + 1
      nv1 = v2r(maxptenv, nfx(nfile))
      nv0 = v2r(maxptenv - 1, nfx(nfile))
c
      if (jopt .eq. tf1func) then
         if (nvals .ne. gnchem + 2) then
            nn = xslen(fxfil(nfile))
            write (stdout, 9110) fxfil(nfile)(1:nn), nfx(nfile), gnchem
     &         + 2, nvals
            write (jerr, 9110) fxfil(nfile)(1:nn), nfx(nfile), gnchem +
     &         2, nvals
            errused = .true.
            call errlog(.true., ' ', 0)
         endif
         f1time(nv1) = t_conv * wvector(1) + f1base_time
         f1celsius(nv1) = wvector(2)
         do jchem = 1, gnchem
            f1chem_water(jchem, nv1) = cw_conv * wvector(2 + jchem)
         enddo
         tdelta = f1time(nv1) - f1time(nv0)
         vtime = f1time(nv1)
c
      elseif (jopt .eq. tf2func) then
         if (nvals .ne. gnchem + 1) then
            nn = xslen(fxfil(nfile))
            write (stdout, 9110) fxfil(nfile)(1:nn), nfx(nfile), gnchem
     &         + 1, nvals
            write (jerr, 9110) fxfil(nfile)(1:nn), nfx(nfile), gnchem +
     &         1, nvals
            errused = .true.
            call errlog(.true., ' ', 0)
         endif
         f2time(nv1) = t_conv * wvector(1) + f2base_time
         do jchem = 1, gnchem
            f2chem_plankton(jchem, nv1) = cf_conv * wvector(1 + jchem)
         enddo
         tdelta = f2time(nv1) - f2time(nv0)
         vtime = f2time(nv1)
c
      elseif (jopt .eq. tf2stock) then
         if (nvals .ne. 2) then
            nn = xslen(fxfil(nfile))
            write (stdout, 9110) fxfil(nfile)(1:nn), nfx(nfile), 2, 
     &         nvals
            write (jerr, 9110) fxfil(nfile)(1:nn), nfx(nfile), 2, nvals
            errused = .true.
            call errlog(.true., ' ', 0)
         endif
         f2time(nv1) = t_conv * wvector(1) + f2base_time
         f2plankton_standing_stock(nv1) = wvector(2)
         tdelta = f2time(nv1) - f2time(nv0)
         vtime = f2time(nv1)
c
      elseif (jopt .eq. tf2both) then
         if (nvals .ne. gnchem + 2) then
            nn = xslen(fxfil(nfile))
            write (stdout, 9110) fxfil(nfile)(1:nn), nfx(nfile), gnchem
     &         + 2, nvals
            write (jerr, 9110) fxfil(nfile)(1:nn), nfx(nfile), gnchem +
     &         2, nvals
            errused = .true.
            call errlog(.true., ' ', 0)
         endif
         f2time(nv1) = t_conv * wvector(1) + f2base_time
         f2plankton_standing_stock(nv1) = wvector(2)
         do jchem = 1, gnchem
            f2chem_plankton(jchem, nv1) = cf_conv * wvector(2 + jchem)
         enddo
         tdelta = f2time(nv1) - f2time(nv0)
         vtime = f2time(nv1)
c
      elseif (jopt .eq. tf3func) then
         if (nvals .ne. gnchem + 1) then
            nn = xslen(fxfil(nfile))
            write (stdout, 9110) fxfil(nfile)(1:nn), nfx(nfile), gnchem
     &         + 1, nvals
            write (jerr, 9110) fxfil(nfile)(1:nn), nfx(nfile), gnchem +
     &         1, nvals
            errused = .true.
            call errlog(.true., ' ', 0)
         endif
         f3time(nv1) = t_conv * wvector(1) + f3base_time
         do jchem = 1, gnchem
            f3chem_benthos(jchem, nv1) = cf_conv * wvector(1 + jchem)
         enddo
         tdelta = f3time(nv1) - f3time(nv0)
         vtime = f3time(nv1)
c
      elseif (jopt .eq. tf4func) then
         if (nvals .ne. gnchem + 1) then
            nn = xslen(fxfil(nfile))
            write (stdout, 9110) fxfil(nfile)(1:nn), nfx(nfile), gnchem
     &         + 1, nvals
            write (jerr, 9110) fxfil(nfile)(1:nn), nfx(nfile), gnchem +
     &         1, nvals
            errused = .true.
            call errlog(.true., ' ', 0)
         endif
         f4time(nv1) = t_conv * wvector(1) + f4base_time
         do jchem = 1, gnchem
            f4chem_cfish(jchem, nv1) = cf_conv * wvector(1 + jchem)
         enddo
         tdelta = f4time(nv1) - f4time(nv0)
         vtime = f4time(nv1)
c
      else
         write (stdout, 9120) jopt
         write (jerr, 9120) jopt
         errused = .true.
         call errlog(.true., ' ', 0)
      endif
c
      if (nfx(nfile) .gt. 1) then
         if (tdelta .lt. zero) then
            nn = xslen(fxfil(nfile))
            write (stdout, 9130) fxfil(nfile)(1:nn), nfx(nfile)
            write (jerr, 9130) fxfil(nfile)(1:nn), nfx(nfile)
            errused = .true.
            call errlog(.true., ' ', 0)
         endif
      endif
c
      return
      end
      subroutine envtime(xtime, nfx, fxtime, xfound, xm0, xm1)
c
c update: 11:45 fri 9-sep-1994.
c
c find "Xtime" in array fxtime; stuff in fxtime is stored circularly;
c Nfx: number of points in fxtime(*)
c
c output:
c . xfound: truth of Xtime found;
c . xm0, xm1 are defined only if xfound == .true.
c . xm0, xm1 such that: fxtime(xm0) .le. Xtime .le. fxtime(xm1);
c   "xm0+1" == "xm1" modulo "maxptenv";
c
c declaration of fortran parameters
c
      include 'chem.par'
      include 'fish.par'
      include 'numbers.par'
      include 'ode.par'
c
      include 'habitat.par'
      include 'lab.def'
      include 'noval.par'
      include 'ode.def'
c
c declarations of subroutine's formal parameters
c;;
      integer nfx, xm0, xm1
      real xtime, fxtime( * )
      logical xfound
c
      integer jjj, maxm, jm0, jm1
      real tlow, tupp
      logical wfound, trne
      external trne
c
      include 'circlist.sfn'
c
c first make sure that the point falls in the array;
c the "output" from this block are:
c     . indexes "jm0", "jm1" such that
c           fxtime("jm0") .le. Xtime .le. fxtime("jm1"),
c       "jm0+1" == "jm1" modulo "maxptenv";
c
c search for *Xtime* using the virtual pointers; notice the loop minimum
c value is the number of elements - 1, since we are looking for an interval;
c check for enclosure within the machine precision ;
c
c we will start from the top because that is the most likely entry;
c if fxtime(jm1) == fxtime(jm0) (within Mach_eps), skip the point.
c;;
      if (nfx .le. 0) then
         wfound = .false.
         go to 110
      endif
c
      maxm = min(maxptenv, nfx)
      jm1 = v2r(maxptenv, nfx)
      jm0 = v2r(maxptenv - maxm + 1, nfx)
c
      if (trne(fxtime(jm1), fxtime(jm0))) then
         tupp = fxtime(jm1) * (one + mach_eps)
         tlow = fxtime(jm0) * (one - mach_eps)
         wfound = ((tlow .le. xtime) .and. (xtime .le. tupp))
         if (wfound) then       ! within span ?                     
            wfound = .false.
            do jjj = maxptenv, maxptenv - maxm + 2, -1
               jm1 = v2r(jjj, nfx)
               jm0 = v2r(jjj - 1, nfx)
               if (trne(fxtime(jm1), fxtime(jm0))) then
                  tupp = fxtime(jm1) * (one + mach_eps)
                  tlow = fxtime(jm0) * (one - mach_eps)
                  wfound = ((tlow .le. xtime) .and. (xtime .le. tupp))
                  if (wfound) go to 110
               endif
            enddo
         endif
      else
         wfound = .false.
      endif
c
  110 continue
      xfound = (wfound)
      if (wfound) then
         xm0 = jm0
         xm1 = jm1
      else
         xm0 = inoval
         xm1 = inoval
      endif
c
      return
      end
      integer function eolcom(card, ncard, nbeg)
c
c update: 16:12 fri 4-mar-1994.
c
c will determine if there is a comment to end-of-line, i.e., comment
c of the form "some stuff ! comment";  the "!" must not appear within
c a quoted string in order to be a comment.
c
c example:   123456789=123456789=123456789=123456789=123456789=
c   card  = "some stuff '! some other stuff'  ! comment"
c   ncard = 42
c   nbeg  = 01
c   will  return Eolcom = 34, not 13.
c
c on output:
c   Eolcom > 0 ==> comment starts at "card (Eolcom : Eolcom)"
c   Eolcom = 0 ==> no Eol comments in this card
c;;
      include 'xglobal.par'
      include 'chars.def'
c
      character*( * ) card
      integer ncard, nbeg
c
      integer np, nn, matchqte
      logical found, done
      character*1 qchar
      external matchqte
      include 'chars.sfn'
c
      np = nbeg
      found = .false.
  110 continue
      done = ((np .gt. ncard) .or. (found))
      if ( .not. done) then
         qchar = card(np:np)
         if (qchar .eq. '!') then
            found = .true.
         elseif (isquote(qchar)) then
            nn = matchqte(card, np)
            if (nn .le. 0) nn = ncard
            np = nn + 1
         else
            np = np + 1
         endif
         go to 110
      endif
c
      if (found) then
         eolcom = np
      else
         eolcom = 0
      endif
c
      return
      end
      subroutine errlog(lstop, wmsg, nmsg)
c
c update: 17:25 fri 4-mar-1994.
c write message to error Log file, optionally stop execution
c
c arguments (all input):
c . Lstop      logical; truth of "stop program"
c . wmsg       s**; message to print; see "nmsg"
c . nmsg       integer;
c              > 0: print wmsg(1:nmsg)
c              = 0: no message to print
c              < 0: determine length of message (via Xslen) and print it
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'idfiles.def'
c
      logical lstop
      integer nmsg
      character*( * ) wmsg
c
      integer nlen, xslen, nout, nerr
      external xslen
c
 9110 format (1x,a)
 9120 format (1x,'?? errors detected: review the files:',/,1x,'   . "',
     &   a,'"',/,1x,'   . "',a,'"')
c
      if (nmsg .ge. 0) then
         nlen = nmsg
      else
         nlen = xslen(wmsg)
      endif
      if (nlen .gt. 0) then
         write (jerr, 9110) wmsg(1:nlen)
         errused = .true.
      endif
c
      if (lstop) then
         errused = .true.
         nout = max(1, xslen(outfil))
         nerr = max(1, xslen(errfil))
         write (stdout, 9120) errfil(1:nerr), outfil(1:nout)
         stop ' '
      endif
c
      return
      end
      real function exx(zz)
c
c history:
c - original documentation: feb/85
c - processed by SPAG 3.14A  at 14:42 on 26 Oct 1992
c - update: 13:04 fri 4-mar-1994.
c
c purpose: compute truncated exponential function.
c   this function tries to avoid over and underflows
c   by truncating the argument when it gets above or
c   below a prescribed value:
c      if Zz is less than or equal to zmin:
c         Exx = 0.0
c      if Zz is between zmin and zmax (inclusive):
c         Exx = Exp(Zz)
c      if Zz is greater than zmax:
c         Exx = Exp(zmax)
c
c - zmin = -80.00;   Exp (zmin) = 1.804851387845e-35
c   zmax = +81.00;   Exp (zmax) = 1.506097314585e+35
c
c - Exp(zmin) is about 1000 larger than the smallest
c   representable number (for the vax 11/785)
c
c - Exp(zmax) is about 1000 smaller than the largest
c   representable number (for the vax 11/785)
c
c description of the arguments:
c input:
c    Zz     - argument of the function
c
c output:
c    Exx    - truncated "Exp(Zz)"
c
      real zz, zmin, zmax
      data zmin / -80.00/, zmax /81.00/
c
      if (zz .lt. zmin) then
         exx = 0.00e+00
      elseif (zz .le. zmax) then
         exx = exp(zz)
      else
         exx = exp(zmax)
      endif
c
      return
      end
      subroutine f77crctl(uu)
c
c F77CrCtl - enable Fortran Carriage-Control in unit "Uu";
c
c history:
c - [lsr] 14:45 fri 5-aug-1994.
c   . original version
c
c much to my regret, i need regular fortran carriage control for stdout, stderr
c (overprint and such).
c
c even worse, sometimes i need it, sometimes i do not need the carriage control
c
c this routine is needed for VMS systems;
c;;
      include 'xglobal.par'
      include 'xio.inc'
c
      integer uu
      integer ios
      logical is_open, ok
c
c [lsr] 15:39 mon 15-aug-1994.
c may live to regret it but i do not have the time to see what is the
c problem between this module and Lahey 32m.
c
c
  110 continue
      return
      end
      subroutine fdelete(fname, ok)
c
c update:   fri 11:59 3-jan-1992.
c purpose:  delete a file
c
c comments:
c    - if the user cannot provide this routine set ok to
c      false and return.
c
c reference: spindrift utility library, p55
c
      character*( * ) fname
      logical ok
c
c
      call erase(fname)
c
      return
      end
      program fgets
c
c update: 12:42 fri 9-sep-1994.
c
c  purpose:
c  -1 analyze bioconcentration of nonpolar chemicals;
c  -2 analyze bioaccumulation of nonpolar chemicals via
c     gill and food exchange;
c  -3 predict additive narcotic lethality;
c
c  required files:
c  - Fgets.dat       (input)
c  - fgets3.db       (model parameters database)
c  - Fgets.fgz       (output)
c  - Fgets.fts       (output; time_series file; user enabled)
c  - Fgets.fcs       (output; updated command file; user enabled)
c  - Fgets.fau       (output; audit file; user enabled)
c  - additional exposure files, if option "... file ..." is selected
c     "/cplankton", "/cbenthos", "/cfish", "/plankton_standing_stock"
c     "/temperature", "/cwater"
c
c  notes concerning program/user input units:
c  - the units of body weight, concentration and time used by Fgets
c    internally as well as for output are grams, ppm (mg/Litre, microgram/mL)
c    and days, respectively.
c
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'xio.inc'
      include 'chem.par'
      include 'dbphysio.par'
      include 'errors.par'
      include 'expos.par'
      include 'fish.par'
      include 'habitat.par'
      include 'helpid.par'
      include 'inkey.par'
      include 'menu.par'
      include 'noval.par'
      include 'numbers.par'
      include 'ode.par'
      include 'page.par'
      include 'phylum.par'
      include 'physio.par'
      include 'plots.par'
      include 'prompt.par'
      include 'setcodes.par'
      include 'simul.par'
      include 'srch.par'
      include 'strings.par'
      include 'token.par'
      include 'water.par'
c
      include 'blkset.def'
      include 'chars.def'
      include 'chemp.def'
      include 'chems.def'
      include 'dbrec.def'
      include 'diet.def'
      include 'echo.def'
      include 'examsrec.def'
      include 'expos.def'
      include 'xinclude.inc'
      include 'fish.def'
      include 'fisiorec.def'
      include 'fluxes.def'
      include 'globpar.def'
      include 'h2ovisc.def'
      include 'habitat.def'
      include 'heap.def'
      include 'hits.def'
      include 'holling.def'
      include 'idfiles.def'
      include 'idsdb.def'
      include 'lab.def'
      include 'obsdata.def'
      include 'ode.def'
      include 'odevar.def'
      include 'options.def'
      include 'page.def'
      include 'plottmp.def'
      include 'prompt.def'
      include 'pspoc.def'
      include 'show.def'
      include 'stealth.def'
      include 'time.def'
      include 'token.def'
      include 'unitdb.def'
      include 'units.def'
      include 'vdefined.def'
      include 'version.def'
      include 'work.def'
c
      include 'fv3vars.h'
c;;
c research + unix-like interface declarations
c
      character*(stdlen) zargs(maxarg)
      character*(stdlen) toutfil, ttsfil, tucffil
      character*(stdlen) xfexpand, xcat
      character*(stdlen) qifname, qidev, qidir, qiname, qitype, qivers
      character*(stdlen) qofname, qodev, qodir, qoname, qotype, qovers
      logical done, xxinit, option(noptions)
      integer nargs
      external xxinit, xfexpand, xcat
c
      character*(stdlen) zdate, qtmp
      logical havefile, xxok, docmd
      integer nin, nout, xfopen, xquery
      integer xslen, ndate, jlun, ios
      external xfopen, xfclose, xslen, blkfgets
c;;
 9110 format ('$','parameter file name (or press "Enter" to exit): ')
 9120 format (a)
 9130 format (' ',' ?? Fgets: cannot open "',a,'"')
 9140 format (' ',' ?? Fgets: cannot create "',a,'"')
c
 9150 format (' ','     program: ',a)
 9160 format (' ','  input file: ',a)
 9170 format (' ',' output file: ',a)
 9180 format (' ','        date: ',a)
c
c initialize program
c
      if (block_data_loaded .ne. 'ok') then
         write (*, *) '?? Linker/Loader error: block data not loaded.'
         go to 120
      endif
c
      done = xxinit(done)
c
c if  -- Version date is the generation date of "blkfgets.fx";
c
c warning: do not do a thing until Initpgm is called;
c
      call initpgm()
      call initvar()    ! initialize default variables.     
      call freadpush(stdin, xxok)
      nversion = xslen(x_version_date)
      qtmp = 'FGETS 3.0.18 [' // x_version_date(1:nversion) // ']'
      x_version_date = qtmp
      nversion = xslen(x_version_date)
c
c use "teject" because at this stage, "Jout" is not defined;
c one possible solution is to open a file for output (say fgets000.tmp),
c     dump all results there, and rename just before exit;
c
      call opage(tsethead, '*** Input', -1, 0, xquery)
      call opage(teject, ' ', 0, 0, xquery)
c
c need to set the first call, just in case: "Xtiming" will be set later;
c
      call uxtiming('Fgets', 1)
c
      call getdate(zdate, ndate)
      infil = ' '
      outfil = ' '
      tsfil = ' '
      ucffil = ' '
      toutfil = ' '
      ttsfil = ' '
      tucffil = ' '
      nversion = xslen(x_version_date)
      write (stdout, 9150) x_version_date(1:nversion)
c
c get user desires and fantasies ...
c
      call clropt(option, noptions)
      call getarg0(.false.)
      call getarg(zargs, nargs)
      zargs(1) = pgmfil
      nargs = max(1, nargs)
      call zdecod(zargs, nargs, option, noptions)
c
c assign input file, if present
c
      havefile = (option(ichar('i')))
      if (havefile) then
         nin = xslen(infil)
         havefile = (nin .gt. 0)
      else
         write (stdout, 9110)
         read (stdin, 9120) infil
         nin = xslen(infil)
         call up2lo(infil, nin)
         havefile = (nin .gt. 0)
      endif
c
      docmd = .false.
      if (havefile) then
         nin = xslen(infil)
         if (infil(1:nin) .eq. '@') then
            infil = ' '
            docmd = .true.
            havefile = .false.
         elseif (infil(1:1) .eq. '@') then
            infil = infil(2:)
            nin = nin - 1
            havefile = (nin .gt. 0)     ! being paranoid ...       
         endif
      endif
c
      if (havefile) then
         call mkname(infil, '.dat', .true., infil)
         if (zioerror .eq. xfopen(jin, infil, zioread)) then
            call errlog(.true., ' ', 0)
            havefile = .false.
         endif
         call freadpush(jin, xxok)
c
         qifname = xfexpand(infil, qidev, qidir, qiname, qitype, qivers)
         qofname = xfexpand(outfil, qodev, qodir, qoname, qotype, qovers
     &      )
         if (qoname(1:1) .ne. null) then
            outfil = qoname
         else
            outfil = qiname
         endif
         if (qotype(1:1) .ne. null) then
            outfil = xcat(outfil, qotype)
         else
            outfil = xcat(outfil, '.fgz')
         endif
         opath = xcat(qodev, qodir)
         call fnameset(outfil, opath, outfil, tsfil, ucffil)
      endif
c
      if (docmd) then
         continue
      elseif ( .not. havefile) then
         go to 110
      endif
c
c write file information
c
      nin = xslen(infil)
      nout = xslen(outfil)
      if (nout .le. 0) then
         opath = ' '
         call fnameset(pgmfil, opath, outfil, tsfil, ucffil)
         nout = xslen(outfil)
      endif
      if (zioerror .eq. xfopen(jout, outfil, ziowrite)) then
         call errlog(.true., ' ', 0)
      endif
c
      call opage(tinquire, ' ', 0, 5, xquery)
      write (jout, 9150) x_version_date(1:nversion)
      if (nin .gt. 0) then
         write (stdout, 9160) infil(1:nin)
         write (jout, 9160) infil(1:nin)
      endif
      if (nout .gt. 0) then
         write (stdout, 9170) outfil(1:nout)
         write (jout, 9170) outfil(1:nout)
      endif
      write (stdout, 9180) zdate(1:ndate)
      write (jout, 9180) zdate(1:ndate)
c
c user input loop
c
      if (xtiming) then
         call uxtiming('input', 1)
      endif
c
      call setvar()
c
      if (xtiming) then
         call uxtiming('input', 2)
      endif
c
c simulation terminated;  closing ceremonies.
c close exposure files (if appropriate)
c
  110 continue
      if (xexams) then
         call xfclose(jcw)
      else
         if (iread_plankton .ne. tfxnoread) call xfclose(jplankton)
         if (iread_benthos .ne. tfxnoread) call xfclose(jbenthos)
         if (iread_cfish .ne. tfxnoread) call xfclose(jcfish)
         if (iread_cw .ne. tfxnoread) call xfclose(jcw)
      endif
c
      if (xdata) call xfclose(jts)      ! close time series file
      inquire (unit=jout, name=qtmp, exist=havefile)    ! plan for the future
      call xfclose(jout)        ! close the output file
c
c check for existence of error Log file;
c get full file name; close it; delete it if not used;
c poor's man delete: open file "old", close "delete";
c
      inquire (unit=jerr, exist=havefile, name=qtmp)
      if (havefile) then
         jlun = jerr    ! save old unit number  
         call xfclose(jerr)     ! close file / deallocate unit
         if ( .not. errused) then       ! if logfile was not used ...
            open (unit=jlun, file=qtmp, status='old', iostat=ios)
            if (ios .eq. 0) then
               close (unit=jlun, status='delete')
            endif
         endif
      endif
c
c print timing statistic before closing the file
c
      if (xtiming) then
         call uxtiming('Fgets', 2)
      endif
c
      call xiofinis()   ! flush and close everything else.
c
  120 continue
      stop 'FGETS 3.0.18'
      end
      subroutine fnameset(infil, opath, outfil, tsfil, ucffil)
c
c update: wed 14:12 18-dec-1991.
c
c this subroutine generates the names for the output file, the
c plot file and the title for the plot. "Opath" contains the path to be
c used for output files;
c
c input arguments :
c -Infil  = character string containing the name of the input file;
c -Opath  = character string containing the path of the output files;
c
c output arguments:
c -Outfil = character string containing the name of the output file;
c -Tsfil  = character string containing the name of the time_series file;
c -Ucffil = character string containing the name of the updated input file;
c
c Infil of the form:
c  d:file.ext
c  d:\s1\s2\file.ext
c
      character*( * ) infil, opath, outfil, tsfil, ucffil
c
      integer xslen, k1, nh, np, nl, laststr, nb, nk
      external xslen, laststr
c
      nl = xslen(infil)
      nh = xslen(opath)
      nb = laststr(infil, nl, 1, ':')
      if (nb .gt. 0) then
         nk = laststr(infil, nl, nb, '\')
         if (nk .le. 0) nk = nb
      else
         nk = laststr(infil, nl, 1, '\')
      endif
      nk = nk + 1       ! nk: position to start saving
      np = index(infil(nk:), '.')
      if (np .gt. 0) np = np + nk - 1
c
      if (np .gt. 0) then
         np = np - 1
      else
         np = nl
      endif
      if (nk .le. np) then
         ucffil = infil(nk:np)
         np = np - nk + 1
      else
         ucffil = 'noname'
         np = len('noname')
      endif
c
      if (nh .gt. 0) then
         outfil = opath(1:nh) // ucffil(1:np)
         k1 = nh + np
      else
         outfil = ucffil(1:np)
         k1 = np
      endif
c
      outfil(k1 + 1:) = '.fgz'
      tsfil = outfil(1:k1) // '.fts'
      ucffil = outfil(1:k1) // '.fcs'
c
      return
      end
      subroutine fparse(fname, qnode, knode, qdevice, kdevice, 
     &   qdirectory, kdirectory, qfile, kfile, qtype, ktype, qversion, 
     &   kversion)
c
c purpose:
c    parse a file name into its component parts
c
c
c note:
c    - missing fields will be set blank
c    - all output strings are translated to lower case
c    - procedure is very naive
c;;
      include 'Xglobal.par'
c
      character*( * ) fname, qnode, qdevice, qdirectory
      character*( * ) qfile, qtype, qversion
      integer knode, kdevice, kdirectory
      integer kfile, ktype, kversion
c
      integer s255
      parameter (s255 = 255)
      character*(s255) q1tmp, xfexpand
      integer xslen, nq1
      external xslen, xfexpand
c
      q1tmp = fname
      nq1 = xslen(q1tmp)
      call up2lo(q1tmp, nq1)
      qnode = null
      qdevice = null
      qdirectory = null
      qfile = null
      qtype = null
      qversion = null
c
c
      q1tmp = xfexpand(fname, qdevice, qdirectory, qfile, qtype, 
     &   qversion)
c
      knode = xslen(qnode)
      kdevice = xslen(qdevice)
      kdirectory = xslen(qdirectory)
      kfile = xslen(qfile)
      ktype = xslen(qtype)
      kversion = xslen(qversion)
c
c
      return
      end
      logical function fread1(uu, line, nl)
c
c update: 17:26 fri 4-mar-1994.
c
c read a logical line; strip end-of-line comments;
c Blank lines will be ignored in interactive mode;
c if the line ends with a "&" ==> read the next record and append;
c example
c     ! column 1                 equivalent line
c     line_1 ...&                   line_1 ...line2
c        line_2
c     line_1 ... &                  line_1 ...    line2
c        &   line_2
c
c cp:    current position; position of the new read
c ep:    end position; total number of chars in "line"
c np:    position of first non Blank
c zp:    number of chars in "line" after shifting
c ncp:   number of chars read, starting from "line(cp:)"
c;;
      include 'xglobal.par'
      include 'idfiles.def'
c
      character*( * ) line
      integer uu, nl
c
      integer cp, ncp, np, nextnb, ep, zp
      logical fread2, done, gotline, xinteractive
      external fread2, nextnb
c
      xinteractive = (uu .eq. stdin)
      gotline = (fread2(uu, line, nl))
      if (gotline) then
         if (xinteractive) then
            if (nl .gt. 0) then
               done = (line(nl:nl) .ne. '&')    ! not done if trailing "&"
            else
               done = .true.    ! return empty line     
            endif
         elseif (nl .gt. 0) then
            done = (line(nl:nl) .ne. '&')       ! not done if trailing "&"
         else
            done = .false.      ! read until nonblank line;
            nl = 1      ! fudge counter;        
         endif
c
  110    continue
         if ( .not. done) then
            line(nl:nl) = ' '   ! nl > 0 always.        
            nl = nl - 1
            cp = nl + 1
            if (fread2(uu, line(cp:), ncp)) then
               if (ncp .gt. 0) then
                  ep = ncp + cp - 1     ! total num of chars in "line"
                  np = nextnb(line, ep, cp)
                  if (line(np:np) .ne. '&') then        ! leading Char <> "&" ?
                     zp = ep - np + cp
                     line(cp:zp) = line(np:ep)
                  else
                     if (np .ne. ep) then       ! leading "&" is not last Char
                        zp = cp + ep - (np + 1)
                        line(cp:zp) = line(np + 1:ep)   ! skip leading "&"
                     else
                        zp = ep - np + cp       ! np == ep     
                        line(cp:zp) = line(np:ep)       ! keep trailing "&"
                     endif
                  endif
                  nl = zp
                  if (nl .gt. 0) then
                     done = (line(nl:nl) .ne. '&')
                  endif
               else
                  nl = nl + 1   ! Blank line read; fudge counter
               endif
            else
               done = .true.
            endif
            go to 110
         endif
      endif
      fread1 = (gotline)
      line(nl + 1:) = ' '
c
      return
      end
      logical function fread2(uu, xbuf, nbuf)
c
c update: 11:22 fri 9-sep-1994.
c
c read a line; strip end-of-line comments;
c lines starting with ("c" | "C") followed with (Blank | Tab | "!")
c are assumed comments; this was done to preserve compatibility with older
c fgets versions;
c
c if interactive io, accept Blank lines.  if the line is a comment line,
c get another.
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'Prompt.par'
      include 'idfiles.def'
      include 'options.def'
c
      character*( * ) xbuf
      integer uu, nbuf
c
      integer npk, xslen, eolcom, ios, nextnb, idum
      logical qeof, xinteractive
      external xslen, eolcom, nextnb
c
      logical ignoreline
      include 'chars.def'
      include 'chars.sfn'
      ignoreline(idum) = ((xbuf(1:1) .eq. 'c') .or. (xbuf(1:1) .eq. 'C')
     &   ) .and. ((xbuf(2:2) .eq. blank) .or. (xbuf(2:2) .eq. tab) .or.
     &   (xbuf(2:2) .eq. '!'))
c
 9110 format (a)
 9120 format (1x,a)
 9130 format (1x,'File> ',a)
c
      xinteractive = (uu .eq. stdin)
c
  110 continue
      call prompt(prprint, ' ')
c
      read (uu, 9110, iostat=ios) xbuf
      if (ios .eq. 0) then
         qeof = .false.
         nbuf = xslen(xbuf)
         if (xinteractive) then ! interactive: accept anything.
            continue
         elseif (nbuf .le. 0) then      ! empty line and not interactive
            go to 110
         endif
c
c if audit is on, issue line to audit file
c
         if (xauditon) then
            if (nbuf .gt. 0) write (jaud, 9120) xbuf(1:nbuf)
         endif
c
c if not reading from Stdin (i.e., not interactive), print the line
c
c!~14!         if (.not. xinteractive) then
c!~14!            if (Nbuf .gt. 0) write (Stdout, 9130) Xbuf(1:Nbuf)
c!~14!         endif
c
c if comment line read another line
c
         if (xbuf(1:1) .eq. '!') go to 110
         if (ignoreline(idum)) go to 110
c
c strip end of line comments
c
         npk = eolcom(xbuf, nbuf, 1)
         if (npk .gt. 0) then
            xbuf(npk:nbuf) = ' '
            nbuf = xslen(xbuf(1:npk))
            if (nbuf .le. 0) go to 110
         endif
         if (nbuf .eq. 0) xbuf = ' '
      else
         nbuf = 0
         xbuf = ' '
         qeof = .true.
      endif
      fread2 = ( .not. qeof)
c
      return
      end
      subroutine freadpush(uu, no_errors)
c
c update: 17:26 fri 4-mar-1994.
c add to or initialize the "# include" processor
c;;
      include 'xglobal.par'
      include 'xinclude.inc'
      include 'idfiles.def'
c
      integer uu
      logical no_errors, first_time
      data first_time /.true./
c
      if (first_time) then
         first_time = .false.
         zlevel = 0
      endif
c
      zlevel = zlevel + 1
      if (zlevel .le. maxfinclude) then
         zjin(zlevel) = uu
         no_errors = .true.
      else
         zlevel = zlevel - 1
         no_errors = .false.
         write (stdout, 9110)
      endif
 9110 format (1x,'?? io stack overflow: increase "maxfinclude"')
c
      return
      end
      logical function freadx(xline, nxline)
c
c update: 16:00 tue 5-apr-1994.
c
c Freadx  -  read a line of a (possible "#include") file
c;;
      include 'xglobal.par'
      include 'xinclude.inc'
      include 'idfiles.def'
c
      character*( * ) xline
      integer nxline
c
      character*(stdlen) f2name
      integer nn, xfopen, xslen, kstatus, uu
      logical eofile, done, xxok
      logical fread1, isinclud, haveline
      external fread1, isinclud, xfclose, xfopen, xslen
c
 9110 format (1x,'?? Freadx: increase "maxfinclude"')
 9120 format (1x,'?? Freadx: include failure, file = "',a,'"')
c
      done = .false.
      do while ( .not. done)
         eofile = ( .not. fread1(zjin(zlevel), xline, nxline))
c
         if (eofile) then
            haveline = .false.
            if (zlevel .gt. 1) then
               call xfclose(zjin(zlevel))
               zlevel = zlevel - 1
            else
               done = .true.
            endif
c                                   ! if "# include" files : "recursion" step
         elseif (isinclud(xline, nxline, f2name)) then
            haveline = .true.
            kstatus = xfopen(uu, f2name, zioread)
            if (kstatus .eq. zioerror) then
               nn = max(1, xslen(f2name))
               write (stdout, 9120) f2name(1:nn)
               write (jerr, 9120) f2name(1:nn)
               errused = .true.
               done = .true.
               call errlog(.true., ' ', 0)
            else
               call freadpush(uu, xxok)
               if ( .not. xxok) then
                  errused = .true.
                  done = .true.
                  call errlog(.true., ' ', 0)
               endif
            endif
c
         else
            done = .true.
            haveline = .true.
         endif
      enddo
c
      if ( .not. haveline) then
         xline = eof
         nxline = 1
      elseif (nxline .eq. 0) then
         xline = eol
         nxline = 1
      endif
      freadx = haveline
c
      return
      end
      subroutine getarg(zargs, nargs)
c
c purpose:
c - ask the user for unix-like input.
c
c updates:
c - [lsr] 19:21 thu 4-mar-1993.
c   . call "GetArg0(.false.)" to inhibit prompting
c - processed by SPAG 3.14A  at 14:43 on 26 Oct 1992
c - [lsr] 14:46:03.19 tuesday october 3, 1989.
c   general cleanup; make use of *xslen*;
c   get the name of the executable that called this image;
c   add "&" to the list of continuation characters;
c - [lsr] 07:38:51.88 wednesday february 25, 1987.
c - 11-sep-1986 15:32:44 [lsr] -- "\" or "-" continuation
c   if either is the last character.
c   read 1024 characters (instead of 80).
c - march/86 [lsr] -- changes for vax vms version 4.2
c - oct/85 [lsr]
c
c description of the arguments:
c input:
c    *none*
c
c output:
c    nargs  - number of arguments ( > 0)
c    zargs  - arguments:
c                (1) - name of the program
c                (2-nargs) - other arguments
c
c system dependencies:
c    - ios < 0  ==> end-of-file read.
c
c notes:
c    - use either "-" or "\" or "&" (preceeded and followed by a
c      blank) to continue input on the next line. example:
c         GetArg> -i input.f \
c         GetArg> -o output.fil -
c         GetArg> -p plotfil &
c         GetArg> -t
c      is equivalent to:
c         GetArg> -i input.f -o output.fil -p plotfil -t
c;;
      include 'xglobal.par'
c
      character*( * ) zargs( * )
      integer nargs
c
      character*(maxstr) q1tmp, pname
      integer nt, nq1, ios, plen
      logical more01, ok, zfirst, zfin, done
      integer xslen
      external dozarg, xslen, argblk
c
      logical doprompt
      common /gargl/ doprompt
c
      save zfirst, pname, plen
c
      data zfirst /.true./
      data pname /' '/
      data plen /0/
c
 9110 format ('$','_GetArg> ')
 9120 format (a)
 9130 format ('?? GetArg: truncation -- increase the length of "q1tmp".'
     &   )
      if (zfirst) then
         zfirst = .false.
         call syslin(ok, q1tmp, nq1)
         nt = index(q1tmp, ' ')
         pname = q1tmp(1:nt)
         plen = xslen(pname)
         q1tmp = q1tmp(nt + 1:)
         nq1 = xslen(q1tmp)
      else
         nq1 = 0
      endif
c
      if ((nq1 .le. 0) .and. (doprompt)) then
         write (zstderr, 9110)
         read (zstdin, 9120, iostat=ios) q1tmp
         if (ios .lt. 0) q1tmp = ' '
      endif
c
      q1tmp = pname(1:plen) // ' ' // q1tmp
      nq1 = xslen(q1tmp)
      if (nq1 .ge. len(q1tmp)) then
         write (zstderr, 9130)
      endif
      call dozarg(q1tmp, nq1, zargs, nargs)
c
c we have *not* finished if the last argument is:
c    - either "\" or "-" or "&" followed by blanks
c
      zfin = .false.
  110 continue
      more01 = ((zargs(nargs) .eq. '\ ') .or. (zargs(nargs) .eq. '- ') 
     &   .or. (zargs(nargs) .eq. '& '))
      done = (( .not. more01) .or. (zfin))
      if ( .not. done) then
         nargs = nargs - 1
         write (zstderr, 9110)
         read (zstdin, 9120, iostat=ios) q1tmp
         if (ios .lt. 0) q1tmp = ' '
         nq1 = xslen(q1tmp)
         call dozarg(q1tmp, nq1, zargs(nargs + 1), nt)
         if (nt .ge. 1) then
            nargs = nargs + nt
         else
            zfin = .true.
         endif
         go to 110
      endif
c
      return
      end
      subroutine getarg0(doask)
c
c update:   19:13 thu 4-mar-1993.
c purpose:
c - set the "ask" parameter of Getarg
c
c Doask:    truth of "ask for command line" if the line is empty
c
      logical doask
      external argblk
c
      logical doprompt
      common /gargl/ doprompt
c
      doprompt = doask
c
      return
      end
      subroutine getdate(zdate, ndate)
c
c update: fri 15:18 11-oct-1991.
c get system date; the format depends on the system;
c
      character*( * ) zdate
      integer ndate, xslen
      external xslen
c
      call time(zdate)  ! hh:mm:ss.hh ; Len = 11, space filled
      call date(zdate(13:))     ! mm/dd/yy ; Len = 8, space filled  
      ndate = xslen(zdate)
c
      return
      end
      subroutine gethelp(xitem, xxfound)
c
c update: 17:43 fri 4-mar-1994.
c look up help info in help file:
c . first try exact match
c . if unsuccessful, add a trailing "*" and try a wildcard match
c xxfound == truth of "entry found"
c
c help file format: unformatted, direct
c line 1: file name; generation date
c line 2: Nhelp, id_offset
c         Nhelp:  number of help entries stored
c         id_offset: identifiers for help entries are stored
c                    in lines {id_offset + i}, i = 1, Nhelp
c line (id_offset + 1): help entry 1 identifier, offset_{1}
c    .
c    .
c    .
c line (id_offset + i): help entry "i" identifier, offset_{i}
c         the text of the i-th help intry starts at line number offset_{i}
c    .
c    .
c    .
c line (id_offset + Nhelp): help entry "Nhelp" identifier, offset_{Nhelp}
c line offset_{1}: nlines
c         nlines: number of text lines to display.
c line offset_{1}+1: text line 1
c line offset_{1}+2: text line 2
c    .
c    .
c    .
c line offset_{1}+nlines: text line "nlines" (i.e., last line)
c line offset_{2}: nlines
c    .
c    .
c    .
c
c notes:
c - each text record is preceeded with the number of characters in the line;
c - the help entries (lines {2+i}, i = 1, Nhelp) are sorted.
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'idfiles.def'
      include 'hits.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) xitem
      logical xxfound
c
      character*(stdlen) q1tmp
      integer nq1, xslen, jj, xfopen, joffset, nlines, ios
      logical xfirst, srchew0, hhfound, srchlb0
      external srchew0, xslen, xfopen, srchlb0, xfclose
c
      data xfirst /.true./
c
 9110 format (1x,'info available on:')
 9120 format (1x,a,a,a)
c
c first time: open file and load help arrays
c
      xxfound = .false.
      if (xfirst) then
         xfirst = .false.
         if (nhelp .le. 0) then
            call inithelp()
         endif
      endif
      if (nhelp .gt. 0) then
c
         hhfound = srchlb0(xitem, xhelp, nhelp, xhits(1))
         if ( .not. hhfound) then
            q1tmp = xitem
            nq1 = 1 + xslen(q1tmp)
            q1tmp(nq1:nq1) = '*'
            call srchlw0(q1tmp, xhelp, maxhelp, xhits, nhits)
            hhfound = (nhits .eq. 1)
         endif
c
         if (hhfound) then
            joffset = xoffset(xhits(1))
            read (jhlb, rec=joffset, iostat=ios) nlines
            do jj = 1, nlines
               joffset = joffset + 1
               read (jhlb, rec=joffset, iostat=ios) nq1, q1tmp(1:nq1)
               write (stdout, 9120) q1tmp(1:nq1)
            enddo
            xxfound = .true.
         else
            xxfound = .false.
         endif
      endif
c
  110 continue
      return
      end
      subroutine gill_sk(xcelsius, ph, nchem, molvol, pka, wt, zfishpar,
     &   gill_area, kw)
c
c update: thu 15:44 5-mar-1992.
c
c this subroutine calculates gill area, and interlamellar mass
c conductances, kw, for the gill exchange model,
c
c     dbf
c     --- = gill_area * kw * (cw - ca),
c     dt
c
c where bf is the body burden of toxicant.
c
c input (as formal parameters):
c   -Xcelsius    = water temperature [celsius];
c   -ph          = water ph;
c   -nchem       = number of chemicals;
c   -Molvol      = molar volume of the chemical [cm^3/mole];
c   -Pka         = Pka of the chemical (Pka=undefined ==> neutral chemical);
c   -wt          = fish weight [g live];
c   -s1,s2       = surface area [cm^2] of gill
c                = s1 * wt**s2;
c   -d1,d2       = interlamellar distance [cm]
c                = d1 * wt**d2;
c   -l1,l2       = lamellar length [cm]
c                = l1 * wt**l2;
c   -ox1,ox2     = standard respiration [mg o2 consumed/hr] at tref [celsius]
c                = ox1 * wt**ox2;
c   -oxq10       = q10 for temperature deviation from tref;
c   -oxt         = reference temperature;
c
c old input
c   -buffered    = .true.  ==> is bulk interlamellar water is buffered;
c   -buffered    = .false. ==> is bulk interlamellar water is not buffered;
c
c output :
c   -gill_area   = total gill surface area [cm^2];
c   -kw          = mass conductances [cm/d] (see barber et al. 1991.
c                  can.j.fish.aquat.sci.);
c
c internal variables:
c   -cox    = dissolved oxygen saturation [mg/ml];
c   -cpoise = viscosity of water [0.01*dyne*s*cm^-2];
c   -d      = average interlamellar distance [cm];
c   -dp     = pressure differential across gill [dyne/cm^2];
c   -dw     = diffusion coefficient [cm^2/s];
c   -l      = average lamellar length [cm];
c   -ngz    = graetz number
c           = (l * dw)/(r^2 * v);
c   -ox     = oxygen uptake [mg/sec];
c   -poise  = viscosity of water [dyne*s*cm^-2];
c   -r      = hydraulic radius (2 cross sectional area / perimeter [cm])
c           = d/2 [cm];
c   -v      = average interlamellar velocity [cm/s];
c   -xa     = cross sectional area of the gill sieve [cm^2];
c
c references:
c -barber et al. 1990. can.j.fish.aquat.sci. (in press).
c -barber et al. 1988. environ.toxicol.chem. 7:545-558.
c -davis and randall. 1972. j.fish.res.bd.can. 30:99-104.
c -hayduk and laudie. 1974. aiche journ. 20:611-615.
c -lauder 1984. j.Exp.biol. 113:151-164.
c -randall. 1984. fish physiology Xa:263-314. acad.press p.456.
c -rohsenow and choi. 1961. heat, mass, and momentum transfer.
c  prentice hall. p.537.
c -stevens and lightfoot. 1986. comp.biochem.physiol. 83a:255-259.
c
c declarations of subroutine's formal parameters
c;;
c
      integer nchem
      real xcelsius, ph, pka( * ), molvol( * ), wt
      real zfishpar( * )
      real gill_area, kw( * )
c
c declarations for intermediate variables
c
      integer jchem
      real dw, zcpoise, zmolvol, cpoise, d, dp, l
      real ngz, ox, poise, r, routine, v, vol, xa
c
c declarations for external functions
c
      include 'noval.par'
      include 'physio.par'
      include 'numbers.par'
c
      real exx, theta_b
      external exx, theta_b
      include 'h2ovisc.def'
      include 'vdefined.def'
c
c dw(zcpoise,zmolvol) : chemical diffusivity [cm^2/s] (hayduk and laudie 1974)
c
      dw(zcpoise, zmolvol) = 13.26e-5 / (zcpoise ** 1.4 * zmolvol ** 
     &   0.589)
c
      include 'h2ovisc.sfn'
      include 'vdefined.sfn'
c
c calculate the dynamic viscosity of water
c
      cpoise = h2o_visc(xcelsius)
      poise = 0.01 * cpoise
c
c calculate gill morphometrics, hydraulic radius, and pore area
c
      gill_area = zfishpar(vsgill1) * wt ** zfishpar(vsgill2)
      d = zfishpar(vrho1) * wt ** zfishpar(vrho2)
      l = zfishpar(vlaml1) * wt ** zfishpar(vlaml2)
      r = d / 2.0
      xa = gill_area * d / l
c
c calculate routine oxygen consumption [mg/s] from the the power function
c used to estimate standard oxygen consumption [mg/hr] assuming routine
c equals twice standard.
c
      routine = 2.0
      ox = (routine / 3600.0) * 
     &   exx(zfishpar(voxq10) * (xcelsius - zfishpar(voxt))) * 
     &   zfishpar(vox1) * wt ** zfishpar(vox2)
c
c calculate ventilation volume [cm^3/s] assuming fully developed poiseullian
c slit flow [see rohsenow and choi (1961, p 34) or stevens and lightfoot
c (1986)]. assume mean pressure differential equals 250 dyne/cm^2 [see
c davis and randall (1972, figure 2)]
c
      dp = 250.0
      v = dp * r ** 2 / (3.0 * poise * l)
      vol = xa * v
c
      do jchem = 1, nchem
         ngz = l * dw(cpoise, molvol(jchem)) / (r ** 2 * v)
c
c calculate bulk concentration of exhalent gill water
c
         if ( .not. vdefined(pka(jchem))) then
c
c **************** chemical is non-dissociating ************************
c
            kw(jchem) = vol * (one - theta_b(ngz)) / gill_area
         else
c
c **************** chemical is dissociating ************************
c
c            call ionic (cw_o, nseg, ngz, cw, Pka
c     &                , ph, c_anion, c_cation, ox, vol, Xcelsius)
c            kw(jchem) = vol*(cw - cw_o) / (gill_area * cw)
            call errlog(.true., 
     &         'Gill_sk: dissociating chemical option not available!', 
     &         -1)
         endif
c
c convert conductance from (cm/s) to (cm/d)
c
         kw(jchem) = kw(jchem) * 86400.0
      enddo
c
      return
      end
      subroutine gmpms(card, ncard, matrix, mrows, nvals, nerror, found)
c
c update: 16:11 fri 4-mar-1994.
c get numbers or commands from a line (mnemonic: get mean plus minus Sigma)
c
c input:
c    card   - character*(*) array with the number(s) or
c             commands to be decoded.
c    ncard  - total number of characters in *card*.
c    mrows  - leading dimension of "matrix"
c
c output:
c    nvals  - number of decoded numbers
c    matrix - matrix of decoded numbers
c             matrix declared "Real matrix(mrows,2)"
c    nerror - error message number.
c                0 ==> no error; 1 ==> error
c    found  - truth of " '+-' found"
c
c examples:
c    - assume:   card  = "1 2 3"
c      then:     nvals = 3; found = .false.
c                matrix(1,1) =  1;    matrix(1,2) = -999
c                matrix(2,1) =  2;    matrix(2,2) = -999
c                matrix(3,1) =  3;    matrix(3,2) = -999
c
c    - assume:   card  = "1   2 +- 3   4   5   6 +- 7"
c      then:     nvals = 5; found = .true.
c                matrix(1,1) =  1;    matrix(1,2) = -999
c                matrix(2,1) =  2;    matrix(2,2) = 3
c                matrix(3,1) =  4;    matrix(3,2) = -999
c                matrix(4,1) =  5;    matrix(4,2) = -999
c                matrix(5,1) =  6;    matrix(5,2) = 7
c
      character*( * ) plus_minus
      parameter (plus_minus = '+-')
      real zero
      parameter (zero = 0.00e+00)
c
      character*( * ) card
      integer ncard, mrows, nvals, nerror
      real matrix(mrows, 2)
      logical found
c
      integer len_plus_minus, ierror, jcol
      integer nextnb, nobs, ival
      logical done, xisrval, xisival
      real zeta, noval, r1mach
      external nextnb, r1mach, xisrval, xisival
c
      found = .false.
      ierror = 0
      nobs = 0
      noval = r1mach(6)
      jcol = nextnb(card, ncard, 1)
      len_plus_minus = len(plus_minus)
c
  110 continue
      done = ((jcol .gt. ncard) .or. (ierror .ne. 0))
      if ( .not. done) then
         if (xisrval(zeta, card, jcol)) then
            continue
         elseif (xisival(ival, card, jcol)) then
            zeta = real(ival)
         else
            ierror = 1
         endif
c
         if (ierror .eq. 0) then
            nobs = nobs + 1
            matrix(nobs, 1) = zeta
            matrix(nobs, 2) = noval
         elseif (card(jcol:jcol + len_plus_minus - 1) .eq. plus_minus) 
     &      then
            ierror = 0
            jcol = jcol + len_plus_minus
            if (xisrval(zeta, card, jcol)) then
               continue
            elseif (xisival(ival, card, jcol)) then
               zeta = real(ival)
            else
               ierror = 1
            endif
            if (ierror .eq. 0) then
               if (nobs .le. 0) then
                  nobs = nobs + 1
                  matrix(nobs, 1) = zero
               endif
               matrix(nobs, 2) = zeta
               found = .true.
            endif
         endif
         go to 110
      endif
      nerror = ierror
      nvals = nobs
c
      return
      end
      subroutine gtstr(zargs, nargs, np, nxtarg, carg)
c
c update:   wed 14:03 11-nov-1992.
c GTSTR.spg  processed by SPAG 3.14A  at 14:43 on 26 Oct 1992
c
      character*( * ) zargs( * ), carg
      integer nargs, np, nxtarg
c
      integer stderr, i1mach
      external i1mach, prargs
c
      include 'chars.def'
      include 'chars.sfn'
c
 9110 format (' ','?? gtstr: no argument')
c
      if (uwhite(zargs(nxtarg)(np:np))) then
         np = 1
         nxtarg = nxtarg + 1
         if (nxtarg .gt. nargs) then
            stderr = i1mach(4)
            write (stderr, 9110)
            call prargs(zargs, nargs, nxtarg, np)
            stop 'gtstr'
         endif
      endif
c
      carg = zargs(nxtarg)(np:)
      np = 1
      nxtarg = nxtarg + 1
c
      return
      end
      logical functionhavefish()
c
c update: 11:33 wed 17-aug-1994.
c determine if the "/species" card was detected;
c
c [tofix] 10:53 wed 17-aug-1994.
c this module is severely brain-impaired; it will need to be fixed when
c FGETS becomes interactive;
c;;
      include 'globpar.def'
c
      havefish = (gnspecies .gt. 0)
c
      return
      end
      subroutine heapinit()
c
c update: 16:33 fri 4-mar-1994.
c unitialize heap pointers
c;;
      include 'xglobal.par'
      include 'strings.par'
      include 'heap.def'
      include 'idfiles.def'
c
      integer jj
c
      sfree_heap = 1
      do jj = 1, maxheap - 1
         sheap_pointer(jj) = jj + 1
      enddo
      sheap_pointer(maxheap) = 0
c
      return
      end
      subroutine heapop(plist)
c
c update: 16:33 fri 4-mar-1994.
c release the first value from the linear list plist.
c the user should get the value Qhs(plist) before calling this module;
c;;
      include 'xglobal.par'
      include 'strings.par'
      include 'heap.def'
      include 'idfiles.def'
c
      integer plist, pnext
c
 9110 format (1x,'?? Heapop: stack is empty.')
c
      if (plist .eq. 0) then
         write (stdout, 9110)
         write (jerr, 9110)
         errused = .true.
         call errlog(.true., ' ', 0)
      endif
c
      pnext = plist     ! front of list         
      plist = sheap_pointer(pnext)      ! delete it from the free list
      sheap_pointer(pnext) = sfree_heap ! add it to the free plist
      sfree_heap = pnext
c
      return
      end
      subroutine heapush(plist)
c
c update: 16:33 fri 4-mar-1994.
c provide the address of the next storage position;
c the new info should be stored in Qhs(plist) (after calling this module);
c;;
      include 'xglobal.par'
      include 'strings.par'
      include 'heap.def'
      include 'idfiles.def'
c
      integer plist, pnext
c
 9110 format (1x,'?? Heapush: heap size exceeded.')
c
      if (sfree_heap .eq. 0) then
         write (stdout, 9110)
         write (jerr, 9110)
         errused = .true.
         call errlog(.true., ' ', 0)
      endif
c
      pnext = sfree_heap        ! obtain next location from heap
      sfree_heap = sheap_pointer(sfree_heap)    ! delete it from the free list
c
      sheap_pointer(pnext) = plist      ! add pnext to front of plist
      plist = pnext
c
      return
      end
      integer function i1mach(jj)
c
c I1MACH.spg  processed by SPAG 3.14A  at 13:10 on  8 Jan 1993
c\begin
c&    installed 6/03/83 - [LSR] (for pdp11/70)
c-    installed 7/18/85 - [LSR] epa
c-              added imach(17) = flag value
c     update: tue 10:23 27-oct-1992.
c
c  i/o unit numbers.
c     i1mach( 1) = the standard input unit.
c     i1mach( 2) = the standard output unit.
c     i1mach( 3) = the standard punch unit.
c     i1mach( 4) = the standard error message unit.
c
c  words.
c     i1mach( 5) = the number of bits per integer storage unit.
c     i1mach( 6) = the number of characters per integer storage unit.
c
c  integers.
c     assume integers are represented in the s-digit, base-a form
c     sign ( x(s-1)*a**(s-1) + ... + x(1)*a + x(0) )
c     where 0 .le. x(j) .lt. a for j=0,...,s-1.
c
c     i1mach( 7) = a, the base.
c     i1mach( 8) = s, the number of base-a digits.
c     i1mach( 9) = a**s - 1, the largest magnitude.
c
c
c  floating-point numbers.
c     assume floating-point numbers are represented in the t-digit,
c     base-b form
c     sign (b**e)*( (x(1)/b) + ... + (x(t)/b**t) )
c     where 0 .le. x(j) .lt. b for j=1,...,t,
c     0 .lt. x(1), and emin .le. e .le. emax.
c
c     i1mach(10) = b, the base.
c
c  single-precision
c     i1mach(11) = t, the number of base-b digits.
c     i1mach(12) = emin, the smallest exponent e.
c     i1mach(13) = emax, the largest exponent e.
c
c  double-precision
c     i1mach(14) = t, the number of base-b digits.
c     i1mach(15) = emin, the smallest exponent e.
c     i1mach(16) = emax, the largest exponent e.
c
c-    i1mach(17) = flag value unusual conditions.
c-                 the value is completely arbitrary.
c
c  to alter this function for a particular environment,
c  the desired set of data statements should be activated by
c  removing the c from column 1.  also, the values of
c  i1mach(1) - i1mach(4) should be checked for consistency
c  with the local operating system.
c\end
c
      integer imach(17), jj
c
c machine constants for Lahey FORTRAN, DOS operating system
c
      data imach(1) /5/
      data imach(2) /6/
      data imach(3) /6/
      data imach(4) /7/
      data imach(5) /32/
      data imach(6) /4/
      data imach(7) /2/
      data imach(8) /31/
      data imach(9) /2147483647/
      data imach(10) /2/
      data imach(11) /24/
      data imach(12) / -127/
      data imach(13) /127/
      data imach(14) /56/
      data imach(15) / -127/
      data imach(16) /127/
      data imach(17) / -999/
c
      i1mach = imach(17)
      if ((1 .le. jj) .and. (jj .le. 17)) i1mach = imach(jj)
c*
c* /* C source for I1MACH -- remove the * in column 1 */
c* /* Note that some values may need changing -- see the comments below. */
c*#include <stdio.h>
c*#include <float.h>
c*#include <limits.h>
c*#include <math.h>
c*
c*long i1mach_(long *i)
c*{
c*  switch(*i){
c*    case 1:  return 5; /* standard input  unit -- may need changing */
c*    case 2:  return 6; /* standard output unit -- may need changing */
c*    case 3:  return 7; /* standard punch  unit -- may need changing */
c*    case 4:  return 0; /* standard error  unit -- may need changing */
c*    case 5:  return 32;   /* bits per integer -- may need changing */
c*    case 6:  return 1; /* Fortran 77 value: 1 character */
c*           /*    per character storage unit */
c*    case 7:  return 2; /* base for integers -- may need changing */
c*    case 8:  return 31;   /* digits of integer base -- may need changing */
c*    case 9:  return LONG_MAX;
c*    case 10: return FLT_RADIX;
c*    case 11: return FLT_MANT_DIG;
c*    case 12: return FLT_MIN_EXP;
c*    case 13: return FLT_MAX_EXP;
c*    case 14: return DBL_MANT_DIG;
c*    case 15: return DBL_MIN_EXP;
c*    case 16: return DBL_MAX_EXP;
c*    }
c*
c*  fprintf(stderr, "invalid argument: i1mach(%ld)\n", *i);
c*  exit(1);
c*  return 0; /* for compilers that complain of missing return values */
c  }
c
      return
      end
      subroutine iactgill(cname, no_errors)
c
c update: 11:33 wed 17-aug-1994.
c /active_gill real_number
c
c 0 .lt.  real_number  .le. 1
c
c for the time being, input only one number per species;
c this number will be used for all year-classes of that species.
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'numbers.par'
      include 'Prompt.par'
      include 'strings.par'
      include 'token.par'
c
      include 'fish.def'
      include 'globpar.def'
      include 'heap.def'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      real rval
      integer xslen, ival, toktype, ptok
      logical havefish
      external havefish, xslen
c
 9110 format (' ?? "/',a,'" : expecting a number between zero and one.')
 9120 format (' ?? "/',a,'" : expecting one value.')
 9130 format (' ?? "/',a,'" : requires "/species" first.')
c
      call prompt(prset1, cname)
      ptok = 0
      call heapush(ptok)
c
      if (havefish()) then
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)
         no_errors = ((toktype .eq. treal) .or. (toktype .eq. tint))
         if (no_errors) then
            no_errors = ((zero .lt. rval) .and. (rval .le. one))
            if (no_errors) then
               activegill(gnspecies) = rval
            else
               write (stdout, 9110) cname
               call tokreset()
            endif
         else
            write (stdout, 9120) cname
            call tokreset()
         endif
      else
         no_errors = .false.
         write (stdout, 9130) cname
         call tokreset()
      endif
c
      call heapop(ptok)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine iatfile(cname, no_errors)
c
c update: 16:00 tue 5-apr-1994.
c read "@" - command file
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'menu.par'
      include 'idfiles.def'
      include 'echo.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      character*(stdlen) q1tmp
      integer nq1, xslen, xfopen, kstatus, uu, exitcode
      logical ishelp, isquit, havefile
      external xslen, xfopen, ishelp, isquit
c
 9110 format (1x,'reading from file "',a,'"')
 9120 format (1x,'?? command file "',a,'" does not exist.')
 9130 format (1x,'?? cannot read file "',a,'"')
c
      call mmgetsv(stdout, cname, '~//filename', exitcode, q1tmp, nq1)
      if (exitcode .ne. tquit) then
c
         inquire (file=q1tmp(1:nq1), exist=havefile)
         if (havefile) then
            kstatus = xfopen(uu, q1tmp(1:nq1), zioread)
            if (kstatus .eq. zioerror) then
               write (stdout, 9130) q1tmp(1:nq1)
               havefile = .false.
            else
               call freadpush(uu, havefile)
            endif
         else
            write (stdout, 9120) q1tmp(1:nq1)
         endif
c
         if (xecho) then
            if (havefile) then
               write (stdout, 9110) q1tmp(1:nq1)
            endif
         endif
      endif
c
  110 continue
      no_errors = (.true.)
      call tokreset()
c
      return
      end
      subroutine iaudit(cname, no_errors)
c
c update: 16:00 tue 5-apr-1994.
c generate an audit file
c
c /audit < file filename | on | off >
c
c file filename : will open the file "filename" for audit purposes;
c                 recording will be enabled also;
c
c on            : enable command recording; if the audit file was not set
c                 the default audit file will be opened.
c
c off           : disable audit trail
c
c Xauditff:  truth of generate audit file, audit file was opened
c Xauditon:  truth of issue the current command to the audit file
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'menu.par'
      include 'Prompt.par'
      include 'strings.par'
      include 'chars.def'
      include 'echo.def'
      include 'hits.def'
      include 'idfiles.def'
      include 'options.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      integer nopts
      parameter (nopts = 5)
c
      character*(stdlen) q1tmp, nameopts(nopts)
      character*(s40) helpopts(nopts)
      integer nq1, xslen, idd, exitcode, xfopen
      logical xfirst, isempty, toshow
      external xslen, xfopen, isquit, isempty
c
      save helpopts, nameopts
c
      include 'chars.sfn'
      data xfirst /.true./
c
 9110 format (1x,'?? could not open audit file')
 9120 format (1x,'?? extraneous characters after valid command ignored:'
     &   )
 9130 format (1x,'audit is on, file = ',a)
 9140 format (1x,'audit is off')
 9150 format (1x,3x,'audit ',a)
c
      if (xfirst) then
         xfirst = .false.
         helpopts(1) = '~/audit/filename'
         nameopts(1) = tmnreturn // 'f2. file <filename>    ! set name o
     &f audit file; enable audit trail'
         helpopts(2) = '~/audit/on'
         nameopts(2) = tmnreturn // 
     &      'n3. on                 ! enable audit trail'
         helpopts(3) = '~/audit/off'
         nameopts(3) = tmnreturn // 
     &      'o4. off                ! disable audit trail'
         helpopts(4) = '~//help'
         nameopts(4) = tmnhelp // 'h1. ? | help'
         helpopts(5) = '~//quit'
         nameopts(5) = tmnquit // 'q0. quit'
      endif
c
      no_errors = (.true.)
      call prompt(prset1, cname)
c
      toshow = (isempty())
  110 continue
      call mmgetopt(stdout, toshow, nameopts, helpopts, nopts, xhits, 
     &   idd)
      if (idd .eq. tquit) then
         go to 120
      elseif (idd .eq. thelp) then      ! should never happen            
         call tokreset()
         go to 110
      endif
c
      continue
      if (idd .eq. 1) then      ! file                           
         call mmgetsv(stdout, cname // 'file', helpopts(1), exitcode, 
     &      q1tmp, nq1)
         if (exitcode .eq. tquit) then
            continue
         else
            audfil = q1tmp
            if (audfil(1:1) .eq. eol) then
               nq1 = xslen(pgmfil)
               audfil = pgmfil(1:nq1) // '.fau'
            endif
            if (xauditff) then  ! a previous file was opened: close it
               call xfclose(jaud)
               xauditff = .false.
            endif
            xauditff = (zioerror .ne. xfopen(jaud, audfil, ziowrite))
            xauditon = (xauditff)
            if ( .not. xauditff) then
               write (stdout, 9110) cname
            endif
         endif
c
      elseif (idd .eq. 2) then  ! on                             
         if ( .not. xauditff) then      ! no previous file, open the default
            nq1 = xslen(pgmfil)
            audfil = pgmfil(1:nq1) // '.fau'
         endif
         xauditff = (zioerror .ne. xfopen(jaud, audfil, ziowrite))
         xauditon = (xauditff)
         if ( .not. xauditff) then
            write (stdout, 9110)
         endif
c
      elseif (idd .eq. 3) then  ! off                            
         xauditon = .false.
c
      else
         write (stdout, 9110) idd
         call tokreset()
         go to 110
      endif
c
c the buffer should be empty at this time
c
      if ( .not. isempty()) then
         write (stdout, 9120)
      endif
      call tokreset()
c
  120 continue
      if (xecho) then
         if (xauditon) then
            nq1 = xslen(audfil)
            write (stdout, 9130) audfil(1:nq1)
            write (jaud, 9150) audfil(1:nq1)
         else
            write (stdout, 9140)
         endif
      endif
      call prompt(prpop, ' ')
      call tokreset()
c
      return
      end
      subroutine iburden(cname, no_errors)
c
c update: 16:33 fri 4-mar-1994.
c set burden mode: laboratory, food_chain, or food_web
c
c /burden   laboratory (...)
c /burden   food_chain (...)
c /burden   food_web
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'Prompt.par'
      include 'simul.par'
      include 'strings.par'
      include 'token.par'
c
      include 'heap.def'
      include 'idfiles.def'
      include 'options.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
c local variables:
c
      real rval
      integer ival, toktype, xslen, nss, sumerr, ptok
      logical xxok
      external xslen
c
 9110 format (1x,'?? "/',a,'" : no such option.')
 9120 format (1x,'?? "/',a,'" : valid options are:',/,1x,
     &   '   laboratory(...) food_chain(...) food_web')
c
      call prompt(prset1, cname)
      ptok = 0  ! assign heap storage            
      call heapush(ptok)
c
      sumerr = 0
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)
      nss = xslen(qhs(ptok))
c
      if (qhs(ptok)(1:nss) .eq. 'laboratory') then
         simul_mode = tlaboratory
         call ilab(qhs(ptok)(1:nss), xxok)
c
      elseif (qhs(ptok)(1:nss) .eq. 'food_chain') then
         simul_mode = tfood_chain
         call ichain(qhs(ptok)(1:nss), xxok)
c
      elseif (qhs(ptok)(1:nss) .eq. 'food_web') then
         simul_mode = tfood_web
c
      else
         sumerr = sumerr + 1
         write (stdout, 9110) cname
         call tokreset()
      endif
c
      if (sumerr .gt. 0) then
         write (stdout, 9120) cname
      endif
      no_errors = (sumerr .eq. 0)
      call heapop(ptok)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine icatalog(cname, no_errors)
c
c update: fri 16:44 13-mar-1992.
c @@@@
c
c declaration of fortran parameters
c;;
c
c declarations of subroutine's formal parameters
c
      include 'Prompt.par'
c
      character*( * ) cname
      logical no_errors
c
      call prompt(prset1, cname)
      no_errors = (.false.)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine icfinit(cname, no_errors)
c
c update: 11:33 wed 17-aug-1994.
c /initial_cf #id1[-#id2] #val_1 #val_2 ... #val_n
c
c - #id1[-#id2] : year class identifier; may be an integer or a range;
c   examples:
c     / initial_cf 1-2 0.0 ... 0.0_n
c        ! concentration of chemical in fish for year classes 1 and 2 is zero.
c     / initial_cf 3 1.0 ... 1.0_n
c        ! concentration of chemical in fish for year class 3 is one.
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'Prompt.par'
      include 'strings.par'
      include 'token.par'
c
      include 'fish.def'
      include 'globpar.def'
      include 'heap.def'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      real rval
      integer ival, toktype, jage, jchem, kbeg, kend, ptok
      logical xxok, done, havefish
      external havefish
c
 9110 format (' ?? "/',a,'" : expects ',i3,
     &   ' chemical concentrations in fish.')
 9120 format (' ?? "/',a,'" : requires "/species" first.')
c
      call prompt(prset1, cname)
      ptok = 0
      call heapush(ptok)
c
      if ( .not. havefish()) then
         xxok = .false.
         write (stdout, 9120) cname
         call tokreset()
         go to 120
      endif
c
c get the yearclass identifier(s)
c
      call irange(cname, xxok, xmaximum_age(gnspecies), kbeg, kend)
      if ( .not. xxok) then
         call tokreset()
         go to 120
      endif
c
      jchem = 1
  110 continue
      done = (jchem .gt. gnchem) .or. ( .not. xxok)
      if ( .not. done) then
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)
         xxok = ((toktype .eq. treal) .or. (toktype .eq. tint))
         if (xxok) then
            do jage = kbeg, kend
               vv_inicf(jchem, jage, gnspecies) = rval
            enddo
            jchem = jchem + 1
         endif
         go to 110
      endif
c
      if ( .not. xxok) then
         call tokpush()
         write (stdout, 9110) cname, gnchem
         call tokreset()
      endif
c
  120 continue
      call heapop(ptok)
      no_errors = (xxok)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine icfood(cname, no_errors)
c
c update: 16:33 fri 4-mar-1994.
c set concentration of chemical in the food - laboratory option
c the token just read was "="; read until "," or ")"
c
c [cfood = ] string  arg(s)  < , or ) >
c
c     string        arg(s)
c    ------------   ---------------------
c     constant      #conc_chem_1 #conc_chem_2 ... #conc_chem_nchem
c     equilibrium   #pl_food     #bmf_1 #bmf_2 ... #bmf_nchem
c
c the strings are input without quotes.
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'habitat.par'
      include 'Prompt.par'
      include 'simul.par'
      include 'strings.par'
      include 'token.par'
c
      include 'globpar.def'
      include 'habitat.def'
      include 'heap.def'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      real rval
      integer ival, toktype, jchem, ptok
      logical xxok, done
c
 9110 format (' ?? "',a,'" : "equilibrium" expects ',i3,' BMF''s.')
 9120 format (' ?? "',a,'" : "equilibrium" expects "pl", followed by ',
     &   i3,' BMF''s.')
 9130 format (' ?? "',a,'" : "constant" expects ',i3,
     &   ' chem concentrations in food.')
 9140 format (' ?? "',a,'" : expects "constant" or "equilibrium"')
c
      call prompt(prset1, cname)
      ptok = 0  ! assign heap storage            
      call heapush(ptok)
c
      xxok = .true.
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)
c
      if (qhs(ptok) .eq. 'equilibrium') then
         food_chem_func = tequilibrium
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)
         xxok = ((toktype .eq. treal) .or. (toktype .eq. tint))
         if (xxok) then
            food_pl = rval
            jchem = 1
  110       continue
            done = (jchem .gt. gnchem) .or. ( .not. xxok)
            if ( .not. done) then
               call toknext(ttoken, qhs(ptok), ival, rval, toktype)
               xxok = ((toktype .eq. treal) .or. (toktype .eq. tint))
               if (xxok) then
                  food_bmf(jchem) = rval
                  jchem = jchem + 1
               endif
               go to 110
            endif
            if ( .not. xxok) then
               call tokpush()
               write (stdout, 9110) cname, gnchem
               call tok2dlim(',)', qhs(ptok))
            endif
         else
            call tokpush()
            write (stdout, 9120) cname, gnchem
            call tok2dlim(',)', qhs(ptok))
         endif
c
      elseif (qhs(ptok) .eq. 'constant') then
         food_chem_func = tconstant
         jchem = 1
  120    continue
         done = (jchem .gt. gnchem) .or. ( .not. xxok)
         if ( .not. done) then
            call toknext(ttoken, qhs(ptok), ival, rval, toktype)
            xxok = ((toktype .eq. treal) .or. (toktype .eq. tint))
            if (xxok) then
               food_chem_conc(jchem) = rval
               jchem = jchem + 1
            endif
            go to 120
         endif
         if ( .not. xxok) then
            call tokpush()
            write (stdout, 9130) cname, gnchem
            call tok2dlim(',)', qhs(ptok))
         endif
c
      else
         xxok = .false.
         write (stdout, 9140) cname
         call tok2dlim(',)', qhs(ptok))
      endif
c
      no_errors = (xxok)
      call heapop(ptok) ! release heap storage                 
      call prompt(prpop, ' ')
c
      return
      end
      subroutine ichain(cname, no_errors)
c
c update: 16:33 fri 4-mar-1994.
c get food-chain system parameters
c
c food_chain (predator = "Predator Species name",
c             prey = <prey_item>,
c             prey_food = <prey_food_item>)
c
c <prey_item> == "Prey Species name" | plankton | benthos | cfish
c <prey_food_item> == plankton | benthos | cfish | Null
c
c notes:
c  - if the argument is "Null" then it is not required to input "prey_food"
c
c  - if "plankton | benthos | cfish" is selected, the chemical concentrations
c    will be provided through the "/cplankton | /cbenthos | /cfish" command
c
c  - prey = "plankton | benthos | cfish" ==> only one fish will be modelled;
c    prey_food = Null  is the only valid option in that case.
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'habitat.par'
      include 'noval.par'
      include 'phylum.par'
      include 'Prompt.par'
      include 'simul.par'
      include 'strings.par'
      include 'token.par'
c
      include 'habitat.def'
      include 'heap.def'
      include 'idfiles.def'
c
      logical no_errors
      character*( * ) cname
c
      integer ival, nss, xslen, sumerr, toktype, ptok
      real rval
      logical xxok
      external xslen
c
 9110 format (' ?? "',a,'" : no arguments.')
 9120 format (' ?? "',a,
     &   '" : "predator" requires a quoted "Species name"')
 9130 format (' ?? "',a,'" : "prey" requires a quoted "Species name"',
     &   '    "plankton", "benthos", or "cfish"')
 9140 format (' ?? "',a,'" : "prey_food" requires "plankton", "benthos",
     & "cfish", or "Null"')
 9150 format (' ?? "',a,'" : expects "predator", "prey", or "prey_food"'
     &   )
 9160 format (' ?? "',a,'" option "',a,'" not set')
 9170 format (' ?? "',a,'" prey = "Species name"',/,
     &   '    requires prey_food = "plankton", "benthos", "cfish"')
 9180 format (' ?? "',a,'" prey = "plankton", "benthos", "cfish"',/,
     &   '    requires prey_food = "Null"')
c
      call prompt(prset1, cname)
      ptok = 0
      call heapush(ptok)
c
      fc_spredator = snoval
      fc_predatort = inoval
      fc_predatorp = inoval
      fc_sprey = snoval
      fc_preyt = inoval
      fc_preyp = inoval
      fc_sprey_food = snoval
      fc_prey_foodt = inoval
      fc_prey_foodp = inoval
c
      xxok = .true.
      sumerr = 0
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)      ! "("    
      if (qhs(ptok)(1:1) .ne. '(') then
         sumerr = sumerr + 1
         write (stdout, 9110) cname
         call tokreset()
         go to 120
      endif
c
  110 continue
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)
      if (qhs(ptok)(1:1) .eq. ',') then
         go to 110
      elseif (qhs(ptok)(1:1) .eq. ')') then
         go to 120
      endif
      nss = xslen(qhs(ptok))
c
      if (qhs(ptok)(1:nss) .eq. 'predator') then
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)   ! "=" 
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)   ! tqstr
         xxok = (toktype .eq. tqstr)
         if ( .not. xxok) then
            sumerr = sumerr + 1
            write (stdout, 9120) cname
            call tokreset()
            go to 120
         endif
         call ustripd(qhs(ptok), -1, fc_spredator, nss)
         call up2lo(fc_spredator, nss)
         fc_predatort = tspecies
c
      elseif (qhs(ptok)(1:nss) .eq. 'prey') then
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)   ! "="    
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)   ! tqstr or tident
         if (toktype .eq. tqstr) then
            xxok = .true.
            call ustripd(qhs(ptok), -1, fc_sprey, nss)
            call up2lo(fc_sprey, nss)
            fc_preyt = tspecies
         elseif (toktype .eq. tident) then
            xxok = .true.
            call ustripd(qhs(ptok), -1, fc_sprey, nss)
            call up2lo(fc_sprey, nss)
            if (fc_sprey .eq. 'plankton') then
               fc_preyt = tplankton
            elseif (fc_sprey .eq. 'benthos') then
               fc_preyt = tbenthos
            elseif (fc_sprey .eq. 'cfish') then
               fc_preyt = tcfish
            else
               xxok = .false.
            endif
         else
            xxok = .false.
         endif
c
         if ( .not. xxok) then
            sumerr = sumerr + 1
            write (stdout, 9130) cname
            call tokreset()
            go to 120
         endif
c
      elseif (qhs(ptok)(1:nss) .eq. 'prey_food') then
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)   ! "="    
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)   ! tident 
         if (toktype .eq. tident) then
            xxok = .true.
            call ustripd(qhs(ptok), -1, fc_sprey_food, nss)
            call up2lo(fc_sprey_food, nss)
            if (fc_sprey_food .eq. 'plankton') then
               fc_prey_foodt = tplankton
            elseif (fc_sprey_food .eq. 'benthos') then
               fc_prey_foodt = tbenthos
            elseif (fc_sprey_food .eq. 'cfish') then
               fc_prey_foodt = tcfish
            elseif (fc_sprey_food .eq. 'Null') then
               fc_prey_foodt = inoval
            else
               xxok = .false.
            endif
         else
            xxok = .false.
         endif
c
         if ( .not. xxok) then
            sumerr = sumerr + 1
            write (stdout, 9140) cname
            call tokreset()
            go to 120
         endif
c
      else
         sumerr = sumerr + 1
         write (stdout, 9150) cname
         call tokreset()
      endif
      go to 110
c
  120 continue
c
      if (sumerr .eq. 0) then   ! make sure everything was set
         if (fc_predatort .eq. inoval) then
            sumerr = sumerr + 1
            write (stdout, 9160) cname, 'predator'
         endif
c
         if (fc_preyt .eq. inoval) then
            sumerr = sumerr + 1
            write (stdout, 9160) cname, 'prey'
         elseif (fc_preyt .eq. tspecies) then
            if ((fc_prey_foodt .eq. tplankton) .or. (fc_prey_foodt .eq.
     &         tbenthos) .or. (fc_prey_foodt .eq. tcfish)) then
               continue
            else
               sumerr = sumerr + 1
               write (stdout, 9170) cname
            endif
         else   ! Fc_preyt == tplankton | tbenthos | TCfish
            if ((fc_prey_foodt .eq. inoval) .or. (fc_prey_foodt .eq. 
     &         inoval)) then
               continue
            else
               sumerr = sumerr + 1
               write (stdout, 9180) cname
            endif
         endif
      endif
c
c!~14!c If (a = inoval) then a = inoval; What is this? 13:10 thu 10-dec-1992.
c
      if (sumerr .eq. 0) then
         if (fc_prey_foodt .eq. inoval) then
            fc_prey_foodt = inoval
         endif
      endif
c
      no_errors = (sumerr .eq. 0)
      call heapop(ptok)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine ichemicals(cname, no_errors, nchem)
c
c update: 17:26 fri 4-mar-1994.
c / chemicals integer
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'menu.par'
      include 'noval.par'
c
      include 'echo.def'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      integer nchem
      logical no_errors
c
      character*(stdlen) q1tmp
      integer ival, exitcode, nq1
      logical xxok
c
 9110 format (1x,'number of chemicals = ',a)
 9120 format (1x,'?? chemical number is not in the range 1 to ',a)
c
      call mmgetiv(stdout, cname, '~//integer', exitcode, ival)
      if (exitcode .ne. tquit) then
c
         xxok = ((1 .le. ival) .and. (ival .le. maxchem))
         if (xxok) then
            nchem = ival
         else
            call int2a(maxchem, q1tmp, nq1)
            write (stdout, 9120) q1tmp(1:nq1)
         endif
      endif
c
  110 continue
      if (xecho) then
         if (nchem .ne. inoval) then
            call int2a(nchem, q1tmp, nq1)
            write (stdout, 9110) q1tmp(1:nq1)
         else
            write (stdout, 9110) snoval
         endif
      endif
      call tokreset()
      no_errors = (xxok)
c
      return
      end
      subroutine iclear(cname, no_errors)
c
c update: wed 09:25 6-may-1992.
c clear all fish, chemicals, etc.; restore system to its initial (pristine)
c state.
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      call initvar()
      call tokreset()
c
      return
      end
      subroutine icw(cname, no_errors)
c
c update: 17:44 fri 4-mar-1994.
c
c /cwater  #chem_number  file       #file-spec
c /cwater  #chem_number  constant   #1
c /cwater  #chem_number  Sin        #1 #2 #3 #4
c /cwater  #chem_number  Exp        #1 #2 #3
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'expos.par'
      include 'habitat.par'
      include 'Prompt.par'
      include 'simul.par'
      include 'strings.par'
      include 'token.par'
c
      include 'globpar.def'
      include 'habitat.def'
      include 'heap.def'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      real rval
      integer ival, toktype, jchem, xslen, ntt, nss, ptok
      logical xxok
      external xslen
c
 9110 format (' ?? "/',a,'" : requires a chemical number.')
 9120 format (' ?? "/',a,'" : jchem = ',i3,' not in [1 ..',i3,']')
 9130 format (' ?? "/',a,'" : /temp and /cwater "file" option ',
     &   'should Access the same exposure file:',/,'    "',a,'" vs "',a,
     &   '"')
 9140 format (' ?? "/',a,'" : unrecognized option;',/,
     &   '    valid options are: "file", "constant", "Sin", or "Exp".')
c
      call prompt(prset1, cname)
      ptok = 0  ! assign heap storage      
      call heapush(ptok)
c
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)
      xxok = (toktype .eq. tint)        ! #jchem                   
      if ( .not. xxok) then
         write (stdout, 9110) cname
         call tokreset()
         go to 110
      endif
c
      jchem = ival
      xxok = ((1 .le. jchem) .and. (jchem .le. gnchem)) ! jchem in range ?
      if ( .not. xxok) then
         write (stdout, 9120) cname, jchem, gnchem
         call tokreset()
         go to 110
      endif
c
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)
      if (qhs(ptok) .eq. 'file') then
         cwfunc(jchem) = tfile
         call tok2dlim(eol, qhs(ptok))
         call ustripd(qhs(ptok), -1, qhs(ptok), nss)
         if (iread_cw .eq. tf1func) then
            xxok = (qhs(ptok) .eq. cwfil)
            if ( .not. xxok) then
               nss = xslen(qhs(ptok))
               ntt = xslen(cwfil)
               write (stdout, 9130) cname, cwfil(1:ntt), 
     &            qhs(ptok)(1:nss)
            endif
         endif
         cwfil = qhs(ptok)
         iread_cw = tf1func
c
      else
         xxok = ((qhs(ptok) .eq. 'Sin') .or. (qhs(ptok) .eq. 'Exp') .or.
     &      (qhs(ptok) .eq. 'constant'))
         if (xxok) then
            call tokpush()
            call ifargs(cname, cwfunc(jchem), cwpar(1, jchem), xxok)
         endif
      endif
c
      if ( .not. xxok) then
         write (stdout, 9140) cname
         call tokreset()
      endif
c
  110 continue
      call heapop(ptok)
      no_errors = (xxok)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine idescribe(cname, no_errors)
c
c update: fri 16:44 13-mar-1992.
c @@@@
c
c declaration of fortran parameters
c;;
      include 'Prompt.par'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      call prompt(prset1, cname)
      no_errors = (.false.)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine idiet(cname, no_errors)
c
c update: 11:33 wed 17-aug-1994.
c
c WARNING:  /diet  should be the last command of the file, after all fish
c                  have been defined.
c Syntax:
c      labels (lab1: "species name 1", lab2: "species name 2", ...)
c         ! sets lab1 to point to the particular species
c         ! example:
c         !     labels (trout: "oncorhynchus mykiss")
c
c      labj (#year_class, #percentages)
c         ! year class "#year_class" will feed as stated (see examples)
c         !     all percentages live in [0, 1];
c         !     sum of percentages = 1;
c
c example:
c / species       oncorhynchus mykiss     ! rainbow trout
c / maximum_age   5
c / species       alosa pseudoharengus    ! alewife
c / maximum_age   3
c / species       osmerus mordax          ! smelt
c / maximum_age   1
c / diet
c     labels (smelt: "osmerus mordax", trout: "oncorhynchus mykiss",
c             alewife: "alosa pseudoharengus")
c     trout (weight =   1 -   3: plankton = 1.0)
c     trout (weight =   3 -  30: plankton = 0.60, benthos = 0.40)
c     trout (weight =  30 - 100: plankton = 0.10, benthos = 0.40,
c                                alewife = 0.30, smelt = 0.20)
c     trout (weight = 100 - 500: plankton = 0.10, benthos = 0.10,
c                                trout = 0.10, alewife = 0.35, smelt = 0.35)
c     alewife (age = 1: ... percentages)
c     alewife (age = 2-3: ... percentages)
c     smelt (age = 1: ... percentages)
c
c     alewife (length = 2 - 3: ... percentages)
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'fish.par'
      include 'noval.par'
      include 'Prompt.par'
      include 'strings.par'
      include 'token.par'
c
      include 'diet.def'
      include 'globpar.def'
      include 'heap.def'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      real rval
      integer ival, toktype, xslen, ptok
      integer sumerr, jspecies
      logical havefish, xxok, xlast
      external xslen, havefish
c
 9110 format (' ?? "/',a,'" : requires "/species" first.')
c
      sumerr = 0
      call prompt(prset1, cname)
      ptok = 0  ! assign heap storage               
      call heapush(ptok)
c
      if ( .not. havefish()) then
         sumerr = sumerr + 1
         write (stdout, 9110) cname
         go to 120
      endif
c
      xdiet = .true.
      xlast = .true.
      call setages(xlast)       ! determine total number of fish.           
c
      do jspecies = 1, gnspecies
         range_type(jspecies) = inoval
         dietlabels(jspecies) = snoval
         range_numof(jspecies) = 0
      enddo
c
  110 continue
      xxok = .true.
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)
      if (qhs(ptok)(1:1) .eq. '/') then
         call tokpush()
         go to 120
      endif
c
      if (qhs(ptok) .eq. 'labels') then
         call idiet1(cname, xxok)
      else
         call tokpush() ! save for Idiet2              
         call idiet2(cname, xxok)
      endif
      if ( .not. xxok) sumerr = sumerr + 1
      go to 110
c
  120 continue
      no_errors = (sumerr .eq. 0)
      call heapop(ptok) ! release heap storage          
      call prompt(prpop, ' ')
c
      return
      end
      subroutine idiet1(cname, no_errors)
c
c update: 16:33 fri 4-mar-1994.
c
c read and decode "labels" command
c labels (lab1: "species_name_1", lab2: "species_name_2", ...)
c    ! sets lab1 to point to the particular species
c    ! example:
c    !     labels (trout: "oncorhynchus mykiss")
c the labels "plankton", benthos", and "cfish" are reserved;
c
c example:
c let
c     / species      oncorhynchus mykiss     ! rainbow trout
c     / maximum_age  5
c
c     / species      alosa pseudoharengus    ! alewife
c     / maximum_age  3
c
c     / species      osmerus mordax          ! smelt
c     / maximum_age  1
c
c     / diet
c           labels (smelt: "osmerus mordax", trout: "oncorhynchus mykiss",
c                   alewife: "alosa pseudoharengus")
c then
c     Gnspecies = 3
c        j        Spplab(j)         Dietlabels(j)
c        -  ----------------------  -------------
c        1  "oncorhynchus mykiss"     "trout"
c        2  "alosa pseudoharengus"    "alewife"
c        3  "osmerus mordax"          "smelt"
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'noval.par'
      include 'Prompt.par'
      include 'strings.par'
      include 'token.par'
c
      include 'diet.def'
      include 'fish.def'
      include 'globpar.def'
      include 'heap.def'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      character*(stdlen) qlab, qtok
      real rval
      integer ival, toktype, xslen, nss, sumerr, jspecies
      integer npos, tnext
      logical xxok, found, srchll0
      external xslen, srchll0
c
 9110 format (' ?? "/',a,'" : "labels" : expecting an identifier.')
 9120 format (' ?? "/',a,'" : "labels" : expecting a quoted string.')
 9130 format (' ?? "/',a,'" : "labels" : species not found.')
 9140 format (' ?? "/',a,'" : "labels" not set for "',a,'"')
 9150 format (' ?? "/',a,'" : "labels" : expecting an "(".')
 9160 format (' ?? "/',a,'" : "labels" : expecting a ":".')
 9170 format (' ?? "/',a,'" : "labels" : unexpected character; ',
     &   'expecting ',a,'.')
 9180 format (' ?? "/',a,'" : "labels" : expecting a ",".')
c
      call prompt(prset1, cname)
c
      sumerr = 0
      call toknext(ttoken, qtok, ival, rval, toktype)   ! "("      
      if (qtok(1:1) .ne. '(') then
         sumerr = sumerr + 1
         write (stdout, 9150) cname
         call tokreset()
         go to 120
      endif
c
      tnext = tident
  110 continue
      call toknext(ttoken, qtok, ival, rval, toktype)   ! labj ?    
      if (qtok(1:1) .ne. ')') then
c
         if (tnext .eq. toktype) then
            if (toktype .eq. toper) then
               if (qtok(1:1) .eq. ',') then
                  call toknext(ttoken, qtok, ival, rval, toktype)
               else
                  sumerr = sumerr + 1
                  write (stdout, 9180) cname
                  call tokreset()
                  go to 120
               endif
            elseif (toktype .ne. tident) then
               sumerr = sumerr + 1
               write (stdout, 9110) cname
               call tokreset()
               go to 120
            endif
         else
            sumerr = sumerr + 1
            if (tnext .eq. tident) then
               write (stdout, 9170) cname, 'an identifier (a name)'
            elseif (tnext .eq. treal) then
               write (stdout, 9170) cname, 'a Real number'
            elseif (tnext .eq. tint) then
               write (stdout, 9170) cname, 'an integer'
            elseif (tnext .eq. tqstr) then
               write (stdout, 9170) cname, 'a quoted-string'
            elseif (tnext .eq. toper) then
               write (stdout, 9170) cname, 'an operator'
            endif
            call tokreset()
            go to 120
         endif
c
         xxok = (toktype .eq. tident)
         if ( .not. xxok) then
            sumerr = sumerr + 1
            write (stdout, 9110) cname
            call tokreset()
            go to 120
         endif
c
         qlab = qtok    ! hold "trout"           
         call toknext(ttoken, qtok, ival, rval, toktype)        ! ":"       
         if (qtok(1:1) .ne. ':') then
            sumerr = sumerr + 1
            write (stdout, 9160) cname
            call tokreset()
            go to 120
         endif
c
         call toknext(ttoken, qtok, ival, rval, toktype)        ! tqstr     
         xxok = (toktype .eq. tqstr)
         if ( .not. xxok) then
            sumerr = sumerr + 1
            write (stdout, 9120) cname
            call tokreset()
            go to 120
         endif
c
c find the fish, linear search
c
         call ustripd(qtok, -1, qtok, nss)
         call up2lo(qtok, nss)
         found = srchll0(qtok(1:nss), spplab, gnspecies, npos)
c
c label not found; read and ignore tokens until a comma or
c close-parenthesis is found; return to the top loop to continue.
c
         tnext = toper
         if ( .not. found) then
            sumerr = sumerr + 1
            write (stdout, 9130) cname
            call tok2dlim(',)', qtok)
            go to 110
         endif
         dietlabels(npos) = qlab
         go to 110
      endif
c
  120 continue
      if (sumerr .eq. 0) then   ! if no errors detected ...
         do jspecies = 1, gnspecies
            if (dietlabels(jspecies) .eq. snoval) then
               sumerr = sumerr + 1
               nss = xslen(spplab(jspecies))
               write (stdout, 9140) cname, spplab(jspecies)(1:nss)
            endif
         enddo
      endif
c
      call prompt(prpop, ' ')
      no_errors = (sumerr .eq. 0)
      return
      end
      subroutine idiet2(cname, no_errors)
c
c update: 11:45 fri 9-sep-1994.
c
c read and decode food web
c syntax below
c
c example:
c / diet
c     labels (smelt: "osmerus mordax", trout: "oncorhynchus mykiss",
c             alewife: "alosa pseudoharengus")
c     trout (weight =   1 -   3: plankton = 1.0)
c     trout (weight =   3 -  30: plankton = 0.60, benthos = 0.40)
c     trout (weight =  30 - 100: plankton = 0.10, benthos = 0.40,
c                                alewife = 0.30, smelt = 0.20)
c     trout (weight = 100 - 500: plankton = 0.10, benthos = 0.10,
c                                trout = 0.10, alewife = 0.35, smelt = 0.35)
c     alewife (age = 1: ... percentages)
c     alewife (age = 2-3: ... percentages)
c     smelt (age = 1: ... percentages)
c
c     carp (length =   1 -   3: plankton = 1.0)
c     carp (length =   3 -  30: plankton = 0.60, benthos = 0.40)
c     carp (length =  30 - 100: plankton = 0.10, benthos = 0.40,
c                               alewife = 0.30, smelt = 0.20)
c
c let
c    Gnspecies = 3
c    j        Spplab(j)         Dietlabels(j)
c    -  ----------------------  -------------
c    1  "oncorhynchus mykiss"     "trout"
c    2  "alosa pseudoharengus"    "alewife"
c    3  "osmerus mordax"          "smelt"
c
c    f1 == Fdiet(1,k,j) ! fraction species 1 is of diet of species j, k-th range
c    f2 == Fdiet(2,k,j) !    ...           2 ...
c    f3 == Fdiet(3,k,j) !    ...           3 ...
c    fp == Fdiet(pplankton,k,j)  ! ... plankton ...
c    fb == Fdiet(pbenthos,k,j)   ! ... benthos ...
c
c j = 1 .. Gnspecies
c     j = 1;
c        Spplab(j) = "oncorhynchus mykiss";
c        Range_type (j)  = tweight;
c        Range_numof (j) = 4;
c        k = 1 .. Range_numof (j)
c           k  lowb(k)  uppb(k)   f1    f2    f3    fp    fb
c           -  -------  -------  ----  ----  ----  ----  ----
c           1     1        3     0.00  0.00  0.00  1.00  0.00
c           2     3       30     0.00  0.00  0.00  0.60  0.40
c           3    30      100     0.00  0.30  0.20  0.10  0.40
c           4   100      500     0.10  0.35  0.35  0.10  0.10
c
c     j = 2;
c        Spplab(j) = "alosa pseudoharengus";
c        Range_type (j)  = tage;
c        Range_numof (j) = 2;
c        k = 1 .. Range_numof (j)
c           k  lowb(k)  uppb(k)   f1    f2    f3    fp    fb
c           -  -------  -------  ----  ----  ----  ----  ----
c           1     1        1     ... percentages ...
c           2     2        3     ... percentages ...
c
c     j = 3;
c        Spplab(j) = "osmerus mordax";
c        Range_type (j)  = tage;
c        Range_numof (j) = 1;
c        k = 1 .. Range_numof (j)
c           k  lowb(k)  uppb(k)   f1    f2    f3    fp    fb
c           -  -------  -------  ----  ----  ----  ----  ----
c           1     1        1     ... percentages ...
c
c NB: for "tage", make sure all age classes are covered.
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'habitat.par'
      include 'noval.par'
      include 'numbers.par'
      include 'Prompt.par'
      include 'simul.par'
      include 'strings.par'
      include 'token.par'
c
      include 'diet.def'
      include 'fish.def'
      include 'globpar.def'
      include 'habitat.def'
      include 'heap.def'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
c got_item(jj) :: truth of "already found food web item (jj)"
c
      character*(stdlen) q1tmp
      real rval, total_fraction, rv1, rv2
      integer ival, toktype, xslen, sumerr
      integer krange, jprey, jpredator, nlen, ttype
      logical xxok, found, srchll0, trne, tosum
      logical got_item(maxbiota)
      external xslen, srchll0, trne
c
 9110 format (' ?? "/',a,
     &   '" : expecting a previously defined species identifier')
 9120 format (' ?? "/',a,
     &   '" : expecting a previously defined species identifier, ',/,
     &   '    or "benthos" , "plankton" or "cfish".')
 9130 format (' ?? "/',a,
     &   '" : expecting a number between zero and one (inclusive).')
 9140 format (' ?? "/',a,
     &   '" : sum of diet fractions must be equal to 1.00 .')
 9150 format (' ?? "/',a,'" : duplicated foodweb item.')
 9160 format (' ?? "/',a,'" : expecting "age", "weight" or "length"')
 9170 format (' ?? "/',a,'" : non contiguous range.')
 9180 format (' ?? "/',a,'" : too many ranges; increase "maxrange"')
 9190 format (' ?? "/',a,
     &   '" : all ranges for this species must be either ',
     &   ' "age", "weight" or "length"')
c
      call prompt(prset1, cname)
c
      sumerr = 0
      call toknext(ttoken, q1tmp, ival, rval, toktype)  ! labj ?     
      xxok = (toktype .eq. tident)
      if ( .not. xxok) then
         sumerr = sumerr + 1
         write (stdout, 9110) cname
         call tokreset()
         go to 120
      endif
c
c identify predator species
c
      nlen = xslen(q1tmp)
      found = srchll0(q1tmp(1:nlen), dietlabels, gnspecies, jpredator)
      xxok = (found)
      if ( .not. xxok) then
         sumerr = sumerr + 1
         write (stdout, 9110) cname
         call tokreset()
         go to 120
      endif
      call toknext(ttoken, q1tmp, ival, rval, toktype)  ! "("        
c
c get the class type: "age" | "weight" | "length"
c
      call toknext(ttoken, q1tmp, ival, rval, toktype)
      if (q1tmp .eq. 'age') then
         ttype = tage
      elseif (q1tmp .eq. 'weight') then
         ttype = tweight
      elseif (q1tmp .eq. 'length') then
         ttype = tlength
      else
         sumerr = sumerr + 1
         write (stdout, 9160) cname
         call tokreset()
         go to 120
      endif
c
c all ranges must be of the same type for a given species
c
      if (range_type(jpredator) .eq. inoval) then
         range_type(jpredator) = ttype
      elseif (range_type(jpredator) .ne. ttype) then
         sumerr = sumerr + 1
         write (stdout, 9190) cname
         call tokreset()
         go to 120
      endif
c
      call toknext(ttoken, q1tmp, ival, rval, toktype)  ! "="        
      call idiet3(cname, xxok, range_type(jpredator), rv1, rv2)
      if ( .not. xxok) then
         sumerr = sumerr + 1
         call tokreset()
         go to 120
      endif
c
c test bounds
c
      if (range_numof(jpredator) .le. 0) then
         krange = 1
         range_numof(jpredator) = krange
         range_lowb(krange, jpredator) = rv1
         range_uppb(krange, jpredator) = rv2
c
      elseif (range_numof(jpredator) .ge. maxrange) then
         sumerr = sumerr + 1
         write (stdout, 9180) cname
         krange = maxrange
c
      else
         krange = range_numof(jpredator)
         rval = range_uppb(krange, jpredator)
         if (rval .le. rv1) then
            krange = krange + 1
            range_numof(jpredator) = krange
            range_lowb(krange, jpredator) = rval
            range_uppb(krange, jpredator) = rv2
         else
            sumerr = sumerr + 1
            write (stdout, 9170) cname
            call tokreset()
            go to 120
         endif
      endif
c
c now get the diet of the j-predator species;
c set duplication array;
c clear Fdiet array for this range, for this predator-species
c
      krange = range_numof(jpredator)
      do jprey = 1, maxbiota
         got_item(jprey) = .false.
         fdiet(jprey, krange, jpredator) = zero
      enddo
      total_fraction = zero
c
      call toknext(ttoken, q1tmp, ival, rval, toktype)  ! ":"        
  110 continue
      call toknext(ttoken, q1tmp, ival, rval, toktype)  ! prey item name
      if (q1tmp(1:1) .eq. ',') go to 110
      if (q1tmp(1:1) .eq. ')') then
         if (trne(total_fraction, one)) then
            sumerr = sumerr + 1
            write (stdout, 9140) cname
         endif
         go to 120
      endif
c
      xxok = (toktype .eq. tident)
      if ( .not. xxok) then
         sumerr = sumerr + 1
         write (stdout, 9120) cname
         call tokreset()
         go to 120
      endif
c
c find food web item; if the item is duplicated, continue syntactic
c analysis but the diet fraction will not be used.
c
      nlen = xslen(q1tmp)
      found = srchll0(q1tmp(1:nlen), dietlabels, gnspecies, jprey)
      if ( .not. found) then
         if (q1tmp(1:nlen) .eq. 'plankton') then
            found = .true.
            jprey = pplankton
            dplankton = .true.
         elseif (q1tmp(1:nlen) .eq. 'benthos') then
            found = .true.
            jprey = pbenthos
            dbenthos = .true.
         elseif (q1tmp(1:nlen) .eq. 'cfish') then
            found = .true.
            jprey = pcfish
            dcfish = .true.
         endif
      endif
c
      if (found) then
         if (got_item(jprey)) then
            sumerr = sumerr + 1
            write (stdout, 9150) cname
            tosum = .false.
         else
            got_item(jprey) = .true.
            tosum = .true.
         endif
      else
         sumerr = sumerr + 1
         write (stdout, 9120) cname
         call tokreset()
         go to 120
      endif
c
      call toknext(ttoken, q1tmp, ival, rval, toktype)  ! "="        
      call toknext(ttoken, q1tmp, ival, rval, toktype)  ! %diet (fraction)
      xxok = ((toktype .eq. treal) .or. (toktype .eq. tint))
      if (xxok) then
         xxok = ((zero .le. rval) .and. (rval .le. one))
      endif
c
      if ( .not. xxok) then
         sumerr = sumerr + 1
         write (stdout, 9130) cname
         call tokreset()
         go to 120
      endif
c
      if (tosum) then
         fdiet(jprey, range_numof(jpredator), jpredator) = rval
         total_fraction = total_fraction + rval
      endif
      go to 110 ! done with this prey item                      
c
  120 continue
      no_errors = (sumerr .eq. 0)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine idiet3(cname, no_errors, idtype, rv1, rv2)
c
c update: 11:45 fri 9-sep-1994.
c decode a range specification; valid forms are:
c a. #ival
c b. #ival_1 - #ival_2
c c. #rval_1 - #rval_2
c
c will return rv1 and rv2; if rv2 was not present, rv2 == rv1.
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'Prompt.par'
      include 'strings.par'
      include 'token.par'
      include 'heap.def'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      integer idtype
      logical no_errors
      real rv1, rv2
c
      character*(stdlen) q1tmp
      real rval, zk1, zk2
      integer ival, toktype
      logical xxok
c
 9110 format (' ?? "/',a,'" : requires an indicator.')
 9120 format (' ?? "/',a,'" : invalid range.')
c
      call prompt(prset1, cname)
c
      call toknext(ttoken, q1tmp, ival, rval, toktype)  ! rv1          
      xxok = (toktype .eq. tint) .or. (toktype .eq. treal)
      if ( .not. xxok) then
         write (stdout, 9110) cname
         go to 110
      endif
      zk1 = rval
c
c do we have a range ?  if we do, the next token is either
c the "-" operator or a negative integer;
c
      call toknext(ttoken, q1tmp, ival, rval, toktype)
      if (q1tmp(1:1) .eq. '-') then     ! range descriptor ?
         if (toktype .eq. toper) then
            call toknext(ttoken, q1tmp, ival, rval, toktype)
         endif
         xxok = (toktype .eq. tint) .or. (toktype .eq. treal)   ! #rv2 ? 
         if ( .not. xxok) then
            write (stdout, 9120) cname
            go to 110
         endif
         zk2 = abs(rval)
      else
         zk2 = zk1
         call tokpush()
      endif
c
      rv1 = zk1
      rv2 = zk2
      xxok = (rv1 .le. rv2)
c
  110 continue
      no_errors = (xxok)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine idquad(qmethod, qstring, qnn)
c
c update: wed 10:52 6-may-1992.
c identify quadrature method
c
      include 'chem.par'
      include 'fish.par'
      include 'ode.par'
c
      integer qmethod, qnn, xslen
      character*( * ) qstring
      external xslen
c
      if (qmethod .eq. teuler) then
         qstring = 'Euler'
      elseif (qmethod .eq. tadams) then
         qstring = 'Adams'
      elseif (qmethod .eq. tgear) then
         qstring = 'Gear'
      elseif (qmethod .eq. tbulirsch) then
         qstring = 'Bulirsch-Stoer'
      elseif (qmethod .eq. tadaptive) then
         qstring = 'Adaptive'
      else
         call int2a(qmethod, qstring, qnn)
      endif
      qnn = xslen(qstring)
c
      return
      end
      subroutine iecho(cname, no_errors)
c
c update: 17:26 fri 4-mar-1994.
c set/unset echo option
c syntax:
c . echo on
c . echo off
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'menu.par'
      include 'idfiles.def'
      include 'echo.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      character*(stdlen) q1tmp
      integer nq1, exitcode, xslen
      external xslen
c
 9110 format (1x,'?? invalid option: "',a,'"')
 9120 format (1x,'echo is ',a)
c
      call mmgetsv(stdout, cname, '~//onoff', exitcode, q1tmp, nq1)
      if (exitcode .eq. tquit) then
         continue
      elseif (q1tmp(1:2) .eq. 'on') then
         xecho = .true.
      elseif (q1tmp(1:2) .eq. 'of') then
         xecho = .false.
      else
         nq1 = xslen(q1tmp)
         write (stdout, 9110) q1tmp(1:nq1)
         call tokreset()
      endif
c
      if (xecho) then
         write (stdout, 9120) 'on'
      endif
c
      continue
      no_errors = (.true.)
      call tokreset()
c
      return
      end
      subroutine iexamode(cname, no_errors)
c
c update: 16:33 fri 4-mar-1994.
c provide exams mode
c /Exams_mode  < 1 | 2 | 3 >
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'Prompt.par'
      include 'strings.par'
      include 'token.par'
c
      include 'examsrec.def'
      include 'xinclude.inc'
      include 'heap.def'
      include 'idfiles.def'
      include 'options.def'
c
      logical no_errors
      character*( * ) cname
c
      integer sumerr, ival, toktype, ptok
      real rval
c
 9110 format (' ?? "/',a,'" : expecting exams mode: 1, 2, or 3')
 9120 format (' ?? "/',a,'" : exams mode not 1, 2, or 3')
c
      call prompt(prset1, cname)
      ptok = 0
      sumerr = 0
      call heapush(ptok)
c
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)
      if (toktype .eq. tint) then
         if ((1 .le. ival) .and. (ival .le. 3)) then
            exams_mode = ival
         else
            sumerr = sumerr + 1
            write (stdout, 9110) cname
            call tokreset()
         endif
      else
         sumerr = sumerr + 1
         write (stdout, 9120) cname
         call tokpush()
         call tokreset()
      endif
c
      call heapop(ptok)
      no_errors = (sumerr .eq. 0)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine iexams(cname, no_errors)
c
c update: 16:00 tue 5-apr-1994.
c exposure provided by exams --
c
c /exams       ! no arguments at this time
c
c - wed 09:03 22-jan-1992.
c . very little checking at this time.
c . check for existance of the *.xms files
c . open cmdfile and place it in the input stack
c . set flags in exposure variables for exams exposure file
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'habitat.par'
      include 'simul.par'
      include 'expos.par'
      include 'Prompt.par'
      include 'idfiles.def'
      include 'options.def'
      include 'habitat.def'
      include 'examsrec.def'
c
      logical no_errors
      character*( * ) cname
c
      character*( * ) expfile, cmdfile
      parameter (expfile = 'fgetsexp.xms')      ! exposure file
      parameter (cmdfile = 'fgetscmd.xms')      ! command file 
c
      logical havefile, xxok
      integer sumerr, xfopen, kstatus, jchem, uu
      external xfopen
c
 9110 format (' ?? "/',a,'" : ',a,' file "',a,'" does not exists')
 9120 format (' ?? "/',a,'" : cannot read file "',a,'"')
c
      call prompt(prset1, cname)
      sumerr = 0
      xexams = .true.
      xcfish = .false.
      xbenthos = .true.
      xplankton = .true.
c
c at the time "/exams" is read, it is very probable that "Gnchem" is not
c set (the can opener is inside the can) ... set "Cwfunc" for all chemicals;
c
      inquire (file=expfile, exist=havefile)
      if (havefile) then
         twfunc = tfile
         do jchem = 1, maxchem
            cwfunc(jchem) = tfile
         enddo
         iread_cw = tfexams
         cwfil = expfile
c
         plankton_standing_stock_func = tfile
         plankton_chem_func = tfile
         iread_plankton = tfexams
         planktonfil = expfile
c
         benthos_chem_func = tfile
         iread_benthos = tfexams
         benthosfil = expfile
c
         cfish_chem_func = tfile
         iread_cfish = tfexams
         cfishfil = expfile
c
      else
         sumerr = sumerr + 1
         write (stdout, 9110) cname, 'exposure', expfile
      endif
c
      inquire (file=cmdfile, exist=havefile)
      if (havefile) then
         kstatus = xfopen(uu, cmdfile, zioread)
         if (kstatus .eq. zioerror) then
            sumerr = sumerr + 1
            write (stdout, 9120) cname, cmdfile
         else
            call freadpush(uu, xxok)
            if ( .not. xxok) then
               sumerr = sumerr + 1
            endif
         endif
      else
         sumerr = sumerr + 1
         write (stdout, 9110) cname, 'command', cmdfile
      endif
c
      call prompt(prpop, ' ')
      no_errors = (sumerr .eq. 0)
      return
      end
      subroutine iexit(cname, no_errors)
c
c update: fri 16:46 13-mar-1992.
c @@@@
c
c declaration of fortran parameters
c;;
      include 'Prompt.par'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      call prompt(prset1, cname)
      no_errors = (.true.)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine ifargs(cname, fx, fp, no_errors)
c
c update: 16:33 fri 4-mar-1994.
c
c - mnemonic: input-function-arguments
c - this module decodes and parameterizes certain analytical functions
c
c - functions:
c   constant    #1          ! fx = fp(1)
c   linear      #1 #2       ! fx = fp(1) + fp(2) * x
c   allometric  #1 #2       ! fx = fp(1) * x ** fp(2)
c   Exp         #1 #2 #3    ! fx = fp(1) + fp(2) * Exp(fp(3)*x)
c   Sin         #1 #2 #3 #4 ! fx = fp(1) + fp(2) * Sin(fp(3)*x + fp(4))
c   allometric  fishpar     !
c   allometric  database    !
c
c - module arguments:
c   fx: function name (integer)
c   fp: function parameters (Real array)
c;;
      include 'xglobal.par'
      include 'noval.par'
      include 'Prompt.par'
      include 'simul.par'
      include 'strings.par'
      include 'token.par'
c
      include 'heap.def'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      real fp( * )
      integer fx
      logical no_errors
c
c local parameters
c
      real rval
      integer ival, toktype, xslen, jpar, nss, npar, ptok, pfs
      logical xxok, done
      external xslen
c
 9110 format (' ?? "/',a,'" : "allometric" options expects ',
     &   'two numbers or "fishpar" or "database".')
 9120 format (' ?? "/',a,'" : unknown function.')
 9130 format (' ?? "/',a,'" : "',a,'" option expects ',i3,' number(s).')
c
      call prompt(prset1, cname)
      ptok = 0  ! assign heap storage            
      pfs = 0
      call heapush(ptok)
      call heapush(pfs)
c
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)
      nss = xslen(qhs(ptok))
      xxok = .true.
      npar = 0
      fx = inoval
      qhs(pfs) = qhs(ptok)
c
      if (qhs(ptok) .eq. 'constant') then
         npar = 1
         fx = tconstant
      elseif (qhs(ptok) .eq. 'linear') then
         npar = 2
         fx = tlinear
      elseif (qhs(ptok) .eq. 'allometric') then
         fx = tallometric
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)
         if (qhs(ptok) .eq. 'fishpar') then
            fx = tfishpar
         elseif (qhs(ptok) .eq. 'database') then
            fx = tdatabase
         elseif ((toktype .eq. treal) .or. (toktype .eq. tint)) then
            npar = 2
            call tokpush()
         else
            xxok = .false.
            write (stdout, 9110) cname
            call tokreset()
            go to 120
         endif
      elseif (qhs(ptok) .eq. 'Exp') then
         npar = 3
         fx = texp
      elseif (qhs(ptok) .eq. 'Sin') then
         npar = 4
         fx = tsin
      else
         fx = inoval
         xxok = .false.
         write (stdout, 9120) cname
      endif
c
      if (npar .gt. 0) then
         xxok = .true.
         jpar = 1
  110    continue
         done = (jpar .gt. npar) .or. ( .not. xxok)
         if ( .not. done) then
            call toknext(ttoken, qhs(ptok), ival, rval, toktype)
            xxok = ((toktype .eq. treal) .or. (toktype .eq. tint))
            if (xxok) then
               fp(jpar) = rval
               jpar = jpar + 1
            endif
            go to 110
         endif
         if ( .not. xxok) then
            call tokpush()
            nss = xslen(qhs(pfs))
            write (stdout, 9130) cname, qhs(pfs)(1:nss), npar
            call tokreset()
         endif
      endif
c
  120 continue
      call prompt(prpop, ' ')
      call heapop(pfs)  ! release heap storage                 
      call heapop(ptok)
      no_errors = (xxok)
c
      return
      end
      subroutine ifishp0(cname, coption, fnarg, parpos, no_errors)
c
c update: 16:33 fri 4-mar-1994.
c
c fnarg  : number of arguments expected
c parpos : position of the first entry of this function in *Vv_pval*
c
c npk : position of the parameter to be stored; it is assumed that
c       the parameters are input in the same relative positions as
c       they appear in *Vv_pval*, e.g.,
c           evac (evac1, evac2, evac3, q10, tref)
c       therefore,
c           parameter (vevac1  =Z+1, vevac2=Z+2, vevac3=Z+3)
c           parameter (vevacq10=Z+4, vevact=Z+5)
c
c       Z arbitrary non-negative integer.
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'noval.par'
      include 'Prompt.par'
      include 'strings.par'
      include 'token.par'
c
      include 'fish.def'
      include 'globpar.def'
      include 'heap.def'
      include 'idfiles.def'
c
      character*( * ) cname, coption
      integer fnarg, parpos
      logical no_errors
c
      real rval
      integer xslen, ival, toktype, ptok
      integer number_args_found, npk, jage, sumerr
      external xslen
c
      include 'vdefined.def'
      include 'vdefined.sfn'
c
 9110 format (' ?? "/',a,'" : option: "',a,'" : no arguments.')
 9120 format (' ?? "/',a,'" : option: "',a,'" expects a number.')
 9130 format (' ?? "/',a,'" : option: "',a,'" found ',i3,
     &   ' arg(s), expecting ',i3,'.')
c
      call prompt(prset1, cname)
      ptok = 0
      call heapush(ptok)
c
      sumerr = 0
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)      ! "("   
      if (qhs(ptok)(1:1) .ne. '(') then
         sumerr = sumerr + 1
         write (stdout, 9110) cname, coption
         call tokreset()
         go to 120
      endif
c
c for each parameter read, loop and store by year class.
c
      npk = parpos - 1
      number_args_found = 0
  110 continue
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)      ! number?
      if (qhs(ptok)(1:1) .eq. ',') then
         go to 110
      elseif (qhs(ptok)(1:1) .eq. ')') then
         go to 120
      endif
      number_args_found = number_args_found + 1
c
      if ((toktype .eq. treal) .or. (toktype .eq. tint)) then
         continue
      elseif (qhs(ptok) .eq. 'database') then
         rval = rnoval
      else
         rval = rnoval
         sumerr = sumerr + 1
         write (stdout, 9120) cname, coption
         call tokreset()
         go to 110
      endif
c
      npk = npk + 1
      do jage = 1, xmaximum_age(gnspecies)
         if ( .not. vdefined(vv_pval(npk, jage, gnspecies))) then
            vv_pval(npk, jage, gnspecies) = rval
         endif
      enddo
      go to 110
c
  120 continue
      if (number_args_found .ne. fnarg) then
         sumerr = sumerr + 1
         write (stdout, 9130) cname, coption, number_args_found, fnarg
      endif
c
      no_errors = (sumerr .eq. 0)
      call heapop(ptok)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine ifishpar(cname, no_errors)
c
c update: 11:33 wed 17-aug-1994.
c
c decode fish parameter functions
c
c /fishpar argument(s)
c argument of the form
c    function_name (arg_1, arg_2, ..., arg_n)
c    valid function names and number of arguments stored in
c        . Fpname (fish_parameter name)
c        . Fparg  (fish_parameter arguments)
c
c output
c     fish parameters placed in Vv_pval for the appropriate year-class
c;;
      include 'xglobal.par'
      include 'Prompt.par'
      include 'idfiles.def'
      include 'fisiorec.def'
      include 'chars.def'
c
      logical no_errors
      character*( * ) cname
c
      character*(stdlen) q1tmp
      integer npos, nq1, xslen, sumerr
      logical found, srchlb0, xxok, havefish
      external havefish, srchlb0, xslen
c
      include 'chars.sfn'
c
 9110 format (' ?? "/',a,'" : unknown parameter.')
 9120 format (' ?? "/',a,'" : requires "/species" first.')
c
      call prompt(prset1, cname)
      sumerr = 0
c
      if ( .not. havefish()) then
         sumerr = sumerr + 1
         write (stdout, 9120) cname
         call tokreset()
         go to 120
      endif
c
  110 continue
      call tok2dlim(' (', q1tmp)
      if ( .not. iseol(q1tmp(1:1))) then
         nq1 = xslen(q1tmp)
c
         found = srchlb0(q1tmp, fpname, max_fish_fun, npos)
         if (found) then
            call ifishp0(cname, q1tmp(1:nq1), fparg(npos), fppos(npos),
     &         xxok)
            if ( .not. xxok) sumerr = sumerr + 1
         else
            sumerr = sumerr + 1
            write (stdout, 9110) cname
            call tokreset()
         endif
         go to 110
      endif
c
  120 continue
      call tokreset()
      call prompt(prpop, ' ')
      no_errors = (sumerr .eq. 0)
c
      return
      end
      subroutine igrowth(cname, no_errors)
c
c update: 11:33 wed 17-aug-1994.
c
c "id" == year class identifier (an integer)
c species parameters: /growth
c   / growth #id1[-#id2] allometric #functional_response
c   / growth #id1[-#id2] holling    #functional_response
c   / growth #id1[-#id2] linear     {database | fishpar}
c   / growth #id1[-#id2] clearance  {database | fishpar}   #functional_response
c
c - #functional_response is the ratio of realized ingestion to maximal
c   ingestion (i.e., #functional_response = c / cmax).
c - if string = linear, the fish's specific growth rate is specified by
c   growth_rate = (dw/dt)/w in units of g/g/d
c               = Exp (ln(q10)/10 * (t-tref)) * gamma1 * wt ** gamma2;
c - if string = clearance, the fish's growth rate is limited by his plankton
c   filtering rate
c - #id1[-#id2] : year class identifier; may be an integer or a range;
c   examples:
c     / growth 1-2 clearance  database
c        ! grow year classes 1 and 2 using the clearance growth model;
c     / growth 3 linear fishpar
c        ! grow year class 3 using the linear growth model;
c
c "ration" is a special case of "allometric" ;
c example: fish feeding at 3% body wt.
c
c     / growth    1 allometric 1.0     ! consume all (1.0 == 100%)
c     / fishpar   max_ingestion(0.03, 1.0, 1.0, 10.0)
c                               0.03*wt^1  q10  tref
c     q10 == 1 ==> no q10 effect
c     tref: arbitrary
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'physio.par'
      include 'Prompt.par'
      include 'simul.par'
      include 'strings.par'
      include 'token.par'
c
      include 'fish.def'
      include 'globpar.def'
      include 'heap.def'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      real rval, fxresponse
      integer ival, toktype, ptok, kbeg, kend, jage, tval
      logical xxok, havefish
      external havefish
c
 9110 format (' ?? "/',a,'" : "allometric" option expects one number.')
 9120 format (' ?? "/',a,'" : "holling" option expects one number.')
 9130 format (' ?? "/',a,
     &   '" : "linear" option expects "database" or "fishpar".')
 9140 format (' ?? "/',a,'" : expects "allometric", "holling", ',
     &   '"linear", or "clearance"')
 9150 format (' ?? "/',a,
     &   '" : "clearance" : expecting "database" or "fishpar".')
 9160 format (' ?? "/',a,'" : "clearance" : expecting one number.')
 9170 format (' ?? "/',a,'" : requires "/species" first.')
c
      call prompt(prset1, cname)
      ptok = 0
      call heapush(ptok)
c
      if ( .not. havefish()) then
         xxok = .false.
         write (stdout, 9170) cname
         call tokreset()
         go to 110
      endif
c
c get the yearclass identifier(s)
c
      call irange(cname, xxok, xmaximum_age(gnspecies), kbeg, kend)
      if (xxok) then
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)
      else
         call tokreset()
         go to 110
      endif
c
      if (qhs(ptok) .eq. 'allometric') then
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)
         xxok = ((toktype .eq. treal) .or. (toktype .eq. tint))
         if (xxok) then
            do jage = kbeg, kend
               vv_growth_model(jage, gnspecies) = tallometric
               vv_functional_response(jage, gnspecies) = rval
            enddo
         else
            write (stdout, 9110) cname
            call tokreset()
            go to 110
         endif
c
      elseif (qhs(ptok) .eq. 'holling') then
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)
         xxok = ((toktype .eq. treal) .or. (toktype .eq. tint))
         if (xxok) then
            do jage = kbeg, kend
               vv_growth_model(jage, gnspecies) = tholling
               vv_functional_response(jage, gnspecies) = rval
            enddo
         else
            write (stdout, 9120) cname
            call tokreset()
            go to 110
         endif
c
      elseif (qhs(ptok) .eq. 'linear') then
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)
         if (qhs(ptok) .eq. 'database') then
            xxok = .true.
            do jage = kbeg, kend
               vv_growth_model(jage, gnspecies) = tlinear
               vv_ptyp(vgamma1, jage, gnspecies) = tdatabase
               vv_ptyp(vgamma2, jage, gnspecies) = tdatabase
               vv_ptyp(vgammaq10, jage, gnspecies) = tdatabase
               vv_ptyp(vgammat, jage, gnspecies) = tdatabase
            enddo
         elseif (qhs(ptok) .eq. 'fishpar') then
            xxok = .true.
            do jage = kbeg, kend
               vv_growth_model(jage, gnspecies) = tlinear
            enddo
         else
            xxok = .false.
            write (stdout, 9130) cname
            call tokreset()
            go to 110
         endif
c
      elseif (qhs(ptok) .eq. 'clearance') then
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)
         if (qhs(ptok) .eq. 'database') then
            tval = tdatabase
         elseif (qhs(ptok) .eq. 'fishpar') then
            tval = tfishpar
         else
            xxok = .false.
            write (stdout, 9150) cname
            call tokreset()
            go to 110
         endif
c
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)
         xxok = ((toktype .eq. treal) .or. (toktype .eq. tint))
         if (xxok) then
            fxresponse = rval
         else
            write (stdout, 9160) cname
            call tokreset()
            go to 110
         endif
c
         if (tval .eq. tdatabase) then
            do jage = kbeg, kend
               vv_growth_model(jage, gnspecies) = tclearance
               vv_functional_response(jage, gnspecies) = fxresponse
               vv_ptyp(vcvol1, jage, gnspecies) = tdatabase
               vv_ptyp(vcvol2, jage, gnspecies) = tdatabase
               vv_ptyp(vcvolq10, jage, gnspecies) = tdatabase
               vv_ptyp(vcvolt, jage, gnspecies) = tdatabase
            enddo
         elseif (tval .eq. tfishpar) then
            do jage = kbeg, kend
               vv_growth_model(jage, gnspecies) = tclearance
               vv_functional_response(jage, gnspecies) = fxresponse
            enddo
         endif
c
      else
         xxok = .false.
         write (stdout, 9140) cname
         call tokreset()
         go to 110
      endif
c
  110 continue
      call prompt(prpop, ' ')
      call heapop(ptok)
      no_errors = (xxok)
c
      return
      end
      subroutine ihelp(cname, no_errors)
c
c update: 16:33 fri 4-mar-1994.
c display help info
c
c help <topic>                   ! displays topics in help file --
c                                      commands, general info, some options;
c help $units <Unitname>         ! names of units
c help $prefixes <prefixname>    ! names of prefixes
c help $commands <commandname>   ! names of commands
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'Prompt.par'
      include 'strings.par'
      include 'chars.def'
      include 'hits.def'
      include 'idfiles.def'
      include 'idsdb.def'
      include 'unitdb.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      integer nopts
      parameter (nopts = 3)
c
      character*(stdlen) q1tmp
      character*(s20) hopts(nopts)
      integer nq1, xslen, jj
      logical hhfound, srchew0, srchllx
      external srchew0, xslen, srchllx
c
      include 'chars.sfn'
c
      data hopts /'$commands', '$prefixes', '$units'/
c
 9110 format (1x,'help available on:')
 9120 format (1x,'?? internal error in array "hopts"',/,1x,
     &   '   no "if" for jj = ',i3,'; entry = "',a,'"')
c
      no_errors = (.false.)
      call prompt(prset1, cname)
c
      call tok2dlim(' ', q1tmp)
      if ( .not. iseol(q1tmp(1:1))) then
         nq1 = xslen(q1tmp)
      else
         q1tmp = '*'
         nq1 = 1
      endif
c
      if (q1tmp(1:1) .eq. '$') then
         hhfound = srchllx(q1tmp(1:nq1), hopts, nopts, xhits, nhits)
         if (nhits .eq. 1) then
            call tok2dlim(' ', q1tmp)
            if (iseol(q1tmp(1:1))) then
               nq1 = 1
               q1tmp = '*'
            else
               nq1 = xslen(q1tmp) + 1
               q1tmp(nq1:nq1) = '*'
            endif
            jj = xhits(nhits)
            if (jj .eq. 1) then
               call srchlw0(q1tmp(1:nq1), comname, maxcom, xhits, nhits)
               call ihelp0(stdout, comname, maxcom, xhits, nhits)
            elseif (jj .eq. 2) then
               call srchlw0(q1tmp(1:nq1), uprenam, nprefix, xhits, nhits
     &            )
               call ihelp0(stdout, uprenam, nprefix, xhits, nhits)
            elseif (jj .eq. 3) then
               call srchlw0(q1tmp(1:nq1), uunam, nnames, xhits, nhits)
               call ihelp0(stdout, uunam, nnames, xhits, nhits)
            else
               if ((1 .le. jj) .and. (jj .le. nopts)) then
                  q1tmp = hopts(jj)
               else
                  q1tmp = '<no entry>'
               endif
               nq1 = max(1, xslen(q1tmp))
               write (stdout, 9120) jj, q1tmp(1:nq1)
            endif
         else
            nhits = nopts
            do jj = 1, nhits
               xhits(jj) = jj
            enddo
            write (stdout, 9110)
            call ihelp0(stdout, hopts, nopts, xhits, nhits)
         endif
c
      else
         call gethelp(q1tmp(1:nq1), hhfound)
         if ( .not. hhfound) then
            if (nhelp .gt. 0) then
               nq1 = nq1 + 1
               q1tmp(nq1:nq1) = '*'
               call srchlw0(q1tmp(1:nq1), xhelp, nhelp, xhits, nhits)
               if (nhits .eq. 0) then
                  nhits = nhelp
                  do jj = 1, nhits
                     xhits(jj) = jj
                  enddo
                  write (stdout, 9110)
                  call ihelp0(stdout, xhelp, nhelp, xhits, nhits)
               elseif (nhits .gt. 1) then
                  write (stdout, 9110)
                  call ihelp0(stdout, xhelp, nhelp, xhits, nhits)
               endif
            endif
         endif
      endif
c
      call prompt(prpop, ' ')
      call tokreset()
      return
      end
      subroutine ihelp0(uu, xlist, nlist, xhits, nhits)
c
c update: 17:27 fri 4-mar-1994.
c display help commands in columns
c;;
      include 'xglobal.par'
      include 'stealth.def'
c
      integer nlist, xhits( * ), nhits, uu
      character*( * ) xlist( * )
c
      character*(stdlen) wbuf
      integer colwidth, leftmost_column, rightmost_column, xslen
      integer ii, jj, nbuf, jlen, kn, kz
      logical lshow
      external xslen
      data colwidth /10/        ! column width                
c
 9110 format (1x,a)
 9120 format (1x,'?? no matches.')
c
      if (nhits .le. 0) then
         write (uu, 9120)
         go to 110
      endif
c
      leftmost_column = 3       ! aesthetics                  
      rightmost_column = stdlen - 1     ! because of "1x" in format   
      wbuf = ' '        ! clear buffer                
      nbuf = leftmost_column    ! column for next entry       
      kz = 0    ! last nonblank column in "wbuf"
c
      do ii = 1, nhits
         jj = xhits(ii)
         jlen = xslen(xlist(jj))
         if (xlist(jj)(1:2) .eq. stealthc // stealthc) then
            lshow = .false.
         elseif (xstealth) then
            lshow = (xlist(jj)(1:1) .ne. stealthc)
         else
            lshow = .true.
         endif
         lshow = ((lshow) .and. (jlen .gt. 0))
         if (lshow) then
            if ((nbuf + jlen - 1) .gt. rightmost_column) then
               if (kz .gt. 0) then
                  write (uu, 9110) wbuf(1:kz)
                  wbuf(leftmost_column:kz) = ' '
                  nbuf = leftmost_column
                  kz = 0
               endif
            endif
            kz = nbuf + jlen - 1
            wbuf(nbuf:kz) = xlist(jj)(1:jlen)
c
c subtracting and adding "leftmost_column" ensures that regardless of the
c starting column, all columns are "colwidth" characters wide.
c - kn:    next multiple of "colwidth"; includes a trailing Blank
c - nbuf:  column for next entry
c
            kn = (kz + 1 + colwidth - leftmost_column) / colwidth
            nbuf = colwidth * kn + leftmost_column
         endif
      enddo
c
      if (kz .gt. 0) then
         write (uu, 9110) wbuf(1:kz)
         wbuf(leftmost_column:kz) = ' '
         nbuf = leftmost_column
         kz = 0
      endif
c
  110 continue
      return
      end
      subroutine ilab(cname, no_errors)
c
c update: 15:43 fri 9-sep-1994.
c get laboratory-function system parameters
c
c laboratory (flow = ## units, volume = ## units, nfish = ##,
c             cfood = <food-description>)
c
c <food-description> ==
c     constant      #conc_chem_1 #conc_chem_2 ... #conc_chem_nchem
c     equilibrium   #pl_food  #bmf_1 #bmf_2 ... #bmf_nchem
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'habitat.par'
      include 'noval.par'
      include 'Prompt.par'
      include 'strings.par'
      include 'token.par'
c
      include 'habitat.def'
      include 'heap.def'
      include 'idfiles.def'
      include 'lab.def'
      include 'units.def'
c
      logical no_errors
      character*( * ) cname
c
      character*(stdlen) wmsg
      integer ival, nss, xslen, sumerr, npp, toktype, ptok
      integer jchem, nmsg
      real rval
      logical xxok, treq
      external xslen, treq
c
 9110 format (' ?? "',a,'" : no arguments.')
 9120 format (' ?? "',a,'" : "flow" option: ',/,
     &   '    units should be dimensionally equal to: ',a)
 9130 format (' ?? "',a,'" : "volume" option: ',/,
     &   '    units should be dimensionally equal to: ',a)
 9140 format (' ?? "',a,'" : "nfish" option expects a number.')
 9150 format (' ?? "',a,
     &   '" : expects "flow", "volume", "nfish", or "cfood".')
 9160 format (' ?? "',a,'" option "',a,'" not set')
c
c initialize laboratory variables
c
      call prompt(prset1, cname)
      tank_flow = rnoval
      tank_nfish = inoval
      tank_volume = rnoval
      food_chem_func = inoval
      food_pl = rnoval
      do jchem = 1, maxchem
         food_chem_conc(jchem) = rnoval
      enddo
c
      ptok = 0  ! assign heap storage            
      call heapush(ptok)
c
      xxok = .true.
      sumerr = 0
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)      ! "("   
      if (qhs(ptok)(1:1) .ne. '(') then
         sumerr = sumerr + 1
         write (stdout, 9110) cname
         call tokreset()
         go to 120
      endif
c
  110 continue
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)
      if (qhs(ptok)(1:1) .eq. ',') then
         go to 110
      elseif (qhs(ptok)(1:1) .eq. ')') then
         go to 120
      endif
      nss = xslen(qhs(ptok))
c
      if (qhs(ptok)(1:nss) .eq. 'flow') then
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)   ! "="
         call tok2dlim(',)', qhs(ptok))
         nss = xslen(qhs(ptok))
         call unitdrv(qhs(ptok), pgm_flow, tank_flow, xxok, wmsg, nmsg)
         if ( .not. xxok) then
            sumerr = sumerr + 1
            npp = xslen(pgm_flow)
            write (stdout, 9120) cname, pgm_flow(1:npp)
         endif
c
      elseif (qhs(ptok)(1:nss) .eq. 'volume') then
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)   ! "="
         call tok2dlim(',)', qhs(ptok))
         nss = xslen(qhs(ptok))
         call unitdrv(qhs(ptok), pgm_volume, tank_volume, xxok, wmsg, 
     &      nmsg)
         if ( .not. xxok) then
            sumerr = sumerr + 1
            npp = xslen(pgm_volume)
            write (stdout, 9130) cname, pgm_volume(1:npp)
         endif
c
      elseif (qhs(ptok)(1:nss) .eq. 'nfish') then
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)   ! "="
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)   ! number
         xxok = ((toktype .eq. treal) .or. (toktype .eq. tint))
         if (xxok) then
            tank_nfish = rval
         else
            sumerr = sumerr + 1
            write (stdout, 9140) cname
         endif
c
      elseif (qhs(ptok)(1:nss) .eq. 'cfood') then
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)   ! "="
         call icfood(qhs(ptok)(1:nss), xxok)
         if ( .not. xxok) sumerr = sumerr + 1
c
      else
         sumerr = sumerr + 1
         write (stdout, 9150) cname
         call tokreset()
      endif
      go to 110
c
  120 continue
      if (sumerr .eq. 0) then   ! make sure everything was set
         if (treq(tank_flow, rnoval)) then
            sumerr = sumerr + 1
            write (stdout, 9160) cname, 'flow'
         endif
         if (treq(tank_volume, rnoval)) then
            sumerr = sumerr + 1
            write (stdout, 9160) cname, 'volume'
         endif
         if (treq(tank_nfish, rnoval)) then
            sumerr = sumerr + 1
            write (stdout, 9160) cname, 'nfish'
         endif
         if (food_chem_func .eq. inoval) then
            sumerr = sumerr + 1
            write (stdout, 9160) cname, 'cfood'
         endif
      endif
c
      no_errors = (sumerr .eq. 0)
      call heapop(ptok) ! release heap storage                 
      call prompt(prpop, ' ')
c
      return
      end
      subroutine ilc50(cname, no_errors)
c
c update: 11:34 wed 17-aug-1994.
c reads lc50 for a particular fish
c
c /lc50 #id1 #string #arguments
c
c        #string           #arguments
c        ---------------   ------------------
c        Log/log_fathead   #p0 #p1
c                          . La50 = 10.0^p0 * la_fathead^p1
c
c        observed          #lc50 [#units]
c                          . #lc50 == lc50 for the #chem_number chemical
c                          . if #units is not input, "Cwunits" will be assumed;
c                            a message will be issued stating the fact;
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'noval.par'
      include 'Prompt.par'
      include 'simul.par'
      include 'strings.par'
      include 'token.par'
c
      include 'fish.def'
      include 'globpar.def'
      include 'heap.def'
      include 'idfiles.def'
      include 'units.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      character*(stdlen) wmsg
      real rval
      integer ival, toktype, jchem, xslen, jpar, ii, ptok
      integer nmsg
      logical xxok, done, havefish
      external havefish, xslen
c
 9110 format (' ?? "/',a,
     &   '" : "Log/log_fathead" option expects two numbers.')
 9120 format (' ?? "/',a,
     &   '" : "observed" option: no units found; assuming "',a,'"')
 9130 format (' ?? "/',a,'" : units should be dimensionally equal to: ',
     &   a)
 9140 format (' ?? "/',a,'" : expects a Real number.')
 9150 format (' ?? "/',a,
     &   '" : options are "Log/log_fathead" or "observed".')
 9160 format (' ?? "/',a,'" : requires "/species" first.')
c
      call prompt(prset1, cname)
      ptok = 0
      call heapush(ptok)
c
      if ( .not. havefish()) then
         xxok = .false.
         write (stdout, 9160) cname
         call tokreset()
         go to 120
      endif
c
c get the chemical identifier(s)
c
      call irange(cname, xxok, gnchem, jchem, ival)
      if ( .not. xxok) then
         call tokreset()
         go to 120
      endif
c
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)
      if (qhs(ptok) .eq. 'Log/log_fathead') then
         lc50func(jpar, gnspecies) = tlog_fathead
         jpar = 1
  110    continue
         done = (jpar .gt. 2) .or. ( .not. xxok)
         if ( .not. done) then
            call toknext(ttoken, qhs(ptok), ival, rval, toktype)
            xxok = ((toktype .eq. treal) .or. (toktype .eq. tint))
            if (xxok) then
               lc50par(jpar, jchem, gnspecies) = rval
               jpar = jpar + 1
            endif
            go to 110
         endif
         if ( .not. xxok) then
            lc50func(jchem, gnspecies) = inoval
            call tokpush()
            write (stdout, 9110) cname
            call tokreset()
         endif
c
      elseif (qhs(ptok) .eq. 'observed') then
         lc50func(jchem, gnspecies) = tobserved
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)
         xxok = ((toktype .eq. treal) .or. (toktype .eq. tint))
         if (xxok) then
            lc50par(1, jchem, gnspecies) = rval
            call tok2dlim(eol, qhs(ptok))
            if (qhs(ptok)(1:1) .eq. ' ') then
               ii = xslen(cwunits)
               qhs(ptok) = cwunits(1:ii)
               write (stdout, 9120) cname, cwunits(1:ii)
            endif
            call unitdrv(qhs(ptok), pgm_conc, rval, xxok, wmsg, nmsg)
            lc50par(1, jchem, gnspecies) = rval * 
     &         lc50par(1, jchem, gnspecies)
            if ( .not. xxok) then
               ii = xslen(pgm_conc)
               write (stdout, 9130) cname, pgm_conc(1:ii)
               lc50func(jchem, gnspecies) = inoval
            endif
         else
            write (stdout, 9140) cname
            call tokreset()
            lc50func(jchem, gnspecies) = inoval
         endif
c
      else
         xxok = .false.
         write (stdout, 9150) cname
         call tokreset()
      endif
c
  120 continue
      call prompt(prpop, ' ')
      call heapop(ptok)
      no_errors = (xxok)
c
      return
      end
      subroutine ilenwt(cname, no_errors)
c
c update: 11:34 wed 17-aug-1994.
c /lenwt  allometric fishpar
c /lenwt  allometric database
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'physio.par'
      include 'Prompt.par'
      include 'simul.par'
      include 'strings.par'
      include 'token.par'
c
      include 'fish.def'
      include 'globpar.def'
      include 'heap.def'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      real rval
      integer ival, toktype, ptok, jage
      logical xxok, havefish
      external havefish
c
 9110 format (' ?? "/',a,'" : valid options are "fishpar" or "database"'
     &   )
 9120 format (' ?? "/',a,'" : requires "/species" first.')
c
      call prompt(prset1, cname)
      ptok = 0
      call heapush(ptok)
c
      if ( .not. havefish()) then
         xxok = .false.
         write (stdout, 9120) cname
         call tokreset()
         go to 110
      endif
c
      xxok = .true.
      jage = 1
c
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)
      if (qhs(ptok) .eq. 'allometric') then
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)
         if (qhs(ptok) .eq. 'fishpar') then
            continue
         elseif (qhs(ptok) .eq. 'database') then
            vv_ptyp(vlenwt1, jage, gnspecies) = tdatabase
            vv_ptyp(vlenwt2, jage, gnspecies) = tdatabase
         else
            xxok = .false.
         endif
      else
         xxok = .false.
      endif
c
      if ( .not. xxok) then
         write (stdout, 9110) cname
         call tokreset()
      endif
c
  110 continue
      call prompt(prpop, ' ')
      call heapop(ptok)
      no_errors = (xxok)
c
      return
      end
      subroutine ilist(cname, no_errors)
c
c update: fri 16:48 13-mar-1992.
c @@@@
c
c declaration of fortran parameters
c;;
      include 'Prompt.par'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      call prompt(prset1, cname)
      no_errors = (.false.)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine imaxage(cname, no_errors)
c
c update: 11:34 wed 17-aug-1994.
c /maximum_age integer
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'Prompt.par'
      include 'strings.par'
      include 'token.par'
c
      include 'fish.def'
      include 'globpar.def'
      include 'heap.def'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      real rval
      integer xslen, ival, toktype, ptok
      logical havefish
      external havefish, xslen
c
 9110 format (' ?? "/',a,'" : year classes .le. 0; set to 1')
 9120 format (' ?? "/',a,
     &   '" : not enough space to store all year classes.')
 9130 format (' ?? "/',a,'" : expecting one integer.')
 9140 format (' ?? "/',a,'" : requires "/species" first.')
c
      call prompt(prset1, cname)
      ptok = 0
      call heapush(ptok)
c
      if ( .not. havefish()) then
         no_errors = .false.
         write (stdout, 9140) cname
         call tokreset()
         go to 110
      endif
c
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)
      no_errors = (toktype .eq. tint)
      if (no_errors) then
         xmaximum_age(gnspecies) = ival
         if (xmaximum_age(gnspecies) .le. 0) then
            no_errors = .false.
            xmaximum_age(gnspecies) = 1
            write (stdout, 9110) cname
         elseif (xmaximum_age(gnspecies) .gt. maxage) then
            no_errors = .false.
            xmaximum_age(gnspecies) = 1
            write (stdout, 9120) cname
         endif
c
      else
         write (stdout, 9130) cname
         call tokreset()
      endif
c
  110 continue
      call heapop(ptok)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine initchem(utbeg, utend, hstep)
c
c update: 17:27 fri 4-mar-1994.
c initialize environmental arrays
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'phylum.par'
      include 'numbers.par'
      include 'habitat.par'
      include 'plots.par'
      include 'work.def'
      include 'fluxes.def'
      include 'globpar.def'
      include 'habitat.def'
c
      real utbeg, utend, hstep
      integer jchem, npts
c
      dtcw = zero
      twmean = zero
      cc_nxy = 0
c
      npts = 1 + nint((utend - utbeg) / hstep)
      cc_iprint = (npts + maxpoints - 1) / maxpoints
      cc_iterno = 0
c
      do jchem = 1, gnchem
         cwmean(jchem) = zero
      enddo
c
      return
      end
      subroutine inithelp()
c
c update: 11:22 fri 9-sep-1994.
c initialize help arrays
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'helpid.par'
c
      include 'hits.def'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*(stdlen) q1tmp
      integer nq1, xslen, jj, xfopen, nn, joffset, ios
      logical xfirst, xhavefile
      external xslen, xfopen, xfclose
c
      data xfirst /.true./
 9110 format (1x,'?? Fgets help file could not be opened.')
 9120 format (1x,
     &   '?? Fgets help file internal error -- incorrect help id:',/,1x,
     &   '   file header id = "',a,'"',/,1x,'   Fgets  help id = "',a,
     &   '"')
 9130 format (1x,'?? Fgets help file internal error: ',
     &   'increase "maxhelp" to ',i3)
c
      if ( .not. xfirst) then
         go to 110
      endif
c
c only the vms version has the help library;
c without further ado, return to the calling module;
c
      xfirst = .false.
      nhelp = 0
      go to 110
c
c first record is an id record; read and test if this is the current version.
c
      read (jhlb, rec=1, iostat=ios) nq1, q1tmp(1:nq1)
c
      if (q1tmp(1:nq1) .ne. helpid) then
         write (stdout, 9120) q1tmp(1:nq1), helpid
      endif
c
      read (jhlb, rec=2, iostat=ios) nhelp, joffset
      if (nhelp .gt. maxhelp) then
         write (stdout, 9130) nhelp
         nhelp = maxhelp        ! read as much as we can.  
      endif
      do jj = 1, nhelp
         joffset = joffset + 1
         read (jhlb, rec=joffset, iostat=ios) nn, xhelp(jj)(1:nn), 
     &      xoffset(jj)
         xhelp(jj)(nn + 1:) = ' '
      enddo
c
  110 continue
      return
      end
      subroutine initpez(simul_mode, nchem, tw, sigma, nh3n, cn, 
     &   conc_plankton_in_water, vv_inicf, utbeg, utend, 
     &   vv_growth_model, kl, koc, kow, acw, molwt, lc50func, lc50par, 
     &   vv_plfunc, vv_iniwt, vv_pval, xwt, bfj, qq_jgilup, qq_jgilex, 
     &   qq_jgutup, qq_jgutex, qq_iterno, qq_iprint, hstep, qq_nxy, 
     &   qq_kf, qq_lenfish, dtfish, qq_igamma, qq_iingest, qq_iassim, 
     &   qq_iegest, qq_iexcret, qq_irespir, qq_isda, cfmean, cpmean, 
     &   fish_la50, qq_death_day, qq_fish_alive)
c
c update: 17:46 fri 4-mar-1994.
c initialize variables for *one* fish year class;
c
c declaration of fortran parameters
c
      include 'chem.par'
      include 'plots.par'
      include 'numbers.par'
      include 'noval.par'
      include 'physio.par'
c
      integer nchem, vv_growth_model, vv_plfunc, lc50func( * )
      integer simul_mode, qq_iterno, qq_iprint
      real conc_plankton_in_water
      real vv_inicf( * ), tw, utbeg, utend, hstep
      real kl( * ), koc( * ), kow( * ), acw( * ), molwt( * )
      real lc50par(maxpar, * ), vv_iniwt
c
      real vv_pval( * ), sigma, nh3n, cn
      real xwt( * ), bfj( * )
      real qq_jgilup( * ), qq_jgilex( * ), qq_jgutup( * ), 
     &   qq_jgutex( * )
      integer qq_nxy
      logical qq_fish_alive
      real qq_kf( * ), cfmean( * ), cpmean( * )
      real qq_lenfish, dtfish
      real qq_igamma, qq_iingest, qq_iassim
      real qq_iegest, qq_iexcret, qq_irespir, qq_isda
      real fish_la50, qq_death_day
c
      integer jchem, npts
      real xpa, xpl, xpoc, plfun, la50, ww0, pafun
      real qq_wgamma, qq_phi, qq_gmax, qq_alpha1, qq_alpha2
      real qq_epsl1, qq_epsl2, qq_mu
      external plfun, la50, pafun
c
      include 'pspoc.def'
      include 'pspoc.sfn'
c
      ww0 = vv_iniwt
      qq_iterno = 0
      npts = 1 + nint((utend - utbeg) / hstep)
      qq_iprint = (npts + maxpoints - 1) / maxpoints
c
c set counters and options;
c
      qq_nxy = 0
      dtfish = zero
c
      qq_lenfish = (ww0 / vv_pval(vlenwt1)) ** (one / vv_pval(vlenwt2))
c
c calculate constant Qq_kf or initialize for mean dynamic Qq_kf
c
      xpl = plfun(ww0, vv_plfunc, vv_pval(vpl1))
      xpa = pafun(xpl, vv_pval(vpa1))
      xpoc = pocfun(xpl, xpa)
      do jchem = 1, nchem
         qq_kf(jchem) = xpa + xpl * kl(jchem) + xpoc * koc(jchem)
      enddo
c
c ******************* set mortality variables ***********************
c
      fish_la50 = la50(lc50func, lc50par, acw, molwt, maxpar, nchem)
      qq_death_day = rnoval
      qq_fish_alive = .true.
c
c ******************* initialize growth state variables *****************
c
      call kphysio(tw, ww0, vv_growth_model, conc_plankton_in_water, 
     &   vv_pval, qq_wgamma, qq_phi, qq_gmax, qq_alpha1, qq_alpha2, 
     &   qq_epsl1, qq_epsl2, qq_mu, sigma, nh3n, cn)
c
c xwt (1): wt-Kdbdtgf;    body weight of fish [g live];
c xwt (2): foodg-Kdbdtgf; mass of food in stomach [g];
c
      xwt(1) = ww0
      xwt(2) = qq_gmax
      qq_igamma = zero
      qq_iingest = zero
      qq_iassim = zero
      qq_iegest = zero
      qq_iexcret = zero
      qq_irespir = zero
      qq_isda = zero
c
c ******************* initialize exchange state variables **********
c -bfj = mass of toxicant in fish due to food and gill exchange (micro grams);
c
      do jchem = 1, nchem
         bfj(jchem) = vv_inicf(jchem) * ww0
         qq_jgilup(jchem) = zero
         qq_jgilex(jchem) = zero
         qq_jgutup(jchem) = zero
         qq_jgutex(jchem) = zero
         cfmean(jchem) = zero
         cpmean(jchem) = zero
      enddo
c
      return
      end
      subroutine initpgm()
c
c update: 14:20 fri 9-sep-1994.
c this subroutine initializes the program variables;
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'ode.par'
      include 'phylum.par'
      include 'plots.par'
c
      include 'holling.def'
      include 'idfiles.def'
      include 'lab.def'
      include 'ode.def'
      include 'plottmp.def'
      include 'units.def'
c
c needed for equivalence testing: kp99 below
      include 'work.def'
c
c miscellaneous declarations;
c make sure blockdata "Blkfgets" is loaded with the image; this was done
c in the main program.
c;;
      character*(35) numalphabet
      character*(stdlen) wmsg
      integer i1mach, m1, m2, jage, xfopen
      integer ndb, ncd, nerr, nmsg
      real cure, rhold
      logical xxok
      real r1mach
      external i1mach, r1mach, xfopen, xfclose
c
      data numalphabet /'123456789abcdefghijklmnopqrstuvwxyz'/
c
      call heapinit()   ! initialize heap package            
c
c get paths
c
      call upaths(dbpath, ndb, opath, ncd, errfil, nerr)
      if (ndb .gt. 0) then
         dbfil = dbpath(1:ndb) // 'Fgets3.db'   ! model parameters database
         hlbfil = dbpath(1:ndb) // 'Fgets.hlb'  ! help info          
      else
         dbfil = 'fgets3.db'
         hlbfil = 'Fgets.hlb'
      endif
      if (nerr .le. 0) then
         errfil = 'Fgets.err'
      endif
c
      stdin = i1mach(1)
      stdout = i1mach(2)
      call f77crctl(stdout)
c
ccc      stderr = I1mach(2)      ! I1mach(4)
c
c open Log file
      if (zioerror .eq. xfopen(jerr, errfil, ziowrite)) then
         jerr = stdout
      endif
c
c make sure equivalences are ok;
c
      if (kp99 .gt. vec_len) then
         write (jerr, *) '?? internal error: kp99 > vec_len !'
         call errlog(.true., ' ', 0)
      endif
c
      if (kq99 .gt. vec_len) then
         write (jerr, *) '?? internal error: kq99 > vec_len !'
         call errlog(.true., ' ', 0)
      endif
c
      if (maxbk .gt. rrlen) then
         write (jerr, *) '?? internal error: maxbk > rrlen !'
         call errlog(.true., ' ', 0)
      endif
c
c propagate changes: "Initpgm" "Envexams" "Envexam0" "Webtemp" "examsrec.def"
c                    "iend"
c . size_of (Wvector) == maxvals .ge. number of entries in exams exposure file
c . number of entries in exams exposure file == 3 + 3*n, n == Gnchem
c . format of exams exposure file
c     time temp plankton_stock cw(1:n) benthos_conc(1:n) plankton_conc(1:n)
c                                      cfish_conc(1:n)
c . module "Envexams": character*(329)      card
c   from exams -- exposure file format:
c     - 1x, 1pe12.5, 1x, 0pf5.1, 1x, 1pe9.2, 30(1x,e9.2)
c     - length of line: 29 + 30*n, n = number of chemicals
c     - 329 = 29 + 30 * maxchem
c
      if (maxvals .lt. (3 * maxchem + 3)) then
         write (jerr, *) '?? internal error: "Wvector" too small !'
         call errlog(.true., ' ', 0)
      endif
c
c set program units; initialize unit conversion software;
c ppmillion     : ppm: micrograms/ml, (10^-6 grams/ml)
c ppbillion     : ppb: nanograms/ml,  (10^-9 grams/ml)
c pptrillion    : ppt: picograms/ml,  (10^-12 grams/ml)
c ppquadrillion : ppq: femtograms/ml, (10^-15 grams/ml)
c ppquintillion : pp_: attograms/ml,  (10^-18 grams/ml)
c;;
      pgm_time = 'days'
      pgm_conc = 'ppm'
      pgm_mass = 'grams'
      pgm_volume = 'ml'
      m1 = index(pgm_volume, ' ')
      m2 = index(pgm_time, ' ') - 1
      pgm_flow = pgm_volume(1:m1) // pgm_time(1:m2) // '^-1'    ! ml day^-1
      call unitdrv('years', pgm_time, one_year, xxok, wmsg, nmsg)
c
c from exams: compute machine-dependent precision via computation of cure
c (computer unit roundoff error), the smallest positive value such that
c 1+cure > 1 in floating point arithmetic.
c
      cure = 1.0e+00
  110 continue
      cure = cure / 2
      rhold = 1.0e+00 + cure
      if (rhold .gt. 1.0e+00) go to 110
      mach_eps = 8.0e+00 * cure
c
c plotting stuff
c
      sobs = 'o'
      do jage = 1, maxage
         steo(jage) = numalphabet(jage:jage)
      enddo
c
      return
      end
      subroutine initvar()
c
c update: 17:27 fri 4-mar-1994.
c this subroutine initializes and/or resets default variables
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'dbphysio.par'
      include 'fish.par'
      include 'habitat.par'
      include 'noval.par'
      include 'numbers.par'
      include 'ode.par'
      include 'phylum.par'
      include 'plots.par'
c
      include 'chemp.def'
      include 'chems.def'
      include 'diet.def'
      include 'examsrec.def'
      include 'fish.def'
      include 'fluxes.def'
      include 'globpar.def'
      include 'habitat.def'
      include 'idfiles.def'
      include 'obsdata.def'
      include 'ode.def'
      include 'options.def'
      include 'page.def'
      include 'time.def'
      include 'units.def'
c
c miscellaneous declarations
c;;
      integer jj, jspecies, jage, jchem, jpar, nq1, xslen
      external xslen
c
      wtunits = pgm_mass        ! set chemicals independent defaults
      cfunits = pgm_conc
      cwunits = pgm_conc
      tunits = pgm_time
c
      simul_beg = zero
      simul_end = simul_beg
      tnstep = 8.00
      tref_output = ref_celsius
c
      simul_mode = inoval
      xsteady_state_gut = .true.
      xupdate_continuously = .false.
      xdiet = .false.
      xplankton = .false.
      xbenthos = .false.
      xcfish = .false.
      dplankton = .false.
      dbenthos = .false.
      dcfish = .false.
      iread_cw = inoval
      iread_benthos = inoval
      iread_cfish = inoval
      iread_plankton = inoval
c
c initialize all fish parameters (species and ages)
c;;
      do jspecies = 1, maxspecies
         spplab(jspecies) = snoval
         famlab(jspecies) = snoval
         ecolab(jspecies) = snoval
         fish_la50(jspecies) = rnoval
         activegill(jspecies) = 1.00 / 3.00
c
c set observed data defaults (i.e., disable them)
c;;
         nobs(jspecies) = 0
         col_t(jspecies) = 0
         col_c(jspecies) = 0
         col_w(jspecies) = 0
         data_t(jspecies) = .false.
         data_c(jspecies) = .false.
         data_w(jspecies) = .false.
c
         do jchem = 1, maxchem
            lc50func(jchem, jspecies) = inoval
            do jpar = 1, maxpar
               lc50par(jpar, jchem, jspecies) = rnoval
            enddo
         enddo
c
         do jage = 1, maxage
            vv_iniwt(jage, jspecies) = rnoval
            vv_plfunc(jage, jspecies) = inoval
            vv_growth_model(jage, jspecies) = inoval
            qq_max_activity(jage, jspecies) = rnoval
c
            do jchem = 1, maxchem
               vv_inicf(jchem, jage, jspecies) = rnoval
               max_cf(jchem, jage, jspecies) = rnoval
            enddo
c
c set model parameterization defaults
c;;
            do jj = 1, maxfpar
               vv_pval(jj, jage, jspecies) = rnoval
               vv_ptyp(jj, jage, jspecies) = tuser
            enddo
         enddo
      enddo
c
c initialize environmental water temperature variables
c;;
      twfunc = inoval
      do jpar = 1, maxpar
         twpar(jpar) = rnoval
      enddo
c
c set chemicals dependent defaults
c;;
      plankton_standing_stock_func = inoval
c
      gnchem = 0
      cwfil = snoval
      planktonfil = snoval
      benthosfil = snoval
      cfishfil = snoval
      benthos_chem_func = inoval
      cfish_chem_func = inoval
      plankton_chem_func = inoval
      do jchem = 1, maxchem
         write (toxlab(jchem), '(a,i4)') 'Chemical ', jchem
         call compress(toxlab(jchem), -1, nq1)
         molwt(jchem) = rnoval
         molvol(jchem) = rnoval
         mp(jchem) = rnoval
         logp(jchem) = rnoval
         clogp(jchem) = rnoval
         pka(jchem) = rnoval
         cwfunc(jchem) = inoval
         do jpar = 1, maxpar
            cwpar(jpar, jchem) = rnoval
         enddo
      enddo
c
c set logical defaults: options, plots, etc.
c;;
      xwtxt = .false.   ! wt vs  t plot                           
      xcfxt = .false.   ! cf vs  t plot                           
      xcfxwt = .false.  ! cf vs wt plot                           
      xcw_t = .false.   ! cwater vs t plot                        
      xcf_aro_wt = .false.      ! cf_aroclor vs wt plot                   
      xcf_aro_t = .false.       ! cf_aroclor vs  t plot                   
      xactvt_wt = .false.       ! total activity vs wt plot               
      xactvt_t = .false.        ! total activity vs  t plot               
      xfishpar = .false.        ! physiological parameters                
      xdata = .false.   ! time series                             
      xupdate_input = .false.   ! generate updated Fgets input file       
      xresearch = .false.       ! truth of "/_research" command read;     
c
      xtiming = .false.
      xtotals = .false.
      xlast_year_only = .false.
      title_set = .false.
      xfcelsius = .false.
      xfourier = .true.
      xwt0 = .false.
      xexams = .false.
      xauditff = .false.
      xauditon = .false.
      xoutff = .false.
      xouton = .false.
c
      kmethod = teuler
c
      return
      end
      subroutine int2a(inum, snum, nnum)
c
c update: tue 14:44 21-apr-1992.
c convert the integer "inum" to its character string.
c
c input:
c . inum - the integer number
c
c output:
c . snum(1:nnum) - string, left justified.
c
      integer inum
      character*( * ) snum
      integer nnum, ios
c
      snum = ' '
      write (unit=snum, fmt='(i7)', iostat=ios) inum
      call compress(snum, -1, nnum)
c
      return
      end
      subroutine iobs(cname, no_errors)
c
c update: 11:34 wed 17-aug-1994.
c /observations string_1 ... string_n
c valid string values are: time, cfish, wt
c
c this command should be followed with the data to be read.
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'plots.par'
      include 'Prompt.par'
      include 'strings.par'
      include 'token.par'
c
      include 'chars.def'
      include 'globpar.def'
      include 'idfiles.def'
      include 'obsdata.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      character*(s255) q1tmp
      real rval
      integer ival, toktype, sumerr, ncol, nq1, xslen
      logical done, xxok, havefish
      external havefish, xslen
c
      include 'chars.sfn'
c
 9110 format (' ?? "/',a,'" : valid strings are ',
     &   '"time", "cfish", or "wt"')
 9120 format (' ?? "/',a,'" : no strings found; valid strings are ',
     &   '"time", "cfish", or "wt"')
 9130 format (' ?? "/',a,'" : requires "/species" first.')
c
      call prompt(prset1, cname)
      sumerr = 0
c
      if ( .not. havefish()) then
         sumerr = sumerr + 1
         write (stdout, 9130) cname
         call tokreset()
         go to 130
      endif
c
c decode the type and sequential order of input observations
c
      ncol = 1
      nobs(gnspecies) = 0
      data_t(gnspecies) = .false.
      data_c(gnspecies) = .false.
      data_w(gnspecies) = .false.
c
  110 continue
      call tok2dlim(' ', q1tmp)
      done = (iseol(q1tmp(1:1)))
      if ( .not. done) then
         nq1 = xslen(q1tmp)
         if (q1tmp(1:nq1) .eq. 'time') then
            data_t(gnspecies) = .true.
            col_t(gnspecies) = ncol
            ncol = ncol + 1
         elseif (q1tmp(1:nq1) .eq. 'cfish') then
            data_c(gnspecies) = .true.
            col_c(gnspecies) = ncol
            ncol = ncol + gnchem
         elseif (q1tmp(1:nq1) .eq. 'wt') then
            data_w(gnspecies) = .true.
            col_w(gnspecies) = ncol
            ncol = ncol + 1
         else
            sumerr = sumerr + 1
            write (stdout, 9110) cname
         endif
         go to 110
      endif
c
      if (sumerr .eq. 0) then
         if (ncol .eq. 1) then
            sumerr = sumerr + 1
            write (stdout, 9120) cname
            call tokreset()
            go to 130
         endif
      endif
c
c read and store observed data
c need to fix: if the first token is not a "/" or a number, pushback and exit
c
  120 continue
      call toknext(ttoken, q1tmp, ival, rval, toktype)
      if (q1tmp(1:1) .ne. '/') then
         call tokpush() ! put number back in buffer 
         call tok2dlim(eol, q1tmp)
         nq1 = xslen(q1tmp)
         call iobs0(cname, xxok, q1tmp, nq1, gnspecies, nobs(gnspecies),
     &      gnchem, col_t(gnspecies), col_w(gnspecies), 
     &      col_c(gnspecies), data_t(gnspecies), data_w(gnspecies), 
     &      data_c(gnspecies))
         if ( .not. xxok) sumerr = sumerr + 1
         go to 120
      else
         call tokpush()
      endif
c
  130 continue
      no_errors = (sumerr .eq. 0)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine iobs0(cname, no_errors, card, ncard, kspecies, jobs, 
     &   nchem, jtcol, jwcol, jccol, ltdat, lwdat, lcdat)
c
c update: 17:27 fri 4-mar-1994.
c read observations
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'fish.par'
      include 'chem.par'
      include 'plots.par'
      include 'numbers.par'
      include 'phylum.par'
      include 'Prompt.par'
      include 'idfiles.def'
      include 'obsdata.def'
      include 'work.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname, card
      integer jtcol, jwcol, jccol, jobs, ncard, kspecies, nchem
      logical ltdat, lwdat, lcdat, no_errors
c
      real xepsilon
      integer sumerr, nvals, nerror, ii, jchem, obsnum
      logical pmfound
      data xepsilon /0.001/
c
 9110 format (' ?? "/',a,'" : invalid observed data record.')
 9120 format (' ?? "/',a,'" : need at least ',i2,
     &   ' observations, found ',i2)
 9130 format (' ?? "/',a,'" : no +- found when "Data_sd" specified')
 9140 format (' ?? "/',a,'" : observation has been ignored due to',
     &   ' insufficient storage space.')
c
      call prompt(prset1, cname)
      sumerr = 0
      call gmpms(card, ncard, wmatrix, maxvals, nvals, nerror, pmfound)
      if (nerror .ne. 0) then
         sumerr = sumerr + 1
         write (stdout, 9110) cname
         go to 110
      endif
c
c need at least *obsnum* observations per line;
c *nvals* is the number of observations read.
c
      obsnum = max(jtcol, jwcol, jccol + nchem - 1)
      if (nvals .lt. obsnum) then
         sumerr = sumerr + 1
         write (stdout, 9120) cname, obsnum, nvals
         go to 110
      endif
c
      if (data_sd .and. ( .not. pmfound)) then
         sumerr = sumerr + 1
         write (stdout, 9130) cname
         go to 110
      endif
c
      if (data_sd) then
         if (jobs .ge. maxobs) then
            sumerr = sumerr + 1
            write (stdout, 9140) cname
            go to 110
         endif
         if (ltdat) then
            tobs(jobs + 1, kspecies) = wmatrix(jtcol, 1)
            tobs(jobs + 2, kspecies) = wmatrix(jtcol, 1)
         endif
         if (lcdat) then
            do jchem = 1, nchem
               ii = jccol + (jchem - 1)
               cfobs(jobs + 1, jchem, kspecies) = wmatrix(ii, 1) - 
     &            wmatrix(ii, 2)
               if (cfobs(jobs + 1, jchem, kspecies) .le. zero) then
                  cfobs(jobs + 1, jchem, kspecies) = xepsilon
               endif
               cfobs(jobs + 2, jchem, kspecies) = wmatrix(ii, 1) + 
     &            wmatrix(ii, 2)
            enddo
         endif
         if (lwdat) then
            wobs(jobs + 1, kspecies) = wmatrix(jwcol, 1) - 
     &         wmatrix(jwcol, 2)
            if (wobs(jobs + 1, kspecies) .le. zero) then
               wobs(jobs + 1, kspecies) = xepsilon
            endif
            wobs(jobs + 2, kspecies) = wmatrix(jwcol, 1) + 
     &         wmatrix(jwcol, 2)
         endif
         jobs = jobs + 2
c
      elseif (data_mean) then
         jobs = jobs + 1
         if (jobs .ge. maxobs) then
            write (stdout, 9140) cname
            sumerr = sumerr + 1
            go to 110
         endif
         if (ltdat) tobs(jobs, kspecies) = wmatrix(jtcol, 1)
         if (lcdat) then
            do jchem = 1, nchem
               ii = jccol + (jchem - 1)
               cfobs(jobs, jchem, kspecies) = wmatrix(ii, 1)
            enddo
         endif
         if (lwdat) wobs(jobs, kspecies) = wmatrix(jwcol, 1)
      endif
c
  110 continue
      call prompt(prpop, ' ')
      no_errors = (sumerr .eq. 0)
      return
      end
      subroutine iopts(cname, no_errors)
c
c update: 17:27 fri 4-mar-1994.
c
c /print option_1 ... option_n
c /plot  option_1 ... option_n
c
c the options are:
c . wt (time)
c . cfish (time | wt)
c . total_activity (time | wt)
c . cw (time)
c . cf_aroclor ( time | wt , arg_1, arg_2, ..., arg_nchem)
c   generate aroclor-type plot
c
c . fishpar (Tref_output)
c   where Tref_output = equals the standard reference temperature desired
c   for output of physiological parameters
c
c . time_series
c   no arguments
c
c . update_input
c   no arguments
c   after the simulation is completed, dump all the data in Fgets input cards.
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'dbphysio.par'
      include 'noval.par'
      include 'Prompt.par'
      include 'token.par'
c
      include 'chars.def'
      include 'globpar.def'
      include 'idfiles.def'
      include 'options.def'
c
c declarations of subroutine's formal parameters
c
      logical no_errors
      character*( * ) cname
c
      character*(stdlen) q1tmp
      real rval
      logical xenable, xxok
      integer ival, toktype, xslen, sumerr
      integer tindex, nn, nv, nq1
      external xslen
c
      include 'chars.sfn'
c
 9110 format (' ?? "/',a,'" : "cf_aroclor" expects a number.')
 9120 format (' ?? "/',a,'" : "fishpar" expects a number.')
 9130 format (' ?? "/',a,'" : no such option.')
c
      call prompt(prset1, cname)
      sumerr = 0
  110 continue
      call tok2dlim(' (', q1tmp)
      if ( .not. iseol(q1tmp(1:1))) then
         nq1 = xslen(q1tmp)
         xenable = (.true.)
c
c plots
         if (q1tmp(1:nq1) .eq. 'wt') then
            call iopts0(cname, sumerr, xenable, q1tmp(1:nq1), xwtxt, 
     &         xwtxt, nv)
            call toknext(ttoken, q1tmp, ival, rval, toktype)    ! ")"    
c
         elseif (q1tmp(1:nq1) .eq. 'cfish') then
            call iopts0(cname, sumerr, xenable, q1tmp(1:nq1), xcfxt, 
     &         xcfxwt, nv)
            call toknext(ttoken, q1tmp, ival, rval, toktype)    ! ")"    
c
         elseif (q1tmp(1:nq1) .eq. 'total_activity') then
            call iopts0(cname, sumerr, xenable, q1tmp(1:nq1), xactvt_t,
     &         xactvt_wt, nv)
            call toknext(ttoken, q1tmp, ival, rval, toktype)    ! ")"    
c
         elseif (q1tmp(1:nq1) .eq. 'cw') then
            call iopts0(cname, sumerr, xenable, q1tmp(1:nq1), xcw_t, 
     &         xcw_t, nv)
            call toknext(ttoken, q1tmp, ival, rval, toktype)    ! ")"    
c
         elseif (q1tmp(1:nq1) .eq. 'cf_aroclor') then
            call iopts0(cname, sumerr, xenable, q1tmp(1:nq1), xcf_aro_t,
     &         xcf_aro_wt, nv)
            if (nv .eq. 1) then
               tindex = pt_aroclor
            elseif (nv .eq. 2) then
               tindex = pwt_aroclor
            else
               tindex = inoval
               call tok2dlim(')', q1tmp)        ! skip rest of this command     
            endif
            if (tindex .ne. inoval) then
               nn = 1
  120          continue
               if (nn .le. gnchem) then
                  call toknext(ttoken, q1tmp, ival, rval, toktype)     ! comma
                  call toknext(ttoken, q1tmp, ival, rval, toktype)     ! number
                  xxok = ((toktype .eq. treal) .or. (toktype .eq. tint))
                  if (xxok) then
                     wtfac_aroclor(nn, tindex) = rval
                     nn = nn + 1
                     go to 120
                  else
                     sumerr = sumerr + 1
                     write (stdout, 9110) cname
                     call tokreset()
                  endif
               endif
               call toknext(ttoken, q1tmp, ival, rval, toktype) ! ")"     
            endif
c
         elseif (q1tmp(1:nq1) .eq. 'fishpar') then
            xfishpar = (xenable)
            call toknext(ttoken, q1tmp, ival, rval, toktype)    ! "(" 
            if (q1tmp(1:1) .eq. '(') then
               call toknext(ttoken, q1tmp, ival, rval, toktype) ! number
               xxok = ((toktype .eq. treal) .or. (toktype .eq. tint))
               if (xxok) then
                  tref_output = rval
               else
                  sumerr = sumerr + 1
                  write (stdout, 9120) cname
               endif
            else        ! no argument: use default
               tref_output = ref_celsius
            endif
            call toknext(ttoken, q1tmp, ival, rval, toktype)    ! ")" 
c
         elseif (q1tmp(1:nq1) .eq. 'time_series') then
            xdata = (xenable)
c
         elseif (q1tmp(1:nq1) .eq. 'update_input') then
            xupdate_input = (xenable)
c
         else
            sumerr = sumerr + 1
            write (stdout, 9130) cname
         endif
         go to 110
      endif
c
  130 continue
      call tokreset()
      call prompt(prpop, ' ')
      no_errors = (sumerr .eq. 0)
      return
      end
      subroutine iopts0(cname, sumerr, xenable, syvar, lx1, lx2, nv)
c
c update: 16:33 fri 4-mar-1994.
c
c common code to several plot options:
c read two tokens; the first one should be "("; the second,
c . if stoken_2 == 'time', then Lx1 = .true.
c . if stoken_2 == 'wt',   then Lx2 = .true.
c . otherwise issue error message;
c
c on output, nv is set to 0, 1, or 2, depending on which variable was set
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'Prompt.par'
      include 'strings.par'
      include 'token.par'
c
      include 'heap.def'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname, syvar
      logical lx1, lx2, xenable
      integer sumerr, nv
c
c local variables
c
      integer nss, ival, xslen, toktype, ptok
      real rval
      external xslen
c
 9110 format (1x,'"/',a,'" : option "',a,'" requires "time" or "wt".')
c
      call prompt(prset1, cname)
      ptok = 0  ! assign heap storage            
      call heapush(ptok)
c
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)      ! "("   
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)      ! x-variable
      nss = xslen(qhs(ptok))
      if (qhs(ptok)(1:nss) .eq. 'time') then
         nv = 1
         lx1 = (xenable)
      elseif (qhs(ptok)(1:nss) .eq. 'wt') then
         nv = 2
         lx2 = (xenable)
      else
         nv = 0
         sumerr = sumerr + 1
         write (stdout, 9110) cname, syvar
         call tokreset()
      endif
      call heapop(ptok) ! release heap storage                 
      call prompt(prpop, ' ')
c
      return
      end
      subroutine ioutput(cname, no_errors)
c
c update: fri 16:49 13-mar-1992.
c @@@@
c
c declaration of fortran parameters
c;;
      include 'Prompt.par'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      call prompt(prset1, cname)
      no_errors = (.false.)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine ipchem(cname, no_errors, physchem)
c
c update: 17:51 fri 4-mar-1994.
c chemicals properties: /Molwt, /Molvol, /melting_point, /Logp, /Clogp, /Pka
c command is of the forms:
c        / xxx #val_1 #val_2 ... #val_n
c        / xxx (j) = <val_{j}>
c     where
c        xxx:     one of the strings Molwt, Molvol, Mp, Logp, Clogp, Pka
c        val_*:   Real numbers
c     examples
c        / Molwt  1.1   1.2   1.3   1.4   1.5
c        / Molwt (3) = 1.3
c        / Molwt (1-5) = 1.3
c        / Molwt (*)   = 1.3
c
c description of some of the variables
c - PhysChem: chemical properties arrays:
c             Molwt | Molvol | Mp | Logp | Clogp | Pka
c
c if Gnchem is not set, exit.
c help & quit at any time.
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'menu.par'
      include 'noval.par'
      include 'strings.par'
c
      include 'echo.def'
      include 'globpar.def'
      include 'idfiles.def'
      include 'vdefined.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      real physchem( * )
      logical no_errors
c
      character*(s20) q1tmp, q2tmp
      character*(1) cc
      real rval, rlo, rhi
      integer xslen, jchem, kbeg, kend, nq1, nq2
      integer xstate, exitcode, np, nerrors
      logical limset, xisnumb, isempty, xxok, done
      external xisnumb, xslen, isempty
c
      include 'vdefined.sfn'
c
 9110 format (1x,a,'(',a,') = ',a)
 9120 format (1x,'?? extraneous characters after valid command ignored:'
     &   )
 9130 format (1x,
     &   '?? must define the number of chemicals (via "/chemicals")',/,1
     &   x,'   before setting chemical properties.')
 9140 format (1x,'?? ',a,' integer not in the range 1 to ',a)
 9150 format (1x,'?? missing "="')
 9160 format (1x,'?? expecting a Real number')
 9170 format (1x,'?? expecting ',a,' Real values.')
 9180 format (1x,'?? begin-of-range must be .le. end-of-range')
c
c Gnchem must be defined before setting the chemical properties.
c
c state 0 (label = 2999): exit
c state 1: begin state variable approach
c
      nerrors = 0
      if (gnchem .eq. inoval) then
         xstate = 0
         limset = .false.
         write (stdout, 9130)
         nerrors = nerrors + 1
      else
         xstate = 1
         limset = .false.
      endif
c
  110 continue
      go to (200, 120, 130, 140, 150, 160, 170, 180), xstate + 1
c
c state 1: determine type: < I | II >
c type I                         type II
c . Molwt (3) = 1.3              . Molwt  1.1   1.2   1.3   1.4   1.5
c . Molwt (1-5) = 1.3
c . Molwt (*)   = 1.3
c
  120 continue
      call tok1c(cname, '~/PhysChem/syntax', exitcode, cc)
      if (exitcode .eq. tquit) then
         xstate = 0
         limset = .false.
      elseif (exitcode .eq. tfailure) then
         xstate = 0
         limset = .false.
         nerrors = nerrors + 1
      elseif (cc .eq. '(') then
         xstate = 2     ! decode type I               
      else
         call tokpush()
         xstate = 7     ! decode type II              
      endif
      go to 110
c
c state 2: decoding type I
c . get range
c . check its validity
c
  130 continue
      call tokrange(cname, ')', exitcode, rlo, rhi)
      if (exitcode .eq. tquit) then
         xstate = 0
         limset = .false.
      elseif (exitcode .eq. tfailure) then
         xstate = 0
         limset = .false.
         nerrors = nerrors + 1
      elseif (exitcode .eq. twild) then
         xstate = 3     ! evaluate "*"                
      else
         xstate = 4     ! integer range               
      endif
      go to 110
c
c state 3:
c . interpreting "*"
c . next state: look for "="
c
  140 continue
      kbeg = 1
      kend = gnchem
      xstate = 5
      limset = .true.
      go to 110
c
c state 4: found range -- interpret
c . if no errors, next state will look for "="
c
  150 continue
      kbeg = nint(rlo)
      kend = nint(rhi)
      xxok = ((1 .le. kbeg) .and. (kbeg .le. gnchem))
      if ( .not. xxok) then
         nerrors = nerrors + 1
         call int2a(gnchem, q1tmp, nq1)
         write (stdout, 9140) 'first', q1tmp(1:nq1)
      endif
      xxok = ((1 .le. kend) .and. (kend .le. gnchem))
      if ( .not. xxok) then
         nerrors = nerrors + 1
         call int2a(gnchem, q1tmp, nq1)
         write (stdout, 9140) 'second', q1tmp(1:nq1)
      endif
      xxok = (kbeg .le. kend)
      if ( .not. xxok) then
         nerrors = nerrors + 1
         write (stdout, 9180)
      endif
      if (nerrors .le. 0) then
         xstate = 5
         limset = .true.
      else
         xstate = 0
         limset = .false.
      endif
      go to 110
c
c state 05: look for "="
  160 continue
      call tok1c(cname, '~/PhysChem/equal', exitcode, cc)
      if (exitcode .eq. tquit) then
         xstate = 0
         limset = .false.
      elseif (cc .eq. '=') then
         xstate = 6
      else
         xstate = 0
         limset = .false.
         write (stdout, 9150)
         nerrors = nerrors + 1
      endif
      go to 110
c
  170 continue  ! read rval                                           
      call tok1t(cname, '~/PhysChem/value', exitcode, q1tmp, nq1)
      if (exitcode .eq. tquit) then
         xstate = 0
         limset = .false.
      else
         np = 1
         if (xisnumb(rval, q1tmp, np)) then
            do jchem = kbeg, kend
               physchem(jchem) = rval
            enddo
            xstate = 0
         else
            xstate = 0
            limset = .false.
            write (stdout, 9160)
            nerrors = nerrors + 1
         endif
      endif
      go to 110
c
  180 continue
      kbeg = 1
      xxok = .true.
      jchem = 0
      limset = .true.
c
  190 continue
      done = ((jchem .ge. gnchem) .or. ( .not. xxok))
      if ( .not. done) then
         call int2a(jchem + 1, q1tmp, nq1)
         q2tmp = cname // '(' // q1tmp(1:nq1) // ') = '
         nq2 = xslen(q2tmp) + 1
         call tok1t(q2tmp(1:nq2), '~/PhysChem/syntax', exitcode, q1tmp,
     &      nq1)
         np = 1
         if (xisnumb(rval, q1tmp, np)) then
            xxok = .true.
            jchem = jchem + 1
            physchem(jchem) = rval
         else
            xxok = .false.
            call int2a(gnchem, q1tmp, nq1)
            write (stdout, 9170) q1tmp(1:nq1)
            nerrors = nerrors + 1
         endif
         go to 190
      endif
      kend = jchem
      xstate = 0
      go to 110
c
  200 continue
      if (xecho .and. limset) then
         do jchem = kbeg, kend
            call int2a(jchem, q1tmp, nq1)
            if (vdefined(physchem(jchem))) then
               call real2a(physchem(jchem), '(1pg14.6)', q2tmp, nq2)
               write (stdout, 9110) cname, q1tmp(1:nq1), q2tmp(1:nq2)
            else
               write (stdout, 9110) cname, q1tmp(1:nq1), snoval
            endif
         enddo
      endif
c
      if (nerrors .gt. 0) then
         call tokreset()
      else
         if ( .not. isempty()) then
            write (stdout, 9120)
            call tokreset()
         endif
      endif
      no_errors = (xxok)
c
      return
      end
      subroutine iplfish(cname, no_errors)
c
c update: 11:34 wed 17-aug-1994.
c read "/plfish" command;
c plan for the future: expand argument list and read "/pafish" also;
c
c /plfish #id1[-#id2]  #function_name #1 ... #n
c                       constant      #1
c                       linear        #1 #2
c                       allometric    fishpar
c                       allometric    database
c                       allometric    #1 #2
c
c - #id1[-#id2] : year class identifier; may be an integer or a range;
c   examples:
c     / plfish 1-2 allometric ...
c        ! determine lipid fraction for year classes 1 and 2 using the
c              allometric function
c     / plfish 3 constant ...
c        ! determine lipid fraction for year class 3 using a constant function;
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'numbers.par'
      include 'physio.par'
      include 'Prompt.par'
      include 'simul.par'
      include 'strings.par'
      include 'token.par'
c
      include 'fish.def'
      include 'globpar.def'
      include 'heap.def'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      real rval
      integer ival, toktype, kbeg, kend, ptok, jage
      logical xxok, havefish
      external havefish
c
 9110 format (' ?? "/',a,'" : valid options are:',/,
     &   '    "constant", "linear", "allometric #1 #2", ',
     &   '"allometric fishpar", "allometric database"')
 9120 format (' ?? "/',a,'" : requires "/species" first.')
c
      call prompt(prset1, cname)
      ptok = 0
      call heapush(ptok)
c
      if ( .not. havefish()) then
         xxok = .false.
         write (stdout, 9120) cname
         call tokreset()
         go to 110
      endif
c
c get the yearclass identifier(s)
c
      call irange(cname, xxok, xmaximum_age(gnspecies), kbeg, kend)
      if (xxok) then
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)
      else
         call tokreset()
         go to 110
      endif
c
      xxok = ((qhs(ptok) .eq. 'constant') .or. (qhs(ptok) .eq. 'linear')
     &   .or. (qhs(ptok) .eq. 'allometric'))
      if (xxok) then
         call tokpush()
         call ifargs(cname, vv_plfunc(kbeg, gnspecies), 
     &      vv_pval(vpl1, kbeg, gnspecies), xxok)
         if (vv_plfunc(kbeg, gnspecies) .eq. tconstant) then
            vv_pval(vpl2, kbeg, gnspecies) = zero
         endif
c
         do jage = kbeg, kend
            if (jage .ne. kbeg) then
               vv_plfunc(jage, gnspecies) = vv_plfunc(kbeg, gnspecies)
               vv_pval(vpl1, jage, gnspecies) = 
     &            vv_pval(vpl1, kbeg, gnspecies)
               vv_pval(vpl2, jage, gnspecies) = 
     &            vv_pval(vpl2, kbeg, gnspecies)
            endif
c
            if (vv_plfunc(jage, gnspecies) .eq. tdatabase) then
               vv_ptyp(vpl1, jage, gnspecies) = tdatabase
               vv_ptyp(vpl2, jage, gnspecies) = tdatabase
            endif
         enddo
      endif
c
      if ( .not. xxok) then
         write (stdout, 9110) cname
         call tokreset()
      endif
c
  110 continue
      call heapop(ptok)
      no_errors = (xxok)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine iplnkstk(cname, no_errors)
c
c update: 17:44 fri 4-mar-1994.
c set plankton standing stock [grams/Litre]
c
c / plankton_standing_stock  file      plankton.Exp
c / plankton_standing_stock  constant  #1
c
c the strings are input without quotes.
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'habitat.par'
      include 'Prompt.par'
      include 'simul.par'
      include 'strings.par'
      include 'token.par'
c
      include 'habitat.def'
      include 'heap.def'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      real rval
      integer ival, toktype, nss, ptok
      logical xxok
c
 9110 format (' ?? "/',a,'" : "file" option requires a file name.')
 9120 format (' ?? "/',a,'" : "constant" expects one Real number.')
 9130 format (' ?? "/',a,'" : unrecognized option;',/,
     &   '    valid options are: "file", and "constant".')
c
      call prompt(prset1, cname)
      ptok = 0
      call heapush(ptok)
c
      xxok = .true.
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)
c
      if (qhs(ptok) .eq. 'file') then
         plankton_standing_stock_func = tfile
         call tok2dlim(eol, qhs(ptok))
         call ustripd(qhs(ptok), -1, qhs(ptok), nss)
         xxok = (nss .gt. 0)
         if (xxok) then
            planktonfil = qhs(ptok)
         else
            write (stdout, 9110) cname
            call tokreset()
         endif
c
      elseif (qhs(ptok) .eq. 'constant') then
         plankton_standing_stock_func = tconstant
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)
         xxok = ((toktype .eq. treal) .or. (toktype .eq. tint))
         if (xxok) then
            plankton_standing_stock_conc = rval
         else
            write (stdout, 9120) cname
            call tokreset()
         endif
c
      else
         xxok = .false.
         write (stdout, 9130) cname
         call tokreset()
      endif
c
      call heapop(ptok)
      no_errors = (xxok)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine irange(cname, no_errors, idmax, id1, id2)
c
c update: 16:33 fri 4-mar-1994.
c decode a range specification; valid forms are:
c a. #id
c b. #id1-#id2
c
c will return id1 and id2; if id2 was not present, id2 == id1.
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'strings.par'
      include 'token.par'
      include 'heap.def'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      integer idmax, id1, id2
      logical no_errors
c
      real rval
      integer ival, toktype, kbeg, kend, ptok
      logical xxok
c
 9110 format (' ?? "/',a,'" : requires an indicator.')
 9120 format (' ?? "/',a,'" : id# = ',i3,' not in [1 ..',i3,']')
 9130 format (' ?? "/',a,'" : invalid range.')
c
      ptok = 0
      call heapush(ptok)
c
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)      ! id1      
      xxok = (toktype .eq. tint)
      if ( .not. xxok) then
         write (stdout, 9110) cname
         go to 110
      endif
c
      kbeg = ival
      xxok = ((1 .le. kbeg) .and. (kbeg .le. idmax))
      if ( .not. xxok) then
         write (stdout, 9120) cname, kbeg, idmax
         go to 110
      endif
c
c do we have a range ?  if we do, the next token is either
c the "-" operator or a negative integer;
c
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)
      if (qhs(ptok)(1:1) .eq. '-') then ! range descriptor ?
         if (toktype .eq. toper) then
            call toknext(ttoken, qhs(ptok), ival, rval, toktype)
         endif
         xxok = (toktype .eq. tint)     ! #id2 ?    
         if ( .not. xxok) then
            write (stdout, 9130) cname
            go to 110
         endif
         kend = abs(ival)
         xxok = ((1 .le. kend) .and. (kend .le. idmax)) ! in range ?
         if ( .not. xxok) then
            write (stdout, 9120) cname, kend, idmax
            go to 110
         endif
      else
         kend = kbeg
         call tokpush()
      endif
c
      id1 = kbeg
      id2 = kend
c
  110 continue
      no_errors = (xxok)
      call heapop(ptok)
c
      return
      end
      subroutine irecall(cname, no_errors)
c
c update: fri 16:50 13-mar-1992.
c @@@@
c
c declaration of fortran parameters
c;;
      include 'Prompt.par'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      call prompt(prset1, cname)
      no_errors = (.false.)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine irun(cname, no_errors)
c
c update: 11:41 wed 17-aug-1994.
c
c take care of closing ceremonies;
c . determine total number of fish.
c . load labels and species data for last fish and update pointers
c . erase Vv_pval arrays when requested
c . set "exams" exposure file pointers
c
c propagate changes: "Initpgm" "Envexams" "Envexam0" "Webtemp" "examsrec.def" "iend"
c . size_of (Wvector) == maxvals .ge. number of entries in exams exposure file
c . number of entries in exams exposure file == 3 + 3*n, n == Gnchem
c . format of exams exposure file
c     time temp plankton_stock cw(1:n) benthos_conc(1:n) plankton_conc(1:n)
c                                      cfish_conc(1:n)
c . module "Envexams": character*(329)      card
c   from exams -- exposure file format:
c     - 1x, 1pe12.5, 1x, 0pf5.1, 1x, 1pe9.2, 30(1x,e9.2)
c     - length of line: 29 + 30*n, n = number of chemicals
c     - 329 = 29 + 30 * maxchem
c check parameters and run simulation
c;;
      include 'xglobal.par'
      include 'xinclude.inc'
      include 'chem.par'
      include 'fish.par'
      include 'habitat.par'
      include 'noval.par'
      include 'page.par'
      include 'simul.par'
c
      include 'errors.def'
      include 'examsrec.def'
      include 'fish.def'
      include 'globpar.def'
      include 'habitat.def'
      include 'idfiles.def'
      include 'options.def'
c
      character*( * ) cname
      logical no_errors
c
      logical xlast, panic
      integer nerror, sumerr, jspecies, jage, jpar
      integer nts, xfopen, xquery, xslen
      external xfopen, xslen
c
 9110 format (' ?? input errors; Fgets stopped.')
 9120 format (' ?? no commands found; Fgets stopped.')
c
      haltsimul = .false.
      sumerr = 0
      xlast = .true.
      call setages(xlast)
c
      do jspecies = 1, gnspecies        ! cleanup Vv_pval arrays
         do jage = 1, xmaximum_age(jspecies)
            do jpar = 1, maxfpar
               if (vv_ptyp(jpar, jage, jspecies) .eq. tdatabase) then
                  vv_pval(jpar, jage, jspecies) = rnoval
               endif
            enddo
         enddo
      enddo
c
      if (xexams) then
         ptime = 1      ! time                        
         ptemp = 2      ! temperature                 
         ppss = 3       ! plankton_standing_stock     
         pcw = 4        ! cwater (1:Gnchem)           
         pcb = pcw + gnchem     ! cbenthos (1:Gnchem)         
         pcp = pcb + gnchem     ! cplankton (1:Gnchem)        
ccc         pcf   = pcf + Gnchem             ! cfish (1:Gnchem), not by exams
         ptotal = 3 * gnchem + 3        ! total number of entries     
      endif
c
 9130 format (' ','?? Fgets: cannot create "',a,'"')
 9140 format (' ','?? Fgets: fatal errors detected by "Chkinput"')
 9150 format (' ','?? Fgets: fatal errors detected by "Setfpar"')
c
      call chkinput(nerror)     ! check if everything is ok             
      if (nerror .ne. 0) then
         sumerr = sumerr + 1
         call opage(tinquire, ' ', 0, -1, xquery)
         write (stdout, 9140)
         write (jerr, 9140)
         go to 110
      endif
      call pgmunits(nerror)     ! initialize transform user input       
      if (nerror .ne. 0) then
         sumerr = sumerr + 1
         go to 110
      endif
c
      if (xtiming) then
         call uxtiming('database Access', 1)
      endif
c
      call setfpar(nerror)      ! parameterize fish if needed.          
      if (nerror .ne. 0) then
         sumerr = sumerr + 1
         go to 110
      endif
c
      if (xtiming) then
         call uxtiming('database Access', 2)
      endif
      if (nerror .ne. 0) then
         sumerr = sumerr + 1
         call opage(tinquire, ' ', 0, -1, xquery)
         write (stdout, 9150)
         write (jerr, 9150)
         go to 110
      endif
c
      if (xdata) then   ! open Xdata file if needed            
         if (zioerror .eq. xfopen(jts, tsfil, ziowrite)) then
            sumerr = sumerr + 1
            nts = xslen(tsfil)
            call opage(tinquire, ' ', 0, -1, xquery)
            write (stdout, 9130) tsfil(1:nts)
            write (jerr, 9130) tsfil(1:nts)
            go to 110
         endif
      endif
      call opage(teject, ' ', 0, 0, xquery)
      call kdriver()    ! begin simulation                      
c
  110 continue
      panic = (sumerr .ne. 0) .or. (haltsimul)
      no_errors = ( .not. panic)
      return
      end
      subroutine isaryset(jpos, arypar, arystat, unset_so_far)
c
c update: thu 15:46 5-mar-1992.
c
c returns: if .not. vdefined (arypar (jpos)) then
c          unset_so_far = unset_so_far + 1
c
c unset_so_far:
c . number of unset entries so far;
c . variable initialized by the calling module, updated by "Isaryset";
c . we have all required info if unset_so_far == 0;
c
c declaration of fortran parameters
c
      include 'noval.par'
      include 'setcodes.par'
c
      integer jpos, arystat( * ), unset_so_far
      real arypar( * )
c
      include 'vdefined.def'
      include 'vdefined.sfn'
c
      if (vdefined(arypar(jpos))) then
         arystat(jpos) = tset
      else
         arystat(jpos) = tunset
         unset_so_far = unset_so_far + 1
      endif
c
      return
      end
      logical functionisempty()
c
c update: 16:52 tue 5-apr-1994.
c Isempty  -  truth of token buffer empty
c;;
      include 'xglobal.par'
      include 'xio.inc'
      include 'xinclude.inc'
      include 'strings.par'
      include 'token.def'
c
      logical havestuff
      integer jj, nextnb
      external nextnb
c
      jj = nextnb(xinbuf, len_inbuf, pcur)
      if (jj .gt. len_inbuf) then
         havestuff = .false.
      elseif (xinbuf(jj:jj) .eq. eol) then
         havestuff = .false.
      elseif (xinbuf(jj:jj) .eq. eof) then
         havestuff = .false.
      else
         havestuff = .true.
      endif
c
      isempty = ( .not. havestuff)
c
      return
      end
      subroutine iset(cname, no_errors)
c
c update: fri 16:50 13-mar-1992.
c @@@@
c
c declaration of fortran parameters
c;;
      include 'Prompt.par'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      call prompt(prset1, cname)
      no_errors = (.false.)
      call prompt(prpop, ' ')
c
      return
      end
      logical function ishelp(xkey)
c
c update: tue 17:12 25-feb-1992.
c is "xkey" a valid abbreviation for help ?
c "help" | "?"
c
      character*( * ) xkey
      logical found
      integer nk
c
      character*4 wcmd
      data wcmd /'help'/
c
      nk = max(index(xkey, ' ') - 1, 1)
      if (nk .eq. 1) then
         found = (xkey(1:1) .eq. wcmd(1:1))
         if ( .not. found) found = (xkey(1:1) .eq. '?')
      elseif (nk .le. 4) then
         found = (xkey(1:nk) .eq. wcmd(1:nk))
      else
         found = .false.
      endif
      ishelp = (found)
c
      return
      end
      subroutine ishow(cname, noerrors)
c
c update: tue 16:09 8-mar-1994.
c show stuff
c
c declaration of fortran parameters
c
      include 'xglobal.par'
      include 'chem.par'
      include 'noval.par'
      include 'Prompt.par'
c
      include 'chars.def'
      include 'chemp.def'
      include 'echo.def'
      include 'globpar.def'
      include 'hits.def'
      include 'idfiles.def'
      include 'options.def'
      include 'page.def'
      include 'show.def'
      include 'stealth.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical noerrors
c
      character*(stdlen) q1tmp, q2tmp
      integer nq1, ncom, nptr, exitcode, xslen, jj, uu
      logical hhfound, isempty
      external xslen, isempty
c
      include 'chars.sfn'
c
 9110 format (1x,'-- Nothing to show: "',a,'"')
 9120 format (1x,'?? internal error; show "',a,
     &   '" requires a computed "goto" label at position ',i4)
 9130 format (1x,'?? show "',a,'" undefined.')
 9140 format (1x,'?? ambiguous item.')
 9150 format ('Show items:')
 9160 format (3x,4a)
c
      noerrors = .true.
      call prompt(prset1, cname)
      uu = stdout
c
c get the name of the item to show.
c
      if (isempty()) then
         q1tmp = 'help'
         nq1 = xslen(q1tmp)
      else
         call tok2dlim(' (', q1tmp)
         if ( .not. iseol(q1tmp(1:1))) then
            nq1 = xslen(q1tmp)
         else
            q1tmp = '*'
            nq1 = 1
         endif
      endif
c
c find item:
c 1. try "normal" form of item
c 2. not found? try hidden form of item : prepend "stealthc" and check.
c;;
      call srchlbw(q1tmp(1:nq1), showname, maxshow, xhits, nhits)
      if (nhits .le. 0) then
         call srchlbw(stealthc // q1tmp(1:nq1), showname, maxshow, 
     &      xhits, nhits)
      endif
c
      if (nhits .eq. 1) then
         ncom = xhits(nhits)
         q1tmp = showname(ncom)
         nq1 = xslen(q1tmp)
         nptr = showcode(ncom)
c
c "go to" como una fina cortesia de v3base:xgoto.f
c!xgoto:start
         go to (110, 120, 130, 140, 150, 160, 170, 180, 190, 200, 210, 
     &      220, 110, 230, 240, 250, 260, 270, 280, 290, 300, 310, 320,
     &      330, 280, 340, 280, 350, 360, 370, 340, 370, 370, 370, 370,
     &      370, 370), ncom
c!xgoto:end     ..
c
         write (stdout, 9120) q1tmp(1:nq1), ncom
      elseif (nhits .eq. 0) then
         write (stdout, 9130) q1tmp(1:nq1)
      else
         write (stdout, 9140)
      endif
      ncom = inoval
      call tokreset()
      go to 380
c
c ******************************************************************
c "help" "?"
c
  110 continue
      call gethelp('show', hhfound)
      write (q2tmp, 9150)
      call tee(q2tmp, -1)
      nhits = maxshow
      do jj = 1, maxshow
         xhits(jj) = jj
      enddo
      call ihelp0(uu, showname, maxshow, xhits, nhits)
      go to 380
c
c ******************************************************************
c audit
c
  120 continue
      if (xauditon) then
         nq1 = xslen(audfil)
         write (q2tmp, 9160) 'Audit is on, file = ', audfil(1:nq1)
      else
         if (xauditff) then
            nq1 = xslen(audfil)
            write (q2tmp, 9160) 'Audit is off, file = ', 
     &         audfil(1:nq1)
         else
            write (q2tmp, 9160) 'Audit is off'
         endif
      endif
      call tee(q2tmp, -1)
      go to 380
c
c ******************************************************************
c burden
c
  130 continue
      call sburden(uu)
      go to 380
c
c ******************************************************************
c cbenthos
c
  140 continue
      write (uu, 9110) q1tmp(1:nq1)
      go to 380
c
c ******************************************************************
c cfish
c
  150 continue
      write (uu, 9110) q1tmp(1:nq1)
      go to 380
c
c ******************************************************************
c chemicals
c
  160 continue
      call schem0(uu)
      go to 380
c
c ******************************************************************
c cplankton
c
  170 continue
      write (uu, 9110) q1tmp(1:nq1)
      go to 380
c
c ******************************************************************
c cwater
c
  180 continue
      write (uu, 9110) q1tmp(1:nq1)
      go to 380
c
c ******************************************************************
c diet
c
  190 continue
      write (uu, 9110) q1tmp(1:nq1)
      go to 380
c
c ******************************************************************
c echo
c
  200 continue
      if (xecho) then
         write (q2tmp, 9160) 'Echo is on'
      else
         write (q2tmp, 9160) 'Echo is off'
      endif
      call tee(q2tmp, -1)
      go to 380
c
c ******************************************************************
c exams
c
  210 continue
      write (uu, 9110) q1tmp(1:nq1)
      go to 380
c
c ******************************************************************
c exams_mode
c
  220 continue
      write (uu, 9110) q1tmp(1:nq1)
      go to 380
c
c ******************************************************************
c initial_cf
c
  230 continue
      write (uu, 9110) q1tmp(1:nq1)
      go to 380
c
c ******************************************************************
c initial_wt
c
  240 continue
      write (uu, 9110) q1tmp(1:nq1)
      go to 380
c
c ******************************************************************
c lc50
c
  250 continue
      write (uu, 9110) q1tmp(1:nq1)
      go to 380
c
c ******************************************************************
c nchemicals
c
  260 continue
      if (gnchem .ne. inoval) then
         call int2a(gnchem, q1tmp, nq1)
         write (q2tmp, 9160) 'Number of chemicals = ', q1tmp(1:nq1)
      else
         write (q2tmp, 9160) 'Number of chemicals = ', snoval
      endif
      call tee(q2tmp, -1)
      go to 380
c
c ******************************************************************
c nspecies
c
  270 continue
      if (gnspecies .ne. inoval) then
         call int2a(gnspecies, q1tmp, nq1)
         write (q2tmp, 9160) 'Number of species = ', q1tmp(1:nq1)
      else
         write (q2tmp, 9160) 'Number of species = ', snoval
      endif
      call tee(q2tmp, -1)
      go to 380
c
c ******************************************************************
c tstart
c tend
c nstep
c
  280 continue
      call stimes(uu)
      go to 380
c
c ******************************************************************
c observations
c
  290 continue
      write (uu, 9110) q1tmp(1:nq1)
      go to 380
c
c ******************************************************************
c output
c
  300 continue
      write (uu, 9110) q1tmp(1:nq1)
      go to 380
c
c ******************************************************************
c plankton_standing_stock
c
  310 continue
      write (uu, 9110) q1tmp(1:nq1)
      go to 380
c
c ******************************************************************
c species
c
  320 continue
      call sfish0(uu)
      go to 380
c
c ******************************************************************
c temperature
c
  330 continue
      call stemp(uu)
      go to 380
c
c ******************************************************************
c title
c ~header
c
  340 continue
      if (title_set) then
         write (q2tmp, 9160) 'Title: "', title_page(1:title_len), '"'
      else
         write (q2tmp, 9160) 'Title: ', snoval
      endif
      call tee(q2tmp, -1)
      go to 380
c
c ******************************************************************
c units
c
  350 continue
      call sunits(uu)
      go to 380
c
c ******************************************************************
c version
c
  360 continue
      call iversion(q1tmp(1:nq1), hhfound)
      go to 380
c
c ******************************************************************
c ~stealth
c ~holling
c ~totals
c ~last_year_only
c ~timing
c ~show
c ~fourier
c
  370 continue
      write (uu, 9110) q1tmp(1:nq1)
      go to 380
c
  380 continue
  390 continue
      call prompt(prpop, ' ')
      call tokreset()
c
      return
      end
      subroutine isimulp(cname, no_errors, nptr)
c
c update: 16:33 fri 4-mar-1994.
c time control: /tstart , /tend , /nstep
c / xxx real_number
c
c tstart: start of simulation
c tend:   end of simulation
c nstep:  number of steps per day
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'Prompt.par'
      include 'strings.par'
      include 'token.par'
      include 'heap.def'
      include 'idfiles.def'
      include 'time.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      integer nptr
      logical no_errors
c
      real rval
      integer xslen, ival, toktype, ptok
      external xslen
c
 9110 format (' ?? "/',a,'" : expecting a Real or integer number.')
c
      call prompt(prset1, cname)
      ptok = 0  ! assign heap storage
      call heapush(ptok)
c
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)
      no_errors = ((toktype .eq. treal) .or. (toktype .eq. tint))
      if (no_errors) then
         rtime(nptr) = rval
      else
         write (stdout, 9110) cname
         call tokreset()
      endif
      call heapop(ptok) ! release heap storage
      call prompt(prpop, ' ')
c
      return
      end
      logical function isinclud(card, ncard, f2name)
c
c update: 17:28 fri 4-mar-1994.
c determine if the card is an "#include" card; if it is, return the filename.
c;;
      include 'xglobal.par'
      include 'chars.def'
      include 'idfiles.def'
c
      integer len_include, im1
      parameter (len_include = 7)       ! 7 == Len ("include")
      parameter (im1 = len_include - 1)
      character*( * ) card, f2name
      integer ncard
c
      character*(len_include) q1tmp
      integer np1, np2, nextnb, xslen, matchqte
      logical inclcard
      external nextnb, xslen, matchqte
      include 'chars.sfn'
c
      np1 = nextnb(card, ncard, 1)
      inclcard = (card(np1:np1) .eq. '#')
      if (inclcard) then
         np1 = nextnb(card, ncard, np1 + 1)
         q1tmp = card(np1:np1 + im1)
         call up2lo(q1tmp, -1)
         inclcard = (q1tmp .eq. 'include')
         if (inclcard) then
            np2 = np1 + im1
            np1 = nextnb(card, ncard, np2 + 1)
            if (isquote(card(np1:np1))) then
               np2 = matchqte(card, np1)
               if (np2 .le. 0) np2 = ncard
               if (np2 .gt. 0) then
                  np1 = np1 + 1
                  np2 = np2 - 1
               endif
            else
               np2 = index(card(np1:), ' ')
               if (np2 .gt. 0) then
                  np2 = np2 + np1 - 1
               else
                  np2 = ncard
               endif
            endif
            if (np1 .le. np2) then
               f2name = card(np1:np2)
            else
               f2name = ' '
               inclcard = .false.
            endif
         endif
      endif
      isinclud = inclcard
c
      return
      end
      subroutine ispecies(cname, no_errors, nptr)
c
c update: 11:33 wed 17-aug-1994.
c
c species id: /species, /family, /ecology
c / xxx string
c
c "/species" is, effectively, the "begin" card for a new fish.
c no fishes may be defined after "/diet" ;
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'fish.par'
      include 'chem.par'
      include 'noval.par'
      include 'Prompt.par'
      include 'strings.par'
      include 'idfiles.def'
      include 'globpar.def'
      include 'fish.def'
      include 'heap.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      integer nptr
      logical no_errors
c
      logical xlast
      integer xslen, nss, ptok, nblank
      external xslen
c
 9110 format (' ?? "/',a,'" : not enough space to store all fishes.')
 9120 format (' ?? "/',a,'" : no argument provided.')
 9130 format (' ?? "/',a,'" : requires two words.')
 9140 format (' ?? "/',a,'" : no more fishes allowed after "/diet" .')
c
      call prompt(prset1, cname)
      no_errors = .true.
      if (nomore_fish) then
         no_errors = .false.
         write (stdout, 9140) cname
         call tokreset()
         go to 110
      endif
c
      ptok = 0
      call heapush(ptok)
      if (nptr .eq. 1) then
c
c load labels and species data for previous fish and update pointer
         xlast = .false.
         call setages(xlast)
c
c begin processing of current fish
         if (gnspecies .ne. inoval) then
            gnspecies = gnspecies + 1
         else
            gnspecies = 1
         endif
         xmaximum_age(gnspecies) = 1
         no_errors = (xmaximum_age(gnspecies) .le. maxage)
         if ( .not. no_errors) then
            write (stdout, 9110) cname
            call tokreset()
            gnspecies = maxspecies
            xmaximum_age(gnspecies) = 1
         endif
      endif
c
      call tok2dlim(eol, qhs(ptok))
      call ustripd(qhs(ptok), -1, qhs(ptok), nss)
      call up2lo(qhs(ptok), nss)
      no_errors = (nss .gt. 0)
      if (no_errors) then
         if (nptr .eq. 1) then
            nblank = index(qhs(ptok), ' ')
            no_errors = (nblank .lt. nss)       ! ==> there are two words
         endif
         if (no_errors) then
            fishlabs(gnspecies, nptr) = qhs(ptok)(1:nss)
         else
            write (stdout, 9130) cname
            call tokreset()
         endif
      else
         write (stdout, 9120) cname
         call tokreset()
      endif
c
  110 continue
      call heapop(ptok)
      call prompt(prpop, ' ')
      return
      end
      logical function isquit(xkey)
c
c update: 17:44 fri 4-mar-1994.
c is "xkey" a valid abbreviation for quit ?
c "quit" | ^z
c
      include 'xglobal.par'
c
      character*( * ) xkey
      logical found
      integer nk
c
      character*4 wcmd
      data wcmd /'quit'/
c
      nk = max(index(xkey, ' ') - 1, 1)
      if (nk .eq. 1) then
         found = (xkey(1:1) .eq. wcmd(1:1))
         if ( .not. found) found = (xkey(1:1) .eq. eof)
      elseif (nk .le. 4) then
         found = (xkey(1:nk) .eq. wcmd(1:nk))
      else
         found = .false.
      endif
      isquit = (found)
c
      return
      end
      subroutine istore(cname, no_errors)
c
c update: fri 16:51 13-mar-1992.
c @@@@
c
c declaration of fortran parameters
c;;
      include 'Prompt.par'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      call prompt(prset1, cname)
      no_errors = (.false.)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine itemp(cname, no_errors)
c
c update: 17:44 fri 4-mar-1994.
c
c /temperature      file         "file-spec"
c /temperature      constant     #1
c /temperature      Sin          #1 #2 #3 #4
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'expos.par'
      include 'habitat.par'
      include 'Prompt.par'
      include 'simul.par'
      include 'strings.par'
      include 'token.par'
c
      include 'habitat.def'
      include 'heap.def'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      real rval
      integer ival, toktype, xslen, nne, nss, ptok
      logical xxok
      external xslen
c
 9110 format (' ?? "/',a,'" : /temp and /cwater "file" option ',
     &   'should Access the same exposure file:',/,'    "',a,'" vs "',a,
     &   '"')
 9120 format (' ?? "/',a,'" : unrecognized option;',/,
     &   '    valid options are: "file", "Sin", or "constant".')
c
      call prompt(prset1, cname)
      ptok = 0  ! assign heap storage            
      call heapush(ptok)
c
      xxok = .true.
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)
      if (qhs(ptok) .eq. 'file') then
         twfunc = tfile
         call tok2dlim(eol, qhs(ptok))
         call ustripd(qhs(ptok), -1, qhs(ptok), nss)
         if (iread_cw .eq. tf1func) then
            xxok = (qhs(ptok) .eq. cwfil)
            if ( .not. xxok) then
               nss = xslen(qhs(ptok))
               nne = xslen(cwfil)
               write (stdout, 9110) cname, cwfil(1:nne), 
     &            qhs(ptok)(1:nss)
            endif
         endif
         cwfil = qhs(ptok)
         iread_cw = tf1func
c
      else
         xxok = ((qhs(ptok) .eq. 'constant') .or. (qhs(ptok) .eq. 'Sin')
     &      )
         if (xxok) then
            call tokpush()
            call ifargs(cname, twfunc, twpar, xxok)
         endif
      endif
c
      if ( .not. xxok) then
         write (stdout, 9120) cname
         call tokreset()
      endif
c
      call heapop(ptok) ! release heap storage                 
      no_errors = (xxok)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine ititle(cname, no_errors)
c
c update: 16:33 fri 4-mar-1994.
c get a page title
c
c /header   "a-string"
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'Prompt.par'
      include 'strings.par'
      include 'token.par'
      include 'heap.def'
      include 'idfiles.def'
      include 'page.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      real rval
      integer ival, toktype, ptok
      logical xxok
c
 9110 format (' ?? "/',a,'" : expecting a quoted string.')
c
      call prompt(prset1, cname)
      ptok = 0  ! assign heap storage            
      call heapush(ptok)
c
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)      ! tqstr  
      xxok = (toktype .eq. tqstr)
      title_set = (xxok)
      if (xxok) then
         call ustripd(qhs(ptok), -1, title_page, title_len)
         title_set = (title_len .gt. 0)
      else
         write (stdout, 9110) cname
         call tokreset()
      endif
c
      call heapop(ptok)
      no_errors = (xxok)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine itoxlab(cname, no_errors)
c
c update: 16:33 fri 4-mar-1994.
c
c chemicals-id:
c /Toxlab "string_1" "string_2" ... "string_gnchem"
c
c each string quoted;
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'Prompt.par'
      include 'strings.par'
      include 'token.par'
c
      include 'chemp.def'
      include 'chems.def'
      include 'globpar.def'
      include 'heap.def'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      real rval
      integer xslen, nss, ival, toktype, jchem, ptok
      logical xxok, done
      external xslen
c
 9110 format (' ?? "/',a,'" : string without quotes.')
c
      call prompt(prset1, cname)
      ptok = 0  ! assign heap storage            
      call heapush(ptok)
c
      jchem = 1
      xxok = .true.
  110 continue
      done = ((jchem .gt. gnchem) .or. ( .not. xxok))
      if ( .not. done) then
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)
         xxok = (toktype .eq. tqstr)
         if (xxok) then
            call ustripd(qhs(ptok), -1, toxlab(jchem), nss)
            jchem = jchem + 1
         else
            write (stdout, 9110) cname
            call tokreset()
         endif
         go to 110
      endif
c
      call heapop(ptok) ! release heap storage                 
      no_errors = (xxok)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine itrophic(cname, no_errors, xzz, zzfunc, zzfil, zzconc,
     &   zzpl, zzbmf)
c
c update: 17:44 fri 4-mar-1994.
c set concentration for all chemicals in base trophic level
c modes: tlaboratory, tfood_chain, tfood_web
c
c let "xxx" == ("cbenthos" | "cplankton" | "cfish")
c
c /xxx file          #file-spec
c /xxx constant      #conc_chem_1 #conc_chem_2 ... #conc_chem_nchen
c /xxx equilibrium   #pl #bmf_1 #bmf_2 ... #bmf_nchem
c
c for command "/cfish", option "file" is not legal;
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'noval.par'
      include 'Prompt.par'
      include 'simul.par'
      include 'strings.par'
      include 'token.par'
c
      include 'globpar.def'
      include 'heap.def'
      include 'idfiles.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname, zzfil
      integer zzfunc
      real zzconc( * ), zzpl, zzbmf( * )
      logical no_errors, xzz
c
      real rval
      integer ival, toktype, jchem, xslen, nne, nss, ptok
      logical xxok, done
      external xslen
c
 9110 format (' ?? "/',a,'" : /plankton_standing_stock and /',a,
     &   ' "file" option ','should Access the same exposure file:',/,
     &   '    "',a,'" vs "',a,'"')
 9120 format (' ?? "/',a,'" : "equilibrium" expects ',i3,' BMF''s.')
 9130 format (' ?? "/',a,'" : "equilibrium" expects "pl", followed by ',
     &   i3,' BMF''s.')
 9140 format (' ?? "/',a,'" : "constant" expects ',i3,
     &   ' chem concentrations in organism.')
 9150 format (' ?? "/',a,'" : unrecognized option;',/,'    valid options
     & are: "file", "equilibrium", and "constant".')
c
      call prompt(prset1, cname)
      ptok = 0  ! assign heap storage            
      call heapush(ptok)
c
      xxok = .true.
      zzfunc = inoval
c
      call toknext(ttoken, qhs(ptok), ival, rval, toktype)
      if (qhs(ptok) .eq. 'file') then
         zzfunc = tfile
         call tok2dlim(eol, qhs(ptok))
         call ustripd(qhs(ptok), -1, qhs(ptok), nss)
         call collapse(qhs(ptok), nss, nss)
         if (zzfil .eq. snoval) then
            zzfil = qhs(ptok)
         else
            xxok = (zzfil .eq. qhs(ptok))
            if ( .not. xxok) then
               nss = xslen(qhs(ptok))
               nne = xslen(zzfil)
               write (stdout, 9110) cname, cname, zzfil(1:nne), 
     &            qhs(ptok)(1:nss)
            endif
         endif
c
      elseif (qhs(ptok) .eq. 'equilibrium') then
         zzfunc = tequilibrium
         call toknext(ttoken, qhs(ptok), ival, rval, toktype)
         xxok = ((toktype .eq. treal) .or. (toktype .eq. tint))
         if (xxok) then
            zzpl = rval
            jchem = 1
  110       continue
            done = (jchem .gt. gnchem) .or. ( .not. xxok)
            if ( .not. done) then
               call toknext(ttoken, qhs(ptok), ival, rval, toktype)
               xxok = ((toktype .eq. treal) .or. (toktype .eq. tint))
               if (xxok) then
                  zzbmf(jchem) = rval
                  jchem = jchem + 1
               endif
               go to 110
            endif
            if ( .not. xxok) then
               call tokpush()
               write (stdout, 9120) cname, gnchem
               call tokreset()
            endif
         else
            call tokpush()
            write (stdout, 9130) cname, gnchem
            call tokreset()
         endif
c
      elseif (qhs(ptok) .eq. 'constant') then
         zzfunc = tconstant
         jchem = 1
  120    continue
         done = (jchem .gt. gnchem) .or. ( .not. xxok)
         if ( .not. done) then
            call toknext(ttoken, qhs(ptok), ival, rval, toktype)
            xxok = ((toktype .eq. treal) .or. (toktype .eq. tint))
            if (xxok) then
               zzconc(jchem) = rval
               jchem = jchem + 1
            endif
            go to 120
         endif
         if ( .not. xxok) then
            call tokpush()
            write (stdout, 9140) cname, gnchem
            call tokreset()
         endif
c
      else
         xxok = .false.
      endif
c
      if ( .not. xxok) then
         write (stdout, 9150) cname
         call tokreset()
      endif
c
      call heapop(ptok) ! release heap storage                 
      no_errors = (xxok)
      xzz = (xxok)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine iunits(cname, no_errors, nptr)
c
c update: 17:44 fri 4-mar-1994.
c
c unit names: /Wtunits, /Cfunits, /Cwunits, /Tunits
c / xxx units
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'Prompt.par'
      include 'idfiles.def'
      include 'units.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      integer nptr
      logical no_errors
c
      character*(stdlen) q1tmp
      integer xslen, nq1
      external xslen
c
 9110 format (' ?? "/',a,'" : no units provided.')
c
      call prompt(prset1, cname)
      call tok2dlim(eol, q1tmp)
      no_errors = (q1tmp(1:1) .ne. eol)
c
      if (no_errors) then
         nq1 = xslen(q1tmp)
         unitname(nptr) = q1tmp(1:nq1)
      else
         write (stdout, 9110) cname
         call tokreset()
      endif
      call prompt(prpop, ' ')
c
      return
      end
      subroutine iversion(cname, no_errors)
c
c update: 17:54 fri 4-mar-1994.
c display version info + other stuff
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'noval.par'
      include 'idfiles.def'
      include 'version.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      integer nn, xslen
      external xslen
c
 9110 format (1x,3x,a,': ',a)
c
      write (stdout, 9110) 'program', x_version_date(1:nversion)
c
ccc      nn = Xslen(Pgmfil)
ccc      if (nn .gt. 0) then
ccc         write (Stdout, 9110) 'Pgmfil', Pgmfil(1:nn)
ccc      else
ccc         write (Stdout, 9110) 'Pgmfil', snoval
ccc      endif
cccc
      nn = xslen(dbpath)
      if (nn .gt. 0) then
         write (stdout, 9110) 'Fgets files path', dbpath(1:nn)
      else
         write (stdout, 9110) 'Fgets files path', snoval
      endif
c
      nn = xslen(hlbfil)
      if (nn .gt. 0) then
         write (stdout, 9110) 'help file', hlbfil(1:nn)
      else
         write (stdout, 9110) 'help file', snoval
      endif
c
      nn = xslen(dbfil)
      if (nn .gt. 0) then
         write (stdout, 9110) 'database file', dbfil(1:nn)
      else
         write (stdout, 9110) 'database file', snoval
      endif
c
      nn = xslen(opath)
      if (nn .gt. 0) then
         write (stdout, 9110) 'output files path', opath(1:nn)
      else
         write (stdout, 9110) 'output files path', snoval
      endif
c
      nn = xslen(infil)
      if (nn .gt. 0) then
         write (stdout, 9110) 'input file', infil(1:nn)
      else
         write (stdout, 9110) 'input file', snoval
      endif
c
      nn = xslen(outfil)
      if (nn .gt. 0) then
         write (stdout, 9110) 'output file', outfil(1:nn)
      else
         write (stdout, 9110) 'output file', snoval
      endif
c
      nn = xslen(errfil)
      if (nn .gt. 0) then
         write (stdout, 9110) 'error file', errfil(1:nn)
      else
         write (stdout, 9110) 'error file', snoval
      endif
c
      nn = xslen(ucffil)
      if (nn .gt. 0) then
         write (stdout, 9110) 'updated command file', ucffil(1:nn)
      else
         write (stdout, 9110) 'updated command file', snoval
      endif
c
      nn = xslen(tsfil)
      if (nn .gt. 0) then
         write (stdout, 9110) 'time series file', tsfil(1:nn)
      else
         write (stdout, 9110) 'time series file', snoval
      endif
c
      nn = xslen(audfil)
      if (nn .gt. 0) then
         write (stdout, 9110) 'audit file', audfil(1:nn)
      else
         write (stdout, 9110) 'audit file', snoval
      endif
c
      nn = xslen(cwfil)
      if (nn .gt. 0) then
         write (stdout, 9110) 'cwater file', cwfil(1:nn)
      else
         write (stdout, 9110) 'cwater file', snoval
      endif
c
      nn = xslen(planktonfil)
      if (nn .gt. 0) then
         write (stdout, 9110) 'cplankton file', planktonfil(1:nn)
      else
         write (stdout, 9110) 'cplankton file', snoval
      endif
c
      nn = xslen(benthosfil)
      if (nn .gt. 0) then
         write (stdout, 9110) 'cbenthos file', benthosfil(1:nn)
      else
         write (stdout, 9110) 'cbenthos file', snoval
      endif
c
      nn = xslen(cfishfil)
      if (nn .gt. 0) then
         write (stdout, 9110) 'cfish file', cfishfil(1:nn)
      else
         write (stdout, 9110) 'cfish file', snoval
      endif
c
      no_errors = (.true.)
      return
      end
      subroutine iwtinit(cname, no_errors)
c
c update: 11:34 wed 17-aug-1994.
c /initial_wt  wt_year_class_1
c     -or-
c /initial_wt  wt_year_class_1 wt_year_class_2 ... wt_year_class_n
c
c initial weight of the first year class or of all year classes
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'fish.par'
      include 'chem.par'
      include 'plots.par'
      include 'phylum.par'
      include 'Prompt.par'
      include 'strings.par'
c
      include 'fish.def'
      include 'globpar.def'
      include 'heap.def'
      include 'idfiles.def'
      include 'work.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
c
      integer xslen, ptok, jage, npp, nvals, npos, nerror
      logical havefish
      external havefish, xslen
c
 9110 format (' ?? "/',a,'" : expecting one or ',i2,' value(s).')
 9120 format (' ?? "/',a,'" : requires "/species" first.')
c
      call prompt(prset1, cname)
      ptok = 0
      call heapush(ptok)
c
      if ( .not. havefish()) then
         no_errors = .false.
         write (stdout, 9120) cname
         call tokreset()
         go to 110
      endif
c
      call tok2dlim(eol, qhs(ptok))
      npp = xslen(qhs(ptok))
      call uvalues(qhs(ptok), npp, 1, wvector, nvals, npos, nerror)
c
      no_errors = .false.
      if (nerror .eq. 0) then
         if (nvals .eq. 1) then
            no_errors = .true.
            vv_iniwt(1, gnspecies) = wvector(1)
         elseif (nvals .eq. xmaximum_age(gnspecies)) then
            no_errors = .true.
            do jage = 1, xmaximum_age(gnspecies)
               vv_iniwt(jage, gnspecies) = wvector(jage)
            enddo
         else
            write (stdout, 9110) cname
            call tokreset()
         endif
      else
         write (stdout, 9110) cname
         call tokreset()
      endif
c
  110 continue
      call heapop(ptok)
      call prompt(prpop, ' ')
c
      return
      end
      subroutine izz(cname, no_errors, nptr)
c
c update: 17:54 fri 4-mar-1994.
c set research/stealth-type options
c
c options - see statements below
c
c declaration of fortran parameters
c
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'menu.par'
      include 'ode.par'
      include 'Prompt.par'
      include 'strings.par'
c
      include 'chars.def'
      include 'echo.def'
      include 'hits.def'
      include 'idfiles.def'
      include 'idsdb.def'
      include 'ode.def'
      include 'options.def'
      include 'stealth.def'
      include 'unitdb.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) cname
      logical no_errors
      integer nptr
c
      integer nopts
      parameter (nopts = 12)
c
      character*(stdlen) q1tmp, nameopts(nopts)
      character*(s40) helpopts(nopts)
      integer nq1, xslen, idd, exitcode, nch
      logical xfirst, isempty, srchex0, toshow
      external xslen, isempty, srchex0
c
      save helpopts, nameopts
c
      include 'chars.sfn'
      data xfirst /.true./
c
 9110 format (1x,'?? cannot happen, idd = ',i5)
 9120 format (1x,'current value of ',a,': "',a,'"')
 9130 format (1x,'?? extraneous characters after valid command ignored:'
     &   )
 9140 format (1x,'?? invalid option: "',a,'"')
 9150 format (1x,'testing "/zz/dummy"')
c
c i need to concatenate the action code to the help options array.
c however "data hhh(1) / tmnhelp // 'text' /" is not valid, therefore,
c initialize everything the first time we invoke.
c
      if (xfirst) then
         xfirst = .false.
         helpopts(1) = '~/zz/stealth'
         nameopts(1) = tmnreturn // 
     &      'e 2. stealth <on | off>         ! set stealth mode'
         helpopts(2) = '~/zz/holling'
         nameopts(2) = tmnreturn // 
     &      'h 3. holling <on | off>         ! holling growth'
         helpopts(3) = '~/zz/totals'
         nameopts(3) = tmnreturn // 
     &      'o 4. totals  <on | off>         ! constant exposure'
         helpopts(4) = '~/zz/last'
         nameopts(4) = tmnreturn // 
     &      'l 5. last_year_only <on | off>  ! constant exposure'
         helpopts(5) = '~/zz/timing'
         nameopts(5) = tmnreturn // 
     &      't 6. timing  <on | off>         ! record timing info'
         helpopts(6) = '~/zz/show'
         nameopts(6) = tmnreturn // 
     &      's 7. show                       ! show current values'
         helpopts(7) = '~/zz/fourier'
         nameopts(7) = tmnreturn // 
     &      'f 8. fourier <on | off>         ! temperature by fourier'
         helpopts(8) = '~/zz/update_daily'
         nameopts(8) = tmnreturn // 'u 9. update daily'
         helpopts(9) = '~/zz/integration'
         nameopts(9) = tmnreturn // 'i10. integration algorithm'
         helpopts(10) = '~/zz/dummy'
         nameopts(10) = tmnreturn // 'd11. dummy'
         helpopts(11) = '~//help'
         nameopts(11) = tmnhelp // 'h 1. ? | help'
         helpopts(12) = '~//quit'
         nameopts(12) = tmnquit // 'q 0. quit'
      endif
c
      toshow = (isempty())
      no_errors = (.true.)
      call prompt(prset0, '>>')
      idd = nptr
      if (idd .le. 0) then
c
         continue
         call mmgetopt(stdout, toshow, nameopts, helpopts, nopts, xhits,
     &      idd)
         toshow = .false.
         if (idd .eq. tquit) then
            go to 230
         elseif (idd .eq. thelp) then   ! should never happen      
            toshow = .true.
            go to 220
         endif
      endif
c
  110 continue
      go to (120, 130, 140, 150, 160, 170, 180, 190, 200, 210), idd
      write (stdout, 9110) idd
      call tokreset()
      go to 220
c
c stealth
c
  120 continue
      call mmgetsv(stdout, 'stealth', '~//onoff', exitcode, q1tmp, nq1)
      if (exitcode .eq. tquit) then
         continue
      elseif (q1tmp(1:2) .eq. 'on') then
         xstealth = .true.
      elseif (q1tmp(1:2) .eq. 'of') then
         xstealth = .false.
      else
         write (stdout, 9140) q1tmp(1:nq1)
         call tokreset()
      endif
      if (xecho) then
         if (xstealth) then
            write (stdout, 9120) 'stealth', 'on'
         else
            write (stdout, 9120) 'stealth', 'off'
         endif
      endif
      go to 220
c
c holling
c
  130 continue
      call mmgetsv(stdout, 'holling', '~//onoff', exitcode, q1tmp, nq1)
      if (exitcode .eq. tquit) then
         continue
      elseif (q1tmp(1:2) .eq. 'on') then
         xsteady_state_gut = .true.
      elseif (q1tmp(1:2) .eq. 'of') then
         xsteady_state_gut = .false.
      else
         write (stdout, 9140) q1tmp(1:nq1)
         call tokreset()
      endif
      if (xecho) then
         if (xsteady_state_gut) then
            write (stdout, 9120) 'holling', 'on'
         else
            write (stdout, 9120) 'holling', 'off'
         endif
      endif
      go to 220
c
c totals
c
  140 continue
      call mmgetsv(stdout, 'totals', '~//onoff', exitcode, q1tmp, nq1)
      if (exitcode .eq. tquit) then
         continue
      elseif (q1tmp(1:2) .eq. 'on') then
         xtotals = .true.
      elseif (q1tmp(1:2) .eq. 'of') then
         xtotals = .false.
      else
         write (stdout, 9140) q1tmp(1:nq1)
         call tokreset()
      endif
      if (xecho) then
         if (xtotals) then
            write (stdout, 9120) 'totals', 'on'
         else
            write (stdout, 9120) 'totals', 'off'
         endif
      endif
      go to 220
c
c last_year_only
c
  150 continue
      call mmgetsv(stdout, 'lastyear', '~//onoff', exitcode, q1tmp, nq1)
      if (exitcode .eq. tquit) then
         continue
      elseif (q1tmp(1:2) .eq. 'on') then
         xlast_year_only = .true.
      elseif (q1tmp(1:2) .eq. 'of') then
         xlast_year_only = .false.
      else
         write (stdout, 9140) q1tmp(1:nq1)
         call tokreset()
      endif
      if (xecho) then
         if (xlast_year_only) then
            write (stdout, 9120) 'lastyear', 'on'
         else
            write (stdout, 9120) 'lastyear', 'off'
         endif
      endif
      go to 220
c
c timing
c
  160 continue
      call mmgetsv(stdout, 'timing', '~//onoff', exitcode, q1tmp, nq1)
      if (exitcode .eq. tquit) then
         continue
      elseif (q1tmp(1:2) .eq. 'on') then
         xtiming = .true.
      elseif (q1tmp(1:2) .eq. 'of') then
         xtiming = .false.
      else
         write (stdout, 9140) q1tmp(1:nq1)
         call tokreset()
      endif
      if (xecho) then
         if (xtiming) then
            write (stdout, 9120) 'timing', 'on'
         else
            write (stdout, 9120) 'timing', 'off'
         endif
      endif
      go to 220
c
c show
c
  170 continue
      if (xstealth) then
         write (stdout, 9120) ' stealth', 'on'
      else
         write (stdout, 9120) ' stealth', 'off'
      endif
      if (xfourier) then
         write (stdout, 9120) ' fourier', 'on'
      else
         write (stdout, 9120) ' fourier', 'off'
      endif
      if (xtiming) then
         write (stdout, 9120) '  timing', 'on'
      else
         write (stdout, 9120) '  timing', 'off'
      endif
      if (xtotals) then
         write (stdout, 9120) '  totals', 'on'
      else
         write (stdout, 9120) '  totals', 'off'
      endif
      if (xlast_year_only) then
         write (stdout, 9120) 'lastyear', 'on'
      else
         write (stdout, 9120) 'lastyear', 'off'
      endif
      if (xsteady_state_gut) then
         write (stdout, 9120) ' holling', 'on'
      else
         write (stdout, 9120) ' holling', 'off'
      endif
      if (xupdate_continuously) then
         write (stdout, 9120) 'update daily', 'off'
      else
         write (stdout, 9120) 'update daily', 'on'
      endif
      call idquad(kmethod, q1tmp, nq1)
      write (stdout, 9120) 'integration algorithm', q1tmp(1:nq1)
      go to 220
c
c fourier
c
  180 continue
      call mmgetsv(stdout, 'fourier', '~//onoff', exitcode, q1tmp, nq1)
      if (exitcode .eq. tquit) then
         continue
      elseif (q1tmp(1:2) .eq. 'on') then
         xfourier = .true.
      elseif (q1tmp(1:2) .eq. 'of') then
         xfourier = .false.
      else
         write (stdout, 9140) q1tmp(1:nq1)
         call tokreset()
      endif
      if (xecho) then
         if (xfourier) then
            write (stdout, 9120) 'fourier', 'on'
         else
            write (stdout, 9120) 'fourier', 'off'
         endif
      endif
      go to 220
c
c update daily
c
  190 continue
      call mmgetsv(stdout, 'update daily', '~//onoff', exitcode, q1tmp,
     &   nq1)
      if (exitcode .eq. tquit) then
         continue
      elseif (q1tmp(1:2) .eq. 'on') then
         xupdate_continuously = .false.
      elseif (q1tmp(1:2) .eq. 'of') then
         xupdate_continuously = .true.
      else
         write (stdout, 9140) q1tmp(1:nq1)
         call tokreset()
      endif
      if (xecho) then
         if (xupdate_continuously) then
            write (stdout, 9120) 'update daily', 'off'
         else
            write (stdout, 9120) 'update daily', 'on'
         endif
      endif
      go to 220
c
c integration algorithm
c . Euler
c . Adams
c . Gear
c . Bulirsch-Stoer
c . Adaptive
c
  200 continue
      call mmgetsv(stdout, 'integration', '~/zz/integration', exitcode,
     &   q1tmp, nq1)
      if (exitcode .eq. tquit) then
         continue
      elseif (srchex0('euler', q1tmp(1:nq1), exitcode, nch)) then
         kmethod = teuler
      elseif (srchex0('adams', q1tmp(1:nq1), exitcode, nch)) then
         kmethod = tadams
      elseif (srchex0('gear', q1tmp(1:nq1), exitcode, nch)) then
         kmethod = tgear
      elseif (srchex0('bulirsch', q1tmp(1:nq1), exitcode, nch)) then
         kmethod = tbulirsch
      elseif (srchex0('adaptive', q1tmp(1:nq1), exitcode, nch)) then
         kmethod = tadaptive
      else
         write (stdout, 9140) q1tmp(1:nq1)
         call tokreset()
      endif
      if (xecho) then
         call idquad(kmethod, q1tmp, nq1)
         write (stdout, 9120) 'integration algorithm', q1tmp(1:nq1)
      endif
      go to 220
c
  210 continue
      write (stdout, 9150)
      go to 220
c
c the buffer should be empty at this time
c
  220 continue
      if ( .not. isempty()) then
         write (stdout, 9130)
      endif
      call tokreset()
cccc
cccc [lsr] 12:59 thu 20-jan-1994.
cccc - i think that the next line should be eliminated;
cccc
ccc      if (Nptr .le. 0) go to 110
c
  230 continue
      call prompt(prpop, ' ')
      call tokreset()
c
      return
      end
      subroutine kdbdtgf(nchem, sgill, kw, cw, kf, pa, koc, cp, ingest,
     &   egest, wt, bfj, dbfj, jgilup, jgilex, jgutup, jgutex)
c
c update: mon 16:25 10-feb-1992.
c
c this subroutine formulates the differential equations that describes
c the whole body burden of a chemical in fish due to gill and
c food chain exposure. gill exchange is modeled as kinetic diffusive
c transport while food exchange is modeled by thermodynamic partitioning, i.e.,
c
c   dBf
c   --- = Sw*Kw * (Cw - Ca) + (Cprey * ingest - Cfeces * egest)
c   dt
c
c input arguments:
c        nchem, sgill, kw, cw, kf
c        pa, Koc
c        cp, ingest, egest, wt, bfj
c
c output arguments:
c        dbfj, jgilup, jgilex, jgutup, jgutex
c
c declaration for arguments
c
      include 'numbers.par'
c
      integer nchem
      real sgill, kw( * ), cw( * ), kf( * )
      real cp( * ), ingest, egest
      real pa, koc( * ), wt, bfj( * ), dbfj( * )
      real jgilup( * ), jgilex( * ), jgutup( * ), jgutex( * )
c
c declarations for derivative formulation
c
      integer jchem
      real pic, pia, ca, cf
      real kfeces, cfeces
c
c assume
c 1. moisture content of feces(intestinal contents) equal moisture content
c    of the fish, i.e., pia=pa.
c 2. dry feces (intestinal contents) are 75% ash (du preez and cockroft
c    1988. comp.biochem.physiol. 90a:63-70 and 71-77) further assume
c    the organic dry feces are 50% carbon.
c 3. kfeces = Koc = 0.4*Kow if there is no kinetic limitation
c 4. kfeces = Koc = 10.*Kow**0.5 if there is kinetic limitation
c
c the computation for pia and pic should be the same in "Kdbdtgf" and "Labode"
c see notes in "Kdbdtgf" ;
c
c changes in "kfeces" should be propagated to "Kdbdtgf", "Ksave1"
c                                             "Ow2", "Labode"
c
      pia = pa
      pic = (one - pia) * 0.125
c
      do jchem = 1, nchem
         cf = bfj(jchem) / wt
         ca = cf / kf(jchem)
         jgilup(jchem) = sgill * kw(jchem) * cw(jchem)
         jgilex(jchem) = sgill * kw(jchem) * ca
c
         kfeces = koc(jchem)
         cfeces = pic * kfeces * ca
         jgutex(jchem) = cfeces * egest
         jgutup(jchem) = cp(jchem) * ingest - jgutex(jchem)
         dbfj(jchem) = jgilup(jchem) - jgilex(jchem) + jgutup(jchem)
      enddo
c
      return
      end
      subroutine kdriver()
c
c update: 17:28 fri 4-mar-1994.
c drive Fgets kernels;
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'numbers.par'
      include 'simul.par'
      include 'idfiles.def'
      include 'globpar.def'
      include 'chemp.def'
      include 'odevar.def'
      include 'time.def'
      include 'lab.def'
      include 'options.def'
c
      integer nerror
      logical xxok
c
      hstep = one / tnstep      ! simulation step                
      nyears = 0        ! used only if tfood_web         
c
c initialize exposure conditions
c
      write (stdout, *)
      call envinit(xxok)
      call envget(simul_beg)
c
c ******************* initialize physico-chemical parameters ************
c
      call chemprop(gnchem, clogp, logp, kow, kl, koc, acw)
c
      if (simul_mode .eq. tlaboratory) then
         if (xtiming) then
            call uxtiming('tlaboratory', 1)
         endif
         call labdrv(nerror)
         if (xtiming) then
            call uxtiming('tlaboratory', 2)
         endif
      elseif (simul_mode .eq. tfood_chain) then
         if (xtiming) then
            call uxtiming('tfood_chain', 1)
         endif
         call chaindrv(nerror)
         if (xtiming) then
            call uxtiming('tfood_chain', 2)
         endif
      elseif (simul_mode .eq. tfood_web) then
         if (xtiming) then
            call uxtiming('tfood_web', 1)
         endif
         call webdrv(nerror)
         if (xtiming) then
            call uxtiming('tfood_web', 2)
         endif
      endif
c
      return
      end
      subroutine kdwdt(xtime, growth_model, fun_resp, gamma, phi, gmax,
     &   alpha1, alpha2, epsl1, epsl2, mu, sigma, nh3n, cn, assxeff, xw,
     &   xdwdt, ingest, assim, egest, respir, sda, excret)
c
c update: tue 16:03 13-aug-1991.
c
c this subroutine formulates the differential equations required to
c model fish's growth, i.e.,
c
c w(1):   body weight of fish [g live];
c w(2):   food_in_gut; mass of food in gut [g];
c
c dw(1)   dwt
c ----- = --- =  assim - sda - respir - excret
c dt      dt
c
c dw(2)   dg
c ----- = --  =  ingest - assim - egest
c dt      dt
c
c  where:
c
c  process                                model
c  -------                                -----
c
c           +-- phi * (gmax - g)          holling
c           |
c  ingest = |
c           |
c           +-- phi * wt                  allometric, linear, clearance
c
c
c           +-- alpha1 * g ** alpha2      holling
c           |
c  assim  = |
c           |
c           +-- assxeff * ingest          allometric, linear, clearance
c
c           +-- epsl1 * g ** epsl2        holling
c           |
c  egest  = |
c           |
c           +-- (1-assxeff) * ingest      allometric, linear, clearance
c
c  sda    = Sigma * ingest
c
c  respir = mu * wt
c
c  excret = Nh3n * (respir) / c:n
c
c
c input arguments:
c        growth_model, fun_resp, gamma, phi, gmax, alpha1, alpha2, epsl1, epsl2
c        mu, Sigma, Nh3n, Cn, assxeff, xw
c
c output arguments:
c        xdwdt, ingest, assim, egest, respir, sda, excret
c
      include 'chem.par'
      include 'numbers.par'
      include 'simul.par'
      include 'options.def'     ! required for steady_state option  
c
c declaration for arguments
c
      integer growth_model
      real xtime, fun_resp, gamma, phi, gmax, alpha1, alpha2
      real epsl1, epsl2, mu, sigma, nh3n, cn, assxeff
      real xw( * ), xdwdt( * )
      real ingest, assim, egest, respir, sda, excret
c
c local variables
c
      real wt, food_in_gut, hunger, max_evac
      real ssgutdrv, new_food_in_gut
      external ssgutdrv
c
      wt = xw(1)
      food_in_gut = xw(2)
c
      if (growth_model .eq. tlinear) then
         ingest = phi * wt
         assim = alpha1 * ingest
         egest = epsl1 * ingest
      elseif ((growth_model .eq. tallometric) .or. (growth_model .eq. 
     &   tclearance)) then
         ingest = fun_resp * phi * wt
         assim = alpha1 * ingest
         egest = epsl1 * ingest
      elseif (growth_model .eq. tholling) then
         if (xsteady_state_gut) then
            new_food_in_gut = ssgutdrv(fun_resp, phi, gmax, alpha1, 
     &         alpha2, epsl1, epsl2)
            food_in_gut = new_food_in_gut
         endif
         hunger = max(zero, (gmax - food_in_gut))
         ingest = fun_resp * phi * hunger
         assim = alpha1 * food_in_gut ** alpha2
         egest = epsl1 * food_in_gut ** epsl2
         max_evac = min(food_in_gut, egest + assim)
         egest = (one - assxeff) * max_evac
         assim = assxeff * max_evac
      endif
c
      respir = mu * wt
      sda = sigma * ingest
      excret = nh3n / cn * respir
c
c ---------------------------------------------------------------
c all models require gmax for initial conditions of the dwdt ode;
c however, only "holling" requires a correct value;
c see Kphysio, Kdwdt;
c ---------------------------------------------------------------
c
c regarding xw(2), xdwdt(2) -- food_in_gut; mass of food in gut [g];
c     if holling : kludge --
c        if "Xsteady_state_gut", we have computed the value that food_in_gut
c        should have; assign zero to the derivative; assign the computed
c        "food_in_gut" to the array.  this works because the integration
c        algorithm is euler.
c     if .not. holling --
c        set derivative to zero.
c
      if (growth_model .ne. tholling) then
         xdwdt(1) = assim - sda - respir - excret
         xdwdt(2) = zero
ccc         xdwdt(2) = ingest - assim - egest
      else
         xdwdt(1) = assim - sda - respir - excret
         if (xsteady_state_gut) then
            xw(2) = new_food_in_gut
            xdwdt(2) = zero
         else
            xdwdt(2) = ingest - assim - egest
         endif
      endif
      gamma = xdwdt(1) / wt
c
      return
      end
      subroutine kerrmsg(nerror)
c
c update: 17:28 fri 4-mar-1994.
c print error messages;
c;;
      include 'xglobal.par'
      include 'errors.par'
      include 'idfiles.def'
c
      integer nerror
c
      if (nerror .eq. tnoerror) then
         continue
      elseif (nerror .eq. terr_species_extinct) then
         write (stdout, *) '?? species extinct.'
      elseif (nerror .eq. terr_predator_starves) then
         write (stdout, *) '?? nothing to eat.'
      elseif (nerror .eq. terr_no_space) then
         write (stdout, *) '?? insufficient work space.'
      else
         write (stdout, *) '?? unknown error ', nerror
      endif
c
      return
      end
      subroutine kfupdate(kage, kspecies, xwt, xcelsius, 
     &   conc_plankton_in_water)
c
c update: 17:28 fri 4-mar-1994.
c update morphological/physiological parameters
c
c input:
c     kage, kspecies    - fish id
c     xwt               - weight of fish
c     Xcelsius          - environmental temperature
c     conc_plankton_in_water - plankton standing stock
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'noval.par'
      include 'numbers.par'
      include 'physio.par'
      include 'simul.par'
      include 'fish.def'
      include 'globpar.def'
      include 'chemp.def'
      include 'odevar.def'
c
      integer kage, kspecies
      real xwt, xcelsius
c
      integer jchem, agep
      real xpa, xpl, xpoc, ph, conc_plankton_in_water, plfun, pafun
      external plfun, pafun
c
      include 'pspoc.def'
      include 'pspoc.sfn'
c
c calculate the fish's physiological rates and dynamic kf
c
      agep = qq_fish_age(kage, kspecies)
      call kphysio(xcelsius, xwt, vv_growth_model(agep, kspecies), 
     &   conc_plankton_in_water, vv_pval(1, agep, kspecies), 
     &   qq_wgamma(kage, kspecies), qq_phi(kage, kspecies), 
     &   qq_gmax(kage, kspecies), qq_alpha1(kage, kspecies), 
     &   qq_alpha2(kage, kspecies), qq_epsl1(kage, kspecies), 
     &   qq_epsl2(kage, kspecies), qq_mu(kage, kspecies), sigma, nh3n, 
     &   cn)
c
      xpl = plfun(xwt, vv_plfunc(agep, kspecies), 
     &   vv_pval(vpl1, agep, kspecies))
      xpa = pafun(xpl, vv_pval(vpa1, agep, kspecies))
      xpoc = pocfun(xpl, xpa)
      if (vv_plfunc(agep, kspecies) .ne. tconstant) then
         do jchem = 1, gnchem
            qq_kf(jchem, kage, kspecies) = xpa + xpl * kl(jchem) + xpoc
     &         * koc(jchem)
         enddo
      endif
      qq_pa(kage, kspecies) = xpa
c
c calculate conductances for exchange across gills, morphological
c gill areas, and effective gill areas
c
      ph = rnoval
      call gill_sk(xcelsius, ph, gnchem, molvol, pka, xwt, 
     &   vv_pval(1, agep, kspecies), qq_sgill(kage, kspecies), 
     &   qq_kw(1, kage, kspecies))
      qq_sgill(kage, kspecies) = activegill(kspecies) * 
     &   qq_sgill(kage, kspecies)
c
      return
      end
      subroutine kphysio(celsius, wt, growth_model, 
     &   conc_plankton_in_water, fishpar, gamma, phi, gmax, alpha1, 
     &   alpha2, epsl1, epsl2, mu, sigma, nh3n, cn)
c
c update: wed 10:06 17-jul-1991.
c
c this subroutine calculates daily feeding and metabolic rates for
c the models,
c
c  dwt
c  --- =  assim - sda - respir - excret
c  dt
c
c  dg
c  --  =  ingest - assim - egest
c  dt
c
c  where:
c
c  process                                model
c  -------                                -----
c
c           +-- phi * (gmax - g)          holling
c           |
c  ingest = |
c           |
c           +-- phi * wt                  allometric, linear, clearance
c
c
c           +-- alpha1 * g ** alpha2      holling
c           |
c  assim  = |
c           |
c           +-- assxeff * ingest          allometric, linear, clearance
c
c           +-- epsl1 * g ** epsl2        holling
c           |
c  egest  = |
c           |
c           +-- (1-assxeff) * ingest      allometric, linear, clearance
c
c
c  sda    = Sigma * ingest
c
c  respir = mu * wt
c
c  excret = Nh3n * (respir) / c:n
c
c
c export
c     gamma, phi, gmax, alpha1, alpha2, epsl1, epsl2, mu
c
c import
c     celsius, wt, growth_model, fishpar, Sigma, Nh3n, Cn
c     conc_plankton_in_water
c
c declarations of subroutine's formal parameters
c;;
      include 'numbers.par'
      include 'simul.par'
      include 'noval.par'
      include 'physio.par'
c
      real celsius, wt, fishpar( * )
      real gamma, phi, gmax, alpha1, alpha2, epsl1, epsl2
      real mu, sigma, nh3n, cn, conc_plankton_in_water
      integer growth_model
c
c local variables
c
      real exx, fsat, tsat, rate, routine, stdo2
      external exx
c
c ---------------------------------------------------------------
c all models require gmax for initial conditions of the dwdt ode;
c however, only "holling" requires a correct value;
c see Kphysio, Kdwdt;
c ---------------------------------------------------------------
c
      gamma = rnoval
      phi = rnoval
      gmax = zero
      alpha1 = rnoval
      alpha2 = rnoval
      epsl1 = rnoval
      epsl2 = rnoval
      mu = rnoval
c
c ---------------------------------------------------------------
      if (growth_model .eq. tallometric) then
         phi = fishpar(vcmax1) * wt ** (fishpar(vcmax2) - one) * 
     &      exx(fishpar(vcmaxq10) * (celsius - fishpar(vcmaxt)))
c
c ---------------------------------------------------------------
      elseif (growth_model .eq. tclearance) then
c
c plankton drift feeder:
c phi = conc_plankton_in_water [grams/litre] *
c       clearance_volume (cvol) [litre/day]
c
         phi = conc_plankton_in_water * fishpar(vcvol1) * wt ** (
     &      fishpar(vcvol2) - one) * 
     &      exx(fishpar(vcvolq10) * (celsius - fishpar(vcvolt)))
c
c ---------------------------------------------------------------
      elseif (growth_model .eq. tholling) then
c
c let f(t) = food consumed during (0,t), i.e., g/t
c          = integral [phi * (gmax - g(tau)) dtau, (0,t)].
c
c if the fish eats to satiation from an empty gut then
c
c     f(t) = integral [phi * (gmax - f(tau)) dtau, (0,t)]
c
c     df(t)
c     ----- =  phi * (gmax - f(t))
c     dt
c
c     ln(gmax - f(t)) = - phi * t + ln(gmax).
c
c     phi = - ln(1-f(t)/gmax) / t
c
c
c assuming that a fish stops feeding when f(t) = 0.95 gmax, then
c if tsat and fsat denote the fish's time to satiation and the size
c of its satiating meal,
c
c     phi = - ln(1- 0.95) / tsat
c
         fsat = fishpar(vfsat1) * wt ** fishpar(vfsat2) * 
     &      exx(fishpar(vfsatq10) * (celsius - fishpar(vfsatt)))
         gmax = fsat / 0.95
c
c convert tsat from minutes to days
c
         tsat = fishpar(vtsat1) * wt ** fishpar(vtsat2) * 
     &      exx(fishpar(vtsatq10) * (celsius - fishpar(vtsatt)))
         tsat = tsat / (60.0 * 24.0)
         phi = -log(0.05) / tsat
      endif
c
c ---------------------------------------------------------------
c ---------------------------------------------------------------
c calculate parameters associated with gastro-intestinal evacuation.
c
      if ((growth_model .eq. tallometric) .or. (growth_model .eq. 
     &   tlinear) .or. (growth_model .eq. tclearance)) then
         alpha1 = fishpar(vassxeff)
         alpha2 = rnoval
         epsl1 = one - alpha1
         epsl2 = rnoval
      elseif (growth_model .eq. tholling) then
         rate = fishpar(vevac1) * wt ** fishpar(vevac2) * 
     &      exx(fishpar(vevacq10) * (celsius - fishpar(vevact)))
         alpha1 = fishpar(vassxeff) * rate
         alpha2 = fishpar(vevac3)
         epsl1 = (one - fishpar(vassxeff)) * rate
         epsl2 = fishpar(vevac3)
      endif
c
c calculated respiratory rate, mu [g/g/d].
c assume that field o2 consumption is twice standard laboratory
c o2 consumption; convert mg o2/g/hr to grams carbon/g/d
c
      routine = 2.0
      stdo2 = fishpar(vox1) * wt ** (fishpar(vox2) - one) * 
     &   exx(fishpar(voxq10) * (celsius - fishpar(voxt)))
      mu = 0.009 * fishpar(vrq) * routine * stdo2
c
      if (growth_model .eq. tlinear) then
         gamma = fishpar(vgamma1) * wt ** fishpar(vgamma2) * 
     &      exx(fishpar(vgammaq10) * (celsius - fishpar(vgammat)))
         phi = (gamma + (one + nh3n / cn) * mu) / (alpha1 - sigma)
      endif
c
      return
      end
      subroutine ksave(kage, kspecies, tdelta, ytoday, to_save)
c
c update: 11:45 fri 9-sep-1994.
c save and/or store updated variables.
c
c to_save:  .true.   ==> save this point, PERIOD;
c           .false.  ==> save this point according to Qq_iprint;
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'numbers.par'
      include 'physio.par'
      include 'fish.def'
      include 'globpar.def'
      include 'chemp.def'
      include 'odevar.def'
      include 'fluxes.def'
      include 'lab.def'
c
      integer kage, kspecies
      real tdelta, ytoday
      logical to_save
c
      integer jchem, agep
      real actvty, afish, lf, ff
      logical treq, important_event
      external afish, treq
c
c if the fish is dead, exit (stage trapdoor);
c
      if (qq_fish_alive(kage, kspecies)) then
         qq_iterno(kage, kspecies) = qq_iterno(kage, kspecies) + 1
         agep = qq_fish_age(kage, kspecies)
c
c if the integration method is changed, then all these variables must
c be integrated using the new method.  euler is used at this time;
c
         dtfish(kage, kspecies) = dtfish(kage, kspecies) + tdelta
         qq_igamma(kage, kspecies) = qq_igamma(kage, kspecies) + tdelta
     &      * qq_wgamma(kage, kspecies)
         qq_iingest(kage, kspecies) = qq_iingest(kage, kspecies) + 
     &      tdelta * qq_wingest(kage, kspecies)
         qq_iassim(kage, kspecies) = qq_iassim(kage, kspecies) + tdelta
     &      * qq_wassim(kage, kspecies)
         qq_iegest(kage, kspecies) = qq_iegest(kage, kspecies) + tdelta
     &      * qq_wegest(kage, kspecies)
         qq_iexcret(kage, kspecies) = qq_iexcret(kage, kspecies) + 
     &      tdelta * qq_wexcret(kage, kspecies)
         qq_irespir(kage, kspecies) = qq_irespir(kage, kspecies) + 
     &      tdelta * qq_wrespir(kage, kspecies)
         qq_isda(kage, kspecies) = qq_isda(kage, kspecies) + tdelta * 
     &      qq_wsda(kage, kspecies)
c
         ff = qq_wt(1, kage, kspecies)
         do jchem = 1, gnchem
            if (ff .gt. zero) then
               qq_cfj(jchem, kage, kspecies) = 
     &            qq_bf(jchem, kage, kspecies) / ff
            else
               qq_cfj(jchem, kage, kspecies) = zero
            endif
            max_cf(jchem, kage, kspecies) = max(
     &         max_cf(jchem, kage, kspecies), 
     &         qq_cfj(jchem, kage, kspecies))
            max_kf(jchem, kage, kspecies) = max(
     &         max_kf(jchem, kage, kspecies), 
     &         qq_kf(jchem, kage, kspecies))
            qq_jgilup(jchem, kage, kspecies) = 
     &         qq_jgilup(jchem, kage, kspecies) + tdelta * 
     &         qq_tjgilup(jchem, kage, kspecies)
            qq_jgilex(jchem, kage, kspecies) = 
     &         qq_jgilex(jchem, kage, kspecies) + tdelta * 
     &         qq_tjgilex(jchem, kage, kspecies)
            qq_jgutup(jchem, kage, kspecies) = 
     &         qq_jgutup(jchem, kage, kspecies) + tdelta * 
     &         qq_tjgutup(jchem, kage, kspecies)
            qq_jgutex(jchem, kage, kspecies) = 
     &         qq_jgutex(jchem, kage, kspecies) + tdelta * 
     &         qq_tjgutex(jchem, kage, kspecies)
            cfmean(jchem, kage, kspecies) = 
     &         cfmean(jchem, kage, kspecies) + tdelta * 
     &         qq_cfj(jchem, kage, kspecies)
            cpmean(jchem, kage, kspecies) = 
     &         cpmean(jchem, kage, kspecies) + tdelta * 
     &         qq_cp(jchem, kage, kspecies)
         enddo
c
         lf = (qq_wt(1, kage, kspecies) / 
     &      vv_pval(vlenwt1, agep, kspecies)) ** (one / 
     &      vv_pval(vlenwt2, agep, kspecies))
         qq_lenfish(kage, kspecies) = 
     &      max(lf, qq_lenfish(kage, kspecies))
c
         actvty = afish(gnchem, qq_cfj(1, kage, kspecies), molwt, 
     &      qq_kf(1, kage, kspecies), acw)
         qq_max_activity(kage, kspecies) = 
     &      max(qq_max_activity(kage, kspecies), actvty)
c
         if (actvty .lt. fish_la50(kspecies)) then
            important_event = (to_save) .or. (treq(ytoday, time_beg)) 
     &         .or. (treq(ytoday, time_end))
            call ksave0(kage, kspecies, ytoday, actvty, important_event)
c
         else
            important_event = .true.
            call ksave0(kage, kspecies, ytoday, actvty, important_event)
            qq_death_day(kage, kspecies) = ytoday
            qq_fish_alive(kage, kspecies) = .false.
         endif
      endif
c
  110 continue
      return
      end
      subroutine ksave0(kage, kspecies, ytoday, actv, important_event)
c
c update: tue 13:11 13-aug-1991.
c store plotting vars
c
c important_event:
c true:    save this point regardless of Qq_iprint;
c          this may happen when:
c          . ytoday == Time_beg or Time_end
c          . fish died
c          . some other important event in the life of the fish;
c false:   save according to Qq_iprint;
c
c declaration of fortran parameters
c;;
      include 'chem.par'
      include 'fish.par'
      include 'plots.par'
      include 'phylum.par'
      include 'odevar.def'
      include 'fluxes.def'
      include 'globpar.def'
      include 'work.def'
c
      integer kage, kspecies, jchem, npos
      real ytoday, actv
      logical important_event
c
c ******************* save desired output variables *********************
c
      if (important_event) then
         continue
      elseif (mod(qq_iterno(kage, kspecies) - 1, 
     &   qq_iprint(kage, kspecies)) .ne. 0) then
         go to 110
      endif
c
      qq_nxy(kage, kspecies) = 
     &   min(1 + qq_nxy(kage, kspecies), maxpoints)
      npos = qq_nxy(kage, kspecies)
c
      qq_tcal(npos, kage, kspecies) = ytoday
      qq_wcal(npos, kage, kspecies) = qq_wt(1, kage, kspecies)
      qq_hgamma(npos, kage, kspecies) = qq_wgamma(kage, kspecies)
c
      do jchem = 1, gnchem
         qq_cfcal(npos, jchem, kage, kspecies) = 
     &      qq_cfj(jchem, kage, kspecies)
      enddo
      qq_hactvt(npos, kage, kspecies) = actv
c
  110 continue
      return
      end
      subroutine ksave1(tdelta, ytoday, to_save)
c
c update: 11:45 fri 9-sep-1994.
c save and/or store updated variables.
c
c to_save:  .true.   ==> save this point, PERIOD;
c           .false.  ==> save this point according to Cc_iprint;
c
c changes in "kfeces" should be propagated to "Kdbdtgf", "Ksave1"
c                                             "Ow2", "Labode"
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'plots.par'
      include 'phylum.par'
      include 'habitat.par'
      include 'numbers.par'
      include 'simul.par'
      include 'work.def'
      include 'globpar.def'
      include 'odevar.def'
      include 'fluxes.def'
      include 'lab.def'
      include 'expos.def'
      include 'habitat.def'
      include 'options.def'
c
      real tdelta, ytoday
      logical to_save
c
      integer jchem, npos
      real cchem, zz, kfeces, ff
      logical treq, important_event
      external treq
c
      cc_iterno = cc_iterno + 1
      dtcw = dtcw + tdelta
      twmean = twmean + tdelta * xcelsius
c
      if (simul_mode .eq. tlaboratory) then
         zz = woc / tank_volume
         ff = one / tank_volume
      endif
c
      do jchem = 1, gnchem
         if (simul_mode .ne. tlaboratory) then
            cchem = xchem_in_water(jchem)
         else
            kfeces = koc(jchem)
            cchem = ff * amt_in_tank(jchem) / (one + zz * kfeces)
            tank_cw(jchem) = cchem
         endif
         cwmean(jchem) = cwmean(jchem) + tdelta * cchem
      enddo
c
      important_event = (to_save) .or. (treq(ytoday, time_beg)) .or. (
     &   treq(ytoday, time_end))
c
      if (important_event) then
         continue
      elseif (mod(cc_iterno - 1, cc_iprint) .ne. 0) then
         go to 110
      endif
c
      cc_nxy = min(1 + cc_nxy, maxpoints)
      npos = cc_nxy
c
      cc_tcal(npos) = ytoday
c
      if (simul_mode .ne. tlaboratory) then
         do jchem = 1, gnchem
            hcw(npos, jchem) = xchem_in_water(jchem)
         enddo
      else
         do jchem = 1, gnchem
            hcw(npos, jchem) = tank_cw(jchem)
         enddo
      endif
c
  110 continue
      return
      end
      subroutine kstep(t0, t1, tbeg, tfin, nerror)
c
c update: 17:40 fri 4-mar-1994.
c given times t0 and t1, advance file (if needed) and find tbeg, tfin such that
c [t0 == tbeg, tfin] does not contain a double point;
c
c on output
c if ("reading chemical concentrations from a file") then
c    tbeg = t0
c    tfin = as described above; notice that tfin .le. t1
c else
c    tbeg = t0
c    tfin = t1
c
c all errors are fatal.
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'habitat.par'
      include 'expos.par'
      include 'noval.par'
      include 'idfiles.def'
      include 'habitat.def'
      include 'options.def'
      include 'examsrec.def'
c
      real t0, t1, tbeg, tfin
      integer nerror
c
      logical wfound, eofile
      integer f1m0, f1m1, f2m0, f2m1, f3m0, f3m1, f4m0, f4m1
      integer nlen, xslen, nfile
      real ziel
      external xslen
c
 9110 format (' ?? Kstep: could not find time = ',1pg10.3,' in ',a,
     &   ' file "',a,'".')
c
      nerror = 0
      ziel = t1
c
c food web setup: we are using fourier transforms -- no need to read the file.
c
      if (xfcelsius) then
         tbeg = t0
         tfin = t1
         go to 110
      endif
c
c exams mode: all in one file
c
      if (xexams) then
         call envtime(t1, nf1, f1time, wfound, f1m0, f1m1)
         if ( .not. wfound) then
            call envexams(rnoval, wfound, f1m0, f1m1, eofile)
            if ( .not. wfound) then
               nlen = xslen(cwfil)
               write (stdout, 9110) t1, 'exams', cwfil(1:nlen)
               write (jerr, 9110) t1, 'exams', cwfil(1:nlen)
               errused = .true.
               call errlog(.true., ' ', 0)
            endif
         endif
         f2m0 = f1m0
         f2m1 = f1m1
         f3m0 = f1m0
         f3m1 = f1m1
         tbeg = t0
         tfin = min(ziel, f1time(f1m1))
         go to 110
      endif
c
      if (iread_cw .ne. tfxnoread) then
         call envtime(t1, nf1, f1time, wfound, f1m0, f1m1)
         if ( .not. wfound) then
            nfile = 1
            call envread(rnoval, nfile, wfound, f1m0, f1m1, eofile)
            if ( .not. wfound) then
               nlen = xslen(cwfil)
               write (stdout, 9110) t1, 'cwater', cwfil(1:nlen)
               write (jerr, 9110) t1, 'cwater', cwfil(1:nlen)
               errused = .true.
               call errlog(.true., ' ', 0)
            endif
         endif
         ziel = min(ziel, f1time(f1m1))
      endif
c
      if (iread_plankton .ne. tfxnoread) then
         call envtime(t1, nf2, f2time, wfound, f2m0, f2m1)
         if ( .not. wfound) then
            nfile = 2
            call envread(rnoval, nfile, wfound, f2m0, f2m1, eofile)
            if ( .not. wfound) then
               nlen = xslen(planktonfil)
               write (stdout, 9110) t1, 'plankton', 
     &            planktonfil(1:nlen)
               write (jerr, 9110) t1, 'plankton', planktonfil(1:nlen)
               errused = .true.
               call errlog(.true., ' ', 0)
            endif
         endif
         ziel = min(ziel, f2time(f2m1))
      endif
c
      if (iread_benthos .ne. tfxnoread) then
         call envtime(t1, nf3, f3time, wfound, f3m0, f3m1)
         if ( .not. wfound) then
            nfile = 3
            call envread(rnoval, nfile, wfound, f3m0, f3m1, eofile)
            if ( .not. wfound) then
               nlen = xslen(benthosfil)
               write (stdout, 9110) t1, 'benthos', benthosfil(1:nlen)
               write (jerr, 9110) t1, 'benthos', benthosfil(1:nlen)
               errused = .true.
               call errlog(.true., ' ', 0)
            endif
         endif
         ziel = min(ziel, f3time(f3m1))
      endif
c
      if (iread_cfish .ne. tfxnoread) then
         call envtime(t1, nf4, f4time, wfound, f4m0, f4m1)
         if ( .not. wfound) then
            nfile = 4
            call envread(rnoval, nfile, wfound, f4m0, f4m1, eofile)
            if ( .not. wfound) then
               nlen = xslen(cfishfil)
               write (stdout, 9110) t1, 'cfish', cfishfil(1:nlen)
               write (jerr, 9110) t1, 'cfish', cfishfil(1:nlen)
               errused = .true.
               call errlog(.true., ' ', 0)
            endif
         endif
         ziel = min(ziel, f4time(f4m1))
      endif
c
      tbeg = t0
      tfin = ziel
c
  110 continue
      return
      end
      real function la50(lc50func, lc50par, acw, molwt, mpar, nchem)
c
c update: wed 15:42 27-mar-1991.
c compute La50
c
c notes:
c . changes in the computation of activity (option "tobserved") should be
c   propagated to the module "Afish", "La50", "Owpezall"
c
c other notes:
c for 96-hour acute exposures of 30-day old fathead minnows (i.e., veith et
c al.(1983)) exchange kinetics appear to become limited for chemicals whose
c Logp > 4. for 7-day acute exposures of guppies (i.e., konemann 1981a)
c exchange kinetics appear to become limited for chemicals whose Logp > 5.
c for fathead minnows the following linear least squares regression
c
c     Log(lc50)= Log(moles/ l) = -1.253 - 0.9408*Clogp (n=50; r=-0.96)
c
c can be calculated (see veith et al.(1983 tables 1 and 2). the aqueous
c activity coefficient of hydrophobic organics can be estimated by the linear
c regression
c
c     Log(Acw) = 1.672 + 0.944*Clogp
c
c (yalkowsky et al. 1983). therefore
c
c    Log(La50) = Log(Acw) + Log(lc50) + Log(nuw=0.018)
c              = -1.326 + 0.0032*Clogp
c
c which yields
c
c         La50 = 0.0472
c
c approximately. for interspecies correlations see mayer and ellersieck (1986)
c and barnthouse et al. (1986)
c
c references:
c -barnthouse et al. 1986. ornl-6251.
c -konemann 1981a. toxicology 19:209-221.
c -konemann 1981b. toxicology 19:229-238.
c -mayer and ellersieck 1986. usfws. s914.a3 no. 160 (qh 545.p4).
c -yalkowsky and valvani 1980. j.pharm.sci. 69:912-922.
c -yalkowsky, valvani and mackay 1983. residues review 85:43-55.
c -veith, call and brooke 1983. can.j.fish.aquat.sci. 40:743-748.
c
c
c declaration of fortran parameters
c
      include 'numbers.par'
      include 'simul.par'
      include 'water.par'
c
      integer mpar, nchem, lc50func( * )
      real lc50par(mpar, * ), acw( * ), molwt( * )
c
      integer jchem
      real sum_la50, la50_j, ca, exx
      real la_fathead
      external exx
      data la_fathead /0.0472/
c
      sum_la50 = zero
      do jchem = 1, nchem
         if (lc50func(jchem) .eq. tlog_fathead) then
            la50_j = 10.0 ** lc50par(1, jchem) * la_fathead ** 
     &         lc50par(2, jchem)
c
         elseif (lc50func(jchem) .eq. tobserved) then
            ca = lc50par(1, jchem)      ! observed lc50 of jth chemical in ppm = mg/l
            ca = ca / (1000.0 * molwt(jchem))   ! convert ca to molarity
            ca = ca * nuw       ! convert ca to mole fraction
            la50_j = acw(jchem) * ca    ! finally convert ca to activity
         else
c
c generalized interspecific correlation from barnthouse et al. (1986)
c
            la50_j = 0.501 * la_fathead ** 1.01
         endif
c
c use geometric mean because TIP uses it. [thu 10:42 3-jan-1991.]
c
         sum_la50 = sum_la50 + log(la50_j)
      enddo
      la50 = exx(sum_la50 / real(nchem))
c
      return
      end
      subroutine labdrv(nerror)
c
c update: 11:45 fri 9-sep-1994.
c drive laboratory simulation;  one fish species, one age class, nfish fish
c     in a tank; concentration of chemical in the water is altered by the
c     fish's adme (absortion, distribution, metabolism, and excretion);
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'errors.par'
      include 'fish.par'
      include 'numbers.par'
      include 'ode.par'
      include 'phylum.par'
      include 'plots.par'
c
      include 'chemp.def'
      include 'expos.def'
      include 'errors.def'
      include 'fish.def'
      include 'fluxes.def'
      include 'globpar.def'
      include 'idfiles.def'
      include 'lab.def'
      include 'ode.def'
      include 'odevar.def'
      include 'options.def'
      include 'time.def'
      include 'work.def'
c
      integer nerror
c
      integer jchem, jage, jspecies
      logical panic, piscis_mortis
c
c euler variables
c
      real tmid, astep, almost_one, arel_tol, tbound, tstep, qeuler
      real t0, t1
      integer jtimes, ntimes, nneg, newstep
      logical done, stephalt, trne
      external trne
c
c errmsg1:  truth of "error message 1 not issued" ;
c           issue the message only once;
c           the message will be issued if the integration step size is
c           too large  --  detected when any of the integration variables
c           becomes negative.
c
      logical errmsg1
      save errmsg1
      data errmsg1 /.true./
c
 9110 format (' ?? Labdrv: integration step size too large; ',/,
     &   '           suggestion: increase "nstep" to ',i4,/,
     &   '           and repeat the simulation.')
c
c *************** initialize simulation/print/plotting parameters *************
c wt-dbdtgf equations
c
      call initchem(simul_beg, simul_end, hstep)
      jspecies = 1
      jage = 1
c
      call initpez(simul_mode, gnchem, xcelsius, sigma, nh3n, cn, 
     &   xplankton_standing_stock, vv_inicf(1, jage, jspecies), 
     &   simul_beg, simul_end, vv_growth_model(jage, jspecies), kl, koc,
     &   kow, acw, molwt, lc50func(1, jspecies), 
     &   lc50par(1, 1, jspecies), vv_plfunc(jage, jspecies), 
     &   vv_iniwt(jage, jspecies), vv_pval(1, jage, jspecies), 
     &   qq_wt(1, jage, jspecies), qq_bf(1, jage, jspecies), 
     &   qq_jgilup(1, jage, jspecies), qq_jgilex(1, jage, jspecies), 
     &   qq_jgutup(1, jage, jspecies), qq_jgutex(1, jage, jspecies), 
     &   qq_iterno(jage, jspecies), qq_iprint(jage, jspecies), hstep, 
     &   qq_nxy(jage, jspecies), qq_kf(1, jage, jspecies), 
     &   qq_lenfish(jage, jspecies), dtfish(jage, jspecies), 
     &   qq_igamma(jage, jspecies), qq_iingest(jage, jspecies), 
     &   qq_iassim(jage, jspecies), qq_iegest(jage, jspecies), 
     &   qq_iexcret(jage, jspecies), qq_irespir(jage, jspecies), 
     &   qq_isda(jage, jspecies), cfmean(1, jage, jspecies), 
     &   cpmean(1, jage, jspecies), fish_la50(jspecies), 
     &   qq_death_day(jage, jspecies), qq_fish_alive(jage, jspecies))
c
      time_beg = simul_beg
      time_end = simul_end
      call envget(time_beg)
c
c initialize tank ode;
c convert from mg/Litre (Xchem_in_water) to micrograms (Amt_in_tank)
c Tank_volume in mL;
c     1 mg/Litre == microgram/mL == 1 ppm
c
      woc = zero
      do jchem = 1, gnchem
         amt_in_tank(jchem) = tank_volume * xchem_in_water(jchem)
      enddo
c
      call ksave1(zero, time_beg, .true.)
      call ksave(jage, jspecies, zero, time_beg, .true.)
c
      stephalt = .false.
      panic = .false.
      nerror = tnoerror
      t0 = time_beg
      t1 = time_end
      tinc = one
      almost_one = one - mach_eps
      piscis_mortis = .false.
      qq_new_day(jage, jspecies) = time_beg
      call uotty('## laboratory', -1)
c
  110 continue
      if ( .not. stephalt) then
         if ( .not. panic) then
            call kstep(t0, t1, t0, t1, nerror)
            if (nerror .ne. tnoerror) go to 130
c
            astep = min(abs(hstep), abs(t1 - t0))
            ntimes = int(((t1 - t0 + hstep) / hstep) + almost_one)
c
            if (trne(t1, zero)) then
               arel_tol = abs(t1 * mach_eps)
            else
               arel_tol = abs(mach_eps)
            endif
c
            tbound = t1 - arel_tol
            tstep = astep
            tmid = t0
c
c at the start of the loop: tmid = t0 + Float(jtimes-1);
c the purpose of the loop is to ensure a finite number of steps;
c
            do jtimes = 1, ntimes
               call labode(jage, jspecies, tmid, nerror)
               if (nerror .ne. tnoerror) go to 130
c
c take euler step:  y(tmid + tstep) = y(tmid)  +  tstep * y'(tmid)
c
c if "tmid + tstep" can overshoot "t1", or it is within machine precision
c from "t1", adjust the step size;
c
               if (tbound .le. (tmid + tstep)) tstep = t1 - tmid
               tmid = tmid + tstep
c
c make sure values are non-negative; keep a count of negative values
c
               call ksave1(tstep, tmid, .false.)
               nneg = 0
               qeuler = qq_wt(1, jage, jspecies) + tstep * 
     &            qq_dwdt(1, jage, jspecies)
               if (qeuler .lt. zero) then
                  nneg = nneg + 1
                  qeuler = zero
               endif
               qq_wt(1, jage, jspecies) = qeuler
c
               qeuler = qq_wt(2, jage, jspecies) + tstep * 
     &            qq_dwdt(2, jage, jspecies)
               if (qeuler .lt. zero) then
                  nneg = nneg + 1
                  qeuler = zero
               endif
               qq_wt(2, jage, jspecies) = qeuler
c
               qeuler = woc + tstep * dwocdt
               if (qeuler .lt. zero) then
                  nneg = nneg + 1
                  qeuler = zero
               endif
               woc = qeuler
c
               do jchem = 1, gnchem
                  qeuler = qq_bf(jchem, jage, jspecies) + tstep * 
     &               qq_dbfdt(jchem, jage, jspecies)
                  if (qeuler .lt. zero) then
                     nneg = nneg + 1
                     qeuler = zero
                  endif
                  qq_bf(jchem, jage, jspecies) = qeuler
c
                  qeuler = amt_in_tank(jchem) + tstep * dadt(jchem)
                  if (qeuler .lt. zero) then
                     nneg = nneg + 1
                     qeuler = zero
                  endif
                  amt_in_tank(jchem) = qeuler
               enddo
c
c negative values detected ?
c
               if (nneg .gt. 0) then
                  if (errmsg1) then
                     errmsg1 = .false.
                     newstep = nint((8.0 + astep) / astep)
                     call uotty(' ', 1)
                     write (stdout, 9110) newstep
                     write (stdout, *)
                     stephalt = .true.
ccc                  go to 130
                  endif
               endif
c
c save stuff
c
               call ksave(jage, jspecies, tstep, tmid, .false.)
c
c dead fish ? - exit
c
               piscis_mortis = ( .not. qq_fish_alive(jage, jspecies))
               if (piscis_mortis) go to 120
c
c have we reached t1 ?
c
               done = (abs(tmid - t1) .le. arel_tol)
               if (done) go to 120
            enddo
c
  120       continue
            panic = (piscis_mortis)
            if ( .not. panic) then
               if (trne(time_end, t1)) then
                  t0 = t1
                  t1 = time_end
                  go to 110
               endif
            endif
         endif
c
         if (piscis_mortis) then
            write (stdout, *) '?? fish died at day = ', 
     &         qq_death_day(jage, jspecies)
            call uotty(' ', 1)
            write (stdout, *) '?? fish died at day = ', 
     &         qq_death_day(jage, jspecies)
         endif
      endif
c
  130 continue
      if (stephalt) then
         haltsimul = .true.
      endif
c
      call kerrmsg(nerror)
      call out0()
      call out1()
      call out2()
c
      return
      end
      subroutine labode(kage, kspecies, ztime, nerror)
c
c update: 17:28 fri 4-mar-1994.
c
c this is an interface between the ode driver and the Fgets ode;
c remember: integrate one fish.
c model:    fish in a tank; cwater changes according fish gill net uptake
c
c ztime:    time (days)
c
c changes in "kfeces" should be propagated to "Kdbdtgf", "Ksave1"
c                                             "Ow2", "Labode"
c
c the computation for pia and pic should be the same in "Kdbdtgf" and "Labode"
c see notes in "Kdbdtgf" ;
c
c let At  be the amount of chemical in the tank: (water + feces), excluding fish
c let Woc be the amount of feces in the tank [grams]
c
c dWoc                                                Woc
c ---- = Tank_nfish * pic * egest  -  Tank_flow * -----------
c dt                                              Tank_volume
c
c  dAt                                 At
c  --- = Tank_flow * (cwater_fun - -----------)    +
c  dt                              Tank_volume
c
c
c        Tank_nfish * (Cfeces * egest  -  Sw*Kw * (Cw - Ca))
c
c Note: if Tank_flow = 0, then
c
c        dAt                  dBf
c        ---  +  Tank_nfish * --- = Tank_nfish * Cprey * ingest
c        dt                   dt
c
c gut_egestions partition between feces and water in tank;
c units: [1 mg/Litre == microgram/mL == 1 ppm]
c     egest [grams/time]
c     Cfeces [micrograms/grams]
c     gutex [micrograms/time] == Cfeces * egest
c     Xchem_in_water [ppm]
c     bfj [micrograms]
c     At [micrograms]
c     wt [grams]
c     cf [ppm]
c     Woc [grams]
c
c At - total amount of chemical in tank (dissolved in water and organic phase)
c at equilibrium: Kfeces = Corganic / Cwater
c
c Corganic already has "pic" factor in it (i.e., it is 100% organic), therefore
c it is not needed to include "pic" in "pic * Kfeces"
c
c let
c  Ao:  amount in organic feces;
c  Aw:  amount in total water; note At = Ao + Aw
c
c feces (egest) partitioned in three phases; let
c  Vf: volume of feces = Egest * density (assume density of feces = 1 gm/mL)
c Vaf: volume aqueous feces = Vf * pia
c Voc: volume organic feces = Vf * pic
c Vxf: volume ash in feces; without solvent properties
c
c let Vw: total aqueous phase == Tank_volume since Vaf << Tank_volume
c
c solve
c     Kfeces = (Ao / Woc) / (Aw / Vw)
c     At = Ao + Aw
c     (assume density of Woc = 1 gm/mL)
c
c solution:
c     let zz = Woc * Kfeces / Vw
c     Aw = At / (one + zz)
c     Ao = (At * zz) / (one + zz)
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'habitat.par'
      include 'errors.par'
      include 'fish.par'
      include 'numbers.par'
      include 'physio.par'
      include 'simul.par'
      include 'fish.def'
      include 'globpar.def'
      include 'odevar.def'
      include 'fluxes.def'
      include 'lab.def'
      include 'options.def'
      include 'habitat.def'
      include 'expos.def'
c
c declaration for arguments
c
      integer kage, kspecies, nerror
      real ztime
c
      integer jchem, agep
      real pia, pic, kfeces, zz, ff, food_kf
      real net_gill_exchange
      logical notdawn
c
c if the fish is dead look no further; maintain status quo;
c
      nerror = tnoerror
      if ( .not. qq_fish_alive(kage, kspecies)) then
         qq_dwdt(1, kage, kspecies) = zero
         qq_dwdt(2, kage, kspecies) = zero
         dwocdt = zero
         do jchem = 1, gnchem
            qq_dbfdt(jchem, kage, kspecies) = zero
            dadt(jchem) = zero
         enddo
         go to 110
      endif
c
c convert from micrograms At to mg Cw [mg/Litre]; Tank_volume in mL;
c     1 mg/Litre == microgram/mL == 1 ppm
c
      zz = woc / tank_volume
      ff = one / tank_volume
      do jchem = 1, gnchem
         kfeces = koc(jchem)
         tank_cw(jchem) = ff * amt_in_tank(jchem) / (one + zz * kfeces)
      enddo
c
c calculate aqueous exposure conditions;
c the only (returnable) error at this time is a warning;
c stop simulation and output results so far.
c
      call envget(ztime)
c
c update morphological/physiological/prey concentrations parameters at "dawn" ;
c these will stay active (read: constant) for this day unless
c "Xupdate_continuously == true" ;
c
      agep = qq_fish_age(kage, kspecies)
      notdawn = (ztime .lt. qq_new_day(kage, kspecies))
      if (notdawn) then
         if (xupdate_continuously) then
            call kfupdate(kage, kspecies, qq_wt(1, kage, kspecies), 
     &         xcelsius, xplankton_standing_stock)
         endif
      else
         qq_new_day(kage, kspecies) = qq_new_day(kage, kspecies) + tinc
         call kfupdate(kage, kspecies, qq_wt(1, kage, kspecies), 
     &      xcelsius, xplankton_standing_stock)
      endif
c
      call kdwdt(ztime, vv_growth_model(agep, kspecies), 
     &   vv_functional_response(agep, kspecies), 
     &   qq_wgamma(kage, kspecies), qq_phi(kage, kspecies), 
     &   qq_gmax(kage, kspecies), qq_alpha1(kage, kspecies), 
     &   qq_alpha2(kage, kspecies), qq_epsl1(kage, kspecies), 
     &   qq_epsl2(kage, kspecies), qq_mu(kage, kspecies), sigma, nh3n, 
     &   cn, vv_pval(vassxeff, agep, kspecies), 
     &   qq_wt(1, kage, kspecies), qq_dwdt(1, kage, kspecies), 
     &   qq_wingest(kage, kspecies), qq_wassim(kage, kspecies), 
     &   qq_wegest(kage, kspecies), qq_wrespir(kage, kspecies), 
     &   qq_wsda(kage, kspecies), qq_wexcret(kage, kspecies))
c
c compute concentration of chemical in food item
c
      if (food_chem_func .eq. tconstant) then
         do jchem = 1, gnchem
            qq_cp(jchem, kage, kspecies) = food_chem_conc(jchem)
         enddo
c
      elseif (food_chem_func .eq. tequilibrium) then
         do jchem = 1, gnchem
            food_kf = food_pl * kl(jchem)
            qq_cp(jchem, kage, kspecies) = tank_cw(jchem) * food_kf * 
     &         food_bmf(jchem)
         enddo
      endif
c
      call kdbdtgf(gnchem, qq_sgill(kage, kspecies), 
     &   qq_kw(1, kage, kspecies), tank_cw, qq_kf(1, kage, kspecies), 
     &   qq_pa(kage, kspecies), koc, qq_cp(1, kage, kspecies), 
     &   qq_wingest(kage, kspecies), qq_wegest(kage, kspecies), 
     &   qq_wt(1, kage, kspecies), qq_bf(1, kage, kspecies), 
     &   qq_dbfdt(1, kage, kspecies), qq_tjgilup(1, kage, kspecies), 
     &   qq_tjgilex(1, kage, kspecies), qq_tjgutup(1, kage, kspecies), 
     &   qq_tjgutex(1, kage, kspecies))
c
      pia = qq_pa(kage, kspecies)
      pic = (one - pia) * 0.125
      dwocdt = tank_nfish * pic * qq_wegest(kage, kspecies) - tank_flow
     &   * woc / tank_volume
c
c convert from mg/Litre (Xchem_in_water) to micrograms/mL (At)
c     1 mg/Litre == 1 microgram/mL
c
c from the fish's point of view:
c     net_gill_exchange: Sw*Kw * (Cw - Ca)
c            Qq_tjgutex: Cfeces * egest
c
      do jchem = 1, gnchem
         net_gill_exchange = qq_tjgilup(jchem, kage, kspecies) - 
     &      qq_tjgilex(jchem, kage, kspecies)
         dadt(jchem) = tank_flow * (xchem_in_water(jchem) - 
     &      amt_in_tank(jchem) / tank_volume) + tank_nfish * (
     &      qq_tjgutex(jchem, kage, kspecies) - net_gill_exchange)
      enddo
c
  110 continue
      return
      end
      integer function laststr(xbuf, nbuf, nbeg, xstr)
c
c update: 13:40 fri 4-mar-1994.
c find the last instance of the string "Xstr" in Xbuf(Nbeg:Nbuf);
c
c Laststr:  0: if the string is not found
c          >0: if the string was found;
c
c example:             10        20        30
c              123456789=123456789=123456789=
c      Xbuf = 'u8:[root.][s1.s2]file.ext'
c      Xstr = ']', Nbeg = 1 ==> Laststr = 17
c;;
      character*( * ) xbuf, xstr
      integer nbuf, nbeg
c
      integer nj, nk, np, nx
c
      nx = len(xstr)    ! length of "Xstr"                     
      nk = 0    ! position of last instance of "Xstr"  
      nj = nbeg ! current position                     
c
  110 continue
      if (nj .le. nbuf) then
         np = index(xbuf(nj:nbuf), xstr)
         if (np .gt. 0) then    ! found Xstr                           
            nk = np + nj - 1    ! starting position                    
            nj = nk + nx        ! step over Xstr; Xbuf(nk:nj-1) == Xstr
            go to 110   ! one more time                        
         endif
      endif
      laststr = nk
c
      return
      end
      subroutine logreg(type, eps10, begin, nobs, xobs, yobs, vused, 
     &   xbar, ybar, ssx, ssy, ssxy, sse, p1, p2, r)
c
c update:
c . 11:23 fri 9-sep-1994.
c . thu 10:17 2-jan-1992.
c
c this subroutine calculates linear regression functions
c
c Log10(y) = p1  +  p2 * Log10(x); if type = 'Log-Log', or
c
c Log10(y) = p1  +  p2 * x;        if type = 'Log-linear'
c
c eps10:
c . eps = Min {eps > 0  such that:  1 + eps > 1}
c . eps10 = 10 * eps
c
c vused: truth of "point used in the regression."
c p0   : probability that tval0 will be exceeded in absolute value
c tval0: see above
c df   : degrees of freedom.
c
c declarations of subroutine's formal parameters
c
      real zero
      parameter (zero = 0.00e+00)
c
      character*( * ) type
      integer begin, nobs
      real eps10, xobs( * ), yobs( * ), xbar, ybar, ssx, ssy, ssxy, sse
      real p1, p2, r
      logical vused( * )
c
      real log10p1, tx, x, xx, ty, y, yy, xy, rn
      real confid, sd, p0, r2, tval0, df
      real xtol, ytol, xein, yein
      integer jj, nused, nerror
      logical nonzero, xconstant, yconstant, first_time, trne
      external trne
c
      xbar = zero
      ybar = zero
      sse = zero
      ssx = zero
      ssy = zero
      ssxy = zero
      p1 = zero
      p2 = zero
      r = zero
      sd = zero
      p0 = zero
c
      x = zero
      xx = zero
      y = zero
      yy = zero
      xy = zero
      nused = 0
      first_time = .true.
      xconstant = .true.
      yconstant = .true.
c
      do jj = begin, nobs
         if (type(1:7) .eq. 'Log-Log') then
            if ((xobs(jj) .gt. zero) .and. (yobs(jj) .gt. zero)) then
               vused(jj) = .true.
               tx = log10(xobs(jj))
               ty = log10(yobs(jj))
            else
               vused(jj) = .false.
            endif
c
         elseif (type(1:10) .eq. 'Log-linear') then
            if (yobs(jj) .gt. zero) then
               vused(jj) = .true.
               tx = xobs(jj)
               ty = log10(yobs(jj))
            else
               vused(jj) = .false.
            endif
         endif
c
         if (vused(jj)) then
            nused = nused + 1
            x = x + tx
            xx = xx + tx ** 2
            y = y + ty
            yy = yy + ty ** 2
            xy = xy + tx * ty
            if ( .not. first_time) then
               if (xconstant) then
                  xconstant = (abs(tx - xein) .le. xtol)
               endif
               if (yconstant) then
                  yconstant = (abs(ty - yein) .le. ytol)
               endif
            else
               xtol = abs(eps10 * tx)
               xein = tx
               ytol = abs(eps10 * ty)
               yein = ty
               first_time = .false.
            endif
         endif
      enddo
c
      if (nused .gt. 0) then
c
         rn = float(nused)
         xbar = x / rn
         ssx = xx - x ** 2 / rn
         if (ssx .le. zero) then
            ssx = zero
            if ( .not. xconstant) then
               do jj = begin, nobs
                  if (vused(jj)) then
                     if (type(1:7) .eq. 'Log-Log') then
                        tx = log10(xobs(jj))
                     elseif (type(1:10) .eq. 'Log-linear') then
                        tx = xobs(jj)
                     endif
                     ssx = ssx + (tx - xbar) ** 2
                  endif
               enddo
            endif
         endif
c
         ybar = y / rn
         ssy = yy - y ** 2 / rn
         if (ssy .le. zero) then
            ssy = zero
            if ( .not. yconstant) then
               do jj = begin, nobs
                  if (vused(jj)) then
                     if (type(1:7) .eq. 'Log-Log') then
                        ty = log10(yobs(jj))
                     elseif (type(1:10) .eq. 'Log-linear') then
                        ty = log10(yobs(jj))
                     endif
                     ssy = ssy + (ty - ybar) ** 2
                  endif
               enddo
            endif
         endif
         ssxy = xy - x * y / rn
c
c calculate regression coefficients
c
         if (ssx .gt. zero) then
c
            p2 = ssxy / ssx
            log10p1 = ybar - p2 * xbar
            p1 = log10p1
c
            sse = ssy - ssxy ** 2 / ssx
            if ((sse .le. zero) .or. (sse .ge. ssy)) then
               sse = zero
               if ( .not. yconstant) then
                  do jj = begin, nobs
                     if (vused(jj)) then
                        if (type(1:7) .eq. 'Log-Log') then
                           tx = log10(xobs(jj))
                           ty = log10(yobs(jj))
                        elseif (type(1:10) .eq. 'Log-linear') then
                           tx = xobs(jj)
                           ty = log10(yobs(jj))
                        endif
                        sse = sse + (log10p1 + p2 * tx - ty) ** 2
                     endif
                  enddo
               endif
            endif
c
            if (ssy .gt. zero) then
               r2 = max(zero, 1.0 - sse / ssy)
            else
               r2 = zero
            endif
            r = sign(sqrt(r2), p2)
            df = rn - 2.0
            confid = 0.95
            nonzero = (trne(df, zero) .and. trne(ssx, zero) .and. 
     &         trne(sse, zero))
            if (nonzero) then
               sd = sqrt(sse / df)
               tval0 = abs(p2 / sqrt(sse / (df * ssx)))
ccc         call mdtd (tval0, df, p0, nerror)
            else
               sd = zero
               tval0 = 1.0e+30
               p0 = 1.00
            endif
         endif
      endif
c
  110 continue
      return
      end
      integer function matchqte(xbuf, nbeg)
c
c update: tue 11:36 27-oct-1992.
c processed by SPAG 3.14A  at 14:44 on 26 Oct 1992
c
c matchqte will point to the position of the closing quote;
c if no closing quote is found, matchqte will be set to zero;
c "Xbuf(nbeg:nbeg)" will be used as the quote character.
c
      character*( * ) xbuf
      integer nbeg
c
      character*1 qchar
      integer lastp, thisp, npa, npb, xslen
      logical found, done
      external xslen
c
      lastp = max(xslen(xbuf(nbeg:)) + nbeg - 1, 0)
      thisp = nbeg
      qchar = xbuf(thisp:thisp)
c
      thisp = thisp + 1
      found = .false.
  110 continue
      done = ((found) .or. (thisp .gt. lastp))
      if ( .not. done) then
         npa = index(xbuf(thisp:lastp), qchar)
         if (npa .gt. 0) then
            npa = npa + thisp - 1
            npb = npa + 1
            if (npb .gt. lastp) then
               thisp = lastp
               found = .true.
            elseif (xbuf(npb:npb) .eq. qchar) then
c
c two quotes in succession ==> not a closing quote; keep looking
c
               thisp = npb + 1
            else
               thisp = npa
               found = .true.
            endif
         else
            thisp = 0
            found = .true.
         endif
         go to 110
      endif
c
      if (found) then
         matchqte = thisp
      else
         matchqte = 0
      endif
c
      return
      end
      subroutine mkfun(fname, fvals, nfvals, q1tmp, nq1)
c
c update: 17:55 fri 4-mar-1994.
c
c
      real fvals( * )
      integer nfvals, nq1
      character*( * ) fname, q1tmp
c
      integer jj, xslen, ns1, nss
      external xslen
c
      ns1 = xslen(fname)
      q1tmp = fname(1:ns1) // '('
      nq1 = xslen(q1tmp)
c
      do jj = 1, nfvals
         nq1 = nq1 + 1
         call real2a(fvals(jj), '(1pg10.3)', q1tmp(nq1:), nss)
         nq1 = nq1 + nss
         if (jj .ne. nfvals) then
            q1tmp(nq1:nq1) = ','
            nq1 = nq1 + 1
         else
            q1tmp(nq1:nq1) = ')'
         endif
      enddo
      call up2lo(q1tmp, nq1)
c
      return
      end
c MKNAME.spg  processed by SPAG 3.14A  at 14:45 on 26 Oct 1992
      subroutine mkname(finput, fdefault, path, fresult)
c
c\begin
c     purpose:
c        given a file name + defaults, generate an output name
c
c     input
c        finput      s*(*); contains parts of the output name
c        fdefault    s*(*); contains default values for name fields
c        path        truth of "include path info in output filespec"
c
c     output
c        fresult     s*(*); contains the result; it may or may not be
c                    a legal filename, depending if some fields where
c                    missing from "finput" and "fresult" .
c
c     example:
c        . finput  = 'file.out'  ; fdefault = 'xx.yy'
c          fresult = 'file.out'
c
c        . finput  = '.out'      ; fdefault = 'xx.yy'
c          fresult = 'xx.out'
c
c        . finput  = 'file'      ; fdefault = 'xx.yy'
c          fresult = 'file.yy'
c
c        . finput   = 'file.'    ! note the period at the end ==> extension
c          fdefault = 'xx.yy'    !  is null, as opposed to no extension.
c          fresult  = 'file.'
c
c        . finput  = ' '         ; fdefault = 'xx.yy'
c          fresult = 'xx.yy'
c
c        . finput  = ' '         ; fdefault = ' '
c          fresult = ' '
c
c        for the above examples, path may be either .true. or .false.
c
c        . finput   = '.o'
c          fdefault = 'node::dev:[dir.sdir]xx.yy;2'   ;  path = .false.
c          fresult  = 'xx.o'
c
c        . finput   = '.o'
c          fdefault = 'node::dev:[dir.sdir]xx.yy;2'   ;  path = .true.
c          fresult  = 'node::dev:[dir.sdir]xx.o'
c
c     note:
c        - version field will *not* be propagated.
c        - all output strings are translated to lower case
c        - procedure is very naive (try ":::].;")
c        - similar examples can be generated with the fields:
c              node, device, directory
c        - things like:
c              call mkname (finput, fdefault, path, finput)
c          will not cause problems.
c\end
      integer s255
      parameter (s255 = 255)
c
      character*( * ) finput, fdefault, fresult
      logical path
c
      integer k1node, k1device, k1directory
      integer k1file, k1type, k1version
      integer k2node, k2device, k2directory
      integer k2file, k2type, k2version
      character*(s255) q1node, q1device, q1directory
      character*(s255) q1file, q1type, q1version
      character*(s255) q2node, q2device, q2directory
      character*(s255) q2file, q2type, q2version
      integer nq1
c
      call fparse(finput, q1node, k1node, q1device, k1device, 
     &   q1directory, k1directory, q1file, k1file, q1type, k1type, 
     &   q1version, k1version)
      call fparse(fdefault, q2node, k2node, q2device, k2device, 
     &   q2directory, k2directory, q2file, k2file, q2type, k2type, 
     &   q2version, k2version)
c
      nq1 = 1
      fresult = ' '
      if (path) then
         if (k1node .gt. 0) then
            fresult(nq1:) = q1node(1:k1node)
            nq1 = nq1 + k1node
         elseif (k2node .gt. 0) then
            fresult(nq1:) = q2node(1:k2node)
            nq1 = nq1 + k2node
         endif
         if (k1device .gt. 0) then
            fresult(nq1:) = q1device(1:k1device)
            nq1 = nq1 + k1device
         elseif (k2device .gt. 0) then
            fresult(nq1:) = q2device(1:k2device)
            nq1 = nq1 + k2device
         endif
         if (k1directory .gt. 0) then
            fresult(nq1:) = q1directory(1:k1directory)
            nq1 = nq1 + k1directory
         elseif (k2directory .gt. 0) then
            fresult(nq1:) = q2directory(1:k2directory)
            nq1 = nq1 + k2directory
         endif
      endif
c
      if (k1file .gt. 0) then
         fresult(nq1:) = q1file(1:k1file)
         nq1 = nq1 + k1file
      elseif (k2file .gt. 0) then
         fresult(nq1:) = q2file(1:k2file)
         nq1 = nq1 + k2file
      endif
c
      if (k1type .gt. 1) then
         fresult(nq1:) = q1type(1:k1type)
         nq1 = nq1 + k1type
      elseif (k2type .gt. 1) then
         fresult(nq1:) = q2type(1:k2type)
         nq1 = nq1 + k2type
      endif
c
      return
      end
      subroutine mmaction(cc, nameopts, nopts, idd)
c
c update: mon 08:28 23-mar-1992.
c find the first entry in nameopts (from the bottom) which corresponds to
c the action "cc"
c
c input:
c cc - character*(1), action code
c nameopts - list of options  --  column 1
c nopts - number of items
c
c output:
c idd - id of action: 1 .le. idd .le. nopts, if action was found
c                     0, if action was not found;
c
c notes:
c the main purpose of this module is to determine the Index of "quit" and
c "help".  these entries are more likely to be in the bottom of the array,
c therefore, we will start searching "nopts";
c;;
      character*( * ) cc, nameopts( * )
      integer nopts, idd
c
      integer npp
      logical found, done
c
      npp = nopts
      found = .false.
  110 continue
      done = ((found) .or. (npp .le. 0))
      if ( .not. done) then
         if (cc .eq. nameopts(npp)(1:1)) then
            found = .true.
         else
            npp = npp - 1
         endif
         go to 110
      endif
c
      if (found) then
         idd = npp
      else
         idd = 0
      endif
c
      return
      end
      subroutine mmgetiv(uu, wprompt, helpentry, exitcode, intval)
c
c update: 17:54 fri 4-mar-1994.
c Prompt user for an integer. help and quit are allowed.
c
c input:
c uu - unit number of output device
c wprompt - prompting string
c helpentry - help entry name (in help file)
c
c output:
c exitcode - tquit | tsuccess | tfailure
c intval   - integer gotten, if "tsuccess"
c
c notes:
c . first <cr> :: issue help
c . second <cr> :: "quit"
c;;
      include 'xglobal.par'
      include 'menu.par'
      include 'noval.par'
      include 'Prompt.par'
      include 'token.par'
      include 'chars.def'
c
      character*( * ) wprompt, helpentry
      integer uu, exitcode, intval
c
c nrets: number of consecutive carriage returns.
c
      character*(stdlen) q1tmp
      real rval
      integer xslen, ival, toktype, nrets
      logical xxfound, ishelp, isquit, isempty
      external xslen, ishelp, isquit, isempty
c
      include 'chars.sfn'
c
 9110 format (1x,'?? no integer found')
c
c get value:
c . first <cr> issue help
c . second <cr> == "quit"
c
      call prompt(prset1, wprompt)
      nrets = 0
      exitcode = tfailure
      if (isempty()) then
         nrets = 1
         call gethelp(helpentry, xxfound)
      endif
c
  110 continue
      call toknext(ttoken, q1tmp, ival, rval, toktype)
      if (iseol(q1tmp(1:1))) then
         nrets = nrets + 1
         if (nrets .le. 1) then
            call gethelp(helpentry, xxfound)
            call tokreset()
            go to 110
         else
            exitcode = tquit
         endif
      elseif (ishelp(q1tmp)) then
         call gethelp(helpentry, xxfound)
         call tokreset()
         nrets = 1
         go to 110
      elseif (isquit(q1tmp)) then
         exitcode = tquit
      else
         exitcode = tsuccess
      endif
c
      if (exitcode .eq. tsuccess) then
         if (toktype .eq. tint) then
            intval = ival
         else
            write (uu, 9110)
            nrets = 0
            exitcode = tfailure
            call tokreset()
            go to 110
         endif
      else
         exitcode = tquit
         intval = inoval
      endif
      call tokreset()
      call prompt(prpop, ' ')
c
      return
      end
      subroutine mmgetopt(uu, toshow, nameopts, helpopts, nopts, xhits,
     &   optid)
c
c update: 17:54 fri 4-mar-1994.
c select an option from a menu.
c
c input:
c uu - unit number of output device
c toshow - truth of "show menu on entry"; generally true.
c nameopts - list of options; first two columns will NOT be printed.
c helpopts - help entry name (in help file) of item in "nameopts"
c nopts - number of items
c
c output:
c Xhits - integer working array. modified.
c optid - id of option. help info is displayed here and therefore it will not
c         be a return code.
c           if (optid .eq. tquit) then
c              ! quit code
c           else
c              ! option selected is nameopts(optid)
c           endif
c
c assumptions:
c . first <cr> :: issue help menu
c . second <cr> :: "quit"
c . see arrays "helpopts", "nameopts"
c     data (helpopts(jj), nameopts(jj), jj = 1, nopts) /
c    &  '~/zz/stealth',  '-e2. stealth <on | off>',
c    &  '~/zz/holling',  '-h3. holling [no]steady_state_gut',
c    &  '~/zz/totals',   '-o4. totals                      ',
c    &  '~/zz/last',     '-l5. last_year_only              ',
c    &  '~/zz/timing',   '-t6. timing                      ',
c    &  '~/zz/show',     '-s7. show                        ',
c    &  '~/zz/fourier',  '-f8. fourier <on | off>',
c    &  '~/zz/dummy',    '-y9. dummy',
c    &  '~/help',        '?h1. ? | help',
c    &  '~/quit',        'qq0. quit'
c    -  /
c     field 1: column 1 of nameopts: action to take:
c        "-" : take option and run
c        "?" : issue help and Prompt again
c        "q" : quit
c        these fields are defined by the parameters "tmn*" in menu.par;
c
c     field 2: column 2 of nameopts: single character that activates the
c        option, e.g., "stealth" may be selected by pressing "e".  this field
c        is NOT used with the command driven interface; it is a hook for the
c        full menu system.
c
c     field 3: column 3 to '.' of nameopts: number that activates the option,
c        e.g., "stealth" may be selected by pressing "2".  the '.' determines
c        the extent of this field. the '.' is assumed to be in the same column
c        for all entries.
c
c     field 4: the first word after the first non Blank after '.'.
c        "help" and "quit" are recognized individually, then appropriate
c        action is taken.
c;;
      include 'xglobal.par'
      include 'menu.par'
      include 'token.par'
      include 'chars.def'
c
      character*( * ) nameopts( * ), helpopts( * )
      integer uu, nopts, xhits( * ), optid
      logical toshow
c
c nrets: number of consecutive carriage returns.
c
      character*(stdlen) q1tmp
      real rval
      integer nq1, xslen, ival, toktype, jj, nrets, nlen
      integer n3a, nhits, ios
      logical lshow, isempty, xxok
      external xslen, isempty
c
      include 'chars.sfn'
c
 9110 format (1x,'options are:')
 9120 format (1x,3x,a)
 9130 format (1x,'?? no such option "',a,'"')
 9140 format (1x,'?? ambiguous option')
c
      n3a = 3
      nrets = 0
      lshow = (toshow)
  110 continue
      if (lshow) then
         write (uu, 9110)
         do jj = 1, nopts
            nlen = xslen(nameopts(jj))
            if (n3a .le. nlen) then
               write (uu, 9120, iostat=ios) nameopts(jj)(n3a:nlen)
            endif
         enddo
         lshow = .false.
      endif
c
c get option:
c . first <cr> issue help
c . second <cr> == "quit"
c
      call toknext(ttoken, q1tmp, ival, rval, toktype)
      if (iseol(q1tmp(1:1))) then
         nrets = nrets + 1
         if (nrets .le. 1) then
            call tokreset()
            lshow = .true.
            go to 110
         else
            call tokreset()
            optid = tquit
            go to 120
         endif
      endif
c
      nrets = 0
      call mmidopt(q1tmp, nameopts, nopts, xhits, nhits)
      if (nhits .eq. thelp) then
         if (isempty()) then
            lshow = .true.
         else
            call tok2dlim(' ', q1tmp)
            call mmidopt(q1tmp, nameopts, nopts, xhits, nhits)
            if (nhits .eq. tquit) then
               call mmaction(tmnquit, nameopts, nopts, ival)
               if (ival .gt. 0) then
                  call gethelp(helpopts(ival), xxok)
                  lshow = ( .not. xxok)
               else
                  lshow = .true.
               endif
            elseif (nhits .eq. thelp) then
               call mmaction(tmnhelp, nameopts, nopts, ival)
               if (ival .gt. 0) then
                  call gethelp(helpopts(ival), xxok)
                  lshow = ( .not. xxok)
               else
                  lshow = .true.
               endif
            elseif (nhits .eq. 0) then
               nq1 = xslen(q1tmp)
               write (uu, 9130) q1tmp(1:nq1)
               lshow = .false.
            elseif (nhits .eq. 1) then
               call gethelp(helpopts(xhits(nhits)), xxok)
               lshow = ( .not. xxok)
            else
               write (uu, 9140)
               lshow = .false.
            endif
         endif
         call tokreset()
         go to 110
c
      elseif (nhits .eq. tquit) then
         optid = tquit
         call tokreset()
c
      elseif (nhits .eq. 1) then
         optid = xhits(nhits)   ! do NOT reset token buffer      
c
      elseif (nhits .eq. 0) then
         nq1 = xslen(q1tmp)
         write (uu, 9130) q1tmp(1:nq1)
         lshow = .false.
         call tokreset()
         go to 110
c
      else
         write (uu, 9140)
         lshow = .false.
         call tokreset()
         go to 110
      endif
c
  120 continue
      return
      end
      subroutine mmgetsv(uu, wprompt, helpentry, exitcode, sval, nlen)
c
c update: 17:54 fri 4-mar-1994.
c Prompt user for a string. help and quit are allowed.
c
c input:
c uu - unit number of output device
c wprompt - prompting string
c helpentry - help entry name (in help file)
c
c output:
c exitcode - tquit | tsuccess | tfailure
c sval - string gotten, if "tsuccess"
c nlen - Xslen(sval)
c
c notes:
c . first <cr> :: issue help
c . second <cr> :: "quit"
c;;
      include 'xglobal.par'
      include 'menu.par'
      include 'Prompt.par'
      include 'token.par'
      include 'chars.def'
c
      character*( * ) wprompt, helpentry, sval
      integer uu, exitcode, nlen
c
c nrets: number of consecutive carriage returns.
c
      character*(stdlen) q1tmp
      real rval
      integer xslen, ival, toktype, nrets
      logical xxfound, ishelp, isquit, isempty
      external xslen, ishelp, isquit, isempty
c
      include 'chars.sfn'
c
c get value:
c . first <cr> issue help
c . second <cr> == "quit"
c
      nrets = 0
      exitcode = tfailure
      call prompt(prset1, wprompt)
      if (isempty()) then
         nrets = 1
         call gethelp(helpentry, xxfound)
      endif
c
  110 continue
      call toknext(ttoken, q1tmp, ival, rval, toktype)
      if (iseol(q1tmp(1:1))) then
         nrets = nrets + 1
         if (nrets .le. 1) then
            call gethelp(helpentry, xxfound)
            call tokreset()
            go to 110
         else
            exitcode = tquit
         endif
      elseif (ishelp(q1tmp)) then
         call gethelp(helpentry, xxfound)
         call tokreset()
         nrets = 1
         go to 110
      elseif (isquit(q1tmp)) then
         exitcode = tquit
      else
         exitcode = tsuccess
      endif
c
      if (exitcode .eq. tsuccess) then
         call tokpush() ! take whole line              
         call tok2dlim(eol, q1tmp)
         sval = q1tmp
         nlen = xslen(q1tmp)
      else
         exitcode = tquit
         sval = ' '
         nlen = 0
      endif
      call tokreset()
      call prompt(prpop, ' ')
c
      return
      end
      subroutine mmidopt(xoption, nameopts, nopts, xhits, nhits)
c
c update: 17:39 fri 4-mar-1994.
c search for xoption in nameopts(1:nopts) ;
c
c - linear search used; search "nameopts" by fields; (see example)
c - letter case, as well as embedded blanks in the field, are not significant.
c - xoption is selected either by an integer number or a character string
c - if an exact match is not found, incremental search will be tried on the
c   strings;
c
c on output:
c Nhits (integer) ; tquit | thelp | n>0
c Xhits (1:Nhits) ; id of entry, if n>0
c;;
      include 'menu.par'
      include 'srch.par'
c
      character*( * ) xoption, nameopts( * )
      integer nopts, xhits( * ), nhits
c
      integer kstatus, kch, ndot, n1, n2, n3a, n3b, n4a, n4b, nxx
      integer ip, jj, nextnb, nlen, xslen, npos, oval, hval
      logical lfound, srchex0, ishelp, isquit, xisival
      external ishelp, isquit, srchex0, xisival, nextnb, xslen
c
      nhits = 0
      if (isquit(xoption)) then
         nhits = tquit
         go to 110
      elseif (ishelp(xoption)) then
         nhits = thelp
         go to 110
      endif
c
      ndot = index(nameopts(1), '.')
      n1 = 1
      n2 = 2
      n3a = 3
      n3b = max(ndot - 1, 0)
      nxx = index(xoption, ' ') - 1
c
c check second field, exact match.
c
      if (n3a .le. n3b) then
         ip = 1
         lfound = xisival(oval, xoption, ip)
         if (lfound) then
            lfound = (ip .gt. nxx)      ! the only entry should be an integer
         endif
         if (lfound) then
            do jj = 1, nopts
               ip = 1
               if (xisival(hval, nameopts(jj)(n3a:n3b), ip)) then
                  if (hval .eq. oval) then
                     nhits = nhits + 1
                     xhits(nhits) = jj
                  endif
               endif
            enddo
         endif
      endif
      if (nhits .le. 0) then
c
c no matches.
c now check the fourth field. find its columns.
c
         nlen = xslen(nameopts(1))
         n4a = min(nextnb(nameopts(1), nlen, ndot + 1), nlen)
c
c try for a match - exact (Xhits entry > 0) or minimum length (Xhits entry < 0);
c after the loop, check the number of positive entries (there should be
c only one). if there are positive entries, remove the negative entries
c from the arrays. if all entries are negative, make them positive.
c in this way we invoke "Srchex0" only once.
c
         npos = 0
         do jj = 1, nopts
            n4b = max(index(nameopts(jj)(n4a:), ' ') + n4a - 2, n4a)
            lfound = srchex0(nameopts(jj)(n4a:n4b), xoption(1:nxx), 
     &         kstatus, kch)
            if (kstatus .eq. ts1eqs2) then
               nhits = nhits + 1
               xhits(nhits) = jj
               npos = npos + 1
            elseif (kstatus .eq. ts2ins1) then
               nhits = nhits + 1
               xhits(nhits) = -jj
            endif
         enddo
c
         if (nhits .gt. 0) then
            if (npos .gt. 0) then
               ip = 0
               do jj = 1, nhits
                  if (xhits(jj) .gt. 0) then
                     ip = ip + 1
                     if (ip .ne. jj) xhits(ip) = xhits(jj)
                  endif
               enddo
               nhits = ip
            else
               do jj = 1, nhits
                  xhits(jj) = abs(xhits(jj))
               enddo
            endif
         else
            continue    ! no matches.                                      
         endif
      endif
c
c help or quit may have been selected with a number
c
  110 continue
      if (nhits .eq. 1) then
         ip = xhits(1)
         if (nameopts(ip)(n1:n1) .eq. tmnquit) then
            nhits = tquit
         elseif (nameopts(ip)(n1:n1) .eq. tmnhelp) then
            nhits = thelp
         endif
      endif
c
      return
      end
c NEXTBL.spg  processed by SPAG 3.14A  at 14:45 on 26 Oct 1992
      integer function nextbl(card, ncard, nbeg)
c
c update:   thu 15:54 15-oct-1992.
c\begin
c     purpose:
c        - returns the index of the position of the next blank
c          character (starting at position *nbeg*)
c\end
c
      integer ncard, nbeg
      character*( * ) card
c
      integer jj
      include 'chars.def'
      include 'chars.sfn'
c
      jj = nbeg - 1
  110 continue
      jj = jj + 1
      if (jj .le. ncard) then
         if ( .not. uwhite(card(jj:jj))) go to 110
      endif
c
      nextbl = min(jj, ncard + 1)
c
      return
      end
      integer function nextnb(wbuf, wlen, nbeg)
c
c update:   thu 15:52 15-oct-1992.
c NEXTNB.spg  processed by SPAG 3.14A  at 14:45 on 26 Oct 1992
c purpose:
c - returns the index of the position of the next non-white
c   character (starting at position *nbeg*)
c;;
      integer wlen, nbeg
      character*( * ) wbuf
c
      integer jj
c
      include 'chars.def'
      include 'chars.sfn'
c
      jj = nbeg - 1
  110 continue
      jj = jj + 1
      if (jj .le. wlen) then
         if (uwhite(wbuf(jj:jj))) go to 110
      endif
      nextnb = min(jj, wlen + 1)
c
      return
      end
      subroutine ocfca()
c
c update: 17:29 fri 4-mar-1994.
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'page.par'
      include 'idfiles.def'
      include 'globpar.def'
      include 'fluxes.def'
      include 'units.def'
c
c miscellaneous declarations
c
      integer xslen, ntime, xquery
      integer jspecies, jage, nage, edadp(maxage), agep
      external xslen
c
 9110 format (5x,'?? year class ',i2,' died at ',1pg10.3,1x,a)
c;;
      ntime = xslen(pgm_time)
      do jspecies = 1, gnspecies
         call opage(tlines, ' ', 0, 1, xquery)
         call agesort(jspecies, nage, edadp)
         call ocfca0(jspecies, nage, edadp)
         do jage = 1, nage
            agep = edadp(jage)
            if ( .not. qq_fish_alive(agep, jspecies)) then
               call opage(tinquire, ' ', 0, 1, xquery)
               write (jout, 9110) jage, qq_death_day(agep, jspecies), 
     &            pgm_time(1:ntime)
            endif
         enddo
      enddo
c
      return
      end
      subroutine ocfca0(jspecies, nage, edadp)
c
c update: 17:29 fri 4-mar-1994.
c summarize species's toxicity info;
c output final pharmacological stats;
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'page.par'
      include 'idfiles.def'
      include 'globpar.def'
      include 'fish.def'
      include 'options.def'
      include 'fluxes.def'
      include 'chems.def'
c
      integer jspecies, nage, edadp( * )
c
c miscellaneous declarations
c
      integer jage, agep, jchem, xslen, addlin, xquery
      integer nspp, ntt
      real ca
      logical first_time, phead
      external xslen
c
 9110 format (' *** species: "',a,'" ***')
 9120 format (:,5x,a20,1x,a12,2x,a12,2x,a10)
 9130 format (:,5x,a20,1x,1pg10.3,2x,2x,1pg10.3,2x,2x,i5,5x)
c;;
      nspp = xslen(spplab(jspecies))
      addlin = 1 + 1 + 1
      call opage(tinquire, ' ', 0, addlin, xquery)
      write (jout, *)
      write (jout, 9110) spplab(jspecies)(1:nspp)
      write (jout, *)
c
      first_time = .true.
      do jage = 1, nage
         agep = edadp(jage)
c
         if (first_time) then
            phead = .true.
            first_time = .false.
         else
            call opage(tqtop, ' ', 0, addlin, xquery)   ! at top of page ?
            phead = (xquery .eq. ttrue)
         endif
         if (phead) then
            call opage(tinquire, ' ', 0, 2, xquery)
            if (nage .gt. 1) then
               write (jout, 9120) 'Toxicant name       ', 
     &            'Max Cf [ppm]', 'Max Ca [ppm]', 'Year class'
               write (jout, 9120) '--------------------', 
     &            '------------', '------------', '----------'
            else
               write (jout, 9120) 'Toxicant name       ', 
     &            'Max Cf [ppm]', 'Max Ca [ppm]'
               write (jout, 9120) '--------------------', 
     &            '------------', '------------'
            endif
         endif
c
         do jchem = 1, gnchem
            ntt = 20    ! "20" : see note above    ! Xslen(Toxlab(jchem))
            ca = max_cf(jchem, agep, jspecies) / 
     &         max_kf(jchem, agep, jspecies)
            call opage(tinquire, ' ', 0, 1, xquery)
            if (nage .gt. 1) then
               write (jout, 9130) toxlab(jchem)(1:ntt), 
     &            max_cf(jchem, agep, jspecies), ca, jage
            else
               write (jout, 9130) toxlab(jchem)(1:ntt), 
     &            max_cf(jchem, agep, jspecies), ca
            endif
         enddo
         if ((jage .lt. nage) .and. (gnchem .gt. 1)) then
            call opage(tlines, ' ', 0, 1, xquery)
         endif
      enddo
c
      return
      end
      subroutine ochem()
c
c update: 17:55 fri 4-mar-1994.
c output chem info
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'habitat.par'
      include 'page.par'
      include 'simul.par'
      include 'strings.par'
      include 'idfiles.def'
      include 'globpar.def'
      include 'chemp.def'
      include 'chems.def'
      include 'habitat.def'
      include 'heap.def'
c
c miscellaneous declarations
c
      integer jchem, xslen
      integer nnt, pq1, nq1, addlin, xquery
      external xslen
c
 9110 format (1pg10.3)
 9120 format (1pg10.3,' +',1pg10.3,' * Sin(',1pg10.3,' * t[day] + ',1
     &   pg10.3,' )')
 9130 format (1pg10.3,' +',1pg10.3,' * Exp(',1pg10.3,' * t[day])')
c
c a20 : length of chemical name
c
 9140 format (5x,a20,1x,a7,1x,a7,2x,a5,2x,a9,2x,a)
 9150 format (5x,a20,1x,i5,2x,1x,i5,2x,2x,0pf5.2,2x,0pf9.1,2x,a)
c;;
      pq1 = 0
      call heapush(pq1)
c
c general initializations;
c chemical parameters;
c
      addlin = 5 + gnchem + 1
      call opage(tinquire, ' ', 0, addlin, xquery)
c
      write (jout, *)
      write (jout, *)
      write (jout, 9140) 'Toxicant name       ', ' Molwt ', ' Molvol', 
     &   'Logp', ' melting ', 'cwater'
      write (jout, 9140) '                    ', '[g/mol]', ' [cm^3]', 
     &   '    ', 'point [c]', '[ppm]'
      write (jout, 9140) '--------------------', '-------', '-------', 
     &   '----', '---------', '---------'
c
      do jchem = 1, gnchem
         nnt = 20       ! "20" : see note above    ! Xslen(Toxlab(jchem))  
         if (cwfunc(jchem) .eq. tfile) then
            nq1 = xslen(cwfil)
            qhs(pq1) = 'file "' // cwfil(1:nq1) // '"'
         elseif (cwfunc(jchem) .eq. tconstant) then
            write (qhs(pq1), 9110) cwpar(1, jchem)
         elseif (cwfunc(jchem) .eq. tsin) then
            write (qhs(pq1), 9120) cwpar(1, jchem), cwpar(2, jchem), 
     &         cwpar(3, jchem), cwpar(4, jchem)
         elseif (cwfunc(jchem) .eq. texp) then
            write (qhs(pq1), 9130) cwpar(1, jchem), cwpar(2, jchem), 
     &         cwpar(3, jchem)
         endif
         call compress(qhs(pq1), -1, nq1)
c
         write (jout, 9150) toxlab(jchem)(1:nnt), nint(molwt(jchem)), 
     &      nint(molvol(jchem)), logp(jchem), mp(jchem), 
     &      qhs(pq1)(1:nq1)
      enddo
      write (jout, *)
c
      call heapop(pq1)
c
      return
      end
      subroutine ofishpar(uu, tref_output, vv_pval, xfishpar)
c
c update: 16:34 fri 4-mar-1994.
c
c this subroutine outputs morphological & physiological parameters,
c "/fishpar" card format.
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'fish.par'
      include 'noval.par'
      include 'physio.par'
      include 'page.par'
      include 'strings.par'
      include 'idfiles.def'
      include 'fisiorec.def'
      include 'heap.def'
c
      integer uu
      real tref_output, vv_pval( * )
      logical xfishpar
c
      integer ii, nq1, nq2, xslen, pq1, pq2, kbeg, kend
      integer jpp, jpar, xquery
      integer right_most_column, left_most_column
      logical have_data, pskip, lout
      real odb(maxfpar)
      real rho1, rho2, d1, d2
      real gamma1, gamma2, gammaq10, gammat
      real cmax1, cmax2, cmaxq10, cmaxt
      real fsat1, fsat2, fsatq10, fsatt
      real tsat1, tsat2, tsatq10, tsatt
      real evac1, evac2, evac3, evacq10, evact
      real ox1, ox2, oxq10, oxt
      real cvol1, cvol2, cvolq10, cvolt
c
      equivalence (odb(vrho1), rho1), (odb(vrho2), rho2)
      equivalence (odb(vgamma1), gamma1)
      equivalence (odb(vgammaq10), gammaq10)
      equivalence (odb(vgammat), gammat)
      equivalence (odb(vcmax1), cmax1)
      equivalence (odb(vcmaxq10), cmaxq10)
      equivalence (odb(vcmaxt), cmaxt)
      equivalence (odb(vfsat1), fsat1)
      equivalence (odb(vfsatq10), fsatq10)
      equivalence (odb(vfsatt), fsatt)
      equivalence (odb(vtsat1), tsat1)
      equivalence (odb(vtsatq10), tsatq10)
      equivalence (odb(vtsatt), tsatt)
      equivalence (odb(vevac1), evac1)
      equivalence (odb(vevacq10), evacq10)
      equivalence (odb(vevact), evact)
      equivalence (odb(vox1), ox1)
      equivalence (odb(voxq10), oxq10)
      equivalence (odb(voxt), oxt)
      equivalence (odb(vcvol1), cvol1)
      equivalence (odb(vcvolq10), cvolq10)
      equivalence (odb(vcvolt), cvolt)
c
      include 'vdefined.def'
c
      real exx
      external exx, xslen
      include 'vdefined.sfn'
c
 9110 format (a)
c
      if (xfishpar) then
c
         lout = (uu .eq. jout)
         pq1 = 0
         pq2 = 0
         call heapush(pq1)
         call heapush(pq2)
c
c first, load all stuff
c
         do ii = 1, maxfpar
            odb(ii) = vv_pval(ii)
         enddo
c
c compute lamellar densities from interlamellar distances;
c the same formula should be used in "Dbnorm", "Ofishpar", "Ospecies";
c
c     d[cm] = 0.11815 * rho[# lamellae/mm gill filament] ** (-1.18862)
c
c        d1 * wt * d2 = 0.11815 * (rho1 * wt * rho2) ** (-1.18862)
c
         d1 = vv_pval(vrho1)
         d2 = vv_pval(vrho2)
         rho1 = (d1 / 0.11815) ** (1.0 / ( -1.18862))
         rho2 = d2 / ( -1.18862)
c
         if (vdefined(gammaq10)) then
            gammaq10 = exx(vv_pval(vgammaq10) * 10.0)
            gamma1 = exx(vv_pval(vgammaq10) * (tref_output - 
     &         vv_pval(vgammat))) * vv_pval(vgamma1)
            gammat = tref_output
         endif
c
         if (vdefined(cmaxq10)) then
            cmaxq10 = exx(vv_pval(vcmaxq10) * 10.0)
            cmax1 = exx(vv_pval(vcmaxq10) * (tref_output - 
     &         vv_pval(vcmaxt))) * vv_pval(vcmax1)
            cmaxt = tref_output
         endif
c
         if (vdefined(fsatq10)) then
            fsatq10 = exx(vv_pval(vfsatq10) * 10.0)
            fsat1 = exx(vv_pval(vfsatq10) * (tref_output - 
     &         vv_pval(vfsatt))) * vv_pval(vfsat1)
            fsatt = tref_output
         endif
c
         if (vdefined(tsatq10)) then
            tsatq10 = exx(vv_pval(vtsatq10) * 10.0)
            tsat1 = exx(vv_pval(vtsatq10) * (tref_output - 
     &         vv_pval(vtsatt))) * vv_pval(vtsat1)
            tsatt = tref_output
         endif
c
         if (vdefined(evacq10)) then
            evacq10 = exx(vv_pval(vevacq10) * 10.0)
            evac1 = exx(vv_pval(vevacq10) * (tref_output - 
     &         vv_pval(vevact))) * vv_pval(vevac1)
            evact = tref_output
         endif
c
         if (vdefined(oxq10)) then
            oxq10 = exx(vv_pval(voxq10) * 10.0)
            ox1 = exx(vv_pval(voxq10) * (tref_output - vv_pval(voxt))) *
     &         vv_pval(vox1)
            oxt = tref_output
         endif
c
         if (vdefined(cvolq10)) then
            cvolq10 = exx(vv_pval(vcvolq10) * 10.0)
            cvol1 = exx(vv_pval(vcvolq10) * (tref_output - 
     &         vv_pval(vcvolt))) * vv_pval(vcvol1)
            cvolt = tref_output
         endif
c
c output only those records with data.
c
         qhs(pq2) = '   / fishpar '
         right_most_column = 79
         left_most_column = 3 + xslen(qhs(pq2))
         nq2 = left_most_column
         do ii = 1, max_fish_fun
            have_data = .false.
            jpp = fppos(ii) - 1
            do jpar = 1, fparg(ii)
               jpp = jpp + 1
               have_data = (have_data .or. (vdefined(odb(jpp))))
            enddo
            pskip = ( .not. have_data) .or. (fpname(ii) .eq. 'plfish')
            if ( .not. pskip) then
               call mkfun(fpname(ii), odb(fppos(ii)), fparg(ii), 
     &            qhs(pq1), nq1)
               if ((nq2 + nq1 - 1) .gt. right_most_column) then
                  nq2 = nq2 - 1
                  if (lout) call opage(tinquire, ' ', 0, 1, xquery)
                  write (uu, 9110) qhs(pq2)(1:nq2)
                  nq2 = left_most_column
               endif
               kbeg = nq2 + 1
               kend = kbeg + nq1        ! includes one trailing Blank
               qhs(pq2)(kbeg:kend) = qhs(pq1)(1:nq1)
               nq2 = kend
            endif
         enddo
         nq2 = xslen(qhs(pq2)(1:nq2))
         if (nq2 .gt. left_most_column) then
            if (lout) call opage(tinquire, ' ', 0, 1, xquery)
            write (uu, 9110) qhs(pq2)(1:nq2)
         endif
c
         call heapop(pq2)
         call heapop(pq1)
      endif
c
  110 continue
      return
      end
      subroutine opage(xcode, xline, nxl, addlin, xquery)
c
c update: 17:29 fri 4-mar-1994.
c
c this module will ensure that no more than "Pagelen" lines are written
c to an output page.
c
c xcode        action
c --------     --------------------------------------
c teject       eject page; set "Thislin" to "Pagelen"
c tprint       print xline
c tinquire     if addlin > 0:  need "addlin" lines in this page; do they fit?
c                 - yes: set "Thislin = Thislin+addlin"
c                 - no:  eject page, set "Thislin = Thislin+addlin"
c              if addlin <= 0:
c                 - eject page, set set "Thislin = Thislin+Abs(addlin)"
c
c              (this option is used when the program is going to print directly,
c               without this module's intervention)
c
c tsethead     set the header string to "xline"
c tlines       issue "addlin" Blank lines if we are NOT at the top of a page
c
c tqtop        query: are we at top of page?
c                 - yes: set "xquery = ttrue"
c                 -  no: set "xquery = tfalse"
c tqfit        query: can we fit "addlin" lines in this page ?
c                 - yes: set "xquery = ttrue"
c                 -  no: set "xquery = tfalse"
c
c eject page will be implemented by setting "Thislin" to "Pagelen";
c the page will be ejected the next time if info is to be printed;
c do not issue an empty page; note that xcode=tinquire may be the exception;
c;;
      include 'xglobal.par'
      include 'noval.par'
      include 'page.par'
      include 'idfiles.def'
      include 'page.def'
c
      character*( * ) xline
      integer nxl, xcode, addlin, xquery
c
      integer xslen, nn, jj
      external xslen
c
 9110 format (a,:,i4)
c
      xquery = inoval
      if (xcode .eq. teject) then
         thislin = pagelen
c
      elseif (xcode .eq. tqtop) then
         if (thislin .le. lines_in_header) then
            xquery = ttrue
         else
            xquery = tfalse
         endif
c
      elseif (xcode .eq. tqfit) then
         if ((thislin + addlin) .ge. pagelen) then
            xquery = tfalse
         else
            xquery = ttrue
         endif
c
      elseif (xcode .eq. tlines) then
         if (thislin .le. lines_in_header) then
            continue    ! lines at top of page: do nothing
         else
            thislin = thislin + addlin
            if (thislin .ge. pagelen) then
               call opage0()    ! Blank lines to end-of-page: eject
            else
               do jj = 1, addlin
                  write (jout, *)
               enddo
            endif
         endif
c
      elseif (xcode .eq. tprint) then
         if (thislin .ge. pagelen) then
            call opage0()
         endif
c
         if (nxl .ge. 0) then
            nn = nxl
         else
            nn = xslen(xline)
         endif
         if (nn .gt. 0) then
            write (jout, 9110) xline(1:nn)
         else
            write (jout, *)
         endif
         thislin = thislin + 1
c
      elseif (xcode .eq. tinquire) then
         if (addlin .gt. 0) then
            thislin = thislin + addlin
            if (thislin .ge. pagelen) then
               call opage0()
               thislin = thislin + addlin
            endif
         else
            call opage0()
            thislin = thislin - addlin  ! remember: addlin <= 0    
         endif
c
      elseif (xcode .eq. tsethead) then
         if (nxl .ge. 0) then
            nn = nxl
         else
            nn = xslen(xline)
         endif
         if (nn .gt. 0) then
            page_header = xline(1:nn)
            nheader = nn
         else
            page_header = ' '
            nheader = 0
         endif
      else
         write (jout, 9110) '?? Opage error: xcode = ', xcode
      endif
c
      return
      end
      subroutine opage0()
c
c update: 17:44 fri 4-mar-1994.
c issue header; make sure the previous page is not empty;
c;;
      include 'xglobal.par'
      include 'idfiles.def'
      include 'page.def'
c
 9110 format (a,a)
c
      if (lines_in_header .ne. thislin) then
c
         thispag = thispag + 1
         thislin = 0
c
c do not issue a Formfeed before page 1;
c
         if (thispag .gt. 1) then
            write (jout, 9110) formfeed
            thislin = thislin + 1
         endif
c
         if (nheader .gt. 0) then
            write (page_header(72:), '(a,i3)') ' Page', thispag
            write (jout, 9110) ' ', page_header(1:79)
            thislin = thislin + 1
         endif
c
         if (title_set) then
            write (jout, 9110) ' *** ', title_page(1:title_len)
            thislin = thislin + 1
         endif
c
         if (thislin .gt. 0) then
            write (jout, *)
            thislin = thislin + 1
         endif
         lines_in_header = thislin
      endif
c
  110 continue
      return
      end
      subroutine ospecies(nage, kspecies)
c
c update: 16:34 fri 4-mar-1994.
c
c this subroutine outputs age-independent morphological & physiological
c parameters; it will provide resolution info also.
c
c changes in this module should be propagated to "Ospecies" "Sfish2" "Sfish3"
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'numbers.par'
      include 'page.par'
      include 'physio.par'
      include 'simul.par'
      include 'strings.par'
      include 'idfiles.def'
      include 'globpar.def'
      include 'fish.def'
      include 'diet.def'
      include 'options.def'
      include 'heap.def'
c
      integer nage, kspecies
c
      integer nq1, pq1, jprey, xquery, jage, jrange
      integer jallometric, jholling, jlinear, jclearance
      logical lpred, lallometric, lholling, llinear, lclearance
      real d1, d2, rho1, rho2, q10, exx
      external exx
c
 9110 format (5x,3x,a,': ',1pg10.3,' [',a,']')
 9120 format (5x,
     &   'Total Gill Surface Area [cm^2] = sgill1 * wt[g]**sgill2')
 9130 format (5x,'Fraction of gill surface area which ',
     &   'is physiologically active: ',a)
 9140 format (5x,
     &   'Number of lamellae / mm gill filament = rho1 * wt[g]**rho2')
 9150 format (5x,'Lamellar length [cm] = laml1 * wt[g]**laml2')
 9160 format (5x,
     &   'Fish aqueous fraction (pa) = pa1 + pa2*(lipid fraction)')
 9170 format (5x,'Fish weight[g] = lenwt1 * fish_length[cm]**lenwt2')
 9180 format (5x,'Routine respiration [mg o2 consumed/hr]',/,5x,
     &   '= Exp(Ln(Q10)/10 * (T-Tref)) * ox1 * wt[g]**ox2')
 9190 format (5x,'Assimilation efficiency')
 9200 format (5x,'Respiratory quotient [litres CO2 respired/',
     &   'litres O2 consumed]')
 9210 format (5x,'Prey_length[cm] = pred1 + pred2 * predator_length[cm]'
     &   )
 9220 format (5x,'Cmax = maximum observed ingestion [grams/day]',/,5x,
     &   '= Exp(Ln(Q10)/10 * (T-Tref)) * cmax1 * wt[g]**cmax2')
 9230 format (5x,'Fsat = size of satiation meal [gram] consumed during (
     &0, tsat)',/,5x,
     &   '= Exp(Ln(Q10)/10 * (T-Tref)) * fsat1 * wt[g]**fsat2')
 9240 format (5x,'Tsat = time to satiation when feeding with an ',
     &   'initially empty stomach [Min]',/,5x,
     &   '= Exp(Ln(Q10)/10 * (T-Tref)) * tsat1 * wt[g]**tsat2')
 9250 format (5x,'Evac = stomach evacuation [gram/day]',/,5x,
     &   '= Exp(Ln(Q10)/10 * (T-Tref)) * evac1 * ',
     &   'wt[g]**evac2 * I**evac3',/,5x,
     &   'I is the amount of food [grams] resident in the GI track')
 9260 format (5x,'Gamma = linear growth rate [day^-1]',/,5x,
     &   '= Exp(Ln(Q10)/10 * (T-Tref)) * gamma1 * wt[g]**gamma2')
 9270 format (5x,'Cvol = maximum daily clearance volume [litre/day]',/,5
     &   x,'= Exp(Ln(Q10)/10 * (T-Tref)) * cvol1 * wt[g]**cvol2')
c;;
      pq1 = 0
      call heapush(pq1)
      jage = 1
c
c sgill = gill area [cm^2] = sgill1 * wt[g]**sgill2
c
      call opage(tinquire, ' ', 0, 3, xquery)
      write (jout, 9120)
      call owpar(vv_ptyp(vsgill1, jage, kspecies), qhs(pq1), nq1)
      write (jout, 9110) 'sgill1', vv_pval(vsgill1, jage, kspecies), 
     &   qhs(pq1)(1:nq1)
      call owpar(vv_ptyp(vsgill2, jage, kspecies), qhs(pq1), nq1)
      write (jout, 9110) 'sgill2', vv_pval(vsgill2, jage, kspecies), 
     &   qhs(pq1)(1:nq1)
c
      call opage(tinquire, ' ', 0, 1, xquery)
      write (qhs(pq1), '(f5.2)') activegill(kspecies)
      call compress(qhs(pq1), -1, nq1)
      write (jout, 9130) qhs(pq1)(1:nq1)
c
c rho = # lamellae / mm gill filament = rho1 * wt[g]**rho2
c compute lamellar densities from interlamellar distances;
c the same formula should be used in "Dbnorm", "Ofishpar", "Ospecies";
c
c     d[cm] = 0.11815 * rho[# lamellae/mm gill filament] ** (-1.18862)
c
c        d1 * wt * d2 = 0.11815 * (rho1 * wt * rho2) ** (-1.18862)
c
      d1 = vv_pval(vrho1, jage, kspecies)
      d2 = vv_pval(vrho2, jage, kspecies)
      rho1 = (d1 / 0.11815) ** (1.0 / ( -1.18862))
      rho2 = d2 / ( -1.18862)
      call opage(tinquire, ' ', 0, 3, xquery)
      write (jout, 9140)
      call owpar(vv_ptyp(vrho1, jage, kspecies), qhs(pq1), nq1)
      write (jout, 9110) 'rho1', rho1, qhs(pq1)(1:nq1)
      call owpar(vv_ptyp(vrho2, jage, kspecies), qhs(pq1), nq1)
      write (jout, 9110) 'rho2', rho2, qhs(pq1)(1:nq1)
c
c laml = lamellar length [cm] = laml1 * wt[g]**laml2
c
      call opage(tinquire, ' ', 0, 3, xquery)
      write (jout, 9150)
      call owpar(vv_ptyp(vlaml1, jage, kspecies), qhs(pq1), nq1)
      write (jout, 9110) 'laml1', vv_pval(vlaml1, jage, kspecies), 
     &   qhs(pq1)(1:nq1)
      call owpar(vv_ptyp(vlaml2, jage, kspecies), qhs(pq1), nq1)
      write (jout, 9110) 'laml2', vv_pval(vlaml2, jage, kspecies), 
     &   qhs(pq1)(1:nq1)
c
c pa = fraction aqueous = pa1 + pa2*pl  (Barber et al. 1991: pa2 < 0)
c
      call opage(tinquire, ' ', 0, 3, xquery)
      write (jout, 9160)
      call owpar(vv_ptyp(vpa1, jage, kspecies), qhs(pq1), nq1)
      write (jout, 9110) 'pa1', vv_pval(vpa1, jage, kspecies), 
     &   qhs(pq1)(1:nq1)
      call owpar(vv_ptyp(vpa2, jage, kspecies), qhs(pq1), nq1)
      write (jout, 9110) 'pa2', vv_pval(vpa2, jage, kspecies), 
     &   qhs(pq1)(1:nq1)
c
c wt = fish weight[gram] = lenwt1 * fish_length[cm]**lenwt2
c
      call opage(tinquire, ' ', 0, 3, xquery)
      write (jout, 9170)
      call owpar(vv_ptyp(vlenwt1, jage, kspecies), qhs(pq1), nq1)
      write (jout, 9110) 'lenwt1', vv_pval(vlenwt1, jage, kspecies), 
     &   qhs(pq1)(1:nq1)
      call owpar(vv_ptyp(vlenwt2, jage, kspecies), qhs(pq1), nq1)
      write (jout, 9110) 'lenwt2', vv_pval(vlenwt2, jage, kspecies), 
     &   qhs(pq1)(1:nq1)
c
c o2 = routine respiration [mg o2 consumed/ hr]
c    = Exp(Ln(Q10)/10 * (T-Tref)) * ox1 * wt[g]**ox2
c
      call opage(tinquire, ' ', 0, 6, xquery)
      write (jout, 9180)
      call owpar(vv_ptyp(vox1, jage, kspecies), qhs(pq1), nq1)
      write (jout, 9110) ' ox1', vv_pval(vox1, jage, kspecies), 
     &   qhs(pq1)(1:nq1)
      call owpar(vv_ptyp(vox2, jage, kspecies), qhs(pq1), nq1)
      write (jout, 9110) ' ox2', vv_pval(vox2, jage, kspecies), 
     &   qhs(pq1)(1:nq1)
      q10 = exx(vv_pval(voxq10, jage, kspecies) * 10.0)
      call owpar(vv_ptyp(voxq10, jage, kspecies), qhs(pq1), nq1)
      write (jout, 9110) ' Q10', q10, qhs(pq1)(1:nq1)
      call owpar(vv_ptyp(voxt, jage, kspecies), qhs(pq1), nq1)
      write (jout, 9110) 'Tref', vv_pval(voxt, jage, kspecies), 
     &   qhs(pq1)(1:nq1)
c
c assimilation efficiency
c
      call opage(tinquire, ' ', 0, 2, xquery)
      write (jout, 9190)
      call owpar(vv_ptyp(vassxeff, jage, kspecies), qhs(pq1), nq1)
      write (jout, 9110) 'assimilation efficiency', 
     &   vv_pval(vassxeff, jage, kspecies), qhs(pq1)(1:nq1)
c
c respiratory quotient [litres CO2 respired/ litres O2 consumed]
c
      call opage(tinquire, ' ', 0, 2, xquery)
      write (jout, 9200)
      call owpar(vv_ptyp(vrq, jage, kspecies), qhs(pq1), nq1)
      write (jout, 9110) 'respiratory quotient', 
     &   vv_pval(vrq, jage, kspecies), qhs(pq1)(1:nq1)
c
c prey_length [cm] = length of prey for a given predator length
c                  = pred1 + pred2 * predator_length [cm]
c
c if Simul_mode == tfood_chain then required IF the prey is another fish;
c if Simul_mode == tfood_web then
c    required only if some member of its diet is not
c        (plankton | benthos | cfish)
c else not required;
c
      if ((simul_mode .eq. tfood_chain) .or. (simul_mode .eq. tfood_web)
     &   ) then
         lpred = .false.
         jage = 0
         do jrange = 1, range_numof(kspecies)
            do jprey = 1, gnspecies
               lpred = lpred .or. (fdiet(jprey, jrange, kspecies) .gt. 
     &            zero)
               if (lpred) then
                  jage = 1
                  go to 110     ! short circuit loop;                     
               endif
            enddo
         enddo
  110    continue
      else
         lpred = .false.
         jage = 0
      endif
c
      if (lpred) then
         call opage(tinquire, ' ', 0, 3, xquery)
         write (jout, 9210)
         call owpar(vv_ptyp(vpred1, jage, kspecies), qhs(pq1), nq1)
         write (jout, 9110) 'pred1', vv_pval(vpred1, jage, kspecies), 
     &      qhs(pq1)(1:nq1)
         call owpar(vv_ptyp(vpred2, jage, kspecies), qhs(pq1), nq1)
         write (jout, 9110) 'pred2', vv_pval(vpred2, jage, kspecies), 
     &      qhs(pq1)(1:nq1)
      endif
c
      llinear = .false.
      lholling = .false.
      lclearance = .false.
      lallometric = .false.
c
      do jage = 1, nage
         if (vv_growth_model(jage, kspecies) .eq. tallometric) then
            lallometric = .true.
            jallometric = jage
         elseif (vv_growth_model(jage, kspecies) .eq. tholling) then
            lholling = .true.
            jholling = jage
         elseif (vv_growth_model(jage, kspecies) .eq. tlinear) then
            llinear = .true.
            jlinear = jage
         elseif (vv_growth_model(jage, kspecies) .eq. tclearance) then
            lclearance = .true.
            jclearance = jage
         endif
      enddo
c
c gamma = linear growth rate [day^-1]
c       = Exp(Ln(Q10)/10 * (T-Tref)) * gamma1 * wt[g]**gamma2
c
      if (llinear) then
         call opage(tinquire, ' ', 0, 6, xquery)
         write (jout, 9260)
         call owpar(vv_ptyp(vgamma1, jlinear, kspecies), qhs(pq1), nq1)
         write (jout, 9110) 'gamma1', 
     &      vv_pval(vgamma1, jlinear, kspecies), qhs(pq1)(1:nq1)
         call owpar(vv_ptyp(vgamma2, jlinear, kspecies), qhs(pq1), nq1)
         write (jout, 9110) 'gamma2', 
     &      vv_pval(vgamma2, jlinear, kspecies), qhs(pq1)(1:nq1)
         q10 = exx(vv_pval(vgammaq10, jlinear, kspecies) * 10.0)
         call owpar(vv_ptyp(vgammaq10, jlinear, kspecies), qhs(pq1), nq1
     &      )
         write (jout, 9110) '   Q10', q10, qhs(pq1)(1:nq1)
         call owpar(vv_ptyp(vgammat, jlinear, kspecies), qhs(pq1), nq1)
         write (jout, 9110) '  Tref', 
     &      vv_pval(vgammat, jlinear, kspecies), qhs(pq1)(1:nq1)
      endif
c
c cmax = maximum observed ingestion [grams/day]
c      = Exp(Ln(Q10)/10 * (T-Tref)) * cmax1 * wt[g]**cmax2
c
      if (lallometric) then
         call opage(tinquire, ' ', 0, 6, xquery)
         write (jout, 9220)
         call owpar(vv_ptyp(vcmax1, jallometric, kspecies), qhs(pq1), 
     &      nq1)
         write (jout, 9110) 'cmax1', 
     &      vv_pval(vcmax1, jallometric, kspecies), qhs(pq1)(1:nq1)
         call owpar(vv_ptyp(vcmax2, jallometric, kspecies), qhs(pq1), 
     &      nq1)
         write (jout, 9110) 'cmax2', 
     &      vv_pval(vcmax2, jallometric, kspecies), qhs(pq1)(1:nq1)
         q10 = exx(vv_pval(vcmaxq10, jallometric, kspecies) * 10.0)
         call owpar(vv_ptyp(vcmaxq10, jallometric, kspecies), qhs(pq1),
     &      nq1)
         write (jout, 9110) '  Q10', q10, qhs(pq1)(1:nq1)
         call owpar(vv_ptyp(vcmaxt, jallometric, kspecies), qhs(pq1), 
     &      nq1)
         write (jout, 9110) ' Tref', 
     &      vv_pval(vcmaxt, jallometric, kspecies), qhs(pq1)(1:nq1)
      endif
c
c fsat = size [gram] of satiation meal consumed during (0, tsat)
c      = Exp(Ln(Q10)/10 * (T-Tref)) * fsat1 * wt[g]**fsat2
c tsat = time to satiation when feeding with an initially empty stomach [Min]
c      = Exp(Ln(Q10)/10 * (T-Tref)) * tsat1 * wt[g]**tsat2
c evac = stomach evacuation [gram/day]
c      = Exp(Ln(Q10)/10 * (T-Tref)) * evac1 * wt[g]**evac2 * I**evac3
c        in general evac3 = 1/2, 2/3, or 1 (see jobling 1981 j.fish biol.19:245)
c
      if (lholling) then
         call opage(tinquire, ' ', 0, 6, xquery)
         write (jout, 9230)
         call owpar(vv_ptyp(vfsat1, jholling, kspecies), qhs(pq1), nq1)
         write (jout, 9110) 'fsat1', 
     &      vv_pval(vfsat1, jholling, kspecies), qhs(pq1)(1:nq1)
         call owpar(vv_ptyp(vfsat2, jholling, kspecies), qhs(pq1), nq1)
         write (jout, 9110) 'fsat2', 
     &      vv_pval(vfsat2, jholling, kspecies), qhs(pq1)(1:nq1)
         q10 = exx(vv_pval(vfsatq10, jholling, kspecies) * 10.0)
         call owpar(vv_ptyp(vfsatq10, jholling, kspecies), qhs(pq1), nq1
     &      )
         write (jout, 9110) '  Q10', q10, qhs(pq1)(1:nq1)
         call owpar(vv_ptyp(vfsatt, jholling, kspecies), qhs(pq1), nq1)
         write (jout, 9110) ' Tref', 
     &      vv_pval(vfsatt, jholling, kspecies), qhs(pq1)(1:nq1)
c
         call opage(tinquire, ' ', 0, 6, xquery)
         write (jout, 9240)
         call owpar(vv_ptyp(vtsat1, jholling, kspecies), qhs(pq1), nq1)
         write (jout, 9110) 'tsat1', 
     &      vv_pval(vtsat1, jholling, kspecies), qhs(pq1)(1:nq1)
         call owpar(vv_ptyp(vtsat2, jholling, kspecies), qhs(pq1), nq1)
         write (jout, 9110) 'tsat2', 
     &      vv_pval(vtsat2, jholling, kspecies), qhs(pq1)(1:nq1)
         q10 = exx(vv_pval(vtsatq10, jholling, kspecies) * 10.0)
         call owpar(vv_ptyp(vtsatq10, jholling, kspecies), qhs(pq1), nq1
     &      )
         write (jout, 9110) '  Q10', q10, qhs(pq1)(1:nq1)
         call owpar(vv_ptyp(vtsatt, jholling, kspecies), qhs(pq1), nq1)
         write (jout, 9110) ' Tref', 
     &      vv_pval(vtsatt, jholling, kspecies), qhs(pq1)(1:nq1)
c
         call opage(tinquire, ' ', 0, 7, xquery)
         write (jout, 9250)
         call owpar(vv_ptyp(vevac1, jholling, kspecies), qhs(pq1), nq1)
         write (jout, 9110) 'evac1', 
     &      vv_pval(vevac1, jholling, kspecies), qhs(pq1)(1:nq1)
         call owpar(vv_ptyp(vevac2, jholling, kspecies), qhs(pq1), nq1)
         write (jout, 9110) 'evac2', 
     &      vv_pval(vevac2, jholling, kspecies), qhs(pq1)(1:nq1)
         q10 = exx(vv_pval(vevacq10, jholling, kspecies) * 10.0)
         call owpar(vv_ptyp(vevacq10, jholling, kspecies), qhs(pq1), nq1
     &      )
         write (jout, 9110) '  Q10', q10, qhs(pq1)(1:nq1)
         call owpar(vv_ptyp(vevact, jholling, kspecies), qhs(pq1), nq1)
         write (jout, 9110) ' Tref', 
     &      vv_pval(vevact, jholling, kspecies), qhs(pq1)(1:nq1)
      endif
c
c cvol = maximum daily clearance volume [litre/day]
c      = Exp(Ln(Q10)/10 * (T-Tref)) * cvol1 * wt[g]**cvol2
c
      if (lclearance) then
         call opage(tinquire, ' ', 0, 6, xquery)
         write (jout, 9270)
         call owpar(vv_ptyp(vcvol1, jclearance, kspecies), qhs(pq1), nq1
     &      )
         write (jout, 9110) 'cvol1', 
     &      vv_pval(vcvol1, jclearance, kspecies), qhs(pq1)(1:nq1)
         call owpar(vv_ptyp(vcvol2, jclearance, kspecies), qhs(pq1), nq1
     &      )
         write (jout, 9110) 'cvol2', 
     &      vv_pval(vcvol2, jclearance, kspecies), qhs(pq1)(1:nq1)
         q10 = exx(vv_pval(vcvolq10, jclearance, kspecies) * 10.0)
         call owpar(vv_ptyp(vcvolq10, jclearance, kspecies), qhs(pq1), 
     &      nq1)
         write (jout, 9110) '  Q10', q10, qhs(pq1)(1:nq1)
         call owpar(vv_ptyp(vcvolt, jclearance, kspecies), qhs(pq1), nq1
     &      )
         write (jout, 9110) ' Tref', 
     &      vv_pval(vcvolt, jclearance, kspecies), qhs(pq1)(1:nq1)
      endif
c
      call heapop(pq1)
c
      return
      end
      subroutine out0()
c
c update: 16:34 fri 4-mar-1994.
c initial chemical output + simulation chars;
c toxicity data;
c call once per run;
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'habitat.par'
      include 'fish.par'
      include 'page.par'
      include 'simul.par'
      include 'plots.par'
      include 'noval.par'
      include 'phylum.par'
      include 'strings.par'
      include 'idfiles.def'
      include 'globpar.def'
      include 'fish.def'
      include 'lab.def'
      include 'time.def'
      include 'habitat.def'
      include 'chems.def'
      include 'units.def'
      include 'options.def'
      include 'heap.def'
      include 'work.def'
      include 'examsrec.def'
c
c miscellaneous declarations
c
      integer xslen, nvolume, nflow, ntime, xquery
      integer pq1, nq1, jspecies, nage
      integer npredator, nprey, nprey_food
      logical puthead
      external xslen
c
 9110 format (5x,
     &   'during the computation of the initial weight distribution: ')
 9120 format (5x,'. the ',a,' was approximated using a ',i3,
     &   ' term Fourier sine series')
c
 9130 format (5x,'exposure files generated by: ',a)
 9140 format (5x,'starting time: ',1pg10.3,1x,a/,5x,'  ending time: ',1
     &   pg10.3,1x,a/,5x,'        nstep: ',1pg10.3/)
 9150 format (1pg10.3,' [celsius]')
 9160 format (1pg10.3,' +',1pg10.3,' * Sin(',1pg10.3,' * t[day] +',1pg10
     &   .3,')',' [celsius]')
 9170 format (5x,'temperature: ',a)
 9180 format (5x,a,:,a,a)
 9190 format (5x,'simulation mode: ',a)
 9200 format (5x,'      tank flow: ',1pg10.3,1x,a/5x,
     &   '    tank volume: ',1pg10.3,1x,a/5x,'number of fish in tank: ',
     &   i4)
 9210 format (5x,'physiological parameters updated: ',a)
 9220 format (5x,'       predator: "',a,'"')
 9230 format (5x,'           prey: "',a,'"')
 9240 format (5x,'      prey_food: ',a)
 9250 format (5x,'           prey: ',a)
c;;
      pq1 = 0
      call heapush(pq1)
c
c set page header
c
      qhs(pq1) = '*** initial conditions ***'
      call opage(tsethead, qhs(pq1), -1, 0, xquery)
c
      ntime = xslen(pgm_time)
      call opage(tinquire, ' ', 0, 3, xquery)
      write (jout, 9140) simul_beg, pgm_time(1:ntime), simul_end, 
     &   pgm_time(1:ntime), tnstep
c
      if (simul_mode .eq. tlaboratory) then
         nflow = xslen(pgm_flow)
         nvolume = xslen(pgm_volume)
         call opage(tinquire, ' ', 0, 4, xquery)
         write (jout, 9190) 'Laboratory'
         write (jout, 9200) tank_flow, pgm_flow(1:nflow), tank_volume, 
     &      pgm_volume(1:nvolume), nint(tank_nfish)
         call owtable1(jout, gnchem, toxlab, 'food', food_chem_func, 
     &      snoval, food_chem_conc, food_pl, food_bmf)
c
      elseif (simul_mode .eq. tfood_chain) then
         npredator = xslen(fc_spredator)
         nprey = xslen(fc_sprey)
         nprey_food = xslen(fc_sprey_food)
         call opage(tinquire, ' ', 0, 2, xquery)
         write (jout, 9190) 'Food_chain'
         write (jout, 9220) fc_spredator(1:npredator)
c
         if (fc_preyt .eq. tspecies) then
            call opage(tinquire, ' ', 0, 2, xquery)
            write (jout, 9230) fc_sprey(1:nprey)
            write (jout, 9240) fc_sprey_food(1:nprey_food)
            if (fc_prey_foodt .eq. tplankton) then
               call owtable1(jout, gnchem, toxlab, 'plankton', 
     &            plankton_chem_func, planktonfil, plankton_chem_conc, 
     &            plankton_pl, plankton_bmf)
            elseif (fc_prey_foodt .eq. tbenthos) then
               call owtable1(jout, gnchem, toxlab, 'benthos', 
     &            benthos_chem_func, benthosfil, benthos_chem_conc, 
     &            benthos_pl, benthos_bmf)
            elseif (fc_prey_foodt .eq. tcfish) then
               call owtable1(jout, gnchem, toxlab, 'prey_food', 
     &            cfish_chem_func, cfishfil, cfish_chem_conc, cfish_pl,
     &            cfish_bmf)
            endif
c
         elseif (fc_preyt .eq. tplankton) then
            call opage(tinquire, ' ', 0, 1, xquery)
            write (jout, 9250) fc_sprey_food(1:nprey_food)
            call owtable1(jout, gnchem, toxlab, 'plankton', 
     &         plankton_chem_func, planktonfil, plankton_chem_conc, 
     &         plankton_pl, plankton_bmf)
         elseif (fc_preyt .eq. tbenthos) then
            call opage(tinquire, ' ', 0, 1, xquery)
            write (jout, 9250) fc_sprey_food(1:nprey_food)
            call owtable1(jout, gnchem, toxlab, 'benthos', 
     &         benthos_chem_func, benthosfil, benthos_chem_conc, 
     &         benthos_pl, benthos_bmf)
         elseif (fc_preyt .eq. tcfish) then
            call opage(tinquire, ' ', 0, 1, xquery)
            write (jout, 9250) fc_sprey_food(1:nprey_food)
            call owtable1(jout, gnchem, toxlab, 'prey_food', 
     &         cfish_chem_func, cfishfil, cfish_chem_conc, cfish_pl, 
     &         cfish_bmf)
         endif
c
      else
         call opage(tinquire, ' ', 0, 1, xquery)
         write (jout, 9190) 'Food_web'
         if (xplankton) then
            call owtable1(jout, gnchem, toxlab, 'plankton', 
     &         plankton_chem_func, planktonfil, plankton_chem_conc, 
     &         plankton_pl, plankton_bmf)
         endif
         if (xbenthos) then
            call owtable1(jout, gnchem, toxlab, 'benthos', 
     &         benthos_chem_func, benthosfil, benthos_chem_conc, 
     &         benthos_pl, benthos_bmf)
         endif
         if (xcfish) then
            call owtable1(jout, gnchem, toxlab, 'cfish', 
     &         cfish_chem_func, cfishfil, cfish_chem_conc, cfish_pl, 
     &         cfish_bmf)
         endif
      endif
c
ccc 9264 format (5x, 'gut formulation: ', a)
ccc      call Opage(tinquire, ' ', 0, 1, xquery)
ccc      if (Xsteady_state_gut) then
ccc         write (Jout, 9264) 'dG/dt = 0'
ccc      else
ccc         write (Jout, 9264) 'dG/dt = o.d.e.'
ccc      endif
      call opage(tinquire, ' ', 0, 1, xquery)
      if (xupdate_continuously) then
         write (jout, 9210) 'continuously'
      else
         write (jout, 9210) 'daily'
      endif
c
      if (xexams) then
         if (exams_mode .eq. 1) then
            write (jout, 9130) 'Exams, mode 1 (steady state)'
         elseif (exams_mode .eq. 2) then
            write (jout, 9130) 'Exams, mode 2 (segmented initial value)'
         elseif (exams_mode .eq. 3) then
            write (jout, 9130) 'Exams, mode 3 (seasonal dynamics)'
         else
            write (jout, 9130) 'Exams, mode ? (unknown)'
         endif
      else
         write (jout, 9130) 'User'
      endif
c
      if (twfunc .eq. tfile) then
         nq1 = xslen(cwfil)
         qhs(pq1) = 'file "' // cwfil(1:nq1) // '"'
      elseif (twfunc .eq. tconstant) then
         write (qhs(pq1), 9150) twpar(1)
      elseif (twfunc .eq. tsin) then
         write (qhs(pq1), 9160) twpar(1), twpar(2), twpar(3), twpar(4)
      endif
      call compress(qhs(pq1), -1, nq1)
      call opage(tinquire, ' ', 0, 1, xquery)
      write (jout, 9170) qhs(pq1)(1:nq1)
c
      if (dplankton) then
         if (plankton_standing_stock_func .eq. tfile) then
            nq1 = xslen(planktonfil)
            qhs(pq1) = 'file "' // planktonfil(1:nq1) // '")'
            nq1 = index(qhs(pq1), ')') - 1
            call opage(tinquire, ' ', 0, 1, xquery)
            write (jout, 9180) 'plankton standing stock: ', 
     &         qhs(pq1)(1:nq1)
         elseif (plankton_standing_stock_func .eq. tconstant) then
            qhs(pq1) = 'constant '
            nq1 = index(qhs(pq1), ' ') + 2
            write (qhs(pq1)(nq1:), '(1pg10.3)') 
     &         plankton_standing_stock_conc
            call compress(qhs(pq1), -1, nq1)
            call opage(tinquire, ' ', 0, 1, xquery)
            write (jout, 9180) 'plankton standing stock: ', 
     &         qhs(pq1)(1:nq1), ' [grams/Litre]'
         endif
      endif
c
      if ((simul_mode .eq. tfood_web) .and. (xfourier) .and. (xwt0)) 
     &   then
         puthead = (twfunc .eq. tfile) .or. ((xplankton) .and. (
     &      plankton_standing_stock_func .eq. tfile))
         if (puthead) then
            call opage(tinquire, ' ', 0, 4, xquery)
            write (jout, *)
            write (jout, 9110)
            if (twfunc .eq. tfile) then
               write (jout, 9120) 'water temperature', mtw
            endif
            if (xplankton) then
               if (plankton_standing_stock_func .eq. tfile) then
                  write (jout, 9120) 'plankton standing stock', mpss
               endif
            endif
         endif
      endif
c
      call ochem()
c
      call opage(tlines, ' ', 0, 3, xquery)
      do jspecies = 1, gnspecies
         nage = xmaximum_age(jspecies)
         call owpezall(jspecies, nage)
      enddo
c
      call owdiet()
c
      call heapop(pq1)
c
      return
      end
      subroutine out1()
c
c update: 11:45 fri 9-sep-1994.
c output yearly stuff
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'page.par'
      include 'strings.par'
c
      include 'errors.def'
      include 'globpar.def'
      include 'heap.def'
      include 'lab.def'
      include 'options.def'
      include 'time.def'
      include 'units.def'
c
      integer edadp(maxage), jspecies, nage, xquery
      integer nt0, nt1, pq1, nq1, pq2
      real rt0, rt1
      logical trne
      external trne
c
      if (xlast_year_only) then
         if (trne(simul_end, time_end)) go to 110
      endif
c
      pq1 = 0
      pq2 = 0
      call heapush(pq1)
      call heapush(pq2)
c
      rt0 = time_beg / one_year ! set header                     
      rt1 = time_end / one_year
      nt0 = nint(rt0)
      nt1 = nint(rt1)
      if (nt0 .ne. nt1) then
         write (qhs(pq1), '(i3,a,i3)') nt0, ' - ', nt1
      else
         write (qhs(pq1), '(f7.1,a,f7.1)') rt0, ' - ', rt1
      endif
      call compress(qhs(pq1), -1, nq1)
      qhs(pq2) = '*** summary of years ' // qhs(pq1)(1:nq1) // ' ***'
      call opage(tsethead, qhs(pq2), -1, 0, xquery)
c
      call ow2()        ! time dependent simulation pars and chemical stuff 
      do jspecies = 1, gnspecies        ! for each species   
         call agesort(jspecies, nage, edadp)
         call ow3(jspecies, nage, edadp)        ! growth stuff       
         call ow4(jspecies, nage, edadp)        ! chem stuff         
      enddo
c
      call heapop(pq2)
      call heapop(pq1)
c
c [tofix] 10:36 wed 17-aug-1994.
c create a global error variable, check it at appropriate places, and
c exit all the way to "Irun", in order to give the user the ability
c to correct the problem;
c
      if (haltsimul) then
         xouton = .true.
         call tee(' ', 1)
         call tee('?? Errors detected, Simulation stopped.', -1)
         call tee(' ', 1)
         xouton = .false.
         stop '  '
      endif
c
  110 continue
      return
      end
      subroutine out2()
c
c update: 16:00 tue 5-apr-1994.
c closing ceremonies; call once per run (at the very end)
c warning: data will be modified after the call to "Owfile" ;
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'noval.par'
      include 'page.par'
      include 'simul.par'
      include 'idfiles.def'
      include 'options.def'
c
c miscellaneous declarations
c
      integer edadp(maxage), nage, jfile, xquery
c
      call opage(tsethead, '*** Updated Command File', -1, 0, xquery)
      call opage(tinquire, ' ', 0, 0, xquery)
      jfile = jout
      call owfile(zioappend, jfile, nage, edadp)
c
      if (xupdate_input) then
         jfile = inoval
         call owfile(tnew, jfile, nage, edadp)
      endif
c
      return
      end
      subroutine ow2()
c
c update: 11:45 fri 9-sep-1994.
c call once per segment.
c
c changes in "kfeces" should be propagated to "Kdbdtgf", "Ksave1"
c                                             "Ow2", "Labode"
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'habitat.par'
      include 'fish.par'
      include 'numbers.par'
      include 'page.par'
      include 'phylum.par'
      include 'plots.par'
      include 'simul.par'
      include 'strings.par'
      include 'idfiles.def'
      include 'globpar.def'
      include 'fish.def'
      include 'lab.def'
      include 'fluxes.def'
      include 'odevar.def'
      include 'options.def'
      include 'chems.def'
      include 'habitat.def'
      include 'work.def'
      include 'units.def'
      include 'heap.def'
c
      integer pq1, pq2, ntt, addlin, xquery
      integer ntime, xslen, jchem, jage, jspecies, ntox, nmass
      real zz, zk, kfeces, atotal, awater, aorganic, dtt
      logical treq, issuepage
      external treq, xslen
c
 9110 format (1x,'"',a,'", year class ',i2,' died at ',1pg10.3,1x,a)
 9120 format (' *** simulation specifications ***')
 9130 format ('     Time_beg: ',1pg10.3,1x,a/'     Time_end: ',1pg10.3,1
     &   x,a)
 9140 format ('     prey_end: ',1pg10.3,1x,a)
 9150 format (/,'     mass of feces (organic carbon) in tank: ',1pg10.3,
     &   1x,a)
c
c a20 for chemical name
c
c                                ! toxicant name
c                                ! organic phase
 9160 format (5x,a20,1x,2x,a13,2x,a13)
c                                ! aqueous phase
c
c                                ! toxicant name
c                                ! organic phase
 9170 format (5x,a20,1x,2x,1pg10.3,3x,2x,1pg10.3)
c                                ! aqueous phase
c;;
      pq1 = 0
      pq2 = 0
      call heapush(pq1)
      call heapush(pq2)
c
      addlin = 1 + 2
      if (simul_mode .eq. tfood_chain) then
         addlin = addlin + 1
      elseif (simul_mode .eq. tlaboratory) then
         addlin = addlin + 6 + gnchem + 1
      endif
      call opage(tinquire, ' ', 0, -addlin, xquery)     ! (1)           
c
c compute mean cwater and temperature during the simulation;
c
      if (treq(dtcw, zero)) dtcw = one
      twmean = twmean / dtcw    ! calculate mean temperature
      do jchem = 1, gnchem      ! calculate mean cwater 
         cwmean(jchem) = cwmean(jchem) / dtcw
      enddo
c
      ntime = xslen(pgm_time)
      do jspecies = 1, gnspecies
         do jage = 1, xmaximum_age(jspecies)
            if (treq(dtfish(jage, jspecies), zero)) 
     &         dtfish(jage, jspecies) = one
            dtt = dtfish(jage, jspecies)
            do jchem = 1, gnchem
               cfmean(jchem, jage, jspecies) = 
     &            cfmean(jchem, jage, jspecies) / dtt
               cpmean(jchem, jage, jspecies) = 
     &            cpmean(jchem, jage, jspecies) / dtt
            enddo
         enddo
      enddo
c
c initial header
c
      write (jout, 9120)
      write (jout, 9130) time_beg, pgm_time(1:ntime), time_end, 
     &   pgm_time(1:ntime)
c
      if (simul_mode .eq. tfood_chain) then
         if (fc_preyt .eq. tspecies) then
            write (jout, 9140) prey_maxtime, pgm_time(1:ntime)
         endif
c
      elseif (simul_mode .eq. tlaboratory) then
         nmass = xslen(pgm_mass)
         write (jout, 9150) woc, pgm_mass(1:nmass)
         write (jout, *)
         write (jout, 9160) '                    ', ' Chemical in ', 
     &      ' Chemical in '
         write (jout, 9160) '                    ', 'organic phase', 
     &      'aqueous phase'
         write (jout, 9160) 'Toxicant name       ', ' [microgram] ', 
     &      ' [microgram] '
         write (jout, 9160) '--------------------', '-------------', 
     &      '-------------'
c
         zz = woc / tank_volume
         do jchem = 1, gnchem
            ntt = 20    ! "20" : see note above    ! Xslen(Toxlab(jchem))
            kfeces = koc(jchem)
            zk = zz * kfeces
            atotal = amt_in_tank(jchem)
            awater = atotal / (one + zk)
            aorganic = atotal * zk / (one + zk)
            write (jout, 9170) toxlab(jchem)(1:ntt), aorganic, awater
         enddo
         write (jout, *)
      endif
c
c the Opage "! (1)" will cover to this point;
c any deaths ??
c
      call ocfca()
      call opage(tlines, ' ', 0, 1, xquery)
c
c plot cw vs time
c
      if (xcw_t) then
         call opage(tlines, ' ', 0, 1, xquery)
         qhs(pq2) = 'chemical''s water conc. [ppm]'
         issuepage = .true.
         do jchem = 1, gnchem
            ntox = xslen(toxlab(jchem))
            qhs(pq1) = 'aqueous concentration of ' // 
     &         toxlab(jchem)(1:ntox)
            call pltchem(cc_tcal, hcw(1, jchem), cc_nxy, pgm_time, 
     &         qhs(pq2), qhs(pq1), xdata, issuepage)
         enddo
      endif
c
      call heapop(pq2)
      call heapop(pq1)
c
      return
      end
      subroutine ow3(kspecies, nage, edadp)
c
c update: 17:56 fri 4-mar-1994.
c for each fish species: growth
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'habitat.par'
      include 'numbers.par'
      include 'ode.par'
      include 'page.par'
      include 'phylum.par'
      include 'plots.par'
      include 'strings.par'
c
      include 'fish.def'
      include 'fluxes.def'
      include 'habitat.def'
      include 'heap.def'
      include 'idfiles.def'
      include 'lab.def'
      include 'ode.def'
      include 'odevar.def'
      include 'options.def'
      include 'plottmp.def'
      include 'work.def'
c
      integer kspecies, nage, edadp( * )
c
c miscellaneous declarations
c
      integer agep, pq1, nq1, jage, xslen, nspp, pq2, nq2
      integer addlin, xquery
      external xslen
c
c declarations for regression vars
c
      logical vused(maxpoints), toprint
      integer np1, np2, nbeg
      real xbar, ybar, ssx, ssy, ssxy, sse
      real rp, gamma1, gamma2
c
 9110 format ('*** year class ',i2,' ***')
 9120 format (/,1x,a)
 9130 format (' *** statistics of growth for "',a,'" ***')
 9140 format (5x,'mean temperature: ',1pg10.3,' c')
 9150 format (5x,'Log10(growth rate[g/g/day]): ',a)
 9160 format (5x,'mean growth rate: ',a)
 9170 format (1pg10.3,:,' + ',1pg10.3,' Log10(w[g])')
 9180 format (1pg10.3,' [g/g/day]')
 9190 format (5x,'                        r^2: ',1pg10.3)
c
 9200 format (a7,7(1x,a12))
 9210 format (i4,3x,7(1x,1pg10.3,2x))
 9220 format (7x,7(1x,1pg10.3,2x))
c;;
      pq1 = 0
      pq2 = 0
      call heapush(pq1)
      call heapush(pq2)
c
      nspp = xslen(spplab(kspecies))
c
      call opage(tinquire, ' ', 0, -2, xquery)
      write (jout, 9130) spplab(kspecies)(1:nspp)
      write (jout, 9140) twmean
c
      do jage = 1, nage
         agep = edadp(jage)
         write (qhs(pq1), 9110) jage
         call compress(qhs(pq1), -1, nq1)
         call opage(tinquire, ' ', 0, 3, xquery)
         write (jout, 9120) qhs(pq1)(1:nq1)
         qq_wgamma(agep, kspecies) = qq_igamma(agep, kspecies) / 
     &      dtfish(agep, kspecies)
         write (qhs(pq1), 9180) qq_wgamma(agep, kspecies)
         call compress(qhs(pq1), -1, nq1)
         write (jout, 9160) qhs(pq1)(1:nq1)
c
         qhs(pq1) = 'Log-Log'
         if (qq_nxy(agep, kspecies) .ge. 3) then
            nbeg = 1
            call logreg(qhs(pq1), mach_eps, nbeg, 
     &         qq_nxy(agep, kspecies), qq_wcal(1, agep, kspecies), 
     &         qq_hgamma(1, agep, kspecies), vused, xbar, ybar, ssx, 
     &         ssy, ssxy, sse, gamma1, gamma2, rp)
            write (qhs(pq1), 9170) gamma1, gamma2
            call compress(qhs(pq1), -1, nq1)
            np1 = index(qhs(pq1), '+ -')
            if (np1 .gt. 0) then        ! eliminate "+ -"       
               np2 = np1 + len('+ -')
               qhs(pq2) = qhs(pq1)(1:np1 - 1) // '- ' // 
     &            qhs(pq1)(np2:nq1)
               nq2 = np1 + 2 + nq1 - np2
               nq1 = nq2
               qhs(pq1) = qhs(pq2)(1:nq2)
            endif
c
            call opage(tinquire, ' ', 0, 2, xquery)
            write (jout, 9150) qhs(pq1)(1:nq1)
            write (jout, 9190) rp ** 2
         endif
      enddo
c
      call opage(tlines, ' ', 0, 2, xquery)
c
      addlin = 4 + nage + 2
      call opage(tinquire, ' ', 0, addlin, xquery)
c
      write (jout, 9200) '  age  ', '    total   ', '   total    ', 
     &   '    total   ', '    total   ', '    total   ', '    total   ',
     &   '   final    '
      write (jout, 9200) '       ', '  ingestion ', 'assimilation', 
     &   '  egestion  ', '  excretion ', ' respiration', '     sda    ',
     &   '   weight   '
      write (jout, 9200) '[years]', '   [grams]  ', '  [grams]   ', 
     &   '   [grams]  ', '   [grams]  ', '   [grams]  ', '   [grams]  ',
     &   '  [grams]   '
      write (jout, 9200) '-------', '------------', '------------', 
     &   '------------', '------------', '------------', '------------',
     &   '------------'
c
c initialize counters for cumulative stats
c
      ux(1) = zero      ! Qq_iingest                           
      ux(2) = zero      ! Qq_iassim                            
      ux(3) = zero      ! Qq_iegest                            
      ux(4) = zero      ! Qq_iexcret                           
      ux(5) = zero      ! Qq_irespir                           
      ux(6) = zero      ! Qq_isda                              
      do jage = 1, nage
         agep = edadp(jage)
         write (jout, 9210) jage, qq_iingest(agep, kspecies), 
     &      qq_iassim(agep, kspecies), qq_iegest(agep, kspecies), 
     &      qq_iexcret(agep, kspecies), qq_irespir(agep, kspecies), 
     &      qq_isda(agep, kspecies), qq_wt(1, agep, kspecies)
         ux(1) = ux(1) + qq_iingest(agep, kspecies)
         ux(2) = ux(2) + qq_iassim(agep, kspecies)
         ux(3) = ux(3) + qq_iegest(agep, kspecies)
         ux(4) = ux(4) + qq_iexcret(agep, kspecies)
         ux(5) = ux(5) + qq_irespir(agep, kspecies)
         ux(6) = ux(6) + qq_isda(agep, kspecies)
      enddo
c
c the cumulative stats only are valid after the transient behaviour has passed.
c
      if (xtotals) then
         toprint = ((nyears .ge. nage) .and. (nage .gt. 1))
         if (toprint) then
            write (jout, 9200) '       ', '------------', 
     &         '------------', '------------', '------------', 
     &         '------------', '------------', '            '
            write (jout, 9220) ux(1), ux(2), ux(3), ux(4), ux(5), ux(6)
         endif
      endif
c
      call pltgamma(kspecies, nage, edadp)
c
      call heapop(pq2)
      call heapop(pq1)
c
      return
      end
      subroutine ow4(jspecies, nage, edadp)
c
c update: 16:34 fri 4-mar-1994.
c for each fish species: chemical stuff
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'habitat.par'
      include 'numbers.par'
      include 'page.par'
      include 'phylum.par'
      include 'plots.par'
      include 'strings.par'
c
      include 'chems.def'
      include 'fish.def'
      include 'fluxes.def'
      include 'globpar.def'
      include 'habitat.def'
      include 'heap.def'
      include 'idfiles.def'
      include 'lab.def'
      include 'obsdata.def'
      include 'odevar.def'
      include 'options.def'
      include 'plottmp.def'
      include 'units.def'
      include 'work.def'
c
      integer jspecies, nage, edadp( * )
c
c miscellaneous declarations for counters and auxiliary i/o variables
c
      integer jchem, pq1, nq1, agep, jage, addlin, xquery
      integer nspp, ntox, xslen, kobs, phlab, pxlab, pylab
      real logkf, logcfcw
      logical issuepage, toprint
      external xslen
c
c                                   ! age
c                                   ! mean body conc
c                                   ! Log(Kf)
c                                   ! Log(Cf/Cw)
c                                   ! gill uptake
c                                   ! gill excretion
c                                   ! gut uptake
c                                   ! gut excretion
 9110 format (1x,a3,2x,a11,2x,a7,2x,a10,2x,a11,2x,a14,2x,a11,2x,a13,2x,
     &   a11,2x)        ! mean prey conc
c
c                                   ! age
c                                   ! mean body conc
c                                   ! Log(Kf)
c                                   ! Log(Cf/Cw)
c                                   ! gill uptake
c                                   ! gill excretion
c                                   ! gut uptake
c                                   ! gut excretion
 9120 format (1x,i2,1x,2x,1pg10.3,2x,1x,1x,0pf5.2,1x,2x,2x,0pf5.2,3x,2x,
     &   1pg10.3,1x,2x,1pg10.3,4x,2x,1pg10.3,1x,2x,1pg10.3,2x,3x,1pg10.3
     &   )
c                                   ! mean prey conc
c
c                                   ! skip age
c                                   ! mean body conc
c                                   ! skip Log(Kf)
c                                   ! skip Log(Cf/Cw)
c                                   ! gill uptake
c                                   ! gill excretion
c                                   ! gut uptake
c                                   ! gut excretion
 9130 format (1x,3x,2x,1pg10.3,2x,1x,7x,2x,10x,2x,1pg10.3,1x,2x,1pg10.3,
     &   4x,2x,1pg10.3,1x,2x,1pg10.3,2x,3x,1pg10.3)
c                                   ! mean prey conc
 9140 format (' *** exchange of ',a,' ***'/)
 9150 format ('     mean water concentration: ',1pg10.3,' ppm'/)
c;;
      pq1 = 0   ! assign heap storage            
      pxlab = 0
      pylab = 0
      phlab = 0
      call heapush(pq1)
      call heapush(pxlab)
      call heapush(pylab)
      call heapush(phlab)
c
c the cumulative stats only are valid after the transient behaviour has passed.
c
      toprint = ((nyears .ge. nage) .and. (nage .gt. 1))
c
      nspp = xslen(spplab(jspecies))
c
      do jchem = 1, gnchem
         ntox = xslen(toxlab(jchem))
         qhs(pq1) = toxlab(jchem)(1:ntox) // ' by ' // 
     &      spplab(jspecies)(1:nspp)
         nq1 = xslen(qhs(pq1))
c
         addlin = 2 + 2 + 3 + nage + 2
         call opage(tinquire, ' ', 0, -addlin, xquery)
         write (jout, 9140) qhs(pq1)(1:nq1)
         write (jout, 9150) cwmean(jchem)
c
c initialize counters for cumulative stats
c
         ux(1) = zero   ! mean body conc                    
         ux(2) = zero   ! gill uptake                       
         ux(3) = zero   ! gill excretion                    
         ux(4) = zero   ! gut uptake                        
         ux(5) = zero   ! gut excretion                     
         ux(6) = zero   ! mean prey conc                    
c
         write (jout, 9110) '   ', 'mean body  ', ' final ', 
     &      '  final   ', 'gill uptake', 'gill excretion', 
     &      'gut uptake ', 'gut excretion', 'mean prey  '
         write (jout, 9110) 'age', 'conc. [ppm]', 'Log(Kf)', 
     &      'Log(Cf/Cw)', '[microgram]', ' [microgram]  ', 
     &      '[microgram]', ' [microgram] ', 'conc. [ppm]'
         write (jout, 9110) '---', '-----------', '-------', 
     &      '----------', '-----------', '--------------', 
     &      '-----------', '-------------', '-----------'
c
         do jage = 1, nage
            agep = edadp(jage)  ! thermodynamic bioconc factor
            logkf = log10(qq_kf(jchem, agep, jspecies))
            if (cwmean(jchem) .gt. zero) then
               logcfcw = log10(qq_cfj(jchem, agep, jspecies) / 
     &            cwmean(jchem))
            else
               logcfcw = zero
            endif
            write (jout, 9120) jage, cfmean(jchem, agep, jspecies), 
     &         logkf, logcfcw, qq_jgilup(jchem, agep, jspecies), 
     &         qq_jgilex(jchem, agep, jspecies), 
     &         qq_jgutup(jchem, agep, jspecies), 
     &         qq_jgutex(jchem, agep, jspecies), 
     &         cpmean(jchem, agep, jspecies)
            ux(1) = ux(1) + cfmean(jchem, agep, jspecies)
            ux(2) = ux(2) + qq_jgilup(jchem, agep, jspecies)
            ux(3) = ux(3) + qq_jgilex(jchem, agep, jspecies)
            ux(4) = ux(4) + qq_jgutup(jchem, agep, jspecies)
            ux(5) = ux(5) + qq_jgutex(jchem, agep, jspecies)
            ux(6) = ux(6) + cpmean(jchem, agep, jspecies)
         enddo
c
         if (xtotals) then
            if (toprint) then
               ux(1) = ux(1) / real(nage)
               ux(6) = ux(6) / real(nage)
               write (jout, 9110) '   ', '-----------', '       ', 
     &            '          ', '-----------', '--------------', 
     &            '-----------', '-------------', '-----------'
               write (jout, 9130) ux(1), ux(2), ux(3), ux(4), ux(5), 
     &            ux(6)
            endif
         endif
c
c done with year classes;
c for each chemical: plot age-related chemical stuff
c
         call opage(tlines, ' ', 0, 2, xquery)
         issuepage = .false.
c
         if (xcfxt) then        ! plot concentration dynamics vs. time       
            qhs(pylab) = 'whole body concentration (ppm)'
            qhs(phlab) = 'exchange of ' // toxlab(jchem)(1:ntox) // 
     &         ' by ' // spplab(jspecies)(1:nspp)
            if (data_t(jspecies) .and. data_c(jspecies)) then
               kobs = nobs(jspecies)
            else
               kobs = 0
            endif
            call plttcf(jchem, jspecies, nage, edadp, tobs, cfobs, kobs,
     &         qq_tcal, qq_cfcal, qq_nxy, pgm_time, qhs(pylab), 
     &         qhs(phlab), xdata, issuepage)
         endif
c
         if (xcfxwt) then       ! plot concentration dynamics vs. fish's body weight
            qhs(pylab) = 'whole body concentration (ppm)'
            qhs(pxlab) = 'wt, gram live'
            qhs(phlab) = 'exchange of ' // toxlab(jchem)(1:ntox) // 
     &         ' by ' // spplab(jspecies)(1:nspp)
            if (data_w(jspecies) .and. data_c(jspecies)) then
               kobs = nobs(jspecies)
            else
               kobs = 0
            endif
            call plttcf(jchem, jspecies, nage, edadp, wobs, cfobs, kobs,
     &         qq_wcal, qq_cfcal, qq_nxy, qhs(pxlab), qhs(pylab), 
     &         qhs(phlab), xdata, issuepage)
         endif
      enddo
c
      call heapop(phlab)
      call heapop(pylab)
      call heapop(pxlab)
      call heapop(pq1)  ! release heap storage                 
c
c and now ..., ladies and gentlemen ..., for you viewing enjoyment ...
c THE REST OF THE PLOTS !
c
      call plt0(jspecies, nage, edadp)
c
      return
      end
      subroutine owage2(nage, kspecies)
c
c update: 16:34 fri 4-mar-1994.
c
c this subroutine outputs age-independent morphological & physiological
c parameters; it will provide resolution info also.
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'page.par'
      include 'physio.par'
      include 'simul.par'
      include 'strings.par'
      include 'idfiles.def'
      include 'globpar.def'
      include 'fish.def'
      include 'diet.def'
      include 'options.def'
      include 'units.def'
      include 'heap.def'
c
      integer nage, kspecies
c
      integer nq1, pq1, nq2, pq2, nq3, pq3, nq4, pq4
      integer kp1, kp2, kp3, kp4
      integer xslen, addlin, xquery, jage, nmass, ks
      external xslen
c
 9110 format (1pg10.3)
 9120 format (3x,a,': ',1pg10.3,' [',a,']')
 9130 format (5x,a)
c
      pq1 = 0
      pq2 = 0
      pq3 = 0
      pq4 = 0
      call heapush(pq1)
      call heapush(pq2)
      call heapush(pq3)
      call heapush(pq4)
c
      ks = kspecies
      nmass = xslen(pgm_mass)
c
c build table header
c
      kp1 = 1
      kp2 = 6
      kp3 = 22
      kp4 = 40
c
c                    kp1  kp2             kp3               kp4
c                            10        20        30        40        50
c                    123456789=123456789=123456789=123456789=123456789=12345
      qhs(pq1) = 
     &   'Age  Initial Weight    Growth model    Lipid fraction (pl)'
      qhs(pq2) = ' '
      qhs(pq2)(kp2:) = ' [' // pgm_mass(1:nmass) // ' live]'
      qhs(pq2)(kp3:) = '(func. response)'
      qhs(pq3) = 
     &   '---  --------------  ----------------  -------------------'
      nq1 = xslen(qhs(pq1))
      nq2 = xslen(qhs(pq2))
      nq3 = xslen(qhs(pq3))
c
c addlin: Blank line + 3 lines (table header) + one table entry
c
      addlin = 1 + 3 + min(1, nage)
      call opage(tqfit, ' ', 0, addlin, xquery)
      if (xquery .eq. tfalse) then
         call opage(tinquire, ' ', 0, 0, xquery)
      endif
c
      call opage(tqtop, ' ', 0, 0, xquery)
      if (xquery .eq. tfalse) then
         call opage(tlines, ' ', 0, 1, xquery)
      endif
c
      call opage(tinquire, ' ', 0, 3, xquery)
      write (jout, 9130) qhs(pq1)(1:nq1)
      write (jout, 9130) qhs(pq2)(1:nq2)
      write (jout, 9130) qhs(pq3)(1:nq3)
c
      do jage = 1, nage
         qhs(pq1) = ' '
         qhs(pq2) = ' '
         qhs(pq3) = ' '
         write (qhs(pq1)(kp1:), '(i2)') jage
         write (qhs(pq1)(kp2:), 9110) vv_iniwt(jage, ks)
         if (vv_growth_model(jage, ks) .eq. tallometric) then
            write (qhs(pq4), 9110) vv_functional_response(jage, ks)
            call compress(qhs(pq4), -1, nq4)
            qhs(pq1)(kp3:) = 'Allometric'
            qhs(pq2)(kp3:) = '(' // qhs(pq4)(1:nq4) // ')'
         elseif (vv_growth_model(jage, ks) .eq. tholling) then
            write (qhs(pq4), 9110) vv_functional_response(jage, ks)
            call compress(qhs(pq4), -1, nq4)
            qhs(pq1)(kp3:) = 'Holling'
            qhs(pq2)(kp3:) = '(' // qhs(pq4)(1:nq4) // ')'
         elseif (vv_growth_model(jage, ks) .eq. tclearance) then
            write (qhs(pq4), 9110) vv_functional_response(jage, ks)
            call compress(qhs(pq4), -1, nq4)
            qhs(pq1)(kp3:) = 'Clearance'
            qhs(pq2)(kp3:) = '(' // qhs(pq4)(1:nq4) // ')'
         elseif (vv_growth_model(jage, ks) .eq. tlinear) then
            qhs(pq1)(kp3:) = 'Linear'
         endif
c
c pl = fraction lipid = pl1 * wt[g]**pl2
c pl = pl1
c pl = pl1  +  pl2 * wt[g]
c
         if ((vv_plfunc(jage, ks) .eq. tallometric) .or. (
     &      vv_plfunc(jage, ks) .eq. tdatabase) .or. (
     &      vv_plfunc(jage, ks) .eq. tfishpar)) then
            qhs(pq1)(kp4:) = 'pl = pl1 * wt[g]**pl2'
            call owpar(vv_ptyp(vpl1, jage, ks), qhs(pq4), nq4)
            write (qhs(pq2)(kp4:), 9120) 'pl1', vv_pval(vpl1, jage, ks),
     &         qhs(pq4)(1:nq4)
            call owpar(vv_ptyp(vpl2, jage, ks), qhs(pq4), nq4)
            write (qhs(pq3)(kp4:), 9120) 'pl2', vv_pval(vpl2, jage, ks),
     &         qhs(pq4)(1:nq4)
         elseif (vv_plfunc(jage, ks) .eq. tconstant) then
            qhs(pq1)(kp4:) = 'pl = pl1'
            call owpar(vv_ptyp(vpl1, jage, ks), qhs(pq4), nq4)
            write (qhs(pq2)(kp4:), 9120) 'pl1', vv_pval(vpl1, jage, ks),
     &         qhs(pq4)(1:nq4)
         elseif (vv_plfunc(jage, ks) .eq. tlinear) then
            qhs(pq1)(kp4:) = 'pl = pl1  +  pl2 * wt[g]'
            call owpar(vv_ptyp(vpl1, jage, ks), qhs(pq4), nq4)
            write (qhs(pq2)(kp4:), 9120) 'pl1', vv_pval(vpl1, jage, ks),
     &         qhs(pq4)(1:nq4)
            call owpar(vv_ptyp(vpl2, jage, ks), qhs(pq4), nq4)
            write (qhs(pq3)(kp4:), 9120) 'pl2', vv_pval(vpl2, jage, ks),
     &         qhs(pq4)(1:nq4)
         endif
c
         nq1 = xslen(qhs(pq1))
         nq2 = xslen(qhs(pq2))
         nq3 = xslen(qhs(pq3))
         addlin = 1
         if (nq2 .gt. 0) addlin = addlin + 1
         if (nq3 .gt. 0) addlin = addlin + 1
         call opage(tqfit, ' ', 0, addlin, xquery)
         if (xquery .eq. tfalse) then
            call opage(tinquire, ' ', 0, -addlin, xquery)
         else
            call opage(tinquire, ' ', 0, addlin, xquery)
         endif
c
         write (jout, 9130) qhs(pq1)(1:nq1)
         if (nq2 .gt. 0) write (jout, 9130) qhs(pq2)(1:nq2)
         if (nq3 .gt. 0) write (jout, 9130) qhs(pq3)(1:nq3)
         if ((addlin .gt. 1) .and. (jage .lt. nage)) then
            call opage(tlines, ' ', 0, 1, xquery)
         endif
      enddo
c
      call heapop(pq4)
      call heapop(pq3)
      call heapop(pq2)
      call heapop(pq1)
c
      return
      end
      subroutine owdiet()
c
c update: 16:34 fri 4-mar-1994.
c output the diet.
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'habitat.par'
      include 'fish.par'
      include 'simul.par'
      include 'page.par'
      include 'strings.par'
      include 'idfiles.def'
      include 'globpar.def'
      include 'fish.def'
      include 'diet.def'
      include 'habitat.def'
      include 'heap.def'
c
      character*(26) alphabet
      integer xslen, jspecies
      integer nn, pq1, nq1, jj, addlin, xquery
      external xslen
c
      integer jrange, pzz, iprey
      pzz(iprey) = nint(100.0 * fdiet(iprey, jrange, jspecies))
c
      data alphabet /'abcdefghijklmnopqrstuvwxyz'/
c
c a30 available for the species name;
c
 9110 format (' *** diet, by species ***',/)
 9120 format (5x,a,'. ',a)
 9130 format (5x,a30,1x,a6,1x,2(a11,1x),a)
 9140 format (5x,a30,1x,a6,1x,2(a11,1x),12(a4,1x))
 9150 format (5x,a30,1x,a6,1x,2(5x,i6,1x),12(i3,'%',1x))
 9160 format (5x,a30,1x,a6,1x,2(1x,1pg10.3,1x),12(i3,'%',1x))
c
 9170 format (5x,'plankton standing stock: ',a,:,' "',a,'"')
 9180 format (5x,'plankton standing stock: ',a,:,1pg10.3,' grams/Litre')
c
      if (xdiet) then
c
c addlin: number of lines this module will produce
c
         addlin = 2
         if (dplankton) addlin = addlin + 2
         addlin = addlin + 3
         do jspecies = 1, gnspecies
            addlin = addlin + range_numof(jspecies)
         enddo
         addlin = addlin + 2 + gnspecies + 2 + 1
         call opage(tinquire, ' ', 0, -addlin, xquery)
c
         pq1 = 0
         call heapush(pq1)
c
         write (jout, 9110)
c
         if (dplankton) then
            if (plankton_standing_stock_func .eq. tfile) then
               jj = xslen(planktonfil)
               write (jout, 9170) 'file', planktonfil(1:jj)
            elseif (plankton_standing_stock_func .eq. tconstant) then
               call compress(qhs(pq1), -1, nq1)
               write (jout, 9180) 'constant', 
     &            plankton_standing_stock_conc
            endif
            write (jout, *)
         endif
c
         write (jout, 9130) 'Species name                  ', 'Range ',
     &      'Lower bound', 'Upper bound', '   Diet  '
         write (jout, 9140) '                              ', 'Type  ',
     &      ' ', ' ', (alphabet(jj:jj), jj = 1, gnspecies + 3)
         write (jout, 9140) '------------------------------', '------',
     &      '-----------', '-----------', ('----', jj = 1, gnspecies + 3
     &      )
c
         do jspecies = 1, gnspecies
            nn = 30     ! "30" : see note above;       Xslen(Spplab (jspecies))
            do jrange = 1, range_numof(jspecies)
               if (range_type(jspecies) .eq. tage) then
                  write (jout, 9150) spplab(jspecies)(1:nn), 'age  ', 
     &               nint(range_lowb(jrange, jspecies)), 
     &               nint(range_uppb(jrange, jspecies)), (pzz(jj), jj =
     &               1, gnspecies), pzz(pplankton), pzz(pbenthos), 
     &               pzz(pcfish)
               elseif (range_type(jspecies) .eq. tweight) then
                  write (jout, 9160) spplab(jspecies)(1:nn), 'weight', 
     &               range_lowb(jrange, jspecies), 
     &               range_uppb(jrange, jspecies), (pzz(jj), jj = 1, 
     &               gnspecies), pzz(pplankton), pzz(pbenthos), 
     &               pzz(pcfish)
               elseif (range_type(jspecies) .eq. tlength) then
                  write (jout, 9160) spplab(jspecies)(1:nn), 'length', 
     &               range_lowb(jrange, jspecies), 
     &               range_uppb(jrange, jspecies), (pzz(jj), jj = 1, 
     &               gnspecies), pzz(pplankton), pzz(pbenthos), 
     &               pzz(pcfish)
               endif
            enddo
         enddo
c
         write (jout, '(/)')
         do jspecies = 1, gnspecies
            nn = xslen(spplab(jspecies))
            write (jout, 9120) alphabet(jspecies:jspecies), 
     &         spplab(jspecies)(1:nn)
         enddo
c
         jspecies = gnspecies + 1
         write (jout, 9120) alphabet(jspecies:jspecies), 'plankton'
c
         jspecies = gnspecies + 2
         write (jout, 9120) alphabet(jspecies:jspecies), 'benthos'
c
         jspecies = gnspecies + 3
         write (jout, 9120) alphabet(jspecies:jspecies), 'cfish'
         write (jout, *)
c
         call heapop(pq1)
      endif
c
  110 continue
      return
      end
      subroutine owdiet2(uu)
c
c update: 11:45 fri 9-sep-1994.
c output "/diet" command
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'numbers.par'
      include 'page.par'
      include 'simul.par'
      include 'strings.par'
      include 'idfiles.def'
      include 'fish.def'
      include 'globpar.def'
      include 'diet.def'
      include 'heap.def'
c
      integer uu
c
      integer xslen, nspp, nbbb, pq1, nq1, ktyp, addlin, xquery
      integer jspecies, jprey, jrange, nss
      real rlow, rupp
      logical treq, lout, trne
      external xslen, treq, trne
c
 9110 format (3x,a)
 9120 format (:,8x,a,a)
 9130 format (i6,' : ')
 9140 format (i6,' - ',i6,' : ')
 9150 format (1pg10.3,' - ',1pg10.3,' : ')
c
      if (range_numof(1) .gt. 0) then
         pq1 = 0
         call heapush(pq1)
         lout = (uu .eq. jout)
c
         addlin = 1 + gnspecies
         if (lout) call opage(tinquire, ' ', 0, addlin, xquery)
         write (uu, 9110) '/ diet'
c
         do jspecies = 1, gnspecies
            nspp = xslen(spplab(jspecies))
            nbbb = xslen(dietlabels(jspecies))
            qhs(pq1) = dietlabels(jspecies)(1:nbbb) // ': "' // 
     &         spplab(jspecies)(1:nspp) // '")'
            nq1 = nbbb + 3 + nspp + 2   ! Index (Qhs(pq1), ')')
            if (jspecies .lt. gnspecies) then
               qhs(pq1)(nq1:nq1 + 2) = ', &'
               nq1 = nq1 + 2    ! Index (Qhs(pq1), '&')
            endif
            if (jspecies .eq. 1) then
               write (uu, 9120) 'labels (', qhs(pq1)(1:nq1)
            else
               write (uu, 9120) '        ', qhs(pq1)(1:nq1)
            endif
         enddo
c
c the diet;
c
         do jspecies = 1, gnspecies
            nbbb = xslen(dietlabels(jspecies))
            ktyp = range_type(jspecies)
            do jrange = 1, range_numof(jspecies)
               rlow = range_lowb(jrange, jspecies)
               rupp = range_uppb(jrange, jspecies)
               if (ktyp .eq. tage) then
                  qhs(pq1) = dietlabels(jspecies)(1:nbbb) // ' (age = '
                  nq1 = index(qhs(pq1), '=') + 2
                  if (treq(rlow, rupp)) then
                     write (qhs(pq1)(nq1:), 9130) nint(rlow)
                  else
                     write (qhs(pq1)(nq1:), 9140) nint(rlow), 
     &                  nint(rupp)
                  endif
               elseif (ktyp .eq. tweight) then
                  qhs(pq1) = dietlabels(jspecies)(1:nbbb) // 
     &               ' (weight = '
                  nq1 = index(qhs(pq1), '=') + 2
                  write (qhs(pq1)(nq1:), 9150) rlow, rupp
               elseif (ktyp .eq. tlength) then
                  qhs(pq1) = dietlabels(jspecies)(1:nbbb) // 
     &               ' (length = '
                  nq1 = index(qhs(pq1), '=') + 2
                  write (qhs(pq1)(nq1:), 9150) rlow, rupp
               endif
               nq1 = index(qhs(pq1), ':') + 2
               do jprey = 1, gnspecies
                  if (trne(fdiet(jprey, jrange, jspecies), zero)) then
                     nss = xslen(dietlabels(jprey))
                     qhs(pq1)(nq1:) = dietlabels(jprey)(1:nss) // ' = '
                     nq1 = nq1 - 1 + nss + 3 + 1
                     call real2a(fdiet(jprey, jrange, jspecies), 
     &                  '(0pf5.2)', qhs(pq1)(nq1:), nss)
                     nq1 = nq1 + nss
                     qhs(pq1)(nq1:nq1) = ','
                     nq1 = nq1 + 2
                  endif
               enddo
               if (trne(fdiet(pplankton, jrange, jspecies), zero)) then
                  qhs(pq1)(nq1:) = 'plankton = '
                  nq1 = xslen(qhs(pq1)) + 2
                  call real2a(fdiet(pplankton, jrange, jspecies), 
     &               '(0pf5.2)', qhs(pq1)(nq1:), nss)
                  nq1 = nq1 + nss
                  qhs(pq1)(nq1:nq1) = ','
                  nq1 = nq1 + 2
               endif
               if (trne(fdiet(pbenthos, jrange, jspecies), zero)) then
                  qhs(pq1)(nq1:) = 'benthos = '
                  nq1 = xslen(qhs(pq1)) + 2
                  call real2a(fdiet(pbenthos, jrange, jspecies), 
     &               '(0pf5.2)', qhs(pq1)(nq1:), nss)
                  nq1 = nq1 + nss
                  qhs(pq1)(nq1:nq1) = ','
                  nq1 = nq1 + 2
               endif
               if (trne(fdiet(pcfish, jrange, jspecies), zero)) then
                  qhs(pq1)(nq1:) = 'cfish = '
                  nq1 = xslen(qhs(pq1)) + 2
                  call real2a(fdiet(pcfish, jrange, jspecies), 
     &               '(0pf5.2)', qhs(pq1)(nq1:), nss)
                  nq1 = nq1 + nss
                  qhs(pq1)(nq1:nq1) = ','
                  nq1 = nq1 + 2
               endif
               nq1 = nq1 - 2
               qhs(pq1)(nq1:nq1) = ')'
               call compress(qhs(pq1), nq1, nq1)
               if (lout) call opage(tinquire, ' ', 0, 1, xquery)
               write (uu, 9120) qhs(pq1)(1:nq1)
            enddo
         enddo
c
         call heapop(pq1)
      endif
c
  110 continue
      return
      end
      subroutine owfile(tmode, jfile, nage, edadp)
c
c update: 16:00 tue 5-apr-1994.
c generate updated Fgets input file:
c if tmode == Zioappend ==> assume file is open; jfile is the logical unit
c                         number of the output device.
c if tmode == tnew    ==> open a new file; jfile is undefined.
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'habitat.par'
      include 'fish.par'
      include 'page.par'
      include 'phylum.par'
      include 'simul.par'
      include 'strings.par'
      include 'idfiles.def'
      include 'globpar.def'
      include 'chemp.def'
      include 'time.def'
      include 'options.def'
      include 'chems.def'
      include 'habitat.def'
      include 'units.def'
      include 'lab.def'
      include 'page.def'
      include 'version.def'
      include 'heap.def'
      include 'examsrec.def'
c
      integer tmode, jfile, nage, edadp( * )
c
      character*(4) c4
      integer xslen, jj, jchem, ndate, uu, pq1
      integer nin, nuif, nq1, xfopen, nkk, addlin, xquery
      integer ns1, ns2, ns3, ns4, nss, jspecies
      integer npredator, nprey, nprey_food
      logical to_open, lout
      external xslen, xfopen, xfclose
c
      pq1 = 0   ! assign heap storage            
      call heapush(pq1)
c
      call usrunits()
      to_open = (tmode .eq. tnew)
      lout = (jfile .eq. jout)
c
      if (to_open) then
         if (zioerror .eq. xfopen(juif, ucffil, ziowrite)) then
            nuif = xslen(ucffil)
            write (jout, 9110) ucffil(1:nuif)
            go to 110
         endif
         uu = juif
      else
         uu = jfile
      endif
 9110 format (1x,'?? cannot open Fgets-updated command file "',a,'"')
c
c notes:
c     /Pka        not enabled; 12:51:24.75 monday april 17, 1989.
c
c file id
c
      nin = xslen(infil)
      nuif = xslen(ucffil)
      call getdate(qhs(pq1), ndate)
c
      if (lout) call opage(tinquire, ' ', 0, 4, xquery)
      if (nin .gt. 0) then
         write (uu, 9120) x_version_date(1:nversion), 
     &      qhs(pq1)(1:ndate), infil(1:nin)
      else
         write (uu, 9120) x_version_date(1:nversion), 
     &      qhs(pq1)(1:ndate)
      endif
 9120 format ('!',t7,a,/,'!',t7,'      date: ',a,:,/,'!',t7,
     &   'input file: ',a,/,'!')
c
c general simulation stuff;
c on input:    data is "unitized" to Pgm_time et al. ;
c on output:   data is in the original user units;
c
c user id
c
 9130 format (t4,'/ header  "',a,'"')
 9140 format ('!')
c
      if (title_set) then
         if (lout) call opage(tinquire, ' ', 0, 2, xquery)
         write (uu, 9130) title_page(1:title_len)
         write (uu, 9140)
      endif
c
      ns1 = xslen(tunits)
      ns2 = xslen(wtunits)
      ns3 = xslen(cwunits)
      ns4 = xslen(cfunits)
      if (lout) call opage(tinquire, ' ', 0, 5, xquery)
      write (uu, 9150) gnchem, tunits(1:ns1), wtunits(1:ns2), 
     &   cwunits(1:ns3), cfunits(1:ns4)
 9150 format (t4,'/ chemicals ',t23,i3,/,t4,'/ tunits    ',t23,a,/,t4,
     &   '/ wtunits   ',t23,a,/,t4,'/ cwunits   ',t23,a,/,t4,
     &   '/ cfunits   ',t23,a)
c
      if (lout) call opage(tinquire, ' ', 0, 3, xquery)
      write (uu, 9160) '/ tstart', simul_end
      write (uu, 9160) '/ tend', simul_end
      write (uu, 9160) '/ nstep', tnstep
c
      if (xexams) then
         if (lout) call opage(tinquire, ' ', 0, 1, xquery)
         write (uu, 9160) '/ exams'
      endif
 9160 format (t4,a,:,t23,1pg10.3)
c
 9170 format (t4,a,:,a)
 9180 format (t4,a,:,t23,a,5a)
 9190 format (a,1x,1p10g10.3)
      if (twfunc .eq. tfile) then
         nq1 = xslen(cwfil)
         qhs(pq1) = 'file "' // cwfil(1:nq1) // '"'
      elseif (twfunc .eq. tconstant) then
         write (qhs(pq1), 9190) 'constant', twpar(1)
      elseif (twfunc .eq. tsin) then
         write (qhs(pq1), 9190) 'Sin', twpar(1), twpar(2), twpar(3), 
     &      twpar(4)
      endif
      call compress(qhs(pq1), -1, nq1)
      if (lout) call opage(tinquire, ' ', 0, 1, xquery)
      write (uu, 9180) '/ temperature', qhs(pq1)(1:nq1)
c
c / burden
      if (simul_mode .eq. tfood_chain) then
         npredator = xslen(fc_spredator)
         nprey = xslen(fc_sprey)
         nprey_food = xslen(fc_sprey_food)
         if (lout) call opage(tinquire, ' ', 0, 3, xquery)
         write (uu, 9180) '/ burden', 'food_chain (predator = "', 
     &      fc_spredator(1:npredator), '",  &'
         if (fc_preyt .eq. tspecies) then
            write (uu, 9180) ' ', '            prey = "', 
     &         fc_sprey(1:nprey), '",  &'
            write (uu, 9180) ' ', '            prey_food = ', 
     &         fc_sprey_food(1:nprey_food), ')'
         else
            write (uu, 9180) ' ', '            prey = ', 
     &         fc_sprey(1:nprey), ')'
         endif
c
      elseif (simul_mode .eq. tlaboratory) then
         call real2a(tank_flow, '(1pg10.3)', qhs(pq1), nq1)
         nkk = xslen(pgm_flow)
         nq1 = nq1 + 2
         qhs(pq1)(nq1:) = pgm_flow(1:nkk)
         nq1 = nkk - 1 + nq1
         if (lout) call opage(tinquire, ' ', 0, 4, xquery)
         write (uu, 9180) '/ burden', 'laboratory (flow = ', 
     &      qhs(pq1)(1:nq1), ',  &'
c
         call real2a(tank_volume, '(1pg10.3)', qhs(pq1), nq1)
         nkk = xslen(pgm_volume)
         nq1 = nq1 + 2
         qhs(pq1)(nq1:) = pgm_volume(1:nkk)
         nq1 = nkk - 1 + nq1
         write (uu, 9180) ' ', '            volume = ', 
     &      qhs(pq1)(1:nq1), ',  &'
c
         call real2a(tank_nfish, '(f5.0)', qhs(pq1), nq1)
         nq1 = nq1 - 1  ! get rid of trailing "."                    
         write (uu, 9180) ' ', '            nfish = ', 
     &      qhs(pq1)(1:nq1), ',  &'
c
         if (food_chem_func .eq. tequilibrium) then
            write (qhs(pq1), 9200) 'equilibrium', food_pl, (
     &         food_bmf(jchem), jchem = 1, gnchem)
         elseif (food_chem_func .eq. tconstant) then
            write (qhs(pq1), 9200) 'constant', (food_chem_conc(jchem), 
     &         jchem = 1, gnchem)
         endif
         call compress(qhs(pq1), -1, nq1)
         write (uu, 9180) ' ', '            cfood = ', 
     &      qhs(pq1)(1:nq1), ')'
c
      elseif (simul_mode .eq. tfood_web) then
         if (lout) call opage(tinquire, ' ', 0, 1, xquery)
         write (uu, 9180) '/ burden', 'food_web'
      endif
c
c / _research
      if (xresearch) then
         if (xsteady_state_gut) then
            qhs(pq1) = 'holling(steady_state_gut)'
         else
            qhs(pq1) = 'holling(nosteady_state_gut)'
         endif
         nq1 = xslen(qhs(pq1))
c
         if (xtotals) then
            qhs(pq1)(nq1 + 2:) = '_totals'
            nq1 = xslen(qhs(pq1))
         endif
c
         if (xlast_year_only) then
            qhs(pq1)(nq1 + 2:) = '_last_year_only'
            nq1 = xslen(qhs(pq1))
         endif
c
         if (lout) call opage(tinquire, ' ', 0, 1, xquery)
         write (uu, 9180) '/ _research ', qhs(pq1)(1:nq1)
      endif
c
c / plot
c
      nq1 = -1
      if (xwtxt) then
         qhs(pq1)(nq1 + 2:) = 'wt(time)'
         nq1 = xslen(qhs(pq1))
      endif
c
      if (xcfxt) then
         qhs(pq1)(nq1 + 2:) = 'cfish(time)'
         nq1 = xslen(qhs(pq1))
      endif
      if (xcfxwt) then
         qhs(pq1)(nq1 + 2:) = 'cfish(wt)'
         nq1 = xslen(qhs(pq1))
      endif
c
      if (xcw_t) then
         qhs(pq1)(nq1 + 2:) = 'cw(time)'
         nq1 = xslen(qhs(pq1))
      endif
c
      if (xactvt_t) then
         qhs(pq1)(nq1 + 2:) = 'total_activity(time)'
         nq1 = xslen(qhs(pq1))
      endif
      if (xactvt_wt) then
         qhs(pq1)(nq1 + 2:) = 'total_activity(wt)'
         nq1 = xslen(qhs(pq1))
      endif
c
      if (nq1 .gt. 0) then
         if (lout) call opage(tinquire, ' ', 0, 1, xquery)
         write (uu, 9180) '/ plot', qhs(pq1)(1:nq1)
      endif
c
      nq1 = -1
      if (xcf_aro_wt) then
         qhs(pq1)(nq1 + 2:) = 'cf_aroclor(wt, '
         nq1 = 2 + xslen(qhs(pq1))
         do jchem = 1, gnchem
            call real2a(wtfac_aroclor(jchem, pwt_aroclor), '(1pg10.3)',
     &         qhs(pq1)(nq1:), nss)
            nq1 = nq1 + nss
            qhs(pq1)(nq1:nq1) = ','
            nq1 = nq1 + 2
         enddo
         nq1 = nq1 - 2
         qhs(pq1)(nq1:nq1) = ')'
         if (lout) call opage(tinquire, ' ', 0, 1, xquery)
         write (uu, 9180) '/ plot', qhs(pq1)(1:nq1)
      endif
c
      nq1 = -1
      if (xcf_aro_t) then
         qhs(pq1)(nq1 + 2:) = 'cf_aroclor(time, '
         nq1 = 2 + xslen(qhs(pq1))
         do jchem = 1, gnchem
            call real2a(wtfac_aroclor(jchem, pt_aroclor), '(1pg10.3)', 
     &         qhs(pq1)(nq1:), nss)
            nq1 = nq1 + nss
            qhs(pq1)(nq1:nq1) = ','
            nq1 = nq1 + 2
         enddo
         nq1 = nq1 - 2
         qhs(pq1)(nq1:nq1) = ')'
         if (lout) call opage(tinquire, ' ', 0, 1, xquery)
         write (uu, 9180) '/ plot', qhs(pq1)(1:nq1)
      endif
c
c / print
c
      nq1 = -1
      if (xfishpar) then
         qhs(pq1)(nq1 + 2:) = 'fishpar('
         nq1 = 1 + xslen(qhs(pq1))
         call real2a(tref_output, '(1pg10.3)', qhs(pq1)(nq1:), nss)
         nq1 = nq1 + nss
         qhs(pq1)(nq1:nq1) = ')'
      endif
      if (xdata) then
         qhs(pq1)(nq1 + 2:) = 'time_series'
         nq1 = xslen(qhs(pq1))
      endif
      if (xupdate_input) then
         qhs(pq1)(nq1 + 2:) = 'update_input'
         nq1 = xslen(qhs(pq1))
      endif
      if (nq1 .gt. 0) then
         if (lout) call opage(tinquire, ' ', 0, 1, xquery)
         write (uu, 9180) '/ print', qhs(pq1)(1:nq1)
      endif
c
 9200 format (a,:,1x,1p1g10.3,1p10g10.3)
c
c chemical info
c
 9210 format (t4,'/ ',a,t23,a,a)
 9220 format (t4,'  ',a,t23,a,a)
 9230 format ('!',/,'! chem info',/,'!')
c
c to cover chemical info.
c
      addlin = 3 + gnchem + 5 + gnchem
      if (lout) call opage(tinquire, ' ', 0, addlin, xquery)
c
      write (uu, 9230)
      do jchem = 1, gnchem
         ns1 = xslen(toxlab(jchem))
         nq1 = ns1 + 2  ! 2: two double quotes
         qhs(pq1)(1:nq1) = '"' // toxlab(jchem)(1:ns1) // '"'
         if (jchem .lt. gnchem) then
            c4 = '   &'
         else
            c4 = ' '
         endif
         if (jchem .eq. 1) then
            write (uu, 9210) 'Toxlab', qhs(pq1)(1:nq1), c4
         else
            write (uu, 9220) '      ', qhs(pq1)(1:nq1), c4
         endif
      enddo
c
 9240 format (t4,'/ ',a,:,t23,10f8.2)
      write (uu, 9240) 'Logp', (logp(jj), jj = 1, gnchem)
      write (uu, 9240) 'Molwt', (molwt(jj), jj = 1, gnchem)
      write (uu, 9240) 'Molvol', (molvol(jj), jj = 1, gnchem)
      write (uu, 9240) 'melting_point', (mp(jj), jj = 1, gnchem)
ccc      write (uu, 9161) 'Pka',             (Pka(jj),    jj=1,Gnchem)
c
 9250 format (i3,1x,:,a,1x,1p10g10.3)
      do jchem = 1, gnchem
         if (cwfunc(jchem) .eq. tfile) then
            nq1 = xslen(cwfil)
            write (qhs(pq1), 9250) jchem, 'file "' // cwfil(1:nq1) // 
     &         '"'
         elseif (cwfunc(jchem) .eq. tconstant) then
            write (qhs(pq1), 9250) jchem, 'constant', cwpar(1, jchem)
         elseif (cwfunc(jchem) .eq. tsin) then
            write (qhs(pq1), 9250) jchem, 'Sin', cwpar(1, jchem), 
     &         cwpar(2, jchem), cwpar(3, jchem), cwpar(4, jchem)
         elseif (cwfunc(jchem) .eq. texp) then
            write (qhs(pq1), 9250) jchem, 'Exp', cwpar(1, jchem), 
     &         cwpar(2, jchem), cwpar(3, jchem)
         endif
         call compress(qhs(pq1), -1, nq1)
         write (uu, 9180) '/ cwater ', qhs(pq1)(1:nq1)
      enddo
c
 9260 format (a,1pg10.3,1p10g10.3)
c
      if (xbenthos) then
         if (benthos_chem_func .eq. tfile) then
            nq1 = xslen(benthosfil)
            qhs(pq1) = 'file ' // benthosfil(1:nq1)
         elseif (benthos_chem_func .eq. tequilibrium) then
            write (qhs(pq1), 9260) 'equilibrium', benthos_pl, (
     &         benthos_bmf(jchem), jchem = 1, gnchem)
         elseif (benthos_chem_func .eq. tconstant) then
            write (qhs(pq1), 9260) 'constant', (
     &         benthos_chem_conc(jchem), jchem = 1, gnchem)
         endif
         call compress(qhs(pq1), -1, nq1)
         if (lout) call opage(tinquire, ' ', 0, 1, xquery)
         write (uu, 9180) '/ cbenthos ', qhs(pq1)(1:nq1)
      endif
c
      if (xcfish) then
         if (cfish_chem_func .eq. tfile) then
            nq1 = xslen(cfishfil)
            qhs(pq1) = 'file ' // cfishfil(1:nq1)
         elseif (cfish_chem_func .eq. tequilibrium) then
            write (qhs(pq1), 9260) 'equilibrium', cfish_pl, (
     &         cfish_bmf(jchem), jchem = 1, gnchem)
         elseif (cfish_chem_func .eq. tconstant) then
            write (qhs(pq1), 9260) 'constant', (cfish_chem_conc(jchem),
     &         jchem = 1, gnchem)
         endif
         call compress(qhs(pq1), -1, nq1)
         if (lout) call opage(tinquire, ' ', 0, 1, xquery)
         write (uu, 9180) '/ cfish ', qhs(pq1)(1:nq1)
      endif
c
      if (xplankton) then
         if (plankton_chem_func .eq. tfile) then
            nq1 = xslen(planktonfil)
            qhs(pq1) = 'file ' // planktonfil(1:nq1)
         elseif (plankton_chem_func .eq. tequilibrium) then
            write (qhs(pq1), 9260) 'equilibrium', plankton_pl, (
     &         plankton_bmf(jchem), jchem = 1, gnchem)
         elseif (plankton_chem_func .eq. tconstant) then
            write (qhs(pq1), 9260) 'constant', (
     &         plankton_chem_conc(jchem), jchem = 1, gnchem)
         endif
         call compress(qhs(pq1), -1, nq1)
         if (lout) call opage(tinquire, ' ', 0, 1, xquery)
         write (uu, 9180) '/ cplankton ', qhs(pq1)(1:nq1)
      endif
c
      if (dplankton) then
         if (plankton_standing_stock_func .eq. tfile) then
            nq1 = xslen(planktonfil)
            if (lout) call opage(tinquire, ' ', 0, 1, xquery)
            write (uu, 9170) '/ plankton_standing_stock   file ', 
     &         planktonfil(1:nq1)
         elseif (plankton_standing_stock_func .eq. tconstant) then
            write (qhs(pq1), '(1pg10.3)') plankton_standing_stock_conc
            if (lout) call opage(tinquire, ' ', 0, 1, xquery)
            write (uu, 9170) '/ plankton_standing_stock   constant ', 
     &         qhs(pq1)(1:nq1)
         endif
      endif
c
c the fish, the fish !
c
      if (simul_mode .eq. tfood_chain) then     ! one or two fish 
         jspecies = fc_predatorp
         call agesort(jspecies, nage, edadp)
         call owfish(uu, jspecies, nage, edadp)
c
         if (fc_preyt .eq. tspecies) then
            jspecies = fc_preyp
            call agesort(jspecies, nage, edadp)
            call owfish(uu, jspecies, nage, edadp)
         endif
c
      elseif (simul_mode .eq. tlaboratory) then ! one fish        
         jspecies = gnspecies
         call agesort(jspecies, nage, edadp)
         call owfish(uu, jspecies, nage, edadp)
c
      elseif (simul_mode .eq. tfood_web) then   ! many fish       
         do jspecies = 1, gnspecies
            call agesort(jspecies, nage, edadp)
            call owfish(uu, jspecies, nage, edadp)
         enddo
         call owdiet2(uu)
      endif
c
      if (lout) call opage(tinquire, ' ', 0, 1, xquery)
      write (uu, '(a)') '/end'
      if (to_open) then
         call xfclose(uu)
      endif
c
  110 continue
      call heapop(pq1)  ! release heap storage                 
c
      return
      end
      subroutine owfish(junit, jspecies, nage, edadp)
c
c update: 16:34 fri 4-mar-1994.
c generate updated Fgets input file for one species;
c junit is the logical output unit number;
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'noval.par'
      include 'page.par'
      include 'phylum.par'
      include 'physio.par'
      include 'plots.par'
      include 'simul.par'
      include 'strings.par'
c
      include 'fish.def'
      include 'fluxes.def'
      include 'globpar.def'
      include 'heap.def'
      include 'idfiles.def'
      include 'obsdata.def'
      include 'options.def'
      include 'units.def'
      include 'work.def'
c
      integer junit, jspecies, nage, edadp( * )
c
      integer xslen, ii, jobs, nq1, jchem, pq1, uu
      integer ns1, ns2, ns3, agep, jage, nn, addlin, xquery
      logical lout
      external xslen
c
 9110 format (t4,'/ ',a,:,t25,a,a)
 9120 format (t4,t25,a,a)
 9130 format ('!',/,'! year class: ',i2,/,'!')
 9140 format ('!',/,t4,'/ species',t25,a,/,t4,'/ family',t25,a,/,t4,
     &   '/ ecology',t25,a,:,/,t4,'/ maximum_age',t25,i2)
 9150 format (i3,1x,1p97g10.3)
 9160 format (i3,1x,a,1x,1p97g10.3)
 9170 format (1p97g10.3)
 9180 format (t10,a)
 9190 format (1p97g10.3)
 9200 format (i3,1x,a,:,1x,1p1g10.3,1p97g10.3)
c
      uu = junit
      lout = (junit .eq. jout)
      pq1 = 0
      call heapush(pq1)
c
      ns1 = xslen(spplab(jspecies))
      ns2 = xslen(famlab(jspecies))
      ns3 = xslen(ecolab(jspecies))
      if (simul_mode .eq. tfood_web) then
         if (lout) call opage(tinquire, ' ', 0, 5, xquery)
         write (uu, 9140) spplab(jspecies)(1:ns1), 
     &      famlab(jspecies)(1:ns2), ecolab(jspecies)(1:ns3), nage
      else
         if (lout) call opage(tinquire, ' ', 0, 4, xquery)
         write (uu, 9140) spplab(jspecies)(1:ns1), 
     &      famlab(jspecies)(1:ns2), ecolab(jspecies)(1:ns3)
      endif
c
      write (qhs(pq1), 9170) activegill(jspecies)
      call compress(qhs(pq1), -1, nq1)
      if (lout) call opage(tinquire, ' ', 0, 1, xquery)
      write (uu, 9110) 'active_gill', qhs(pq1)(1:nq1)
c
      do jchem = 1, gnchem
         if (lc50func(jchem, jspecies) .eq. inoval) then
            continue
         elseif (lc50func(jchem, jspecies) .eq. tlog_fathead) then
            write (qhs(pq1), 9200) jchem, 'Log/log_fathead', 
     &         lc50par(1, jchem, jspecies), lc50par(2, jchem, jspecies)
            call compress(qhs(pq1), -1, nq1)
            if (lout) call opage(tinquire, ' ', 0, 1, xquery)
            write (uu, 9110) 'lc50', qhs(pq1)(1:nq1)
         elseif (lc50func(jchem, jspecies) .eq. tobserved) then
            write (qhs(pq1), 9200) jchem, 'observed', 
     &         lc50par(1, jchem, jspecies)
            nq1 = xslen(qhs(pq1)) + 3
            ii = xslen(pgm_conc)
            qhs(pq1)(nq1:nq1 + ii - 1) = pgm_conc(1:ii)
            call compress(qhs(pq1), -1, nq1)
            if (lout) call opage(tinquire, ' ', 0, 1, xquery)
            write (uu, 9110) 'lc50', qhs(pq1)(1:nq1)
         else
            qhs(pq1) = '?? UNSET'
            call compress(qhs(pq1), -1, nq1)
            if (lout) call opage(tinquire, ' ', 0, 1, xquery)
            write (uu, 9110) 'lc50', qhs(pq1)(1:nq1)
         endif
      enddo
c
      if (lout) call opage(tinquire, ' ', 0, nage, xquery)
      do jage = 1, nage
         write (qhs(pq1), 9190) qq_wt(1, edadp(jage), jspecies)
         call compress(qhs(pq1), -1, nq1)
         if (nage .eq. 1) then
            write (uu, 9110) 'initial_wt', qhs(pq1)(1:nq1)
         else
            if (jage .eq. 1) then
               write (uu, 9110) 'initial_wt', qhs(pq1)(1:nq1), '  &'
            elseif (jage .lt. nage) then
               write (uu, 9120) qhs(pq1)(1:nq1), '  &'
            else
               write (uu, 9120) qhs(pq1)(1:nq1)
            endif
         endif
      enddo
c
      do jage = 1, nage
         agep = edadp(jage)
         if (nage .gt. 1) then
            addlin = 3 + 3
            if (lout) call opage(tinquire, ' ', 0, addlin, xquery)
            write (uu, 9130) jage
         else
            addlin = 4
            if (lout) call opage(tinquire, ' ', 0, addlin, xquery)
         endif
         nn = max(1, qq_nxy(agep, jspecies))
         write (qhs(pq1), 9150) jage, (
     &      qq_cfcal(nn, jchem, agep, jspecies), jchem = 1, gnchem)
         call compress(qhs(pq1), -1, nq1)
         write (uu, 9110) 'initial_cf ', qhs(pq1)(1:nq1)
c
         if (vv_growth_model(jage, jspecies) .eq. tallometric) then
            write (qhs(pq1), 9160) jage, 'allometric', 
     &         vv_functional_response(jage, jspecies)
c
         elseif (vv_growth_model(jage, jspecies) .eq. tholling) then
            write (qhs(pq1), 9160) jage, 'holling', 
     &         vv_functional_response(jage, jspecies)
c
         elseif (vv_growth_model(jage, jspecies) .eq. tlinear) then
            write (qhs(pq1), 9160) jage, 'linear fishpar'
c
         elseif (vv_growth_model(jage, jspecies) .eq. tclearance) then
            write (qhs(pq1), 9160) jage, 'clearance fishpar', 
     &         vv_functional_response(jage, jspecies)
         else
            qhs(pq1) = '?? UNSET'
         endif
         call compress(qhs(pq1), -1, nq1)
         write (uu, 9110) 'growth', qhs(pq1)(1:nq1)
c
         if (vv_plfunc(jage, jspecies) .eq. tconstant) then
            write (qhs(pq1), 9160) jage, 'constant', 
     &         vv_pval(vpl1, jage, jspecies)
c
         elseif (vv_plfunc(jage, jspecies) .eq. tlinear) then
            write (qhs(pq1), 9160) jage, 'linear', 
     &         vv_pval(vpl1, jage, jspecies), 
     &         vv_pval(vpl2, jage, jspecies)
c
         elseif ((vv_plfunc(jage, jspecies) .eq. tallometric) .or. (
     &      vv_plfunc(jage, jspecies) .eq. tdatabase) .or. (
     &      vv_plfunc(jage, jspecies) .eq. tfishpar)) then
c
            write (qhs(pq1), 9160) jage, 'allometric', 
     &         vv_pval(vpl1, jage, jspecies), 
     &         vv_pval(vpl2, jage, jspecies)
         else
            qhs(pq1) = '?? UNSET'
         endif
         call compress(qhs(pq1), -1, nq1)
         write (uu, 9110) 'plfish', qhs(pq1)(1:nq1)
      enddo
c
      jage = 1
      call ofishpar(uu, tref_output, vv_pval(1, jage, jspecies), .true.)
c
      nq1 = -1
      if (data_t(jspecies)) then
         qhs(pq1)(nq1 + 2:) = 'time'
         nq1 = xslen(qhs(pq1))
      endif
      if (data_w(jspecies)) then
         qhs(pq1)(nq1 + 2:) = 'wt'
         nq1 = xslen(qhs(pq1))
      endif
      if (data_c(jspecies)) then
         qhs(pq1)(nq1 + 2:) = 'cfish'
         nq1 = xslen(qhs(pq1))
      endif
      if (nq1 .gt. 0) then
         if (lout) call opage(tinquire, ' ', 0, 1, xquery)
         write (uu, 9110) 'observations', qhs(pq1)(1:nq1)
      endif
      do jobs = 1, nobs(jspecies)
         nq1 = 0
         if (data_t(jspecies)) then
            write (qhs(pq1)(nq1 + 1:), 9170) tobs(jobs, jspecies)
            nq1 = xslen(qhs(pq1))
         endif
         if (data_w(jspecies)) then
            write (qhs(pq1)(nq1 + 1:), 9170) wobs(jobs, jspecies)
            nq1 = xslen(qhs(pq1))
         endif
         if (data_c(jspecies)) then
            write (qhs(pq1)(nq1 + 1:), 9170) (
     &         cfobs(jobs, jchem, jspecies), jchem = 1, gnchem)
            nq1 = xslen(qhs(pq1))
         endif
         if (nq1 .gt. 0) then
            call compress(qhs(pq1), nq1, nq1)
            if (nq1 .gt. 0) then
               if (lout) call opage(tinquire, ' ', 0, 1, xquery)
               write (uu, 9180) qhs(pq1)(1:nq1)
            endif
         endif
      enddo
c
      call heapop(pq1)
c
      return
      end
      subroutine owpar(vv_ptyp, stype, nlen)
c
c update: wed 12:40 13-nov-1991.
c
c determine type of vv_typ; info stored in "stype(1:nlen)"
c
c declaration of fortran parameters
c;;
      include 'phylum.par'
c
      character*( * ) stype
      integer vv_ptyp, nlen
c
      integer xslen
      external xslen
c
      if (vv_ptyp .eq. tuser) then
         stype = 'User'
      elseif (vv_ptyp .eq. tspecies) then
         stype = 'Species'
      elseif (vv_ptyp .eq. tgenus) then
         stype = 'Genus'
      elseif (vv_ptyp .eq. tfamily) then
         stype = 'Family'
      elseif (vv_ptyp .eq. tecology) then
         stype = 'Ecology'
      elseif (vv_ptyp .eq. tgeneric) then
         stype = 'Generic fish'
      else
         write (stype, '(a,i4)') 'Bogus value: ', vv_ptyp
         call compress(stype, -1, nlen)
      endif
      nlen = xslen(stype)
c
      return
      end
      subroutine owpezall(kspecies, nage)
c
c update: 16:34 fri 4-mar-1994.
c output initial physiological parameters and toxicity data (call once per run)
c
c notes:
c . changes in the computation of activity (option "tobserved") should be
c   propagated to the module "Afish", "La50", "Owpezall"
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'page.par'
      include 'water.par'
      include 'strings.par'
      include 'idfiles.def'
      include 'globpar.def'
      include 'fish.def'
      include 'chemp.def'
      include 'odevar.def'
      include 'fluxes.def'
      include 'chems.def'
      include 'diet.def'
      include 'options.def'
      include 'heap.def'
c
      integer kspecies, nage
c
c miscellaneous declarations
c
      integer jchem, pq1, nq1, xslen
      integer nspp, nfam, neco, ntt, addlin, xquery
      real la50j, la50, actvty_to_aq, lc50j
      external xslen, la50
c
 9110 format (' *** biological specifications for "',a,'" ***',/
     &   '     fish  family: ',a,/'     fish ecology: ',a,/)
 9120 format (/' *** toxicity data ***')
 9130 format ('     ',a)
 9140 format ('La50(mixture, aqueous): ',1pg10.3)
 9150 format (5x,a20,1x,a10,2x,a10)
 9160 format (5x,a20,1x,1pg10.3,2x,1pg10.3)
c;;
      pq1 = 0
      call heapush(pq1)
c
      nspp = xslen(spplab(kspecies))
      nfam = xslen(famlab(kspecies))
      neco = xslen(ecolab(kspecies))
c
      addlin = 4
      call opage(tinquire, ' ', 0, -addlin, xquery)
      write (jout, 9110) spplab(kspecies)(1:nspp), 
     &   famlab(kspecies)(1:nfam), ecolab(kspecies)(1:neco)
c
      call ospecies(nage, kspecies)     ! age-independent parameters    
      call owage2(nage, kspecies)       ! age-dependent parameters -- table
      call opage(tlines, ' ', 0, 1, xquery)
c
c summarize species's toxicity info
c
      addlin = 2 + 1 + 4 + gnchem
      call opage(tinquire, ' ', 0, addlin, xquery)
c
      write (qhs(pq1), 9140) fish_la50(kspecies)
      call compress(qhs(pq1), -1, nq1)
      write (jout, 9120)
      write (jout, 9130) qhs(pq1)(1:nq1)
c
      write (jout, *)
      write (jout, 9150) 'Toxicant name       ', '   La50    ', 
     &   '   lc50    '
      write (jout, 9150) '                    ', ' (aqueous) ', 
     &   '  [ppm]    '
      write (jout, 9150) '--------------------', '-----------', 
     &   '-----------'
c
      do jchem = 1, gnchem
         la50j = la50(lc50func(jchem, kspecies), 
     &      lc50par(1, jchem, kspecies), acw(jchem), molwt(jchem), 
     &      maxpar, 1)
         actvty_to_aq = molwt(jchem) * 1.0e+03 / (acw(jchem) * nuw)
         lc50j = la50j * actvty_to_aq
c
         ntt = 20       ! "20" : see note above    ! Xslen(Toxlab(jchem))  
         write (jout, 9160) toxlab(jchem)(1:ntt), la50j, lc50j
      enddo
c
      call heapop(pq1)
c
      return
      end
      subroutine owtable0(uu, cname, chead, nchem, toxlab, zzvar)
c
c update: 14:03 tue 16-aug-1994.
c output a two-column table
c
      include 'page.par'
c
      integer uu, nchem
      real zzvar( * )
      character*( * ) cname, chead, toxlab( * )
c
      integer jchem, ntt, xslen, addlin, xquery
      external xslen
c
 9110 format (5x,a20,1x,a)
 9120 format (5x,a20,1x,1pg10.3)
c
      addlin = 2 + nchem
      call opage(tinquire, ' ', 0, addlin, xquery)
c
      write (uu, 9110) 'Toxicant name       ', cname // '-' // chead
      write (uu, 9110) '--------------------', '------------------'
c
      do jchem = 1, nchem
         ntt = 20       ! "20" : see note above    ! Xslen(Toxlab(jchem))  
         write (uu, 9120) toxlab(jchem)(1:ntt), zzvar(jchem)
      enddo
c
      return
      end
      subroutine owtable1(uu, nchem, toxlab, cname, zzfunc, zzfil, 
     &   zzconc, zzpl, zzbmf)
c
c update: wed 08:37 22-apr-1992.
c "zz" == ("benthos" | "plankton" | "cfish")
c "func" == (tequilibrium | tconstant | tfile)
c
c generate a table of the form
c
c zz-pl: #
c zz-file: #
c                       zz-func
c Toxicant-Name         (BMF | concentration [ppm])
c ##################    #############
c
c declaration of fortran parameters
c
      include 'page.par'
      include 'simul.par'
c
c declarations of subroutine's formal parameters
c;;
      character*( * ) cname, zzfil, toxlab( * )
      integer uu, nchem, zzfunc
      real zzconc( * ), zzpl, zzbmf( * )
c
      integer xslen, nfil, xquery
      external xslen
c
 9110 format (5x,'Concentration of chemical in ',a,': file = "',a,'"')
 9120 format (5x,'Concentration of chemical in ',a,
     &   ': equilibrium; lipid fraction = ',0pf5.3)
 9130 format (5x,'Concentration of chemical in ',a,': constant')
c
      if (zzfunc .eq. tfile) then
         nfil = xslen(zzfil)
         call opage(tinquire, ' ', 0, 1, xquery)
         write (uu, 9110) cname, zzfil(1:nfil)
c
      elseif (zzfunc .eq. tequilibrium) then
         call opage(tinquire, ' ', 0, 2, xquery)
         write (uu, *)
         write (uu, 9120) cname, zzpl
         call owtable0(uu, cname, 'bmf', nchem, toxlab, zzbmf)
         call opage(tlines, ' ', 0, 1, xquery)
c
      elseif (zzfunc .eq. tconstant) then
         call opage(tinquire, ' ', 0, 2, xquery)
         write (uu, *)
         write (uu, 9130) cname
         call owtable0(uu, cname, 'concentration [ppm]', nchem, toxlab,
     &      zzconc)
         call opage(tlines, ' ', 0, 1, xquery)
      endif
c
      return
      end
      real function pafun(xpl, pa_parms)
c
c update: fri 09:29 7-jun-1991.
c
c determine fish's moisture content from its lipid fraction.
c in general pl and pa are inversely related, i.e., pa = l0 - l1*pl, based
c on analyses of
c (1) eschmeyer and phyllips 1965.trans.am.fish.soc 94-62
c (2) staples and nomura 1976.j.fish biol.9:29-
c (3) elliott 1976.j.animal ecol.45:273-
c (4) lowe et al. 1985. arch.environ.contam.toxicol. 14:363-
c (5) schmitt et al. 1985. arch.environ.contam.toxicol. 14:225-
c (6) shubina and rychagova 1982. j. icthylogy
c (7) kunisaki et al. 1986. bull.jap.soc.sci.fish. 52:333-
c (8) morishita et al. 1987. bull.jap.soc.sci.fish. 53:1601-
c (9) groves 1970. j.fish.res.bd.canada 27:929-
c (10) brett et al. 1969. j.fish.res.bd.canada 26:2363-
c (11) gill and weatherly 1984. j.fish biol. 25:491-
c approximate values of l0 and l1 are 0.8 and 1.25, respectively.
c
ccc      Pafun(zpl) = 0.80 - 1.25 * zpl
c
      real xpl, pa_parms( * )
c
      pafun = pa_parms(1) + pa_parms(2) * xpl
c
      return
      end
      subroutine pgmunits(ierror)
c
c update: 17:56 fri 4-mar-1994.
c
c this subroutine converts all user input/data into program units
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'habitat.par'
      include 'noval.par'
      include 'physio.par'
      include 'plots.par'
      include 'simul.par'
c
      include 'diet.def'
      include 'fish.def'
      include 'globpar.def'
      include 'habitat.def'
      include 'idfiles.def'
      include 'obsdata.def'
      include 'time.def'
      include 'units.def'
      include 'vdefined.def'
c
c declarations of subroutine's formal parameters
c
      integer ierror
c
c local variables
c
      character*(stdlen) wmsg
      integer jchem, jobs, jage, jspecies, nchem, jrange, nmsg
      real cf2ppm
      logical xxok
c
      include 'vdefined.sfn'
c
 9110 format (' ?? Pgmunits: number of fish .le. 0')
 9120 format (' ?? Pgmunits: number of chemicals .le. 0')
c
 9130 format (' ?? Pgmunits: user units unresolved.')
 9140 format (' ?? Pgmunits: incorrect "Tunits"')
 9150 format (' ?? Pgmunits: incorrect "Wtunits"')
 9160 format (' ?? Pgmunits: incorrect "Cwunits"')
 9170 format (' ?? Pgmunits: incorrect "Cfunits"')
 9180 format (' ?? Pgmunits: cannot convert "bcf" to',
     &   ' "ppm" for non-constant cwater')
c
      xxok = .true.
      nchem = gnchem
      ierror = 0
      if (gnspecies .le. 0) then
         ierror = ierror + 1
         write (stdout, 9110)
      elseif (nchem .le. 0) then
         ierror = ierror + 1
         write (stdout, 9120)
      endif
      xxok = (ierror .eq. 0)
      if ( .not. xxok) then
         call errlog(.true., '?? unit errors detected.', -1)
      endif
c
c convert user initial conditions to program units;
c
      ierror = 0
      call unitdrv(tunits, pgm_time, t_conv, xxok, wmsg, nmsg)
      if ( .not. xxok) then
         write (stdout, 9140)
         ierror = ierror + 1
      endif
c
      call unitdrv(wtunits, pgm_mass, wt_conv, xxok, wmsg, nmsg)
      if ( .not. xxok) then
         write (stdout, 9150)
         ierror = ierror + 1
      endif
c
      call unitdrv(cwunits, pgm_conc, cw_conv, xxok, wmsg, nmsg)
      if ( .not. xxok) then
         write (stdout, 9160)
         ierror = ierror + 1
      endif
c
      if (cfunits(1:3) .ne. 'bcf') then
         call unitdrv(cfunits, pgm_conc, cf_conv, xxok, wmsg, nmsg)
         if ( .not. xxok) then
            write (stdout, 9170)
            ierror = ierror + 1
         endif
      endif
c
      xxok = (ierror .eq. 0)
      if ( .not. xxok) then
         write (stdout, 9130)
         write (jerr, 9130)
         errused = .true.
         go to 110
      endif
c
      if (vdefined(simul_beg)) simul_beg = simul_beg * t_conv
      if (vdefined(simul_end)) simul_end = simul_end * t_conv
c
      do jspecies = 1, gnspecies
         do jobs = 1, nobs(jspecies)
            wobs(jobs, jspecies) = wobs(jobs, jspecies) * wt_conv
            tobs(jobs, jspecies) = tobs(jobs, jspecies) * t_conv
         enddo
         do jage = 1, xmaximum_age(jspecies)
            vv_iniwt(jage, jspecies) = vv_iniwt(jage, jspecies) * 
     &         wt_conv
            if ((vv_plfunc(jage, jspecies) .eq. tallometric) .or. (
     &         vv_plfunc(jage, jspecies) .eq. tdatabase) .or. (
     &         vv_plfunc(jage, jspecies) .eq. tfishpar)) then
               vv_pval(vpl1, jage, jspecies) = 
     &            vv_pval(vpl1, jage, jspecies) / wt_conv ** 
     &            vv_pval(vpl2, jage, jspecies)
            elseif (vv_plfunc(jage, jspecies) .eq. tlinear) then
               vv_pval(vpl2, jage, jspecies) = 
     &            vv_pval(vpl2, jage, jspecies) / wt_conv
            endif
         enddo
         if (xdiet) then
            do jrange = 1, range_numof(jspecies)
               if (range_type(jspecies) .eq. tage) then
c                 ! continue
               elseif (range_type(jspecies) .eq. tweight) then
                  range_lowb(jrange, jspecies) = 
     &               range_lowb(jrange, jspecies) * wt_conv
                  range_uppb(jrange, jspecies) = 
     &               range_uppb(jrange, jspecies) * wt_conv
               elseif (range_type(jspecies) .eq. tlength) then
ccc                  Range_lowb(jrange,jspecies) = Range_lowb(jrange,jspecies) *
ccc     &                                          Wt_conv
ccc                  Range_uppb(jrange,jspecies) = Range_uppb(jrange,jspecies) *
ccc     &                                          Wt_conv
               endif
            enddo
         endif
      enddo
c
      if (twfunc .eq. tsin) then
         twpar(3) = twpar(3) / t_conv
      endif
c
      do jchem = 1, gnchem
         if (cwfunc(jchem) .eq. tconstant) then
            cwpar(1, jchem) = cwpar(1, jchem) * cw_conv
         elseif (cwfunc(jchem) .eq. tsin) then
            cwpar(1, jchem) = cwpar(1, jchem) * cw_conv
            cwpar(2, jchem) = cwpar(2, jchem) * cw_conv
            cwpar(3, jchem) = cwpar(3, jchem) / t_conv
         elseif (cwfunc(jchem) .eq. texp) then
            cwpar(1, jchem) = cwpar(1, jchem) * cw_conv
            cwpar(2, jchem) = cwpar(2, jchem) * cw_conv
            cwpar(3, jchem) = cwpar(3, jchem) / t_conv
         endif
c
         if (cfunits(1:3) .eq. 'bcf') then
            if (cwfunc(jchem) .eq. tconstant) then
               cf2ppm = cwpar(1, jchem)
            else
               write (stdout, 9180)
               write (jerr, 9180)
               errused = .true.
               call errlog(.true., ' ', 0)
            endif
         else
            cf2ppm = cf_conv
         endif
c
         if (cfish_chem_func .eq. tconstant) then
            cfish_chem_conc(jchem) = cfish_chem_conc(jchem) * cf2ppm
         endif
c
         if (benthos_chem_func .eq. tconstant) then
            benthos_chem_conc(jchem) = benthos_chem_conc(jchem) * cf2ppm
         endif
c
         if (plankton_chem_func .eq. tconstant) then
            plankton_chem_conc(jchem) = plankton_chem_conc(jchem) * 
     &         cf2ppm
         endif
c
         if (food_chem_func .eq. tconstant) then
            food_chem_conc(jchem) = food_chem_conc(jchem) * cf2ppm
         endif
c
         do jspecies = 1, gnspecies
            do jobs = 1, nobs(jspecies)
               cfobs(jobs, jchem, jspecies) = 
     &            cfobs(jobs, jchem, jspecies) * cf2ppm
            enddo
            do jage = 1, xmaximum_age(jspecies)
               vv_inicf(jchem, jage, jspecies) = 
     &            vv_inicf(jchem, jage, jspecies) * cf2ppm
            enddo
         enddo
      enddo
c
  110 continue
      if (xxok) then
         return
      else
         call errlog(.true., ' ', 0)
      endif
c
      end
      real function plfun(wt, plfunc, plpar)
c
c update: mon 09:26 9-mar-1992.
c
c determine fish lipid fraction.
c
      include 'simul.par'
c
      real plpar( * ), wt
      integer plfunc
c
      if (plfunc .eq. tconstant) then
         plfun = plpar(1)
c
      elseif (plfunc .eq. tlinear) then
         plfun = plpar(1) + plpar(2) * wt
c
      elseif ((plfunc .eq. tallometric) .or. (plfunc .eq. tdatabase) 
     &   .or. (plfunc .eq. tfishpar)) then
         plfun = plpar(1) * wt ** plpar(2)
      endif
c
      return
      end
      subroutine plt0(jspecies, nage, edadp)
c
c update: 17:56 fri 4-mar-1994.
c Plot(aroclor | activity) vs (t | wt)
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'plots.par'
      include 'phylum.par'
      include 'page.par'
      include 'strings.par'
      include 'idfiles.def'
      include 'globpar.def'
      include 'fish.def'
      include 'options.def'
      include 'obsdata.def'
      include 'work.def'
      include 'units.def'
      include 'heap.def'
c
      integer jspecies, nage, edadp( * )
c
      integer kobs, phlab, pxlab, pylab
      integer nspp, xslen, xquery
      logical issuepage
      external xslen
c;;
      pxlab = 0 ! assign heap storage            
      pylab = 0
      phlab = 0
      call heapush(pxlab)
      call heapush(pylab)
      call heapush(phlab)
c
      nspp = xslen(spplab(jspecies))
c
      call opage(tlines, ' ', 0, 2, xquery)
      issuepage = (xcfxt .or. xcfxwt)   ! previous plots.          
c
      if (xcf_aro_t) then       ! plot dynamics of aroclor vs time        
         qhs(pylab) = 'aroclor'
         qhs(phlab) = 'aroclor in ' // spplab(jspecies)(1:nspp)
         if (data_t(jspecies) .and. data_c(jspecies)) then
            kobs = nobs(jspecies)
         else
            kobs = 0
         endif
         call pltclor(jspecies, nage, edadp, 
     &      wtfac_aroclor(1, pt_aroclor), gnchem, tobs, cfobs, kobs, 
     &      qq_tcal, qq_cfcal, qq_nxy, pgm_time, qhs(pylab), qhs(phlab),
     &      xdata, issuepage)
      endif
c
      if (xcf_aro_wt) then      ! plot dynamics of aroclor vs fish's body weight
         qhs(pxlab) = 'wt, gram live'
         qhs(pylab) = 'aroclor'
         qhs(phlab) = 'aroclor in ' // spplab(jspecies)(1:nspp)
         if (data_w(jspecies) .and. data_c(jspecies)) then
            kobs = nobs(jspecies)
         else
            kobs = 0
         endif
         call pltclor(jspecies, nage, edadp, 
     &      wtfac_aroclor(1, pwt_aroclor), gnchem, wobs, cfobs, kobs, 
     &      qq_wcal, qq_cfcal, qq_nxy, qhs(pxlab), qhs(pylab), 
     &      qhs(phlab), xdata, issuepage)
      endif
c
      if (xactvt_t) then        ! plot dynamics of activity vs time       
         qhs(pylab) = 'chemical activity'
         qhs(phlab) = 'activity of the mixture of chemicals in ' // 
     &      spplab(jspecies)(1:nspp)
         call pltactvt(jspecies, nage, edadp, qq_tcal, qq_hactvt, 
     &      qq_nxy, pgm_time, qhs(pylab), qhs(phlab), xdata, issuepage)
      endif
c
      if (xactvt_wt) then       ! plot dynamics of activity vs fish's body weight
         qhs(pxlab) = 'wt, gram live'
         qhs(pylab) = 'chemical activity'
         qhs(phlab) = 'activity of the mixture of chemicals in ' // 
     &      spplab(jspecies)(1:nspp)
         call pltactvt(jspecies, nage, edadp, qq_wcal, qq_hactvt, 
     &      qq_nxy, qhs(pxlab), qhs(pylab), qhs(phlab), xdata, issuepage
     &      )
      endif
c
      call heapop(phlab)        ! release heap storage                    
      call heapop(pylab)
      call heapop(pxlab)
c
      return
      end
      subroutine pltactvt(kspecies, nage, edadp, xcal, ycal, kcal, 
     &   xlabel, ylabel, hlabel, xdata, issuepage)
c
c update: 17:56 fri 4-mar-1994.
c Plot(activity | wt) vs (t | wt)
c
c xcal == ("Qq_tcal" | "Qq_wcal")
c ycal == ("Qq_hactvt")
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'page.par'
      include 'plots.par'
      include 'idfiles.def'
      include 'plottmp.def'
c
      integer kspecies, nage, edadp( * )
      integer kcal(maxage)
      real xcal(mp3, maxage), ycal(mp3, maxage)
      logical xdata, issuepage
      character*( * ) xlabel, ylabel, hlabel
c
c miscellaneous declarations
c
      integer jage, agep, xslen, nxx, nyy, nhh, addlin, xquery
      real zmax, zmin
      external xslen
c
 9110 format (1x,a,//)
 9120 format (/,1x,14x,'x-axis: ',a,/,1x,14x,'y-axis: ',a)
c
      addlin = 1 + 2 + (nrow + 3) + 3
      if (issuepage) then
         call opage(tinquire, ' ', 0, -addlin, xquery)
      else
         call opage(tinquire, ' ', 0, addlin, xquery)
      endif
      issuepage = .true.
c
c determine range of data;
c
      xmin = 1.0e+30
      xmax = -xmin
      ymin = xmin
      ymax = xmax
      do jage = 1, nage
         agep = edadp(jage)
         call bnd1(xcal(1, agep), kcal(agep), zmax, zmin)
         xmax = max(xmax, zmax)
         xmin = min(xmin, zmin)
         call bnd1(ycal(1, agep), kcal(agep), zmax, zmin)
         ymax = max(ymax, zmax)
         ymin = min(ymin, zmin)
      enddo
c
      call pltinit()    ! initialize plotting buffer                 
      if (xdata) then   ! dump data to file if requested;         
         call pltdump0(xlabel, ylabel, hlabel, nage)
      endif
c
      do jage = 1, nage ! load arrays                             
         agep = edadp(jage)
         call pltload(xcal(1, agep), ycal(1, agep), kcal(agep), 
     &      steo(jage))
         if (xdata) then        ! dump data to file if requested;         
            call pltdump1(xcal(1, agep), ycal(1, agep), kcal(agep))
         endif
      enddo
c
c finally, plot;
c
      nxx = xslen(xlabel)
      nyy = xslen(ylabel)
      nhh = xslen(hlabel)
c
      write (jout, *)
      if (nhh .gt. 0) then
         write (jout, 9110) hlabel(1:nhh)
      endif
      call pltbdump(jout)
      write (jout, 9120) xlabel(1:nxx), ylabel(1:nyy)
c
      continue
      return
      end
      subroutine pltbdump(uu)
c
c update: fri 13:50 15-nov-1991.
c the module dumps the plotting buffer;
c it does not call "Opage"; the driver must ensure that the plot will fit in
c     one page; it generates "nrow + 3" lines;
c
c input in common;
c
      include 'chem.par'
      include 'fish.par'
      include 'plots.par'
      include 'plottmp.def'
c
      integer uu
c
      real xanot(11), yanot, xff, yff
      integer nn, it, ix, kk, nx, nx1
c
      yff = 1.00 / yscale
      do nn = 1, nrow
         yanot = ymin + float(nrow - nn) * yff
c
c compute the starting and ending array elements for each row;
c row starts at: nrow * ncol  -  nn * ncol  +  1
c row ends   at: (row start)  +  ncol  -  1
c row    length: ncol
c
         it = nrow * ncol - nn * ncol + 1
         ix = it + ncol
  110    continue       ! do not plot trailing blanks;      
         ix = ix - 1
         if (ix .ge. it) then
            if (bufer(ix) .eq. ' ') go to 110
         endif
         write (uu, 9110) yanot, (bufer(kk), kk = it, ix)
      enddo
c
c compute the number of x annotations (nx).
c allow 10 characters for each x annotation
c
      nx = ncol / 10
      xff = 1.00 / xscale
      do nn = 1, nx
         xanot(nn) = xmin + float(10 * (nn - 1)) * xff
      enddo
      xanot(nx + 1) = xmax
c
      nx1 = nx + 1
      write (uu, 9120) ('+---------', nn = 1, nx1)
      write (uu, 9130) (xanot(nn), nn = 1, nx1, 2)
      write (uu, 9140) (xanot(nn), nn = 2, nx1, 2)
c
      return
c
 9110 format (1x,1pg12.4,1x,'|',110a1)
 9120 format (1x,12x,1x,1x,20a)
 9130 format (1x,10x,1x,20(1pg12.4,8x))
 9140 format (1x,20x,1x,20(1pg12.4,8x))
c
      end
      subroutine pltchem(xcal, ycal, kcal, xlabel, ylabel, hlabel, 
     &   xdata, issuepage)
c
c update: 17:30 fri 4-mar-1994.
c Plot(ycal, xcal)
c
c xcal == (vector)
c ycal == (vector)
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'page.par'
      include 'plots.par'
      include 'idfiles.def'
      include 'plottmp.def'
c
      integer kcal
      real xcal( * ), ycal( * )
      logical xdata, issuepage
      character*( * ) xlabel, ylabel, hlabel
c
c miscellaneous declarations
c
      integer xslen, nxx, nyy, nhh, addlin, xquery
      real zmax, zmin
      external xslen
c
 9110 format (1x,a,//)
 9120 format (/,1x,14x,'x-axis: ',a,/,1x,14x,'y-axis: ',a)
c
      if (kcal .gt. 0) then
         addlin = 1 + 2 + (nrow + 3) + 3
         if (issuepage) then
            call opage(tinquire, ' ', 0, -addlin, xquery)
         else
            call opage(tinquire, ' ', 0, addlin, xquery)
         endif
         issuepage = .true.
c
c determine range of data
c
         xmin = 1.0e+30
         xmax = -xmin
         ymin = xmin
         ymax = xmax
c
         call bnd1(xcal, kcal, zmax, zmin)
         xmax = max(xmax, zmax)
         xmin = min(xmin, zmin)
c
         call bnd1(ycal, kcal, zmax, zmin)
         ymax = max(ymax, zmax)
         ymin = min(ymin, zmin)
c
         call pltinit() ! initialize plotting buffer
         call pltload(xcal, ycal, kcal, steo(1))        ! load array             
c
c finally, plot;
c
         nxx = xslen(xlabel)
         nyy = xslen(ylabel)
         nhh = xslen(hlabel)
c
         write (jout, *)
         if (nhh .gt. 0) then
            write (jout, 9110) hlabel(1:nhh)
         endif
         call pltbdump(jout)
         write (jout, 9120) xlabel(1:nxx), ylabel(1:nyy)
c
         if (xdata) then        ! dump data to file if requested;         
            call pltdump0(xlabel, ylabel, hlabel, (1))  ! 1 set;      
            call pltdump1(xcal, ycal, kcal)
         endif
      endif
c
  110 continue
      return
      end
      subroutine pltclor(jspecies, nage, edadp, wfac, nchem, xobs, yobs,
     &   kobs, xcal, ycal, kcal, xlabel, ylabel, hlabel, xdata, 
     &   issuepage)
c
c update: 17:30 fri 4-mar-1994.
c Plot(aroclor) vs (t | wt)
c
c wfac: aroclor weighting factor;
c
c xobs == ("Tobs" | "Wobs")
c yobs == ("Cfobs")
c xcal == ("Qq_tcal" | "Qq_wcal")
c ycal == ("Qq_cfcal")
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'noval.par'
      include 'page.par'
      include 'plots.par'
      include 'idfiles.def'
      include 'plottmp.def'
c
      integer jspecies, nage, edadp( * )
      integer kobs, kcal(maxage, maxspecies), nchem
      real wfac( * )
      real xobs(maxobs, maxspecies), yobs(maxobs, maxchem, maxspecies)
      real xcal(mp3, maxage, maxspecies)
      real ycal(mp3, maxchem, maxage, maxspecies)
      logical xdata, issuepage
      character*( * ) xlabel, ylabel, hlabel
c
c miscellaneous declarations
c
      integer agep, jage, xslen, nxx, nyy, nhh, jobs, kpts, jchem
      integer addlin, xquery
      real zmax, zmin, wmid
      logical all_defined
      external xslen
c
      include 'vdefined.def'
      include 'vdefined.sfn'
c
 9110 format (1x,a,//)
 9120 format (/,1x,14x,'x-axis: ',a,/,1x,14x,'y-axis: ',a)
c
      addlin = 1 + 2 + (nrow + 3) + 3
      if (issuepage) then
         call opage(tinquire, ' ', 0, -addlin, xquery)
      else
         call opage(tinquire, ' ', 0, addlin, xquery)
      endif
      issuepage = .true.
c
c determine range of data;
c if we are willing to provide more temporary storage we can save
c the computed aroclor values, so we would not have to recompute;
c
      xmin = 1.0e+30
      xmax = -xmin
      ymin = xmin
      ymax = xmax
      do jage = 1, nage
         agep = edadp(jage)
         call bnd1(xcal(1, agep, jspecies), kcal(agep, jspecies), zmax,
     &      zmin)
         xmax = max(xmax, zmax)
         xmin = min(xmin, zmin)
         call pltclor0(kcal(agep, jspecies), mp3, 
     &      ycal(1, 1, agep, jspecies), nchem, wfac, uy)
         call bnd1(uy, kcal(agep, jspecies), zmax, zmin)
         ymax = max(ymax, zmax)
         ymin = min(ymin, zmin)
      enddo
c
c if the user provided data, plot only data which falls in [Xmin, Xmax]
c we will save the aroclor values for the observed data in (Ux, Uy)
c
      if (kobs .gt. 0) then
         kpts = 0
         do jobs = 1, kobs
            wmid = xobs(jobs, jspecies)
            if (vdefined(wmid)) then
               if ((xmin .le. wmid) .and. (wmid .le. xmax)) then
                  kpts = kpts + 1
                  ux(kpts) = wmid
                  all_defined = .true.
                  do jchem = 1, nchem
                     uz(kpts, jchem) = yobs(jobs, jchem, jspecies)
                     all_defined = all_defined .and. 
     &                  vdefined(yobs(jobs, jchem, jspecies))
                  enddo
                  if ( .not. all_defined) kpts = kpts - 1
               endif
            endif
         enddo
         if (kpts .gt. 0) then
            call pltclor0(kpts, mp3, uz, nchem, wfac, uy)
            call bnd1(uy, kpts, zmax, zmin)
            ymax = max(ymax, zmax)
            ymin = min(ymin, zmin)
         endif
      else
         kpts = 0
      endif
c
      call pltinit()    ! initialize plotting buffer                 
      if (xdata) then   ! dump data to file if requested;         
         call pltdump0(xlabel, ylabel, hlabel, nage + 1)        ! nage + 1 sets;
      endif
c
      do jage = 1, nage ! load arrays                             
         agep = edadp(jage)
         call pltclor0(kcal(agep, jspecies), mp3, 
     &      ycal(1, 1, agep, jspecies), nchem, wfac, uz(1, 1))
         call pltload(xcal(1, agep, jspecies), uz(1, 1), 
     &      kcal(agep, jspecies), steo(jage))
         if (xdata) then        ! dump data to file if requested;         
            call pltdump1(xcal(1, agep, jspecies), uz(1, 1), 
     &         kcal(agep, jspecies))
         endif
      enddo
c
      call pltload(ux, uy, kpts, sobs)  ! "obs" data should be loaded last
      if (xdata) then   ! dump data to file if requested;
         call pltdump1(ux, uy, kpts)
      endif
c
c finally, plot;
c
      nxx = xslen(xlabel)
      nyy = xslen(ylabel)
      nhh = xslen(hlabel)
c
      write (jout, *)
      if (nhh .gt. 0) then
         write (jout, 9110) hlabel(1:nhh)
      endif
      call pltbdump(jout)
      write (jout, 9120) xlabel(1:nxx), ylabel(1:nyy)
c
      continue
      return
      end
      subroutine pltclor0(npts, mdim, vconc, nchem, vwt, haroclor)
c
c update: 11:45 fri 9-sep-1994.
c
c compute aroclor values & store in array
c
c input
c   npts:                    number of points defined
c   mdim:                    actual first dimension of matrix *vconc*
c   vconc(#points,#chem)     chemical concentrations
c   nchem:                   number of chemicals
c   vwt:                     weighting factor for each chemical
c output:
c   haroclor:                aroclor values
c
      integer npts, mdim, nchem
      real vconc(mdim, * ), vwt( * ), haroclor( * )
c
      integer jpt, jchem
      real sct, wct, ccj
      logical treq
      external treq
c
      do jpt = 1, npts
         sct = 0.0e+00
         wct = 0.0e+00
         do jchem = 1, nchem
            ccj = vconc(jpt, jchem)
            sct = sct + ccj
            wct = wct + ccj * vwt(jchem)
         enddo
         if (sct .gt. 0.0e+00) then
            haroclor(jpt) = wct / sct
         else
            haroclor(jpt) = 0.0e+00
         endif
      enddo
c
c kill the first point if the aroclor == 0
c
      if (treq(haroclor(1), 0.0e+00)) then
         haroclor(1) = haroclor(2)
      endif
c
      return
      end
      subroutine pltdump0(xlabel, ylabel, hlabel, nsets)
c
c update: 17:30 fri 4-mar-1994.
c Pltdump0: dump labels and total number of sets
c Pltdump1: dump plotting data
c
c nsets: number of sets in this block;
c
c notes:
c    - each "section" of the file is of the form:
c       xlabel: label
c       ylabel: label
c       hlabel: label
c       #nsets
c       #nset_1
c           xpt_1(1)       ypt_1(1)
c              .              .
c              .              .
c              .              .
c           xpt_1(nset_1)  ypt_1(nset_1)
c       #nset_2
c           xpt_2(1)       ypt_2(1)
c              .              .
c              .              .
c              .              .
c           xpt_2(nset_1)  ypt_2(nset_1)
c       .
c       .
c       .
c       #nset_n
c           xpt_n(1)       ypt_n(1)
c              .              .
c              .              .
c              .              .
c           xpt_n(nset_1)  ypt_n(nset_n)
c
c if there is observed data, it will be the last set (nset_n);
c nsets, as well as some (or all) of the nset_# may be zero;
c;;
      include 'xglobal.par'
      include 'idfiles.def'
c
      integer nsets
      character*( * ) xlabel, ylabel, hlabel
c
      integer nx, ny, nz, xslen
      external xslen
c
 9110 format ('xlabel: ',a,/,'ylabel: ',a,/,'hlabel: ',a)
 9120 format (i5)
c
      nx = max(xslen(xlabel), 1)
      ny = max(xslen(ylabel), 1)
      nz = max(xslen(hlabel), 1)
      write (jts, 9110) xlabel(1:nx), ylabel(1:ny), hlabel(1:nz)
      write (jts, 9120) nsets
c
      return
      end
      subroutine pltdump1(xpt, ypt, npt)
c
c update: 17:30 fri 4-mar-1994.
c Pltdump0: dump labels and total number of sets
c Pltdump1: dump plotting data
c
c npt: number of points (npt .ge. 0)
c
c notes:
c    - each "section" of the file is of the form:
c       xlabel: label
c       ylabel: label
c       hlabel: label
c       #nsets
c       #nset_1
c           xpt_1(1)       ypt_1(1)
c              .              .
c              .              .
c              .              .
c           xpt_1(nset_1)  ypt_1(nset_1)
c       #nset_2
c           xpt_2(1)       ypt_2(1)
c              .              .
c              .              .
c              .              .
c           xpt_2(nset_1)  ypt_2(nset_1)
c       .
c       .
c       .
c       #nset_n
c           xpt_n(1)       ypt_n(1)
c              .              .
c              .              .
c              .              .
c           xpt_n(nset_1)  ypt_n(nset_n)
c
c if there is observed data, it will be the last set (nset_n);
c nsets, as well as some (or all) of the nset_# may be zero;
c;;
      include 'xglobal.par'
      include 'idfiles.def'
c
      integer npt
      real xpt( * ), ypt( * )
c
      integer jj
c
 9110 format (i5)
 9120 format (1p2g14.6)
c
      write (jts, 9110) npt
      do jj = 1, npt
         write (jts, 9120) xpt(jj), ypt(jj)
      enddo
c
      return
      end
      subroutine pltgamma(jspecies, nage, edadp)
c
c update: 16:34 fri 4-mar-1994.
c plot growth dynamics vs. time for the given fish species;
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'plots.par'
      include 'phylum.par'
      include 'noval.par'
      include 'page.par'
      include 'strings.par'
      include 'idfiles.def'
      include 'fish.def'
      include 'options.def'
      include 'obsdata.def'
      include 'work.def'
      include 'heap.def'
      include 'units.def'
      include 'plottmp.def'
c
      integer jspecies, nage, edadp( * )
c
c miscellaneous declarations
c
      integer agep, pqt, nqt, pqy, nqy, jage, xslen
      integer nspp, kpts, jobs, nqx, addlin, xquery
      real zmax, zmin, wmid
      external xslen
c
      include 'vdefined.def'
      include 'vdefined.sfn'
c
 9110 format (1x,a,/)
 9120 format (/,1x,14x,'x-axis: ',a,/,1x,14x,'y-axis: ',a)
c
      if (xwtxt) then
         addlin = 1 + 2 + (nrow + 3) + 3
         call opage(tinquire, ' ', 0, addlin, xquery)
c
         pqt = 0        ! assign heap storage            
         pqy = 0
         call heapush(pqt)      ! title                                
         call heapush(pqy)      ! y-axis label                         
         qhs(pqy) = 'wt, grams live'
         nspp = xslen(spplab(jspecies))
         qhs(pqt) = 'growth of ' // spplab(jspecies)(1:nspp)
c
c determine range of data
c
         xmin = 1.0e+30
         xmax = -xmin
         ymin = xmin
         ymax = xmax
         do jage = 1, nage
            agep = edadp(jage)
            call bnd1(qq_tcal(1, agep, jspecies), 
     &         qq_nxy(agep, jspecies), zmax, zmin)
            xmax = max(xmax, zmax)
            xmin = min(xmin, zmin)
            call bnd1(qq_wcal(1, agep, jspecies), 
     &         qq_nxy(agep, jspecies), zmax, zmin)
            ymax = max(ymax, zmax)
            ymin = min(ymin, zmin)
         enddo
c
c if the user provided data, plot only data which falls in [Xmin, Xmax]
c
         if (data_t(jspecies) .and. data_w(jspecies)) then
            kpts = 0
            do jobs = 1, nobs(jspecies)
               wmid = tobs(jobs, jspecies)
               if (vdefined(wmid)) then
                  if ((xmin .le. wmid) .and. (wmid .le. xmax)) then
                     if (vdefined(wobs(jobs, jspecies))) then
                        kpts = kpts + 1
                        ux(kpts) = tobs(jobs, jspecies)
                        uy(kpts) = wobs(jobs, jspecies)
                        ymax = max(ymax, uy(kpts))      ! update y-range
                        ymin = min(ymin, uy(kpts))
                     endif
                  endif
               endif
            enddo
         else
            kpts = 0
         endif
c
         call pltinit() ! initialize plotting buffer                 
         if (xdata) then        ! dump data to file if requested;         
            call pltdump0(pgm_time, qhs(pqy), qhs(pqt), nage + 1)
         endif
c
         do jage = 1, nage      ! load arrays              
            agep = edadp(jage)
            call pltload(qq_tcal(1, agep, jspecies), 
     &         qq_wcal(1, agep, jspecies), qq_nxy(agep, jspecies), 
     &         steo(jage))
            if (xdata) then     ! dump data to file if requested;
               call pltdump1(qq_tcal(1, agep, jspecies), 
     &            qq_wcal(1, agep, jspecies), qq_nxy(agep, jspecies))
            endif
         enddo
c
         call pltload(ux, uy, kpts, sobs)       ! "obs" data should be loaded last
         if (xdata) then        ! dump data to file if requested;
            call pltdump1(ux, uy, kpts)
         endif
c
         write (jout, *)
c
c finally, plot;
c
         nqx = xslen(pgm_time)
         nqy = xslen(qhs(pqy))
         nqt = xslen(qhs(pqt))
c
         if (nqt .gt. 0) then
            write (jout, 9110) qhs(pqt)(1:nqt)
         endif
         call pltbdump(jout)
         write (jout, 9120) pgm_time(1:nqx), qhs(pqy)(1:nqy)
c
         call heapop(pqy)       ! release heap storage                 
         call heapop(pqt)
      endif
c
  110 continue
      return
      end
      subroutine pltinit()
c
c update: 11:28 fri 9-sep-1994.
c initialize plotting buffer with blanks;
c set x-scale and y-scale factors;
c
c note:
c - by this time Xmax, Xmin, Ymax, and Ymin (in common) should be set;
c
      include 'chem.par'
      include 'fish.par'
      include 'numbers.par'
      include 'plots.par'
      include 'plottmp.def'
c
      integer nn
      logical norange, treq, trne
      real wmid
      external treq, trne
c
      do nn = 1, maxbuf
         bufer(nn) = ' '
      enddo
c
c if data has no range, generate bounds +/- 5% of constant value.
c
      norange = treq(xmin, xmax)
      if (norange) then
         wmid = xmin
         if (trne(wmid, zero)) then
            xmax = 1.05 * wmid
            xmin = 0.95 * wmid
         else
            xmax = 0.1
            xmin = zero
         endif
      endif
c
      norange = treq(ymin, ymax)
      if (norange) then
         wmid = ymin
         if (trne(wmid, zero)) then
            ymax = 1.05 * wmid
            ymin = 0.95 * wmid
         else
            ymax = 0.1
            ymin = zero
         endif
      endif
c
      xscale = float(ncol - 1) / (xmax - xmin)
      yscale = float(nrow - 1) / (ymax - ymin)
c
      return
      end
      subroutine pltload(xobs, yobs, kobs, xsym)
c
c update: thu 09:27 28-mar-1991.
c load plotting buffer with the curve (xobs, yobs)
c
      include 'chem.par'
      include 'fish.par'
      include 'plots.par'
      include 'plottmp.def'
c
      real xobs( * ), yobs( * )
      integer kobs
      character*1 xsym
      integer jb, jx, jy, jobs
c
c determine the (x,y) "pixel" the point falls into;
c load the pixel with the given symbol;
c
      do jobs = 1, kobs
         jy = nint(1.00 + yscale * (yobs(jobs) - ymin))
         jx = nint(1.00 + xscale * (xobs(jobs) - xmin))
         jb = (jy - 1) * ncol + jx
         bufer(jb) = xsym
      enddo
c
      return
      end
      subroutine plttcf(jchem, jspecies, nage, edadp, xobs, yobs, kobs,
     &   xcal, ycal, kcal, xlabel, ylabel, hlabel, xdata, issuepage)
c
c update: 17:30 fri 4-mar-1994.
c for the "jchem" chemical and "j-th" species plot
c (time | wt) vs. chemical conc in body
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'noval.par'
      include 'page.par'
      include 'plots.par'
      include 'idfiles.def'
      include 'plottmp.def'
c
      integer jchem, jspecies, nage, edadp( * )
      integer kobs, kcal(maxage, maxspecies)
      real xobs(maxobs, maxspecies)
      real yobs(maxobs, maxchem, maxspecies)
      real xcal(mp3, maxage, maxspecies)
      real ycal(mp3, maxchem, maxage, maxspecies)
      logical xdata, issuepage
      character*( * ) xlabel, ylabel, hlabel
c
c miscellaneous declarations
c
      integer agep, jage, xslen, nxx, nyy, nhh, jobs, kpts, addlin
      integer xquery
      real zmax, zmin, wmid
      external xslen
c
      include 'vdefined.def'
      include 'vdefined.sfn'
c
 9110 format (1x,a,//)
 9120 format (/,1x,14x,'x-axis: ',a,/,1x,14x,'y-axis: ',a)
c
      addlin = 1 + 2 + (nrow + 3) + 3
      if (issuepage) then
         call opage(tinquire, ' ', 0, -addlin, xquery)
      else
         call opage(tinquire, ' ', 0, addlin, xquery)
      endif
      issuepage = .true.
c
c determine range of data
c
      xmin = 1.0e+30
      xmax = -xmin
      ymin = xmin
      ymax = xmax
      do jage = 1, nage
         agep = edadp(jage)
         call bnd1(xcal(1, agep, jspecies), kcal(agep, jspecies), zmax,
     &      zmin)
         xmax = max(xmax, zmax)
         xmin = min(xmin, zmin)
         call bnd1(ycal(1, jchem, agep, jspecies), kcal(agep, jspecies),
     &      zmax, zmin)
         ymax = max(ymax, zmax)
         ymin = min(ymin, zmin)
      enddo
c
c if the user provided data, plot only data which falls in [Xmin, Xmax]
c
      if (kobs .gt. 0) then
         kpts = 0
         do jobs = 1, kobs
            wmid = xobs(jobs, jspecies)
            if (vdefined(wmid)) then
               if ((xmin .le. wmid) .and. (wmid .le. xmax)) then
                  if (vdefined(yobs(jobs, jchem, jspecies))) then
                     kpts = kpts + 1
                     ux(kpts) = wmid
                     uy(kpts) = yobs(jobs, jchem, jspecies)
                     ymax = max(ymax, uy(kpts)) ! update y-range
                     ymin = min(ymin, uy(kpts))
                  endif
               endif
            endif
         enddo
      else
         kpts = 0
      endif
c
      call pltinit()    ! initialize plotting buffer                 
      if (xdata) then   ! dump data to file if requested;         
         call pltdump0(xlabel, ylabel, hlabel, nage + 1)        ! nage + 1 sets;
      endif
c
      do jage = 1, nage ! load arrays                             
         agep = edadp(jage)
         call pltload(xcal(1, agep, jspecies), 
     &      ycal(1, jchem, agep, jspecies), kcal(agep, jspecies), 
     &      steo(jage))
         if (xdata) then        ! dump data to file if requested;         
            call pltdump1(xcal(1, agep, jspecies), 
     &         ycal(1, jchem, agep, jspecies), kcal(agep, jspecies))
         endif
      enddo
c
      call pltload(ux, uy, kpts, sobs)
      if (xdata) then   ! dump data to file if requested;         
         call pltdump1(ux, uy, kpts)
      endif
c
c finally, plot;
c
      nxx = xslen(xlabel)
      nyy = xslen(ylabel)
      nhh = xslen(hlabel)
c
      write (jout, *)
      if (nhh .gt. 0) then
         write (jout, 9110) hlabel(1:nhh)
      endif
      call pltbdump(jout)
      write (jout, 9120) xlabel(1:nxx), ylabel(1:nyy)
c
      continue
      return
      end
c PRARGS.spg  processed by SPAG 3.14A  at 14:46 on 26 Oct 1992
      subroutine prargs(zargs, nargs, nxtarg, np)
c
      character*( * ) zargs( * )
      integer nargs, nxtarg, np
c
      integer stderr, i1mach, xslen, jj, nn, nw
      external i1mach, xslen
c
 9110 format (' ','?? nargs :',i3)
 9120 format (' ','?? nxtarg:',i3)
 9130 format (' ','?? np    :',i3)
 9140 format (' ','?? zargs (',i3,') ==>',a,'<==')
 9150 format (' ','?? zargs (',i3,') is all blanks')
c
      stderr = i1mach(4)
      nw = len(zargs(1))
      write (stderr, 9110) nargs
      write (stderr, 9120) nxtarg
      write (stderr, 9130) np
c
      do jj = 1, nargs
         nn = xslen(zargs(jj))
         if (nn .gt. 0) then
            write (stderr, 9140) jj, zargs(jj)(1:nn)
         else
            write (stderr, 9150) jj
         endif
      enddo
c
      return
      end
      subroutine prompt(xaction, xstr)
c
c update: 16:34 fri 4-mar-1994.
c do Prompt stuff: push, pop, print
c if (push), "xstr" contains the new Prompt
c;;
      include 'xglobal.par'
      include 'strings.par'
      include 'Prompt.par'
      include 'Prompt.def'
      include 'xinclude.inc'
      include 'idfiles.def'
c
 9110 format ('$',a)
c
      integer xaction
      character*( * ) xstr
c
      logical do_issue, xfirst
      integer xslen, nx
      external xslen
c
      data xfirst /.true./
      if (xfirst) then
         levprompt = 0
         sprompt(levprompt) = 'Fgets>'
         nprompt(levprompt) = xslen(sprompt(levprompt)) + 1
         xfirst = .false.
      endif
c
      if (xaction .eq. prset0) then
         levprompt = min(levprompt + 1, maxprompt)
         nx = xslen(xstr)
         if (nx .gt. 0) then
            sprompt(levprompt)(1:nx + 1) = xstr(1:nx)
         else
            sprompt(levprompt) = ' '
         endif
         nprompt(levprompt) = nx + 1
c
      elseif (xaction .eq. prset1) then
         levprompt = min(levprompt + 1, maxprompt)
         nx = xslen(xstr)
         if (nx .gt. 0) then
            sprompt(levprompt)(1:nx) = xstr(1:nx)
         else
            sprompt(levprompt) = ' '
         endif
         nx = nx + 1
         sprompt(levprompt)(nx:) = '> '
         nprompt(levprompt) = nx + 1
c
      elseif (xaction .eq. prpop) then
         if (levprompt .gt. 0) then     ! always leave one Prompt in the stack
            levprompt = levprompt - 1
         endif
c
      elseif (xaction .eq. prprint) then
         if (zlevel .gt. 0) then
            do_issue = (zjin(zlevel) .eq. stdin)
         else
            do_issue = .true.
         endif
         if (do_issue) then
            write (stdout, 9110) 
     &         sprompt(levprompt)(1:nprompt(levprompt))
         endif
      endif
c
      return
      end
      real function r1mach(jj)
c
c R1MACH.spg  processed by SPAG 3.14A  at 13:10 on  8 Jan 1993
c\begin
c&    installed 6/03/83 - [LSR] (for pdp11/70)
c-    installed 7/18/85 - [LSR] epa
c-              added r1mach(6) = flag value.
c
c single-precision machine constants
c     r1mach( 1) = b**(emin-1), the smallest positive magnitude.
c     r1mach( 2) = b**emax*(1 - b**(-t)), the largest magnitude.
c     r1mach( 3) = b**(-t), the smallest relative spacing.
c     r1mach( 4) = b**(1-t), the largest relative spacing.
c                    define x := Max{ z such that 1+z == 1 }
c                    r1mach(4) > x  (within half an order of magnitude)
c     r1mach( 5) = log10(b)
c
c-    r1mach( 6) = flag value for unusual conditions.
c-                 the value is completely arbitrary.
c-    r1mach( 7) = minimum exponent (single precision, base 10)
c-    r1mach( 8) = maximum exponent (single precision, base 10)
c-    r1mach( 9) = minimum exponent (double precision, base 10)
c-    r1mach(10) = maximum exponent (double precision, base 10)
c
c     to alter this function for a particular environment,
c     the desired set of data statements should be activated by
c     removing the c from column 1.
c
c     where possible, octal or hexadecimal constants have been used
c     to specify the constants exactly which has in some cases
c     required the use of equivalent integer arrays.
c\end
c
      real rmach(10)
      integer i1mach, jj
      external i1mach
c
c machine constants for Lahey fortran's supporting
c 32-bit integers (expressed in real)
c
      data rmach(1) /1.1800000e-38/
      data rmach(2) /3.4000000e+38/
      data rmach(3) /5.9604645e-08/
      data rmach(4) /1.1920929e-07/
      data rmach(5) /0.3010300e+00/
      data rmach(6) /0.0e+00/
      data rmach(7) /0.0e+00/
      data rmach(8) /0.0e+00/
      data rmach(9) /0.0e+00/
      data rmach(10) /0.0e+00/
c
      if ((1 .le. jj) .and. (jj .le. 5)) then
         r1mach = rmach(jj)
      elseif (jj .eq. 6) then
         r1mach = float(i1mach(17))
      elseif (jj .eq. 7) then
         r1mach = ifix(i1mach(12) * alog10(float(i1mach(10)))) - 1
      elseif (jj .eq. 8) then
         r1mach = ifix(i1mach(13) * alog10(float(i1mach(10))))
      elseif (jj .eq. 9) then
         r1mach = ifix(i1mach(15) * alog10(float(i1mach(10)))) - 1
      elseif (jj .eq. 10) then
         r1mach = ifix(i1mach(16) * alog10(float(i1mach(10))))
      else
         r1mach = float(i1mach(17))
      endif
c
c* /* C source for R1MACH -- remove the * in column 1 */
c*#include <stdio.h>
c*#include <float.h>
c*#include <math.h>
c*
c*float r1mach_(long *i)
c*{
c*  switch(*i){
c*    case 1: return FLT_MIN;
c*    case 2: return FLT_MAX;
c*    case 3: return FLT_EPSILON/FLT_RADIX;
c*    case 4: return FLT_EPSILON;
c*    case 5: return log10(FLT_RADIX);
c*    }
c*
c*  fprintf(stderr, "invalid argument: r1mach(%ld)\n", *i);
c*  exit(1);
c*  return 0; /* for compilers that complain of missing return values */
c*  }
c
c
      return
      end
      subroutine readme()
c
c update:   15:34 wed 13-jan-1993.
c README.spg  processed by SPAG 3.14A  at 11:00 on  8 Jan 1993
c
c ===========================================================================
c variables to delete:
c . qq_new_day(age,species), xupdate_continuously
c . 'options.def', and modules required for steady_state option
c
c ===========================================================================
c DAEsolv: usage, information, history, etc. on the Differential-Algebraic
c          Equation solver package is stored in DAEsolv.f;
c
c ===========================================================================
c Gnspecies .le. maxspecies;
c jspecies = 1, ..., Gnspecies;
c jage = 1 .. xmaximum_age(jspecies);  xmaximum_age(jspecies) .le. maxage
c
c qq_* :: variable age-dependent information array; example
c         qq_wgamma(jage=1,jspecies=1) does not necessarily contains the info
c                                     for age=1, species = 1
c
c vv_* :: static age-dependent information array; example
c         vv_growth_model(jage=1,jspecies=1) will always contain the info for
c                                            species=1, age=1.
c
c ===========================================================================
c
c jfish = 1..Gnfish
c Fishk2ij(jfish,1) = jage
c Fishk2ij(jfish,2) = jspecies
c
c pfish = Odepnter(jfish)  ! Storage location of the j-th fish, DAEsolv arrays
c jage  = Fishk2ij(jfish, 1)
c jspecies = Fishk2ij(jfish, 2)
c agep = qq_fish_age (jage, jspecies)
c
c ===========================================================================
c
c ux(mp3)                           temporary storage
c uy(mp3)
c
c ===========================================================================
c
c changes in the definition/usage/documentation of "fishij2k", "fishk2ij"
c must be propagated to "readme.f" "fish.def"
c
c The fish are stored in matrices (maxage,maxspecies) but, in order
c to integrate, the differential equations must be stored consecutively
c in the same array. the arrays "fishij2k", "fishk2ij" provide the required
c addresses (matrix to linear and viceversa).
c
c        integer           fishij2k(maxage,maxspecies)
c        integer           fishk2ij(maxfish,2)
c                             fishk2ij(m,1) == age
c                             fishk2ij(m,2) == species
c
c example:
c     assume:
c        Gnspecies = 3                 ! 3 fish species
c        xmaximum_age(1:Gnspecies) = 3, 4, 2;
c                                      ! i.e., species 1 has 3 age classes;
c                                      !       species 2 has 4 age classes;
c                                      !       species 3 has 2 age classes;
c     therefore
c        nfish = 3 + 4 + 2 = 9         ! number of fish to integrate
c
c     and
c        fishij2k(1,1) = 1
c        fishij2k(2,1) = 2
c        fishij2k(3,1) = 3
c
c        fishij2k(1,2) = 4
c        fishij2k(2,2) = 5
c        fishij2k(3,2) = 6
c        fishij2k(4,2) = 7
c
c        fishij2k(1,3) = 8
c        fishij2k(2,3) = 9
c
c
c        fishk2ij(m,1) = age        fishk2ij(m,2) = species
c        -------------------        -----------------------
c        fishk2ij(1,1) = 1          fishk2ij(1,2) = 1
c        fishk2ij(2,1) = 2          fishk2ij(2,2) = 1
c        fishk2ij(3,1) = 3          fishk2ij(3,2) = 1
c        fishk2ij(4,1) = 1          fishk2ij(4,2) = 2
c        fishk2ij(5,1) = 2          fishk2ij(5,2) = 2
c        fishk2ij(6,1) = 3          fishk2ij(6,2) = 2
c        fishk2ij(7,1) = 4          fishk2ij(7,2) = 2
c        fishk2ij(8,1) = 1          fishk2ij(8,2) = 3
c        fishk2ij(9,1) = 2          fishk2ij(9,2) = 3
c
c ===========================================================================
c >>>>> these arrays should be accessed by year class;
c       jage = 1 .. xmaximum_age(jspecies)
c       (to save space: ja == jage, js == jspecies)
c
c the physiological parameters are "species" dependent;
c vv_iniwt, plfish, ... are year class dependent;
c qq_wgamma, qq_eps1-2, qq_gmax, ... are fish dependent;
c
c ==============================
c === THIS INFORMATION IS STATIC, e.g., vv_growth_model(1,1) will always contain
c                                 the info for age=1, species=1.
c
c vv_growth_model(ja,js)   fish growth model
c                             values: tlinear, tallometric, tholling, tclearance
c
c vv_functional_response(ja,js)  if tallometric or tholling, func_resp is the
c                             ratio of realized ingestion to maximal ingestion
c                             (i.e., func_resp = c / cmax).
c vv_pval(maxfpar,ja,js)
c     because, during input, year class parameters are stored here;
c
c vv_ptyp(maxfpar,ja,js)  fishpar_erase;
c                          if vv_ptyp (...) == TRUE then
c                             set vv_pval (...) = rnoval;
c                             the idea is to place in this position
c                                 the database value of the parameter;
c                          vv_ptyp is set to "database" or tdatabase;
c
c vv_plfunc(ja,js)
c vv_iniwt(ja,js)             initial wt for the year class
c vv_inicf(maxchem,ja,js)     initial concentration of chem in fish
c vv_cfood(maxchem,ja,js)     initial concentration of chem in food, used
c                             with "tlaboratory"
c vv_bmf (maxchem,ja,js)      initial vv_bmf in prey, used with "tfood_chain" or
c                             "tlaboratory"
c
c ==================================
c === THIS INFORMATION IS NOT STATIC
c
c qq_fish_age(jage,jspecies)           age in integer years of the fish
c
c qq_nxy(jage,jspecies)                number of stored plotting points
c qq_iterno(jage,jspecies)             iteration number
c qq_iprint(jage,jspecies)             (integer) print flag
c qq_hgamma(mp3,jage,jspecies)         fish growth rate;
c qq_tcal(mp3,jage,jspecies)           time
c qq_wcal(mp3,jage,jspecies)           weight
c qq_cfcal(mp3,maxchem,jage,jspecies)  concentration in fish at "qq_tcal"
c qq_hactvt(mp3,jage,jspecies)         activity
c qq_new_day(jage,jspecies)            used to determine if we are at dawn;
c qq_max_activity(jage,jspecies)
c qq_maxcf(maxchem,jage,jspecies)
c
c qq_cp(maxchem,jage,jspecies)
c qq_wgamma(jage,jspecies), qq_phi(jage,jspecies), qq_gmax(jage,jspecies)
c qq_alpha1(jage,jspecies), qq_alpha2(jage,jspecies)
c qq_epsl1(jage,jspecies), qq_epsl2(jage,jspecies)
c qq_mu(jage,jspecies)
c qq_sgill(jage,jspecies)
c
c qq_igamma(jage,jspecies), qq_iingest(jage,jspecies)
c qq_iassim(jage,jspecies), qq_iegest(jage,jspecies)
c qq_iexcret(jage,jspecies), qq_irespir(jage,jspecies), qq_isda(jage,jspecies)
c qq_lenfish(jage,jspecies)
c qq_wingest(jage,jspecies), qq_wassim(jage,jspecies), qq_wegest(jage,jspecies)
c qq_wrespir(jage,jspecies), qq_wsda(jage,jspecies), qq_wexcret(jage,jspecies)
c qq_cfj(maxchem,jage,jspecies)
c qq_tjgilup(maxchem,jage,jspecies), qq_tjgilex(maxchem,jage,jspecies)
c qq_tjgutup(maxchem,jage,jspecies), qq_tjgutex(maxchem,jage,jspecies)
c qq_jgilup(maxchem,jage,jspecies), qq_jgilex(maxchem,jage,jspecies)
c qq_jgutup(maxchem,jage,jspecies), qq_jgutex(maxchem,jage,jspecies)
c qq_kf(maxchem,jage,jspecies)
c qq_pa(jage,jspecies)
c qq_kw(maxchem,jage,jspecies)
c
c qq_death_day(jage,jspecies)
c qq_fish_alive(jage,jspecies)
c
c ===========================================================================
c >>>>> these arrays should be accessed by jspecies = 1, ..., Gnspecies
c       Gnspecies .le. maxspecies;
c
c xmaximum_age(jspecies)            number of year_classes
c lc50func(maxchem,jspecies)        concentration to obtain 50% mortality
c lc50par(maxpar,maxchem,jspecies)  parameters for "lc50func"
c fish_la50(jspecies)               lethal activity
c spplab(jspecies)
c famlab(jspecies)
c ecolab(jspecies)
c activegill(jspecies)              fraction of gill surface area used
c                                      for exchange
c data_t(jspecies)
c data_c(jspecies)
c data_w(jspecies)
c nobs(jspecies)
c col_t(jspecies)
c col_w(jspecies)
c col_c(jspecies)
c tobs(maxobs,jspecies)
c wobs(maxobs,jspecies)
c cfobs(maxobs,maxchem,jspecies)
c
c ===========================================================================
c >>> other variables
c hcw(mp3,maxchem)                  water concentration
c!4! twmean
c!4! cwmean(maxchem)
c xsave_status                      "to save" status;
c xcurrent_fish                     fish being integrated
c
c tlaboratory
c  tank_flow, tank_volume, tank_nfish, tank_cw(maxchem)
c  Food_chem_func
c  Food_chem_conc(maxchem), Food_bmf(maxchem)
c  Food_pl
c
c;;
      return
      end
      subroutine real2a(rnum, zform, snum, nlen)
c
c update: 16:00 tue 5-apr-1994.
c convert the Real number "rnum" to its character string.
c
c input:
c . rnum - the Real number
c . zform - the format, e.g., "(1pg14.6)" -- notice the parenthesis
c
c output:
c . snum(1:nlen) - string, left justified.
c
      include 'xglobal.par'
      include 'noval.par'
      include 'chars.def'
      include 'vdefined.def'
c
      real rnum
      character*( * ) zform, snum
      integer nlen, ios, kx, k0, k1
      logical havee
c
      include 'chars.sfn'
      include 'vdefined.sfn'
c
      if (vdefined(rnum)) then
         snum = ' '
         write (unit=snum, fmt=zform, iostat=ios) rnum
      else
         ios = zioerror
         snum = snoval
      endif
      call compress(snum, -1, k0)
      call up2lo(snum, k0)
      if (ios .ne. 0) then
         nlen = k0
         go to 110      ! if an error occured, just return  
      endif
c
      k1 = k0
      kx = index(snum, 'e')
      if (kx .le. 0) kx = index(snum, 'd')
      havee = (kx .gt. 0)
c
      if (havee) then   ! if "empty" exponent, delete it.   
         if ((snum(kx + 1:kx + 3) .eq. '+00') .or. (
     &      snum(kx + 1:kx + 3) .eq. '-00')) then
            k0 = kx - 1
            havee = .false.
         endif
      endif
c
      if ( .not. havee) then
         do while ((snum(k0:k0) .eq. blank) .or. (snum(k0:k0) .eq. '0'))
            k0 = k0 - 1
         enddo
         if (snum(k0:k0) .eq. '.') k0 = k0 + 1  ! no naked "."'s  
      endif
      nlen = k0
      k0 = k0 + 1
      if (k0 .le. k1) snum(k0:k1) = blank
c
  110 continue
      return
      end
      subroutine sburden(uu)
c
c update: 17:30 fri 4-mar-1994.
c show burden info
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'habitat.par'
      include 'noval.par'
      include 'phylum.par'
      include 'simul.par'
c
      include 'chems.def'
      include 'globpar.def'
      include 'habitat.def'
      include 'idfiles.def'
      include 'lab.def'
      include 'options.def'
      include 'units.def'
c
      integer uu
c
c miscellaneous declarations
c
      integer xslen, nvolume, nflow
      integer npredator, nprey, nprey_food
      external xslen
c
 9110 format (1x,3x,'Simulation mode: ',a)
 9120 format (1x,3x,'      tank flow: ',1pg11.4,1x,a/1x,3x,
     &   '    tank volume: ',1pg11.4,1x,a/1x,3x,
     &   'Number of fish in tank: ',i4)
 9130 format (1x,3x,'       predator: "',a,'"')
 9140 format (1x,3x,'           prey: "',a,'"')
 9150 format (1x,3x,'      prey_food: ',a)
 9160 format (1x,3x,'           prey: ',a)
c;;
      if (simul_mode .eq. tlaboratory) then
         nflow = xslen(pgm_flow)
         nvolume = xslen(pgm_volume)
         write (uu, 9110) 'Laboratory'
         write (uu, 9120) tank_flow, pgm_flow(1:nflow), tank_volume, 
     &      pgm_volume(1:nvolume), nint(tank_nfish)
         call owtable1(uu, gnchem, toxlab, 'food', food_chem_func, 
     &      snoval, food_chem_conc, food_pl, food_bmf)
c
      elseif (simul_mode .eq. tfood_chain) then
         npredator = xslen(fc_spredator)
         nprey = xslen(fc_sprey)
         nprey_food = xslen(fc_sprey_food)
         write (uu, 9110) 'Food Chain'
         write (uu, 9130) fc_spredator(1:npredator)
c
         if (fc_preyt .eq. tspecies) then
            write (uu, 9140) fc_sprey(1:nprey)
            write (uu, 9150) fc_sprey_food(1:nprey_food)
            if (fc_prey_foodt .eq. tplankton) then
               call owtable1(uu, gnchem, toxlab, 'plankton', 
     &            plankton_chem_func, planktonfil, plankton_chem_conc, 
     &            plankton_pl, plankton_bmf)
            elseif (fc_prey_foodt .eq. tbenthos) then
               call owtable1(uu, gnchem, toxlab, 'benthos', 
     &            benthos_chem_func, benthosfil, benthos_chem_conc, 
     &            benthos_pl, benthos_bmf)
            elseif (fc_prey_foodt .eq. tcfish) then
               call owtable1(uu, gnchem, toxlab, 'prey_food', 
     &            cfish_chem_func, cfishfil, cfish_chem_conc, cfish_pl,
     &            cfish_bmf)
            endif
c
         elseif (fc_preyt .eq. tplankton) then
            write (uu, 9160) fc_sprey_food(1:nprey_food)
            call owtable1(uu, gnchem, toxlab, 'plankton', 
     &         plankton_chem_func, planktonfil, plankton_chem_conc, 
     &         plankton_pl, plankton_bmf)
         elseif (fc_preyt .eq. tbenthos) then
            write (uu, 9160) fc_sprey_food(1:nprey_food)
            call owtable1(uu, gnchem, toxlab, 'benthos', 
     &         benthos_chem_func, benthosfil, benthos_chem_conc, 
     &         benthos_pl, benthos_bmf)
         elseif (fc_preyt .eq. tcfish) then
            write (uu, 9160) fc_sprey_food(1:nprey_food)
            call owtable1(uu, gnchem, toxlab, 'prey_food', 
     &         cfish_chem_func, cfishfil, cfish_chem_conc, cfish_pl, 
     &         cfish_bmf)
         endif
c
      elseif (simul_mode .eq. tfood_web) then
         write (uu, 9110) 'Food Web'
         if (xplankton) then
            call owtable1(uu, gnchem, toxlab, 'plankton', 
     &         plankton_chem_func, planktonfil, plankton_chem_conc, 
     &         plankton_pl, plankton_bmf)
         endif
         if (xbenthos) then
            call owtable1(uu, gnchem, toxlab, 'benthos', 
     &         benthos_chem_func, benthosfil, benthos_chem_conc, 
     &         benthos_pl, benthos_bmf)
         endif
         if (xcfish) then
            call owtable1(uu, gnchem, toxlab, 'cfish', cfish_chem_func,
     &         cfishfil, cfish_chem_conc, cfish_pl, cfish_bmf)
         endif
c
      else
         write (uu, 9110) snoval
      endif
c
      return
      end
      subroutine schem0(uu)
c
c update: 17:44 fri 4-mar-1994.
c output chem info
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'habitat.par'
      include 'menu.par'
      include 'noval.par'
      include 'simul.par'
c
      include 'idfiles.def'
      include 'globpar.def'
      include 'chemp.def'
      include 'chems.def'
      include 'habitat.def'
      include 'vdefined.def'
c
      integer uu
c
      character*(stdlen) q1tmp
      integer jchem, kbeg, kend, xslen, nnt, nq1, exitcode
      real rlo, rhi
      external xslen
c
      include 'vdefined.sfn'
c
 9110 format (1pg11.4)
 9120 format (1pg11.4,' +',1pg11.4,' * Sin(',1pg11.4,' * t[day] + ',1
     &   pg11.4,' )')
 9130 format (1pg11.4,' +',1pg11.4,' * Exp(',1pg11.4,' * t[day])')
c
 9140 format (1x,3x,'Chemical name: "',a,'"')
 9150 format (1x,3x,'Mol. weight, grams/mol: ',a)
 9160 format (1x,3x,'Mol. volume,  cm^3/mol: ',a)
 9170 format (1x,3x,'Logp : ',a)
 9180 format (1x,3x,'Clogp: ',a)
 9190 format (1x,3x,'Melting point, Celsius: ',a)
 9200 format (1x,3x,'Conc. in water, mg/Litre: ',a)
 9210 format (1x,3x,'--------------------------------------')
c
      call tokrange('show chemical', eol, exitcode, rlo, rhi)
      if (exitcode .eq. tquit) then
         go to 110
      elseif (exitcode .eq. tfailure) then
         go to 110
      elseif (exitcode .eq. twild) then
         kbeg = 1       ! evaluate "*"                
         kend = gnchem
      else
         kbeg = nint(rlo)       ! integer range               
         kend = nint(rhi)
      endif
c
      do jchem = kbeg, kend
         nnt = xslen(toxlab(jchem))
         write (uu, 9140) toxlab(jchem)(1:nnt)
c
         if (vdefined(molwt(jchem))) then
            call real2a(molwt(jchem), '(1pg11.4)', q1tmp, nq1)
            write (uu, 9150) q1tmp(1:nq1)
         else
            write (uu, 9150) snoval
         endif
c
         if (vdefined(molvol(jchem))) then
            call real2a(molvol(jchem), '(1pg11.4)', q1tmp, nq1)
            write (uu, 9160) q1tmp(1:nq1)
         else
            write (uu, 9160) snoval
         endif
c
         if (vdefined(logp(jchem))) then
            call real2a(logp(jchem), '(1pg11.4)', q1tmp, nq1)
            write (uu, 9170) q1tmp(1:nq1)
         else
            write (uu, 9170) snoval
         endif
c
         if (vdefined(clogp(jchem))) then
            call real2a(clogp(jchem), '(1pg11.4)', q1tmp, nq1)
            write (uu, 9180) q1tmp(1:nq1)
         else
            write (uu, 9180) snoval
         endif
c
         if (vdefined(mp(jchem))) then
            call real2a(mp(jchem), '(1pg11.4)', q1tmp, nq1)
            write (uu, 9190) q1tmp(1:nq1)
         else
            write (uu, 9190) snoval
         endif
c
         if (cwfunc(jchem) .eq. tfile) then
            nq1 = xslen(cwfil)
            q1tmp = 'file "' // cwfil(1:nq1) // '"'
         elseif (cwfunc(jchem) .eq. tconstant) then
            call real2a(cwpar(1, jchem), '(1pg11.4)', q1tmp, nq1)
         elseif (cwfunc(jchem) .eq. tsin) then
            write (q1tmp, 9120) cwpar(1, jchem), cwpar(2, jchem), 
     &         cwpar(3, jchem), cwpar(4, jchem)
         elseif (cwfunc(jchem) .eq. texp) then
            write (q1tmp, 9130) cwpar(1, jchem), cwpar(2, jchem), 
     &         cwpar(3, jchem)
         else
            q1tmp = snoval
         endif
         call compress(q1tmp, -1, nq1)
         write (uu, 9200) q1tmp(1:nq1)
         if (jchem .lt. kend) write (uu, 9210)
      enddo
c
  110 continue
      return
      end
      subroutine setages(xlast)
c
c update: 17:30 fri 4-mar-1994.
c xlast == true ==> this is the last call; after this transfer,
c                   ignore all other requests;
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'noval.par'
      include 'globpar.def'
      include 'fish.def'
c
      logical xlast
c
      integer jpar, jage
c
      include 'vdefined.def'
      include 'vdefined.sfn'
c
      if (nomore_fish) then
         continue
c
      elseif (gnspecies .gt. 0) then
         nomore_fish = xlast
         qq_fish_age(1, gnspecies) = 1
         do jage = 2, xmaximum_age(gnspecies)
            qq_fish_age(jage, gnspecies) = jage
            do jpar = 1, maxfpar
               if ( .not. vdefined(vv_pval(jpar, jage, gnspecies))) then
                  vv_pval(jpar, jage, gnspecies) = 
     &               vv_pval(jpar, 1, gnspecies)
               endif
            enddo
         enddo
      endif
c
      return
      end
      subroutine setcfish(nchem, ecolab, food_pl, kow, kl, food_kf)
c
c update: 09:02 wed 19-jan-1994.
c
c this subroutine calculates food kf's which used to calculate the toxicant's
c concentration in food assuming that the food either is equilibrated with the
c water or is biomagnified.
c
c declarations of subroutine's formal parameters
c
      integer nchem
      character*( * ) ecolab
      real food_pl, kow( * ), kl( * )
      real food_kf( * )
c
      integer jchem
c
c assign food kf according to ecology type
c
      if (index(ecolab, 'piscivore') .gt. 0) then
c
c the fish is a piscivore. therefore mckay's generalized fish kf
c regression (mckay 1982.environ.sci.technol.16:274-278.) could be
c used here. that is
c                 Food_kf = 0.048 Kow
c
         do jchem = 1, nchem
            food_kf(jchem) = 0.048 * kow(jchem)
         enddo
      else
c
c assign default kf's
c
         do jchem = 1, nchem
            food_kf(jchem) = food_pl * kl(jchem)
         enddo
      endif
c
      return
      end
      subroutine setfpar(nerror)
c
c update: 17:30 fri 4-mar-1994.
c parameterize all fishes;
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'plots.par'
      include 'phylum.par'
      include 'noval.par'
      include 'fish.def'
      include 'globpar.def'
      include 'options.def'
      include 'idfiles.def'
      include 'diet.def'
      include 'work.def'
c
      integer nerror
c
c local declarations
c
      character*(stdlen) genlab(maxspecies)
      character*(stdlen) hablab(maxspecies), fedlab(maxspecies)
      character*(stdlen) habitat(2), guild(9)
      integer ii, nn, nh, ng, ierror, nage, number_missing, jpar
      integer jspecies, jage, fishstat(maxfpar)
      logical havit, found, done
      integer xslen
      external xslen
c
      include 'vdefined.def'
      include 'vdefined.sfn'
c
      data habitat /'fresh', 'marine'/
      data guild /'herbivore', 'omnivore', 'benthivore', 'piscivore', 
     &   'mixed', 'nonpiscivore', 'planktivore', 'parasitic', 
     &   'nonfeeding'/
c
 9110 format (1x,'?? parameterization incomplete for "',a,
     &   '", age class ',i2)
c
c identify fish's genus, habitat, and functional ecology
c
      nerror = 0
      number_missing = 0
      do jspecies = 1, gnspecies
         nage = xmaximum_age(jspecies)
         nn = index(spplab(jspecies), ' ')
         genlab(jspecies) = spplab(jspecies)(1:nn)
c
         ii = 1
         found = .false.
  110    continue
         done = ((ii .gt. 2) .or. (found))
         if ( .not. done) then
            nh = xslen(habitat(ii))
            nn = index(ecolab(jspecies), habitat(ii)(1:nh))
            if (nn .gt. 0) then
               found = .true.
               hablab(jspecies) = habitat(ii)(1:nh)
            else
               ii = ii + 1
            endif
            go to 110
         endif
         if ( .not. found) hablab(jspecies) = 'unresolved'
c
         ii = 1
         found = .false.
  120    continue
         done = ((ii .gt. 9) .or. (found))
         if ( .not. done) then
            ng = xslen(guild(ii))
            nn = index(ecolab(jspecies), guild(ii)(1:ng))
            if (nn .gt. 0) then
               found = .true.
               fedlab(jspecies) = guild(ii)(1:ng)
            else
               ii = ii + 1
            endif
            go to 120
         endif
         if ( .not. found) fedlab(jspecies) = 'unresolved'
c
c standardize and check all fish input paramenters required for the run;
c
         do jage = 1, nage
            call dbnorm(vv_pval(1, jage, jspecies), ierror)
            call chkfpar(vv_pval(1, jage, jspecies), 
     &         vv_growth_model(jage, jspecies), simul_mode, 
     &         vv_plfunc(jage, jspecies), fdiet(1, jage, jspecies), 
     &         havit, fishstat)
            do jpar = 1, maxfpar
               if (vdefined(vv_pval(jpar, jage, jspecies))) then
                  vv_ptyp(jpar, jage, jspecies) = tuser
               else
                  vv_ptyp(jpar, jage, jspecies) = inoval
               endif
            enddo
            if ( .not. havit) then
               number_missing = number_missing + 1
            endif
         enddo
      enddo
c
      if (number_missing .gt. 0) then
c
c model parameterization is incomplete for some species,
c therefore Access Fgets's morphometrical/physiological/ecological database
c
         call uotty('0## accessing database.', -1)
         call dbparam(spplab, genlab, famlab, hablab, fedlab, gnspecies,
     &      xxp, sxp, nxp, dbpar, dbtyp)
c
         number_missing = 0
         do jspecies = 1, gnspecies
            nage = xmaximum_age(jspecies)
            nn = xslen(spplab(jspecies))
            do jage = 1, nage
c
c set the physiological variables that are undefined and recheck for
c completeness.
c
               do jpar = 1, maxfpar
                  if ( .not. vdefined(vv_pval(jpar, jage, jspecies))) 
     &               then
                     vv_pval(jpar, jage, jspecies) = 
     &                  dbpar(jpar, jspecies)
                     vv_ptyp(jpar, jage, jspecies) = 
     &                  dbtyp(jpar, jspecies)
                  endif
               enddo
c
               call chkfpar(vv_pval(1, jage, jspecies), 
     &            vv_growth_model(jage, jspecies), simul_mode, 
     &            vv_plfunc(jage, jspecies), fdiet(1, jage, jspecies), 
     &            havit, fishstat)
               if ( .not. havit) then
                  number_missing = number_missing + 1
                  nerror = nerror + 1
                  nn = xslen(spplab(jspecies))
                  write (stdout, 9110) spplab(jspecies)(1:nn), jage
                  call dbnfound(stdout, spplab(jspecies), fishstat)
               endif
            enddo
         enddo
      endif
c
  130 continue
      return
      end
      subroutine setvar()
c
c update: 11:44 wed 17-aug-1994.
c
c NB: make sure all modules leave an empty buffer, unless we have pushback
c     stuff
c
c this subroutine assigns user input values/parameters/observations
c
c ********************** fish/simulation control input **************
c this section describes the syntax and usage of the commands;
c it also provides a brief description of their purpose and examples.
c
c Fgets requires a user input file of the following general structure
c
c    / command_1    argument(s)
c    / command_2    argument(s)
c          .
c          .
c          .
c    / command_n    argument(s)
c    / end
c
c The leading virgule (/) identifies the line as a command.  Blanks or tabs
c before or after the slash delimiter are not significant.  Each slash is
c followed by a keyword or phrase, as indicated above, that identifies the
c record's data.  Keywords must be spelled in full without any embedded blanks
c and must be separated from the record's remaining information by at least
c one Blank or Tab.  One or more consecutive blanks or tabs are equivalent to
c one Blank.   The letter "c" or an exclamation symbol (!) in the first column
c of a line identifies the line as a comment.  The exclamation symbol can also
c be used anywhere in the record field to start an end-of-line comment, i.e.,
c the remainder of the line, including the exclamation symbol, will be ignored.
c Comments can be placed anywhere in the input file.  Therefore, users can
c document Fgets input files in as much detail as desired.  Commands may be
c continued by appending an ampersand (&) to the line, e.g., the following two
c commands lines are equivalent:
c
c    / command   arg_1   arg_2   arg_3     &         ! command first line
c                arg_4   arg_5             &         ! command second line
c                arg_6                               ! command last line
c
c    /command arg_1 arg_2 arg_3 arg_4 arg_5 arg_6
c
c Input file letter case is not significant.
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'xio.inc'
      include 'chem.par'
      include 'fish.par'
      include 'habitat.par'
      include 'noval.par'
      include 'simul.par'
      include 'strings.par'
      include 'token.par'
c
      include 'chemp.def'
      include 'fish.def'
      include 'globpar.def'
      include 'habitat.def'
      include 'hits.def'
      include 'idfiles.def'
      include 'idsdb.def'
      include 'stealth.def'
      include 'token.def'
c
      character*(stdlen) wverb
      real rval
      integer tot_errors, ival, toktype, nv, nptr, ncom, xslen
      logical xxok, xxfin
      external xslen
c
 9110 format (' ?? unexpected end-of-file.')
 9120 format (' ?? extra stuff at end of the line ignored')
 9130 format (' ?? internal error; command "/',a,
     &   '" requires computed "go-to" label at position ',i4)
 9140 format (' ?? command "',a,'" not defined.')
 9150 format (' ?? empty line.')
 9160 format (' ?? ambiguous command: "',a,'"')
 9170 format (' ?? errors detected.')
c
c initialize input variables
c main loop: loop until end of file or "/ end" detected.
c get command;
c
      tot_errors = 0
      xxfin = .false.
      gnchem = inoval
      gnspecies = inoval
      nomore_fish = .false.
      call inithelp()   ! initialize help arrays      
      call tokreset()
c
c all modules leave with: Pcur > Len_inbuf,
c except for pushed-back line, or token
c;;
  110 continue
      call toknext(ttoken, wverb, ival, rval, toktype)
      if (wverb(1:1) .eq. eof) then     ! Eof -- quit                 
         wverb = 'exit'
      elseif (wverb(1:1) .eq. eol) then ! Eol -- should not happen    
         call tokreset()
         go to 620
      elseif (wverb(1:1) .eq. '/') then ! remove leading "/", if found
         call toknext(ttoken, wverb, ival, rval, toktype)
      endif
      nv = index(wverb, ' ') - 1
c
c look for the command in the command table
c . try "normal" form of command
c . not found? try hidden form of command : prepend "stealthc" and check.
c
c simulate "case" statement:
c . use computed go to (argggggg !)
c
c (a hashing function may be better for the lookup.)
c "go to" como una fina cortesia de v3base:xgoto.f
c
      call srchlbw(wverb(1:nv), comname, maxcom, xhits, nhits)
      if (nhits .le. 0) then
         call srchlbw(stealthc // wverb(1:nv), comname, maxcom, xhits, 
     &      nhits)
      endif
c
      if (nhits .eq. 1) then
         xxok = .false.
         ncom = xhits(nhits)
         wverb = comname(ncom)
         nv = xslen(wverb)
         nptr = comcode(ncom)
c
c!xgoto:start   ;;
         go to (120, 130, 140, 150, 160, 170, 180, 190, 200, 210, 220, 
     &      230, 240, 250, 260, 210, 270, 280, 130, 290, 300, 310, 320,
     &      330, 340, 300, 350, 360, 120, 370, 380, 390, 400, 410, 420,
     &      430, 440, 450, 460, 470, 480, 490, 500, 510, 520, 520, 340,
     &      530, 310, 540, 140, 300, 550, 560, 470, 570, 580, 470, 210,
     &      590, 210, 600, 600, 570, 600, 600, 610, 600, 600, 600, 600,
     &      600), ncom
c!xgoto:end     ;;
c
         write (stdout, 9130) wverb(1:nv), ncom
      elseif (nhits .eq. 0) then
c
c!~14!c kludge: accept without message "update_growth"
c
         if (wverb(1:nv) .eq. 'update_growth') then
            xxok = .true.
         else
            xxok = .false.
            write (stdout, 9140) wverb(1:nv)
         endif
      else
         xxok = .false.
         write (stdout, 9160) wverb(1:nv)
         call ihelp0(stdout, comname, maxcom, xhits, nhits)
      endif
      ncom = inoval
      call tokreset()
      go to 620
c
c ******************************************************************
c help: ? /help
c
  120 continue
      call ihelp(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c read script file: @ /do
c
  130 continue
      call iatfile(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c "`" /show
c
  140 continue
      call ishow(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /active_gill
c
  150 continue
      call iactgill(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /audit
c
  160 continue
      call iaudit(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /burden
c
  170 continue
      call iburden(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /catalog
c
  180 continue
      call icatalog(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /cbenthos
c
  190 continue
      call itrophic(wverb(1:nv), xxok, xbenthos, benthos_chem_func, 
     &   benthosfil, benthos_chem_conc, benthos_pl, benthos_bmf)
      go to 620
c
c ******************************************************************
c /cfish
c
  200 continue
      call itrophic(wverb(1:nv), xxok, xcfish, cfish_chem_func, 
     &   cfishfil, cfish_chem_conc, cfish_pl, cfish_bmf)
      if (xxok) then
         xxok = ((cfish_chem_func .eq. tequilibrium) .or. (
     &      cfish_chem_func .eq. tconstant))
         if ( .not. xxok) then
            write (stdout, 9180) wverb(1:nv)
         endif
      endif
      go to 620
 9180 format (' ?? "/',a,'" : expects "equilibrium" or "constant"')
c
c ******************************************************************
c unit names: /Cfunits, /Cwunits, /Tunits, /Wtunits
c
  210 continue
      call iunits(wverb(1:nv), xxok, nptr)
      go to 620
c
c ******************************************************************
c /chemicals
c
  220 continue
      call ichemicals(wverb(1:nv), xxok, gnchem)
      go to 620
c
c ******************************************************************
c /clear
c
  230 continue
      call iclear(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c chemicals properties: /Clogp
c
  240 continue
      call ipchem(wverb(1:nv), xxok, clogp)
      go to 620
c
c ******************************************************************
c /cplankton
c
  250 continue
      call itrophic(wverb(1:nv), xxok, xplankton, plankton_chem_func, 
     &   planktonfil, plankton_chem_conc, plankton_pl, plankton_bmf)
      go to 620
c
c ******************************************************************
c /cwater
c
  260 continue
      call icw(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /describe
c
  270 continue
      call idescribe(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /diet
c . determine total number of fish;
c . set the diet;
c
  280 continue
      call idiet(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /echo
c
  290 continue
      call iecho(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c species id: /species, /family, /ecology
c
c "/species" is, effectively, the "begin" card for a new fish.
c
  300 continue
      call ispecies(wverb(1:nv), xxok, nptr)
      go to 620
c
c ******************************************************************
c /end /run
c
  310 continue
      if (tot_errors .le. 0) then
         call irun(wverb(1:nv), xxok)
      else
         write (stdout, 9170)
      endif
c
c!~14!c temporary kludge: jump to /exit /quit
      go to 340 ! c!~14!                
c!~14!      go to 4110
c
c ******************************************************************
c /exams
c
  320 continue
      call iexams(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /Exams_mode
c
  330 continue
      call iexamode(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /exit /quit
c
  340 continue
      call iexit(wverb(1:nv), xxok)
      xxfin = .true.
      go to 620
c
c ******************************************************************
c /fishpar
c
  350 continue
      call ifishpar(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c species parameters: /growth
c
  360 continue
      call igrowth(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c species exposure: /initial_cf
c
  370 continue
      call icfinit(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c species parameters: /initial_wt
c
  380 continue
      call iwtinit(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /lc50
c
  390 continue
      call ilc50(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /lenwt
c
  400 continue
      call ilenwt(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /list
c
  410 continue
      call ilist(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c chemicals properties: /Logp
c
  420 continue
      call ipchem(wverb(1:nv), xxok, logp)
      go to 620
c
c ******************************************************************
c /maximum_age
c
  430 continue
      call imaxage(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c chemicals properties: /melting_point
c
  440 continue
      call ipchem(wverb(1:nv), xxok, mp)
      go to 620
c
c ******************************************************************
c chemicals properties: /Molvol
c
  450 continue
      call ipchem(wverb(1:nv), xxok, molvol)
      go to 620
c
c ******************************************************************
c chemicals properties: /Molwt
c
  460 continue
      call ipchem(wverb(1:nv), xxok, molwt)
      go to 620
c
c ******************************************************************
c time control: /tstart , /tend , /nstep
c
  470 continue
      call isimulp(wverb(1:nv), xxok, nptr)
      go to 620
c
c ******************************************************************
c /observations
c
  480 continue
      call iobs(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /output
c
  490 continue
      call ioutput(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /plankton_standing_stock
c
  500 continue
      call iplnkstk(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /plfish
c
  510 continue
      call iplfish(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /plot, /print
c
  520 continue
      call iopts(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /recall
c
  530 continue
      call irecall(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /set
c
  540 continue
      call iset(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /store
c
  550 continue
      call istore(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /temperature
c
  560 continue
      call itemp(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c general parameters: /~header, /title
c
  570 continue
      call ititle(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c chemicals-id: /Toxlab
c
  580 continue
      call itoxlab(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c /version
c
  590 continue
      call iversion(wverb(1:nv), xxok)
      go to 620
c
c ******************************************************************
c < /~zz | /zz > + options
c
  600 continue
      call izz(wverb(1:nv), xxok, nptr)
      go to 620
c
c ******************************************************************
c chemicals properties: /Pka
c
  610 continue
      call ipchem(wverb(1:nv), xxok, pka)
      go to 620
c
c ******************************************************************
c ******************************************************************
c
  620 continue
      if ( .not. xxok) tot_errors = tot_errors + 1
      if ( .not. xxfin) go to 110       ! continue                          
c
  630 continue
      return
      end
      subroutine sfish0(uu)
c
c update: 17:44 fri 4-mar-1994.
c output fish info
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'menu.par'
      include 'globpar.def'
c
      integer uu
      integer jspecies, kbeg, kend, exitcode
      real rlo, rhi
c
 9110 format (1x,3x,'-------------------------')
c
      call tokrange('show fish', eol, exitcode, rlo, rhi)
      if (exitcode .eq. tquit) then
         go to 110
      elseif (exitcode .eq. tfailure) then
         go to 110
      elseif (exitcode .eq. twild) then
         kbeg = 1       ! evaluate "*"                
         kend = gnspecies
      else
         kbeg = nint(rlo)       ! integer range               
         kend = nint(rhi)
      endif
c
      do jspecies = kbeg, kend
         call sfish1(uu, jspecies)
         if (jspecies .lt. kend) write (uu, 9110)
      enddo
c
  110 continue
      return
      end
      subroutine sfish1(uu, kspecies)
c
c update: 17:30 fri 4-mar-1994.
c output fish info: physiological parameters et al.
c
c notes:
c . changes in the computation of activity (option "tobserved") should be
c   propagated to the module "Afish", "La50", "Owpezall"
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'noval.par'
c
      include 'fish.def'
c
      integer uu, kspecies
c
c miscellaneous declarations
c
      character*(stdlen) q1tmp
      integer xslen, nage, nspp, nfam, neco, nq1
      external xslen
c
 9110 format (1x,3x,'Species: ',a)
 9120 format (1x,3x,'Family : ',a)
 9130 format (1x,3x,'Ecology: ',a)
 9140 format (1x,3x,'Number of Age Classes: ',a)
c
      if (spplab(kspecies) .ne. snoval) then
         nspp = xslen(spplab(kspecies))
         write (uu, 9110) spplab(kspecies)(1:nspp)
      else
         write (uu, 9110) snoval
      endif
c
      if (famlab(kspecies) .ne. snoval) then
         nfam = xslen(famlab(kspecies))
         write (uu, 9120) famlab(kspecies)(1:nfam)
      else
         write (uu, 9120) snoval
      endif
c
      if (ecolab(kspecies) .ne. snoval) then
         neco = xslen(ecolab(kspecies))
         write (uu, 9130) ecolab(kspecies)(1:neco)
      else
         write (uu, 9130) snoval
      endif
c
      nage = xmaximum_age(kspecies)
      if (nage .gt. 0) then
         call int2a(nage, q1tmp, nq1)
         write (uu, 9140) q1tmp(1:nq1)
      else
         write (uu, 9140) snoval
      endif
c
      call sfish2(uu, nage, kspecies)   ! age-independent parameters   
c
      write (uu, *)
      call sfish3(uu, nage, kspecies)   ! age-dependent parameters -- table
c
      continue
      return
      end
      subroutine sfish2(uu, nage, kspecies)
c
c update: 17:30 fri 4-mar-1994.
c
c this subroutine outputs age-independent morphological & physiological
c parameters; it will provide resolution info also.
c
c changes in this module should be propagated to "Ospecies" "Sfish2" "Sfish3"
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'numbers.par'
      include 'noval.par'
      include 'physio.par'
      include 'simul.par'
c
      include 'diet.def'
      include 'fish.def'
      include 'globpar.def'
      include 'options.def'
      include 'vdefined.def'
c
      integer uu, nage, kspecies
c
      character*(stdlen) q1tmp
      integer nq1, jprey, jage, jrange
      integer jallometric, jholling, jlinear, jclearance
      logical lpred, lallometric, lholling, llinear, lclearance
      real d1, d2, rho1, rho2, q10, exx
      external exx
c
      include 'vdefined.sfn'
c
 9110 format (1x,6x,a,': ',1pg10.3,:,' [',a,']')
 9120 format (1x,6x,a,': ',a)
 9130 format (1x,3x,
     &   'Total Gill Surface Area [cm^2] = sgill1 * wt[g]**sgill2')
 9140 format (1x,3x,'Fraction of gill surface area which ',
     &   'is physiologically active: ',a)
 9150 format (1x,3x,
     &   'Number of lamellae / mm gill filament = rho1 * wt[g]**rho2')
 9160 format (1x,3x,'Lamellar length [cm] = laml1 * wt[g]**laml2')
 9170 format (1x,3x,
     &   'Fish aqueous fraction (pa) = pa1 + pa2*(lipid fraction)')
 9180 format (1x,3x,'Fish weight[g] = lenwt1 * fish_length[cm]**lenwt2')
 9190 format (1x,3x,'Routine respiration [mg o2 consumed/hr]',/,1x,3x,
     &   '= Exp(Ln(Q10)/10 * (T-Tref)) * ox1 * wt[g]**ox2')
 9200 format (1x,3x,'Assimilation efficiency')
 9210 format (1x,3x,'Respiratory quotient [litres CO2 respired/',
     &   'litres O2 consumed]')
 9220 format (1x,3x,
     &   'Prey_length[cm] = pred1 + pred2 * predator_length[cm]')
 9230 format (1x,3x,'Cmax = maximum observed ingestion [grams/day]',/,1
     &   x,3x,'= Exp(Ln(Q10)/10 * (T-Tref)) * cmax1 * wt[g]**cmax2')
 9240 format (1x,3x,'Fsat = size of satiation meal [gram] consumed durin
     &g (0, tsat)',/,1x,3x,
     &   '= Exp(Ln(Q10)/10 * (T-Tref)) * fsat1 * wt[g]**fsat2')
 9250 format (1x,3x,'Tsat = time to satiation when feeding with an ',
     &   'initially empty stomach [Min]',/,1x,3x,
     &   '= Exp(Ln(Q10)/10 * (T-Tref)) * tsat1 * wt[g]**tsat2')
 9260 format (1x,3x,'Evac = stomach evacuation [gram/day]',/,1x,3x,
     &   '= Exp(Ln(Q10)/10 * (T-Tref)) * evac1 * ',
     &   'wt[g]**evac2 * I**evac3',/,1x,3x,
     &   'I is the amount of food [grams] resident in the GI track')
 9270 format (1x,3x,'Gamma = linear growth rate [day^-1]',/,1x,3x,
     &   '= Exp(Ln(Q10)/10 * (T-Tref)) * gamma1 * wt[g]**gamma2')
 9280 format (1x,3x,'Cvol = maximum daily clearance volume [litre/day]',
     &   /,1x,3x,'= Exp(Ln(Q10)/10 * (T-Tref)) * cvol1 * wt[g]**cvol2')
c;;
      jage = 1
c
c sgill = gill area [cm^2] = sgill1 * wt[g]**sgill2
c
      write (uu, 9130)
      if (vdefined(vv_pval(vsgill1, jage, kspecies))) then
         call owpar(vv_ptyp(vsgill1, jage, kspecies), q1tmp, nq1)
         write (uu, 9110) 'sgill1', vv_pval(vsgill1, jage, kspecies), 
     &      q1tmp(1:nq1)
      else
         write (uu, 9120) 'sgill1', snoval
      endif
      if (vdefined(vv_pval(vsgill2, jage, kspecies))) then
         call owpar(vv_ptyp(vsgill2, jage, kspecies), q1tmp, nq1)
         write (uu, 9110) 'sgill2', vv_pval(vsgill2, jage, kspecies), 
     &      q1tmp(1:nq1)
      else
         write (uu, 9120) 'sgill2', snoval
      endif
c
      if (vdefined(activegill(kspecies))) then
         call real2a(activegill(kspecies), '(f5.2)', q1tmp, nq1)
         write (uu, 9140) q1tmp(1:nq1)
      else
         write (uu, 9140) snoval
      endif
c
c rho = # lamellae / mm gill filament = rho1 * wt[g]**rho2
c compute lamellar densities from interlamellar distances;
c the same formula should be used in "Dbnorm", "Ofishpar", "Ospecies";
c
c     d[cm] = 0.11815 * rho[# lamellae/mm gill filament] ** (-1.18862)
c
c        d1 * wt * d2 = 0.11815 * (rho1 * wt * rho2) ** (-1.18862)
c
      write (uu, 9150)
      d1 = vv_pval(vrho1, jage, kspecies)
      d2 = vv_pval(vrho2, jage, kspecies)
      if (vdefined(d1)) then
         rho1 = (d1 / 0.11815) ** (1.0 / ( -1.18862))
         call owpar(vv_ptyp(vrho1, jage, kspecies), q1tmp, nq1)
         write (uu, 9110) 'rho1', rho1, q1tmp(1:nq1)
      else
         write (uu, 9120) 'rho1', snoval
      endif
      if (vdefined(d2)) then
         rho2 = d2 / ( -1.18862)
         call owpar(vv_ptyp(vrho2, jage, kspecies), q1tmp, nq1)
         write (uu, 9110) 'rho2', rho2, q1tmp(1:nq1)
      else
         write (uu, 9120) 'rho2', snoval
      endif
c
c laml = lamellar length [cm] = laml1 * wt[g]**laml2
c
      write (uu, 9160)
      if (vdefined(vv_pval(vlaml1, jage, kspecies))) then
         call owpar(vv_ptyp(vlaml1, jage, kspecies), q1tmp, nq1)
         write (uu, 9110) 'laml1', vv_pval(vlaml1, jage, kspecies), 
     &      q1tmp(1:nq1)
      else
         write (uu, 9120) 'laml1', snoval
      endif
      if (vdefined(vv_pval(vlaml2, jage, kspecies))) then
         call owpar(vv_ptyp(vlaml2, jage, kspecies), q1tmp, nq1)
         write (uu, 9110) 'laml2', vv_pval(vlaml2, jage, kspecies), 
     &      q1tmp(1:nq1)
      else
         write (uu, 9120) 'laml2', snoval
      endif
c
c pa = fraction aqueous = pa1 + pa2*pl  (Barber et al. 1991: pa2 < 0)
c
      write (uu, 9170)
      if (vdefined(vv_pval(vpa1, jage, kspecies))) then
         call owpar(vv_ptyp(vpa1, jage, kspecies), q1tmp, nq1)
         write (uu, 9110) 'pa1', vv_pval(vpa1, jage, kspecies), 
     &      q1tmp(1:nq1)
      else
         write (uu, 9120) 'pa1', snoval
      endif
      if (vdefined(vv_pval(vpa2, jage, kspecies))) then
         call owpar(vv_ptyp(vpa2, jage, kspecies), q1tmp, nq1)
         write (uu, 9110) 'pa2', vv_pval(vpa2, jage, kspecies), 
     &      q1tmp(1:nq1)
      else
         write (uu, 9120) 'pa2', snoval
      endif
c
c wt = fish weight[gram] = lenwt1 * fish_length[cm]**lenwt2
c
      write (uu, 9180)
      if (vdefined(vv_pval(vlenwt1, jage, kspecies))) then
         call owpar(vv_ptyp(vlenwt1, jage, kspecies), q1tmp, nq1)
         write (uu, 9110) 'lenwt1', vv_pval(vlenwt1, jage, kspecies), 
     &      q1tmp(1:nq1)
      else
         write (uu, 9120) 'lenwt1', snoval
      endif
      if (vdefined(vv_pval(vlenwt2, jage, kspecies))) then
         call owpar(vv_ptyp(vlenwt2, jage, kspecies), q1tmp, nq1)
         write (uu, 9110) 'lenwt2', vv_pval(vlenwt2, jage, kspecies), 
     &      q1tmp(1:nq1)
      else
         write (uu, 9120) 'lenwt2', snoval
      endif
c
c o2 = routine respiration [mg o2 consumed/ hr]
c    = Exp(Ln(Q10)/10 * (T-Tref)) * ox1 * wt[g]**ox2
c
      write (uu, 9190)
      if (vdefined(vv_pval(vox1, jage, kspecies))) then
         call owpar(vv_ptyp(vox1, jage, kspecies), q1tmp, nq1)
         write (uu, 9110) ' ox1', vv_pval(vox1, jage, kspecies), 
     &      q1tmp(1:nq1)
      else
         write (uu, 9120) ' ox1', snoval
      endif
      if (vdefined(vv_pval(vox2, jage, kspecies))) then
         call owpar(vv_ptyp(vox2, jage, kspecies), q1tmp, nq1)
         write (uu, 9110) ' ox2', vv_pval(vox2, jage, kspecies), 
     &      q1tmp(1:nq1)
      else
         write (uu, 9120) ' ox2', snoval
      endif
      if (vdefined(vv_pval(voxq10, jage, kspecies))) then
         q10 = exx(vv_pval(voxq10, jage, kspecies) * 10.0)
         call owpar(vv_ptyp(voxq10, jage, kspecies), q1tmp, nq1)
         write (uu, 9110) ' Q10', q10, q1tmp(1:nq1)
      else
         write (uu, 9120) ' Q10', snoval
      endif
      if (vdefined(vv_pval(voxt, jage, kspecies))) then
         call owpar(vv_ptyp(voxt, jage, kspecies), q1tmp, nq1)
         write (uu, 9110) 'Tref', vv_pval(voxt, jage, kspecies), 
     &      q1tmp(1:nq1)
      else
         write (uu, 9120) 'Tref', snoval
      endif
c
c assimilation efficiency
c
      write (uu, 9200)
      if (vdefined(vv_pval(vassxeff, jage, kspecies))) then
         call owpar(vv_ptyp(vassxeff, jage, kspecies), q1tmp, nq1)
         write (uu, 9110) 'assimilation efficiency', 
     &      vv_pval(vassxeff, jage, kspecies), q1tmp(1:nq1)
      else
         write (uu, 9120) 'assimilation efficiency', snoval
      endif
c
c respiratory quotient [litres CO2 respired/ litres O2 consumed]
c
      write (uu, 9210)
      if (vdefined(vv_pval(vrq, jage, kspecies))) then
         call owpar(vv_ptyp(vrq, jage, kspecies), q1tmp, nq1)
         write (uu, 9110) 'respiratory quotient', 
     &      vv_pval(vrq, jage, kspecies), q1tmp(1:nq1)
      else
         write (uu, 9120) 'respiratory quotient', snoval
      endif
c
c prey_length [cm] = length of prey for a given predator length
c                  = pred1 + pred2 * predator_length [cm]
c
c if Simul_mode == tfood_chain then required IF the prey is another fish;
c if Simul_mode == tfood_web then
c    required only if some member of its diet is not
c        (plankton | benthos | cfish)
c else not required;
c
      if ((simul_mode .eq. tfood_chain) .or. (simul_mode .eq. tfood_web)
     &   ) then
         lpred = .false.
         jage = 0
         do jrange = 1, range_numof(kspecies)
            do jprey = 1, gnspecies
               lpred = lpred .or. (fdiet(jprey, jrange, kspecies) .gt. 
     &            zero)
               if (lpred) then
                  jage = 1
                  go to 110     ! short circuit loop;                     
               endif
            enddo
         enddo
  110    continue
      else
         lpred = .false.
         jage = 0
      endif
c
      if (lpred) then
         write (uu, 9220)
         if (vdefined(vv_pval(vpred1, jage, kspecies))) then
            call owpar(vv_ptyp(vpred1, jage, kspecies), q1tmp, nq1)
            write (uu, 9110) 'pred1', vv_pval(vpred1, jage, kspecies), 
     &         q1tmp(1:nq1)
         else
            write (uu, 9120) 'pred1', snoval
         endif
         if (vdefined(vv_pval(vpred2, jage, kspecies))) then
            call owpar(vv_ptyp(vpred2, jage, kspecies), q1tmp, nq1)
            write (uu, 9110) 'pred2', vv_pval(vpred2, jage, kspecies), 
     &         q1tmp(1:nq1)
         else
            write (uu, 9120) 'pred2', snoval
         endif
      endif
c
      llinear = .false.
      lholling = .false.
      lclearance = .false.
      lallometric = .false.
c
      do jage = 1, nage
         if (vv_growth_model(jage, kspecies) .eq. tallometric) then
            lallometric = .true.
            jallometric = jage
         elseif (vv_growth_model(jage, kspecies) .eq. tholling) then
            lholling = .true.
            jholling = jage
         elseif (vv_growth_model(jage, kspecies) .eq. tlinear) then
            llinear = .true.
            jlinear = jage
         elseif (vv_growth_model(jage, kspecies) .eq. tclearance) then
            lclearance = .true.
            jclearance = jage
         endif
      enddo
c
c gamma = linear growth rate [day^-1]
c       = Exp(Ln(Q10)/10 * (T-Tref)) * gamma1 * wt[g]**gamma2
c
      if (llinear) then
         write (uu, 9270)
         if (vdefined(vv_pval(vgamma1, jlinear, kspecies))) then
            call owpar(vv_ptyp(vgamma1, jlinear, kspecies), q1tmp, nq1)
            write (uu, 9110) 'gamma1', 
     &         vv_pval(vgamma1, jlinear, kspecies), q1tmp(1:nq1)
         else
            write (uu, 9120) 'gamma1', snoval
         endif
         if (vdefined(vv_pval(vgamma2, jlinear, kspecies))) then
            call owpar(vv_ptyp(vgamma2, jlinear, kspecies), q1tmp, nq1)
            write (uu, 9110) 'gamma2', 
     &         vv_pval(vgamma2, jlinear, kspecies), q1tmp(1:nq1)
         else
            write (uu, 9120) 'gamma2', snoval
         endif
         if (vdefined(vv_pval(vgammaq10, jlinear, kspecies))) then
            q10 = exx(vv_pval(vgammaq10, jlinear, kspecies) * 10.0)
            call owpar(vv_ptyp(vgammaq10, jlinear, kspecies), q1tmp, nq1
     &         )
            write (uu, 9110) '   Q10', q10, q1tmp(1:nq1)
         else
            write (uu, 9120) '   Q10', snoval
         endif
         if (vdefined(vv_pval(vgammat, jlinear, kspecies))) then
            call owpar(vv_ptyp(vgammat, jlinear, kspecies), q1tmp, nq1)
            write (uu, 9110) '  Tref', 
     &         vv_pval(vgammat, jlinear, kspecies), q1tmp(1:nq1)
         else
            write (uu, 9120) '  Tref', snoval
         endif
      endif
c
c cmax = maximum observed ingestion [grams/day]
c      = Exp(Ln(Q10)/10 * (T-Tref)) * cmax1 * wt[g]**cmax2
c
      if (lallometric) then
         write (uu, 9230)
         if (vdefined(vv_pval(vcmax1, jallometric, kspecies))) then
            call owpar(vv_ptyp(vcmax1, jallometric, kspecies), q1tmp, 
     &         nq1)
            write (uu, 9110) 'cmax1', 
     &         vv_pval(vcmax1, jallometric, kspecies), q1tmp(1:nq1)
         else
            write (uu, 9120) 'cmax1', snoval
         endif
         if (vdefined(vv_pval(vcmax2, jallometric, kspecies))) then
            call owpar(vv_ptyp(vcmax2, jallometric, kspecies), q1tmp, 
     &         nq1)
            write (uu, 9110) 'cmax2', 
     &         vv_pval(vcmax2, jallometric, kspecies), q1tmp(1:nq1)
         else
            write (uu, 9120) 'cmax2', snoval
         endif
         if (vdefined(vv_pval(vcmaxq10, jallometric, kspecies))) then
            q10 = exx(vv_pval(vcmaxq10, jallometric, kspecies) * 10.0)
            call owpar(vv_ptyp(vcmaxq10, jallometric, kspecies), q1tmp,
     &         nq1)
            write (uu, 9110) '  Q10', q10, q1tmp(1:nq1)
         else
            write (uu, 9120) '  Q10', snoval
         endif
         if (vdefined(vv_pval(vcmaxt, jallometric, kspecies))) then
            call owpar(vv_ptyp(vcmaxt, jallometric, kspecies), q1tmp, 
     &         nq1)
            write (uu, 9110) ' Tref', 
     &         vv_pval(vcmaxt, jallometric, kspecies), q1tmp(1:nq1)
         else
            write (uu, 9120) ' Tref', snoval
         endif
      endif
c
c fsat = size [gram] of satiation meal consumed during (0, tsat)
c      = Exp(Ln(Q10)/10 * (T-Tref)) * fsat1 * wt[g]**fsat2
c tsat = time to satiation when feeding with an initially empty stomach [Min]
c      = Exp(Ln(Q10)/10 * (T-Tref)) * tsat1 * wt[g]**tsat2
c evac = stomach evacuation [gram/day]
c      = Exp(Ln(Q10)/10 * (T-Tref)) * evac1 * wt[g]**evac2 * I**evac3
c        in general evac3 = 1/2, 2/3, or 1 (see jobling 1981 j.fish biol.19:245)
c
      if (lholling) then
         write (uu, 9240)
         if (vdefined(vv_pval(vfsat1, jholling, kspecies))) then
            call owpar(vv_ptyp(vfsat1, jholling, kspecies), q1tmp, nq1)
            write (uu, 9110) 'fsat1', 
     &         vv_pval(vfsat1, jholling, kspecies), q1tmp(1:nq1)
         else
            write (uu, 9120) 'fsat1', snoval
         endif
         if (vdefined(vv_pval(vfsat2, jholling, kspecies))) then
            call owpar(vv_ptyp(vfsat2, jholling, kspecies), q1tmp, nq1)
            write (uu, 9110) 'fsat2', 
     &         vv_pval(vfsat2, jholling, kspecies), q1tmp(1:nq1)
         else
            write (uu, 9120) 'fsat2', snoval
         endif
         if (vdefined(vv_pval(vfsatq10, jholling, kspecies))) then
            q10 = exx(vv_pval(vfsatq10, jholling, kspecies) * 10.0)
            call owpar(vv_ptyp(vfsatq10, jholling, kspecies), q1tmp, nq1
     &         )
            write (uu, 9110) '  Q10', q10, q1tmp(1:nq1)
         else
            write (uu, 9120) '  Q10', snoval
         endif
         if (vdefined(vv_pval(vfsatt, jholling, kspecies))) then
            call owpar(vv_ptyp(vfsatt, jholling, kspecies), q1tmp, nq1)
            write (uu, 9110) ' Tref', 
     &         vv_pval(vfsatt, jholling, kspecies), q1tmp(1:nq1)
         else
            write (uu, 9120) ' Tref', snoval
         endif
c
         write (uu, 9250)
         if (vdefined(vv_pval(vtsat1, jholling, kspecies))) then
            call owpar(vv_ptyp(vtsat1, jholling, kspecies), q1tmp, nq1)
            write (uu, 9110) 'tsat1', 
     &         vv_pval(vtsat1, jholling, kspecies), q1tmp(1:nq1)
         else
            write (uu, 9120) 'tsat1', snoval
         endif
         if (vdefined(vv_pval(vtsat2, jholling, kspecies))) then
            call owpar(vv_ptyp(vtsat2, jholling, kspecies), q1tmp, nq1)
            write (uu, 9110) 'tsat2', 
     &         vv_pval(vtsat2, jholling, kspecies), q1tmp(1:nq1)
         else
            write (uu, 9120) 'tsat2', snoval
         endif
         if (vdefined(vv_pval(vtsatq10, jholling, kspecies))) then
            q10 = exx(vv_pval(vtsatq10, jholling, kspecies) * 10.0)
            call owpar(vv_ptyp(vtsatq10, jholling, kspecies), q1tmp, nq1
     &         )
            write (uu, 9110) '  Q10', q10, q1tmp(1:nq1)
         else
            write (uu, 9120) '  Q10', snoval
         endif
         if (vdefined(vv_pval(vtsatt, jholling, kspecies))) then
            call owpar(vv_ptyp(vtsatt, jholling, kspecies), q1tmp, nq1)
            write (uu, 9110) ' Tref', 
     &         vv_pval(vtsatt, jholling, kspecies), q1tmp(1:nq1)
         else
            write (uu, 9120) ' Tref', snoval
         endif
c
         write (uu, 9260)
         if (vdefined(vv_pval(vevac1, jholling, kspecies))) then
            call owpar(vv_ptyp(vevac1, jholling, kspecies), q1tmp, nq1)
            write (uu, 9110) 'evac1', 
     &         vv_pval(vevac1, jholling, kspecies), q1tmp(1:nq1)
         else
            write (uu, 9120) 'evac1', snoval
         endif
         if (vdefined(vv_pval(vevac2, jholling, kspecies))) then
            call owpar(vv_ptyp(vevac2, jholling, kspecies), q1tmp, nq1)
            write (uu, 9110) 'evac2', 
     &         vv_pval(vevac2, jholling, kspecies), q1tmp(1:nq1)
         else
            write (uu, 9120) 'evac2', snoval
         endif
         if (vdefined(vv_pval(vevacq10, jholling, kspecies))) then
            q10 = exx(vv_pval(vevacq10, jholling, kspecies) * 10.0)
            call owpar(vv_ptyp(vevacq10, jholling, kspecies), q1tmp, nq1
     &         )
            write (uu, 9110) '  Q10', q10, q1tmp(1:nq1)
         else
            write (uu, 9120) '  Q10', snoval
         endif
         if (vdefined(vv_pval(vevact, jholling, kspecies))) then
            call owpar(vv_ptyp(vevact, jholling, kspecies), q1tmp, nq1)
            write (uu, 9110) ' Tref', 
     &         vv_pval(vevact, jholling, kspecies), q1tmp(1:nq1)
         else
            write (uu, 9120) ' Tref', snoval
         endif
      endif
c
c cvol = maximum daily clearance volume [litre/day]
c      = Exp(Ln(Q10)/10 * (T-Tref)) * cvol1 * wt[g]**cvol2
c
      if (lclearance) then
         write (uu, 9280)
         if (vdefined(vv_pval(vcvol1, jclearance, kspecies))) then
            call owpar(vv_ptyp(vcvol1, jclearance, kspecies), q1tmp, nq1
     &         )
            write (uu, 9110) 'cvol1', 
     &         vv_pval(vcvol1, jclearance, kspecies), q1tmp(1:nq1)
         else
            write (uu, 9120) 'cvol1', snoval
         endif
         if (vdefined(vv_pval(vcvol2, jclearance, kspecies))) then
            call owpar(vv_ptyp(vcvol2, jclearance, kspecies), q1tmp, nq1
     &         )
            write (uu, 9110) 'cvol2', 
     &         vv_pval(vcvol2, jclearance, kspecies), q1tmp(1:nq1)
         else
            write (uu, 9120) 'cvol2', snoval
         endif
         if (vdefined(vv_pval(vcvolq10, jclearance, kspecies))) then
            q10 = exx(vv_pval(vcvolq10, jclearance, kspecies) * 10.0)
            call owpar(vv_ptyp(vcvolq10, jclearance, kspecies), q1tmp, 
     &         nq1)
            write (uu, 9110) '  Q10', q10, q1tmp(1:nq1)
         else
            write (uu, 9120) '  Q10', snoval
         endif
         if (vdefined(vv_pval(vcvolt, jclearance, kspecies))) then
            call owpar(vv_ptyp(vcvolt, jclearance, kspecies), q1tmp, nq1
     &         )
            write (uu, 9110) ' Tref', 
     &         vv_pval(vcvolt, jclearance, kspecies), q1tmp(1:nq1)
         else
            write (uu, 9120) ' Tref', snoval
         endif
      endif
c
      return
      end
      subroutine sfish3(uu, nage, kspecies)
c
c update: 17:30 fri 4-mar-1994.
c
c this subroutine outputs age-independent morphological & physiological
c parameters; it will provide resolution info also.
c
c changes in this module should be propagated to "Ospecies" "Sfish2" "Sfish3"
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'noval.par'
      include 'physio.par'
      include 'simul.par'
c
      include 'fish.def'
      include 'units.def'
      include 'vdefined.def'
c
      integer uu, nage, kspecies
c
      character*(stdlen) q1tmp, q2tmp, q3tmp, q4tmp
      integer nq1, nq2, nq3, nq4, xslen, jage, nmass, ks
      integer kp1, kp2, kp3, kp4
      external xslen
c
      include 'vdefined.sfn'
c
 9110 format (1pg10.3)
 9120 format (3x,a,': ',1pg10.3,' [',a,']')
 9130 format (5x,a)
c
      ks = kspecies
      nmass = xslen(pgm_mass)
c
c build table header
c
      kp1 = 1
      kp2 = 6
      kp3 = 22
      kp4 = 40
c
c             !   kp1  kp2             kp3               kp4
c             !           10        20        30        40        50
c             !   123456789=123456789=123456789=123456789=123456789=12345
      q1tmp = 
     &   'Age  Initial Weight    Growth model    Lipid fraction (pl)'
      q2tmp = ' '
      q2tmp(kp2:) = ' [' // pgm_mass(1:nmass) // ' live]'
      q2tmp(kp3:) = '(func. response)'
      q3tmp = 
     &   '---  --------------  ----------------  -------------------'
      nq1 = xslen(q1tmp)
      nq2 = xslen(q2tmp)
      nq3 = xslen(q3tmp)
c
      if (nage .gt. 0) then
         write (uu, 9130) q1tmp(1:nq1)
         write (uu, 9130) q2tmp(1:nq2)
         write (uu, 9130) q3tmp(1:nq3)
      endif
c
      do jage = 1, nage
         q1tmp = ' '
         q2tmp = ' '
         q3tmp = ' '
         write (q1tmp(kp1:), '(i2)') jage
         if (vdefined(vv_iniwt(jage, ks))) then
            write (q1tmp(kp2:), 9110) vv_iniwt(jage, ks)
         else
            q1tmp(kp2:) = snoval
         endif
         if (vv_growth_model(jage, ks) .eq. tallometric) then
            write (q4tmp, 9110) vv_functional_response(jage, ks)
            call compress(q4tmp, -1, nq4)
            q1tmp(kp3:) = 'Allometric'
            q2tmp(kp3:) = '(' // q4tmp(1:nq4) // ')'
         elseif (vv_growth_model(jage, ks) .eq. tholling) then
            write (q4tmp, 9110) vv_functional_response(jage, ks)
            call compress(q4tmp, -1, nq4)
            q1tmp(kp3:) = 'Holling'
            q2tmp(kp3:) = '(' // q4tmp(1:nq4) // ')'
         elseif (vv_growth_model(jage, ks) .eq. tclearance) then
            write (q4tmp, 9110) vv_functional_response(jage, ks)
            call compress(q4tmp, -1, nq4)
            q1tmp(kp3:) = 'Clearance'
            q2tmp(kp3:) = '(' // q4tmp(1:nq4) // ')'
         elseif (vv_growth_model(jage, ks) .eq. tlinear) then
            q1tmp(kp3:) = 'Linear'
         else
            q1tmp(kp3:) = snoval
         endif
c
c pl = fraction lipid = pl1 * wt[g]**pl2
c pl = pl1
c pl = pl1  +  pl2 * wt[g]
c
         if ((vv_plfunc(jage, ks) .eq. tallometric) .or. (
     &      vv_plfunc(jage, ks) .eq. tdatabase) .or. (
     &      vv_plfunc(jage, ks) .eq. tfishpar)) then
            q1tmp(kp4:) = 'pl = pl1 * wt[g]**pl2'
            call owpar(vv_ptyp(vpl1, jage, ks), q4tmp, nq4)
            write (q2tmp(kp4:), 9120) 'pl1', vv_pval(vpl1, jage, ks), 
     &         q4tmp(1:nq4)
            call owpar(vv_ptyp(vpl2, jage, ks), q4tmp, nq4)
            write (q3tmp(kp4:), 9120) 'pl2', vv_pval(vpl2, jage, ks), 
     &         q4tmp(1:nq4)
         elseif (vv_plfunc(jage, ks) .eq. tconstant) then
            q1tmp(kp4:) = 'pl = pl1'
            call owpar(vv_ptyp(vpl1, jage, ks), q4tmp, nq4)
            write (q2tmp(kp4:), 9120) 'pl1', vv_pval(vpl1, jage, ks), 
     &         q4tmp(1:nq4)
         elseif (vv_plfunc(jage, ks) .eq. tlinear) then
            q1tmp(kp4:) = 'pl = pl1  +  pl2 * wt[g]'
            call owpar(vv_ptyp(vpl1, jage, ks), q4tmp, nq4)
            write (q2tmp(kp4:), 9120) 'pl1', vv_pval(vpl1, jage, ks), 
     &         q4tmp(1:nq4)
            call owpar(vv_ptyp(vpl2, jage, ks), q4tmp, nq4)
            write (q3tmp(kp4:), 9120) 'pl2', vv_pval(vpl2, jage, ks), 
     &         q4tmp(1:nq4)
         else
            q1tmp(kp4:) = 'pl function: ' // snoval
         endif
c
         nq1 = xslen(q1tmp)
         nq2 = xslen(q2tmp)
         nq3 = xslen(q3tmp)
c
         write (uu, 9130) q1tmp(1:nq1)
         if (nq2 .gt. 0) write (uu, 9130) q2tmp(1:nq2)
         if (nq3 .gt. 0) write (uu, 9130) q3tmp(1:nq3)
      enddo
c
      return
      end
      real function sineeval(a, b, alpha, beta, bk, mterms, tt)
c
c update: mon 08:32 21-oct-1991.
c
c evaluate trigonometric interpolation generated by h1_gsin;
c
c                M             k * Pi
c        y(t) = Sum { b_k Sin (------ (t - a)) }  +
c               k=1             b - a
c
c               alpha  +  beta * (t - a)
c
c;;
c module argument list
c
      integer mterms
      real a, b, alpha, beta, bk( * ), tt
c
      real pi
      parameter (pi = 3.141592653589793)
      real ysum, qtmp
      integer kk
c
      qtmp = (tt - a) * pi / (b - a)
      ysum = alpha + beta * (tt - a)
      do kk = 1, mterms
         ysum = ysum + bk(kk) * sin(real(kk) * qtmp)
      enddo
      sineeval = ysum
c
      return
      end
      subroutine sinegen(tobs, yobs, nobs, maxbk, mterms, bk, alpha, 
     &   beta, aa, bb)
c
c update: thu 09:31 24-oct-1991.
c Tobs:     observed x-values; Tobs are equally spaced;
c yobs:     observed y-values
c Nobs:     number of observed points
c maxbk:    maximum number of terms to generate
c
c mterms:   number of coefficients generated
c bk:       coefficients
c alpha:    linear trend coefficient, alpha + beta*(t-aa)
c beta:     linear trend coefficient, alpha + beta*(t-aa)
c aa:       == Tobs(1)
c bb:       == Tobs(Nobs)
c
c perform fourier analysis of data using sine function;
c ref: lanczos, c. 1956. applied analysis. prentice hall, inc.:
c      englewood cliffs, nj. [chapter iv, chapter v sections 11-12]
c
c  1. assume Tobs, yobs define the function y(t)
c        t in [Tobs(1), Tobs(Nobs)] == [a, b]
c        y == yobs(*)
c        Tobs are equally spaced:
c           h_t = Tobs(i+1) - Tobs(i)
c           Tobs(k+1) = a + h_t * k,   k = 0, 1, 2, ..., Nobs-1
c        notation:
c           y_k = f(k h_x),  k = 0, 1, ..., n
c
c
c
c  2. translate y(t) to f(x) where x in [0, L]
c
c           L                         b - a
c     x = ----- (t - a)     ;;    t = ----- x  +  a
c         b - a                         L
c
c
c               b - a
c     y(t) = y (----- x  +  a) =: f(x)
c                 L
c
c
c  3. improve convergence of the fourier series by reflecting f(x) as an even
c     function for negative x, and thus expand f(x) into a pure cosine series.
c     consider:
c
c        g(x) = f(x)  -  (alpha + beta*x)
c
c     such that
c
c        g(0) = 0,   g(L) = 0
c
c     which yields
c
c        alpha = f(0)
c        beta = (f(L) - f(0)) / L
c
c                                 f(L) - f(0)
c        g(x) = f(x)  -  f(0)  -  ----------- x
c                                      L
c
c                                y(b) - y(a)
c        g(x) = y(t)  -  (y(a) + ----------- (t - a))
c                                  b  -  a
c
c        g(x) = y(t)  -  (alpha + beta * (t - a))
c
c  4. reflect g(x) as an odd function, i.e., g(-x) = -g(x),  x > 0.
c     the resulting function, if made periodic with period 2L, has no
c     discontinuities in either function or derivative. the first discontinuity
c     appears in the second derivative. the asymptotic order of magnitude of
c     the fourier terms is n^(-3).
c
c  5. develop g(x) into a pure sine series of the form
c
c                M             k * Pi
c        g(x) = Sum { b_k Sin (------ x) }
c               k=1              L
c
c        k = 1, 2, ... , M == number of terms in the expansion
c
c
c     where (for full analysis review reference)
c
c               2  n-1                           Pi
c        b_k =  -  Sum { g(j * h_x) Sin (k * j * --) }
c               n  j=1                           n
c
c                L
c        h_x = ----- (h_t)
c              b - a
c
c
c     which reduces to
c
c               2  n-1                     Pi
c        b_k =  -  Sum { w(j) Sin (k * j * --) }
c               n  j=1                     n
c
c                                             y(b) - y(a)
c        w(j) = y (j * h_t  +  a)  -  (y(a) + ----------- (j * h_t))
c                                               b  -  a
c
c                M             k * Pi
c        y(t) = Sum { b_k Sin (------ (t - a)) }  +  alpha + beta * (t - a)
c               k=1             b - a
c
c;;
      real tobs(0: * ), yobs(0: * ), bk( * ), alpha, beta, aa, bb
      integer nobs, maxbk, mterms
c
      real skj, pi, pi_over_n, two_over_n, wjj, k_pi_over_n
      real p0, p1, bbsum, bbm, bbmp1, eps
      integer jj, kk, nn, ngen
      logical found
c
      pi = 4.0 * atan(1.0)
      eps = 0.01        ! convergence if: Abs(a_n - a_{n+1}) .le. eps
      ngen = maxbk      ! maximum number of terms to generate     
c
      nn = nobs - 1
      pi_over_n = pi / real(nn)
      two_over_n = 2.0 / real(nn)
c
      aa = tobs(0)
      bb = tobs(nn)
      beta = (yobs(nn) - yobs(0)) / (bb - aa)
      alpha = yobs(0)
      p1 = beta ! alpha + beta*(t-a) == p0 + p1*t   
      p0 = alpha - beta * aa
c
      do kk = 1, ngen
         bbsum = 0.0
         k_pi_over_n = real(kk) * pi_over_n
         do jj = 1, nn - 1
            skj = sin(real(jj) * k_pi_over_n)
            wjj = yobs(jj) - (p0 + p1 * tobs(jj))
            bbsum = bbsum + wjj * skj
         enddo
         bk(kk) = two_over_n * bbsum
      enddo
c
c determine cutoff frequency
c
c                         1    m
c generate bb^{2}_{m} :=  -   Sum  bk_{ngen-i+1} ^{2}
c                         m   i=1
c
c as m increases, bb will approach a fairly constant value. select "mterms"
c such that  Abs (bk_{mterms+1})  .le.  bb;
c
      bbsum = bk(ngen) ** 2
      bbmp1 = bbsum
      bbm = bbmp1
      kk = 1
c
      found = .false.
      do jj = ngen - 1, 1, -1
         kk = kk + 1
         bbm = bbmp1
         bbsum = bbsum + bk(jj) ** 2
         bbmp1 = bbsum / real(kk)
         if (abs(bbmp1 - bbm) .le. eps) then
            found = .true.
            go to 110
         endif
      enddo
c
  110 continue
      if (found) then
         found = .false.
         bbm = sqrt(bbm)
         do jj = 1, ngen
            if (bbm .ge. abs(bk(jj))) then
               found = .true.
               mterms = jj
               go to 120
            endif
         enddo
         mterms = ngen
      else
         mterms = ngen
      endif
  120 continue
c
      return
      end
      logical function srchew0(wstr, wpat)
c
c update: thu 11:30 23-apr-1992.
c Srchew0  -  performs wildcard matches;
c notes:
c - the "*" character is the only wildcard and recognizes zero or more
c   characters.
c - it will only match the shortest possible string in the input for each
c   wildcard character, even though longer matching sequences may exist, e.g.,
c   the pattern "aa*bb*xyz" matches "aa@bb@xyz" but not "aa@bb@xyz@bb@xyz".
c   more to the point, the pattern "m*t" will match "Molwt" but not
c   "melting_point"  --  this is a problem i am trying to fix.  in order
c   to fix this bug a full regular expression parser is needed.
c - the pattern is not escaped, therefore there is no way of matching the
c   wildcard character itself.
c - for your confort, convenience, and safety, trailing uwhite will be
c   ignored.  this may be considered a bug or a feature.
c
c - [lsr] thu 11:28 23-apr-1992.
c   the module will now match the longest possible string. this still causes
c   some problems, to which the solution is a full regular expression parser
c;;
      character*( * ) wildcard  ! Wildcard character       
      parameter (wildcard = '*')
c
      character*( * ) wstr, wpat
c
      integer nstr, npat, jstr, jpat, i2, k0, kn, xslen, laststr
      logical done
      external xslen, laststr
c
      nstr = xslen(wstr)
      npat = xslen(wpat)
      jstr = 1  ! string pointer                             
      jpat = 1  ! pattern pointer                            
      done = .false.
c
      do while ( .not. done)
         if ((jstr .gt. nstr) .and. (jpat .gt. npat)) then
            srchew0 = .true.
            done = .true.
         elseif (jstr .gt. nstr) then
            srchew0 = ((wpat(jpat:jpat) .eq. wildcard) .and. (jpat + 1 
     &         .gt. npat))
            done = .true.
         elseif (jpat .gt. npat) then
            srchew0 = .false.
            done = .true.
         elseif (wpat(jpat:jpat) .eq. wildcard) then
            if (jpat + 1 .gt. npat) then        ! match to end    
               srchew0 = .true.
               done = .true.
            else
               jpat = jpat + 1
               k0 = jpat
               kn = 0
  110          continue
               if (jpat .le. npat) then
                  if (wpat(jpat:jpat) .ne. wildcard) then
                     kn = kn + 1
                     jpat = jpat + 1
                     go to 110
                  endif
               endif
c
c two or more wildcards in succession will crash the code; fudge it.
c it the user is so <insert favorite derogative here> to input something like
c "a**", s/he deserves what s/he gets.
c skip the first wildcard and loop.
c
               if (kn .gt. 0) then
ccc                  i2 = Index (wstr (jstr:nstr),  wpat (k0 : k0 + kn - 1))
                  i2 = laststr(wstr(jstr:nstr), nstr - jstr + 1, 1, 
     &               wpat(k0:k0 + kn - 1))
                  if (i2 .eq. 0) then
                     srchew0 = .false.
                     done = .true.
                  else
                     jstr = jstr + i2 - 1 + kn
                  endif
               else
                  continue
               endif
            endif
         elseif (wstr(jstr:jstr) .eq. wpat(jpat:jpat)) then     ! ordinary character
            jstr = jstr + 1
            jpat = jpat + 1
         else   ! ordinary character and failed
            srchew0 = .false.
            done = .true.
         endif
      enddo
c
      return
      end
      logical function srchex0(ws1, ws2, status, nch)
c
c update: tue 13:14 14-jul-1992.
c compare ws1(1:Len(ws1)) to ws2(1:Len(ws2));
c trailing blanks, tabs and nulls (ascii 0) will be ignored;
c     Null  = Char(000)           ! [^@] Null character
c     Tab   = Char(009)           ! [^i] horizontal Tab
c     Blank = ' '                 ! Blank
c
c letter case is not significant; embedded uwhite is not significant.
c
c input:
c - ws1     s*(*) string 1
c - ws2     s*(*) string 2
c
c output:
c Srchex0   logical; truth of "status == ts1eqs2 or ts2ins1"
c           in this context, ws1 is the "full string",
c                            ws2 is the "abbreviated string";
c
c - status  integer, values are defined in include file "srch.par"
c           ts1eqs2 : strings are equal
c           ts1ins2 : string "s1" is contained in "s2", e.g.,
c                       s1 = "q" , s2 = "quit"
c           ts2ins1 : string "s2" is contained in "s1", e.g.,
c                       s2 = "q" , s1 = "quit"
c           ts1lts2 : string "s1" is lexicographically less than s2,
c                       e.g., s1 = "abc" , s2 = "abz"
c           ts1gts2 : string "s1" is lexicographically greater than s2,
c                       e.g., s1 = "abz" , s2 = "abc"
c
c - nch     integer, number of characters matched, i.e.,
c           if nch > 0, then ws1(1:nch) == ws2(1:nch)
c
c notes:
c - to determine if ws1 < ws2 , check status == ts1lts2 or ts1ins2
c - to determine if ws1 = ws2 , check status == ts1eqs2 or ts1ins2 or ts2ins1
c - examples:
c    ws1   ws2       status     nch   found
c    --------------------------------------
c     8    8         ts1eqs2     80     T
c     1    1         ts1eqs2     80     T
c     10   1         ts2ins1      2     T
c    quit  quit      ts1eqs2     80     T
c    quit  quitx     ts1ins2     80     F
c    quitx quit      ts2ins1      4     T
c    quitx q         ts2ins1      1     T
c    abc   abk       ts1lts2      2     F
c    abk   abc       ts1gts2      2     F
c    xy    ab        ts1gts2      0     F
c    ab    xy        ts1lts2      0     F
c    a     z         ts1lts2      0     F
c    z     a         ts1gts2      0     F
c    aa    z         ts1lts2      0     F
c    z     aa        ts1gts2      0     F
c    abc   abcd      ts1ins2     80     F
c    abcd  abc       ts2ins1      3     T
c    abc   b         ts1lts2      0     F
c    bcd   a         ts1gts2      0     F
c;;
      include 'srch.par'
c
      character*( * ) ws1, ws2
      integer status, nch
c
      character*(26) lcalphabet, ucalphabet
      character*(1) c1, c2, null
      integer ns1, ns2, js1, js2, nn
      logical done
c
      logical uwhite
      character*1 carg1
      uwhite(carg1) = (carg1 .eq. ' ') .or. (carg1 .eq. char(9)) .or. (
     &   carg1 .eq. char(0))
c
      data lcalphabet /'abcdefghijklmnopqrstuvwxyz'/
      data ucalphabet /'ABCDEFGHIJKLMNOPQRSTUVWXYZ'/
c
      status = 0
      nch = 0
      null = char(0)
c
      js1 = 1
      js2 = 1
      ns1 = len(ws1)
      ns2 = len(ws2)
      done = .false.
c
c by setting c_{n} to Null, we can do all the ifs with the current character.
c
  110 continue
      if ( .not. done) then
  120    continue       ! get next nonblank character, string 1      
         if (js1 .le. ns1) then
            if (uwhite(ws1(js1:js1))) then
               js1 = js1 + 1
               go to 120
            endif
            c1 = ws1(js1:js1)
         else
            c1 = null
         endif
c
  130    continue       ! get next nonblank character, string 2      
         if (js2 .le. ns2) then
            if (uwhite(ws2(js2:js2))) then
               js2 = js2 + 1
               go to 130
            endif
            c2 = ws2(js2:js2)
         else
            c2 = null
         endif
c
         if ((c1 .eq. null) .and. (c2 .eq. null)) then
            nch = js1 - 1
            status = ts1eqs2
            done = .true.
         elseif (c1 .eq. null) then     ! i.e., Len(s1) < Len(s2)     
            nch = js1 - 1
            status = ts1ins2
            done = .true.
         elseif (c2 .eq. null) then     ! i.e., Len(s1) > Len(s2)     
            nch = js1 - 1
            status = ts2ins1
            done = .true.
         elseif (c1 .eq. c2) then
            js1 = js1 + 1
            js2 = js2 + 1
         else   ! not equal: try letter case transliteration
            nn = index(ucalphabet, c1)
            if (nn .gt. 0) c1 = lcalphabet(nn:nn)
            nn = index(ucalphabet, c2)
            if (nn .gt. 0) c2 = lcalphabet(nn:nn)
c
            if (c1 .eq. c2) then
               js1 = js1 + 1
               js2 = js2 + 1
            elseif (llt(c1, c2)) then
               nch = js1 - 1
               status = ts1lts2
               done = .true.
            else
               nch = js1 - 1
               status = ts1gts2
               done = .true.
            endif
         endif
         go to 110
      endif
      srchex0 = ((status .eq. ts1eqs2) .or. (status .eq. ts2ins1))
c
      return
      end
      logical function srchlb0(xkey, xlist, nlist, keypos)
c
c update: mon 08:56 28-jan-1991
c binary search xlist(1:nlist) for a given xkey;
c
c description of the arguments:
c input:
c    xlist  - sorted list of elements
c    nlist  - number of entries
c    xkey   - value to find in xlist
c
c output:
c    keypos - if xkey was found then keypos = xlist Index of xkey;
c             if xkey not found then keypos = xlist Index of where it should be
c    Srchlb0 - truth of "xkey found"
c
c internal variables:
c    low    - Index of first  entry in the current sublist
c    high   - Index of last   entry in the current sublist
c    middle - Index of middle entry in the current sublist
c
      character*( * ) xlist( * ), xkey
      integer nlist, keypos
      logical found
      integer low, high, middle
c
      low = 1
      high = nlist
      found = .false.
      keypos = 0
c
  110 continue
      if (( .not. found) .and. (low .le. high)) then
         middle = (low + high) / 2
         if (xkey .eq. xlist(middle)) then
            keypos = middle
            found = .true.
         elseif (xkey .lt. xlist(middle)) then
            high = middle - 1
         else
            low = middle + 1
         endif
         go to 110
      endif
c
      if ( .not. found) then
         keypos = low
      endif
      srchlb0 = (found)
c
      return
      end
      subroutine srchlbw(xkey, xlist, nlist, p2list, nhits)
c
c update: 17:30 fri 4-mar-1994.
c search a list, first with exact match binary search, then with wildcards.
c
c description of the arguments:
c input:
c    xlist  - sorted list of elements
c    nlist  - number of entries
c    xkey   - value to find in xlist
c
c output:
c    Nhits  - number of entries found.
c    {xlist (p2list (jj)), jj = 1, Nhits} are the hits (matches)
c
c;;
      include 'xglobal.par'
c
      character*( * ) xlist( * ), xkey
      integer nlist, p2list( * ), nhits
c
      character*(stdlen) xitem
      logical found, srchlb0
      integer ncom, nk, xslen
      external xslen, srchlb0
c
      nk = xslen(xkey)
      if (nk .le. 0) then
         nhits = 0
         found = .false.
      else
         found = srchlb0(xkey(1:nk), xlist, nlist, ncom)        ! exact match ?
         if (found) then
            nhits = 1
            p2list(nhits) = ncom
         else   ! abbreviated comand ?
            if (index(xkey(1:nk), '*') .gt. 0) then
               call srchlw0(xkey(1:nk), xlist, nlist, p2list, nhits)
            else
               xitem(1:nk) = xkey(1:nk)
               nk = nk + 1
               xitem(nk:nk) = '*'       ! WildCard match
               call srchlw0(xitem(1:nk), xlist, nlist, p2list, nhits)
            endif
            found = (nhits .gt. 0)
         endif
      endif
c
      return
      end
      logical function srchll0(xitem, xlist, nlist, npos)
c
c update: thu 12:02 7-feb-1991.
c
c look for xitem in xlist ; xlist is not sorted: linear search used.
c
      character*( * ) xitem, xlist( * )
      integer nlist, npos, npp
      logical found, done
c
      npp = 1
      found = .false.
  110 continue
      done = ((found) .or. (npp .gt. nlist))
      if ( .not. done) then
         if (xitem .ne. xlist(npp)) then
            npp = npp + 1
         else
            found = .true.
         endif
         go to 110
      endif
c
      if (found) then
         npos = npp
      else
         npos = 0
      endif
      srchll0 = (found)
c
      return
      end
      logical function srchllx(xitem, xlist, nlist, xhits, nhits)
c
c update: tue 11:05 10-mar-1992.
c
c look for xitem in xlist ; xlist is not sorted: linear search used;
c if an exact match is not found, try incremental search;
c
      character*( * ) xitem, xlist( * )
      integer nlist, xhits( * ), nhits, npos, kstatus, kch
      logical done, srchex0, srchll0
      external srchex0
c
      if (srchll0(xitem, xlist, nlist, npos)) then
         nhits = 1
         xhits(nhits) = npos
c
      else
         nhits = 0
         npos = 1
  110    continue
         done = (npos .gt. nlist)
         if ( .not. done) then
            if (srchex0(xlist(npos), xitem, kstatus, kch)) then
               nhits = nhits + 1
               xhits(nhits) = npos
            endif
            npos = npos + 1
            go to 110
         endif
      endif
      srchllx = (nhits .gt. 0)
c
      return
      end
      subroutine srchlw0(xitem, xlist, nlist, p2list, nhits)
c
c update: sat 12:48 29-feb-1992.
c
c look for xitem (a pattern with possible "*") in xlist;
c xlist may or may not be sorted,
c on output: {xlist (p2list (jj)), jj = 1, Nhits} are the hits (matches)
c
      character*( * ) xitem, xlist( * )
      integer nlist, p2list( * ), nhits
c
      integer ji, jl, xslen
      external xslen
c
      integer jj
      logical found, srchew0
      external srchew0
c
      ji = xslen(xitem)
c
      nhits = 0
      do jj = 1, nlist
         jl = xslen(xlist(jj))
         found = srchew0(xlist(jj)(1:jl), xitem(1:ji))
         if (found) then
            nhits = nhits + 1
            p2list(nhits) = jj
         endif
      enddo
c
      return
      end
      real function ssgutdrv(fun_resp, phi, gmax, alpha1, alpha2, epsl1,
     &   epsl2)
c
c update: 13:29 fri 19-aug-1994.
c . processed by SPAG 4.50I  at 13:29 on 19 Aug 1994
c
c this function determines the steady-state value (i.e., g0 such that
c {dg/dt eval. at g0} = 0) of the differential equation for "foodg"
c (mass of food in the gut [g]);
c
c    dg
c    --  =  ingest - assim - egest
c    dt
c
c where
c    ingest = fun_resp * phi * (gmax - g)
c    assim  = alpha1 * g ** alpha2
c    egest  = epsl1 * g ** epsl2
c
c input arguments:
c    fun_resp, phi, gmax, alpha1, alpha2, epsl1, epsl2
c
c output arguments:
c    Ssgutdrv
c
c declaration for arguments
c;;
      include 'xglobal.par'
      include 'numbers.par'
      include 'idfiles.def'
      include 'holling.def'
c
      real fun_resp, phi, gmax, alpha1, alpha2, epsl1, epsl2
c
c local variables
c
      real xeps, foodg_min, foodg_max, fzero
      integer nerror
c
c bona fide external -- function name used as argument
c
      real ssgutfx
      external ssgutfx
c
      xxfun_resp = fun_resp
      xxphi = phi
      xxgmax = gmax
      xxalpha1 = alpha1
      xxalpha2 = alpha2
      xxepsl1 = epsl1
      xxepsl2 = epsl2
c
      xeps = 1.00e-04
      foodg_min = zero
      foodg_max = gmax
c
c call Zbrent(Ssgutfx, xeps, nsig, foodg_min, foodg_max, maxfn, nerror)
      call zeroin(foodg_min, foodg_max, ssgutfx, xeps, nerror, fzero)
c
      if (nerror .eq. 1) then
         write (stdout, 9110)
         write (jerr, 9110)
         errused = .true.
         call errlog(.true., ' ', 0)
      endif
      ssgutdrv = fzero
c
 9110 format (1x,'?? Ssgutdrv/Zeroin error: f(a) * f(b) > 0')
c
      return
      end
      real function ssgutfx(xfoodg)
c
c update: wed 13:01 24-jul-1991.
c
c this function determines the steady-state value (i.e., g0 such that
c {dg/dt eval. at g0} = 0) of the differential equation for "foodg"
c (mass of food in the gut [g]);
c
c    dg
c    --  =  ingest - evac
c    dt
c
c where
c    evac   = Min (assim + egest, g)
c    ingest = fun_resp * phi * (gmax - g)
c    assim  = alpha1 * g ** alpha2
c    egest  = epsl1 * g ** epsl2
c
c declaration for arguments
c;;
      include 'numbers.par'
      include 'holling.def'
c
      real xfoodg
c
c local variables
c
      real ingest, assim, egest, evac
c
      ingest = xxfun_resp * xxphi * (xxgmax - xfoodg)
      if (xfoodg .gt. zero) then
         assim = xxalpha1 * xfoodg ** xxalpha2
         egest = xxepsl1 * xfoodg ** xxepsl2
      else
         assim = zero
         egest = zero
      endif
c
      evac = assim + egest
      ssgutfx = ingest - evac
c
      return
      end
      subroutine stemp(uu)
c
c update: 17:52 fri 4-mar-1994.
c output temperature info
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'habitat.par'
      include 'noval.par'
      include 'simul.par'
c
      include 'idfiles.def'
      include 'globpar.def'
      include 'chemp.def'
      include 'chems.def'
      include 'habitat.def'
      include 'vdefined.def'
c
      integer uu
c
      character*(stdlen) q1tmp
      integer xslen, nq1
      external xslen
c
      include 'vdefined.sfn'
c
 9110 format (1pg11.4)
 9120 format (1pg11.4,' +',1pg11.4,' * Sin(',1pg11.4,' * t[day] +',1pg11
     &   .4,')')
 9130 format (1x,3x,'Ambient Temperature, Celsius: ',a)
c
      if (twfunc .eq. tfile) then
         nq1 = xslen(cwfil)
         q1tmp = 'file "' // cwfil(1:nq1) // '"'
      elseif (twfunc .eq. tconstant) then
         write (q1tmp, 9110) twpar(1)
      elseif (twfunc .eq. tsin) then
         write (q1tmp, 9120) twpar(1), twpar(2), twpar(3), twpar(4)
      else
         q1tmp = snoval
      endif
      call compress(q1tmp, -1, nq1)
      write (uu, 9130) q1tmp(1:nq1)
c
      continue
      return
      end
      subroutine stimes(uu)
c
c update: 17:51 fri 4-mar-1994.
c output tstart, tend, tstep
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'noval.par'
      include 'time.def'
      include 'vdefined.def'
c
      integer uu
c
      character*(stdlen) q1tmp
      integer nq1
      external xslen
c
      include 'vdefined.sfn'
c
 9110 format (1x,3x,a,a,a)
c
      if (vdefined(simul_beg)) then
         call real2a(simul_beg, '(1pg11.4)', q1tmp, nq1)
         write (uu, 9110) 'Starting time: ', q1tmp(1:nq1), 
     &      ' <Pgm_time or Tunits>'
      else
         write (uu, 9110) 'Starting time: ', snoval
      endif
c
      if (vdefined(simul_end)) then
         call real2a(simul_end, '(1pg11.4)', q1tmp, nq1)
         write (uu, 9110) 'Ending time: ', q1tmp(1:nq1), 
     &      ' <Pgm_time or Tunits>'
      else
         write (uu, 9110) 'Endding time: ', snoval
      endif
c
      if (vdefined(tnstep)) then
         call real2a(tnstep, '(1pg11.4)', q1tmp, nq1)
         write (uu, 9110) 'Time Step: ', q1tmp(1:nq1), 
     &      ' <Pgm_time or Tunits>'
      else
         write (uu, 9110) 'Time Step: ', snoval
      endif
c
      continue
      return
      end
      subroutine sunits(uu)
c
c update: 17:45 fri 4-mar-1994.
c output units
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'noval.par'
      include 'units.def'
c
      integer uu, nn, xslen
      external xslen
c
 9110 format (1x,3x,a,a)
c
      if (wtunits .ne. snoval) then
         nn = xslen(wtunits)
         write (uu, 9110) 'Mass (input): ', wtunits(1:nn)
      else
         write (uu, 9110) 'Mass (input): ', snoval
      endif
c
      if (cfunits .ne. snoval) then
         nn = xslen(cfunits)
         write (uu, 9110) 'Conc. in fish (input): ', cfunits(1:nn)
      else
         write (uu, 9110) 'Conc. in fish (input): ', snoval
      endif
c
      if (cwunits .ne. snoval) then
         nn = xslen(cwunits)
         write (uu, 9110) 'Conc. in water (input): ', cwunits(1:nn)
      else
         write (uu, 9110) 'Conc. in water (input): ', snoval
      endif
c
      if (tunits .ne. snoval) then
         nn = xslen(tunits)
         write (uu, 9110) 'Time (input): ', tunits(1:nn)
      else
         write (uu, 9110) 'Time (input): ', snoval
      endif
c
      if (pgm_time .ne. snoval) then
         nn = xslen(pgm_time)
         write (uu, 9110) 'Time (output): ', pgm_time(1:nn)
      else
         write (uu, 9110) 'Time (output): ', snoval
      endif
c
      if (pgm_conc .ne. snoval) then
         nn = xslen(pgm_conc)
         write (uu, 9110) 'Conc. in water (output): ', pgm_conc(1:nn)
      else
         write (uu, 9110) 'Conc. in water (output): ', snoval
      endif
c
      if (pgm_mass .ne. snoval) then
         nn = xslen(pgm_mass)
         write (uu, 9110) 'Mass (output): ', pgm_mass(1:nn)
      else
         write (uu, 9110) 'Mass (output): ', snoval
      endif
c
c
      continue
      return
      end
c SWITCH.spg  processed by SPAG 3.14A  at 14:47 on 26 Oct 1992
      subroutine switch(zargs, nargs, option, nopti, nxtarg)
c
c update:   fri 16:40 16-oct-1992.
c decode other switches wich start with '-' ;
c "-a -b -c ..." or "-abc..."
c
      character*( * ) zargs( * )
      integer nargs, nopti, nxtarg, np, jj
      logical option( * )
c
      include 'chars.def'
      include 'chars.sfn'
c
      np = 2
  110 continue
      if ( .not. uwhite(zargs(nxtarg)(np:np))) then
         jj = ichar(zargs(nxtarg)(np:np))
         option(jj) = .true.
         np = np + 1
         go to 110
      endif
      nxtarg = nxtarg + 1
c
      return
      end
c SWYN.spg  processed by SPAG 3.14A  at 14:47 on 26 Oct 1992
      subroutine swyn(zargs, nargs, option, nopti, nxtarg, np, defopt)
c
c\begin
c     get a yes or no answer:
c        syntax: "-cy" or "-cy" or "-c+" ==> affirmative
c                "-cn" or "-cn" or "-c-" ==> negative
c                "-c?" will be set to the boolean value of defopt
c        "c" stands for any character;
c        "?" stands for any character except:
c               "upper-case-y"; "lower-case-y"; "+"
c               "upper-case-n"; "lower-case-n"; "-"
c
c     generally np is 2.
c\end
c
      character*( * ) zargs( * )
      integer nargs, nopti, nxtarg, np
c
      logical option( * ), defopt
      integer jopt
      character*1 cc
      external up2lo
c
      jopt = ichar(zargs(nxtarg)(np:np))
      np = np + 1
      cc = zargs(nxtarg)(np:np)
      call up2lo(cc, 1)
c
      if ((cc .eq. 'y') .or. (cc .eq. '+')) then
         option(jopt) = .true.
c
      elseif ((cc .eq. 'n') .or. (cc .eq. '-')) then
         option(jopt) = .false.
c
      else
         option(jopt) = defopt
      endif
c
      nxtarg = nxtarg + 1
      np = 1
c
      return
      end
      subroutine syslin(ok, xbuf, nbuf)
c
c ***** caution: this is a system dependent routine *****
c
c purpose:
c    - get the command line (the one that invoked this program)
c
c updates:
c    - [lsr] 12:25 sat 2-apr-1994.
c      . added error message for truncation
c    - processed by SPAG 3.14A  at 13:10 on  8 Jan 1993
c    - [lsr] 11:36:17.13 saturday december 9, 1989.
c    - [lsr] wed 15:49 25-apr-1990.
c      rm/fortran call added;
c
c problems:
c    - all input will be translated to upper case, except strings
c      delimited by double quotes (") (vax/vms idiosyncrasy).
c    - to get around this problem use a single double quote (")
c      at the beginning of the command: do not use double quotes
c      anywhere else in that string. the ending double quote is
c      optional (these quotes will be removed by this procedure).
c    - if a double quote is necessary use a double double quote ("");
c      however, the returned string will have a double double quote.
c      see examples below.
c    -  apparently does not have the letter-case problem.
c
c examples:
c    - test "abc               ! is legal
c    - test "abc"              ! is also legal
c    - test "lowercase "abc"   ! will translate "abc" to uppercase:
c                              ! the second (") effectively ends the string
c                              ! starting with the first (").
c                              ! the returned string will be:
c                              ! ==>lowercase "abc<==
c    - test " ABC""abc         ! returned string: ==> ABC""abc<==
c                              ! letter case is preserved.
c
c description of the variables:
c input:
c    *none*
c output:
c    ok     - logical; truth of "can access command line".
c             if the user cannot access the command line
c             set *ok* to .false.
c    Xbuf   - character*(*); command string read (if any);
c             if nothing was read then:
c                 Nbuf = 0.
c    Nbuf   - integer; number of characters in Xbuf.
c
c comments:
c    - if the user cannot access the command line set *ok* to .false.
c      example:
c         1234567 -- columns
c               subroutine SysLin (ok, Xbuf, Nbuf)
c         c
c               character*(*)      Xbuf
c               integer            Nbuf
c               logical            ok
c         c
c               ok = .false.
c               Nbuf = 0
c         c
c               return
c               end
c
c references:
c    - vax-11 run-time library reference manual, april 1982;
c      pages 2-49 to 2-50.
c    - f77l, fortran 77 language system,
c       computer systems, inc.
c      version 2.22; 11:37:28.65 monday february 1, 1988.
c      pages 12-1 to 12-2.
c;;
      include 'xglobal.par'
c
c define variables.
c
      character*( * ) xbuf
      integer nbuf
      logical ok
c
c
      integer xslen
      external xslen
c
c get command input string from the foreign command used to execute the program.
c
c
c maximum "readable" command line length = 127 characters (DOS 3.3)
c
      call getcl(xbuf)
      xbuf = 'NoName  ' // xbuf
      nbuf = xslen(xbuf)
      ok = (.true.)
c
      if (nbuf .ge. len(xbuf)) then
         write (zstderr, 9110)
      endif
 9110 format ('?? SysLin: possible truncation -- increase the length',/,
     &   '           of "Xbuf" in "GetArg".')
c
      return
      end
      subroutine tee(wbuf, nbuf)
c
c update: 17:31 fri 4-mar-1994.
c write buffer to Stdout and output file
c
c arguments (all input):
c . wbuf       s**; message to print; see "nbuf"
c . nbuf       integer;
c              > 0: print wbuf(1:nbuf)
c              = 0: issue carriage return
c              < 0: determine length of message (via Xslen) and print it
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'idfiles.def'
      include 'options.def'
c
      integer nbuf
      character*( * ) wbuf
c
      integer nlen, xslen
      external xslen
c
 9110 format (1x,a)
 9120 format (a)
c
      if (nbuf .ge. 0) then
         nlen = nbuf
      else
         nlen = xslen(wbuf)
      endif
c
      if (nlen .gt. 0) then
         write (stdout, 9110) wbuf(1:nlen)
         if (xouton) then
            write (jout, 9120) wbuf(1:nlen)
         endif
c
      else
         write (stdout, *)
         if (xouton) then
            write (jout, *)
         endif
      endif
c
      return
      end
      real function theta_b(ngz)
c
c update: mon 08:56 28-jan-1991
c
c evaluate the mixing cup concentration
c
c     theta_m =  b(m) * Exp{-2/3 * beta(m)**2 * ngz}
c
      real ngz
c
c  exchange of neutral organic; NSh = 1.00
c
      integer neigen
      parameter (neigen = 5)
      real beta(neigen), bm(neigen)
      integer jj, nterms
c
      real exx
      external exx
c
      data nterms /2/
      data (beta(jj), jj = 1, 5) /0.100000e+01, 0.465614e+01, 
     &   0.856202e+01, 0.125158e+02, 0.164876e+02/
      data (bm(jj), jj = 1, 5) /0.990073e+00, 0.837195e-02, 
     &   0.104781e-02, 0.278136e-03, 0.105056e-03/
c
      theta_b = 0.0
      do jj = nterms, 1, -1
         theta_b = theta_b + bm(jj) * 
     &      exx( -2.0 / 3.0 * beta(jj) ** 2 * ngz)
      enddo
c
      return
      end
      subroutine tok1c(wprompt, helpentry, exitcode, cc)
c
c update: 17:31 fri 4-mar-1994.
c get next nonblank character; prompting user if buffer is empty.
c help and quit are allowed.
c
c input:
c wprompt - prompting string
c helpentry - help entry name (in help file);
c             if Null ==> do not interpret help queries,
c                         i.e., return "?" or "help"
c
c output:
c exitcode - tquit | tsuccess | tfailure
c cc - next nonblank character, if "tsuccess"
c
c notes:
c . first <cr> :: issue help
c . second <cr> :: "quit"
c;;
      include 'xglobal.par'
      include 'menu.par'
      include 'Prompt.par'
      include 'token.par'
      include 'chars.def'
c
      character*( * ) wprompt, helpentry, cc
      integer exitcode
c
c nrets: number of consecutive carriage returns.
c
      character*(stdlen) q1tmp
      real rval
      integer xslen, ival, toktype, nrets
      logical xxfound, ishelp, isquit, isempty, nointerpretation
      external xslen, ishelp, isquit, isempty
c
      include 'chars.sfn'
c
      nrets = 0
      exitcode = tfailure
      nointerpretation = (helpentry .eq. null)
      call prompt(prset1, wprompt)
      if (isempty()) then
         call gethelp(helpentry, xxfound)
      endif
c
  110 continue
      call toknext(ttoken, q1tmp, ival, rval, toktype)
      if (iseol(q1tmp(1:1))) then
         nrets = nrets + 1
         if (nrets .le. 1) then
            call gethelp(helpentry, xxfound)
            call tokreset()
            go to 110
         else
            exitcode = tquit
         endif
      elseif (ishelp(q1tmp)) then
         if (nointerpretation) then
            exitcode = tsuccess
         else
            call gethelp(helpentry, xxfound)
            call tokreset()
            nrets = 0
            go to 110
         endif
      elseif (isquit(q1tmp)) then
         exitcode = tquit
      else
         exitcode = tsuccess
      endif
c
      if (exitcode .eq. tsuccess) then
         call tokpush()
         call toknext(tchar, cc, ival, rval, toktype)
      else
         exitcode = tquit
         cc = eol
      endif
      call prompt(prpop, ' ')
c
      return
      end
      subroutine tok1t(wprompt, helpentry, exitcode, sval, nlen)
c
c update: 17:54 fri 4-mar-1994.
c get next token, prompting user for a string. help and quit are allowed.
c
c input:
c wprompt - prompting string
c helpentry - help entry name (in help file)
c             if Null ==> do not interpret help queries,
c                         i.e., return "?" or "help"
c
c output:
c exitcode - tquit | tsuccess | tfailure
c sval - string gotten, if "tsuccess"
c nlen - Xslen(sval)
c
c notes:
c . first <cr> :: issue help
c . second <cr> :: "quit"
c;;
      include 'xglobal.par'
      include 'menu.par'
      include 'Prompt.par'
      include 'token.par'
      include 'chars.def'
c
      character*( * ) wprompt, helpentry, sval
      integer exitcode, nlen
c
c nrets: number of consecutive carriage returns.
c
      character*(stdlen) q1tmp
      real rval
      integer xslen, ival, toktype, nrets
      logical xxfound, ishelp, isquit, isempty, nointerpretation
      external xslen, ishelp, isquit, isempty
c
      include 'chars.sfn'
c
      nrets = 0
      exitcode = tfailure
      nointerpretation = (helpentry .eq. null)
      call prompt(prset1, wprompt)
      if (isempty()) then
         call gethelp(helpentry, xxfound)
      endif
c
  110 continue
      call toknext(ttoken, q1tmp, ival, rval, toktype)
      if (iseol(q1tmp(1:1))) then
         nrets = nrets + 1
         if (nrets .le. 1) then
            call gethelp(helpentry, xxfound)
            call tokreset()
            go to 110
         else
            exitcode = tquit
         endif
      elseif (ishelp(q1tmp)) then
         if (nointerpretation) then
            exitcode = tsuccess
         else
            call gethelp(helpentry, xxfound)
            call tokreset()
            nrets = 0
            go to 110
         endif
      elseif (isquit(q1tmp)) then
         exitcode = tquit
      else
         exitcode = tsuccess
      endif
c
      if (exitcode .eq. tsuccess) then
         sval = q1tmp
         nlen = xslen(q1tmp)
      else
         exitcode = tquit
         sval = eol
         nlen = 1
      endif
      call prompt(prpop, ' ')
c
      return
      end
      subroutine tok2dlim(target, stoken)
c
c update: 16:52 tue 5-apr-1994.
c
c read the buffer until the current character is found in target
c (and we are not in a quoted field);
c
c notes:
c - target is a set of 1-character tokens;
c - if we are at the end of buffer, return "Eol"
c - if "target" does not contain a quote character, then quoted
c   fields will be included as part of the output token.
c
c on output
c . stoken will contain all characters up to (but not including) "target";
c;;
      include 'xglobal.par'
      include 'xio.inc'
      include 'chars.def'
      include 'strings.par'
      include 'token.def'
c
      character*( * ) target, stoken
c
      character*1 cc
      integer jj, kbeg, kend, klen, pend
      integer xslen, nextnb, matchqte
      external xslen, nextnb, matchqte
c
      include 'chars.sfn'
c
      kbeg = 1
      stoken = ' '
c
c save previous positions
c
      nprev = min(nprev + 1, maxtokrecall)
      do jj = nprev, 2, -1
         pprev(jj) = pprev(jj - 1)
      enddo
      pprev(1) = pcur
c
      pcur = nextnb(xinbuf, len_inbuf, pcur)
  110 continue
      cc = xinbuf(pcur:pcur)
      if (pcur .le. len_inbuf) then
         if (index(target, cc) .le. 0) then     ! not found             
            if (isquote(cc)) then       ! include the whole quoted field
               pend = matchqte(xinbuf, pcur)
               if (pend .gt. 0) then
                  klen = pend - pcur + 1
                  kend = kbeg + klen - 1
                  stoken(kbeg:kend) = xinbuf(pcur:pend)
                  kbeg = kend + 1
                  pcur = pend + 1
               else     ! unbalanced quote         
                  stoken(kbeg:kbeg) = cc
                  kbeg = kbeg + 1
                  pcur = pcur + 1
               endif
            else
               stoken(kbeg:kbeg) = cc
               kbeg = kbeg + 1
               pcur = pcur + 1
            endif
            go to 110
         endif
      endif
c
      if (kbeg .eq. 1) then
         stoken(1:1) = eol
      endif
c
      return
      end
      subroutine tokbuf1(ttype, stoken, ival, rval, toktype, xbuf, pbuf,
     &   nbuf)
c
c update: 16:46 fri 4-mar-1994.
c
c get next token (+ type) from "xbuf(pbuf:nbuf)";
c if the token is treal, ival will be set to "Nint(rval)";
c if the token is tint,  rval will be set to "Real(ival)";
c;;
      include 'xglobal.par'
      include 'chars.def'
      include 'token.par'
c
      character*( * ) stoken, xbuf
      integer ttype, toktype, ival, pbuf, nbuf
      real rval
c
      character*1 cc
      integer nextnb, np1, np2, ntt, matchqte
      logical valid_char, xisrval, xisival
      external matchqte, xisrval, xisival
c
      logical xch
      include 'chars.sfn'
      xch(cc) = ((cc .eq. '~') .or. (cc .eq. '_') .or. (cc .eq. '$'))
c
      pbuf = nextnb(xbuf, nbuf, pbuf)
      if (pbuf .le. nbuf) then
         cc = xbuf(pbuf:pbuf)
      else
         cc = eol
      endif
c
      if (ttype .eq. tchar) then
         call up2lo(cc, 1)
         stoken = cc
         pbuf = pbuf + 1
         toktype = tchar
         go to 120
      endif
c
      if (isalfa(cc) .or. xch(cc)) then
         ntt = 1
         stoken(ntt:ntt) = cc
  110    continue
         pbuf = pbuf + 1
         if (pbuf .le. nbuf) then
            cc = xbuf(pbuf:pbuf)
            valid_char = ((alfanu(cc)) .or. xch(cc))
            if (valid_char) then
               ntt = ntt + 1
               stoken(ntt:ntt) = cc
               go to 110
            endif
         endif
         call up2lo(stoken(1:ntt), ntt)
         toktype = tident
c
      elseif (cc .eq. eol) then
         ntt = 1
         stoken(1:ntt) = cc
         pbuf = pbuf + 1
         toktype = teol
c
      elseif (cc .eq. eof) then
         ntt = 1
         stoken(1:ntt) = cc
         pbuf = pbuf + 1
         toktype = teof
c
      elseif (isquote(cc)) then
         np1 = pbuf
         np2 = matchqte(xbuf, np1)
         if (np2 .gt. 0) then
            toktype = tqstr
            ntt = np2 - np1 + 1
            stoken(1:ntt) = xbuf(np1:np2)
            pbuf = np2 + 1
         else   ! unbalanced quote            
            ntt = 1
            stoken(1:ntt) = cc
            pbuf = pbuf + 1
            toktype = toper
         endif
c
      elseif ((xbuf(pbuf:pbuf + 1) .eq. '**') .or. (
     &   xbuf(pbuf:pbuf + 1) .eq. '+-') .or. (xbuf(pbuf:pbuf + 1) .eq. 
     &   '<>') .or. (xbuf(pbuf:pbuf + 1) .eq. ':=') .or. (
     &   xbuf(pbuf:pbuf + 1) .eq. '//')) then
         ntt = 2
         stoken(1:ntt) = xbuf(pbuf:pbuf + 1)
         pbuf = pbuf + 2
         toktype = toper
c
c try to decode: {(+ | - | .)} {(integer | Real | other stuff)}
c
      else
         np1 = pbuf
         np2 = np1
         if (xisrval(rval, xbuf, np2)) then
            ival = nint(rval)
            toktype = treal
            pbuf = np2
            np2 = np2 - 1
            ntt = np2 - np1 + 1
            stoken(1:ntt) = xbuf(np1:np2)
         elseif (xisival(ival, xbuf, np2)) then
            rval = real(ival)
            toktype = tint
            pbuf = np2
            np2 = np2 - 1
            ntt = np2 - np1 + 1
            stoken(1:ntt) = xbuf(np1:np2)
         else
            ntt = 1
            stoken(1:ntt) = cc
            pbuf = pbuf + 1
            toktype = toper
         endif
      endif
      ntt = ntt + 1
      if (ntt .le. len(stoken)) stoken(ntt:) = ' '
c
  120 continue
      return
      end
      subroutine toknext(ttype, stoken, ival, rval, toktype)
c
c update: 16:52 tue 5-apr-1994.
c Toknext  -  read next token
c get next token (+ type);
c ttype - type of token to get:
c         tchar - get next character
c         ttoken - get next token
c
c return "Eol" if no token is found
c if Eof (^z) and it is level one, return "Eof" and reset Eof_inbuf
c;;
      include 'xglobal.par'
      include 'xio.inc'
      include 'xinclude.inc'
      include 'strings.par'
      include 'token.def'
c
      character*( * ) stoken
      integer ttype, toktype, ival
      real rval
c
      integer nextnb, jj
      logical freadx
      external nextnb, freadx
c
c make sure there is something in the buffer; read if necessary.
c
      if (eof_inbuf) then       ! end of file           
         nprev = 0
         xinbuf = eof
         pcur = 1
         len_inbuf = 1
      elseif (pcur .le. len_inbuf) then ! have unread stuff in line ?
         continue
      else      ! no: read a line.      
         nprev = 0
         pcur = 1
         if (freadx(xinbuf, len_inbuf)) then
            continue
         else
            eof_inbuf = (zlevel .gt. 1)
         endif
      endif
c
c now get the token;  save previous positions
c
      nprev = min(nprev + 1, maxtokrecall)
      do jj = nprev, 2, -1
         pprev(jj) = pprev(jj - 1)
      enddo
      pprev(1) = pcur
      call tokbuf1(ttype, stoken, ival, rval, toktype, xinbuf, pcur, 
     &   len_inbuf)
c
      return
      end
      subroutine tokpush()
c
c update: 16:52 tue 5-apr-1994.
c
c recall column of previous token.
c;;
      include 'xglobal.par'
      include 'xio.inc'
      include 'strings.par'
      include 'idfiles.def'
      include 'token.def'
c
      integer jj
c
 9110 format (1x,'?? Tokpush: no column to recall.')
c
      if (nprev .gt. 0) then
         pcur = pprev(1)
         nprev = nprev - 1
         do jj = 1, nprev
            pprev(jj) = pprev(jj + 1)
         enddo
      else
         write (stdout, 9110)
         write (jerr, 9110)
         errused = .true.
         call errlog(.true., ' ', 0)
      endif
c
      return
      end
      subroutine tokrange(wprompt, tdelims, exitcode, rlo, rhi)
c
c update: 17:45 fri 4-mar-1994.
c - get range, prompting user if the buffer is empty.
c - help and quit are allowed.
c - range may be integer or Real; results will be Real.
c - the module will not check the validity of numbers returned (e.g.,
c   rlo .le. rhi, verify that rlo and rhi are within certain bound, etc.)
c   because the range specification will be used in different settings. that is
c   the problem of the calling module.
c - for the same reason "*" is only noted; no attempt of interpretation is made.
c - will exit at the first error.
c - may use "-" or ":" to denote range, although ":" is preferred.
c
c input:
c . wPrompt(character*(*)) - Prompt to be used
c . tdelims (character*(*)) - characters that will terminate the range
c   if tdelims contains "Eol" then we will stop processing if the buffer
c      is empty and we have a decoded a range.  this is useful in order
c      to decode a range at the end of the line (i.e., with no terminator).
c      example:   list 1-3
c . characters are read from input buffer
c
c output:
c . exitcode (integer) - tquit | tfailure | trange | twild
c   == tfailure: no range found; the current token was the cause of failure;
c   == trange | twild: range found; the next token will be the one after
c        "tdelims";
c   == tquit: resets buffer;
c . rlo, rhi (reals) - the range, if "exitcode == trange"; otherwise
c                      indeterminate.
c
c buffer pointer -- example
c line: "Molwt ( 1 : 3 ) = 300";  tdelims = ")"
c               ^       ^
c               |       |
c               |       +- buffer-pointer (at output)
c               +- buffer-pointer (at input)
c examples:
c      input   rlo   rhi   exitcode    context
c     ----------------------------------------------
c      1 : 3   1.0   3.0   trange      Molwt (1 : 3)
c     2.3-3.1  2.3   3.1   trange      diet (2.3-3.1, ...
c        *      ?     ?    twild       Mp (*)
c        4     4.0   4.0   trange      Logp(4)
c       6.7    6.7   6.7   trange
c;;
      include 'xglobal.par'
      include 'menu.par'
      include 'idfiles.def'
c
      character*( * ) wprompt, tdelims
      integer exitcode
      real rlo, rhi
c
      character*(stdlen) q1tmp
      character*(1) cc
      real rval
      integer nq1, xstate, np, ecode
      logical xisnumb, weol, isempty, lgetc
      external xisnumb, isempty
c
 9110 format (1x,'?? expecting a number (Real or integer)')
 9120 format (1x,'?? expecting "',a,'"')
c
c state 0 (label = 2999): exit
c state 1: begin state variable approach
c
      weol = (index(tdelims, eol) .gt. 0)
      xstate = 1
      exitcode = tfailure
  110 continue
      go to (180, 120, 130, 140, 150, 160, 170), xstate + 1
c
  120 continue  ! state 01: start of range 
      call tok1t(wprompt, '~/range/num1', ecode, q1tmp, nq1)
      if (ecode .eq. tquit) then
         xstate = 0
         exitcode = tquit
      elseif (q1tmp(1:nq1) .eq. '*') then       ! found "*" of "xxx (* "   
         xstate = 2
      else
         xstate = 3     ! range ?                  
      endif
      go to 110
c
  130 continue  ! state 02: decoding "xxx (* "
      xstate = 6
      exitcode = twild
      go to 110
c
  140 continue  ! state 03: are we in range ?
      np = 1
      if (xisnumb(rval, q1tmp, np)) then        ! decoding "r1" of "xxx (r1 "
         rlo = rval
         rhi = rval
         xstate = 4
         exitcode = trange
      else
         xstate = 0
         exitcode = tfailure
         write (stdout, 9110)
      endif
      go to 110
c
  150 continue  ! state 04: to read "-" or ":"
      if (weol) then
         if (isempty()) then
            xstate = 0
            lgetc = .false.
         else
            lgetc = .true.
         endif
      else
         lgetc = .true.
      endif
      if (lgetc) then
         call tok1c(wprompt, '~/range/delim', ecode, cc)
         if (ecode .eq. tquit) then
            xstate = 0
            exitcode = tquit
         elseif (cc .eq. '-') then
            xstate = 5  ! get 2nd number        
         elseif (cc .eq. ':') then
            xstate = 5  ! get 2nd number        
         else
            call tokpush()      ! push back token        
            xstate = 6  ! it better be "tdelims"
         endif
      endif
      go to 110
c
  160 continue  ! state 05: to read 2nd number
      call tok1t(wprompt, '~/range/num2', ecode, q1tmp, nq1)
      if (ecode .eq. tquit) then
         xstate = 0
         exitcode = tquit
      else
         np = 1
         if (xisnumb(rval, q1tmp, np)) then
            rhi = rval
            xstate = 6
         else
            xstate = 0
            exitcode = tfailure
            write (stdout, 9110)
         endif
      endif
      go to 110
c
  170 continue  ! state 06: to read "tdelims"
      if (weol) then
         if (isempty()) then
            xstate = 0
            lgetc = .false.
         else
            lgetc = .true.
         endif
      else
         lgetc = .true.
      endif
      if (lgetc) then
         call tok1c(wprompt, '~/range/terminators', ecode, cc)
         if (ecode .eq. tquit) then
            xstate = 0
            exitcode = tquit
         elseif (index(tdelims, cc) .gt. 0) then
            xstate = 0
         else
            xstate = 0
            exitcode = tfailure
            write (stdout, 9120) tdelims
         endif
      endif
      go to 110
c
  180 continue  ! exit                     
      if (exitcode .eq. tquit) then
         call tokreset()
      endif
c
      return
      end
      subroutine tokreset()
c
c update: 16:52 tue 5-apr-1994.
c Tokreset  -  reset token variables;
c;;
      include 'xglobal.par'
      include 'xio.inc'
      include 'strings.par'
      include 'token.def'
c
      logical first_time
      data first_time /.true./
c
      if (first_time) then
         eof_inbuf = .false.
         first_time = .false.
         len_inbuf = 0
      endif
c
      nprev = 0
      pcur = len_inbuf + 1
c
      return
      end
      block data trblk
c;;
      include 'TRround.def'
c
      data trnotset /.true./
c
      end
cFF
      real function trfloor(x)
c
c Tolerant FLOOR Function.
c
c TRfloor(x) is the (fuzzy) largest integer less than or equal to X;
c TRceil(x) = -TRfloor(-X)
c TRound(x) = TRfloor(x+0.5e0)
c
c modules in this library:
c     block data Trblk              set initialization variable;
c     real function TRfloor(X)      (fuzzy) largest integer .le. X;
c     real function TRceil(X)       (fuzzy) smallest integer .gt. X;
c     real function Tround(X)       round up to the nearest integer;
c     logical function Treq(X,Y)    truth of (x .eq. y)
c     logical function Trne(X,Y)    truth of (x .ne. y)
c     logical function Trgt(X,Y)    truth of (x .gt. y)
c     logical function Trle(X,Y)    truth of (x .le. y)
c     logical function Trlt(X,Y)    truth of (x .lt. y)
c     logical function Trge(X,Y)    truth of (x .ge. y)
c     logical function TrIsInt(X)   truth of "X a floating integer";
c
c history:
c . [lsr] 09:28 fri 26-aug-1994.
c   - processed by SPAG 4.50I  at 10:32 on 26 Aug 1994
c   - "TrEps" is now a common block parameter, set the first time one
c     of the modules is used. this is more convenient (for my purposes);
c   - converted to single precision;
c   - test75.f used to validate answers: passed;
c
c . Article 9624 of comp.lang.fortran:
c   Organization: Penn State University
c   Date: Wed, 24 Aug 1994 08:09:14 EDT
c   From: H.D. Knoble <HDK@psuvm.psu.edu>
c   Subject: Re: floating point diff?
c
c X  -  is given as a real argument to be operated on.
c       it is assumed that X is represented with m mantissa bits.
c TrEps -  is given as a Comparison Tolerance such that
c
c           0 .lt. TrEps .le. 3-Sqrt(5)/2 (= 1.881966011).
c
c       If the relative difference between X and a whole number is less
c       than TrEps, then TRfloor is returned as this whole number. By treating
c       the floating-point numbers as a finite ordered set note that the
c       heuristic eps=2.0**(-(m-1)) and TrEps=3*eps causes arguments of
c       TRfloor/TRceil to be treated as whole numbers if they are exactly whole
c       numbers or are immediately adjacent to whole number representations.
c       Since EPS, the "distance" between floating-point numbers on the unit
c       interval, and m, the number of bits in X's mantissa, exist on every
c       floating-point computer, TRfloor/TRceil are consistently definable on
c       every floating-point computer.
c
c For more information see the following references:
c    {1} P. E. Hagerty, "More on Fuzzy Floor and Ceiling," APL  QUOTE
c        QUAD 8(4):20-24, June 1978. Note that TRfloor=FL5.
c    {2} L. M. Breed, "Definitions for Fuzzy Floor and Ceiling",  APL
c        QUOTE QUAD 8(3):16-23, March 1978.
c
c   H.D. Knoble, Penn State University.
c;;
      include 'TRround.def'
c
      real x
c
      real q, rmax, eps5, r1mach
      external r1mach, trblk
c
c FLOOR(X) is the largest integer algebraically less than
c or equal to X; that is, the unfuzzy Floor Function.
c
      real floor, wint
      wint(x) = x - mod(x, 1.0e0)
      floor(x) = wint(x) - mod(2.0e0 + sign(1.0e0, x), 3.0e0)
c
      if (trnotset) then
         trnotset = .false.
         treps = 3.0e0 * r1mach(4)
      endif
c
c Hagerty's FL5 Function follows...
c
      q = 1.0e0
      if (x .lt. 0) q = 1.0e0 - treps
      rmax = q / (2.0e0 - treps)
      eps5 = treps / q
c
      trfloor = floor(x + max(treps, 
     &   min(rmax, eps5 * abs(1.0e0 + floor(x)))))
      if (x .le. 0 .or. (trfloor - x) .lt. rmax) then
         return
      endif
      trfloor = trfloor - 1.0e0
c
      return
      end
cFF
      real function trceil(x)
c
c Tolerant Ceiling Function; See TRfloor.
c
      real x, trfloor
      external trfloor, trblk
c
      trceil = -trfloor( -x)
c
      return
      end
cFF
      real function tround(x)
c
c Tolerant Round Function; round up to the nearest integer;
c See Knuth, Art of Computer Programming, Vol. 1, Problem 1.2.4-5.
c
      real trfloor, x
      external trfloor, trblk
c
      tround = trfloor(x + 0.5e0)
c
      return
      end
cFF
      logical function treq(x, y)
c
c Fuzzy Comparison Arithmetic Function: TReq = (x .eq. y)
c
      include 'TRround.def'
c
      real x, y
c
      real r1mach
      external r1mach, trblk
c
      if (trnotset) then
         trnotset = .false.
         treps = 3.0e0 * r1mach(4)
      endif
c
      treq = abs(x - y) .le. max(abs(x), abs(y)) * treps
c
      return
      end
cFF
      logical function trne(x, y)
c
c Fuzzy Comparison Arithmetic Function: TRne = (x .ne. y)
c
      real x, y
c
      logical treq
      external treq, trblk
c
      trne = .not. treq(x, y)
c
      return
      end
cFF
      logical function trgt(x, y)
c
c Fuzzy Comparison Arithmetic Function: TRgt = (x .gt. y)
c
      include 'TRround.def'
c
      real x, y
c
      real r1mach
      external r1mach, trblk
c
      if (trnotset) then
         trnotset = .false.
         treps = 3.0e0 * r1mach(4)
      endif
c
      trgt = (x - y) .gt. max(abs(x), abs(y)) * treps
c
      return
      end
cFF
      logical function trle(x, y)
c
c Fuzzy Comparison Arithmetic Function: TRle = (x .le. y)
c
      real x, y
c
      logical trgt
      external trgt, trblk
c
      trle = .not. trgt(x, y)
c
      return
      end
cFF
      logical function trlt(x, y)
c
c Fuzzy Comparison Arithmetic Function: Trlt = (x .lt. y)
c
      real x, y
c
      logical trle, trne
      external trle, trne, trblk
c
      trlt = trle(x, y) .and. trne(x, y)
c
      return
      end
cFF
      logical function trge(x, y)
c
c Fuzzy Comparison Arithmetic Function: TRge = (x .ge. y)
c
      real x, y
c
      logical trgt, treq
      external trgt, treq, trblk
c
      trge = trgt(x, y) .or. treq(x, y)
c
      return
      end
cFF
      logical function trisint(x)
c
c truth of "X a floating integer";
c
      real x
c
      logical treq
      real trceil
      external trceil, treq, trblk
c
      trisint = treq(x, trceil(x))      ! integer if x == Ceil(x)        
c
      return
      end
      subroutine unit2si(wline, nline, dimxx, zeta, xxok, wmsg, nmsg, 
     &   uexpo, uunam, nnames, uprenam, nprefix, upreval, uuval, nqntt,
     &   lda, uudim)
c
c update: 17:32 fri 4-mar-1994.
c convert user units to SI units;
c
c premult - unit prefix conversion factor (e.g., kilo, pico)
c untpow - power term of current unit (e.g., metre^2)
c;;
      include 'xglobal.par'
      include 'token.par'
c
      character*( * ) wline, wmsg
      integer nline, dimxx( * ), nmsg
      real zeta
      logical xxok
c
      integer nqntt, nnames, nprefix, lda
      real upreval( * ), uuval( * )
      integer uudim(lda, * )
      character*( * ) uexpo, uprenam( * ), uunam( * )
c
      real zero, one
      parameter (zero = 0.00e+00, one = 1.00e+00)
c
      character*(stdlen) sq1, sq2, stoktype
      integer dn, jj, np, nq1, id, idprefix, ns, untpow, ival
      integer xslen, ntmp, ndenom, itoktype
      real premult, rval
      logical done, found, xisrval, xisival
      external xslen, xisrval, xisival
c
      xxok = .true.
      nmsg = 0
      zeta = zero
c
      do jj = 1, nqntt  ! initialize dimensions array           
         dimxx(jj) = 0
      enddo
c
c get a (possible) number
c
      np = 1
      if (xisrval(rval, wline, np)) then
         found = .true.
      elseif (xisival(ival, wline, np)) then
         rval = real(ival)
         found = .true.
      else
         found = .false.
      endif
      if ( .not. found) then
         rval = one
      endif
      zeta = rval
c
c dn: set to "-1" when "/" or "per" is found;
c     +1 ==> numerator
c     -1 ==> denominator
c
c ndenom: number of units after "/" or "per", i.e., after dn == -1;
c
c disallow constructs like:
c . gramme / Litre second
c . gramme / Litre / second
c . gramme /
c . millimicro
c
c algorithm:
c try to find the string in units table; if it is there, ok; else try to
c identify a prefix (e.g., micro). if we find a prefix, save the conversion
c factor in "premult", remove the prefix-string from the original string,
c and try to find the remaining string in the units table. repeat until
c success or we cannot remove any prefixes and cannot identify the unit.
c
c some unit strings look like prefixes, so make sure we look the units table
c first.
c
      dn = 1
      ndenom = 0
  110 continue
      done = (np .gt. nline)
      if ( .not. done) then
         untpow = 1
         premult = one
         call tokbuf1(ttoken, sq1, ival, rval, itoktype, wline, np, 
     &      nline)
ccc         call unitoken (wline, nline, np, sq1, ival, stoktype)
c
         if ((sq1(1:1) .eq. '/') .or. (sq1(1:3) .eq. 'per')) then
            if (dn .lt. 0) then ! second slash             
               xxok = .false.
               wmsg = 'only one "/" or "per" is allowed'
               nmsg = xslen(wmsg)
               go to 130
            endif
            dn = -1
         else
c
c see if unit has a power term; if it does, save the power in "untpow"
c
            ntmp = np
            call tokbuf1(ttoken, sq2, ival, rval, itoktype, wline, ntmp,
     &         nline)
ccc            call unitoken (wline, nline, ntmp, sq2, ival, stoktype)
            if (sq2(1:1) .eq. uexpo) then
               call tokbuf1(ttoken, sq2, ival, rval, itoktype, wline, 
     &            ntmp, nline)
ccc               call unitoken (wline, nline, ntmp, sq2, ival, stoktype)
               untpow = ival
               np = ntmp
            endif
c
            found = .false.
            nq1 = index(sq1, ' ') - 1
  120       continue
            done = ((found) .or. (nq1 .le. 0))
            if ( .not. done) then
               call unitid(sq1, uunam, nnames, id)
               found = (id .gt. 0)
               if ( .not. found) then
                  call unitpref(sq1, uprenam, nprefix, idprefix)
                  if (idprefix .gt. 0) then
                     premult = premult * upreval(idprefix)
                     ns = index(uprenam(idprefix), ' ')
                     sq2 = sq1(ns:)
                     sq1 = sq2
                     nq1 = index(sq1, ' ') - 1
                  else
                     xxok = .false.
                     write (wmsg, 9110) sq1(1:nq1)
                     nmsg = xslen(wmsg)
                     go to 130
                  endif
               endif
               go to 120
            endif
 9110       format ('unit "',a,'" not found in table')
c
            if ( .not. found) then
               xxok = .false.
               wmsg = 'found prefixes only'
               nmsg = xslen(wmsg)
               go to 130
            endif
c
            if (dn .lt. 0) then
               ndenom = ndenom + 1
            endif
            if (ndenom .ge. 2) then
               xxok = .false.
               wmsg = 
     &            'ambiguous construct: rephrase using negative powers'
               nmsg = xslen(wmsg)
               go to 130
            endif
c
            zeta = zeta / ((uuval(id) / premult) ** (untpow * dn))
            do jj = 1, nqntt
               dimxx(jj) = dimxx(jj) + untpow * dn * uudim(jj, id)
            enddo
         endif
         go to 110
      endif
c
c if found a slash (dn < 0) but no units (ndenom = 0): error, e.g., "mg / "
c
      if ((dn .lt. 0) .and. (ndenom .le. 0)) then
         xxok = .false.
         wmsg = 'trailing "/" or "per"'
         nmsg = xslen(wmsg)
         go to 130
      endif
c
  130 continue
      return
      end
      subroutine unitdrv(ufrom, uto, convfac, xxok, wmsg, nmsg)
c
c update: 17:32 fri 4-mar-1994.
c purpose:
c - driver for Unit2si(convert user units to SI)
c
c input arguments:
c - ufrom:     lowercased string, source units
c - uto:       lowercased string, target units
c
c output arguments:
c - convfac:   conversion factor
c - xxok:      truth of "everything ok"
c - wmsg(1:nmsg) - error description, if xxok == .false.
c
c notes:
c - propagate changes to "unitww21"
c;;
      include 'xglobal.par'
      include 'unitdb.def'
c
      character*( * ) ufrom, uto, wmsg
      real convfac
      integer nmsg
      logical xxok
c
      real zero, one
      parameter (zero = 0.00e+00, one = 1.00e+00)
c
c Kg to Metre^3 conversion: see notes below.
c
c ref: Standard Practice for use of the International System of Units (SI).
c      1989. American Society for Testing and Materials (ASTM),
c      designation: E 380-89a.
c
      real kg_to_metre3
      parameter (kg_to_metre3 = 1.00e-03)
c
      character*(stdlen) wfrom, wto
      real zfrom, zto
      integer nfrom, nto, jj, xslen, lfrom, lto, mm
      logical all_equal, lm_equal, only_temp, ltmp
      external xslen
c
      convfac = zero
      xxok = .true.
      nmsg = 0
      wmsg = ' '
c
      wfrom = ufrom     ! from "ufrom" to si          
      nfrom = xslen(ufrom)
      if (nfrom .le. 0) then
         xxok = .false.
         wmsg = 'empty "ufrom" string'
         nmsg = xslen(wmsg)
         go to 110
      elseif (nfrom .gt. len(wfrom)) then
         xxok = .false.
         wmsg = 'increase temporary storage for "ufrom"'
         nmsg = xslen(wmsg)
      endif
c
      call up2lo(wfrom, nfrom)
      call unit2si(wfrom, nfrom, dimfrom, zfrom, xxok, wmsg, nmsg, 
     &   uexpo, uunam, nnames, uprenam, nprefix, upreval, uuval, nqntt,
     &   umaxqntt, uudim)
      if (xxok) then
c
         wto = uto      ! from "uto" to si            
         nto = xslen(uto)
         if (nto .le. 0) then
            xxok = .false.
            wmsg = 'empty "uto" string'
            nmsg = xslen(wmsg)
            go to 110
         elseif (nto .gt. len(wto)) then
            xxok = .false.
            wmsg = 'increase temporary storage for "ufrom"'
            nmsg = xslen(wmsg)
         endif
c
         call up2lo(wto, nto)
         call unit2si(wto, nto, dimto, zto, xxok, wmsg, nmsg, uexpo, 
     &      uunam, nnames, uprenam, nprefix, upreval, uuval, nqntt, 
     &      umaxqntt, uudim)
         if (xxok) then
c
c temperature conversion ?
c
            only_temp = .true.
            do jj = 1, nqntt
               if (jj .ne. pkelvin) then
                  ltmp = (dimfrom(jj) .eq. 0) .and. (dimto(jj) .eq. 0)
               else
                  ltmp = (dimfrom(pkelvin) .eq. 1) .and. (
     &               dimto(pkelvin) .eq. 1)
               endif
               only_temp = (only_temp .and. ltmp)
            enddo
            if (only_temp) then
               call unittemp(wfrom, wto, zfrom, xxok, wmsg, nmsg)
               convfac = zfrom
               zto = one
               go to 110
            endif
c
c at this stage "Dimfrom" == "Dimto", otherwise the units do not have the
c same dimensionality (e.g., metre to gramme and such)
c
c if "length" and "mass" dimensions are not equal, convert according to:
c a. 1 Litre == 10^{-3} Metre^3, i.e., 1 Litre == 1 decimetre^3
c b. density == 1 Kilogramme Litre^{-1}
c c. 1 Kilogramme == 10^{-3} Metre^3
c d. by definition (see ref above) 1 decimetre water at 3.98C masses 1 Kg.
c
c let psi := L^{l} M^{m},  L == Length, M == Mass; psi == dimensional analysis
c
c from (c): M == 10^{-3} density L^3
c i.e.,     M^{m} = (10^{-3} density L^3)^{m}
c
c therefore
c           psi = L^{l + 3m} M^{0} * (10^{-3} density)^{m}
c
c (remember: density == 1)
c
c if the dimensions of Length and Mass are equal, nothing should be done.
c
            lm_equal = (dimfrom(pmetre) .eq. dimto(pmetre)) .and. (
     &         dimfrom(pkilogramme) .eq. dimto(pkilogramme))
            if ( .not. lm_equal) then
               lfrom = dimfrom(pmetre) + 3 * dimfrom(pkilogramme)
               lto = dimto(pmetre) + 3 * dimto(pkilogramme)
               if (lfrom .eq. lto) then
                  mm = dimfrom(pkilogramme)
                  dimfrom(pmetre) = lfrom
                  dimfrom(pkilogramme) = 0
                  zfrom = zfrom * (kg_to_metre3 ** mm)
c
                  mm = dimto(pkilogramme)
                  dimto(pmetre) = lto
                  dimto(pkilogramme) = 0
                  zto = zto * (kg_to_metre3 ** mm)
               endif
            endif
c
            all_equal = .true.
            do jj = 1, nqntt
               all_equal = (all_equal .and. (dimfrom(jj) .eq. dimto(jj))
     &            )
            enddo
            if ( .not. all_equal) then
               xxok = .false.
               wmsg = 'units do not have the same dimensions'
               nmsg = xslen(wmsg)
               go to 110
            endif
            convfac = zfrom / zto
         endif
      endif
c
  110 continue
      return
      end
      subroutine unitid(utoken, uunam, nnames, id)
c
c update: 17:32 fri 4-mar-1994.
c identify unit name
c
c process token (unit name)
c - convert plural form to singular; if unit name ends with "s" then assume it
c   is plural except for special cases (see below)
c - handle special cases first
c;;
      include 'xglobal.par'
c
      integer id, nnames
      character*( * ) uunam( * ), utoken
c
      character*(stdlen) wtoken
      integer ntoken, nstr, place, low, high, middle
      logical found, special
c
      wtoken = utoken
      ntoken = index(wtoken, ' ') - 1
c
      if (wtoken(1:ntoken) .eq. 'inches') then
         wtoken = 'inch'
c
      elseif (wtoken(1:ntoken) .eq. 'centuries') then
         wtoken = 'century'
c
      else      ! remove trailing "s" except "special"                   
         special = ((wtoken(1:ntoken) .eq. 's') .or. (
     &      wtoken(1:ntoken) .eq. 'gauss') .or. (wtoken(1:ntoken) .eq. 
     &      'celsius') .or. (wtoken(1:ntoken) .eq. 'siemens'))
         if ((wtoken(ntoken:ntoken) .eq. 's') .and. ( .not. special)) 
     &      then
            wtoken(ntoken:ntoken) = ' '
            ntoken = ntoken - 1
         endif
      endif
c
      low = 1   ! binary search                              
      high = nnames
      found = .false.
      place = 0
c
  110 continue
      if (( .not. found) .and. (low .le. high)) then
         middle = (low + high) / 2
         nstr = index(uunam(middle), ' ') - 1
         if (wtoken(1:ntoken) .eq. uunam(middle)(1:nstr)) then
            place = middle
            found = .true.
         elseif (wtoken(1:ntoken) .lt. uunam(middle)(1:nstr)) then
            high = middle - 1
         else
            low = middle + 1
         endif
         go to 110
      endif
c
      if (found) then
         id = place
      else
         id = -1
      endif
c
      return
      end
      subroutine unitpref(ustr, uprenam, nprefix, id)
c
c update: fri 14:13 7-feb-1992.
c identify prefix name
c
c we are looking for a prefix, therefore do NOT compare full strings;
c consider ustr == "microgramme",  Uprenam(id) == "micro"
c
      integer id, nprefix
      character*( * ) uprenam( * ), ustr
c
      integer nstr, place, low, high, middle
      logical found
c
      low = 1   ! binary search                              
      high = nprefix
      place = 0
      found = .false.
c
  110 continue
      if (( .not. found) .and. (low .le. high)) then
         middle = (low + high) / 2
         nstr = index(uprenam(middle), ' ') - 1
         if (ustr(1:nstr) .eq. uprenam(middle)(1:nstr)) then
            place = middle
            found = .true.
         elseif (ustr(1:nstr) .lt. uprenam(middle)(1:nstr)) then
            high = middle - 1
         else
            low = middle + 1
         endif
         go to 110
      endif
c
      if (found) then
         id = place
      else
         id = -1
      endif
c
      return
      end
      subroutine unittemp(ufrom, uto, tnew, xxok, wmsg, nmsg)
c
c update: 16:12 fri 4-mar-1994.
c purpose:
c - conversion between temperature scales
c
c notes:
c - the fact that we are called implies "ufrom", "uto" contains
c   only one string identifying the temperature (see "tscale" below)
c
c input arguments:
c - ufrom:     source temperature scale
c - uto:       target temperature scale
c
c output arguments:
c - tnew:      temperature value
c - xxok:      truth of "everything ok"
c - wmsg(1:nmsg) - error description, if xxok == .false.
c
c notes:
c   let tk denote the kelvin temperature;     tk = tk
c   let tc denote the celsius temperature;    tk = tc + 273.15
c   let tf denote the fahrenheit temperature; tk = (tf + 459.67) / 1.8
c   let tr denote the rankine temperature;    tk = tr / 1.8
c
c "273.15" "459.67" "1.8" are exact by definition
c
c all these functions are of the form:
c   tk = (tz + a0) / a1,
c   tz = a1 * tk  -  a0,      z == "kelvin" "celsius" "fahrenheit" "rankine"
c
c algorithm: change temperature first to kelvin(tk), then to the requested
c            scale(tz)
c;;
      real zero, one
      parameter (zero = 0.00e+00, one = 1.00e+00)
c
      character*( * ) ufrom, uto, wmsg
      real tnew
      integer nmsg
      logical xxok
c
      character*(23) tscale(4)
      real tk, tto, tfrom, rval, a0(4), a1(4)
      integer jj, jfrom, jto, ival
      integer f0, f1, t0, t1, flen, tlen
      logical found, xisrval, xisival
      integer xslen, nextbl, nextnb
      external xslen, nextbl, nextnb, xisrval, xisival
c
      data (tscale(jj), a0(jj), a1(jj), jj = 1, 4) /'.k.kelvin.', 
     &   0.00e+00, 1.00e+00, '.c.celsius.centigrade.', 273.15e+00, 
     &   1.00e+00, '.f.fahrenheit.', 459.67e+00, 1.80e+00, 
     &   '.r.rankine.', 0.00e+00, 1.80e+00/
c
      tnew = zero
      xxok = .true.
      nmsg = 0
      wmsg = ' '
c
c get a (possible) number
c
      f0 = 1
      if (xisrval(rval, ufrom, f0)) then
         found = .true.
      elseif (xisival(ival, ufrom, f0)) then
         rval = real(ival)
         found = .true.
      else
         found = .false.
      endif
      if ( .not. found) then
         rval = zero
      endif
      tfrom = rval
c
      flen = xslen(ufrom)
      f0 = nextnb(ufrom, flen, f0)
      f1 = nextbl(ufrom, flen, f0) - 1
c
      tlen = xslen(uto)
      t0 = nextnb(uto, tlen, 1)
      t1 = nextbl(uto, tlen, t0) - 1
c
      jto = 0
      jfrom = 0
      do jj = 1, 4
         if (index(tscale(jj), '.' // ufrom(f0:f1) // '.') .gt. 0) jfrom
     &      = jj
         if (index(tscale(jj), '.' // uto(t0:t1) // '.') .gt. 0) jto = 
     &      jj
      enddo
c
      if (jfrom .le. 0) then
         xxok = .false.
         wmsg = 'could not find temperature scale "' // ufrom(f0:f1) //
     &      '"'
         nmsg = xslen(wmsg)
         go to 110
      endif
      if (jto .le. 0) then
         xxok = .false.
         wmsg = 'could not find temperature scale "' // uto(t0:t1) // 
     &      '"'
         nmsg = xslen(wmsg)
         go to 110
      endif
c
      tk = (tfrom + a0(jfrom)) / a1(jfrom)      ! convert to kelvin     
      tto = a1(jto) * tk - a0(jto)      ! convert to requested scale
      tnew = tto
c
  110 continue
      return
      end
      subroutine uotty(xmsg, nmsg)
c
c update: 17:45 fri 4-mar-1994.
c output a message "xmsg" to the screen; Blank the line if overprinting.
c the string "xmsg" contains the carriage control info
c;;
      include 'xglobal.par'
c
      include 'idfiles.def'
c
      character*( * ) xmsg
      integer nmsg
c
      character*(stdlen) stty
      character*(1) cc1
      integer ntty, xslen, len_so_far, nn
      external xslen
      save len_so_far
      data len_so_far /0/
c
      if (nmsg .gt. 0) then
         ntty = nmsg
      else
         ntty = xslen(xmsg)
      endif
c
      if (ntty .gt. 0) then
         cc1 = xmsg(1:1)
         if ((cc1 .eq. '$') .or. (cc1 .eq. ' ') .or. (cc1 .eq. '+') .or.
     &      (cc1 .eq. '0') .or. (cc1 .eq. '1') .or. (cc1 .eq. null)) 
     &      then
            stty = xmsg(1:ntty)
         else
            stty = '+' // xmsg(1:ntty)
            ntty = 1 + ntty
         endif
      else
         stty = '+'
         ntty = 1
      endif
c
      nn = max(len_so_far, ntty, 1)
      write (stdout, '(a)') stty(1:nn)
      len_so_far = ntty
c
      return
      end
c UP2LO.spg  processed by SPAG 3.14A  at 14:47 on 26 Oct 1992
      subroutine up2lo(letter, nleter)
c
c update:   wed 14:12 2-oct-1991.
c purpose:  transliterate upper case to lower case;
c           stuff between quoted strings will be transliterated also.
c
c input variables:
c . letter  (character*(*)); string to be translit.
c . nletter (integer); number of letters to be translit.;
c           nletter .le. 0 ==> translit all characters;
c
c output variables:
c . letter  (character*(*)); transliterated string
c
c notes:
c . upper-case-a = ascii 065; upper-case-z = ascii 090
c . lower-case-a = ascii 097; lower-case-z = ascii 122
c
      integer nleter
      character*( * ) letter
c
      integer offset, jj, hold, ntotal, xslen
      external xslen
c
      if (nleter .ge. 0) then
         ntotal = nleter
      else
         ntotal = xslen(letter)
      endif
c
      offset = 97 - 65
      do jj = 1, ntotal
         hold = ichar(letter(jj:jj))
         if ((65 .le. hold) .and. (hold .le. 90)) letter(jj:jj) = 
     &      char(hold + offset)
      enddo
c
      return
      end
      subroutine upaths(dbpath, ndb, cdirpath, ncd, errfil, nerr)
c
c update: 16:00 tue 5-apr-1994.
c purpose:     determine:
c              . path to database
c              . path to current directory (for output files)
c              . full name of error Log file
c algorithm:
c . if the file "project.loc" exists in the current directory,
c   then it contains the path info
c . if the file does not exists, return the path of this executable
c
c output variables:
c . Dbpath     (character*(*)); path to data base
c . ndb        (integer); number of characters in "Dbpath";
c                         ndb == 0 ==> no path
c . cdirpath   (character*(*)); path to current directory
c . ncd        (integer); number of characters in "cdirpath";
c                         ncd == 0 ==> no path
c . Errfil     (character*(*)); fully qualified error Log file
c . nerr       (integer); number of characters in "Errfil";
c                         nerr == 0 ==> no name
c
c modules called:
c . subroutine xmypath
c . integer function Xfopen
c . subroutine Xfclose
c
c sample file "project.loc"
c ! <-- column 1                 ! this line is NOT part of the file
c path-to-current-directory
c path-to-database
c path+name-of-error-Log-file
c ! end-of-file                  ! this line is NOT part of the file
c;;
      include 'xglobal.par'
c
      character*( * ) dbpath, cdirpath, errfil
      integer ndb, ncd, nerr
c
      character*( * ) locfile
      parameter (locfile = 'project.loc')
c
      logical havefile, found
      integer uin, ios, xfopen, xslen
      external xfopen, xfclose, xslen
c
 9110 format (a)
c
c open and read "project.loc"
c . if cannot open, find path of this executable
c . else read the path in "project.loc" file
c . protect against reading past end-of-file, should the file contain less
c   than three lines
c
      cdirpath = ' '
      dbpath = ' '
      errfil = ' '
      ndb = 0
      ncd = 0
      nerr = 0
c
      inquire (file=locfile, exist=havefile)
      if (havefile) then
         if (xfopen(uin, locfile, zioread) .ne. zioerror) then
            read (uin, 9110, iostat=ios) cdirpath
            if (ios .eq. 0) then
               read (uin, 9110, iostat=ios) dbpath
               if (ios .eq. 0) then
                  read (uin, 9110, iostat=ios) errfil
               endif
            endif
            ndb = xslen(dbpath)
            ncd = xslen(cdirpath)
            nerr = xslen(errfil)
            call xfclose(uin)
         else
            call xmypath(found, dbpath, ndb)
         endif
      else
         call xmypath(found, dbpath, ndb)
      endif
c
      return
      end
      subroutine usrunits()
c
c update: 17:32 fri 4-mar-1994.
c
c this subroutine converts all program data to user original units;
c the subroutine modifies the arrays ==> output all info *before*
c the conversion; no error checking is necessary.
c
c is a fish is dead, its info will be zero
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'habitat.par'
      include 'fish.par'
      include 'plots.par'
      include 'phylum.par'
      include 'numbers.par'
      include 'simul.par'
      include 'physio.par'
      include 'fluxes.def'
      include 'time.def'
      include 'habitat.def'
      include 'work.def'
      include 'diet.def'
      include 'obsdata.def'
      include 'units.def'
      include 'globpar.def'
      include 'fish.def'
c
c local variables
c
      integer jchem, jobs, jage, jspecies, jrange, nn
      real ppm2cf, t_iconv, wt_iconv, cw_iconv
c
      logical converted_once
      save converted_once
      data converted_once /.false./     ! initialize.    
c
      if ( .not. converted_once) then
         converted_once = .true.
c
         t_iconv = one / t_conv
         wt_iconv = one / wt_conv
         cw_iconv = one / cw_conv
c
         simul_beg = simul_beg * t_iconv
         simul_end = simul_end * t_iconv
c
         if (twfunc .eq. tsin) then
            twpar(3) = twpar(3) / t_iconv
         endif
c
         do jspecies = 1, gnspecies
            if (xdiet) then
               do jrange = 1, range_numof(jspecies)
                  if (range_type(jspecies) .eq. tage) then
c                 ! continue
                  elseif (range_type(jspecies) .eq. tweight) then
                     range_lowb(jrange, jspecies) = 
     &                  range_lowb(jrange, jspecies) * wt_iconv
                     range_uppb(jrange, jspecies) = 
     &                  range_uppb(jrange, jspecies) * wt_iconv
                  elseif (range_type(jspecies) .eq. tlength) then
ccc                  Range_lowb(jrange,jspecies) = Range_lowb(jrange,jspecies) *
ccc     &                                          wt_iconv
ccc                  Range_uppb(jrange,jspecies) = Range_uppb(jrange,jspecies) *
ccc     &                                          wt_iconv
                  endif
               enddo
            endif
c
            do jage = 1, xmaximum_age(jspecies)
               vv_iniwt(jage, jspecies) = vv_iniwt(jage, jspecies) * 
     &            wt_iconv
               qq_wt(1, jage, jspecies) = qq_wt(1, jage, jspecies) * 
     &            wt_iconv
               if ((vv_plfunc(jage, jspecies) .eq. tallometric) .or. (
     &            vv_plfunc(jage, jspecies) .eq. tdatabase) .or. (
     &            vv_plfunc(jage, jspecies) .eq. tfishpar)) then
                  vv_pval(vpl1, jage, jspecies) = 
     &               vv_pval(vpl1, jage, jspecies) / wt_iconv ** 
     &               vv_pval(vpl2, jage, jspecies)
               elseif (vv_plfunc(jage, jspecies) .eq. tlinear) then
                  vv_pval(vpl2, jage, jspecies) = 
     &               vv_pval(vpl2, jage, jspecies) / wt_iconv
               endif
            enddo
c
            do jobs = 1, nobs(jspecies)
               wobs(jobs, jspecies) = wobs(jobs, jspecies) * wt_iconv
               tobs(jobs, jspecies) = tobs(jobs, jspecies) * t_iconv
            enddo
         enddo
c
         do jchem = 1, gnchem
c
c notice the order: Cwpar(1,*) should be accessed *before* it is modified
c to its previous value.
c
            if (cfunits(1:3) .ne. 'bcf') then
               ppm2cf = one / cf_conv
            else
               ppm2cf = one / cwpar(1, jchem)
            endif
c
            if (cwfunc(jchem) .eq. tconstant) then
               cwpar(1, jchem) = cwpar(1, jchem) * cw_iconv
            elseif (cwfunc(jchem) .eq. tsin) then
               cwpar(1, jchem) = cwpar(1, jchem) * cw_iconv
               cwpar(2, jchem) = cwpar(2, jchem) * cw_iconv
               cwpar(3, jchem) = cwpar(3, jchem) / t_iconv
            elseif (cwfunc(jchem) .eq. texp) then
               cwpar(1, jchem) = cwpar(1, jchem) * cw_iconv
               cwpar(2, jchem) = cwpar(2, jchem) * cw_iconv
               cwpar(3, jchem) = cwpar(3, jchem) / t_iconv
            endif
c
            do jspecies = 1, gnspecies
               do jage = 1, xmaximum_age(jspecies)
                  vv_inicf(jchem, jage, jspecies) = 
     &               vv_inicf(jchem, jage, jspecies) * ppm2cf
                  nn = max(1, qq_nxy(jage, jspecies))
                  qq_cfcal(nn, jchem, jage, jspecies) = 
     &               qq_cfcal(nn, jchem, jage, jspecies) * ppm2cf
               enddo
            enddo
c
            if (food_chem_func .eq. tconstant) then
               food_chem_conc(jchem) = food_chem_conc(jchem) * ppm2cf
            endif
c
            if (cfish_chem_func .eq. tconstant) then
               cfish_chem_conc(jchem) = cfish_chem_conc(jchem) * ppm2cf
            endif
c
            if (benthos_chem_func .eq. tconstant) then
               benthos_chem_conc(jchem) = benthos_chem_conc(jchem) * 
     &            ppm2cf
            endif
c
            if (plankton_chem_func .eq. tconstant) then
               plankton_chem_conc(jchem) = plankton_chem_conc(jchem) * 
     &            ppm2cf
            endif
c
            do jspecies = 1, gnspecies
               do jobs = 1, nobs(jspecies)
                  cfobs(jobs, jchem, jspecies) = 
     &               cfobs(jobs, jchem, jspecies) * ppm2cf
               enddo
            enddo
         enddo
      endif
c
  110 continue
      return
      end
      subroutine ustripd(oldstr, lenold, newstr, lennew)
c
c update: 16:12 fri 4-mar-1994.
c strip oldstr of the leading and trailing delimiters,
c    if they exist.  if the same non-alphanumeric
c    character delimits oldstr, that character will be
c    assumed to be a quote character.
c
c examples:
c    oldstr   newstr
c    abc      abc
c    .abc.    abc
c    .abc     .abc  ('.' not at the end ==> not a delimiter)
c    "abc.    "abc. (since the enclosing non-alphanumerics are not equal,
c                   they are not considered quote characters)
c    "a""b'c" a"b'c
c    'ab'c'   ab'c  (bug ?!; we will allow it for the time being)
c
c note:
c    - soft delimiters are not considered delimiters by this procedure
c    - alpha-numerics  are not considered delimiters by this procedure
c    - things like "call Ustripd(oldstr, lenold, oldstr, lenold)" are legal
c;;
      include 'xglobal.par'
      include 'chars.def'
c
      character*( * ) oldstr, newstr
      integer lenold, lennew
c
      character*1 qchar
      integer ja, jb, xslen
      external xslen
      include 'chars.sfn'
c
      ja = 1
      jb = xslen(oldstr)
      qchar = oldstr(ja:ja)
      if (ja .le. jb) then
         if (alfanu(qchar)) then
            newstr = oldstr
            lennew = jb
         else
            if (oldstr(ja:ja) .eq. oldstr(jb:jb)) then
               if (ja + 1 .le. jb - 1) then
                  qchar = oldstr(ja:ja)
                  newstr = oldstr(ja + 1:jb - 1)
                  lennew = (jb - 1) - (ja + 1) + 1
                  call ustripd0(qchar, newstr, lennew)
               else
                  newstr = ' '
                  lennew = 0
               endif
            else
               newstr = oldstr
               lennew = jb
            endif
         endif
      else
         newstr = ' '
         lennew = 0
      endif
c
      return
      end
      subroutine ustripd0(qchar, newstr, lennew)
c
c update: mon 08:57 28-jan-1991
c unquote quotes in "newstr(1:)" (quote character stored in "qchar")
c
      character*( * ) qchar, newstr
      integer lennew
c
      integer jj, nnew, nrun
c
      nnew = 0
      nrun = 0
c
      do jj = 1, lennew
         if (newstr(jj:jj) .ne. qchar) then
            nrun = 0
            nnew = nnew + 1
            newstr(nnew:nnew) = newstr(jj:jj)
         else
            if (nrun .eq. 0) then
               nrun = 1
               nnew = nnew + 1
               newstr(nnew:nnew) = newstr(jj:jj)
            else
               nrun = 0
            endif
         endif
      enddo
c
      if (nnew .lt. len(newstr)) newstr(nnew + 1:) = ' '
      lennew = nnew
c
      return
      end
      subroutine uvalues(card, ncard, jfirst, vals, nvals, npos, nerror)
c
c update: 16:12 fri 4-mar-1994.
c get numbers from a line
c
c input:
c    card   - character*(*) array with the number(s) or
c             commands to be decoded.
c    ncard  - total number of characters in *card*.
c    jfirst - start decoding at *card(jfirst)*.
c
c output:
c    nvals  - number of decoded numbers
c    vals   - array of decoded number (vals(jj), jj = 1, nvals)
c    npos   - .eq. 0 ==> all is well (nerror=0 as well).
c           - .ne. 0 ==> strange character at *card(npos)*
c    nerror - error message number.
c                0: no error
c                1: error
c    - none for the time being.
c
c some internal variables:
c    wscoma - last token was a hard delimiter.
c             .true.  last token was a hard delimiter,
c             .false. last token was something else.
c             if the last token was a hard delimiter and
c             this token is also a hard delimiter that means
c             that some default number must be used.
c    "token"- in this context a token is either a (Real)
c             number (with digits, decimal point and exponent),
c             or a hard delimiter (comma or semicolon), or
c             some some other unrecognizable string.
c;;
      integer ncard, jfirst, nvals, npos, nerror
      character*( * ) card
      real vals( * )
c
      integer jcol, pass, ival, eolcom, nend, npk
      logical done, wscoma, xisrval, xisival, havenum
      real noval, r1mach, zeta
      external r1mach, xisrval, xisival, eolcom
c
      jcol = jfirst
      pass = 0
      npos = 0
      nvals = 0
      nerror = 0
      noval = r1mach(6)
      wscoma = .false.
c
c stop at "!"
c
      npk = eolcom(card, ncard, jcol)
      if (npk .gt. 0) then
         nend = npk - 1
      else
         nend = ncard
      endif
c
  110 continue
      done = ((jcol .gt. nend) .or. (nerror .ne. 0))
      if ( .not. done) then
         if (xisrval(zeta, card, jcol)) then
            havenum = .true.
         elseif (xisival(ival, card, jcol)) then
            havenum = .true.
            zeta = real(ival)
         else
            havenum = .false.
         endif
         pass = pass + 1
         if (havenum) then
            nvals = nvals + 1
            vals(nvals) = zeta
            wscoma = .false.
         elseif (card(jcol:jcol) .eq. ',') then
            if ((wscoma) .or. (pass .eq. 1)) then
               nvals = nvals + 1
               vals(nvals) = noval
            endif
            wscoma = .true.
            jcol = jcol + 1
         else
            nerror = 1
            npos = jcol
         endif
         go to 110
      endif
c
      if (wscoma .and. (nerror .eq. 0)) then
         nvals = nvals + 1
         vals(nvals) = noval
      endif
c
      return
      end
      subroutine uxtiming(xlabel, jflag)
c
c update: 16:00 tue 5-apr-1994.
c dump time stats to a file; nested requests ok
c
c jflag = 0 :: output xlabel
c jflag = 1 :: start timer
c jflag = 2 :: end timer, report delta_t
c jflag = 3 :: flush all pending requests
c
c example
c  call Uxtiming('total simul', 1)    ! begin total simulation time
c  call Uxtiming('processs 1',  1)    ! time process 1
c  call Uxtiming('processs 1a', 1)    ! time process 1a
c  call Uxtiming('processs 1a', 2)    ! process 1a finished
c  call Uxtiming('processs 1',  2)    ! process 1 finished
c  call Uxtiming('total simul', 2)    ! simulation finished
c
c subroutine time (qtime)
c . qtime: (character*11) returns the current system time-of-day HH:MM:SS.hh
c   (hours, minutes, seconds, hundredths of a second)
c subroutine timer (iticks)
c . iticks: (integer*4) the count of number of seconds elapsed since the
c   beginning of an implementation specific starting point
c;;
      include 'xglobal.par'
      include 'idfiles.def'
c
      character*( * ) xlabel
      integer jflag
c
      integer xmaxlev
      parameter (xmaxlev = 30)
c
      character*(stdlen) zdate, xline
      integer xfopen, xslen, xnl, kp1, kp2
      integer nnn, ios, idelta, ndate, otick
      integer ihun, ohun, isec, osec, omin
      logical qflush
      external xslen, xfopen
c
      integer qout, nticks(xmaxlev), nlev
      logical qopened, qfirst
c
      save qopened, qfirst, qout, nlev, nticks, zdate, ndate
c
      data qopened /.false./
      data qfirst /.true./
      data nlev /0/
c
c
      if (qfirst) then
         call getdate(zdate, ndate)
         qfirst = .false.
      endif
c
c jflag == 0, 2, 3 produce output: make sure file is open
c
      if ((jflag .eq. 0) .or. (jflag .eq. 2) .or. (jflag .eq. 3)) then
         if ( .not. qopened) then
            qopened = .true.
            ios = xfopen(qout, 'fstats.sss', zioappend)
            write (qout, 9110) zdate(1:ndate)
            write (qout, 9120)
         endif
      endif
c
      if (jflag .eq. 0) then
         nnn = max(xslen(xlabel), 1)
         kp2 = max(xslen(infil), 1)
         write (qout, 9150) infil(1:kp2), xlabel(1:nnn)
      elseif (jflag .eq. 1) then
         nlev = nlev + 1
         call timer(nticks(nlev))
      elseif ((jflag .eq. 2) .or. (jflag .eq. 3)) then
         if (nlev .le. 0) then
            if (jflag .eq. 3) then
               continue
            else
               nnn = xslen(xlabel)
               kp2 = xslen(infil)
               write (qout, 9140) infil(1:kp2), xlabel(1:nnn)
            endif
            go to 120
         endif
         qflush = (jflag .eq. 3)
c
  110    continue       ! loop until ...  
         call timer(otick)
         idelta = otick - nticks(nlev)
         ihun = idelta
         isec = ihun / 100
         ohun = mod(ihun, 100)
         osec = mod(isec, 60)
         omin = isec / 60
         nnn = xslen(xlabel)
         kp1 = 1
ccc            kp1 = 2 * nlev  -  1
         xnl = nnn - 1 + kp1
         xline(1:kp1) = ' '
         xline(kp1:xnl) = xlabel(1:nnn)
         kp2 = xslen(infil)
         if (kp2 .gt. 0) then
            write (qout, 9130) infil(1:kp2), xline(1:xnl), omin, osec, 
     &         ohun
         else
            write (qout, 9130) 'NONAME', xline(1:xnl), omin, osec, ohun
         endif
         nlev = nlev - 1
         if ((nlev .ge. 1) .and. qflush) go to 110      ! loop until ...  
      endif
 9110 format (///,1x,'xxxxxxxxxxxxxxxxxxxx new run: ',a)
 9120 format (1x,'Filename',t31,'Module Label',t73,'MM:SS.hh',/,1x,
     &   '--------',t31,'------------',t73,'--------')
 9130 format (1x,:,a,t31,a,t73,i2.2,':',i2.2,'.',i2.2)
 9140 format (1x,:,a,t31,'?? unbalanced label "',a,'"')
 9150 format (1x,:,a,t31,a)
c
  120 continue
      return
      end
      subroutine vectsum(n, x, sum_type, sx, nx)
c
c update: wed 15:53 13-mar-1991.
c
c this subroutine accumulates the sums needed to calculate arithmetic
c or geometric means of the the vector x()
c
c input arguments (modified by Vectsum):
c -nx(i) = cumulative number of records having data for x(i)
c -sx(i) = cumulative sum of Log10(x(i))
c
c input arguments (not modified by Vectsum):
c -n       = number of sums to be calculated
c -x(i)    = an Fgets data base parameter
c -sum_type(i) = type of sum
c
c declarations of subroutine's formal parameters
c
      include 'noval.par'
c
      integer n, nx( * )
      real x( * ), sx( * )
      character*( * ) sum_type( * )
c
      integer ii
      include 'vdefined.def'
      include 'vdefined.sfn'
c
      do ii = 1, n
         if (vdefined(x(ii))) then
            nx(ii) = nx(ii) + 1
            if (sum_type(ii) .eq. 'g') then
               sx(ii) = sx(ii) + log10(x(ii))
            elseif (sum_type(ii) .eq. 'a') then
               sx(ii) = sx(ii) + x(ii)
            endif
         endif
      enddo
c
      return
      end
      subroutine webcp(kpredator, kage, zwt, zlen, nerror)
c
c update: 17:32 fri 4-mar-1994.
c
c determine the concentration in the prey for the k-th predator
c
c by species: determine if prey is "closest" (in length) to the
c predator requirements:
c     let adelta[jj] := Abs (len_prey(jj) - len_target)
c         for all jj in {prey year class}
c     the "closest" prey is an Index such that for all
c     jj in {prey year class}
c         # adelta[closest] .le. adelta[jj]   ! i.e., the smallest delta
c         # closest .le. jj                   ! i.e., the smallest Index
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'errors.par'
      include 'fish.par'
      include 'numbers.par'
      include 'ode.par'
      include 'physio.par'
      include 'simul.par'
c
      include 'diet.def'
      include 'expos.def'
      include 'fish.def'
      include 'fluxes.def'
      include 'globpar.def'
      include 'lab.def'
      include 'ode.def'
      include 'odevar.def'
c
c declaration for arguments
c
      integer kpredator, nerror, kage
      real zwt, zlen
c
      integer nprey, jchem, agep
      integer closest_prey, jage, jprey, krange, jrange
      real len_target, min_delta, adelta, tupp, tlow, rage
      logical wfound
c
      nerror = tnoerror
      nprey = 0
      agep = qq_fish_age(kage, kpredator)
c
      do jchem = 1, gnchem
         qq_cp(jchem, kage, kpredator) = zero
      enddo
c
c determine the diet Index for this predator;
c note that the age of this predator is Qq_fish_age (kage,kpredator)
c
      krange = 0
      rage = real(qq_fish_age(kage, kpredator))
      do jrange = 1, range_numof(kpredator)
         tupp = range_uppb(jrange, kpredator) * (one + mach_eps)
         tlow = range_lowb(jrange, kpredator) * (one - mach_eps)
         if (range_type(kpredator) .eq. tage) then
            wfound = ((tlow .le. rage) .and. (rage .le. tupp))
         elseif (range_type(kpredator) .eq. tweight) then
            wfound = ((tlow .le. zwt) .and. (zwt .le. tupp))
         elseif (range_type(kpredator) .eq. tlength) then
            wfound = ((tlow .le. zlen) .and. (zlen .le. tupp))
         endif
         if (wfound) then
            krange = jrange
         endif
      enddo
c
c the last (weight | length) range will be automatically extended;
c age range is always found;
c
      if (krange .le. 0) then
         krange = range_numof(kpredator)
ccc         nerror = terr_no_predator_range
ccc         go to 120
      endif
c
c predator desires.
c
      len_target = vv_pval(vpred1, agep, kpredator) + 
     &   vv_pval(vpred2, agep, kpredator) * zlen
c
      do jprey = 1, gnspecies   ! for each "prey" species
c
c if this species is not part of the diet, skip it;
c
         if (fdiet(jprey, krange, kpredator) .gt. zero) then
c
            min_delta = 1.00e+35        ! arbitrary large number
            closest_prey = 0    ! initialize         
            do jage = 1, xmaximum_age(jprey)    ! for each year_class
c
c determine closest prey so far;
c
               if (qq_fish_alive(jage, jprey)) then
                  adelta = abs(qq_lenfish(jage, jprey) - len_target)
                  if (adelta .lt. min_delta) then
                     closest_prey = jage
                     min_delta = adelta
                  endif
               endif
            enddo
c
            if (closest_prey .le. 0) then
               nerror = terr_species_extinct
               go to 120
            endif
c
c accumulate burdens, for the time being
c
            nprey = nprey + 1
            do jchem = 1, gnchem
               qq_cp(jchem, kage, kpredator) = 
     &            qq_cp(jchem, kage, kpredator) + 
     &            qq_cfj(jchem, closest_prey, jprey) * 
     &            fdiet(jprey, krange, kpredator)
            enddo
         endif
  110    continue
      enddo
c
c plankton
c
      if (fdiet(pplankton, krange, kpredator) .gt. zero) then
         nprey = nprey + 1
         do jchem = 1, gnchem
            qq_cp(jchem, kage, kpredator) = 
     &         qq_cp(jchem, kage, kpredator) + xchem_in_plankton(jchem)
     &         * fdiet(pplankton, krange, kpredator)
         enddo
      endif
c
c benthos
c
      if (fdiet(pbenthos, krange, kpredator) .gt. zero) then
         nprey = nprey + 1
         do jchem = 1, gnchem
            qq_cp(jchem, kage, kpredator) = 
     &         qq_cp(jchem, kage, kpredator) + xchem_in_benthos(jchem) *
     &         fdiet(pbenthos, krange, kpredator)
         enddo
      endif
c
c cfish
c
      if (fdiet(pcfish, krange, kpredator) .gt. zero) then
         nprey = nprey + 1
         do jchem = 1, gnchem
            qq_cp(jchem, kage, kpredator) = 
     &         qq_cp(jchem, kage, kpredator) + xchem_in_cfish(jchem) * 
     &         fdiet(pcfish, krange, kpredator)
         enddo
      endif
c
      if (nprey .le. 0) then
         nerror = terr_predator_starves
         go to 120
      endif
c
  120 continue
      return
      end
      subroutine webdrv(nerror)
c
c update: 11:46 fri 9-sep-1994.
c set up and run food web model;
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'errors.par'
      include 'fish.par'
      include 'numbers.par'
      include 'strings.par'
      include 'idfiles.def'
      include 'fish.def'
      include 'globpar.def'
      include 'time.def'
      include 'lab.def'
      include 'units.def'
      include 'heap.def'
      include 'options.def'
c
      integer nerror
c
      integer jage, jspecies, pq0, nq0, xslen
      real tfin, tbeg
      logical trne, xxok
      external trne, xslen
c
      pq0 = 0
      call heapush(pq0)
c
      nerror = tnoerror
      call initchem(simul_beg, simul_end, hstep)
      call uotty('+## food web setup', -1)
      call webset()     ! set up food web              
      call uotty('+## food web setup ...', -1)
c
c *********************** begin simulation *****************************
c integrate food web model;
c
      tinc = one
      tbeg = simul_beg
      tfin = min(tbeg + one_year, simul_end)
      time_beg = tbeg
      time_end = tfin
      call envinit(xxok)
      call envget(tbeg)
c
c run in periods of one year until Simul_end is reached;
c graduate the cohorts;
c re-stock year class 1;
c output yearly results;
c
      call out0()       ! output time independent stuff         
      nyears = 0
      tinc = one
c
  110 continue
      call initchem(time_beg, time_end, hstep)
      call ksave1(zero, tbeg, .true.)
      do jspecies = 1, gnspecies
         do jage = 1, xmaximum_age(jspecies)
            qq_new_day(jage, jspecies) = tbeg
            call ksave(jage, jspecies, zero, tbeg, .true.)
         enddo
      enddo
c
 9110 format ('+## food web, year ',i3)
      nyears = nyears + 1
      write (qhs(pq0), 9110) nyears
      call compress(qhs(pq0), -1, nq0)
      call uotty(qhs(pq0), nq0)
c
      if (xtiming) then
         write (qhs(pq0), '(a,i2)') 'foodweb simulation, year', nyears
         nq0 = xslen(qhs(pq0))
         call uxtiming(qhs(pq0)(1:nq0), 1)
      endif
      call webstep(tbeg, tfin, nerror)
      if (xtiming) then
         call uxtiming(qhs(pq0)(1:nq0), 2)
      endif
c
      if (nerror .eq. tnoerror) then
         if (trne(simul_end, tfin)) then
            call out1()
            call webupdat()     ! update every year except the last.         
            tbeg = tfin
            tfin = min(tbeg + one_year, simul_end)
            time_beg = tbeg
            time_end = tfin
            go to 110
         endif
      endif
c
  120 continue
      call heapop(pq0)
      call kerrmsg(nerror)
      call out1()
      call out2()
c
      return
      end
      subroutine webode(kdum1, kdum2, ztime, nerror)
c
c update: 17:32 fri 4-mar-1994.
c
c we are integrating all fish;
c procedure:
c 1. determine derivatives for growth model;
c 2. update Qq_cp (concentration of chemical in fish) for each fish;
c    remember that all fish are potentially predators;
c 3. determine derivatives of uptake model;
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'errors.par'
      include 'fish.par'
      include 'physio.par'
      include 'numbers.par'
      include 'fish.def'
      include 'globpar.def'
      include 'odevar.def'
      include 'fluxes.def'
      include 'lab.def'
      include 'options.def'
      include 'expos.def'
c
c declaration for arguments
c
      integer kdum1, kdum2, nerror
      real ztime
c
      integer jage, jspecies, jchem, agep
      logical notdawn
c
      nerror = tnoerror
      call envget(ztime)        ! determine exposure conditions;
c
      do jspecies = 1, gnspecies
         do jage = 1, xmaximum_age(jspecies)
c
c if the fish is dead look no further: maintain status quo;
c
            if ( .not. qq_fish_alive(jage, jspecies)) then      ! skip dead fish
               qq_dwdt(1, jage, jspecies) = zero
               qq_dwdt(2, jage, jspecies) = zero
               do jchem = 1, gnchem
                  qq_dbfdt(jchem, jage, jspecies) = zero
               enddo
               go to 110        ! "break"   
            endif
c
c update morphological/physiological parameters at "dawn" ;
c these will stay active (read: constant) for this day unless
c "Xupdate_continuously == true" ;
c
            agep = qq_fish_age(jage, jspecies)
            notdawn = (ztime .lt. qq_new_day(jage, jspecies))
            if (notdawn) then
               if (xupdate_continuously) then
                  call kfupdate(jage, jspecies, 
     &               qq_wt(1, jage, jspecies), xcelsius, 
     &               xplankton_standing_stock)
               endif
            else
               qq_new_day(jage, jspecies) = qq_new_day(jage, jspecies) +
     &            tinc
               call kfupdate(jage, jspecies, qq_wt(1, jage, jspecies), 
     &            xcelsius, xplankton_standing_stock)
            endif
c
c grow the fish
c
            call kdwdt(ztime, vv_growth_model(agep, jspecies), 
     &         vv_functional_response(agep, jspecies), 
     &         qq_wgamma(jage, jspecies), qq_phi(jage, jspecies), 
     &         qq_gmax(jage, jspecies), qq_alpha1(jage, jspecies), 
     &         qq_alpha2(jage, jspecies), qq_epsl1(jage, jspecies), 
     &         qq_epsl2(jage, jspecies), qq_mu(jage, jspecies), sigma, 
     &         nh3n, cn, vv_pval(vassxeff, agep, jspecies), 
     &         qq_wt(1, jage, jspecies), qq_dwdt(1, jage, jspecies), 
     &         qq_wingest(jage, jspecies), qq_wassim(jage, jspecies), 
     &         qq_wegest(jage, jspecies), qq_wrespir(jage, jspecies), 
     &         qq_wsda(jage, jspecies), qq_wexcret(jage, jspecies))
c
c determine concentration of chemical in prey (Qq_cp) for each predator;
c if problems (only problem at this time is no prey), kill this predator;
c
            call webcp(jspecies, jage, qq_wt(1, jage, jspecies), 
     &         qq_lenfish(jage, jspecies), nerror)
            if (nerror .ne. tnoerror) then
               qq_death_day(jage, jspecies) = ztime
               qq_fish_alive(jage, jspecies) = .false.
               go to 110
            endif
c
c determine burden;
c
            call kdbdtgf(gnchem, qq_sgill(jage, jspecies), 
     &         qq_kw(1, jage, jspecies), xchem_in_water, 
     &         qq_kf(1, jage, jspecies), qq_pa(jage, jspecies), koc, 
     &         qq_cp(1, jage, jspecies), qq_wingest(jage, jspecies), 
     &         qq_wegest(jage, jspecies), qq_wt(1, jage, jspecies), 
     &         qq_bf(1, jage, jspecies), qq_dbfdt(1, jage, jspecies), 
     &         qq_tjgilup(1, jage, jspecies), 
     &         qq_tjgilex(1, jage, jspecies), 
     &         qq_tjgutup(1, jage, jspecies), 
     &         qq_tjgutex(1, jage, jspecies))
c
  110       continue    ! "break"               
         enddo
      enddo
c
c all errors where taken care of
c
      nerror = tnoerror
      return
      end
      subroutine webread(uu, arylen, ncols, idcols, zobs, nobs, zcal, 
     &   ncal, wvals, zp0, zp1)
c
c update: 11:46 fri 9-sep-1994.
c
c input:
c . uu            (integer), logical unit number of exposure file
c . arylen        (integer), dimension of arrays
c . ncols         (integer), number of rows to read
c . idcols(1:ncols)  columns to read
c . wvals(*)      temporary storage
c . zp0(*),zp1(*) temporary storage
c
c output    ! assume xcol == 1
c . Nobs    number of points read
c . zobs(1:Nobs,xcol), zobs(1:Nobs, xcol+1:?) data from file, such that
c     zobs(1,xcol) .le. Simul_beg .lt. Simul_beg+One_year .le. zobs(Nobs,xcol)
c
c . ncal    number of equally-spaced generated points
c . zcal(1:ncal,xcol), zcal(1:ncal, xcol+1:?)
c
c linear interpolation will be used as needed to generate the new y-values.
c
c the time span of the data will be one year or end of file, whichever comes
c first.  the data (as read) will be stored in "zobs". equally spaced points
c will be generated and stored in "zcal".  the data in array "zcal" will be
c used later for fourier transforms.
c
c again: this module reads either water temperature, plankton standing stock,
c        or both.
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'strings.par'
      include 'idfiles.def'
      include 'time.def'
      include 'units.def'
      include 'options.def'
      include 'heap.def'
c
      integer uu, arylen, ncols, idcols( * ), nobs, ncal
      real zobs(arylen, * ), zcal(arylen, * ), wvals( * ), zp0( * ), 
     &   zp1( * )
c
      logical xxok, bmin, bmax, bset, bfound, trne
      real zbeg, zend, vtime, dinc, tt
      integer pq0, nq0, npk, eolcom, xslen, nrr, xcol, ycol, ios
      integer nvals, npos, nerror, rrmax, jj, nff, ibeg
      external eolcom, xslen, trne
c
c gather y-values for one year or end-of-file, whichever comes first.
c start with nrr == 1, we want to leave a hole in the first position, to be used
c for insertion later, if needed.
c
c on output from the reading loop:  ! assume "rx(j) == zobs(j,xcol)"
c . if the file does not start with "Simul_beg", rx(1) contains the largest
c   value in the file .le. Simul_beg; if rx(1) was set, bmin == .true.
c . rx(nrr+1) contains one extra point, presumably .gt. Simul_beg+One_year;
c   if rx(nrr+1) was set, bmax == .true.
c
      pq0 = 0
      call heapush(pq0)
c
      call envinit(xxok)
      zbeg = simul_beg
      zend = simul_beg + one_year
      nrr = 1
      bmin = .false.
      bmax = .false.
      rrmax = arylen - 5        ! leave several trailing holes      
      xcol = 1  ! x-column                          
c
      if (xtiming) then
         call uxtiming('foodweb readfile', 1)
      endif
c
  110 continue
      read (uu, '(a)', end=120, iostat=ios) qhs(pq0)
      nq0 = xslen(qhs(pq0))
      npk = eolcom(qhs(pq0), nq0, 1)
      if (npk .gt. 0) then
         qhs(pq0)(npk:nq0) = ' '
         nq0 = xslen(qhs(pq0)(1:npk))
         if (nq0 .le. 0) go to 110
      endif
      nq0 = xslen(qhs(pq0))
      call uvalues(qhs(pq0), nq0, 1, wvals, nvals, npos, nerror)
      if (nvals .le. 1) then
         xxok = .false.
         inquire (unit=uu, name=qhs(pq0))
         nff = xslen(qhs(pq0))
         write (stdout, 9110) qhs(pq0)(1:nff), nvals
         write (jerr, 9110) qhs(pq0)(1:nff), nvals
         errused = .true.
         go to 140
      endif
      vtime = t_conv * wvals(1)
      if ((zbeg .le. vtime) .and. (vtime .le. zend)) then
         if (nrr .ge. rrmax) then
            xxok = .false.
            write (stdout, 9120) arylen
            write (jerr, 9120) arylen
            errused = .true.
            go to 140
         endif
         nrr = nrr + 1
         zobs(nrr, xcol) = vtime
         do ycol = 1, ncols
            zobs(nrr, ycol + 1) = wvals(idcols(ycol))
         enddo
         go to 110
      elseif (vtime .le. zbeg) then
         zobs(1, xcol) = vtime
         do ycol = 1, ncols
            zobs(1, ycol + 1) = wvals(idcols(ycol))
         enddo
         bmin = .true.
         go to 110
      elseif (vtime .ge. zend) then
         zobs(nrr + 1, xcol) = vtime
         do ycol = 1, ncols
            zobs(nrr + 1, ycol + 1) = wvals(idcols(ycol))
         enddo
         bmax = .true.
      endif
c
c generate equally spaced-data at one day intervals;
c make sure (for table lookup):
c . zobs(1,xcol) .le. Simul_beg .lt. Simul_beg+One_year .le. zobs(nrr,xcol)
c
c remember the first point was stored in zobs(2,xcol)
c
  120 continue
      if (xtiming) then
         call uxtiming('foodweb readfile', 2)
      endif
c
      if (zobs(2, xcol) .gt. zbeg) then
         if (bmin) then
            continue    ! zobs(1,xcol) already set    
         else
            zobs(1, xcol) = zbeg
            do ycol = 1, ncols
               zobs(1, ycol + 1) = zobs(2, ycol + 1)
            enddo
         endif
      else
         zobs(1, xcol) = zobs(2, xcol)
         do ycol = 1, ncols
            zobs(1, ycol + 1) = zobs(2, ycol + 1)
         enddo
      endif
c
      if (zobs(nrr, xcol) .lt. zend) then
         if (bmax) then
            nrr = nrr + 1
            continue    ! zobs(new nrr,xcol) already set
         else
            nrr = nrr + 1
            zobs(nrr, xcol) = zend
            do ycol = 1, ncols
               zobs(nrr, ycol + 1) = zobs(nrr - 1, ycol + 1)
            enddo
         endif
      endif
      nobs = nrr
c
      zbeg = max(zobs(1, xcol), zbeg)
      zend = min(zobs(nrr, xcol), zend)
      ncal = 1 + nint(one_year)
      dinc = (zend - zbeg) / real(ncal - 1)
      if (ncal .gt. arylen) then
         xxok = .false.
         write (stdout, 9130) arylen, ncal
         write (jerr, 9130) arylen, ncal
         errused = .true.
         go to 140
      endif
c
c use linear interpolation to generate values at the new grid: y = p0 + p1*t ;
c be carefull about double points;
c because of the previous code, we know that all generated points (tt) are
c located in the table -- there is no need to chech for "ibeg" out of bounds;
c
c alpha + beta*(t-a) == p0 + p1*t
c
      bset = .false.
      ibeg = 1
      do jj = 1, ncal
         tt = zbeg + real(jj - 1) * dinc
         zcal(jj, xcol) = tt
c
c loop until interval found; ignore double points;
c
  130    continue
         bfound = ((zobs(ibeg, xcol) .le. tt) .and. (tt .le. 
     &      zobs(ibeg + 1, xcol))) .and. (
     &      trne(zobs(ibeg, xcol), zobs(ibeg + 1, xcol)))
         if ( .not. bfound) then
            ibeg = ibeg + 1
            bset = .false.
            go to 130
         endif
         do ycol = 2, ncols + 1 ! column "1" of zobs(*,*) contains "x-data"
            if ( .not. bset) then
               zp1(ycol) = (zobs(ibeg + 1, ycol) - zobs(ibeg, ycol)) / (
     &            zobs(ibeg + 1, xcol) - zobs(ibeg, xcol))
               zp0(ycol) = zobs(ibeg, ycol) - zp1(ycol) * 
     &            zobs(ibeg, xcol)
               if (ycol .eq. (ncols + 1)) bset = .true.
            endif
            zcal(jj, ycol) = zp0(ycol) + zp1(ycol) * tt
         enddo
      enddo
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccc      do ycol = 2, ncols+1    ! column "1" contains "x-data"
ccc         bset = .false.
ccc         ibeg = 1
ccc         do jj = 1, ncal
ccc            tt = zbeg + Real(jj-1)*dinc
cccc
cccc loop until interval found; ignore double points;
cccc
ccc 3120       continue
ccc            bfound = ((zobs(ibeg,xcol) .le. tt) .and.
ccc     &                (tt .le. zobs(ibeg+1,xcol))) .and.
ccc     &               (TrNe(zobs(ibeg,xcol),zobs(ibeg+1,xcol)))
ccc            if (.not. bfound) then
ccc               ibeg = ibeg + 1
ccc               bset = .false.
ccc               go to 3120
ccc            endif
ccc            if (.not. bset) then
ccc               p1 = (zobs(ibeg+1,ycol) - zobs(ibeg,ycol)) /
ccc     &              (zobs(ibeg+1,xcol) - zobs(ibeg,xcol))
ccc               p0 = zobs(ibeg,ycol)  -  p1 * zobs(ibeg,xcol)
ccc               bset = .true.
ccc            endif
cccc
ccc            zcal(jj,xcol) = tt
ccc            zcal(jj,ycol) = p0 + p1*tt
ccc         enddo
ccc      enddo
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
      call envinit(xxok)
c
  140 continue
      if (xxok) then
         return
      else
         call errlog(.true., '?? Webread: food web setup errors', 
     &      -1)
      endif
c
 9110 format (1x,'?? food web setup exposure file "',a,
     &   '" : expecting at least two numbers, found ',i2)
 9120 format (1x,'?? food web setup: increase arylen reading space: ',/1
     &   x,'                   arylen = ',i6)
 9130 format (1x,'?? food web setup: arylen internal error re: ncal',/,1
     &   x,'                   arylen = ',i6,';  ncal = ',i6)
c
      end
      subroutine webset()
c
c update: 12:10 fri 9-sep-1994.
c food web initialization;
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'noval.par'
      include 'habitat.par'
      include 'numbers.par'
      include 'ode.par'
      include 'phylum.par'
      include 'plots.par'
      include 'strings.par'
c
      include 'chemp.def'
      include 'errors.def'
      include 'expos.def'
      include 'fish.def'
      include 'fluxes.def'
      include 'globpar.def'
      include 'habitat.def'
      include 'heap.def'
      include 'idfiles.def'
      include 'lab.def'
      include 'ode.def'
      include 'odevar.def'
      include 'options.def'
      include 'time.def'
      include 'units.def'
      include 'vdefined.def'
      include 'work.def'
c
      integer nerror, jspecies, nage, jage, jhold, xslen, nlen
      integer ptty, npp, pq0, nq0
      logical have_wt0
      real tbeg, tfin
c
c euler variables
c
      real tmid, astep, almost_one, arel_tol, tbound, tstep, qeuler
      real t0, t1
      integer jtimes, ntimes, nneg, newstep
      logical trne, done, xxok, stephalt
      external xslen, trne
c
c errmsg1:  truth of "error message 1 not issued" ;
c           issue the message only once;
c           the message will be issued if the integration step size is
c           too large  --  detected when any of the integration variables
c           becomes negative.
c
      logical errmsg1
      save errmsg1
      include 'vdefined.sfn'
      data errmsg1 /.true./
c
 9110 format (' ?? Webset: integration step size too large; ',/,
     &   '      suggestion: increase "nstep" to ',i4,/,
     &   '                  and repeat the simulation.')
 9120 format ('## food web setup: "',a,'", age = ',i2)
c
c determine fish's final wt; integrate growth model only;
c
c QUESTION: is it possible to integrate all year classes one, then all
c           year classes two, ..., rather that sequentially by species ?
c           <plan for the future>
c
      if (xtiming) then
         call uxtiming('foodweb setup', 1)
      endif
c
      ptty = 0
      pq0 = 0
      call heapush(ptty)
      call heapush(pq0)
      stephalt = .false.
c
c if all initial fish wt are set, skip fourier sine series initialization
c
      have_wt0 = .true.
      do jspecies = 1, gnspecies
         do jage = 1, xmaximum_age(jspecies)
            have_wt0 = (have_wt0 .and. 
     &         vdefined(vv_iniwt(jage, jspecies)))
         enddo
      enddo
c
      if ( .not. have_wt0) then
         xwt0 = .true.
         call uotty('+## food web setup: temperature', -1)
         if (xtiming) then
            call uxtiming('food web setup: temperature', 1)
         endif
         xfcelsius = (xfourier)
         call webtemp()
         if (xtiming) then
            call uxtiming('food web setup: temperature', 2)
         endif
      else
         xwt0 = .false.
      endif
c
c if "cfish" was a diet item, set its Kf "Cfish_kf";
c
      if (dcfish) then
         call setcfish(gnchem, 'piscivore', cfish_pl, kow, kl, cfish_kf)
      endif
c
      tinc = one
      almost_one = one - mach_eps
      do jspecies = 1, gnspecies
         if (xtiming) then
            write (qhs(pq0), '(a,i2)') 'foodweb setup ', jspecies
            nq0 = xslen(qhs(pq0))
            call uxtiming(qhs(pq0)(1:nq0), 1)
         endif
         nage = xmaximum_age(jspecies)
c
c if all initial fish wt are set, just initialize the parameters;
c else determine initial wt distribution
c
         have_wt0 = .true.
         do jage = 1, nage
            have_wt0 = (have_wt0 .and. 
     &         vdefined(vv_iniwt(jage, jspecies)))
         enddo
         if (have_wt0) then
            do jage = 1, nage
               qq_fish_age(jage, jspecies) = jage
               call initpez(simul_mode, gnchem, xcelsius, sigma, nh3n, 
     &            cn, xplankton_standing_stock, 
     &            vv_inicf(1, jage, jspecies), simul_beg, simul_end, 
     &            vv_growth_model(jage, jspecies), kl, koc, kow, acw, 
     &            molwt, lc50func(1, jspecies), lc50par(1, 1, jspecies),
     &            vv_plfunc(jage, jspecies), vv_iniwt(jage, jspecies), 
     &            vv_pval(1, jage, jspecies), qq_wt(1, jage, jspecies),
     &            qq_bf(1, jage, jspecies), 
     &            qq_jgilup(1, jage, jspecies), 
     &            qq_jgilex(1, jage, jspecies), 
     &            qq_jgutup(1, jage, jspecies), 
     &            qq_jgutex(1, jage, jspecies), 
     &            qq_iterno(jage, jspecies), qq_iprint(jage, jspecies),
     &            hstep, qq_nxy(jage, jspecies), 
     &            qq_kf(1, jage, jspecies), qq_lenfish(jage, jspecies),
     &            dtfish(jage, jspecies), qq_igamma(jage, jspecies), 
     &            qq_iingest(jage, jspecies), qq_iassim(jage, jspecies),
     &            qq_iegest(jage, jspecies), qq_iexcret(jage, jspecies),
     &            qq_irespir(jage, jspecies), qq_isda(jage, jspecies), 
     &            cfmean(1, jage, jspecies), cpmean(1, jage, jspecies),
     &            fish_la50(jspecies), qq_death_day(jage, jspecies), 
     &            qq_fish_alive(jage, jspecies))
            enddo
            go to 130
         endif
c
         nlen = xslen(spplab(jspecies))
         tbeg = simul_beg
         tfin = tbeg
         call envinit(xxok)
         call envget(tbeg)
c
c *************** initialize simulation/print/plotting parameters *************
c integrate growth model of age class one ONLY;
c
         jhold = 1      ! initialize age class 1            
         call initpez(simul_mode, gnchem, xcelsius, sigma, nh3n, cn, 
     &      xplankton_standing_stock, vv_inicf(1, jhold, jspecies), 
     &      simul_beg, simul_end, vv_growth_model(jhold, jspecies), kl,
     &      koc, kow, acw, molwt, lc50func(1, jspecies), 
     &      lc50par(1, 1, jspecies), vv_plfunc(jhold, jspecies), 
     &      vv_iniwt(jhold, jspecies), vv_pval(1, jhold, jspecies), 
     &      qq_wt(1, jhold, jspecies), qq_bf(1, jhold, jspecies), 
     &      qq_jgilup(1, jhold, jspecies), 
     &      qq_jgilex(1, jhold, jspecies), 
     &      qq_jgutup(1, jhold, jspecies), 
     &      qq_jgutex(1, jhold, jspecies), qq_iterno(jhold, jspecies), 
     &      qq_iprint(jhold, jspecies), hstep, qq_nxy(jhold, jspecies),
     &      qq_kf(1, jhold, jspecies), qq_lenfish(jhold, jspecies), 
     &      dtfish(jhold, jspecies), qq_igamma(jhold, jspecies), 
     &      qq_iingest(jhold, jspecies), qq_iassim(jhold, jspecies), 
     &      qq_iegest(jhold, jspecies), qq_iexcret(jhold, jspecies), 
     &      qq_irespir(jhold, jspecies), qq_isda(jhold, jspecies), 
     &      cfmean(1, jhold, jspecies), cpmean(1, jhold, jspecies), 
     &      fish_la50(jspecies), qq_death_day(jhold, jspecies), 
     &      qq_fish_alive(jhold, jspecies))
c
         qq_new_day(jhold, jspecies) = tbeg
         do jage = 2, nage
            write (qhs(ptty), 9120) spplab(jspecies)(1:nlen), jage
            call compress(qhs(ptty), -1, npp)
            call uotty(qhs(ptty), npp)
            tbeg = tfin
            tfin = tbeg + one_year
            t0 = tbeg
            t1 = tfin
c
  110       continue
            call kstep(t0, t1, t0, t1, nerror)
c
            astep = min(abs(hstep), abs(t1 - t0))
            ntimes = int(((t1 - t0 + hstep) / hstep) + almost_one)
c
            if (trne(t1, zero)) then
               arel_tol = abs(t1 * mach_eps)
            else
               arel_tol = abs(mach_eps)
            endif
c
            tbound = t1 - arel_tol
            tstep = astep
            tmid = t0
c
c at the start of the loop: tmid = t0 + Float(jtimes-1);
c the purpose of the loop is to ensure a finite number of steps;
c
            do jtimes = 1, ntimes
               call dwdtode(jhold, jspecies, tmid, nerror)
c
c take euler step:  y(tmid + tstep) = y(tmid)  +  tstep * y'(tmid)
c
c if "tmid + tstep" can overshoot "t1", or it is within machine precision
c from "t1", adjust the step size;
c
               if (tbound .le. (tmid + tstep)) tstep = t1 - tmid
               tmid = tmid + tstep
c
c make sure values are non-negative; keep a count of negative values
c
               nneg = 0
               qeuler = qq_wt(1, jhold, jspecies) + tstep * 
     &            qq_dwdt(1, jhold, jspecies)
               if (qeuler .lt. zero) then
                  nneg = nneg + 1
                  qeuler = zero
               endif
               qq_wt(1, jhold, jspecies) = qeuler
c
               qeuler = qq_wt(2, jhold, jspecies) + tstep * 
     &            qq_dwdt(2, jhold, jspecies)
               if (qeuler .lt. zero) then
                  nneg = nneg + 1
                  qeuler = zero
               endif
               qq_wt(2, jhold, jspecies) = qeuler
c
c negative values detected ?
c
               if (nneg .gt. 0) then
                  if (errmsg1) then
                     errmsg1 = .false.
                     newstep = nint((8.0 + astep) / astep)
                     call uotty(' ', 1)
                     write (stdout, 9110) newstep
                     write (stdout, *)
                     stephalt = .true.
                     go to 140
                  endif
               endif
c
c have we reached t1 ?
c
               done = (abs(tmid - t1) .le. arel_tol)
               if (done) go to 120
            enddo
c
  120       continue
            if (trne(tfin, t1)) then
               t0 = t1
               t1 = tfin
               go to 110
            endif
c
            qq_fish_age(jage, jspecies) = jage
            vv_iniwt(jage, jspecies) = qq_wt(1, jhold, jspecies)
c                                                             ! initwt jth class
            call initpez(simul_mode, gnchem, xcelsius, sigma, nh3n, cn,
     &         xplankton_standing_stock, vv_inicf(1, jage, jspecies), 
     &         simul_beg, simul_end, vv_growth_model(jage, jspecies), 
     &         kl, koc, kow, acw, molwt, lc50func(1, jspecies), 
     &         lc50par(1, 1, jspecies), vv_plfunc(jage, jspecies), 
     &         vv_iniwt(jage, jspecies), vv_pval(1, jage, jspecies), 
     &         qq_wt(1, jage, jspecies), qq_bf(1, jage, jspecies), 
     &         qq_jgilup(1, jage, jspecies), 
     &         qq_jgilex(1, jage, jspecies), 
     &         qq_jgutup(1, jage, jspecies), 
     &         qq_jgutex(1, jage, jspecies), qq_iterno(jage, jspecies),
     &         qq_iprint(jage, jspecies), hstep, qq_nxy(jage, jspecies),
     &         qq_kf(1, jage, jspecies), qq_lenfish(jage, jspecies), 
     &         dtfish(jage, jspecies), qq_igamma(jage, jspecies), 
     &         qq_iingest(jage, jspecies), qq_iassim(jage, jspecies), 
     &         qq_iegest(jage, jspecies), qq_iexcret(jage, jspecies), 
     &         qq_irespir(jage, jspecies), qq_isda(jage, jspecies), 
     &         cfmean(1, jage, jspecies), cpmean(1, jage, jspecies), 
     &         fish_la50(jspecies), qq_death_day(jage, jspecies), 
     &         qq_fish_alive(jage, jspecies))
         enddo
c
         qq_fish_age(jhold, jspecies) = 1
         call initpez(simul_mode, gnchem, xcelsius, sigma, nh3n, cn, 
     &      xplankton_standing_stock, vv_inicf(1, jhold, jspecies), 
     &      simul_beg, simul_end, vv_growth_model(jhold, jspecies), kl,
     &      koc, kow, acw, molwt, lc50func(1, jspecies), 
     &      lc50par(1, 1, jspecies), vv_plfunc(jhold, jspecies), 
     &      vv_iniwt(jhold, jspecies), vv_pval(1, jhold, jspecies), 
     &      qq_wt(1, jhold, jspecies), qq_bf(1, jhold, jspecies), 
     &      qq_jgilup(1, jhold, jspecies), 
     &      qq_jgilex(1, jhold, jspecies), 
     &      qq_jgutup(1, jhold, jspecies), 
     &      qq_jgutex(1, jhold, jspecies), qq_iterno(jhold, jspecies), 
     &      qq_iprint(jhold, jspecies), hstep, qq_nxy(jhold, jspecies),
     &      qq_kf(1, jhold, jspecies), qq_lenfish(jhold, jspecies), 
     &      dtfish(jhold, jspecies), qq_igamma(jhold, jspecies), 
     &      qq_iingest(jhold, jspecies), qq_iassim(jhold, jspecies), 
     &      qq_iegest(jhold, jspecies), qq_iexcret(jhold, jspecies), 
     &      qq_irespir(jhold, jspecies), qq_isda(jhold, jspecies), 
     &      cfmean(1, jhold, jspecies), cpmean(1, jhold, jspecies), 
     &      fish_la50(jspecies), qq_death_day(jhold, jspecies), 
     &      qq_fish_alive(jhold, jspecies))
c
  130    continue
         if (xtiming) then
            call uxtiming(qhs(pq0)(1:nq0), 2)
         endif
      enddo
c
      xfcelsius = .false.
      call uotty('+', 1)
      call heapop(pq0)
      call heapop(ptty)
c
      if (xtiming) then
         call uxtiming('foodweb setup', 2)
      endif
c
  140 continue
      if (stephalt) then
         haltsimul = .true.
      endif
c
      return
      end
      subroutine webstep(zbeg, zfin, nerror)
c
c update: 11:46 fri 9-sep-1994.
c
c integrate Webode from zbeg to zfin for all species;
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'errors.par'
      include 'fish.par'
      include 'noval.par'
      include 'numbers.par'
      include 'ode.par'
c
      include 'errors.def'
      include 'fish.def'
      include 'fluxes.def'
      include 'globpar.def'
      include 'idfiles.def'
      include 'lab.def'
      include 'ode.def'
c
      integer nerror
      real zbeg, zfin
c
      real tmid, astep, almost_one, arel_tol, tbound, tstep, qeuler
      real t0, t1
      integer jtimes, ntimes, nneg, jchem, jage, jspecies, kdum0, kdum1
      integer newstep
      logical trne, somealive, done, stephalt
      external trne
c
c errmsg1:  truth of "error message 1 not issued" ;
c           issue the message only once;
c           the message will be issued if the integration step size is
c           too large  --  detected when any of the integration variables
c           becomes negative.
c
      logical errmsg1
      save errmsg1
      data errmsg1 /.true./
c
 9110 format (' ?? Webstep: integration step size too large; ',/,
     &   '    suggestion: increase "nstep" to ',i4,/,
     &   '                and repeat the simulation.')
c
      nerror = tnoerror
      stephalt = .false.
      tinc = one
      t0 = zbeg
      t1 = zfin
      kdum0 = inoval
      kdum1 = inoval
      almost_one = one - mach_eps
c
  110 continue
      call kstep(t0, t1, t0, t1, nerror)
      if (nerror .eq. tnoerror) then
c
         astep = min(abs(hstep), abs(t1 - t0))
         ntimes = int(((t1 - t0 + hstep) / hstep) + almost_one)
c
         if (trne(t1, zero)) then
            arel_tol = abs(t1 * mach_eps)
         else
            arel_tol = abs(mach_eps)
         endif
c
         tbound = t1 - arel_tol
         tstep = astep
         tmid = t0
c
c at the start of the loop: tmid = t0 + Float(jtimes-1);
c the purpose of the loop is to ensure a finite number of steps;
c
         do jtimes = 1, ntimes
            call webode(kdum0, kdum1, tmid, nerror)
            if (nerror .ne. tnoerror) go to 130
c
c take euler step:  y(tmid + tstep) = y(tmid)  +  tstep * y'(tmid)
c
c if "tmid + tstep" can overshoot "t1", or it is within machine precision
c from "t1", adjust the step size;
c
            if (tbound .le. (tmid + tstep)) tstep = t1 - tmid
            tmid = tmid + tstep
c
c make sure values are non-negative; keep a count of negative values;
c update live fish only;
c
            call ksave1(tstep, tmid, .false.)
            nneg = 0
            do jspecies = 1, gnspecies
               do jage = 1, xmaximum_age(jspecies)
                  if (qq_fish_alive(jage, jspecies)) then
                     qeuler = qq_wt(1, jage, jspecies) + tstep * 
     &                  qq_dwdt(1, jage, jspecies)
                     if (qeuler .lt. zero) then
                        nneg = nneg + 1
                        qeuler = zero
                     endif
                     qq_wt(1, jage, jspecies) = qeuler
c
                     qeuler = qq_wt(2, jage, jspecies) + tstep * 
     &                  qq_dwdt(2, jage, jspecies)
                     if (qeuler .lt. zero) then
                        nneg = nneg + 1
                        qeuler = zero
                     endif
                     qq_wt(2, jage, jspecies) = qeuler
c
                     do jchem = 1, gnchem
                        qeuler = qq_bf(jchem, jage, jspecies) + tstep *
     &                     qq_dbfdt(jchem, jage, jspecies)
                        if (qeuler .lt. zero) then
                           nneg = nneg + 1
                           qeuler = zero
                        endif
                        qq_bf(jchem, jage, jspecies) = qeuler
                     enddo
c
c save stuff
c
                     call ksave(jage, jspecies, tstep, tmid, .false.)
                  endif
               enddo
            enddo
c
c negative values detected ?
c
            if (nneg .gt. 0) then
               if (errmsg1) then
                  errmsg1 = .false.
                  newstep = nint((8.0 + astep) / astep)
                  call uotty(' ', 1)
                  write (stdout, 9110) newstep
                  write (stdout, *)
                  stephalt = .true.
                  go to 130
               endif
            endif
c
c . all fish dead ? - return to calling module;
c . if all fish are dead, somealive == 0;
c . this test must be performed *after* Ksave is called since Ksave
c   updates Qq_fish_alive
c
            somealive = .false.
            do jspecies = 1, gnspecies
               do jage = 1, xmaximum_age(jspecies)
                  somealive = somealive .or. 
     &               qq_fish_alive(jage, jspecies)
               enddo
            enddo
            if ( .not. somealive) go to 130
c
c have we reached t1 ?
c
            done = (abs(tmid - t1) .le. arel_tol)
            if (done) go to 120
         enddo
c
  120    continue
         if (trne(zfin, t1)) then
            t0 = t1
            t1 = zfin
            go to 110
         endif
      endif
c
  130 continue
      if (stephalt) then
         haltsimul = .true.
      endif
c
      return
      end
      subroutine webtemp()
c
c update: 17:55 fri 4-mar-1994.
c determine temperature function to be used for the food web initialization;
c
c approximate the temperature (for setup) by a function:
c if Twfunc == tconstant | tsin  ==> use that function
c if Twfunc == tfile generate fourier sine series approximation:
c
c do the same for plankton standing stock
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'habitat.par'
      include 'fish.par'
      include 'plots.par'
      include 'phylum.par'
      include 'simul.par'
      include 'idfiles.def'
      include 'habitat.def'
      include 'work.def'
      include 'examsrec.def'
      include 'options.def'
c
      integer nobs, ncal
c
      if (xfcelsius) then
c
c propagate changes: "Initpgm" "Envexams" "Envexam0" "Webtemp" "examsrec.def" "iend"
c . size_of (Wvector) == maxvals .ge. number of entries in exams exposure file
c . number of entries in exams exposure file == 3 + 3*n, n == Gnchem
c . format of exams exposure file
c     time temp plankton_stock cw(1:n) benthos_conc(1:n) plankton_conc(1:n)
c                                      cfish_conc(1:n)
c . module "Envexams": character*(329)      card
c   from exams -- exposure file format:
c     - 1x, 1pe12.5, 1x, 0pf5.1, 1x, 1pe9.2, 30(1x,e9.2)
c     - length of line: 29 + 30*n, n = number of chemicals
c     - 329 = 29 + 30 * maxchem
c
         if (xexams) then
            xypntr(1) = ptemp
            xypntr(2) = ppss
            xyntot = 2
            call webread(jcw, rrlen, xyntot, xypntr, xyread, nobs, 
     &         xyeqsh, ncal, wvector, xyp0, xyp1)
            call sinegen(xyeqsh(1, 1), xyeqsh(1, xypntr(1)), ncal, 
     &         maxbk, mtw, bktw, a0tw, a1tw, aatw, bbtw)
            call sinegen(xyeqsh(1, 1), xyeqsh(1, xypntr(2)), ncal, 
     &         maxbk, mpss, bkpss, a0pss, a1pss, aapss, bbpss)
            go to 110
         endif
c
         if (twfunc .eq. tconstant) then
            continue
         elseif (twfunc .eq. tsin) then
            continue
         elseif (twfunc .eq. tfile) then
            xypntr(1) = 2
            xyntot = 1
            call webread(jcw, rrlen, xyntot, xypntr, xyread, nobs, 
     &         xyeqsh, ncal, wvector, xyp0, xyp1)
            call sinegen(xyeqsh(1, 1), xyeqsh(1, xypntr(1)), ncal, 
     &         maxbk, mtw, bktw, a0tw, a1tw, aatw, bbtw)
         endif
c
         if (xplankton) then
            if (plankton_standing_stock_func .eq. tconstant) then
               continue
            elseif (plankton_standing_stock_func .eq. tfile) then
               xypntr(1) = 2
               xyntot = 1
               call webread(jplankton, rrlen, xyntot, xypntr, xyread, 
     &            nobs, xyeqsh, ncal, wvector, xyp0, xyp1)
               call sinegen(xyeqsh(1, 1), xyeqsh(1, xypntr(1)), ncal, 
     &            maxbk, mpss, bkpss, a0pss, a1pss, aapss, bbpss)
            endif
         endif
      endif
c
  110 continue
      return
      end
      subroutine webupdat()
c
c update: 17:32 fri 4-mar-1994.
c cohort graduation;
c
c declaration of fortran parameters
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'fish.par'
      include 'plots.par'
      include 'phylum.par'
      include 'fish.def'
      include 'globpar.def'
      include 'chemp.def'
      include 'odevar.def'
      include 'fluxes.def'
      include 'work.def'
      include 'lab.def'
      include 'options.def'
      include 'expos.def'
c
      integer jspecies, nage, jage, agep
      logical hold_death_status
      real hold_death_day
c
      call initchem(time_beg, time_end, hstep)
c
      do jspecies = 1, gnspecies
         nage = xmaximum_age(jspecies)
         do jage = 1, nage
            qq_fish_age(jage, jspecies) = qq_fish_age(jage, jspecies) +
     &         1
            if (qq_fish_age(jage, jspecies) .gt. nage) then
               qq_fish_age(jage, jspecies) = 1
            endif
c
c ****************************************
c *** notice AGEP in call to Initpez ***
c ****************************************
c
c if Qq_fish_age(jage,jspecies) == 1:
c - generate new fish year class one: requires initial "Vv_iniwt" and "Vv_inicf"
c
c else
c - continue with old fish: the initial wt is NOT "Vv_iniwt" but "Qq_wt";
c - ditto for "Qq_cfj(1,jage,jspecies)" rather than "Vv_inicf"
c
            agep = qq_fish_age(jage, jspecies)
            if (qq_fish_age(jage, jspecies) .eq. 1) then
               call initpez(simul_mode, gnchem, xcelsius, sigma, nh3n, 
     &            cn, xplankton_standing_stock, 
     &            vv_inicf(1, agep, jspecies), time_beg, time_end, 
     &            vv_growth_model(agep, jspecies), kl, koc, kow, acw, 
     &            molwt, lc50func(1, jspecies), lc50par(1, 1, jspecies),
     &            vv_plfunc(agep, jspecies), vv_iniwt(agep, jspecies), 
     &            vv_pval(1, agep, jspecies), qq_wt(1, jage, jspecies),
     &            qq_bf(1, jage, jspecies), 
     &            qq_jgilup(1, jage, jspecies), 
     &            qq_jgilex(1, jage, jspecies), 
     &            qq_jgutup(1, jage, jspecies), 
     &            qq_jgutex(1, jage, jspecies), 
     &            qq_iterno(jage, jspecies), qq_iprint(jage, jspecies),
     &            hstep, qq_nxy(jage, jspecies), 
     &            qq_kf(1, jage, jspecies), qq_lenfish(jage, jspecies),
     &            dtfish(jage, jspecies), qq_igamma(jage, jspecies), 
     &            qq_iingest(jage, jspecies), qq_iassim(jage, jspecies),
     &            qq_iegest(jage, jspecies), qq_iexcret(jage, jspecies),
     &            qq_irespir(jage, jspecies), qq_isda(jage, jspecies), 
     &            cfmean(1, jage, jspecies), cpmean(1, jage, jspecies),
     &            fish_la50(jspecies), qq_death_day(jage, jspecies), 
     &            qq_fish_alive(jage, jspecies))
c
c we do not want to resurrect fish; dead fish should stay dead until
c they are replaced with a new age class one;
c
            else
               hold_death_status = qq_fish_alive(jage, jspecies)
               hold_death_day = qq_death_day(jage, jspecies)
c                                                     ! WARNING: note argument
               call initpez(simul_mode, gnchem, xcelsius, sigma, nh3n, 
     &            cn, xplankton_standing_stock, 
     &            qq_cfj(1, jage, jspecies), time_beg, time_end, 
     &            vv_growth_model(agep, jspecies), kl, koc, kow, acw, 
     &            molwt, lc50func(1, jspecies), lc50par(1, 1, jspecies),
     &            vv_plfunc(agep, jspecies), qq_wt(1, jage, jspecies), 
     &            vv_pval(1, agep, jspecies), qq_wt(1, jage, jspecies),
     &            qq_bf(1, jage, jspecies), 
     &            qq_jgilup(1, jage, jspecies), 
     &            qq_jgilex(1, jage, jspecies), 
     &            qq_jgutup(1, jage, jspecies), 
     &            qq_jgutex(1, jage, jspecies), 
     &            qq_iterno(jage, jspecies), qq_iprint(jage, jspecies),
     &            hstep, qq_nxy(jage, jspecies), 
     &            qq_kf(1, jage, jspecies), qq_lenfish(jage, jspecies),
     &            dtfish(jage, jspecies), qq_igamma(jage, jspecies), 
     &            qq_iingest(jage, jspecies), qq_iassim(jage, jspecies),
     &            qq_iegest(jage, jspecies), qq_iexcret(jage, jspecies),
     &            qq_irespir(jage, jspecies), qq_isda(jage, jspecies), 
     &            cfmean(1, jage, jspecies), cpmean(1, jage, jspecies),
     &            fish_la50(jspecies), qq_death_day(jage, jspecies), 
     &            qq_fish_alive(jage, jspecies))
c                                                     ! WARNING: note argument
               qq_fish_alive(jage, jspecies) = hold_death_status
               qq_death_day(jage, jspecies) = hold_death_day
            endif
         enddo
      enddo
c
      return
      end
c XCAT.spg  processed by SPAG 3.14A  at 14:48 on 26 Oct 1992
      character*( * ) function xcat(str1, str2)
c
c! xcat  -  concatenate two null-terminated/regular strings
c
      include 'xglobal.par'
c
      character*( * ) str1, str2
      integer ns1, ns2, xslen
      external xslen
c
      ns1 = xslen(str1)
      ns2 = xslen(str2)
c
      if (ns1 .gt. 0) then
         if (ns2 .gt. 0) then
            xcat = str1(1:ns1) // str2(1:ns2) // null
         else
            xcat = str1(1:ns1) // null
         endif
      elseif (ns2 .gt. 0) then
         xcat = str2(1:ns2) // null
      else
         xcat = null
      endif
c
      return
      end
      subroutine xerrmsg(xmsg)
c
c! xerrmsg  -  output message to stderr
c history:
c . [lsr] 11:10 wed 24-feb-1993.
c   if ZSTDERR is not open, write to 6 (hardwired)
c . processed by SPAG 3.14A  at 13:10 on  8 Jan 1993
c
      include 'xglobal.par'
      include 'xio.inc'
c
      character*( * ) xmsg
      integer uu
      logical isopen
c
      integer nn, xslen
      external xslen
c
      inquire (unit=zstderr, opened=isopen)
      if (isopen) then
         uu = zstderr
      else
         uu = 6 ! punt                                       
      endif
c
      nn = xslen(xmsg)
      if (nn .gt. 0) write (uu, '(1x,a)') xmsg(1:nn)
c
      return
      end
      logical function xf77cctl(cc)
c
c update:   fri 17:03 6-nov-1992.
c XF77CCTL.spg  processed by SPAG 3.14A  at 14:48 on 26 Oct 1992
c fortran carriage control characters;
c * ==> vax fortran extension
c
c    '+'       overprinting: starts output at the beginning of the current
c              line and returns to the left margin after printing.
c    ' '       single spacing: starts output at the beginning of the next line;
c              16:34:30.04 tuesday june 27, 1989. : do not consider blank
c                                                   a carriage control.
c    '0'       double spacing: skips a line before starting output
c    '1'       paging: starts output at the top of a new page
c  * '$'       prompting: starts output at the beginning of the next line,
c              and suppresses carriage return at the end of the line.
c  * null      overprinting with no advance: starts output at the beginning
c              of the current line and does not return to the left margin
c              after printing.
c
      include 'xglobal.par'
c
      character*1 cc
c
c                ! (cc .eq. ' ') .or.
      xf77cctl = ((cc .eq. '+') .or. (cc .eq. '$') .or. (cc .eq. null))
c                ! (cc .eq. '0') .or.  (cc .eq. '1') .or.
c
      return
      end
      integer function xfalloc(uu)
c
c xfalloc  -  allocate a unit number for i/o
c history:
c - [lsr] 16:56 fri 1-apr-1994.
c   . ``MaxOpen'' changed to "IOUmin,IOUmax" pair
c - 09:18 fri 18-mar-1994.
c - processed by SPAG 3.14A  at 14:49 on 26 Oct 1992
c
c notes:
c    because other external utilities (e.g., calcomp) may choose
c    to open some of these units, some care must be exercised.
c;;
      include 'xglobal.par'
      include 'xio.inc'
c
      integer uu
c
c! external modules
      external xfputstr
c
      uu = ioumin
      do while ((uu .le. ioumax) .and. (alloc(uu)))
         uu = uu + 1
      enddo
c
      if (uu .gt. ioumax) then
         uu = zioerror
         call xerrmsg('?? Xfalloc: exceeded open file limit' // eol)
      else
         alloc(uu) = .true.
      endif
c
      xfalloc = uu
c
      return
      end
      subroutine xfclose(uu)
c
c Xfclose  -  deallocate a file
c for your confort and convenience, we will close a unit that was not opened
c    using xfalloc as long as the unit was opened.
c
c history:
c - [lsr] 16:56 fri 1-apr-1994.
c   . ``MaxOpen'' changed to "IOUmin,IOUmax" pair
c - 09:17 fri 18-mar-1994.
c - processed by SPAG 3.14A  at 14:49 on 26 Oct 1992
c;;
      include 'xglobal.par'
      include 'xio.inc'
c
      integer uu, ios
      logical is_open
c
c! external modules
      external xfdealoc, xfflush, xfputstr, xioerr
c
      if (uu .eq. zioerror) then
         continue
c
      elseif ((ioumin .le. uu) .and. (uu .le. ioumax)) then
         if (access(uu) .ne. zioread) call xfflush(uu)
         zlines(uu) = 0
         inquire (unit=uu, opened=is_open)
         if (is_open) then
            close (unit=uu, iostat=ios)
            if (ios .eq. 0) then
               call xfdealoc(uu)
            else
               call xerrmsg('?? Xfclose: ' // null)
               call xioerr(ios)
            endif
         else
            call xfdealoc(uu)
         endif
c
      else
         inquire (unit=uu, opened=is_open)
         if (is_open) then
            close (unit=uu, iostat=ios)
            if (ios .ne. 0) then
               call xerrmsg('?? Xfclose: ' // null)
               call xioerr(ios)
            endif
         endif
      endif
c
      return
      end
      subroutine xfdealoc(uu)
c
c Xfdealoc  -  deallocate a unit
c history:
c - [lsr] 16:56 fri 1-apr-1994.
c   . ``MaxOpen'' changed to "IOUmin,IOUmax" pair
c - 10:36 mon 4-jan-1993.
c - processed by SPAG 3.14A  at 14:49 on 26 Oct 1992
c;;
      include 'xglobal.par'
      include 'xio.inc'
c
      integer uu
c
      character*(stdlen) xitoa
c
c! external modules
      external xfputstr, xitoa
c
      if (uu .eq. zioerror) then
         continue
      elseif ((ioumin .le. 0) .and. (uu .le. ioumax)) then
         alloc(uu) = .false.
      else
         call xerrmsg('?? Xfdealoc: illegal unit number: ' // null)
         call xerrmsg(xitoa(uu))
         call xerrmsg(eol)
      endif
c
      return
      end
      character*( * ) function 
     &   xfexpand(filespec, dev, dir, name, type, vers)
c
c Xfexpand  -  expand file name to full file specification (path+name)
c output examples:
c - vms:
c FileSpec: "z:a*.del"
c Xfexpand: "bio1:[luis.zapfiles]a*.del;"
c      Dev: "bio1:"
c      Dir: "[luis.zapfiles]"
c     Name: "a*"
c     Type: ".del"
c     Vers: ";"
c    Xdisk: "bio1"
c     Xdir: "bio1:[luis.flb.test]"
c
c - dos:
c FileSpec: "c:\m\a.del"
c Xfexpand: "c:\m\a.del"
c      Dev: "c:"
c      Dir: "\m\"
c     Name: "a"
c     Type: ".del"
c     Vers: " "
c    Xdisk: "c:"
c     Xdir: "\piranhax\fgets\vnew\1111\"
c
c processed by SPAG 3.14A  at 13:10 on  8 Jan 1993
c;;
      include 'xglobal.par'
c
      character*( * ) filespec, dev, dir, name, type, vers
c
c
      integer fp, fe, tp, te
c
      integer xslen
      character*(maxstr) xgetdisk, xgetdir, xcat
      external xgetdisk, xgetdir, xcat, xslen
c
      xfexpand = null
      dev = null
      dir = null
      name = null
      type = null
      vers = null
c
      fe = xslen(filespec)
      if (fe .le. 0) then       ! empty file name: leave      
         dev = xgetdisk(dev)
         dir = xgetdir(dir)
         go to 120
      endif
c
      fp = index(filespec(1:fe), ':')
      if (fp .eq. 0) then
         dev = xgetdisk(dev)
      else
         dev = filespec(1:fp) // null
      endif
      fp = fp + 1
c
      tp = fp
      if (fp .le. fe) then
         te = index(filespec(fp:fe), '\')
         if (te .eq. 0) then
            dir = xgetdir(dir)
         else
  110       continue
            if (te .ne. 0) then
               fp = fp + te
               if (fp .le. fe) then
                  te = index(filespec(fp:fe), '\')
               else
                  te = 0
               endif
               go to 110
            endif
            dir = filespec(tp:fp - 1) // null
         endif
      else
         dir = xgetdir(dir)
      endif
c
      if (fp .le. fe) then
         tp = index(filespec(fp:fe), '.')
         if (tp .eq. 0) then
            name = filespec(fp:fe)
            type = null
         else
            tp = tp + fp - 2    ! character just before the "."  
            if (fp .le. tp) then
               name = filespec(fp:tp) // null
            else
               name = null
            endif
            type = filespec(tp + 1:fe) // null
         endif
      else
         name = null
         type = null
      endif
      vers = null
c
  120 continue
      xfexpand = xcat(dev, xcat(dir, xcat(name, type)))
c
      return
      end
      subroutine xfflush(uu)
c
c Xfflush  -  dump io_buf associated with unit uu
c
c history:
c . update: fri 17:18 6-nov-1992.
c . processed by SPAG 3.14A  at 14:49 on 26 Oct 1992
c . 10:03 thu 2-sep-1993.
c   - if "unit shadowing" is enabled, flush also the copy buffer.
c
      include 'Xglobal.par'
      include 'Xio.inc'
      include 'Xftee.def'
c
      integer uu, jj, utmp
      external xfteeblk
c
c flush named buffer
c
      if (bp(uu) .gt. 0) then
         write (uu, '(a)') io_buf(uu)(1:bp(uu))
         bp(uu) = 0
      endif
c
c flush cc (carbon copy) buffers
c
      do jj = 1, nshadow
         if (uu .eq. uorig(jj)) then
            utmp = ucopy(jj)
            if (bp(utmp) .gt. 0) then
               write (utmp, '(a)') io_buf(utmp)(1:bp(utmp))
               bp(utmp) = 0
            endif
         endif
      enddo
c
      return
      end
      integer function xfopen(uu, filename, mode)
c
c Xfopen  -  open file and assign unique unit number
c
c history:
c - [lsr] 16:56 fri 1-apr-1994.
c   . ``MaxOpen'' changed to "IOUmin,IOUmax" pair
c - 08:50 fri 18-mar-1994.
c - processed by SPAG 3.14A  at 13:10 on  8 Jan 1993
c - thu 09:56 27-feb-1992:
c   . unformatted direct stuff added
c;;
      include 'xglobal.par'
      include 'xio.inc'
c
c
      character*( * ) filename
      integer uu, mode
      logical havefile
c
c
      character*(stdlen) xitoa
      integer flength, ios, xslen, xfalloc
c
c! external modules
      external xfalloc, xfdealoc, xfputstr
      external xioerr, xitoa, xslen
c
      flength = max(1, xslen(filename)) ! just in case filename == ""
      uu = xfalloc(uu)
      xfopen = uu
c
      if (uu .eq. zioerror) then
         continue
c
c ******************************************************************
      elseif (mode .eq. zioread) then
         open (unit=uu, file=filename(1:flength), access='sequential', 
     &      form='formatted', status='old', action='READ,DENYWRITE', 
     &      iostat=ios, err=110)
         bp(uu) = 0
         blen(uu) = 0
         zlines(uu) = 0
         access(uu) = zioread
         rewind (unit=uu, iostat=ios)
c
c ******************************************************************
      elseif (mode .eq. ziowrite) then
         open (unit=uu, file=filename(1:flength), access='sequential', 
     &      form='formatted', status='unknown', carriagecontrol='list',
     &      action='READ/WRITE,DENYBOTH', iostat=ios, err=110)
         bp(uu) = 0
         blen(uu) = 0
         zlines(uu) = 0
         access(uu) = ziowrite
         rewind (unit=uu, iostat=ios)
c
c ******************************************************************
      elseif (mode .eq. zioplot) then
         open (unit=uu, file=filename(1:flength), access='sequential', 
     &      form='formatted', action='READ/WRITE,DENYBOTH', status=
     &      'unknown', iostat=ios, err=110)
         bp(uu) = 0
         blen(uu) = 0
         zlines(uu) = 0
         access(uu) = ziowrite
         rewind (unit=uu, iostat=ios)
c
c ******************************************************************
      elseif (mode .eq. zioappend) then
         open (unit=uu, file=filename(1:flength), access='append', form=
     &      'formatted', status='unknown', carriagecontrol='list', 
     &      action='READ/WRITE,DENYBOTH', iostat=ios, err=110)
         bp(uu) = 0
         blen(uu) = 0
         zlines(uu) = 0
         access(uu) = ziowrite
c
c
c ******************************************************************
c unformatted direct stuff
c ******************************************************************
      elseif (mode .eq. zuread) then
         open (unit=uu, file=filename(1:flength), access='direct', form=
     &      'unformatted', recl=lenrec, status='old', action=
     &      'READ,DENYWRITE', iostat=ios, err=110)
         bp(uu) = 0
         blen(uu) = 0
         zlines(uu) = 0
         access(uu) = zioread
         rewind (unit=uu, iostat=ios)
c
c ******************************************************************
      elseif (mode .eq. zuwrite) then
         open (unit=uu, file=filename(1:flength), form='unformatted', 
     &      recl=lenrec, status='unknown', action='READ/WRITE,DENYBOTH',
     &      iostat=ios, err=110)
         bp(uu) = 0
         blen(uu) = 0
         zlines(uu) = 0
         access(uu) = ziowrite
c
c
      else
         call xfdealoc(uu)
         call xerrmsg('?? xfopen: "' // filename(1:flength) // 
     &      '" illegal access mode: ' // null)
         call xerrmsg(xitoa(mode))
         call xerrmsg(eol)
         xfopen = zioerror
      endif
      return
c
 9110 format (1x,'?? Xfopen: could not open "',a,'"')
 9120 format (1x,'?? Xfopen: unrecognized access Mode "',i3,
     &   '" for file"',a,'"')
c
  110 continue
      call xfdealoc(uu)
      xfopen = zioerror
      call xerrmsg('?? xfopen: "' // filename(1:flength) // '" ' // null
     &   )
      call xioerr(ios)
c
      end
      subroutine xfputstr(uu, string)
c
c XfputStr  -  output string to file
c
c history:
c . processed by SPAG 3.14A  at 14:49 on 26 Oct 1992
c . 09:34 thu 2-sep-1993.
c   - enable "unit" shadowing, i.e., duplicate messages to other units
c
      include 'Xglobal.par'
      include 'Xftee.def'
c
      character*( * ) string
      integer uu, jj
      logical xsamefil
      external xsamefil, xfteeblk
c
      call xfputsxx(uu, string) ! issue the "Original" String 
c
      do jj = 1, nshadow        ! cc (carbon copy) to other units
         if (uu .eq. uorig(jj)) then
            call xfputsxx(ucopy(jj), string)
         endif
      enddo
c
      return
      end
      subroutine xfputsxx(uu, string)
c
c XfputSxx  -  output string to file
c
c history:
c . 09:02 fri 18-mar-1994.
c   - line counter "Zlines" added;
c
c . 09:34 thu 2-sep-1993.
c   - work horse for the new "XfputStr";
c     this module was the old "XfputStr";
c
c . processed by SPAG 3.14A  at 14:49 on 26 Oct 1992
c;;
      include 'xglobal.par'
      include 'xio.inc'
c
      character*( * ) string
      integer uu, jj, xslen, nlen
      logical xf77cctl
      external xf77cctl, xslen
c
      jj = 1
      nlen = xslen(string)
c
      do while (jj .le. nlen)
         bp(uu) = bp(uu) + 1
         if (bp(uu) .eq. maxline) then
            write (uu, '(a)') io_buf(uu)(1:maxline)
            bp(uu) = 0
            zlines(uu) = zlines(uu) + 1
         elseif (string(jj:jj) .eq. newline) then
            if (bp(uu) .gt. 1) then
               write (uu, '(a)') io_buf(uu)(1:bp(uu) - 1)
            else
               write (uu, *)
            endif
            jj = jj + 1
            bp(uu) = 0
            zlines(uu) = zlines(uu) + 1
         else
            if (uu .eq. zstderr) then
               if (bp(uu) .eq. 1) then
                  if ( .not. xf77cctl(string(jj:jj))) then
                     io_buf(uu)(bp(uu):bp(uu)) = ' '
                     bp(uu) = bp(uu) + 1
                  endif
               endif
            endif
            io_buf(uu)(bp(uu):bp(uu)) = string(jj:jj)
            jj = jj + 1
         endif
      enddo
c
      return
      end
      block data xfteeblk
c
c XfteeBlk - block data for unit shadow (duplication)
c
c history:
c - [lsr] 09:05 thu 2-sep-1993.
c   . creation
c;;
      include 'Xglobal.par'
      include 'Xftee.def'
c
      data nshadow /0/
c
      end
      character*( * ) function xgetdir(xdir)
c
c update:   17:54 fri 15-jan-1993.
c XGetDir  -  vms: get default directory specification (+ drive)
c             dos: get default directory from default disk (no drive info)
c
c output examples:
c - vms: "bio1:[luis.flb.topc]"
c - dos: "\sub1\sub2\"
c;;
      include 'xglobal.par'
      character*( * ) xdir
c
c
c use Spindrift Utility Library "CurDir" -- returns the current directory
c on a particular drive; append "\";
c
c  call CurDir(drive, DirName)
c
      character*(stdlen) q1tmp
      integer xslen, nn, nq1
      external xslen
c
c
c get current directory and remove drive specification
      call curdir(' ', xdir)
      nn = index(xdir, ':') + 1
      xdir = xdir(nn:)
c
      nn = xslen(xdir)
      if (nn .le. 0) then
         xdir = null
      else
         if (xdir(nn:nn) .eq. '\') then
            xdir(nn + 1:) = null
         else
            xdir(nn + 1:) = '\' // null
         endif
      endif
      call up2lo(xdir, -1)
      xgetdir = xdir
c
      return
      end
      character*( * ) function xgetdisk(xdisk)
c
c update:   15:10 wed 2-mar-1994.
c XGetDisk  -  get default disk specification
c output examples:
c - vms: "bio1:"
c - dos: "c:"
c;;
      include 'xglobal.par'
c
      character*( * ) xdisk
c
c
c use Spindrift Utility Library "GetDrive" -- returns the letter of the
c current drive; append ":";
      character*1 getdrive
      external getdrive
c
ccc      include 'Blib:msdos.def'
cccc
ccc      reg$ax = DOS$GETDISK
ccc      call Intrup(Registers, 33)
cccc
ccc      Xdisk = Char(Ichar('a')+Mod(reg$ax, 256)) // ':' // NULL
ccc      call Up2lo(Xdisk, -1)
c
      xdisk = getdrive() // ':' // null
      call up2lo(xdisk, -1)
      xgetdisk = xdisk
      return
      end
      subroutine xioerr(ios)
c
c update:   fri 18:55 6-nov-1992.
c XIOERR.spg  processed by SPAG 3.14A  at 13:11 on  8 Jan 1993
c! xioerr  -  writes appropriate i/o error message to error unit
c
      include 'xglobal.par'
c
      integer ios
      character*(stdlen) xitoa
      external xerrmsg, xitoa
c
      call xerrmsg('?? Xioerr: Ios = ' // xitoa(ios))
      call xerrmsg(eol)
c
      return
      end
      subroutine xiofinis()
c
c xiofinis  -  deallocate and flush any open write-enabled buffers
c
c history:
c - [lsr] 16:56 fri 1-apr-1994.
c   . ``MaxOpen'' changed to "IOUmin,IOUmax" pair
c - 16:33 fri 11-dec-1992.
c - processed by SPAG 3.14A  at 14:50 on 26 Oct 1992
c;;
      include 'xglobal.par'
      include 'xio.inc'
c
      integer uu, ios
c
c! external modules
      external xfflush
c
      do uu = ioumin, ioumax
         if (alloc(uu)) then
            if (access(uu) .ne. zioread) call xfflush(uu)
            close (unit=uu, iostat=ios)
            alloc(uu) = .false.
            access(uu) = 0
         elseif (bp(uu) .gt. 0) then
            call xfflush(uu)
         endif
      enddo
c
      return
      end
      subroutine xioinit()
c
c xioinit  -  initialize file system and connect standard units
c
c history:
c - [lsr] 16:56 fri 1-apr-1994.
c   . ``MaxOpen'' changed to "IOUmin,IOUmax" pair
c - 09:20 fri 18-mar-1994.
c - processed by SPAG 3.14A  at 13:11 on  8 Jan 1993
c
c mon 08:50 9-nov-1992.    should use "write" or "print", rather than "Xerrmsg"
c because if there is an error so early in the game, then STDIN/STDOUT/STDERR
c are not set to their appropriate values.
c
c much to my regret, i need regular fortran carriage control for stdout, stderr
c (overprint and such).
c;;
      include 'xglobal.par'
      include 'xio.inc'
c
      character*(stdlen) xitoa
      integer ios, i1mach, uu
      integer uin, uout, uerr
c
c external modules
      external i1mach, xioerr, xitoa
c
      do uu = ioumin, ioumax    ! initialize i/o buffers         
         bp(uu) = 0
         blen(uu) = 0
         alloc(uu) = .false.
         access(uu) = 0
      enddo
c
c these definitions must correspond (precedence is given to I1mach):
c     zstdin  == i1mach(1)
c     zstdout == i1mach(2)
c     zstderr == i1mach(4)
c
      uin = i1mach(1)   ! stdin                                
      alloc(uin) = .true.
      access(uin) = zioread
      if (uin .ne. zstdin) then
         call xerrmsg('?? xioinit: i1mach(1) = ' // null)
         call xerrmsg(xitoa(uin))
         call xerrmsg('; zstdin = ')
         call xerrmsg(xitoa(zstdin))
         call xerrmsg(eol)
      endif
c
      uout = i1mach(2)  ! stdout                               
      alloc(uout) = .true.
      access(uout) = ziowrite
      if (uout .ne. zstdout) then
         call xerrmsg('?? xioinit: i1mach(2) = ' // null)
         call xerrmsg(xitoa(uout))
         call xerrmsg('; zstdout = ')
         call xerrmsg(xitoa(zstdout))
         call xerrmsg(eol)
      endif
c
c much to my regret, i need regular fortran carriage control for stderr
c (overprint and such). there is a filter in both output routines
c (xfputc, xfputstr) that will be activated when the output logical
c unit number == zstderr.  this filter will "protect" characters that are
c not fortran carriage control characters.
c
      uerr = i1mach(4)  ! stderr                               
      alloc(uerr) = .true.
      access(uerr) = ziowrite
      if (uerr .ne. zstderr) then
         call xerrmsg('?? xioinit: i1mach(4) = ' // null)
         call xerrmsg(xitoa(uerr))
         call xerrmsg('; zstderr = ')
         call xerrmsg(xitoa(zstderr))
         call xerrmsg(eol)
      endif
c
c
c  preconnects units 5 and 6 to stdin and stdout
c
      open (unit= * , status='old', iostat=ios, carriagecontrol=
     &   'FORTRAN', err=110)
c
c opening a file to the DOS device CON results in a console connection that
c cannot be redirected
c
      open (unit=uerr, file='CON', status='unknown', iostat=ios, 
     &   carriagecontrol='fortran', err=110)
c
c 09:21 fri 18-mar-1994.
c - do not include unit 0 for the time being;
      uu = 0
      alloc(uu) = .true.
      access(uu) = zioread
      return
c
  110 continue
      call xerrmsg('?? Xioinit: ' // null)
      call xioerr(ios)
c
      return
      end
      logical function xisival(ival, line, lp)
c
c XISIVAL.spg  processed by SPAG 3.14A  at 14:50 on 26 Oct 1992
c update: 17:10 fri 9-sep-1994.
c! xisival  -  get integer from input text
c
c bug:
c . [lsr] 16:57 sat 10-apr-1993.
c   will crash with "-2147483647"  ==  1 - (2**31)
c
      integer ival, lp
      character*( * ) line
c
      integer jj, nextnb, xslen, lastp, mmsign, tp
      logical have_int
      external nextnb, xslen
c
      include 'chars.def'
      include 'chars.sfn'
c
      ival = 0
      mmsign = 1
      have_int = .false.
      lastp = max(xslen(line(lp:)) + lp - 1, 0)
      lp = nextnb(line, lastp, lp)
      if (lp .le. lastp) then
         jj = lp
         if (line(jj:jj) .eq. '-') then
            mmsign = -1
            jj = jj + 1
         elseif (line(jj:jj) .eq. '+') then
            jj = jj + 1
         endif
c
         if (lp .le. lastp) then
  110       continue
            if (isdigit(line(jj:jj))) then
               ival = 10 * ival + ichar(line(jj:jj)) - ichar('0')
               have_int = .true.
               tp = jj
               jj = jj + 1
               if (jj .le. lastp) go to 110
            endif
            ival = mmsign * ival
         endif
      endif
c
      xisival = have_int
      if (have_int) lp = tp + 1
c
      return
      end
c XISNUMB.spg  processed by SPAG 3.14A  at 14:50 on 26 Oct 1992
      logical function xisnumb(rval, line, lp)
c
      real rval
      character*( * ) line
      integer lp, ival
      logical xisival, xisrval
      external xisival, xisrval
c
      if (xisrval(rval, line, lp)) then
         xisnumb = .true.
      elseif (xisival(ival, line, lp)) then
         xisnumb = .true.
         rval = float(ival)
      else
         xisnumb = .false.
         rval = 0.0e+00
      endif
c
      return
      end
      logical function xisrval(rval, line, lp)
c
c update: 17:10 fri 9-sep-1994.
c XISRVAL.spg  processed by SPAG 3.14A  at 14:50 on 26 Oct 1992
c! xisrval  -  get a real number from input text; integers will not be decoded;
c
c real number is of the form:  cccc.dddde+00
c let
c . vint:   truth of "`cccc` part detected"
c . vdec:   truth of "`dddd` part detected"
c . vexp:   truth of "exponent part detected"
c . *   :   logical "and"
c . +   :   logical "or"
c
c a real would be detected if :
c   vreal = vint * vdec  +  vint * vdec * vexp
c           vint * vexp  +  vdec  +  vdec * vexp
c which reduces to:
c   vreal = vint * vexp  +  vdec
c
c tp: last accepting position
c
      real rval
      integer lp
      character*( * ) line
c
      integer tp, jj, nextnb, xslen, lastp, exponent, mmsign, esign, nd
      real val, power
      logical vint, vdec, vexp, ok
      external nextnb, xslen
c
      include 'chars.def'
      include 'chars.sfn'
c
      val = 0.0e+00
      mmsign = 1
      esign = 1
      power = 1.0
      exponent = 0
      vint = .false.
      vdec = .false.
      vexp = .false.
      rval = 0.0e+00
c
      lastp = max(xslen(line(lp:)) + lp - 1, 0)
      lp = nextnb(line, lastp, lp)
      jj = lp
      tp = jj
c
      if (jj .le. lastp) then
         if (line(jj:jj) .eq. '-') then
            mmsign = -1
            jj = jj + 1
         elseif (line(jj:jj) .eq. '+') then
            jj = jj + 1
         endif
c
         if (jj .le. lastp) then
            if (isdigit(line(jj:jj))) then      ! integer part ?        
               vint = .true.
  110          continue
               val = 10.0 * val + ichar(line(jj:jj)) - ichar('0')
               tp = jj
               jj = jj + 1
               if (jj .le. lastp) then
                  if (isdigit(line(jj:jj))) go to 110
               endif
c
               if (jj .gt. lastp) go to 140
c                               ! only integers and end of string ==> no real
            endif
c
            if (line(jj:jj) .eq. '.') then
c                                      ! decimal part ?
               nd = 0   ! number of digits after decimal point
               tp = jj
               jj = jj + 1
  120          continue
               if (jj .le. lastp) then
                  if (isdigit(line(jj:jj))) then
                     val = 10.0 * val + ichar(line(jj:jj)) - ichar('0')
                     power = 10.0 * power
                     nd = nd + 1
                     tp = jj
                     jj = jj + 1
                     go to 120
                  endif
               endif
c
c found a period: it is part of a real number only if it has leading
c digits (vint == .true.) or trailing digits (nd > 0);
c
               if (nd .gt. 0) then
                  vdec = .true.
               else
                  vdec = vint
               endif
               if ( .not. vdec) tp = tp - 1
            endif
c
c try get optional exponent only if we have the integer or decimal part of
c the number;
c
            ok = (vint .or. vdec)
            if (ok) then
               if (jj .le. lastp) then
                  if (index('eEdDqQ', line(jj:jj)) .gt. 0) then
c                                                      ! e,d,q exponent
                     jj = jj + 1
                     if (jj .le. lastp) then
                        if (line(jj:jj) .eq. '-') then
                           esign = -1
                           jj = jj + 1
                        elseif (line(jj:jj) .eq. '+') then
                           jj = jj + 1
                        endif
                        if (jj .le. lastp) then
  130                      continue
                           if (isdigit(line(jj:jj))) then
                              exponent = 10 * exponent + 
     &                           ichar(line(jj:jj)) - ichar('0')
                              vexp = .true.
                              tp = jj
                              jj = jj + 1
                              if (jj .le. lastp) go to 130
                           endif
                        endif
                     endif
                  endif
               endif
            endif
         endif
      endif
c
  140 continue
      xisrval = ((vint .and. vexp) .or. vdec)
      if (xisrval) then
         lp = tp + 1
         rval = (mmsign * val / power) * 10.0 ** (esign * exponent)
      endif
c
      return
      end
      character*( * ) function xitoa(ival)
c
c! xitoa  -  convert integer to string
c processed by SPAG 3.14A  at 14:50 on 26 Oct 1992
c
      include 'xglobal.par'
c
      integer ival
      character*16 buffer
      integer jj, nn, mmsign
c
      if (ival .ne. 0) then
         if (ival .lt. 0) then
            mmsign = -1
         else
            mmsign = 1
         endif
c
         nn = abs(ival)
         buffer(16:16) = null
         jj = 16
         do while (nn .gt. 0)
            jj = jj - 1
            buffer(jj:jj) = char(mod(nn, 10) + ichar('0'))
            nn = nn / 10
         enddo
         if (mmsign .eq. -1) then
            jj = jj - 1
            buffer(jj:jj) = '-'
         endif
         xitoa = buffer(jj:16)
c
      else
         xitoa = '0' // null
      endif
c
      return
      end
      subroutine xmypath(found, exepath, nex)
c
c update:   11:35 sat 5-mar-1994.
c Xmypath.spg  processed by SPAG 3.14A  at 11:07 on  8 Jan 1993
c
c purpose:  determine the full path of the currently executing program
c
c output variables:
c . found   (logical); truth of "path to exe found"
c . exepath (character*(*)); the path, if found == .true.
c . nex     (integer); number of characters in "exepath", if found == .true.
c
c modules called:
c NONE
c
c algorithm:
c . the spindrift utility library subroutine "mypath" determines the fully
c   qualified path to the currently executing program. the fully qualified path
c   includes the drive letter and full path, including a trailing "\", e.g.,
c     "C:\FGETS3\"
c
c . the interacter library subroutine "OSVAR" determines the value
c   of a given environmental variable; letter case is VERY important:
c        call Osvar('FGETSDIR', patnam)
c   is up to the user to ensure that the variable was set;
c
      include 'Xglobal.par'
c
      character*( * ) exepath
      logical found
      integer nex
c
c
      integer*2 iserror, i2val
      external iserror
      integer ii, jj
c
      call mypath(exepath)      ! Spindrift Code           
      i2val = iserror()
      if (i2val .eq. 0) then
         nex = index(exepath, ' ') - 1
         found = (nex .gt. 0)
      else
         nex = 0
         exepath = ' '
         found = .false.
      endif
c
ccc      call Osvar('FGETSDIR', Exepath)           ! Interacter Code
ccc      call Locstr(Exepath, ii, jj)
ccc      if ((ii .gt. 0) .and. (jj .gt. 0)) then
ccc         call Collapse(Exepath, -1, Nex)
ccc         Found = (Nex .gt. 0)
ccc      else
ccc         Nex = 0
ccc         Exepath = ' '
ccc         Found = .false.
ccc      endif
c
      return
      end
      logical function xsamefil(lun1, lun2)
c
c update:   18:14 sat 6-mar-1993.
c determine if two logical unit numbers point to the same file.
c this is generally not a problem unless STDOUT and STDERR are involved;
c
c this is purely a vms function;
c
      integer lun1, lun2
c
      logical areq
c
c if they have the same number, look no further
c
      if (lun1 .eq. lun2) then
         areq = .true.
         go to 110
      endif
c
c
  110 continue
      xsamefil = (areq)
      return
      end
      integer function xslen(wbuf)
c
c xslen - determine length of string;
c trailing tabs, blanks, and nulls will be ignored.
c history:
c . processed by SPAG 3.14A  at 14:51 on 26 Oct 1992
c . update: thu 15:55 15-oct-1992.
c;;
      character*( * ) wbuf
      integer nn
c
      include 'chars.def'
      include 'chars.sfn'
c
      nn = index(wbuf, char(0))
      if (nn .gt. 0) then
         nn = nn - 1
      else
         nn = len(wbuf) + 1
  110    continue
         nn = nn - 1
         if (nn .gt. 0) then
            if (uwhite(wbuf(nn:nn))) go to 110
         endif
      endif
      xslen = nn
c
      return
      end
      subroutine xwrap(jout, xline, nlen, cwide)
c
c update:   thu 11:41 11-jun-1992.
c print a line "cwide" columns wide; if the xline is longer than "cwide"
c characters, split a xline at the first Blank, starting at column "cwide";
c print the remaining line(s) with the indentation of the first line;
c
c notes:
c - since most of the time the line will be short,
c   process that case individually (for speed) .
c
c - examples:  !        10        20        30
c              !123456789=123456789=123456789=
c   * xline  = 'abjfdh lkjcjkl  kkjfkljkkf'
c     cwide = integer in [15 .. 25]
c     output: 2 lines
c         'abjfdh lkjcjkl'
c         'kkjfkljkkf'
c
c             !        10        20        30
c             !123456789=123456789=123456789=
c   * xline  = 'abjfdh lkjcjkl  kkjfkljkkf'
c     cwide = integer .ge. 26
c     output: 1 line
c         'abjfdh lkjcjkl  kkjfkljkkf'
c
c - notes
c   * if the line is "solid" (i.e., no blanks), it will be split at "cwide";
c   * bug: if "cwide" occurs within a quoted string, well, that's too bad;
c
c - modules:
c   Xslen:   length of string, trailing blanks ignored;
c   Xwrap:   wrap a line
c   Xwrap0:   auxilliary module for "Xwrap"
c   Nextnb:   position of next non-Blank character
c
c internal variables
c    rmc   right most column
c;;
      integer stdlen
      parameter (stdlen = 80)
c
      character*( * ) xline
      integer jout, nlen, cwide
c
      integer np1, np2, maxc, npk, nf1, nf2, xwrap0, nextnb
      logical done, xfirst
      external xwrap0, nextnb
c
 9110 format (1x,a,a)
c
c handle empty lines first.
c
      if (nlen .le. 0) then
         write (jout, *)
         go to 120
      endif
c
c maxc:        width of output, "-1" for "1x" in format
c Nf1, Nf2:    indentation limits of the first line
c
      maxc = cwide - 1
      if (maxc .le. 0) maxc = stdlen - 1
      nf1 = 1
      nf2 = nextnb(xline, nlen, nf1) - 1
      np1 = 1
      xfirst = .true.
c
  110 continue
      done = (np1 .gt. nlen)
      if ( .not. done) then
         npk = min(np1 + maxc - 1, nlen)
         np2 = xwrap0(xline, nlen, np1, npk)
         if (np2 .le. 0) np2 = npk
         if (xfirst) then
            write (jout, 9110) xline(np1:np2)
            xfirst = .false.
         else
            if (nf1 .le. nf2) then
               write (jout, 9110) xline(nf1:nf2), xline(np1:np2)
            else
               write (jout, 9110) xline(np1:np2)
            endif
         endif
         np1 = nextnb(xline, nlen, np2 + 1)
         go to 110
      endif
c
  120 continue
      return
      end
      integer function xwrap0(xline, nlen, nfirst, nlast)
c
c update:   thu 11:41 11-jun-1992.
c purpose:
c - given that the xline is too long, determine where it
c   should be split; xline is defined starting at "nfirst"
c   and ending at "nlast" .
c
c - examples: !        10        20        30
c             !123456789=123456789=123456789=
c   * xline = 'abjfdh lkjcjkl  kkjfkljkkf'
c     nfirst = 8
c     nlast  = integer in [15 .. 25]
c     ==> Xwrap0 = 14
c     (presumably, Xwrap0 = 6 at a previous call)
c
c             !        10        20        30
c             !123456789=123456789=123456789=
c   * xline = 'abjfdh lkjcjkl  kkjfkljkkf'
c     nfirst = 8
c     nlast  = 26
c     ==> Xwrap0 = 26
c     (length of xline = nlast ==> no need to split.)
c
c - notes
c   * if the line is "solid" (i.e., no blanks), Xwrap0 = 0;
c   * bug: if "nlast" occurs within a quoted string, well, that's too bad;
c;;
      character*( * ) xline
      integer nlen, nfirst, nlast
c
      integer npk, xslen
      logical done, found
      external xslen
c
      logical uwhite
      character*1 carg1
      uwhite(carg1) = (carg1 .eq. ' ')
c
c at all times (npk .lt. Len(xline)); if this is not the case, pass the buck.
c
      npk = min(nlast, nlen)
      if (npk .lt. len(xline)) then
         found = (uwhite(xline(npk + 1:npk + 1)))
      else
         found = .false.
      endif
c
  110 continue
      done = ((npk .lt. nfirst) .or. (found))
      if ( .not. done) then
         found = (uwhite(xline(npk:npk)))
         if ( .not. found) then
            npk = npk - 1
         endif
         go to 110
      endif
c
c if found a Blank, then find the first non-Blank in this
c run of blanks (see example above).
c
      if (found) then
         if (npk .gt. 0) npk = xslen(xline(1:npk))
      else
         npk = 0
      endif
      xwrap0 = npk
c
      return
      end
      logical function xxinit(done)
c
c update: 13:34 sat 5-mar-1994.
c XXINIT.spg  processed by SPAG 3.14A  at 13:11 on  8 Jan 1993
c purpose:
c    - initialize [LSR] packages.
c
c updates:
c    - [LSR] oct/85
c    - [LSR] 12:35:09.17 saturday january 31, 1987.
c      substitute/unit03/untini/wh
c    - [lsr] 08:03:06.89 thursday october 5, 1989.
c      made compatible with "xlib" system
c    - [lsr] tue 16:44 8-sep-1992.
c      add generic error message handler
c    - thu 14:55 15-oct-1992.
c      create for Lahey
c
c description of the arguments:
c input:
c    *none*
c
c output:
c    Xxinit - logical variable:
c             .true.  ==> all is well; initialization completed
c                         successfully.
c             .false. ==> initialization not completed. no
c                         error number is returned.
c    done   - same as Xxinit
c
c plans for the future:
c    - none for the time being
c
      logical done
c
      integer i1mach, stderr
      external i1mach
c
c
c standard error unit
      stderr = i1mach(4)
c
c initialize xfile i/o
      call xioinit()
c
c
      done = .true.
      xxinit = done
c
      return
      end
      subroutine zdecod(zargs, nargs, option, nopti)
c
c update: 17:34 fri 4-mar-1994.
c
c this subroutine decodes command line(s) for unix like input
c;;
      include 'xglobal.par'
      include 'chem.par'
      include 'idfiles.def'
      include 'options.def'
c
c declarations of subroutine's formal parameters
c
      character*( * ) zargs( * )
      integer nargs, nopti
      logical option( * )
c
      integer xslen, nxtarg, np, nn, jpos
      logical defopt
      external xslen
c
      jpos = 1
      nxtarg = 1
      if (zargs(nxtarg)(1:1) .ne. '!') then
         pgmfil = zargs(nxtarg)
         call up2lo(pgmfil, -1)
         nxtarg = nxtarg + 1
      else
         nxtarg = nargs + 1
      endif
c
  110 continue
      if (nxtarg .le. nargs) then
         call up2lo(zargs(nxtarg), -1)
         if (zargs(nxtarg)(1:2) .eq. '-i') then
            option(ichar('i')) = .true.
            np = 3
            call gtstr(zargs, nargs, np, nxtarg, infil)
            call up2lo(infil, -1)
c
         elseif (zargs(nxtarg)(1:2) .eq. '-o') then
            option(ichar('o')) = .true.
            np = 3
            call gtstr(zargs, nargs, np, nxtarg, outfil)
            call up2lo(outfil, -1)
c
         elseif (zargs(nxtarg)(1:2) .eq. '-s') then
            option(ichar('s')) = .true.
            xtiming = .true.
            nxtarg = nxtarg + 1
c
c -u? where "?" :: ("y" | "n" | "+" | "-")
c
         elseif (zargs(nxtarg)(1:2) .eq. '-u') then
            np = 2
            defopt = .true.
            call swyn(zargs, nargs, option, nopti, nxtarg, np, defopt)
c
         elseif ((zargs(nxtarg)(1:2) .eq. '--') .or. (
     &      zargs(nxtarg)(1:1) .eq. '!')) then
            nxtarg = nargs + 1
c
         elseif (zargs(nxtarg)(1:1) .eq. '-') then
            call switch(zargs, nargs, option, nopti, nxtarg)
c
         elseif (jpos .eq. 1) then      ! it is the input file name
            option(ichar('i')) = .true.
            np = 1      ! start decoding at position 1 !
            call gtstr(zargs, nargs, np, nxtarg, infil)
            call up2lo(infil, -1)
            jpos = jpos + 1
c
         else
            call uotty(' ', 1)
            nn = max(1, xslen(zargs(nxtarg)))
            write (stdout, 9110) zargs(nxtarg)(1:nn)
 9110       format (' ?? subroutine Zdecod: unknown option(s): ',a)
            stop '?? Zdecod: unknown option'
         endif
         go to 110
      endif
c
      return
      end
      subroutine zeroin(ax, bx, f, tol, ierr, fzero)
c
c a zero of the function  F(x)  is computed in the interval Ax,Bx ;
c
c history:
c . gotten from ftp://netlib.att.com/netlib/go/seroin.f.Z  on  18.aug.1994;
c . processed by SPAG 4.50I  at 11:59 on 19 Aug 1994
c . modifications [lsr]:
c   - the original module was a function; now a subroutine;
c   - arguments added
c     Ierr - see below;
c     Fzero - see below;
c   - documentation altered to reflect modifications;
c   - uses module "Trne" to determine if two real numbers are equal
c
c  input..
c
c  Ax     left endpoint of initial interval
c  Bx     right endpoint of initial interval
c  F      function subprogram which evaluates F(x) for any x in
c         the interval  Ax,Bx
c  Tol    desired length of the interval of uncertainty of the
c         final result (.ge.0.0)
c
c  output..
c  Ierr   error flag;
c         0: no error
c         1: error: F(Ax) and F(Bx) do not have different signs;
c  Fzero  abscissa approximating a zero of  F  in the interval Ax,Bx;
c           originally returned in "Zeroin";
c
c
c      it is assumed that   F(Ax)   and   F(Bx)   have opposite signs
c  this is checked, and an error message is printed if this is not
c  satisfied. Zeroin returns a zero  x  in the given interval Ax,Bx
c  to within a tolerance  4*macheps*abs(x)+Tol, where macheps  is
c  the  relative machine precision defined as the smallest representable
c  number such that  1.0+macheps .gt. 1.0;
c      this function subprogram is a slightly modified translation of
c  the algol 60 procedure zero given in richard brent, algorithms for
c  minimization without derivatives, prentice-hall, inc. (1973).
c;;
      real ax, bx, f, tol, fzero
      integer ierr
c
      real a, b, c, d, e, eps, fa, fb, fc, tol1, xm, p, q, r, s
      real r1mach
      logical trne
      external r1mach, trne
c
      ierr = 0
      eps = r1mach(4)
      tol1 = eps + 1.0e0
      fzero = 0.0e0
c
      a = ax
      b = bx
      fa = f(a)
      fb = f(b)
c
c check that F(Ax) and F(Bx) have different signs
c
      if (trne(fa, 0.0e0) .and. trne(fb, 0.0e0)) then
         if (fa * (fb / abs(fb)) .gt. 0.0e0) then
            ierr = 1
         endif
      endif
c
  110 continue
      c = a
      fc = fa
      d = b - a
      e = d
c
  120 continue
      if (abs(fc) .lt. abs(fb)) then
         a = b
         b = c
         c = a
         fa = fb
         fb = fc
         fc = fa
      endif
c
      tol1 = 2.0e0 * eps * abs(b) + 0.5e0 * tol
      xm = 0.5e0 * (c - b)
      if ((abs(xm) .gt. tol1) .and. trne(fb, 0.0e0)) then
c
c see if a bisection is forced
c
         if ((abs(e) .ge. tol1) .and. (abs(fa) .gt. abs(fb))) then
            s = fb / fa
            if (trne(a, c)) then
c
c inverse quadratic interpolation
c
               q = fa / fc
               r = fb / fc
               p = s * (2.0e0 * xm * q * (q - r) - (b - a) * (r - 1.0e0)
     &            )
               q = (q - 1.0e0) * (r - 1.0e0) * (s - 1.0e0)
            else
c
c linear interpolation
c
               p = 2.0e0 * xm * s
               q = 1.0e0 - s
            endif
            if (p .le. 0.0e0) then
               p = -p
            else
               q = -q
            endif
            s = e
            e = d
            if (((2.0e0 * p) .ge. (3.0e0 * xm * q - abs(tol1 * q))) .or.
     &         (p .ge. abs(0.5e0 * s * q))) then
               d = xm
               e = d
            else
               d = p / q
            endif
         else
            d = xm
            e = d
         endif
         a = b
         fa = fb
         if (abs(d) .gt. tol1) then
            b = b + d
         elseif (xm .le. 0.0e0) then
            b = b - tol1
         else
            b = b + tol1
         endif
         fb = f(b)
         if ((fb * (fc / abs(fc))) .le. 0.0e0) go to 120
         go to 110
      endif
c
      fzero = b
      return
      end
