@ECHO OFF
CLS
GOTO START
REM  ****************** \HSCTM2D\HSCTM2D.BAT *********************
REM  *       Author: D.W. Disney, Senior Systems Analyst         *
REM  *               OAO Corporation                             *
REM  *         Date: Thursday, 20 November 1997.  Time: 14:09:04.*
REM  *  Environment: Microway 486 B2T/66, DOS 6.00               *
REM  * Installation: OAO Corporation                             *
REM  *               U.S. Environmental Protection Agency        *
REM  *               NERL - Ecosystems Research Div., Athens, GA *
REM  *     Function: Execute HSCTM2D model from DOS command line *
REM  *     Calling                                               *
REM  *     Sequence: HSCTM2D                                     *
REM  *        Input: Command line: none                          *
REM  *                      Other: none                          *
REM  *************************************************************
REM  ----- Label START ------------------------------------------------------
:START
IF "%1"=="DEBUG" GOTO CHECKEXE
IF "%1"=="debug" GOTO CHECKEXE
IF EXIST instpath\XHSCTM2D.EXE GOTO RUNHSCT1
GOTO ERROR1
REM  ----- Label CHECKEXE ---------------------------------------------------
:CHECKEXE
IF EXIST \HSCTM2D\XHSCTM2D.EXE GOTO RUNHSCT1
REM  ----- Label ERROR1 -----------------------------------------------------
:ERROR1
ECHO #
ECHO # ----------------------------------------------------------------------
ECHO #
ECHO ##  ERROR:  BAD OR MISSING XHSCTM2D.EXE FILE
ECHO #
ECHO #           The HSCTM2D executable task image file XHSCTM2D.EXE is
ECHO #           not located in DOS sub-directory instpath.
ECHO #
ECHO #           Install and/or copy this file and all of its support
ECHO #           files to sub-directory instpath or contact
ECHO #           CEAM (ceam@epamail.epa.gov) for assistance.
ECHO #
ECHO #   Press "<Enter>" key to return to DOS command prompt.
PAUSE >NUL
GOTO STOP
REM  ----- Label RUNHSCT1 ---------------------------------------------------
:RUNHSCT1
IF "%1"=="DEBUG" TYPE \HSCTM2D\HSCTOPEN.SCR
IF "%1"=="debug" TYPE \HSCTM2D\HSCTOPEN.SCR
IF "%1"=="DEBUG" PAUSE >NUL
IF "%1"=="debug" PAUSE >NUL
IF "%1"=="DEBUG" GOTO TYPESCR
IF "%1"=="debug" GOTO TYPESCR
TYPE instpath\HSCTOPEN.SCR
PAUSE >NUL
REM  ----- Label TYPESCR ----------------------------------------------------
:TYPESCR
CLS
ECHO #
ECHO #----------------------------------------------------------------------#
ECHO ##  Executing HSCTM2D DOS command file.
ECHO #----------------------------------------------------------------------#
ECHO #
ECHO #
ECHO ##  Loading HSCTM2D model task image file...wait.
REM
IF "%1"=="DEBUG" SET LFDIR=D:\F77L3\BIN\
IF "%1"=="debug" SET LFDIR=D:\F77L3\BIN\
IF "%1"=="DEBUG" GOTO RUNHSCTM
IF "%1"=="debug" GOTO RUNHSCTM
SET LFDIR=instpath
REM  ----- Label RUNHSCTM ---------------------------------------------------
:RUNHSCTM
IF "%1"=="DEBUG" \HSCTM2D\XHSCTM2D
IF "%1"=="debug" \HSCTM2D\XHSCTM2D
IF "%1"=="DEBUG" GOTO ENDRUN
IF "%1"=="debug" GOTO ENDRUN
ECHO #
ECHO #------------------------#
ECHO ##  HSCTM2D run beginning.
ECHO #------------------------#
ECHO #
ECHO #                                    >>HSCT_RUN.LOG
ECHO # ----- RUN DATE/TIME STAMP ----- #  >>HSCT_RUN.LOG
ECHO # ----- Begin Execution     ----- #  >>HSCT_RUN.LOG
IF NOT "%1"=="" ECHO #                    >>HSCT_RUN.LOG
IF NOT "%1"=="" ECHO # ----- Data set: %1 >>HSCT_RUN.LOG
ECHO #                                    >>HSCT_RUN.LOG
DATE <instpath\RETURN1.ANS | FIND "C" >>HSCT_RUN.LOG
TIME <instpath\RETURN1.ANS | FIND "C" >>HSCT_RUN.LOG
ECHO #                                    >>HSCT_RUN.LOG
REM CLS
instpath\XHSCTM2D %1
ECHO #                                   >>HSCT_RUN.LOG
ECHO # ----- End Execution       ----- # >>HSCT_RUN.LOG
ECHO #                                   >>HSCT_RUN.LOG
DATE <instpath\RETURN1.ANS | FIND "C" >>HSCT_RUN.LOG
TIME <instpath\RETURN1.ANS | FIND "C" >>HSCT_RUN.LOG
ECHO #                                   >>HSCT_RUN.LOG
ECHO # --------------------------------------------------- # >>HSCT_RUN.LOG
REM
REM  ----- Label ENDRUN -----------------------------------------------------   
:ENDRUN
SET LFDIR=
ECHO.
ECHO ##  HSCTM2D program execution complete.
IF "%1"=="DEBUG" ECHO #   Press "<Enter>" key to return to DOS command prompt.
IF "%1"=="debug" ECHO #   Press "<Enter>" key to return to DOS command prompt.
IF "%1"=="DEBUG" PAUSE >NUL
IF "%1"=="debug" PAUSE >NUL
GOTO FINISH
REM  ----- Label STOP -------------------------------------------------------   
:STOP
ECHO.
IF "%1"=="DEBUG" GOTO FINISH
IF "%1"=="debug" GOTO FINISH
CLS
REM  ----- Label FINISH -----------------------------------------------------   
:FINISH
