************************************************************************
*     Include File
************************************************************************
*
*     hsctm.inc
*
*------- Definition of parameters --------------------------------------
*
*     MEL = maximum number of elements
*     MND = maximum number of nodes 
*     NIV = number of independent variables
*     MR1 = maximum number of equations
*     MFW = maximum front width
*     NBS = maximum buffer size
*     MPB = maximum print buffer
*     MCC = maximum number of continuity check lines        
*     MCCN = maximum number of nodes per continuity check line
*     MAXSTRM = maximum number of storms
*     INL = number of unconsolidated bed layers
*     ILL = number of partially consolidated bed layers
*     NELZ = maximum number of elements to record time histories
*     NCYS = number of time steps
*-
      PARAMETER (MND=4365, MEL=1490, MR1=30000, MFW=400, NBS=600000,
     &           MPB=30000, MCC=10, MCCN=50, MXSTRM=1)
      PARAMETER (INL=9, ILL=9, IOL=9, NIV=8)
      PARAMETER (IZ1=INL+1, IL1=ILL+1, IL2=IOL+1, NIU=NIV-3)
      PARAMETER (NELZ=10, NCYS=10000)
      PARAMETER (POR=0.2, DIA=0.000004)
      PARAMETER (IFILE=60, NLL=62)
*      PARAMETER (SSDCRT=0.0050E0, USDCRT=0.0050E0)
*-
      CHARACTER*77 TITLE, TGFGEN
*-
      COMMON /LAB/ TITLE, TGFGEN
*-
      COMMON /BLKA/  NP,NE,IHOTN,NDF,NCN,NMAT,NSZF,LI,MAXN,NPR,ICT,
     &               MBAND,IHOTO,NCL,GRAV,ROAVG,OMEGA,IFINO,NITI,NITN,
     &               METRIC,NCBC,ICYC,DELT,TMAX,ALTM,CHI,FACT,URF,
     &               TET,NEM,NPM,NITSV,NCYC,NSCR,IGEON,IBUP,INOLD,
     &               IOUT,IDNORD,IVRSID,IDNOPT,IDEN,IC24,IBCSET,KBCTS,
     &               IVOUT,FCOEF,ISWIT,LPCBP,IOSTEP
*-
      COMMON /BLKB/  CORD(MND,2),NBC(MND,NIV),VEL(3,MND),SPEC(MND,NIV),
     &               ALFA(MND),AO(MND),SIGMA(MND,2),VOLD(3,MND),
     &               VDOT(3,MND),NOP(MEL,8),IMAT(MEL),ORT(MEL,12),
     &               NFIXH(MND),NFIX(MND),NLOC(MND),VDOTO(3,MND),
     &               TH(MEL),CHEZ(MEL),ZMANN(MEL),NDRY(MND),
     &               NFIXP(MND),WIDTH(MND),XAREA(MEL),IMATO(MEL),
     &               NDRYO(MND),IPT(MND),WIDS(MND),LISTEL(MEL),NC(MEL),
     &               DREC(MND),DIR(MND),NCORN(MEL),SS1(MND),SS2(MND),
     &               ADIF(MND),SIDF(MEL),IHORD(MEL),ADB(MND),ADT(MND),
     &               ADO(MND),AKP(MND),HEL(MND),HOL(MND),HDET(MND),
     &               HDOT(MND),WSEL(MND),AOO(MND),TVOL(MEL),
     &               TA(MND),TW(MND),IDMN(MND)
*-
      COMMON /BLKD/  LINE(MCC,MCCN),LMT(MCC),STQ(MCC),STQA(MCC),
     &               STQE(MCC),STQC(MCC),STQT(MCC),ALN(MCC),
     &               NDSWT(MCC),ISTLIN(MND),TAREA(MCC)
*-
      COMMON /BLKDD/ DSET,DSETD,IFLG,ITRMAX
*-
      COMMON /BIGONE/ EQ(MFW,MFW)
*-
      COMMON /BUFFR/ LBMAX,LCS(MR1),LPS(MR1),LQ,LHS(NBS),QS(NBS),
     &               LHED(MFW),JMOD(MFW),
     &               QQ(MFW),PVKOL(MFW),MAXFIL
      COMMON /BLIN/  YSLP(MND),XSLP(MND),IBN(MND),
     &               ALFAK(MND),NFIXK(MND)
      COMMON /CSTCT/ NJT(100),AJ(100),BJ(100),CJ(100),
     &               GAMJ(100),QD(100)
*-
      COMMON /PRHYD/ JCR(MCC),AC1X(MCC),AC2X(MCC),AC3X(MCC),
     &               AC4X(MCC),AC5X(MCC),JCH(MCC),HFX(MCC),
     &               JCQ(MCC),QF(MCC),QDIR(MCC), IBR(MCC), JBQE(MCC),
     &               TAX(MND),TWX(MND),KNBX(MND),TBINRY(MND),
     &               WDMC1(MND),WDMC2(MND),WDMC3(MND),WDMC4(MND),
     &               IFLZ1(MEL),IFLZ2(MEL),FLZ3(MEL),FLZ4(MEL),
     &               FLZ5(MEL),FLZ6(MEL),FLZ7(MEL),OMEGAS(MEL),
     &               ISS,WC1X,WC2X,WC3X,WC4X,IWMX,
     &               NPX,NBX,NWID,NSID,IPRT,IWIND,KWIND,WSFACT,IRO,
     &               IRSLP,IQGEN,IHGEN,ISTGEN,NCFLW,IBIN,IBATCH,
     &               ELEV,XSCALE,ZSCALE,UNOM,HMIN,NSTART,
     &               IHOE,TEMPC,MAXE,IECHO,NTBIN,INHEC,USERCA,
     &               IRVIZ,IRVOLD,SSDCRT,USDCRT,STPCRT,NTBN
*-
      COMMON  /STRM/ NSTORM, ISTYPE(MXSTRM),WNDMAX(MXSTRM), WNDMIN,
     &               NREF(MXSTRM),TREF(MXSTRM),SSPD(MXSTRM),
     &               THETAS(MXSTRM),THETAK(MXSTRM),BETAL(MXSTRM),
     &               BETAT(MXSTRM),WX(MXSTRM),WY(MXSTRM),
     &               DECAY(MXSTRM)
*-    
      COMMON /MISC/  R1(MR1),NDROP(MND),NLSTEL(MR1)
*-
      COMMON /PRINT/ KOUNTR,ITSI,IPLI,ISPRT,JSPLPT,TT(MPB),NSPLPT(MPB),
     &               SPVELX(MPB),SPVELY(MPB),SPVELT(MPB),SPQ(MPB),
     &               SPDEP(MPB),SPELEV(MPB),NSPREF(MND),
     &               SPCRDX(MPB),SPCRDY(MPB),ITRACE
*-
*-    DATA MANAGEMENT REQUIREMENTS
      COMMON /DMSCHR/ BANGFG(15),VERRM2(4),STAMP,DESC(2),
     &                BANRM2(15),BANHTN(15),CHKDMS,RECRD
      COMMON /DMSREC/ IREC(40),FREC(40),IHOT(40),FHOT(40), 
     &                IPACKB(1200),IPACKT(77),IPACKH(1200)
      COMMON /LOGICS/ ONCE
      CHARACTER       CHKDMS*6,RECRD*6,BANGFG*80,BANRM2*80,BANHTN*80,
     &                VERRM2*40,STAMP*80,DESC*80  
*-
      COMMON /NEW/ INT1,INT2,INT3,LP2,LPDR2,ND1,ND2
*-
      COMMON/FILES/IN,LP,INA,INB,INC,IND,INF,ING,INI,IIN,INS,   
     &             INSS,ISZ,IN5,INBC,IDEFAU,IX,IBED,IS,IN8
*-
      COMMON /CONT/ TITLF(19),NCON,NOPT,NSTEP,NTEP,MAXP
*-
      COMMON /SLOP/ SLOPE(MND),MSN(MND)
*-
      COMMON /CONC/ CNC(MND,NIU),CNCO(MND,NIU),CNT(MND,NIU),
     &              CBP(MND,3),TC(MEL,5),CBEL(MEL,3),CINT
*-
      COMMON /CONS/ ADENO(MEL),AP,ALAMDA,TCC,FMBDO,AI,TCINO,BI,
     &              BETAO,DELTO,ADEN,AQ,BQ,EQW,FQ,PQ,SQQ,TAL,TAB
*-
      COMMON /BOUN/ SPECO(MND,NIV),
     &              MFIX(MND,NIU),NFIZ(MND,NIU),NFIZH(MND,NIU)
*-
      COMMON /MISX/ R2(MND,NIU),NLEFT(MND),NRIGHT(MND)
*-
      COMMON /COM/ DEN(MND),DEPO(MND),TH9(MEL),BDM(MEL),AT(MEL),
     &             TMAS(MEL),TMASOLD(MEL)
*-
      COMMON /INBED/ THICK(9,MEL,ILL),SST(9,MEL,IL1),GADT(9,MEL,IL1),
     &    GBT(9,MEL,IL1),SSTO(MEL,10),EROCON(MEL,10),GBO(MEL,10),
     &    THICKO(MEL,10),GADO(MEL,10),BEDEL(MEL),EPSLON(10),
     &    AFLA(10),NLAY(9,MEL),NLAYO(MEL)
*-
      COMMON /PROPS/ THICKM(MEL,10),SSTM(MEL,10),GADTM(MEL,10),
     &               GBTM(MEL,10),AVERAT(MEL),TLAY(10),GAD(10),
     &               SS(10),GB(10),SSM(10),GBM(10),TLAYM(10),
     &               GADM(10),TAUBMN,GAW,GAC,UN,IVCOP(MND),IV(MND),      
     &               IVT(MEL),IVCON(MEL),NLAYM(MEL),NLAYTM,NLAYT
*-
      COMMON /SALPRP/ GDM(MEL,10),GM(MEL,10),SM(MEL,10),SD(MEL,10),
     &                GD(MEL,10),GBB(MEL,10),ESAL(MEL),ESALO(MEL),
     &                ESALOO(MEL),EDEN(MEL),EDENO(MEL),EDENOO(MEL)
*-
      COMMON /TIMES/ TIM(NCYS),TETZ(MND),TDP(MND),ETIM(MEL),TDE(MEL),
     &               DTIM(MEL),TETA,IFF(NCYS,2),NOCR(MEL)
*-
      COMMON /TIMHI/ TECON(NELZ,NCYS),TEVEL(NELZ,NCYS),TEDR(NELZ,NCYS),
     &             TEMER(NELZ,NCYS),TESER(NELZ,NCYS),TEDMAS(NELZ,NCYS),
     &               TEBOT(NELZ,NCYS),NELH(NELZ)
*-
      COMMON /SED/ DIF(MND,3),ALPHA1(MND,1),BSHEAR(MND),WS(MND,1),
     &             UST(MND),ALPHA2(MEL),EDOT(MEL),TMD(MEL),ANET(MEL),
     &             FLUX(MEL),DOWN(MEL)
*-
      COMMON/ELFAN/ ESTO(NIU,MEL,8,8),FO(MEL,8),QK(MEL,8),ESTIFM(8,8),
     &              T(8,8),BEDLL(MND),CBPART(MND),BEDL(MEL),F(8)
*-
      COMMON /CODE/ IVCOD(NCYS),ISVS(NCYS),IDIF(NCYS),
     &              ISORS(NCYS),IFLAG(MEL),IFGZ(MEL),
     &              ISTP(MND),ISTE(MEL),NELE
*-
      COMMON /ELAV/ EXV(MEL),EYV(MEL),EDEP(MEL),ECONC(MEL),EUSTAR(MEL),
     &              ESR(MEL)
*-
      COMMON /RA/ BSO(MND),EELEV(MEL),ESRO(MEL),TM(MEL),TMBC(MEL)
*-
      COMMON /EROZ/ ALFN(MEL,10),EPSN(MEL,10)
*-
      COMMON /SHAPE/ EN(8,9),DNDS(8,9),DNDE(8,9),EM(3,3),
     &               DM(3,3),EL(MEL),WT(9),QP(3),QW(3),NGAUSS
*-
      COMMON /TSHAP/ SZ(6,7),SX(6,7),SY(6,7),QX(7),QY(7),QWT(7),NGAUSP
*-
      COMMON /RGU/ TV(3),TVD(3),NIMAT(MND),LINE1(20,100),LMT1(20)
*-
      COMMON /ANGL/ THTA(MND),DLT
*-
      COMMON /STTVEL/ CRCN1,CRCN2,CRCN3,WS1,EXPN1,EXPN2,EXPM1,
     &                EXPM2,EXPM3,WSK1,WSK2,AA,AB,AC,B,FZ,AL,D
*-
      COMMON /DEPOS/ A1,A2,A3,A4,S1,S2,S3,S4,C1,C2,TAUMAX,T50,SIG2,CEQ
*-
      COMMON /FNT/ LDEST(40),NK(40)
*-
      COMMON /BLKE/ ESTIFN(30,30),Z(30),NSZG,NDG,NGC
*-
      COMMON /BUFFT/ R9(MR1,NIU),QZ(NBS),QPP(MFW),PVCOL(MFW),LCZ(MR1),
     &               LPZ(MR1),LHZ(NBS),LHEF(MFW),LPIW(MFW),JMOF(MFW)
*-
      COMMON /SEDI2/ BEDNOD(MND),BEDNDO(MND)
*-
      COMMON /SEDI1/ QXX(MND),QYY(MND),DZDT(MND),    
     &               AREAS(MND),AREASE(MEL,8),DZDTAV(MND),IDZDT(MND)
*-
      COMMON /BLKT/ XNT(6,7),DNAT(6,7),DNBT(6,7),WAITT(7),
     &              XMT(6,7),DMAT(6,7),DMBT(6,7)
*-
      COMMON /BLKR/ XNR(8,9),DNAR(8,9),DNBR(8,9),WAITR(9),
     &              XMR(8,9),DMAR(8,9),DMBR(8,9)
*-
      COMMON /FNT/ NBD(MND,NIV),NJ(40),LDESS(40),IFLXNN(20),
     &             IFLXN2(20),NSTIME
*-
      COMMON /CONTAM/ ADRATE(3),PART(3),DCYD,DCYP,
     &                JQZ(5),JSOUR(4),JQ1,JQ2,JQ3,JQ4,JQ5,JQP
*-
      COMMON /DEPIN/ dinibbu,dinigs1,dinicon,dinimru,dinigs2
