      FUNCTION INCTIM(INTRVL,MINDAY,NPER,JULS,ISTIME,JULE,IETIME)
C
C     FUNCTION INCREMENTS STARTING DATE AND TIME NPER
C     NUMBER OF PERIODS,  WHERE THE LENGTH OF THE
C     PERIOD IS INTRVL, AND MINDAY DESGINATES WHETHER
C     INTRVL IS IN MINIUTES OR DAYS.
C     IF MINDAY=0, INTRVL IS IN MINIUTES
C     IF MINDAY=1, INTRVL IS IN DAYS
C     UPDATED AUG82, ACCOUNTS FOR YEARLY INTERVALS AND
C     WILL HANDLE ALL NEGATIVE INCREMENTS
C
C     FOR PERIODS .GE. 1 MONTH, PROGRAM TAKES
C     CARE OF UNEQUAL NO OF DAYS PER MONTH, LEAP
C     DAYS, ETC.  HOWEVER FOR INTRVL .GE. MONTH,
C     PERIOD MUST BE STANDARD (EG. 6 MONTHS, NOT
C     6.5 MONTHS).
C
C     INTRVL = INTERVAL (MINS, OR DAYS)
C     MINDAY = 0 FOR MINS, = 1 FOR DAYS
C     NPER = NUMBER OF PERIODS TO INCREMENT
C     JULS = STARTING JULIAN DATE
C     ISTIME = STARTING TIME IN MINUTES AFTER MIDNIGHT FROM JULS
C     JULE, IETIME = RETURNED INCREMENTED TIME
C
C     TESTED FOR THE STANDARD 14 INTERVALS OF INCREMENTS
C     BETWEEN -10,000 AND 10,000 ON HARRIS -- FOR YEARLY
C     INTERVALS GOOD FOR INCREMENTS OF -1,000 TO 1,000.
C
      INTEGER*4 JULS, JULE, INTL, INTRVL, IYMDJL                        ML
      INTL = INTRVL
      IF (MINDAY.EQ.0) GO TO 5
      IF (INTL.GE.27) GO TO 100
C
C     INTRVL IN DAYS, LESS THAN 1 MONTH
      INTL = INTL * 1440
5     IF (INTL.GT.40000) GO TO 95
      IF (INTL.EQ.1440) GO TO 40
C
C     INTERVAL LESS THAN 1 MONTH
C
      ROUND = 0.00002
      IF (NPER.LT.0) ROUND = -0.00002
C
      XTEMP = (FLOAT(NPER) / 1440.) * FLOAT(INTL) + ROUND
      ITEMP = IFIX(XTEMP)
      JULE = JULS + ITEMP
      XMIN = (XTEMP - FLOAT(ITEMP)) * 1440.0 + ROUND
C     XMIN = MOD(MOD(NPER,1440)*MOD(INTL,1440),1440)
      IETIME = ISTIME + IFIX(XMIN)
C
C
C     CLEAN UP ENDING TIME TO BE A VAULE BETWEEN 1 AND 1440 MINS
10    IF (IETIME.LE.1440) GO TO 20
      IETIME = IETIME - 1440
      JULE = JULE + 1
      GO TO 10
 20   IF (IETIME.LE.0) GO TO 30
      INCTIM = 0
      RETURN
C
C     NEGATIVE INCREMENT
30    IF (IETIME.GT.0) GO TO 10
      IETIME = 1440 + IETIME
      JULE = JULE - 1
      GO TO 30
C
40    JULE = JULS + NPER
      IETIME = ISTIME
      GO TO 10
C
C     INTERVAL IS MONTHLY OR LARGER
95    INTL = INTL/1440
100   I = JLIYMD(JULS,IYR,IMON,IDAY)
      I = INTL/29
      IF (I.EQ.0) I = 1
      IF (I.LE.12) GO TO 105
      J = INTL/12
      I = J * 12
C
105   I = I * NPER
      IMON = IMON + I
      JY = IMON/12
      IMON = IMON - (JY*12)
      IYR = IYR + JY
C
110   IF (IMON.GT.0) GO TO 120
      IYR = IYR - 1
      IMON = IMON + 12
      GO TO 110
C
120   IF (IMON.LE.12) GO TO 150
      IYR = IYR + 1
      IMON = IMON - 12
      GO TO 120
C
150   IF (IDAY.GE.27) GO TO 160
      JULE = IYMDJL(IYR,IMON,IDAY)
      IETIME = ISTIME
      INCTIM = 0
      GO TO 10
C
C     INCREMENT TIME TO LAST DAY OF MONTH
160   CONTINUE
      IMON = IMON + 1
      IDAY = 1
165   IF (IMON.LE.12) GO TO 170
      IYR = IYR + 1
      IMON = IMON - 12
      GO TO 165
C
170   JULE = IYMDJL(IYR,IMON,IDAY) - 1
      IETIME = ISTIME
      INCTIM = 0
      GO TO 10
      END
