      FUNCTION NOPERS(INTRVL,MINDAY,JULS,ISTIME,JULE,IETIME)
C
C     FUNCTION DETERMINES NUMBER OF PERIODS
C     BETWEEN TWO POINTS IN TIME, WHERE THE LENGTH OF THE
C     PERIOD IS INTRVL, AND MINDAY DESGINATES WHETHER
C     INTRVL IS IN MINIUTES OR DAYS.
C     IF MINDAY=0, INTRVL IS IN MINIUTES
C     IF MINDAY=1, INTRVL IS IN DAYS
C     UPDATED AUG82 TO HANDLE YEARLY INTERVALS AND
C     DETERMINE A NEGATIVE NUMBER OF PERIODS.
C
C     FOR PERIODS .GE. 1 MONTH, PROGRAM TAKES
C     CARE OF UNEQUAL NO OF DAYS PER MONTH, LEAP
C     DAYS, ETC.  HOWEVER FOR INTRVL .GE. MONTH,
C     PERIOD MUST BE STANDARD (EG. 6 MONTHS, NOT
C     6.5 MONTHS).
C
C     INTRVL = INTERVAL (MINS, OR DAYS)
C     MINDAY = 0 FOR MINS, = 1 FOR DAYS
C     JULS = STARTING JULIAN DATE
C     ISTIME = STARTING TIME IN MINUTES AFTER MIDNIGHT FROM JULS
C     JULE, IETIME = ENDING DATE AND TIME.
C
C     TESTED FOR THE STANDARD 14 INTERVALS OF NUMBER PERS
C     BETWEEN -10,000 AND 10,000 ON HARRIS -- FOR YEARLY
C     INTERVALS GOOD FOR NUMBER PERS OF -1,000 TO 1,000.
C
C
      INTEGER*4 INTL, INTRVL, JULS, JULE                                ML
      INTL = INTRVL
      IF (MINDAY.EQ.0) GO TO 5
      IF (INTL.GE.27) GO TO 100
C
C     INTRVL IN DAYS, LESS THAN 1 MONTH
      INTL = INTL * 1440
5     IF (INTL.GT.40000) GO TO 95
C
C     INTERVAL LESS THAN 1 MONTH
      IDAYS = JULE - JULS
      IMINS = IETIME - ISTIME
      IF (INTL.EQ.1440) GO TO 30
      XDAYS = FLOAT(IDAYS)
      XMINS = FLOAT(IMINS)
      X = ((XDAYS/INTL)*1440.) + (XMINS/INTL)
C     CHECK FOR ROUND OFF ERROR AND (NEGATIVE) TRUNCATION
      X1 = X
      X = ABS(X) + 0.001
      NOPERS = IFIX(X)
      IF (X1.LT.0) NOPERS = - NOPERS
      RETURN
C
30    NOPERS = IDAYS + (IMINS/INTL)
      RETURN
C
C     INTERVAL IS MONTHLY OR LARGER
95    INTL = INTL/1440
100   I = JLIYMD(JULS,IYR,IMON,IDAY)
      I = JLIYMD(JULE,JYR,JMON,JDAY)
      IF (INTL.GT.31) GO TO 200
C
      I = (JDAY-IDAY)/27
      NOPERS = (JYR-IYR)*12 + (JMON-IMON) + I
      RETURN
C
200   INTL = INTL/30
      I = (JDAY-IDAY)/27
      I = JMON - IMON + I
      NOPERS = ((JYR-IYR)*12 + I)/INTL
      RETURN
      END
