      SUBROUTINE XREALC ( XNUMB, CLINE, NBEG, NLEN, NDEC)
C
C  PURPOSE:  TO CONVERT AN REAL NUMBER TO A CHARACTER STRING. THIS
C            PROVIDES A MACHINE TRANSPORTABLE ALTERNATIVE TO ENCODE.
C
C  INPUTS:  XNUMB - REAL NUMBER TO BE CONVERTED TO CHARACTER STRING
C           NBEG - BEGINNING CHARACTER POSITION OF CLINE WHICH TO PLACE
C                STRING
C           NLEN - MAXIMUM NUMBER OF CHARACTERS THAT MAY BE PLACED IN STRING
C         NDEC - NUMBER OF CHARACTERS AFTER DECIMAL POINT
C
C  OUTPUTS:  CLINE-  CHARACTER STRING THAT CONTAINS THE CONVERTED REAL.
C                  THE RESULTS WILL BE RIGHT JUSTIFIED WITH BLANK FILL.
C                  CLINE IS SET TO ASTERICKS IF ERROR OCCURS.
C
C     EXAMPLE: FOR A FORMAT OF  F12.4,  NLEN = 12, AND NDEC = 4
C
C  SUBROUTINES REFERENCED: NONE
C
      CHARACTER CLINE*(*), CFORMT*8
C
C
C     CHECK FOR ERROR CONDITION
      IF ((NBEG.LE.0).OR.(NLEN.LT.0).OR.(NLEN.GT.99)) GO TO 900
      IF ((NDEC.LT.0).OR.(NDEC.GE.NLEN)) GO TO 900
C
      CFORMT(1:8) = '(F      '
C
      IF (NLEN.LT.10) THEN
      WRITE ( CFORMT(3:3), 10, ERR=900) NLEN
 10   FORMAT (I1)
      IPOS = 4
      ELSE
      WRITE ( CFORMT(3:4), 20, ERR=900) NLEN
 20   FORMAT (I2)
      IPOS = 5
      ENDIF
C
      CFORMT(IPOS:IPOS) = '.'
      IPOS = IPOS + 1
C
      IF (NDEC.LT.10) THEN
      WRITE ( CFORMT(IPOS:IPOS), 30, ERR=900) NDEC
 30   FORMAT (I1)
      IPOS = IPOS + 1
      ELSE
      JPOS = IPOS + 1
      WRITE ( CFORMT(IPOS:JPOS), 40, ERR=900) NDEC
 40   FORMAT (I2)
      IPOS = IPOS + 2
      ENDIF
C
      CFORMT(IPOS:IPOS) = ')'
C
      NEND = NBEG + NLEN - 1
      WRITE ( CLINE(NBEG:NEND), CFORMT, ERR=900) XNUMB
      RETURN
C
 900  CONTINUE
      IF (NLEN.GE.1) CALL CHRFIL ( CLINE(NBEG:NBEG+NLEN-1), '*')
      RETURN
      END
