C
C
C
      REAL   FUNCTION   CNVTDG
     I                         (I)
C
C     + + + PURPOSE + + +
C     This routine computes latitude or longitude in degrees
C     form an integer representation of degrees-minutes-seconds.
C     593000 is converted to 59.5 degrees.
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER   I
C
C     + + + ARGUMENT DEFINITIONS + + +
C     I      - latitude or longitude in degrees, minutes, seconds
C
C     + + + LOCAL VARIABLES + + +
      INTEGER   IR
      REAL      XD, XM, XS
C
C     + + + INTRINSICS + + +
      INTRINSIC   REAL, INT
C
C     + + + END SPECIFICATIONS + + +
      XD = REAL(I/1000)
      IR = I - INT(XD)*1000
      XM = REAL(IR/100)
      IR = IR - INT(XM)*100
      XS = REAL(IR)
      CNVTDG = XD + XM/60.0 + XS/3600.0
C
      RETURN
      END
