#!/bin/sh
# test.sh -- run hspf for tests using wdm file
#
# Usage: test.sh [start [stop]]
#
#        where: start = starting test number
#                stop = ending test number (may be same as start)
# 
# History: 95/12/06  kmflynn

# pathname
WrdA=/usr/opt/wrdapp

#*******************************************************************
#***** You should not need to modify anything below this line. *****
#*******************************************************************

  Prgm=$WrdA/hspf11.0
  Data=$WrdA/hspf11.0/data
  Anne=$WrdA/annie2.2
  Chck=$WrdA/hspf11.0/test


  exec 2>&1                                     # stderr shows up in log file

  Start=${1-1}                                  # by default, start at 1
  Stop=${2-13}                                  # by default, stop at 13

# 
# Begin test runs
  echo
  echo _________________________________________________________________
  echo " Processing hspf tests $Start to $Stop"
  echo "  hspf program from: $Prgm"
  echo "     test data from: $Data"
  echo " annie program from: $Anne"
  echo
  date

# make sure the wdm files are available
  for wdm in test.wdm test2.wdm ; do
     if [ -f $wdm ] ; then
        echo " Using the $wdm file that is in the current directory"
     else if [ -f $Data/$wdm ] ; then
        echo " Copying the $wdm file from $Data "
        cp -p $Data/test.wdm test.wdm
        cp -p $Data/test2.wdm test2.wdm
     else
        echo " Building the wdm files "
        if [ -f testa1.exp ] ; then rm testa1.exp ; fi
        if [ -f testa2.exp ] ; then rm testa2.exp ; fi
        ln -s $Data/testa1.exp testa1.exp
        ln -s $Data/testa2.exp testa2.exp
        $Anne/bin/annie <<-EOT
	@$Data/testa.log
	EOT
        rm testa1.exp testa2.exp
        fi
     fi
  done

# files and suffixes used later
  Input='test01dt.p91
         test02dt.s31  test02dt.s33  test02dt.s35  test02dt.s37
         test02dt.s32  test02dt.s34  test02dt.s36
         test03dt.s57  test03dt.s58
         test06dt.p92'
  Sufix='out ech d61 d62 d63 d64 d65 d66 d67 p92 p93 p94 p95'

# make sure any required input files are available
  for Inp in $Input ; do
     echo " linking in $Data/$Inp "
     if [ -f $Inp ] ; then rm $Inp ; fi
     ln -s $Data/$Inp $Inp
  done

  Test=$Start
  while [ $Test -le $Stop -a $Test -le 13 ] ; do
#    hspf wdm test runs
     echo
     echo
     echo _________________________________________________________________
     echo "Test run number $Test"
     echo
     # is a leading zero needed?
     if [ $Test -lt 10 ] ; then
        Zero=0
     else
        Zero=
     fi
     # remove any old output file for this test
     for Sufx in $Sufix ; do
        if [ -f test$Zero$Test.$Sufx ] ; then rm test$Zero$Test.$Sufx ; fi
     done
     $Prgm/bin/hspf <<-EOT
	$Data/test$Zero$Test.uci
	EOT

     Test=`expr $Test + 1`
  done

# remove any files no longer needed
  for Inp in $Input ; do
     if [ -f $Inp ] ; then rm $Inp ; fi
  done

#
  echo
  echo
  echo _________________________________________________________________
  echo "Completed hspf test runs $Start to $Stop"
  echo
# check new output against original output
  $Chck/check.sh $Data

# end of shell
