@ECHO OFF
CLS
ECHO #
ECHO ##  MINTEQA2 CLMINTEQ batch command file.
ECHO #
REM
ECHO #                                          >CLMINTEQ.LOG
ECHO ##  MINTEQA2 CLMINTEQ batch command file. >>CLMINTEQ.LOG
ECHO #   RMFORT FORTRAN version 2.45.          >>CLMINTEQ.LOG            
ECHO #                                         >>CLMINTEQ.LOG
GOTO START
REM 
REM  ***************** \MINTEQA2\CLMINTEQ.BAT *******************
REM  *                                                          *
REM  *        Author: D.W. Disney, Computer Scientist           *
REM  *                Computer Sciences Corporation             *
REM  *          Date: Friday, 14 June 1991.  Time: 07:22:44.    *
REM  *   Environment: IBM PS/2 Model 80 under DOS 3.30          *
REM  *  Installation: Computer Sciences Corporation             *
REM  *                U.S. Environmental Protection Agency      *
REM  *                Athens ERL - Athens, Georgia              *
REM  *      Function: To complile and link all FORTRAN 77       *
REM  *                source code *.FOR and include files       *
REM  *                (*.INC) MINTEQA2 model version 3.01.      *
REM  *      Calling                                             *
REM  *      Sequence: CLMINTEQ                                  *
REM  *         Input: None                                      *
REM  *                                                          *
REM  ************************************************************
REM
REM **************************************************************
REM *         Maintenance History - \MINTEQA2\CLMINTEQ.BAT       *
REM *------------------------------------------------------------*
REM *                                                            *
REM *  1) Initial coding                                         *
REM *     Date: Friday, 14 June 1991.  Time: 07:23:42.           *
REM *                                                            *
REM **************************************************************
REM *                                                            *
REM *  Compile and link the MINTEQA2 model under Ryan-McFarland  *
REM *  FORTRAN (RMFORT) compiler and PLINK86 Plus link editor.   *
REM *                                                            *
REM *       Program     Version                                  *
REM *       -------     -------                                  *
REM *       RMFORT  -   2.45                                     *
REM *       PLINK86 -   2.24                                     *
REM *       PC DOS  -   3.30                                     *
REM *                                                            *
REM *  Author: D W Disney - 09/01/88 - CSC for US EPA            *
REM *                                                            *
REM **************************************************************
REM *  \MINTEQA2\CLMINTEQ.BAT                                    *
REM *------------------------------------------------------------*
REM *  The program assumes that                                  *
REM *                                                            *
REM *       1)  All RMFORT commands and files are stored in the  *
REM *           root sub-directory \RMFORT on drive F:.          *
REM *       2)  All PLINK86 Plus commands and files are in the   *
REM *           root sub-directory \PLINK on drive D:.           *
REM *       3)  All MINTEQA2 commands should be in the root sub- *
REM *           directory \MINTEQA2.                             *
REM *       4)  All MINTEQA2 source code and source code include *
REM *           files are stored in the \MINTEQA2 sub-directory  *
REM *           MINTCODE.                                        *
REM *       5)  The compile (CLMINTEQ.BAT) and link edit command *
REM *           file (MINTEQA2.LNK) are stored in the root       *
REM *           sub-directory \MINTEQA2.                         * 
REM *       6)  The MINTEQA2 object code files (*.OBJ) are in the*
REM *           \MINTEQA2 sub-directory MINT_OBJ.                *
REM *                                                            *
REM **************************************************************
REM *                                                            *
REM *  Ryan-McFarland compiler switches (version 2.45).          *
REM *                                                            *
REM *  /B - Assume adjustable and assumed size arrays gt 64k     *
REM *  /D - Compile debug source code lines                      *
REM *  /E - Generate listing with error and warning lines only   *
REM *  /H - Dummy arrays lt 64k are stored in more than 1 segment*
REM *  /I - I2 for integer; I4 is the default                    *
REM *  /N - Generate calls to the emulator library               *
REM *  /Q - Suppress generation of individual program summaries  *
REM *  /U - Suppress object module file generation               *
REM *  /Z - Suppress code optimization                           *
REM *                                                            *
REM *  Ryan-McFarland execution command (version 2.45)           *
REM *                                                            *
REM *  progname [/R n] [/SEUFM]                                  *
REM *                                                            *
REM *  /SEUFM - Suppress display of certain underflow messages   * 
REM *                                                            *
REM **************************************************************
REM
:START
REM
ECHO #
ECHO ##  Setting system environment for RMFORT and PLINK.
ECHO #
REM
SET OBJ=
SET LIB=
SET TMP=
SET PROFORT=
SET INCLUDE=
REM PATH C:.;C:\;C:\PLINK;C:\RMFORT
SET \RMFORT.CER=F:\RMFORT\RMFORT.CER
SET \RMFORT.ERR=F:\RMFORT\RMFORT.ERR
REM
CLS
ECHO #
ECHO ##  Cleaning up extra work files...wait.
ECHO #
IF EXIST MINTEQA2.MAP DEL MINTEQA2.MAP >NUL
IF EXIST XMINTEQX.EXE DEL XMINTEQX.EXE >NUL
REM IF EXIST        *.LST DEL        *.LST >NUL
REM
IF NOT EXIST MINT_OBJ\NUL MKDIR MINT_OBJ >NUL
REM
IF "%1"=="Y" GOTO YESDEL
IF "%1"=="y" GOTO YESDEL
IF "%1"=="N" GOTO NODEL
IF "%1"=="n" GOTO NODEL
SET ANSWER=
ANSWER     Delete existing MINTEQA2 program object files (*.OBJ)? (Y/N) 
IF "%ANSWER%"=="N" GOTO NODEL
IF "%ANSWER%"=="n" GOTO NODEL
IF "%ANSWER%"==""  GOTO NODEL
:YESDEL
IF EXIST MINT_OBJ\*.OBJ DEL MINT_OBJ\*.OBJ >NUL
IF EXIST          *.OBJ DEL          *.OBJ >NUL
:NODEL
SET ANSWER=
REM
CLS
VERIFY OFF
BREAK ON
ECHO #
ECHO ##  Ready to begin MINTEQA2 compilation and link edit.
ECHO #   Press "<Ctrl> <P>" if you wish to echo the results to printer.
ECHO #
ECHO #   Press the "<Enter>" key to continue.
REM PAUSE >NUL
CLS
REM
ECHO #
ECHO ##  Coping all INCLUDE source code files to \MINTEQA2 directory.
ECHO #
COPY MINTCODE\*.INC /V >NUL
CLS
REM
ECHO #
ECHO ##  Compile for MINTEQA2 in progress with Ryan-McFarland FORTRAN.
ECHO #
REM
ECHO #                                                        >>CLMINTEQ.LOG
ECHO ##  MINTEQA2 CLMINTEQ batch command file begin execution.>>CLMINTEQ.LOG
ECHO #                                                        >>CLMINTEQ.LOG
ECHO #                                                        >>CLMINTEQ.LOG
ECHO ## Start date and time.                                  >>CLMINTEQ.LOG
ECHO #                                                        >>CLMINTEQ.LOG
ECHO # -------- DATE ---------                                >>CLMINTEQ.LOG
ECHO #                                                        >>CLMINTEQ.LOG
DATE <RETURN1.ANS |FIND "C"                                   >>CLMINTEQ.LOG
ECHO #                                                        >>CLMINTEQ.LOG
ECHO # -------- TIME ---------                                >>CLMINTEQ.LOG
ECHO #                                                        >>CLMINTEQ.LOG
TIME <RETURN1.ANS |FIND "C"                                   >>CLMINTEQ.LOG
ECHO #                                                        >>CLMINTEQ.LOG
ECHO # -----------------------                                >>CLMINTEQ.LOG
ECHO #                                                        >>CLMINTEQ.LOG
CLS
@ECHO ON
IF NOT EXIST MINT_OBJ\MINTEQA2.OBJ RMFORT \MINTEQA2\MINTCODE\MINTEQA2 /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\ACTVTY.OBJ   RMFORT \MINTEQA2\MINTCODE\ACTVTY   /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\ADSORB.OBJ   RMFORT \MINTEQA2\MINTCODE\ADSORB   /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\ALKCOR.OBJ   RMFORT \MINTEQA2\MINTCODE\ALKCOR   /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\CLRSCR.OBJ   RMFORT \MINTEQA2\MINTCODE\CLRSCR   /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\COMPOSIT.OBJ RMFORT \MINTEQA2\MINTCODE\COMPOSIT /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\DELAY.OBJ    RMFORT \MINTEQA2\MINTCODE\DELAY    /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\DISPLAY.OBJ  RMFORT \MINTEQA2\MINTCODE\DISPLAY  /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\DUPCMP.OBJ   RMFORT \MINTEQA2\MINTCODE\DUPCMP   /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\ENQUIRE.OBJ  RMFORT \MINTEQA2\MINTCODE\ENQUIRE  /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\ERROR.OBJ    RMFORT \MINTEQA2\MINTCODE\ERROR    /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\EXCOL.OBJ    RMFORT \MINTEQA2\MINTCODE\EXCOL    /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\EXROW.OBJ    RMFORT \MINTEQA2\MINTCODE\EXROW    /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\GUESS.OBJ    RMFORT \MINTEQA2\MINTCODE\GUESS    /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\GUESS1.OBJ   RMFORT \MINTEQA2\MINTCODE\GUESS1   /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\IADX.OBJ     RMFORT \MINTEQA2\MINTCODE\IADX     /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\IADY.OBJ     RMFORT \MINTEQA2\MINTCODE\IADY     /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\IAP.OBJ      RMFORT \MINTEQA2\MINTCODE\IAP      /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\INFILE.OBJ   RMFORT \MINTEQA2\MINTCODE\INFILE   /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\INIT.OBJ     RMFORT \MINTEQA2\MINTCODE\INIT     /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\INPUT.OBJ    RMFORT \MINTEQA2\MINTCODE\INPUT    /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\KCORR.OBJ    RMFORT \MINTEQA2\MINTCODE\KCORR    /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\MAIND.OBJ    RMFORT \MINTEQA2\MINTCODE\MAIND    /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\MINVAL.OBJ   RMFORT \MINTEQA2\MINTCODE\MINVAL   /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\NEWX.OBJ     RMFORT \MINTEQA2\MINTCODE\NEWX     /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\NXTPRB.OBJ   RMFORT \MINTEQA2\MINTCODE\NXTPRB   /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\OUFILE.OBJ   RMFORT \MINTEQA2\MINTCODE\OUFILE   /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\OUTPUT.OBJ   RMFORT \MINTEQA2\MINTCODE\OUTPUT   /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\POINTER.OBJ  RMFORT \MINTEQA2\MINTCODE\POINTER  /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\PREP.OBJ     RMFORT \MINTEQA2\MINTCODE\PREP     /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\SIMQ.OBJ     RMFORT \MINTEQA2\MINTCODE\SIMQ     /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\SOLID.OBJ    RMFORT \MINTEQA2\MINTCODE\SOLID    /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\SOLIDX.OBJ   RMFORT \MINTEQA2\MINTCODE\SOLIDX   /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\SOLVE.OBJ    RMFORT \MINTEQA2\MINTCODE\SOLVE    /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\SWITCH.OBJ   RMFORT \MINTEQA2\MINTCODE\SWITCH   /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\TSTAMP.OBJ   RMFORT \MINTEQA2\MINTCODE\TSTAMP   /BNZE >>CLMINTEQ.LOG
IF NOT EXIST MINT_OBJ\VHOFF.OBJ    RMFORT \MINTEQA2\MINTCODE\VHOFF    /BNZE >>CLMINTEQ.LOG
@ECHO OFF
CLS
ECHO #
ECHO ##  MINTEQA2 compilation complete with Ryan-McFarland.FORTRAN.
ECHO #
ECHO #                                 >>CLMINTEQ.LOG
ECHO ## MINTEQA2 compilation complete. >>CLMINTEQ.LOG
ECHO #                                 >>CLMINTEQ.LOG
ECHO #                                 >>CLMINTEQ.LOG
ECHO ## End date and time.             >>CLMINTEQ.LOG
ECHO #                                 >>CLMINTEQ.LOG
ECHO # -------- DATE ---------         >>CLMINTEQ.LOG
ECHO #                                 >>CLMINTEQ.LOG
DATE <RETURN1.ANS |FIND "C"            >>CLMINTEQ.LOG
ECHO #                                 >>CLMINTEQ.LOG
ECHO # -------- TIME ---------         >>CLMINTEQ.LOG
ECHO #                                 >>CLMINTEQ.LOG
TIME <RETURN1.ANS |FIND "C"            >>CLMINTEQ.LOG
ECHO #                                 >>CLMINTEQ.LOG
ECHO # -----------------------         >>CLMINTEQ.LOG
ECHO #                                 >>CLMINTEQ.LOG
ECHO #
IF EXIST *.INC DEL *.INC
REM
IF NOT EXIST *.OBJ GOTO CONT
CLS
ECHO #
ECHO #   Saving object code files (*.OBJ) to MINT_OBJ directory...wait.
ECHO #
COPY *.OBJ MINT_OBJ /V >NUL
DEL  *.OBJ >NUL
:CONT
CLS
SET \RMFORT.CER=
SET OBJ=F:\MINTEQA2\MINT_OBJ;F:\RMFORT\;D:\PLINK
REM
ECHO #
ECHO ##  Ready to link MINTEQA2.
ECHO #
ECHO #   Press the "<Enter>" key to continue.
REM PAUSE >NUL
CLS
ECHO #   
ECHO ##  Beginning PLINK86 for MINTEQA2 code...wait.
ECHO #   
ECHO #                                       >>CLMINTEQ.LOG
ECHO ## Beginning PLINK86 for MINTEQA2 code. >>CLMINTEQ.LOG
ECHO #                                       >>CLMINTEQ.LOG
ECHO #                                       >>CLMINTEQ.LOG
ECHO ## Begin date and time.                 >>CLMINTEQ.LOG
ECHO #                                       >>CLMINTEQ.LOG
ECHO # -------- DATE ---------               >>CLMINTEQ.LOG
ECHO #                                       >>CLMINTEQ.LOG
DATE <RETURN1.ANS |FIND "C"                  >>CLMINTEQ.LOG
ECHO #                                       >>CLMINTEQ.LOG
ECHO # -------- TIME ---------               >>CLMINTEQ.LOG
ECHO #                                       >>CLMINTEQ.LOG
TIME <RETURN1.ANS |FIND "C"                  >>CLMINTEQ.LOG
ECHO #                                       >>CLMINTEQ.LOG
ECHO # -----------------------               >>CLMINTEQ.LOG
ECHO #                                       >>CLMINTEQ.LOG
ECHO #
CLS
IF NOT EXIST MINT_OBJ\*.OBJ GOTO NOLINK
@ECHO ON
IF NOT EXIST XMINTEQX.EXE PLINK86 VERBOSE NOBELL @MINTEQA2.LNK
@ECHO OFF
ECHO #
ECHO # -----------------
ECHO #   
ECHO ##  LINK complete for MINTEQA2 code.
ECHO #   
ECHO #                                   >>CLMINTEQ.LOG
ECHO ## Link complete for MINTEQA2 code. >>CLMINTEQ.LOG
ECHO #                                   >>CLMINTEQ.LOG
ECHO #                                   >>CLMINTEQ.LOG
ECHO ## End date and time.               >>CLMINTEQ.LOG
ECHO #                                   >>CLMINTEQ.LOG
ECHO # -------- DATE ---------           >>CLMINTEQ.LOG
ECHO #                                   >>CLMINTEQ.LOG
DATE <RETURN1.ANS |FIND "C"              >>CLMINTEQ.LOG
ECHO #                                   >>CLMINTEQ.LOG
ECHO # -------- TIME ---------           >>CLMINTEQ.LOG
ECHO #                                   >>CLMINTEQ.LOG
TIME <RETURN1.ANS |FIND "C"              >>CLMINTEQ.LOG
ECHO #                                   >>CLMINTEQ.LOG
ECHO # -----------------------           >>CLMINTEQ.LOG
ECHO #                                   >>CLMINTEQ.LOG
ECHO #   Press the "<Enter>" key to continue.
REM PAUSE >NUL
CLS
:NOLINK
ECHO #
ECHO ##  MINTEQA2 compilation/link complete...deleting work files...wait.
ECHO #
REM
SET OBJ=
IF EXIST *.OBJ DEL *.OBJ >NUL
REM
ECHO #                                               >>CLMINTEQ.LOG
ECHO ## MINTEQA2 CLMINTEQ.BAT command file complete. >>CLMINTEQ.LOG
ECHO #                                               >>CLMINTEQ.LOG
ECHO #                                               >>CLMINTEQ.LOG
ECHO ## End date and time.                           >>CLMINTEQ.LOG
ECHO #                                               >>CLMINTEQ.LOG
ECHO # -------- DATE ---------                       >>CLMINTEQ.LOG
ECHO #                                               >>CLMINTEQ.LOG
DATE <RETURN1.ANS |FIND "C"                          >>CLMINTEQ.LOG
ECHO #                                               >>CLMINTEQ.LOG
ECHO # -------- TIME ---------                       >>CLMINTEQ.LOG
ECHO #                                               >>CLMINTEQ.LOG
TIME <RETURN1.ANS |FIND "C"                          >>CLMINTEQ.LOG
ECHO #                                               >>CLMINTEQ.LOG
ECHO # -----------------------                       >>CLMINTEQ.LOG
ECHO #                                               >>CLMINTEQ.LOG
ECHO #
REM
REM PRINT CLMINTEQ.LOG <RETURN1.ANS >NUL
REM
CLS
ECHO #
ECHO ##  Compilation and link for all MINTEQA2 code complete.
ECHO #   Press "<Ctrl> <P>" if previously selected for printing.
ECHO #
ECHO #   Press the "<Enter>" key to continue.
REM PAUSE >NUL
CLS
ECHO #
ECHO ##  MINTEQA2 task image ready for test execution.
ECHO #   To execute, type MINRUN at the DOS system
ECHO #   prompt, then press the "<Enter>" key.
ECHO #
REM
REM *************************************************************
REM *       End compile batch stream \MINTEQA2\CLMINTEQ.BAT.    *
REM *************************************************************
