      subroutine actvty
c
c *****************************************************************
c
c ACTVTY
c
c THIS SUBROUTINE CALCULATES
c     1. ACTIVITY COEFFICIENTS FOR ALL SPECIES BY BOTH
c        THE DAVIES AND DEBYE-HUCKEL EQUATIONS
c     2. THE IONIC STRENGTH(XMU)
c     3. THE IONIC STRENGTH CORRECTION FOR THE EQUILIBRIUM
c        CONSTANTS BY CALLING KCORR
c
c *************************************************************
c
      include 'MINTEQA2.INC'
      real*8 cc2,tmp,v,sqrxmu
c
      include 'CONST.INC'
      i0 = nn(1)+nn(2)
      ii = i0+nn(3)
      i3 = ii+nn(4)+nn(5)+nn(6)
      cc2 = 0.D0
c
c COMPUTE CONCENTRATIONS USING NEW X'S OLD K'S
c
      if (isopt.eq.1) then
         xmu = fions
         sqrxmu = dsqrt(xmu)
         go to 130
      endif
c
c COMPLEXES
c
        id1 = idclf*10000
        id2 = idcll*10000 + 9999
        do 110 i = 1, i0
          if (idy(i).ge.id1.and.idy(i).le.id2) go to 110
          v = gk(i)
          do 100 k = 1, jmax(i)
             n = jpta(i,k)
             v = v+a(i,n)*gx(n)
  100     continue
c
          gc(i) = v
          c(i) = 10.0d0**gc(i)
c
  110  continue
c
c
c SUM THE CONCENTRATION OF ALL SPECIES FOR ACTIVITY
c COEFFICIENT CALCULATIONS
c
      do 120 i = 1, i0
c
c -- MODIFIED TO EXCLUDE ALL ADSORBENT COMPONENTS AND REACTION PRODUC
c
         if (idy(i).ge.811.and.idy(i).le.859) go to 120
         if (idy(i).le.2) go to 120
         if (idy(i).ge.8110000.and.idy(i).le.8599999) go to 120
         if (c(i).ge.0.0d0) then
           cc2 = cc2+c(i)*spcz(i)*spcz(i)
         end if
  120 continue
c
      xmu = cc2/2.0d0
      sqrxmu = dsqrt(xmu)
c
c FELMY 1982 ORIGINALLY SET LIMIT OF IONIC
c  STRENGTH TO 4.0 MOLAL
c
      if (xmu.gt.4.0d0) then
         xmu = tis
         sqrxmu = dsqrt(xmu)
      endif
c
  130 continue
c
c FIRST CALCULATE ACTIVITY COEFFICENTS WITH THE
c DAVIES EQUATION
c
      tmp = (sqrxmu/(1.0d0+sqrxmu)-0.24d0*xmu)
c
      do 140 i = 1, i3
c
c -- MODIFIED TO EXCLUDE ALL ADSORBENT COMPONENTS AND REACTION PRODUC
c
         if (idy(i).ge.811.and.idy(i).le.859) go to 140
         if (idy(i).eq.2) go to 140
         if (idy(i).ge.8110000.and.idy(i).le.8599999) go to 140
         if (abs(spcz(i)).lt.R0MIN) then
            gamma(i) = 0.0d0
         else
            gamma(i) = -aa*spcz(i)*spcz(i)*tmp
         endif
  140 continue
c
c NOW INITIALIZE ACTIVITY COEFFICIENTS FOR NEUTRAL COMPLEXES
c
      do 150 i = 1, i0
c
c -- MODIFIED TO EXCLUDE ALL ADSORBENT COMPONENTS AND REACTION PRODUC
c
         if (idy(i).ge.811.and.idy(i).le.859) go to 150
         if (idy(i).eq.2) go to 150
         if (idy(i).ge.8110000.and.idy(i).le.8599999) go to 150
         if (abs(spcz(i)).lt.D0MIN) gamma(i) = 0.1d0*xmu
  150 continue
      if (kkdav.eq.1) go to 170
c
c NOW USE THE DEBYE HUCKEL IF DHA IS NOT EQUAL TO 0
c
      do 160 i = 1, i3
c
c -- MODIFIED TO EXCLUDE ALL ADSORBENT COMPONENTS AND REACTION PRODUC
c
         if (idy(i).ge.811.and.idy(i).le.859) go to 160
         if (idy(i).eq.2) go to 160
         if (idy(i).ge.8110000.and.idy(i).le.8599999) go to 160
         if (abs(dha(i)).lt.R0MIN) go to 160
         gamma(i) = -aa*spcz(i)*spcz(i)*sqrxmu/(1.0d0+bb*dha(i)*
     *      sqrxmu)+dhb(i)*xmu
  160 continue
c
  170 continue
c
c NOW CORRECT LOGK FOR IONIC STRENGTH
c
      i0 = i0-1
      call kcorr
c
c DEBUG ROUTINE IN ACTVTY
c
      if (idebug.eq.1) then
         write (lunout,9000)
         write (lunout,9010) xmu
         write (lunout,9020) iter
         write (lunout,9030)
         ijj3 = nn(1)+nn(2)+nn(3)
         do 180 ijj = 1, ijj3
            write (lunout,9040) ijj,idx(ijj),x(ijj),idy(ijj),gamma(ijj)
     *         ,c(ijj),y(ijj)
  180    continue
      endif
      return
c
 9000 format ('0','DEBUG PRINT IN SUBROUTINE ACTVTY')
 9010 format ('0',10x,' XMU = ',f15.10)
 9020 format ('0',5x,'ITER = ',i5)
 9030 format ('0',5x,' I ',3x,'  IDX  ',3x,'     X    ',3x,'  IDY  ',
     *   3x,'   GAMMA  ',3x,'     C    ',3x,'     Y    ')
 9040 format (5x,i3,3x,i7,3x,1pe10.3,3x,i7,3x,0pf10.5,3x,1pe10.3,3x,
     *   e10.3)
c
      end
