      subroutine adsorb
c
c ***************************************************************
c
c THIS SUBROUTINE PERFORMS ALL ADSORPTION CALCULATIONS
c FOR THE TRIPLE LAYER SITE BINDING MODEL YATES ET AL.(1975)
c AND FOR THE CONSTANT CAPACITANCE MODEL (SEE HOHL AND STUMM).
c THE SUBROUTINE IS BROKEN INTO THREE ENTRY POINTS.
c
c ENTRY ADSID INITIALIZES SOME USEFUL CONSTANTS AND LOCATES
c THE COLUMN HEADERS FOR THE ELECTROSTATIC COMPONENTS.
c
c ENTRY ADINIT INITIALIZES THE TOTAL MASSES OF THE SURFACE
c SITE AND ELECTROSTATIC COMPONENTS.
c
c ENTRY ADSJAC INCLUDES THE DERIVATIVES OF TJ/PSI(J) FOR
c THE ELECTROSTATIC COMPONENTS IN THE JACOBIAN
c
c **************************************************************
c
      include 'MINTEQA2.INC'
c
      real*8 cnvft(5),econv,lambda,w
      integer*4 m0(5),m1(5)
      include 'CONST.INC'
c
      entry adsid
      if (iter.eq.0) then
         econv = dlog(10.0d0)*rj*tempk/fcc
         lambda = rj*tempk/fcc
         w = 1.0d0/(2d0*lambda)
      endif
c
      do 100 i = 1, 5
         IF (SOLCON(I).lt.D0MIN) GO TO 100
         cnvft(i) = ssa(i)*solcon(i)/fcc
         m0(i) = iadx(813+(i-1)*10)
         if (iads.eq.3) then
            m1(i) = iadx(814+(i-1)*10)
            m2(i) = iadx(815+(i-1)*10)
         endif
  100 continue
c
      return
c
c
      entry adinit
      do 110 i = 1, 5
         IF (SOLCON(I).lt.D0MIN) GO TO 110
         psi0(i) = -econv*gx(m0(i))
         if (iads.eq.3) then
            psib(i) = -econv*gx(m1(i))
            psid(i) = -econv*gx(m2(i))
         endif
         if (iads.eq.2) then
            sig0(i) = psi0(i)*cap1(i)
            t(m0(i)) = sig0(i)*cnvft(i)
         elseif (iads.eq.3) then
            sig0(i) = (psi0(i)-psib(i))*cap1(i)
            sigd(i) = (psid(i)-psib(i))*cap2(i)
            sigb(i) = -sig0(i)-sigd(i)
            t(m0(i)) = sig0(i)*cnvft(i)
            t(m2(i)) = sigd(i)*cnvft(i)
            t(m1(i)) = -t(m0(i))-t(m2(i))
         elseif (iads.eq.4) then
            sig0(i) = ee*sqrt(xmu)*dsinh(w*psi0(i))
            t(m0(i)) = sig0(i)*cnvft(i)
         endif
  110 continue
c
c
      return
c
      entry adscaly
      do 120 i = 1, 5
         IF (SOLCON(I).lt.D0MIN) GO TO 120
         y(m2(i)) = y(m2(i))+(-ee*sqrt(xmu)*dsinh(w*psid(i))*cnvft(i))
  120 continue
c
      return
c
      entry adsjac
      do 130 i = 1, 5
         IF (SOLCON(I).lt.D0MIN) GO TO 130
         if (iads.eq.2) then
            z(m0(i),m0(i)) = z(m0(i),m0(i))+cap1(i)*lambda/x(m0(i))*
     *         cnvft(i)
         elseif (iads.eq.3) then
            z(m0(i),m0(i)) = z(m0(i),m0(i))+cap1(i)*lambda/x(m0(i))*
     *         cnvft(i)
            z(m1(i),m2(i)) = z(m1(i),m2(i))-cap2(i)*lambda/x(m2(i))*
     *         cnvft(i)
            z(m2(i),m1(i)) = z(m2(i),m1(i))-cap2(i)*lambda/x(m1(i))*
     *         cnvft(i)
            z(m2(i),m2(i)) = z(m2(i),m2(i))+(cap2(i)+w*ee*dsqrt(xmu)*
     *         dcosh(w*psid(i)))*lambda/x(m2(i))*cnvft(i)
            z(m0(i),m1(i)) = z(m0(i),m1(i))-cap1(i)*lambda/x(m1(i))*
     *         cnvft(i)
            z(m1(i),m0(i)) = z(m1(i),m0(i))-cap1(i)*lambda/x(m0(i))*
     *         cnvft(i)
            z(m1(i),m1(i)) = z(m1(i),m1(i))+(cap1(i)+cap2(i))*lambda/
     *         x(m1(i))*cnvft(i)
         elseif (iads.eq.4) then
            z(m0(i),m0(i)) = z(m0(i),m0(i))+w*ee*dsqrt(xmu)*dcosh(w*
     *         psi0(i))*lambda/x(m0(i))*cnvft(i)
         endif
  130 continue
      return
c
      entry adsprnt
c
c  -- Print out information about adsorbents.
c
      if (iads.eq.2) then
         write (lunout,9000)
      elseif (iads.eq.3) then
         write (lunout,9010)
      elseif (iads.eq.4) then
         write (lunout,9020)
      endif
c
      do 140 i = 1, 5
         IF (SOLCON(I).lt.D0MIN) GO TO 140
         write (lunout,9030) i
         write (lunout,9040) psi0(i), sig0(i), psib(i), sigb(i),
     *                     psid(i), sigd(i)
         write (lunout,9050) solcon(i)
         write (lunout,9060) ssa(i)
  140 continue
      return
c
c
c
 9000 format (//,1x,'**** CONSTANT CAPACITANCE ADSORPTION MODEL ****'
     *   )
 9010 format (//,1x,'******** TRIPLE LAYER ADSORPTION MODEL ********'
     *   )
 9020 format (//,1x,'******* DIFFUSE LAYER ADSORPTION MODEL ********'
     *   )
 9030 format (//,1x,' **** Parameters For Adsorbent Number ',i1,
     *   ' ****')
 9040 format (1x,'  Electrostatic Variables:  psi0 = ',f8.6,4x,
     *   ' sig0 = ',f8.6,
     *      /,1x,'                            psib = ',f8.6,4x,
     *   ' sigb = ',f8.6,
     *      /,1x,'                            psid = ',f8.6,4x,
     *   ' sigd = ',f8.6)
 9050 format (1x,'  Adsorbent Concentration (g/l): ',f7.3)
 9060 format (1x,'  Specific Surface Area (sq. meters/g): ',f7.2)
c
      end
