      Subroutine DISPLAY (msgno)
c
c  -- The purpose of this routine is to display the program title and
c     CEAM address, obtain I/O filenames, and display execution status
c     information and error messages on the screen while MINTEQA2
c     executes.
c
c     The screen is divided into an upper region (the TITLE AREA),
c     middle region (the STATUS AREA) and lower region (the ERROR
c     AREA).  The variable "msgno" represents the message number and
c     is passed to DISPLAY by the calling program to indicate the
c     status text to be displayed.  In addition to text status
c     information, iteration, sweep number, and problem number
c     information may be displayed.  Also, information on the current
c     list of TYPE IV solids may be displayed.
c
c  -- The flag "prtstat" indicates whether to display the status
c     information for iteration, sweep, and problem numbers.
c  -- The flag "prtsld" indicates whether to display the status
c     information for TYPE IV solids.
c  -- The variables "string1, string2, ..." and the array "string(i)"
c     are used to temporarily store the ANSI escape sequence for
c     cursor position.
c  -- The variable "stringc" is used to temporarily store the ANSI
c     escape sequence for changing the foreground and background
c     screen colors.
c  -- The parameters "errcode" and "ierr" are available to DISPLAY
c     through named common blocks (MINTEQA2.INC).  These are written
c     out as the error message code heading th ERROR AREA.  The ERROR
c     AREA is caused to remain long enough for the user to read by
c     calling Subroutine DELAY for some few seconds.  This may also be
c     done for other messages.
c
      include 'MINTEQA2.INC'
CDWD
      integer*4  msgno
      INTEGER*2  IDLAY
CDWD
      character prtstat*1, string1*8, string2*8, string3*8, string4*8,
     *          string5*8, stringc*8, strings*8, prtsld*1, blank*12,
     *          oufil*12, infil*12, xerr*1, messg*1
      logical preexist
      dimension strings(20)
c
c  -- Set to display status information unless directed otherwise.
      prtstat = 'y'
      prtsld = 'y'
CDWD
      IDLAY = 0
CDWD
c
c  -- Branch on message number "msgno".
c
c
      if (msgno.eq.1) then
c  -- TITLE AREA - Display MINTEQA2 version number, Laboratory address.
c
c  -- Set the overall background color to white (47) and the
c     foreground to anything.
      write (scrnout,*) '[47;34m'
c
c  -- Clear the screen to turn the screen white.
      call clrscr (scrnout)
c
c  -- Set lines 3 through 5 to start in column 10.  For example,
c     string1 is set to begin printing on line 3 at column 10.  To
c     implement this, one need only write string1 to the display
c     device.  It will be interpreted as a command to position the
c     cursor, not as a string to be displayed.
        string1 = '[3;10H'
        string2 = '[4;10H'
        string3 = '[5;10H'
        string4 = '[6;10H'
        string5 = '[7;10H'
c
c  -- Set the foreground display to white (37) and the background to
c     blue (44).
        stringc = '[44;37m'
c
c  -- Implement these settings and write in the TITLE AREA.
        write (scrnout,900) stringc
        write (scrnout,1001) string1,string2,string3,string4,string5
c
c  -- Set background BLACK, foreground GREEN.
        stringc = '[40;32m'
        write (scrnout,900) stringc
c
c
c  -- OBTAIN INPUT AND OUTPUT FILENAMES
c
c  -- Check for the presence of a file named MININ.DAT.  If there
c     is such a file, assume it is the intended input file and
c     open it as such.  Open MINOUT.OUT as the output file.  If
c     there is no file named MININ.DAT, obtain both the input and
c     the output filenames from the user.
c
      infil = 'MININ.DAT'
      preexist =  .TRUE.
      xerr = 'N'
      messg = 'N'
      call enquire (infil,preexist,xerr,scrnout,messg)
c
c  -- If ENQUIRE found MININ.DAT, OPEN same as input file and OPEN
c     as output a file named MINOUT.OUT
      if (xerr.eq.'N') then
         oufil = 'MINOUT.OUT'
         open (unit=lun01,file=infil,status='OLD')
         open (unit=lunout,file=oufil,status='unknown')
         go to 106
      end if
c
c  -- In the absence of a file named MININ.DAT, obtain I/O
c     filenames from the user.
c
c  -- OBTAIN INPUT FILENAME
c
c  -- Set attribute to high intensity, position cursor at line 10,
c     column 1 and write input file prompt.
c
      string1 = '[1m'
 5700 format (a4)
      write (scrnout,5700) string1
      string1 = '[10;1H'
 5705 format (a8,'             <- Type input data file name (use X t',
     *           'o exit), then press <Enter>. ')
      write (scrnout,5705) string1
c
c  -- Re-position cursor at beginning of line 9.  This is because
c     the READ statement in INFILE will advance the cursor to the
c     beginning of the next line (line 10) which is where it needs
c     to be.
      string1 = '[9;1H'
 5710 format (a6)
      write (scrnout,5710) string1
c
c  -- Call INFILE to obtain the input filename.  INFILE will return
c     the filename in infil.  If xerr is returned as 'Y', the
c     specified file was not found so put up a TRY AGAIN prompt.
c     If xerr is returned as 'X', the user has elected to exit,
c     so return.
c
      call infile (infil,xerr)
105   if (xerr.eq.'Y') then
c  --    Move cursor to line 10 and write TRY AGAIN prompt.
         string1 = '[10;1H'
         write (scrnout,5715) string1, infil
 5715 format (a8,'             <- Try again.  (File ',a12,' entered by',
     *           ' user does not exist.)')
c  --    Re-position cursor to line 9 so that the READ in INFILE
c        will leave it in the right place.
         string1 = '[9;1H'
         write (scrnout,5710) string1
         xerr = 'N'
         call infile (infil,xerr)
         go to 105
      else if (xerr.eq.'X') then
c  --    If 'X' is entered instead of a filename, exit gracefully,
c        clearing the screen first.
         xstop = 'Y'
         call clrscr (scrnout)
         go to 999
      end if
c
c
c  -- OBTAIN OUTPUT FILENAME (only if MININ.DAT is not the input
c     filename and subsequently, MINOUT.OUT is the output file).
c
      if (infil.ne.'MININ.DAT') then
c  --    Position cursor at line 10 and write output file prompt.
         string1 = '[10;1H'
 5720 format (a8,'             <- Type output listing file name, the',
     *           'n press <Enter>.             ')
         write (scrnout,5720) string1
c  --    Re-position cursor at line 9 so that the READ in OUFILE
c        will leave it in the correct position.
 706     string1 = '[9;1H'
         write (scrnout,5710) string1
c  --    OUFILE opens the specified output file and returns the output
c        filename in oufil.
         call oufile (oufil)
         if (oufil.eq.infil) then
            string1 = '[10;1H'
 5735 format (a8,'             <- Try again.  Output file name cannot',
     *           ' be same as input file name.')
            write (scrnout,5735) string1
            go to 706
         else if (oufil.eq.' ') then
            go to 706
         end if
c  --    Open output file "oufil" on unit lunout
         open (unit=lunout,file=oufil,status='unknown')
      end if
c
c  -- Restore normal screen attributes, re-set black background,
c     green foreground.
      string1 = '[0m'
      string2 = '[32;40m'
 5725 format (a4,a8)
      write (scrnout,5725) string1, string2
c
c  -- Write I/O file names for user information on line 10.
 106  string1 = '[10;1H'
 5730 format (a8,' INPUT: ',a12,'          <--  FILES  -->    ',
     *           '          OUTPUT: ',a12)
      write (scrnout,5730) string1,infil,oufil
c
c
c  -- Set to not display the iteration number and solids status.
        prtstat = 'n'
        prtsld = 'n'
c
c
      else if (msgno.eq.3) then
c  -- STATUS AREA - "MINTEQA2 READING INPUT DATA"
c  -- Set to begin display in column 19 of line 12 and set background
c     color to black, foreground to green.
        string1 = '[12;19H'
        stringc = '[40;32m'
c
c  -- Implement these settings and write in the STATUS AREA.
        write (scrnout,900) stringc
        write (scrnout,1003) string1
c
c
      else if (msgno.eq.4) then
c  -- STATUS AREA - "CALCULATING SATURATION INDICES"
c  -- Set to begin display in column 19 of line 12 and set background
c     color to black, foreground to green.
        string1 = '[12;19H'
        stringc = '[40;32m'
c
c  -- Implement these settings and write in the STATUS AREA.
        write (scrnout,900) stringc
        write (scrnout,1004) string1
c
c
      else if (msgno.eq.5) then
c  -- ERROR AREA - "     --- COMPUTATIONS ABORTED ---", "... ERROR..."
c
c  -- Set background color to white (47) and foreground to anything.
        stringc = '[47;32m'
c  -- Set to begin next display at lines 10 through 22 beginning in
c     column 1.  The purpose of this is to "clear" the STATUS AREA
c     by writing over it with the background color (white).
        strings(1) = '[10;1H'
        strings(2) = '[11;1H'
        strings(3) = '[12;1H'
        strings(4) = '[13;1H'
        strings(5) = '[14;1H'
        strings(6) = '[15;1H'
        strings(7) = '[16;1H'
        strings(8) = '[17;1H'
        strings(9) = '[18;1H'
        strings(10) = '[19;1H'
        strings(11) = '[20;1H'
        strings(12) = '[21;1H'
        strings(13) = '[22;1H'
c
c  -- Implement these settings and write in the STATUS AREA.
        write (scrnout,900) stringc
        do 300 i = 1, 13
          write (scrnout,1008) strings(i)
  300   continue
c
c  -- Set background color to red (41) and foreground to white (37).
        stringc = '[41;37m'
c
c  -- Set to begin display in column 27 for lines 20 and 21.
        string1 = '[20;27H'
        string2 = '[21;27H'
c
c  -- Implement these settings and write in the ERROR AREA.
        write (scrnout,900) stringc
        write (scrnout,1005) string1, string2
c
c
      else if (msgno.eq.6) then
c  -- STATUS AREA - "EQUILIBRATING AQUEOUS SOLUTION"
c
c  -- Set to begin display in column 19 of line 12 and set background
c     color to black, foreground to green.
        string1 = '[12;19H'
        stringc = '[40;32m'
c
c  -- Implement these settings and write in the STATUS AREA.
        write (scrnout,900) stringc
        write (scrnout,1006) string1
c
c
      else if (msgno.eq.14) then
c  -- STATUS AREA - "THE MINERAL xxxxxxxx HAS DISSOLVED"
c
c  -- Set to begin display in column 19 of line 12 and set background
c     color to black, foreground to green.
        string1 = '[12;19H'
        stringc = '[40;32m'
c
c  -- Implement these settings and write in the STATUS AREA.
        write (scrnout,900) stringc
        write (scrnout,1014) string1, name(idwrite)
c
c
      else if (msgno.eq.15) then
c  -- STATUS AREA - "THE MINERAL xxxxxxxx HAS PRECIPITATED"
c
c  -- Set to begin display in column 19 of line 12 and set background
c     color to black, foreground to green.
        string1 = '[12;19H'
        stringc = '[40;32m'
c
c  -- Implement these settings and write in the STATUS AREA.
        write (scrnout,900) stringc
        write (scrnout,1015) string1, name(idwrite)
c
c
      else if (msgno.eq.18.and.ierrtotl.eq.0) then
c  -- STATUS AREA - "MINTEQA2 EXECUTION COMPLETED NORMALLY"
c
c  -- Set to begin display in column 19 of line 12 and set background
c     and foreground colors to normal display attributes.
        string1 = '[12;19H'
        stringc = '[0m'
        write (scrnout,900) stringc
c
c  -- Clear screen
        call clrscr (scrnout)
c
c  -- Write final message in the STATUS AREA.
        write (scrnout,1018) string1
c
c  -- Set to not display the iteration number and solids status.
        prtstat = 'n'
        prtsld = 'n'
c
c
      else if (msgno.eq.18.and.ierrtotl.eq.1) then
c  -- STATUS AREA - "MINTEQA2 EXECUTION COMPLETED WITH 1 ERROR"
c
c  -- Set to begin display in column 19 of line 12 and set background
c     and foreground colors to normal display attributes.
        string1 = '[12;19H'
        string2 = '[13;19H'
        stringc = '[0m'
        write (scrnout,900) stringc
c
c  -- Clear screen
        call clrscr (scrnout)
c
c  -- Write final message in the STATUS AREA.
        write (scrnout,1019) string1,ierrtotl,string2
c
c  -- Set to not display the iteration number and solids status.
        prtstat = 'n'
        prtsld = 'n'
c
      else if (msgno.eq.18.and.ierrtotl.gt.1) then
c  -- STATUS AREA - "MINTEQA2 EXECUTION COMPLETED WITH (>1) ERRORS"
c
c  -- Set to begin display in column 19 of line 12 and set background
c     and foreground colors to normal display attributes.
        string1 = '[12;19H'
        string2 = '[13;19H'
        stringc = '[0m'
        write (scrnout,900) stringc
c
c  -- Clear screen
        call clrscr (scrnout)
c
c  -- Write final message in the STATUS AREA.
        write (scrnout,1020) string1,ierrtotl,string2
c
c  -- Set to not display the iteration number and solids status.
        prtstat = 'n'
        prtsld = 'n'
c
      end if
c
c
c  -- Display the status information regarding iteration, sweep, and
c     problem number.
      if (prtstat.eq.'y') then
c
c  -- For "msgno" not equal to 5 (which is an error message), display
c     the iteration number, etc., in the STATUS AREA.
        if (msgno.ne.5) then
          string2 = '[12;2H'
          string3 = '[13;2H'
          string4 = '[14;2H'
          write (scrnout,620) string2, iter
          write (scrnout,625) string3, iprob
          write (scrnout,630) string4, mprob
c
c
c  -- For "msgno" equal to 5 only, display the iteration number, etc.,
c     in the  ERROR AREA.
        else
          prtsld = 'n'
          string1 = '[18;10H'
          string2 = '[20;10H'
          string3 = '[21;10H'
          string4 = '[22;10H'
          write (scrnout,616) string1, errcode, ierr
          write (scrnout,621) string2, iter
          write (scrnout,626) string3, iprob
          write (scrnout,631) string4, mprob
c
c  -- Hold the error screen for an additional 7 sec so that it may be
c     easily read.
CDWD
          IDLAY=5
          call delay (IDLAY)
CDWD
        end if
      end if
c
c
c
c
c  -- Display the current list of TYPE IV Finite Solids.  The list
c     may change from one call to this routine to the next with
c     new solids being added or existing solids disappearing from
c     the list.  Space is provided for only 17 such solids. If there
c     are more than 17 (not likely), no attempt is made to write more
c     after the 17th is displayed.
      if (prtsld.eq.'y'.and.msgno.eq.14
     *   .or.prtsld.eq.'y'.and.msgno.eq.15) then
         string1 = '[12;65H'
         write (scrnout,635) string1
         strings(1) = '[13;65H'
         strings(2) = '[14;65H'
         strings(3) = '[15;65H'
         strings(4) = '[16;65H'
         strings(5) = '[17;65H'
         strings(6) = '[18;65H'
         strings(7) = '[19;65H'
         strings(8) = '[20;65H'
         strings(9) = '[21;65H'
         strings(10) = '[22;65H'
         strings(11) = '[15;49H'
         strings(12) = '[16;49H'
         strings(13) = '[17;49H'
         strings(14) = '[18;49H'
         strings(15) = '[19;49H'
         strings(16) = '[20;49H'
         strings(17) = '[21;49H'
         strings(18) = '[22;49H'
c
c  -- Compute array index bounds for the TYPE IV species; nn(4) gives
c     the number of such species.
         i0 = nn(1) + nn(2) + nn(3) + 1
         ii = i0 + nn(4) - 1
         j = 1
         if (nn(4).gt.0) then
c
c  -- Display the names of up to the first 12 in the TYPE IV list.
           do 500 i = i0, ii
c
             if (j.le.17) then
               write (scrnout,640) strings(j), name(i)
               j = j + 1
             end if
  500      continue
c
           stringc = '[47;32m'
           write (scrnout,900) stringc
           blank = '           '
           write (scrnout,640) strings(j), blank
c
c  -- If there are no TYPE IV species, they will have disappeared
c     from the list one by one until there is only one left.  When
c     it too has dissolved, simply blank it's name by writing blanks
c     with the background color.
         else
           stringc = '[47;32m'
           write (scrnout,900) stringc
           strings(1) = '[13;65H'
           blank = '           '
           write (scrnout,640) strings(1), blank
         end if
      end if
c
c
c
c
999   RETURN
c
  900 format (a8)
 1001 format(a7,'                                                  ',
     *             '            ',
     *      /a7,'                    MINTEQA2 Version 3.11         ',
     *             '            ',
     *      /a7,'            U.S. Environmental Protection Agency  ',
     *             '            ',
     *      /a7,' Center for Exposure Assessment Modeling, Athens, ',
     *             'GA.   30613 ',
     *      /a7,'                                                  ',
     *             '            ')
 1003 format(a8,'         MINTEQA2 READING INPUT DATA         ')
 1004 format(a8,'       CALCULATING SATURATION INDICES        ')
 1005 format(a8,'        ---  COMPUTATION ABORTED  ---        ',
     *      /a8,'SEE OUPUT FILE FOR COMPLETE ERROR DIAGNOSTIC ')
 1006 format(a8,'       EQUILIBRATING AQUEOUS SOLUTION        ')
 1008 format(a8,'                                              ',
     *          '                                  ')
 1014 format(a8,'   THE MINERAL ',a12,' HAS DISSOLVED    ')
 1015 format(a8,'  THE MINERAL ',a12,' HAS PRECIPITATED  ')
 1018 format(a8,'    MINTEQA2 EXECUTION COMPLETED NORMALLY    ')
 1019 format(a8,' MINTEQA2 EXECUTION COMPLETED WITH ',i2,' ERROR',
     *          '  ',
     *      /a8,'SEE OUPUT FILE FOR COMPLETE ERROR DIAGNOSTIC ')
 1020 format(a8,' MINTEQA2 EXECUTION COMPLETED WITH ',i2,' ERRORS',
     *          ' ',
     *      /a8,'SEE OUPUT FILE FOR COMPLETE ERROR DIAGNOSTICS')
  616 format(a8,'               ***  ERROR NUMBER ',a7,i2,'  *** ',
     *          '              ')
  620 format(a7,' ITERATION: ',i3,' ')
  625 format(a7,' SWEEP:     ',i3,' ')
  630 format(a7,' PROBLEM:   ',i3,' ')
  621 format(a8,' ITERATION: ',i3,' ')
  626 format(a8,' SWEEP:     ',i3,' ')
  631 format(a8,' PROBLEM:   ',i3,' ')
  635 format(a8,'    SOLIDS:    ')
  640 format(a8,' ',a12,'  ')
C
      END
