      SUBROUTINE ENQUIRE (FILENAME,PREEXIST,XERR,SCRNOUT,MESSG)
c
c  -- The purpose of this subroutine is to inquire whether
c     the file named FILENAME exists and return the logical
c     variable FILEXIST as .TRUE. or .FALSE. accordingly.
c     The logical variable PREEXIST indicates whether the
c     file is supposed to already exist.  The character
c     variable MESSG indicates whether ENQUIRE is to write an
c     error message on the screen if a file that is supposed
c     to already exist does not or vica versa.  The character
c     variable XERR indicates whether the disposition of the
c     file is as it should be (XERR = 'N' for "no error") or
c     not as it should be (XERR = 'Y' for "error").
c
      CHARACTER FILENAME*12, XERR*1, MESSG*1
      LOGICAL FILEXIST,PREEXIST
      INTEGER SCRNOUT
C
C
      INQUIRE (FILE=FILENAME,EXIST=FILEXIST)
      IF (PREEXIST) THEN
        IF (.NOT.FILEXIST) THEN
          IF (MESSG.EQ.'Y') WRITE (SCRNOUT,1000) FILENAME
          XERR = 'Y'
          GO TO 999
        END IF
      ELSE IF (.NOT.PREEXIST) THEN
        IF (FILEXIST) THEN
          IF (MESSG.EQ.'Y') WRITE (SCRNOUT,1010) FILENAME
          XERR = 'Y'
        END IF
      END IF
C
  999 RETURN
C
 1000 FORMAT(' THE REQUIRED FILE ',a12,' IS NOT PRESENT IN THIS SUB-',
     *       'DIRECTORY.',
     *     /,' CONSULT THE INSTALLATION INSTRUCTIONS (READ.ME).   ')
 1010 FORMAT(' THE FILE ',a12,' ALREADY EXISTS IN THIS SUB-DIRECTORY.',
     *       ' RENAME IT TO SOME',
     *     /,' OTHER NAME OR MOVE IT TO A DIFFERENT DIRECTORY AND',
     *       ' TRY AGAIN.')
      END
