      subroutine guess
c
c  -- The purpose of this subroutine is to make better activity
c     guesses for certain components--  those for which an equation of
c     some sort is provided below and for which the flag reguess(j)
c     is not equal to no ('n').
c
      include 'MINTEQA2.INC'
c
      real*8 k1, k2, k3, k4, k5, k6, k7, k8, k9, k10,
     *       total, actH, actE, coefa, coefb, coefc
      character crred1*1, crred2*1, sered1*1, sered2*1
      include 'CONST.INC'
c
      crred1 = 'n'
      crred2 = 'n'
      sered1 = 'n'
      sered2 = 'n'
      if (fxdph.eq.'y') then
         actH = 10.0d0**(-systemph)
      else
         if (iadx(330).ne.0) then
           actH = 10.0d0**gx(iadx(330))
         else
           go to 999
         end if
      end if
      if (fxdpe.eq.'y') then
         actE = 10.0d0**(-systempe)
      else
         if (iadx(001).ne.0) actE = 10.0d0**gx(iadx(001))
      end if
c
c
      call guess1 (actH,actE)
c
c
c  -- Type III species that involve acid/base chemistry only, i.e,
c     no requirement that the electron be defined as a component.
      i1 = nn(1)+nn(2)+1
      i2 = nn(1)+nn(2)+nn(3)
      do 20 i = i1,i2
c
c  -- Compute new guess for CO3-2
        if (idy(i).eq.3301403) then
          j1 = iadx(140)
          k1 = 10.0d0**gk(iady(3301403))
          if (reguess(j1).eq.'n') go to 20
          x(j1) = 1.0d0/(k1*(actH**2))
          gx(j1) = dlog10 (x(j1))
          reguess(j1) = 'r'
        end if
c
c
   20 continue
c
c
c
c  -- Type III species that involve acid/base AND redox chemistry.
c     The electron must be defined as a component.
      if (iadx(001).ne.0.and.iadx(330).ne.0) then
c
        i1 = nn(1)+nn(2)+1
        i2 = nn(1)+nn(2)+nn(3)
        do 30 i = i1,i2
c
c  -- Compute new guess for SO4-2
        if (idy(i).eq.7307320) then
          j1 = iadx(730)
          j2 = iadx(732)
          if (j1.gt.j2) then
            call excol (j1,j2)
            j1 = iadx(730)
            j2 = iadx(732)
          end if
          k1 = 10.d0**gk(iady(7307320))
          k2 = 10.d0**gk(iady(3307320))
          k3 = 10.d0**gk(iady(3307300))
c
          total = t(j1) + t(j2)
          if (total.gt.D0MIN.and.reguess(j2).ne.'n') then
            x(j2) = total / (1.0 + k1*(actH**9)*(actE**8)
     *            + k3*k1*(actH**10)*(actE**8) + k2*actH)
            gx(j2) = dlog10 (x(j2))
            reguess(j2) = 'r'
c
            if (reguess(j1).ne.'n') then
              x(j1) = k1*x(j2)*actH**9*actE**8
              gx(j1) = dlog10(x(j1))
              reguess(j1) = 'r'
            end if
          end if
        end if
c
c  -- Compute new guess for Fe+3
        if (idy(i).eq.2802810) then
          j1 = iadx(280)
          j2 = iadx(281)
          if (j1.gt.j2) then
            call excol (j1,j2)
            j1 = iadx(280)
            j2 = iadx(281)
          end if
          k1 = 10.d0**gk(iady(2802810))
          k2 = 10.d0**gk(iady(2803300))
          k3 = 10.d0**gk(iady(2803302))
          k4 = 10.d0**gk(iady(2813300))
          k5 = 10.d0**gk(iady(2813301))
          k6 = 10.d0**gk(iady(2813302))
          k7 = 10.d0**gk(iady(2813303))
c
         total = t(j1) + t(j2)
         if (total.gt.D0MIN.and.reguess(j2).ne.'n') then
           x(j2) = total / (1.0 + k1*actE + k2*k1*actE/actH
     *           + k3*k1*actE/actH**2 + k4/actH + k5/actH**2
     *           + k6/actH**3 + k7/actH**4)
           reguess(j2) = 'r'
           gx(j2) = dlog10 (x(j2))
c
           if (reguess(j1).ne.'n') then
              x(j1) = k1*x(j2)*actE
              gx(j1) = dlog10(x(j1))
              reguess(j1) = 'r'
           end if
         end if
        end if
c
c  -- Compute new guess for Mn+3
        if (idy(i).eq.4704710) then
          j1 = iadx(470)
          j2 = iadx(471)
          if (j1.gt.j2) then
            call excol (j1,j2)
            j1 = iadx(470)
            j2 = iadx(471)
          end if
          k1 = 10.d0**gk(iady(4704710))
          k2 = 10.d0**gk(iady(4703300))
          k3 = 10.d0**gk(iady(4703301))
          k4 = 10.d0**gk(iady(4700020))
          k5 = 10.d0**gk(iady(4700021))
c
          total = t(j1) + t(j2)
          if (total.gt.D0MIN.and.reguess(j2).ne.'n') then
             x(j2) = total / (1.0 + k1*actE + k2*k1*actE/actH
     *            + k3*k1*actE/actH**3 + k4*k1/((actH**8)*(actE**4))
     *            + k5*k1/((actH**8)*(actE**3)))
            reguess(j2) = 'r'
            gx(j2) = dlog10 (x(j2))
c
            if (reguess(j1).ne.'n') then
               x(j1) = k1*x(j2)*actE
               gx(j1) = dlog10(x(j1))
               reguess(j1) = 'r'
            end if
          end if
        end if
c
c
c  -- Compute new guess for H3AsO4
        if (idy(i).eq.0600610) then
          j1 = iadx(060)
          j2 = iadx(061)
          if (j1.gt.j2) then
            call excol (j1,j2)
            j1 = iadx(060)
            j2 = iadx(061)
          end if
          k1 = 10.d0**gk(iady(0600610))
          k2 = 10.d0**gk(iady(3300600))
          k3 = 10.d0**gk(iady(3300601))
          k4 = 10.d0**gk(iady(3300602))
          k5 = 10.d0**gk(iady(3300603))
          k6 = 10.d0**gk(iady(3300611))
          k7 = 10.d0**gk(iady(3300612))
          k8 = 10.d0**gk(iady(3300613))
c
          total = t(j1) + t(j2)
          if (total.gt.D0MIN.and.reguess(j2).ne.'n') then
           x(j2) = total / (1.0 + k1*(actE**2)*(actH**2)
     *            + k2*k1*(actE**2)*actH + k3*k1*(actE**2)
     *            + k4*k1*(actE**2)/actH
     *            + k5*k1*(actE**2)*(actH**3)
     *            + k6/actH + k7/(actH**2) + k8/(actH**3))
            reguess(j2) = 'r'
            gx(j2) = dlog10 (x(j2))
c
            if (reguess(j1).ne.'n') then
               x(j1) = k1*x(j2)*actH**2*actE**2
               gx(j1) = dlog10(x(j1))
               reguess(j1) = 'r'
            end if
          end if
        end if
c
c  -- Compute new guess for Cr(OH)2+ if couple Cr+2/Cr(OH)2+
        if (idy(i).eq.2102110) then
          crred1 = 'y'
          k1 = 10.d0**gk(iady(2102110))
          k2 = 10.d0**gk(iady(2113300))
          k3 = 10.d0**gk(iady(2113301))
          k4 = 10.d0**gk(iady(2113302))
          k5 = 10.d0**gk(iady(2113303))
          k6 = 10.d0**gk(iady(2113304))
c
          j1 = iadx(210)
          j2 = iadx(211)
          if (j1.gt.j2) then
            call excol (j1,j2)
            j1 = iadx(210)
            j2 = iadx(211)
          end if
          total = t(j1) + t(j2)
          if (total.gt.D0MIN.and.reguess(j2).ne.'n') then
            x(j2) = total / (1.0 + k1*(actH**2)*actE + k2*(actH**2)
     *            + k3*actH + k4/actH + k5/(actH**2) + k6/(actH**2))
            gx(j2) = dlog10 (x(j2))
            reguess(j2) = 'r'
            if (reguess(j1).ne.'n') then
               x(j1) = k1*x(j2)*actH**2*actE
               gx(j1) = dlog10(x(j1))
               reguess(j1) = 'r'
            end if
          end if
        end if
c
c  -- Compute new guess for Cr(OH)2+ if couple Cr(OH)2+/CrO4-2
          if (idy(i).eq.2112120) then
          crred2 = 'y'
          k2 = 10.d0**gk(iady(2113300))
          k3 = 10.d0**gk(iady(2113301))
          k4 = 10.d0**gk(iady(2113302))
          k5 = 10.d0**gk(iady(2113303))
          k6 = 10.d0**gk(iady(2113304))
          k7 = 10.d0**gk(iady(2112120))
          k8 = 10.d0**gk(iady(2123300))
          k9 = 10.d0**gk(iady(2123301))
          k10= 10.d0**gk(iady(2123302))
          j1 = iadx(212)
          j2 = iadx(211)
          if (j1.gt.j2) then
            call excol (j1,j2)
            j1 = iadx(212)
            j2 = iadx(211)
          end if
          total = t(j1) + t(j2)
          if (total.gt.D0MIN.and.reguess(j2).ne.'n') then
            x(j2) = total / (1.0 + 1.0/(k7*(actH**6)*(actE**3))
     *            + k2*(actH**2) + k3*actH + k4/actH
     *            + k5/(actH**2) + k6/(actH**2)
     *            + k8/(k7*(actH**5)*(actE**3))
     *            + k9/(k7*(actH**4)*(actE**3))
     *            + k10/(k7*(actH**4)*(actE**3)))
            gx(j2) = dlog10 (x(j2))
            reguess(j2) = 'r'
            if (reguess(j1).ne.'n') then
               x(j1) = x(j2)/(k7*actH**6*actE**3)
               gx(j1) = dlog10(x(j1))
               reguess(j1) = 'r'
            end if
          end if
        end if
c
c  -- Mercury
        if (idy(i).eq.3603610) then
          k1 = 10.d0**gk(iady(3603610))
          k2 = 10.d0**gk(iady(3600000))
          k3 = 10.d0**gk(iady(3613300))
          k4 = 10.d0**gk(iady(3613302))
          k5 = 10.d0**gk(iady(3613303))
c
          j1 = iadx(360)
          j2 = iadx(361)
          if (j1.gt.j2) then
            call excol (j1,j2)
            j1 = iadx(360)
            j2 = iadx(361)
          end if
          coefa = 2*k1*(actH**4)*(actE**2)
          coefb = 1.0 + k2*dsqrt(k1)*(actH**2)*(actE**2) + k3*(actH**2)
     *            + k4*actH + k5/actH
          coefc = (-1)*(2*t(j1) + t(j2))
          if (coefc.gt.D0MIN.and.reguess(j2).ne.'n') then
            x(j2) = (-coefb + dsqrt((coefb**2)-4.0d0*coefa*coefc))
     *            /(2.0d0*coefa)
            if (x(j2).lt.D0MIN) x(j2) = -coefc/coefb
            gx(j2) = dlog10(x(j2))
            reguess(j2) = 'r'
            if (reguess(j1).ne.'n') then
               x(j1) = k1*x(j2)**2*actH**4*actE**2
               gx(j1) = dlog10(x(j1))
               reguess(j1) = 'r'
            end if
          end if
        end if
c
c  -- Copper
        if (idy(i).eq.2302310) then
          k1 = 10.d0**gk(iady(2302310))
          k2 = 10.d0**gk(iady(2313300))
          k3 = 10.d0**gk(iady(2313301))
          k4 = 10.d0**gk(iady(2313302))
          k5 = 10.d0**gk(iady(2313303))
          k6 = 10.d0**gk(iady(2313304))
c
          j1 = iadx(230)
          j2 = iadx(231)
          if (j1.gt.j2) then
            call excol (j1,j2)
            j1 = iadx(230)
            j2 = iadx(231)
          end if
          coefa = k6/(actH**2)
          coefb = 1.0 + k1*actE + k2/actH + k3*(actH**2)
     *            + k4/(actH**3) + k5/(actH**4)
          coefc = (-1)*(t(j1) + t(j2))
          if (coefc.gt.D0MIN.and.reguess(j2).ne.'n') then
            x(j2) = (-coefb + dsqrt((coefb**2)-4.0d0*coefa*coefc))
     *            /(2.0d0*coefa)
            if (x(j2).lt.D0MIN) x(j2) = -coefc/coefb
            gx(j2) = dlog10(x(j2))
            reguess(j2) = 'r'
            if (reguess(j1).ne.'n') then
               x(j1) = k1*x(j2)*actE
               gx(j1) = dlog10(x(j1))
               reguess(j1) = 'r'
            end if
          end if
        end if
c
c  -- Selenium
        if (idy(i).eq.7607610) then
          sered1 = 'y'
          k1 = 10.d0**gk(iady(7607610))
          k2 = 10.d0**gk(iady(3307600))
          k3 = 10.d0**gk(iady(3307601))
          k4 = 10.d0**gk(iady(3307610))
          k5 = 10.d0**gk(iady(3307611))
c
          j1 = iadx(760)
          j2 = iadx(761)
          if (j1.gt.j2) then
            call excol (j1,j2)
            j1 = iadx(760)
            j2 = iadx(761)
          end if
          total = t(j1) + t(j2)
          if (total.gt.D0MIN.and.reguess(j2).ne.'n') then
             x(j2) = total /(1.0d0+ k1*(actH**6)*(actE**6)
     *            + k2*(actH**7)*(actE**6) + k3*(actH**5)*(actE**6)
     *            + k4*actH + k5/actH)
            gx(j2) = dlog10(x(j2))
            reguess(j2) = 'r'
            if (reguess(j1).ne.'n') then
               x(j1) = k1*x(j2)*actH**6*actE**6
               gx(j1) = dlog10(x(j1))
               reguess(j1) = 'r'
            end if
          end if
        end if
c
        if (idy(i).eq.7617620) then
          sered2 = 'y'
          k4 = 10.d0**gk(iady(3307610))
          k5 = 10.d0**gk(iady(3307611))
          k6 = 10.d0**gk(iady(7617620))
          k7 = 10.d0**gk(iady(3307620))
c
          j1 = iadx(762)
          j2 = iadx(761)
          if (j1.gt.j2) then
            call excol (j1,j2)
            j1 = iadx(762)
            j2 = iadx(761)
          end if
          total = t(j1) + t(j2)
          if (total.gt.D0MIN.and.reguess(j2).ne.'n') then
            x(j2) = total /(1.0d0+ 1.0d0/(k6*(actH**3)*(actE**2))
     *           + k4*actH + k5/actH + k7/(k6*(actH**2)*(actE**2)))
            gx(j2) = dlog10(x(j2))
            reguess(j2) = 'r'
            if (reguess(j1).ne.'n') then
               x(j1) = x(j2)/(k6*actH**3*actE**2)
               gx(j1) = dlog10(x(j1))
               reguess(j1) = 'r'
            end if
          end if
        end if
c
c  -- Antimony
        if (idy(i).eq.7407410) then
          k1 = 10.d0**gk(iady(7407410))
          k2 = 10.d0**gk(iady(7403302))
          k3 = 10.d0**gk(iady(7400020))
          k4 = 10.d0**gk(iady(7403301))
          k5 = 10.d0**gk(iady(7403300))
          k6 = 10.d0**gk(iady(7400021))
          k7 = 10.d0**gk(iady(7413300))
          k8 = 10.d0**gk(iady(7410021))
          j1 = iadx(740)
          j2 = iadx(741)
          if (j1.gt.j2) then
            call excol (j1,j2)
            j1 = iadx(740)
            j2 = iadx(741)
          end if
          total = t(j1) + t(j2)
          if (total.gt.D0MIN.and.reguess(j2).ne.'n') then
            x(j2) = total/(1.0d0 + k1*(actH**3)*(actE**2)
     *          + k2*k1*(actH**4)*(actE**2)
     *          + k3*k1*(actH**2)*(actE**2) + k4*k1*(actH**2)*(actE**2)
     *          + k5*k1*(actH**4)*(actE**2) + k6*k1*(actH**3)*(actE**2)
     *          + k7*(actH**2) + k8)
            gx(j2) = dlog10(x(j2))
            reguess(j2) = 'r'
            if (reguess(j1).ne.'n') then
               x(j1) = k1*x(j2)*actH**3*actE**2
               gx(j1) = dlog10(x(j1))
               reguess(j1) = 'r'
            end if
          end if
        end if
c
c  -- Thallium
        if (idy(i).eq.8708710) then
          k1 = 10.d0**gk(iady(8708710))
          k2 = 10.d0**gk(iady(8703300))
          k3 = 10.d0**gk(iady(8713300))
          k4 = 10.d0**gk(iady(8713301))
          k5 = 10.d0**gk(iady(8713302))
          k6 = 10.d0**gk(iady(8713303))
          j1 = iadx(870)
          j2 = iadx(871)
          if (j1.gt.j2) then
            call excol (j1,j2)
            j1 = iadx(870)
            j2 = iadx(871)
          end if
          total = t(j1) + t(j2)
          if (total.gt.D0MIN.and.reguess(j2).ne.'n') then
             x(j2) = total/(1.0d0 + k1*(actH**3)*(actE**2)
     *          + k2*k1*(actH**2)*(actE**2)
     *          + k3*(actH**3) + k4*(actH**2) + k5*actH + k6/actH)
            gx(j2) = dlog10(x(j2))
            reguess(j2) = 'r'
            if (reguess(j1).ne.'n') then
               x(j1) = k1*x(j2)*actH**3*actE**2
               gx(j1) = dlog10(x(j1))
               reguess(j1) = 'r'
            end if
          end if
        end if
   30   continue
c
c  -- If both redox couples of chrome are imposed, recalculate
c     the Cr(OH)2+ activity guess using both.
        if (crred1.eq.'y'.and.crred2.eq.'y') then
          j1 = iadx(210)
          j2 = iadx(211)
          j3 = iadx(212)
          k1 = 10.d0**gk(iady(2102110))
          k2 = 10.d0**gk(iady(2113300))
          k3 = 10.d0**gk(iady(2113301))
          k4 = 10.d0**gk(iady(2113302))
          k5 = 10.d0**gk(iady(2113303))
          k6 = 10.d0**gk(iady(2113304))
          k7 = 10.d0**gk(iady(2112120))
          k8 = 10.d0**gk(iady(2123300))
          k9 = 10.d0**gk(iady(2123301))
          k10= 10.d0**gk(iady(2123302))
          if (j1.gt.j2) then
            call excol (j1,j2)
            j1 = iadx(210)
            j2 = iadx(211)
          end if
          if (j3.gt.j2) then
            call excol (j3,j2)
            j3 = iadx(212)
            j2 = iadx(211)
          end if
          total = t(j1) + t(j2) + t(j3)
          if (total.gt.D0MIN.and.reguess(j2).ne.'n') then
             x(j2) = total / (1.0 + k1*(actH**2)*actE
     *            + k2*(actH**2) + k3*actH + k4/actH
     *            + k5/(actH**2) + k6/(actH**2)
     *            + 1.0/(k7*(actH**6)*(actE**3))
     *            + k8/(k7*(actH**5)*(actE**3))
     *            + k9/(k7*(actH**4)*(actE**3))
     *            + k10/(k7*(actH**4)*(actE**3)))
            gx(j2) = dlog10 (x(j2))
            reguess(j2) = 'r'
          end if
        end if
c
c  -- Selenium
        if (sered1.eq.'y'.and.sered2.eq.'y') then
          k1 = 10.d0**gk(iady(7607610))
          k2 = 10.d0**gk(iady(3307600))
          k3 = 10.d0**gk(iady(3307601))
          k4 = 10.d0**gk(iady(3307610))
          k5 = 10.d0**gk(iady(3307611))
          k6 = 10.d0**gk(iady(7617620))
          k7 = 10.d0**gk(iady(3307620))
c
          j1 = iadx(760)
          j2 = iadx(761)
          j3 = iadx(762)
          if (j1.gt.j2) then
            call excol (j1,j2)
            j1 = iadx(760)
            j2 = iadx(761)
          end if
          if (j3.gt.j2) then
            call excol (j3,j2)
            j3 = iadx(762)
            j2 = iadx(761)
          end if
          total = t(j1) + t(j2) + t(j3)
          if (total.gt.D0MIN.and.reguess(j2).ne.'n') then
            x(j2) = total /(1.0d0 + k1*(actH**6)*(actE**6)
     *            + 1.0d0/(k6*(actH**3)*(actE**2))
     *            + k2*(actH**7)*(actE**6) + k3*(actH**5)*(actE**6)
     *            + k4*actH + k5/actH * k7/(k6*(actH**2)*(actE**2)))
            gx(j2) = dlog10(x(j2))
            reguess(j2) = 'r'
          end if
        end if
c
      end if
c
      icount = 0
      do 100 j = 1, nnn
        if (reguess(j).eq.'r') then
          icount = icount + 1
          if (icount.eq.1) write (lunout,1000)
          i = iady(idx(j))
          write (lunout,1010) name(i),gx(j)
        end if
  100 continue
      if (icount.gt.0) write (lunout,1020)
c
  999 return
c
 1000 format (///,t16,'----------------------------------------',
     *                '--------------',
     *         /,t15,'|',2x,'IMPROVED ACTIVITY GUESSES PRIOR TO',
     *                      ' FIRST ITERATION:',1x,'|')
 1010 format (1x,t15,'|',7x,a12,t35,'Log activity guess:',2x,f7.2,
     *           t70,'|')
 1020 format (1x,t15,'|',t70,'|',/,t16,'--------------------------',
     *                '----------------------------')
      end
