      subroutine guess1 (actH,actE)
c
c  -- The purpose of this subroutine is to make better activity
c     guesses for certain components.
c
      include 'MINTEQA2.INC'
c
      real*8 k1, k2, k3, k4, k5, k6, k7, k8, k9, k10,
     *       total, actH, actE, coefa, coefb, coefc
      include 'CONST.INC'
c
c
c
      do 10 j = 1, nnn
      if (t(j).lt.D0MIN.or.reguess(j).eq.'n') go to 10
c
c  -- Carbonate
      if (idx(j).eq.140) then
        k1 = 10.0d0**gk(iady(3301400))
        k2 = 10.0d0**gk(iady(3301401))
        total = t(j)
        if (total.gt.D0MIN) then
          x(j) = total / (1.0 + k1*actH + k2*actH**2)
          gx(j) = dlog10 (x(j))
          reguess(j) = 'r'
        end if
c
c  -- Phosphate
      else if (idx(j).eq.580) then
        k1 = 10.0d0**gk(iady(3305800))
        k2 = 10.0d0**gk(iady(3305801))
        total = t(j)
        if (total.gt.D0MIN) then
          x(j) = total / (1.0 + k1*actH + k2*actH**2 + k3*actH**3)
          gx(j) = dlog10 (x(j))
          reguess(j) = 'r'
        end if
c
c  -- Aluminum
      else if (idx(j).eq.030) then
        k1 = 10.0d0**gk(iady(0303300))
        k2 = 10.0d0**gk(iady(0303301))
        k3 = 10.0d0**gk(iady(0303303))
        k4 = 10.0d0**gk(iady(0303302))
        total = t(j)
        if (total.gt.D0MIN) then
          x(j) = total / (1.0 + k1/actH + k2/actH**2 + k3/actH**3
     *          + k4/actH**4)
          gx(j) = dlog10 (x(j))
          reguess(j) = 'r'
        end if
c  -- Sulfate
      else if (idx(j).eq.732) then
        k2 = 10.d0**gk(iady(3307320))
c
        total = t(j)
        if (total.gt.D0MIN) then
          x(j) = total / (1.0 + k2*actH)
          gx(j) = dlog10 (x(j))
          reguess(j) = 'r'
        end if
c  -- Bi-sulfide
      else if (idx(j).eq.730) then
        k3 = 10.d0**gk(iady(3307300))
c
        total = t(j)
        if (total.gt.D0MIN) then
          x(j) = total / (1.0 + k3*actH)
          gx(j) = dlog10 (x(j))
          reguess(j) = 'r'
        end if
c
c  -- Fe+3
      else if (idx(j).eq.281) then
        k4 = 10.d0**gk(iady(2813300))
        k5 = 10.d0**gk(iady(2813301))
        k6 = 10.d0**gk(iady(2813302))
        k7 = 10.d0**gk(iady(2813303))
        total = t(j)
        if (total.gt.D0MIN) then
          x(j) = total / (1.0 + k4/actH + k5/actH**2
     *           + k6/actH**3 + k7/actH**4)
          gx(j) = dlog10 (x(j))
          reguess(j) = 'r'
        end if
c
c  -- Fe+2
      else if (idx(j).eq.280) then
        k2 = 10.d0**gk(iady(2803300))
        k3 = 10.d0**gk(iady(2803302))
        total = t(j)
        if (total.gt.D0MIN) then
          x(j) = total / (1.0 + k2/actH + k3/actH**2)
          gx(j) = dlog10 (x(j))
          reguess(j) = 'r'
        end if
c
c  -- Manganese
      else if (idx(j).eq.470) then
        k2 = 10.d0**gk(iady(4703300))
        k3 = 10.d0**gk(iady(4703301))
c
        total = t(j)
        if (total.gt.D0MIN) then
          x(j) = total / (1.0 +  k2/actH + k3/actH**3)
          gx(j) = dlog10 (x(j))
          reguess(j) = 'r'
        end if
c
c  -- Arsenic
      else if (idx(j).eq.061) then
        k6 = 10.d0**gk(iady(3300611))
        k7 = 10.d0**gk(iady(3300612))
        k8 = 10.d0**gk(iady(3300613))
c
        total = t(j)
        if (total.gt.D0MIN) then
          x(j) = total / (1.0 + k6/actH + k7/(actH**2)
     *            + k8/(actH**3))
          gx(j) = dlog10 (x(j))
          reguess(j) = 'r'
        end if
      else if (idx(j).eq.060) then
        k2 = 10.d0**gk(iady(3300600))
        k3 = 10.d0**gk(iady(3300601))
        k4 = 10.d0**gk(iady(3300602))
        k5 = 10.d0**gk(iady(3300603))
c
        total = t(j)
        if (total.gt.D0MIN) then
          x(j) = total / (1.0 + k1*(actE**2)*(actH**2)
     *            + k2/actH + k3/(actH**2)
     *            + k4/(actH**3) + k5*actH)
          gx(j) = dlog10 (x(j))
          reguess(j) = 'r'
       end if
c
c  -- Chromium
      else if (idx(j).eq.211) then
        k2 = 10.d0**gk(iady(2113300))
        k3 = 10.d0**gk(iady(2113301))
        k4 = 10.d0**gk(iady(2113302))
        k5 = 10.d0**gk(iady(2113303))
        k6 = 10.d0**gk(iady(2113304))
c
        total = t(j)
        if (total.gt.D0MIN) then
          x(j) = total / (1.0 +  k2*(actH**2) + k3*actH
     *            + k4/actH + k5/(actH**2) + k6/(actH**2))
          gx(j) = dlog10 (x(j))
          reguess(j) = 'r'
        end if
c
      else if (idx(j).eq.212) then
        k8 = 10.d0**gk(iady(2123300))
        k9 = 10.d0**gk(iady(2123301))
        k10= 10.d0**gk(iady(2123302))
c
        total = t(j)
        if (total.gt.D0MIN) then
          x(j) = total / (1.0 + k8*actH + k9*(actH**2)
     *            + k10*(actH**2))
          gx(j) = dlog10 (x(j))
          reguess(j) = 'r'
        end if
c
c  -- Mercury
      else if (idx(j).eq.361) then
        k3 = 10.d0**gk(iady(3613300))
        k4 = 10.d0**gk(iady(3613302))
        k5 = 10.d0**gk(iady(3613303))
c
        total = t(j)
        if (total.gt.D0MIN) then
          x(j) = total / (1.0 + k3*(actH**2) + k4*actH + k5/actH)
          gx(j) = dlog10 (x(j))
          reguess(j) = 'r'
        end if
c
      else if (idx(j).eq.360.and.iady(3600000).ne.0) then
        k2 = 10.d0**gk(iady(3600000))
c
        coefa = k2*actE
        coefb = 2.0d0
        coefc = -2*t(j)
        x(j) = (-coefb + dsqrt((coefb**2)-4.0d0*coefa*coefc))
     *          /(2.0d0*coefa)
        if (dabs(x(j)).lt.D0MIN) x(j) = -coefc/coefb
        x(j) = x(j)**2
        gx(j) = dlog10 (x(j))
        reguess(j) = 'r'
c
c
c  -- Copper
      else if (idx(j).eq.231) then
          k2 = 10.d0**gk(iady(2313300))
          k3 = 10.d0**gk(iady(2313301))
          k4 = 10.d0**gk(iady(2313302))
          k5 = 10.d0**gk(iady(2313303))
          k6 = 10.d0**gk(iady(2313304))
c
          coefa = k6/(actH**2)
          coefb = 1.0 + k2/actH + k3*(actH**2) + k4/(actH**3)
     *            + k5/(actH**4)
          coefc = -t(j)
          x(j) = (-coefb + dsqrt((coefb**2)-4.0d0*coefa*coefc))
     *            /(2.0d0*coefa)
          if (dabs(x(j)).lt.D0MIN) x(j) = -coefc/coefb
          gx(j) = dlog10(x(j))
          reguess(j) = 'r'
c
c
c  -- Selenium
      else if (idx(j).eq.760) then
          k2 = 10.d0**gk(iady(3307600))
          k3 = 10.d0**gk(iady(3307601))
          total = t(j)
          if (total.gt.D0MIN) then
            x(j) = total/(1.0d0 + k2*actH + k3/actH)
            gx(j) = dlog10(x(j))
            reguess(j) = 'r'
          end if
c
      else if (idx(j).eq.761) then
          k4 = 10.d0**gk(iady(3307610))
          k5 = 10.d0**gk(iady(3307611))
          total = t(j)
          if (total.gt.D0MIN) then
            x(j) = total/(1.0d0 + k4*actH + k5/actH)
            gx(j) = dlog10(x(j))
            reguess(j) = 'r'
          end if
      else if (idx(j).eq.762) then
          k7 = 10.d0**gk(iady(3307620))
          total = t(j)
          if (total.gt.D0MIN) then
            x(j) = total/(1.0d0 + k7*actH)
            gx(j) = dlog10(x(j))
           reguess(j) = 'r'
          end if
c
      else if (idx(j).eq.740) then
          k2 = 10.d0**gk(iady(7403302))
          k3 = 10.d0**gk(iady(7400020))
          k4 = 10.d0**gk(iady(7403301))
          k5 = 10.d0**gk(iady(7403300))
          k6 = 10.d0**gk(iady(7400021))
          total = t(j)
          if (total.gt.D0MIN) then
            x(j) = total/(1.0d0 + k2*actH + k3/actH + k4/actH
     *             + k5*actH + k6)
            gx(j) = dlog10(x(j))
            reguess(j) = 'r'
          end if
c
      else if (idx(j).eq.741) then
          k7 = 10.d0**gk(iady(7413300))
          k8 = 10.d0**gk(iady(7410021))
          total = t(j)
          if (total.gt.D0MIN) then
            x(j) = total/(1.0d0 + k7*(actH**2) + k8)
            gx(j) = dlog10(x(j))
            reguess(j) = 'r'
          end if
c
c  -- Thallium
      else if (idx(j).eq.870) then
          k2 = 10.d0**gk(iady(8703300))
          total = t(j)
          if (total.gt.D0MIN) then
            x(j) = total/(1.0d0 + k2/actH)
            gx(j) = dlog10(x(j))
            reguess(j) = 'r'
          end if
c
      else if (idx(j).eq.871) then
          k3 = 10.d0**gk(iady(8713300))
          k4 = 10.d0**gk(iady(8713301))
          k5 = 10.d0**gk(iady(8713302))
          k6 = 10.d0**gk(iady(8713303))
          total = t(j)
          if (total.gt.D0MIN) then
            x(j) = total/(1.0d0 + k3*(actH**3) + k4*(actH**2)
     *             + k5*actH + k6/actH)
            gx(j) = dlog10(x(j))
            reguess(j) = 'r'
          end if
c
c  -- Silica
      else if (idx(j).eq.770) then
          k1 = 10.d0**gk(iady(3307700))
          k2 = 10.d0**gk(iady(3307701))
          total = t(j)
          if (total.gt.D0MIN) then
            x(j) = total/(1.0d0 + k1/actH + k2/(actH**2))
            gx(j) = dlog10(x(j))
            reguess(j) = 'r'
          end if
        end if
   10 continue
c
c
c
      return
c
      end
