      subroutine iap (state)
c
c *******************************************************************
c
c THIS SUBROUTINE CALCULATES THE SATURATION INDICES FOR ALL
c MINERALS AND SOLIDS IN THE TYPE 6 FILE. THE INDICES ARE
c CALCULATED ONE AT A TIME THUS REQUIRING MEMORY FOR ONLY
c ONE MINERAL.
c
c *******************************************************************
c
      include 'MINTEQA2.INC'
c
      dimension at(12),idt(12),id(20),ta(20),tb(20),tc(20),td(20),te(
     *   20),tf(20),tg(20)
c
      real*8 at,ta,tb,tc,td,te,tf,tg,spz,spcdha,spcdhb,spcgfw,alkft
      real*8 dht,gkt,maxgkt,mingkt,si,tmpk,v,vhoff
      character minnam*12, state*5, match*2,oparen*1,cparen*1
      data oparen,cparen / '[',']'/
      if (kkthr.eq.2) go to 999
      call display (4)
c
c ZERO LOCAL ARRAYS
c
      do 100 i = 1, 10
         at(i) = 0.0d0
         idt(i) = 0
  100 continue
c
c NOW READ IN ANALYTICAL EXPRESSIONS FOR LOG K
c WITH TEMPERATURE FOR MINERALS AND SOLIDS ONLY
c REMEMBER MINERALS AND SOLIDS ARE STORED IN THE
c FIRST PART OF FILE LUN07.
c
      i = 1
  110 read (lun07,9060) id(i),ta(i),tb(i),tc(i),td(i),te(i),tf(i),tg(i
     *   )
      if (id(i).eq.0) then
         rewind lun07
         go to 120
      endif
      i = i+1
      go to 110
  120 num = i-1
c
      nlines = 0
      ipage = 1
      write (lunout,5750) 6
      call tstamp
      if (state.eq.'both ') then
        write (lunout,9020)
      else if (state.eq.'over ') then
        write (lunout,9021)
      else if (state.eq.'under') then
        write (lunout,9022)
      end if
c
      write (lunout,9050)
      rewind lun04
c
c READ IN THE DATA FOR ONLY ONE MINERAL
c
  130 read (lun04) midt,minnam,dht,gkt,maxgkt,mingkt,
     *   spz,spcdha,spcdhb,spcgfw,alkft,ncmp,(at(j),
     *   idt(j),j=1,ncmp)
      if (midt.eq.0) go to 999
c
      match = '  '
      v = 0.0d0
      do 150 i = 1, ncmp
         n = iadx(idt(i))
         if (n.eq.0) go to 130
         v = v+at(i)*gx(n)
  150 continue
c
c CHECK FOR INSERTED SPECIES WITH THE SAME ID AS TYPE 6 SOLIDS
c
      if (kount.eq.0) go to 170
      do 160 i = 1, kount
         if (idydum(i).ne.midt) go to 160
         match = '**'
  160 continue
c
  170 tmpk = vhoff(gkt,dht)
c
c CALCULATE LOG K WITH T
c
      do 220 i = 1, num
         if (id(i).ne.midt) go to 220
         tmpk = ta(i)+tb(i)*tempk+tc(i)/tempk+td(i)*dlog10(tempk)+te(
     *      i)*(tempk*tempk)+tf(i)/(tempk*tempk)+tg(i)/dsqrt(tempk)
         go to 230
  220 continue
  230 continue
      si = v+tmpk
      if (state.eq.'over '.and.si.lt.0.0) go to 130
      if (state.eq.'under'.and.si.gt.0.0) go to 130
      if (ncmp.le.3) then
         nlines = nlines + 1
         write (lunout,9030) match,midt,minnam,si,(oparen,at(j),cparen,
     *      idt(j),j=1,ncmp)
      elseif (ncmp.ge.4.and.ncmp.le.6) then
         nlines = nlines + 2
         write (lunout,9035) match,midt,minnam,si,(oparen,at(j),cparen,
     *      idt(j),j=1,ncmp)
      elseif (ncmp.ge.7.and.ncmp.le.9) then
         nlines = nlines + 3
         write (lunout,9040) match,midt,minnam,si,(oparen,at(j),cparen,
     *      idt(j),j=1,ncmp)
      elseif (ncmp.ge.10.and.ncmp.le.12) then
         nlines = nlines + 4
         write (lunout,9045) match,midt,minnam,si,(oparen,at(j),cparen,
     *      idt(j),j=1,ncmp)
      endif
      if (ipage.eq.1) then
        if (nlines.le.42) go to 130
      else
        if (nlines.le.50) go to 130
      end if
c
      ipage = ipage + 1
      nlines = 0
      write (lunout,9000)
      write (lunout,9050)
      go to 130
  999 return
c
 9000 format ('1'//)
 9020 format ('0','Saturation indices and stoichiometry of all',
     *       ' minerals')
 9021 format ('0','Saturation indices and stoichiometry of all',
     *       ' supersaturated minerals')
 9022 format ('0','Saturation indices and stoichiometry of all',
     *       ' undersaturated minerals')
 9030 format (' ',a2,i7,1x,a12,1x,f8.3,4x,3(a1,f7.3,a1,1x,i3,2x))
 9035 format (' ',a2,i7,1x,a12,1x,f8.3,4x,3(a1,f7.3,a1,1x,i3,2x),
     *      /,' ',                    35x,3(a1,f7.3,a1,1x,i3,2x))
 9040 format (' ',a2,i7,1x,a12,1x,f8.3,4x,3(a1,f7.3,a1,1x,i3,2x),
     *      /,' ',                    35x,3(a1,f7.3,a1,1x,i3,2x),
     *      /,' ',                    35x,3(a1,f7.3,a1,1x,i3,2x))
 9045 format (' ',a2,i7,1x,a12,1x,f8.3,4x,3(a1,f7.3,a1,1x,i3,2x),
     *      /,' ',                    35x,3(a1,f7.3,a1,1x,i3,2x),
     *      /,' ',                    35x,3(a1,f7.3,a1,1x,i3,2x),
     *      /,' ',                    35x,3(a1,f7.3,a1,1x,i3,2x))
 9050 format ('0',4x,'ID #',5x,'NAME',6x,'Sat. Index',8x,
     *   'Stoichiometry in [brackets] ')
 9060 format (i7,1x,7(e10.3,1x))
5750  format ('1',//,' ________________________________________',
     *        '________________________________________',
     *      /,' ______________________________ PART ',i1,' of',
     *        ' OUTPUT FILE ___________________________')
c
      end
