      subroutine input (idxx, sweep)
c
c SUBROUTINE INPUT REQUIRES 4 INPUT FILES
c  FILE LUN01. CONTAINS THE RUN SPECIFIC INFORMATION(WATER ANALYSIS)
c  FILE LUN02. CONTAINS THERMODYNAMIC DATA FOR ALL SPECIE TYPES EXCEPT
c              TYPE 6 SOLIDS
c  FILE LUN03. CONTAINS A LIST OF ALL ACCEPTED COMPONENTS AND THE
c            NECESSARY AUXILLARY THERMODYNAMIC DATA
c  FILE LUN04. CONTAINS THE THERMODYNAMIC DATA FOR ALL TYPE 6 SOLIDS
c
c
c  SUBROUTINE INPUT PERFORMS THE FOLLOWING FUNCTIONS
c            1. READS SAMPLE DESCRIPTION AND COMPONENT INFORMATION FR
c               FILE LUN01. THIS SECTION OF FILE LUN01. ENDS WITH A BLA
c            2. READS FILE LUN03. AND FINDS A MATCH BETWEEN ALL COMPON
c               IN THE INPUT STREAM
c            3. READS FILE LUN02. AND STORES ALL SPECIES WHICH HAVE AL
c               NECESSARY COMPONENTS IN THE SAMPLE INPUT(FILE 11.)
c            4. READS FILE LUN01. FOR ALL TYPE,LOGK,OR DH CHANGES TO T
c               EXISTING THERMODYNAMIC DATA STORED FROM FILE LUN02.
c            5. IF THE SPECIE ID IS A TYPE 6 SOLID THEN THE INFORMATI
c               READ IN DURING OPERATION (4)ABOVE IS STORED IN DUMMY
c               UNTIL THE TYPE 6 SOLIDS FILE IS READ. THIS REQUIRES R
c               THE TYPE 6 SOLIDS FILE ONLY ONCE.
c            6. THE INFORMATION FOR INSERTED SPECIES NOT IN THE DATA
c               IS READ FROM FILE LUN01.
c
c THE THERMODYNAMIC DATA FOR TYPE 6 SOLIDS WAS STORED IN A SEPARATE F
c ELIMINATE THE NEED TO INCREASE THE SIZE OF THE A AND B MATRICIES.TH
c MINEQL CODE OF JOHN WESTALL STORED THE STOICHIOMETRY FOR ALL SPECIE
c THE A AND B MATRICIES.THIS PROCEDURE REQUIRED MODIFICATION BECAUSE
c LARGE NUMBER OF SOLIDS IN THE WATEQ3 AND WATEQ4 DATA BANKS.
c
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
c %%INPUT              CORRECTION HISTORY
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
c  DATE                   CORRECTION
c 10-10-87   CHANGED FORMAT STATEMENTS 500, 502, 503, 504 TO USE
c            E10.3 AND F7.2 FOR READING CONCENTRATIONS AND ACTIVITIES
c            AND EQUILIBRIUM CONSTANTS AND ENTHALPIES.
c
c            CHANGED TO STOP WRITING MODIFICATION HISTORY TO OUTPUT
c            FILE.
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
c
      include 'MINTEQA2.INC'
c
      dimension idt(12),at(12),gkdum(100),ifnd(100),ityp(100),
     *          dhdum(100),bt(3),ibt(3),cdum(100)
c
      character spcnam*12, acteq*21 ,adsmodel*20, sweep*10, insh2o*1,
     *          rgt*1, match*1
      character*75 desc,carry
      real*8 alkft,conc,dht,gkt,gxt,mingkt,maxgkt,spcdh,spcdha,spcdhb,
     *       spcgfw,spz,tt,atmp1,atmp2,atmp3,atmp4
      real*8 at,bt,cdum,dhdum,gkdum,startval,valinc
C
      real lines
      integer isurf, jsurf, idxx, ierparm, nlines
C
      include 'CONST.INC'
      call display (3)
c
      sweep = '          '
      idxx = 0
c  -- Initialize flag indicating whether H2O has been inserted as a
c     component to no ('n').
      insh2o = 'n'
c
      do 100 j = 1, 100
         idydum(j) = 0
  100 continue
c
c     INPUT PROBLEM DATA
c READ SAMPLE DESCRIPTION,TEMPERATURE AND UNITS
c
      read (lun01,9000,end=110) desc
      go to 120
 110  call display (18)
      xstop = 'y'
      go to 999
c
  120 read (lun01,9000) carry
c
      write (lunout,5700) 1
      call tstamp
c
      write (lunout,9130) desc
      write (lunout,9140) carry
c
c
      read (lun01,9010) temp,flag,fions
c
      tempk = temp+273.16d0
      units = flag
c
c  -- Compute the temperature dependent term for the Van't Hoff
c     correction used in FUNCTION VHOFF.
      vh = (298.16d0-tempk)/(298.16d0*tempk*vhc*r)
c
c  -- Read the sequence of integers in the input file.  These are
c     various program flags.
      read (lun01,9210) icoralk,idebug,icharg,iprint,niter,iparm,isopt
     *   ,iprdct,kkdav,kkthr,isweep,n123,ntyp123
c
c  -- So far, 4 lines have been read from the input file.
      ierparm = 4
c
c  -- Write the interpretation of the flags to the output file.
      write (lunout,9250) temp,flag
      if (isopt.eq.0) then
         write (lunout,9260)
      else
         write (lunout,9270) fions
      endif
      if (icoralk.eq.0) then
         write (lunout,9280)
      elseif (icoralk.eq.1) then
         write (lunout,9290)
      endif
      if (icharg.eq.0) then
         write (lunout,9310)
      else
         write (lunout,9300)
      endif
      if (iprint.eq.0) then
         write (lunout,9320)
      else
         write (lunout,9330) iprint
      endif
      if (niter.eq.0) then
         itmax = 40
      elseif (niter.eq.1) then
         itmax = 10
      elseif (niter.eq.2) then
         itmax = 100
      elseif (niter.eq.3) then
         itmax = 200
      elseif (niter.eq.4) then
         itmax = 500
      endif
      write (lunout,9340) itmax
      if (kkdav.eq.0) then
         acteq = 'Debye-Huckel equation'
      else
         acteq = 'Davies equation      '
      endif
      write (lunout,9350) acteq
      if (kkthr.eq.0) then
         write (lunout,9360)
      else if (kkthr.eq.1) then
         write (lunout,9365)
      else if (kkthr.eq.2) then
         write (lunout,9370)
      endif
c
c  -- The isweep flag indicates whether this is a sweep run (isweep=1)
c     or not (isweep=0).  Proceed to read sweep parameters if it is.
      if (isweep.eq.1) then
        read (lun01,9211) sweep, idxx, nprob
        ierparm = ierparm + 1
        if (sweep.eq.'activity  '.or.sweep.eq.'ACTIVITY  ') then
          sweep = 'ACTIVITY  '
          read (lun01,9212) valinc
          ierparm = ierparm + 1
        else if (sweep.eq.'total conc'.or.sweep.eq.'TOTAL CONC') then
          sweep = 'TOTAL CONC'
          read (lun01,9214) valinc
          ierparm = ierparm + 1
        end if
      else if (isweep.eq.2) then
        read (lun01,9211) sweep, idxx, nprob
        ierparm = ierparm + 1
        if (sweep.eq.'activity  '.or.sweep.eq.'ACTIVITY  ') then
          sweep = 'ACTIVITY  '
          read (lun01,9213) (uvalue(i),i=2,nprob)
          lines = float((nprob-1))/6.0
          nlines = lines
          if ((lines-float(nlines)).gt.0.0) nlines = nlines+1
          ierparm = ierparm + nlines
        else if (sweep.eq.'total conc'.or.sweep.eq.'TOTAL CONC') then
          sweep = 'TOTAL CONC'
          read (lun01,9215) (uvalue(i),i=2,nprob)
          lines = float((nprob-1))/6.0
          nlines = lines
          if ((lines-float(nlines)).gt.0.0) nlines = nlines+1
          ierparm = ierparm + nlines
        end if
      end if
c
c  -- The n123 flag indicates the number of components for special
c     spreadsheet-type output (n123=0 if none).  If n123>0, proceed
c     to read the relevant parameters from the input file.
      if (n123.ne.0) then
        read (lun01,9800) fil123, (id123(i),i=1, n123)
        ierparm = ierparm + 1
        open (unit=lun11,file=fil123,status='unknown',access='append')
      end if
c
c  -- Read next line from input file.  This line pertains to whether
c     adsorption is to be modeled, the number of adsorbing surfaces,
c     and a number identifying the adsorption model.
      read (lun01,9220) iads,numads,iabq
      ierparm = ierparm+1
      if (iads.gt.0) then
         if (iabq.eq.1) then
            adsmodel = 'Activity Kd         '
         elseif (iabq.eq.2) then
            adsmodel = 'Activity Langmuir   '
         elseif (iabq.eq.3) then
            adsmodel = 'Activity Freundlich '
         elseif (iabq.eq.4) then
            adsmodel = 'Ion - Exchange      '
         elseif (iabq.eq.5) then
            adsmodel = 'Constant Capacitance'
         elseif (iabq.eq.6) then
            adsmodel = 'Triple Layer        '
         elseif (iabq.eq.7) then
            adsmodel = 'Diffuse Layer       '
         endif
         write (lunout,9380) adsmodel
         write (lunout,9390) numads
      endif
      write (lunout,9400)
c
c -- If the number of adsorbing surfaces (numads)  > 0, then the next
c    "numads" lines each has parameters relevant to one surface.
      if (numads.gt.0) then
         do 130 i = 1, numads
            read (lun01,9230) atmp1, atmp2, atmp3, atmp4, isurf
            ierparm = ierparm+1
            jsurf = isurf - 80
            solcon(jsurf) = atmp1
            ssa(jsurf) = atmp2
            cap1(jsurf) = atmp3
            cap2(jsurf) = atmp4
            write (lunout,9240) solcon(jsurf), ssa(jsurf), cap1(jsurf),
     *                          cap2(jsurf), isurf
c
c -- Interpret the surface specific parameters in reference to
c    the selected adsorption model and check that all parameters
c    relative to that model have been input.
            if (iads.gt.1) then
               if (solcon(jsurf).lt.D0MIN.or.ssa(jsurf).lt.D0MIN) then
                  write (lunout,9700) ierparm
                  ierr = 4
                  call error
                  go to 999
               end if
               if (iads.eq.2.or.iads.eq.3) then
                  if (dabs(cap1(jsurf)).lt.D0MIN) then
                     write (lunout,9700) ierparm
                     ierr = 4
                     call error
                     go to 999
                  end if
               endif
               if (iads.eq.3) then
                  if (dabs(cap2(jsurf)).lt.D0MIN) then
                    write (lunout,9700) ierparm
                    ierr = 4
                    call error
                    go to 999
                  end if
               endif
            endif
c
  130    continue
      endif
c
c  -- Read the component id number, total dissolved concentration,
c     log free activity guess, and flag indicating whether MINTEQA2
c     is allowed to adjust the guess prior to beginning the iterations.
c     This adjustment is not the same as estimating the new log
c     activity with each succeeding iteration-- that will certainly
c     be done.  The guess that is the subject of a possible
c     re-adjustment here is the INITIAL guess before iterations begin.
c     A better guess here means a faster and more certain convergence.
      j = 0
  140 read (lun01,9020) idxt,tt,gxt,rgt
      if (idxt.eq.0) go to 150
c
c  -- If this is a sweep run, check whether this is the sweep component.
      if (isweep.gt.0) then
        if (idxt.eq.idxx) then
          if (sweep.eq.'TOTAL CONC') then
             startval = tt
          end if
        end if
      end if
c
      write (lunout,9030) idxt,tt,gxt,rgt
      j = j+1
      idx(j) = idxt
      gx(j) = gxt
      t(j) = tt
c  -- Any value other than no (n or N) (including no value at all) is
c     interpreted as yes (y) for the flag indicating whether its it OK
c     to adjust the log free activity guess in subroutines GUESS and
c     GUESS1 prior to beginning the iterations.
      if (rgt.eq.'N') rgt = 'n'
      if (rgt.eq.'n') then
        reguess(j) = 'n'
      else
        reguess(j) = 'y'
      end if
c  -- For components not accompanied by an activity guess at all,
c     make an initial guess of free activity = total conc.  Note
c     that this is not the adjustment referred to above.
      if (dabs(gxt).lt.D0MIN) then
         x(j) = 1.0d0
      else
         x(j) = 10.0d0**gxt
      endif
c
c--  Go back to read the next component in the input file.
      go to 140
  150 continue
c
c  -- Insert H2O as a component and reset insh2o to yes ('y').
c
      ii = j
      do 190 i = 1, ii
         if (idx(i).eq.2) go to 200
  190 continue
      ii = ii+1
      insh2o = 'y'
      idx(ii) = 2
      gx(ii) = 0.d0
      t(ii) = 0.d0
      x(ii) = 1.d0
      write (lunout,9160)
  200 continue
      j = ii
      if (j.gt.nxdim) then
        ierr = 1
        call error
        go to 999
      end if
      nnn = j
c
c     INITIALIZE NN
c
      do 210 l = 1, 6
         nn(l) = 0
  210 continue
c
c     INITIALIZE A,B
c
      do 220 i = 1, nydim
         do 220 j = 1, nxdim
            b(i,j) = 0.0d0
            a(i,j) = 0.0
  220 continue
c
c MAKE SURE ALL INPUT SPECIES ARE VALID COMPONENTS
c
      jj = nnn
      numfnd = 0
c
      do 250 i = 1, jj
         rewind lun03
c
c -- CHANGED UPPER BOUND ON LOOP 221 FROM 73 TO 200 ON 10-12-87 JDA
c
         do 230 l = 1, 200
            read (lun03,9090,end=260) idyt,spcnam,spz,spcdha,spcdhb,
     *         spcgfw
            if (idyt.eq.idx(i)) then
               numfnd = numfnd+1
               name(i) = spcnam
               spcz(i) = spz
               dha(i) = spcdha
               dhb(i) = spcdhb
               gfw(i) = spcgfw
c
c INCLUDE COMPONENTS AS SPECIES
c
               idy(i) = idx(i)
               a(i,i) = 1.0
               gk(i) = 0.0d0
               dh(i) = 0.d0
               maxgk(i) = 0.0
               mingk(i) = 0.0
               go to 240
            endif
  230    continue
  240    continue
  250 continue
  260   if (numfnd.ne.jj) then
          ierparm = ierparm+numfnd+1
          write (lunout,9710) idx(i),ierparm
          ierr = 6
          call error
          go to 999
        end if
      if (insh2o.eq.'y') then
        ierparm = ierparm+jj
      else
        ierparm = ierparm+jj+1
      end if
c
      nn(1) = nnn
c
c INPUT THERMODYNAMIC DATA FOR Composite ligand species
c
      i = nn(1)
      nn(2) = 0
      rewind lun14
      i0 = i
  271 read(lun14,9080,end=301)idyt,spcnam,spcdh,gkt,maxgkt,mingkt,spz,
     *      spcdha,spcdhb,spcgfw,alkft,ncmp,(at(j),idt(j),j=1,ncmp)
c
c
         if (idyt.eq.0) go to 301
c
c
c CHECK TO INSURE ALL COMPONENTS INCLUDED
c
         do 281 j = 1, ncmp
            if (iadx(idt(j)).eq.0) go to 271
  281    continue
         i = i+1
         if (i.gt.nydim) then
           ierr = 2
           call error
           go to 999
         end if
c
c   ASSIGN PARAMETERS FOR COMPLEX (I)
c
         idy(i) = idyt
         gk(i) = gkt
         dha(i) = spcdha
         dhb(i) = spcdhb
         gfw(i) = spcgfw
         spcz(i) = spz
         dh(i) = spcdh
         name(i) = spcnam
         maxgk(i) = maxgkt
         mingk(i) = mingkt
         alkfct(i) = alkft
c
         do 291 m = 1, ncmp
            a(i,iadx(idt(m))) = at(m)
  291    continue
c
c  -- Provide special operations for species that represent
c     complexes with composite ligands.
c  -- First find out if the species read in is a complex involving
c     a composite ligand.  If so, set up the "b" matrix elements
c     for mass balance stoichiometries.
c  -- The mass balance stoichiometry for each component in the
c     reaction is equal to the mass action stoichiometry of that
c     component.
         id1 = idclf*10000
         id2 = idcll*10000 + 9999
         if (idyt .ge. id1 .and. idyt .le. id2) then
c11-08a NOTE: The stoichiometry elements in the database are actually
c       for mass balance, though they are read into array a.  Therefore,
c       they are loaded into array b in the usual place below, i.e.,
c       b = a.
c     We are assuming one composite ligand component per run.
c     Sigma is approximately the same for all components for a given
c     composite ligand.  However, provision is made for the more
c     general case of a sigma specific to each reaction which is
c     stored in the reaction entry in those spaces ordinarily used for
c     enthalpy (dh).  The variable nrxcl counts the number of reactions
c     involving the complex ligand.
           nrxcl = nrxcl + 1
c  -- Store the 7-digit id of the reaction in array idrxcl.
           idrxcl(nrxcl) = idyt
           gkcl(nrxcl) = gkt
c  -- The value entered for enthalpy of reaction (dh) in the database
c     is actually sigma for this entry and the value of dh is unknown
c     so make it equal zero.
           sigma = dh(i)
           dh(i) = 0.0d0
           do 292 m = 1, ncmp
             if (idt(m).ge.idclf.and.idt(m).le.idcll) then
               jxlig = iadx(idt(m))
             else if (idt(m).ne.002) then
               if (nidxcl.eq.0) then
                 nidxcl = 1
                 idxcl(nidxcl) = idt(m)
               else
                 match = 'N'
                 do 293 n = 1, nidxcl
                   if (idt(m).eq.idxcl(n)) match = 'Y'
  293            continue
                 if (match.eq.'N') then
                   nidxcl = nidxcl + 1
                   idxcl(nidxcl) = idt(m)
                 end if
               end if
               do 294 n = 1, nidxcl
                if (idt(m).eq.idxcl(n)) stoica(nrxcl,n) = at(m)
  294          continue
             end if
  292      continue
         end if
c
c  READ DATA FOR NEXT SPECIES
c
         go to 271
c
c  -- Set up pointer array for composite species.
c     jmax(i) stores the number of non-zero elements of array "stoica"
c     for species i.  jpta(i,j) stores the column number address of
c     the jth component which has non-zero stoichiometry in species i.
 301  do 302 icl = 1, nrxcl
        jmaxcl(icl) = 0
        do 303 jcl = 1, nidxcl
          if (abs(stoica(icl,jcl)).gt.0.0) then
           jmaxcl(icl) = jmaxcl(icl) + 1
           jptacl(icl,jmaxcl(icl)) = jcl
          endif
 303    continue
 302  continue
c
c
c
         nn(2) = i-i0
c INPUT THERMODYNAMIC DATA FOR ALL SPECIES EXCEPT TYPE 6 SOLIDS
c
      i = nn(1) + nn(2)
      rewind lun02
      do 310 l = 2, 6
         i0 = i
  270    read (lun02) idyt,spcnam,spcdh,gkt,maxgkt,mingkt,spz,
     *      spcdha,spcdhb,spcgfw,alkft,ncmp,(at(j),idt(j),j=1,ncmp)
c
c READ NEXT GROUP OF THERMODYNAMIC DATA: NOTE DEFAULT GROUPS
c FOR THERMODYNAMIC DATA MUST BE SEPARATED BY TWO BLANK LINES
c IN THE THERMODYNAMIC DATA FILE ALSO THERE MUST BE TWO
c BLANK LINES AT THE END OF THE FILE OR YOU WILL HIT  AN
c END OF FILE CONDITION
c
         if (idyt.eq.0) go to 300
c
c IF IPRINT=0 DO NOT STORE DATA FOR TYPE 5 FROM FILE LUN02
c
         if (iprint.eq.0.and.l.eq.5) go to 270
c
c CHECK TO INSURE ALL COMPONENTS INCLUDED
c
         do 280 j = 1, ncmp
            if (iadx(idt(j)).eq.0) go to 270
  280    continue
         i = i+1
         if (i.gt.nydim) then
           ierr = 2
           call error
           go to 999
         end if
c
c   ASSIGN PARAMETERS FOR COMPLEX (I)
c
         idy(i) = idyt
         gk(i) = gkt
         dha(i) = spcdha
         dhb(i) = spcdhb
         gfw(i) = spcgfw
         spcz(i) = spz
         dh(i) = spcdh
         name(i) = spcnam
         maxgk(i) = maxgkt
         mingk(i) = mingkt
         alkfct(i) = alkft
c
         do 290 m = 1, ncmp
            a(i,iadx(idt(m))) = at(m)
  290    continue
c
c
c  READ DATA FOR NEXT SPECIES
c
         go to 270
c
  300    nn(l) = nn(l) + i-i0
  310 continue
c
c     READ SPECIES MODIFICATION & TYPE SPECIFICATIONS
      fxdph = 'n'
      fxdph = 'n'
c
      entry intype
      k = 0
  320 read (lun01,9060) ltype,ntype
      ierparm = ierparm + 1
      if (ltype.eq.0) go to 360
      write (lunout,9070) ltype,ntype
      if (ltype.gt.6) then
c  -- The error parameter will contain the line number in the input
c     file where the LTYPE greater than six occurs.
        write (lunout,9700) ierparm
        ierr = 5
        call error
        go to 999
      end if
      do 350 n = 1, ntype
         conc = 0.0d0
         if (ltype.eq.4) then
            read (lun01,9040) idyt,gkt,dht,conc
            ierparm = ierparm+1
            write (lunout,9050) idyt,gkt,dht,conc
         else
            read (lun01,9045) idyt,gkt,dht
            ierparm = ierparm+1
            write (lunout,9055) idyt,gkt,dht
            if (idyt.eq.001) then
               fxdpe = 'y'
               systempe = gkt
            end if
            if (idyt.eq.330) then
               fxdph = 'y'
               systemph = gkt
            end if
         endif
c
         if (ltype.eq.3.and.isweep.gt.0) then
           if (sweep.eq.'ACTIVITY') then
             if (idyt.eq.idxx) then
               startval = gkt
             end if
           end if
         end if
c
c     SEARCH
c
         ii = 0
         do 340 l = 1, 6
            if (nn(l).eq.0) go to 340
            i0 = ii+1
            ii = ii+nn(l)
            do 330 i = i0, ii
               if (idy(i).ne.idyt) go to 330
               if (dabs(gkt).gt.D0MIN) gk(i) = gkt
               if (dabs(dht).gt.D0MIN) dh(i) = dht
               if (dabs(conc).gt.D0MIN) c(i) = conc
c  -- If the type modification is to fix the activity of some
c     component other than H2O or E-, that is, to make that component
c     TYPE 3, then call Subroutine DUPCMP to first duplicate it as a
c     TYPE 1 component.  Upon return from DUPCMP, call Subroutine
c     SWITCH to MOVE one of the two identical entries to TYPE 3.
c     In this way, the TYPE 1 identity of the component is retained.
               if(idyt.le.999.and.idyt.gt.2.and.ltype.eq.3) then
                 idnew = idyt
                 call dupcmp (idnew,i)
               end if
               call switch (l,ltype,i)
               go to 350
  330       continue
  340    continue
c
c SEARCH UNSUCCESSFUL: STORE DATA FOR ONE LOOP THROUGH TYPE 6 FILE
c
         k = k+1
         dhdum(k) = dht
         idydum(k) = idyt
         gkdum(k) = gkt
         cdum(k) = conc
         ityp(k) = ltype
         ifnd(k) = 0
  350 continue
      go to 320
c
c LOOP THROUGH TYPE 6 SOLIDS FILE ONLY ONCE
c
  360 ii = k
      if (ii.eq.0) go to 430
      kount = 0
      rewind lun04
  370 read (lun04) idytnw,spcnam,spcdh,gkt,maxgkt,mingkt,spz,
     *   spcdha,spcdhb,spcgfw,alkft,ncmp,(at(j),idt(j),j=1,ncmp)
c
c IF ENTIRE FILE READ PRINT THE SPECIES WHICH DID NOT
c MATCH THEN TERMINATE EXECUTION
c
      if (idytnw.eq.0) then
         do 380 j = 1, ii
            if (ifnd(j).eq.1) go to 380
            write (lunout,9720) idydum(j)
            ierr = 3
            call error
            go to 999
  380    continue
      endif
c
c LOOP THROUGH ALL STORED SPECIES
c
      do 410 i = 1, ii
         if (idytnw.ne.idydum(i)) go to 410
c
c CHECK TO INSURE ALL COMPONENTS PRESENT
c
         do 390 m = 1, ncmp
            if (iadx(idt(m)).ne.0) go to 390
            write (lunout,9180) idytnw,idt(m)
            ifnd(i) = 1
            go to 420
  390    continue
         i0 = nn(1)+nn(2)+nn(3)+nn(4)+nn(5)+nn(6)+1
         idy(i0) = idytnw
         gk(i0) = gkdum(i)
         if (dabs(gk(i0)).lt.D0MIN) gk(i0) = gkt
         dha(i0) = spcdha
         dhb(i0) = spcdhb
         gfw(i0) = spcgfw
         spcz(i0) = spz
         dh(i0) = dhdum(i)
         if (dabs(dh(i0)).lt.D0MIN) dh(i0) = spcdh
         if (cdum(i).gt.D0MIN) c(i0) = cdum(i)
         name(i0) = spcnam
         maxgk(i0) = maxgkt
         mingk(i0) = mingkt
         alkfct(i0) = alkft
         do 400 m = 1, ncmp
            a(i0,iadx(idt(m))) = at(m)
  400    continue
         ifnd(i) = 1
         nn(6) = nn(6)+1
         l = 6
         ltype = ityp(i)
         call switch (l,ltype,i0)
         go to 420
  410 continue
      go to 370
c
c NOW INCREASE COUNTER OF FOUND SPECIES AND CHECK TO
c SEE IF ALL WERE FOUND
c
  420 kount = kount+1
      if (kount.eq.ii) then
         rewind lun04
         go to 430
      endif
      go to 370
c
c    SETUP B MATRIX
c
  430 continue
c
      i0 = nn(1)+nn(2)+nn(3)+nn(4)+nn(5)+nn(6)
      do 440 i = 1, i0
        do 440 j = 1, nnn
            b(i,j) = a(i,j)
            if (idy(i).ge.id1.and.idy(i).le.id2) then
            a(i,j) = 0.0
           end if
  440 continue
c///////////////////////////////////////////////////////
c      i0 = nn(1)+nn(2)+nn(3)+nn(4)+nn(5)+nn(6)
c      do 440 i = 1, i0
c	 do 440 j = 1, nnn
c            b(i,j) = a(i,j)
c  440 continue
cclllllllllllllllllllllllllllllllllllllllllllllllllllllll
c      do 339 i = 1, i0
c         if (idy(i).eq.1452110) then
c         write (lunout,*) idy(i)
c	 do 338 j = 1, nnn
c            write (lunout,*) idx(j),'  A= ', a(i,j),' B= ',b(i,j)
c  338    continue
c         end if
c  339 continue
clllllllllllllllllllllllllllllllllllllllllllllllllllllll
c      do 441 i = 1, i0
c         if (idy(i).ge.2400000.and.idy(i).le.2499999) then
c           ii = iady(330)
cc	   if (idy(i).ge.2570000) kk = iadx(330)
c           do 442 j = 1, nnn
c             if (a(i,j).ne.0.0) then
c	       if (idx(j).ge.240.and.idx(j).le.249) then
c                  jj = j
c               else if (idx(j).ne.330.and.idx(j).ne.002) then
c                  ii = iady(idx(j))
c               end if
c             end if
c 442       continue
c           b(i,jj) = abs(spcz(ii))
cc          if (idy(i).ge.2570000) b(i,kk) = -b(i,jj)
c         end if
c 441  continue
c///////////////////////////////////////////////////////
c      do 443 i = 1, i0
c         if (idy(i).eq.1452110) then
c         write (lunout,*) idy(i)
c	 do 444 j = 1, nnn
c            write (lunout,*) idx(j),'  A= ', a(i,j),' B= ',b(i,j)
c  444    continue
c         end if
c  443 continue
c  CHECK FOR INSERTION OF SPECIES NOT IN DATA BASE
c
      kount = 0
  450 continue
      read (lun01,9060) ltype,ntype
      ierparm = ierparm + 1
c
c TERMINATE INPUT STREAM
c
      if (ltype.eq.0) go to 510
      if (ltype.gt.6) then
c  -- The error parameter will contain the line number in the input
c     file where the LTYPE greater than six occurs.
        write (lunout,9700) ierparm
        ierr = 5
        call error
        go to 999
      end if
      write (lunout,9070) ltype,ntype
      do 500 n = 1, ntype
c
c 5/12/83 KRUPKA CHANGED NUMBER OF MAX COMPONENTS IN REACTION
c         FOR NEW SPECIES OR SOLID FROM 9 TO 12; ALSO
c         CHANGED  DIM OF ARRAY 'AT' AND 'IDT' AND FORMAT 570
c
         read (lun01,9190) idyt,spcnam,spcdh,gkt,maxgkt,mingkt,spz,
     *      spcdha,spcdhb,spcgfw,alkft,ncmp,(at(j),idt(j),j=1,12),
     *      nbcmp,(bt(j),ibt(j),j=1,3)
         write (lunout,9200) idyt,spcnam,spcdh,gkt,maxgkt,mingkt,spz,
     *      spcdha,spcdhb,spcgfw,alkft,ncmp,(at(j),idt(j),j=1,12),
     *      nbcmp,(bt(j),ibt(j),j=1,3)
c
c A BLANK CARD INITIATES CHECK FOR INSERTED SPECIES
c ***NOTE: IT TAKES 2 BLANK CARDS IN A ROW TO TERMINATE INPUT STREAM
c
c
c CHECK TO INSURE ALL COMPONENTS OF INSERTED SPECIE ARE PRESENT
c
         do 460 j = 1, ncmp
            if (iadx(idt(j)).ne.0) go to 460
            write (lunout,9100) idyt
            go to 500
  460    continue
c
c SEARCH MEMORY FOR DUPLICATE ID NUMBERS
c NOTE: THIS SEARCH DOES NOT INCLUDE TYPE 6 SOLIDS
c THE ID NUMBERS NOT FOUND IN MEMORY WILL BE
c STORED AND COMPARED AGAINST THE TYPE 6 SOLIDS
c FILE WHEN TYPE 6 SOLIDS ARE READ IN SUBROUTINE IAP
c
         ii = nn(1)+nn(2)+nn(3)+nn(4)+nn(5)+nn(6)
         do 470 m = 1, ii
            if (idy(m).ne.idyt) go to 470
            write (lunout,9110) idyt
            go to 500
  470    continue
c
c NOW STORE ID NUMBERS FOR LATER SEARCH IN SUBROUTINE IAP
c
         kount = kount+1
         idydum(kount) = idyt
c
c INSERT SPECIE FROM INPUT SAMPLE FILE
c
         i = nn(1)+nn(2)+nn(3)+nn(4)+nn(5)+nn(6)+1
         if (i.gt.nydim) then
           ierr = 2
           call error
           go to 999
         end if
         idy(i) = idyt
         gk(i) = gkt
         dha(i) = spcdha
         dhb(i) = spcdhb
         gfw(i) = spcgfw
         spcz(i) = spz
         dh(i) = spcdh
         name(i) = spcnam
         maxgk(i) = maxgkt
         mingk(i) = mingkt
         alkfct(i) = alkft
c
         do 480 j = 1, ncmp
            jp = iadx(idt(j))
            a(i,jp) = at(j)
            b(i,jp) = at(j)
  480    continue
c
c NOW CORRECT B MATRIX
c
         if (nbcmp.gt.0) then
            do 490 j = 1, nbcmp
               b(i,iadx(ibt(j))) = bt(j)
  490       continue
         endif
c
         l = 6
         nn(6) = nn(6)+1
c
c NOW SWITCH TYPES IF NECESSARY
c
         call switch (l,ltype,i)
  500 continue
      go to 450
c
  510 continue
c
c CHANGE S(0) AND H2O TO TYPE 3
c
      i = iady(2)
      l = 1
      ltype = 3
      call switch (l,ltype,i)
c
c
c OUTPUT DATA AFTER ALL INSERTIONS AND TYPE CHANGES
c
      if (isweep.eq.1) then
        do 128 i = 1, nprob
          uvalue(i) = startval + (i-1) * valinc
  128   continue
      else if (isweep.eq.2) then
        uvalue(1) = startval
      end if
      if (isweep.gt.0) then
        write (lunout,5750) 1
        call tstamp
        write (lunout, 9400)
        write (lunout, 9401)
        write (lunout, 9216) nprob
        if (sweep.eq.'ACTIVITY  ') then
          if (idxx.eq.330) then
            write (lunout, 9217)
          else if (idxx.eq.001) then
            write (lunout, 9218)
          else
            write (lunout, 9219) idxx
          end if
          write (lunout, 9222) (uvalue(i),i=1,nprob)
        else
          write (lunout, 9221) idxx
          write (lunout, 9223) (uvalue(i),i=1,nprob)
        end if
        write (lunout, 9224)
        write (lunout, 9401)
        write (lunout, 9400)
      end if
      call oincmp
      if (kkthr.eq.0) call oinspc
c
  999 return
c
 9000 format (a75)
 9010 format (f5.2,1x,a5,1x,f6.3,1x,f7.4)
 9020 format (i7,1x,e10.3,1x,f7.2,1x,a1)
 9030 format (' ',i7,1x,1pe10.3,1x,0pf7.2,1x,a1)
 9040 format (i7,2(2x,f9.4),2x,e10.3)
 9050 format (' ',i7,2(2x,f9.4),2x,1pe10.3)
 9045 format (i7,2(2x,f9.4))
 9055 format (' ',i7,2(2x,f9.4))
 9060 format (i3,1x,i3)
 9070 format (' ',i3,1x,i3)
 9080 format (i7,1x,a12,2f10.4,2f8.3,3f5.2,f9.4/f5.2,1x,i1,3x,5(f7.3,
     *   1x,i3,3x))
 9090 format (i3,1x,a8,f4.1,4x,f5.2,f5.2,8x,f11.5)
 9100 format ('0','Not all of the required components for species: ',
     *   i7,' are present.  SPECIES IGNORED')
 9110 format ('0','There is a species in the thermodynamic database',
     *            ' with this same id: ',i7,
     *          /,' SPECIES IGNORED')
 9130 format ('0',a75)
 9140 format (' ',a75)
 9160 format ('0',' H2O has been inserted as a COMPONENT')
 9180 format ('0','Species ',i7,' WITH TYPE CHANGE WAS A',
     *   ' TYPE 6 SOLID AND COMPONENT ',i3,' WAS NOT INPUT',
     *   ' :SPECIE IGNORED')
 9190 format (i7,1x,a12,2f10.4,2f8.3,3f5.2,f9.4/f5.2,i2,1x,6(f7.3,1x,
     *   i3,1x)/6(f7.3,1x,i3,1x)/i1,3(f7.3,1x,i3,1x))
 9200 format (' ',i7,1x,a12,2f10.4,2f8.3,3f5.2,f9.4/f5.2,i2,1x,6(f7.3
     *   ,1x,i3,1x)/6(f7.3,1x,i3,1x)/i1,3(f7.3,1x,i3,1x))
 9210 format (13(i1,1x))
 9211 format (a10,1x,i3,1x,i2)
 9212 format (f6.2)
 9213 format (6(1x,f6.2))
 9214 format (e10.3)
 9215 format (6(1x,e10.3))
 9216 format (' ----------- THE INPUT DATA WILL BE USED IN A SERIES ',
     *        'OF ',i2,' SWEEPS ------------',
     *       /'   The input parameters for each sweep will',
     *        ' be identical to this initial',
     *       /'   listing except that:')
 9217 format ('   --  The fixed equilibrium pH in successive sweeps',
     *        ' will be: ')
 9218 format ('   --  The fixed equilibrium pe in successive sweeps',
     *        ' will be: ')
 9219 format ('   --  The fixed equilibrium log activity of ',
     *        ' component number ',i3,' in',
     *       /'       successive sweeps will be: ')
 9221 format ('   --  The total dissolved concentration of ',
     *        ' component number ',i3,' in',
     *       /'       successive sweeps will be: ',e10.3)
 9224 format ('   --  After the first sweep, the initial',
     *        ' component activity guesses',
     *      /,'       for each successive sweep are the equilibrium' ,
     *        ' activities computed at the',
     *      /,'       end of the sweep which precedes it.')
 9222 format (6x,6(1x,f6.2),3(/,6x,6(1x,f6.2)))
 9223 format (6x,6(1x,1pe10.3),3(/,6x,6(1x,1pe10.3)))
 9220 format (i1,3x,i1,3x,i1)
 9230 format (e9.3,1x,f7.2,1x,f5.3,1x,f5.3,1X,I2)
 9240 format (' ',1pe9.3,1x,0pf7.2,1x,f5.3,1x,f5.3,1X,I2)
 9250 format (/,' -------------------------------------------------'
     *   ,'-------------------------------',/
     *   '  Temperature (Celsius): ',f6.2,/
     *   '  Units of concentration: ',a5)
 9260 format ('  Ionic strength to be computed.')
 9270 format ('  Ionic strength: ',f6.3,' molal; FIXED')
 9280 format ('  If specified, carbonate concentration',
     *   ' represents total inorganic carbon.')
 9290 format ('  Carbonate concentration represents carbonate',
     *   ' alkalinity.')
 9300 format ('  Do not automatically terminate if charge imbalance',
     *   ' exceeds 30% ')
 9310 format ('  Automatically terminate if charge imbalance',
     *   ' exceeds 30% ')
 9320 format ('  Precipitation is allowed only for those solids',
     *   ' specified as ALLOWED',/,'    in the input file (if any).')
 9330 format ('  Precipitation is allowed for all solids in the',
     *   ' thermodynamic database and'/,
     *   '    the print option for solids is set to: ',i1)
 9340 format ('  The maximum number of iterations is: ',i3)
 9350 format ('  The method used to compute activity',
     *   ' coefficients is: ',a21)
 9360 format ('  Full output file')
 9365 format ('  Intermediate output file ')
 9370 format ('  Abbreviated output file')
 9380 format ('  Adsorption model: ',a20)
 9390 format ('  Number of adsorbing surfaces: ',i1)
 9400 format (/' ---------------------------------------------------',
     *   '----------------------------')
 9401 format (/' !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!',
     *   '!!!!!!!!!!!!!!!!!!!!!!!!!!!!')
 9800 format (a12,6(1x,i7))
 9700 format (/,' An error has occurred at line ',i3,' of the input',
     *          ' file.')
 9710 format (/,' The component id ',i3,' listed on line ',i3,' of',
     *          ' the input file',
     *        /,' is not a valid MINTEQA2 component.')
 9720 format (/,' Species id ',i7,' listed in the input file was',
     *          ' not found in any',
     *        /,' MINTEQA2 database file.')
 5750 format ('1',//,' ________________________________________',
     *        '________________________________________',
     *      /,' ______________________________ PART ',i1,' of',
     *        ' OUTPUT FILE ___________________________')
 5700 format (//,' ________________________________________',
     *        '________________________________________',
     *      /,' ______________________________ PART ',i1,' of',
     *        ' OUTPUT FILE ___________________________')
c
      end
