      subroutine kcorr
c
c ******************************************************************
c
c KCORR
c
c THIS SUBROUTINE CORRECTS THE EQUILIBRIUM CONSTANTS FOR
c IONIC STRENGTH
c
c *****************************************************************
c
      include 'MINTEQA2.INC'
c
c -- THE INCLUDE FILE HAS A PARAMETER STATEMENT THAT SETS BOTH
c    NXDIM AND NYDIM.  (THEIR VALUES DEPEND UPON THE MEMORY
c    CAPACITY OF THE COMPUTER.)  THE INCLUDE STATEMENT ABOVE
c    MUST COME BEFORE THE DIMENSION STATEMENT FOR GK2 SINCE
c    NYDIM IS USED FOR AN ADJUSTABLE ARRAY DIMENSION. 10-14-87 JDA
c
      dimension gk1(nydim)
c
      real*8 gk1
c
      i3 = nn(1)+nn(2)
      if (isopt.eq.0) then
        do 100 i = 1, i3
           gk(i) = gk1(i)
  100   continue
      end if
c
c  CORRECT FOR GAMMA OF SPECIES I
c
      do 120 i = 1, i3
         gk(i) = gk(i)-gamma(i)
  120 continue
c
c
      return
c
c AFTER ALTERING K'S FOR PRECIPITATION OR DISSOLUTION
c RESET GK1 ARRAY
c
      entry kcorr2
      i3 = nn(1)+nn(2)
      do 140 i = 1, i3
         gk1(i) = gk(i)
  140 continue
c
c
      return
      end
