      subroutine nxtprb (idxx, sweep)
c
c  -- The purpose of this routine is to generate the next problem
c     from the initial problem specification read from the input
c     file and stored on unit 12.  This routine is called from
c     subroutine MAIND after a speciation problem is solved but
c     before the next in a series of identical problems begins.
c     The series of problems are presented to MINTEQA2 as a
c     single-problem input file with the specifications for changing
c     the pH, eh, or total concentrations of some component,
c     embedded within it.
c
c     NXTPRB is called only for problems that are to be run at
c     a series of fixed activities or total concentrations of some
c     component.
c
      include 'MINTEQA2.INC'
c
      real*8 spz
      integer idxx
      character sweep*10, uflag*5
      include 'CONST.INC'
c
      if (iprob.eq.nprob) then
        xstop = 'y'
        go to 999
      end if
c
      iter = 0
c
      iprob = iprob + 1
c  -- Find address of sweep component in component space.
      j = iadx(idxx)
c
c  -- Find address of sweep component in species space.  Ordinarily,
c     Function IADY might be used for this but since modifying to
c     retain component 330 as a TYPE 1 species, that component will
c     have two addresses in species space.  The first is the TYPE 1
c     address and the second is the TYPE 3 fixed species address.
c     IADY always returns the first address (which will also be the
c     only address if the component is not fixed).  Here, we always
c     want the second address so a modified form of IADY is used
c     here to provide same.
      ii = nn(1)+nn(2)+nn(3)+nn(4)+nn(5)+nn(6)
      if (ii.lt.1) go to 110
      do 100 i = 1, ii
         if (idy(i).eq.idxx) iii = i
  100 continue
      i = iii
      go to 120
  110 continue
      i = 0
  120 continue
      if (sweep.eq.'ACTIVITY  ') then
        gx(j) = (-1) * uvalue(iprob)
        x(j) = 10.0d0**gx(j)
        gk(i) = uvalue(iprob)
      else if (sweep.eq.'TOTAL CONC') then
        t(j) = uvalue(iprob)
c
        uflag = units
        if (uflag.eq.'MEQ/L') then
          i = iady(idx(j))
          spz = abs(spcz(i))
          t(j) = t(j)*gfw(i)/dmax1(1.0d0,spz)
          uflag = 'MG/L '
        endif
c
        if (uflag.eq.'MG/L ') then
          t(j) = t(j)/dens
          uflag = 'PPM  '
        endif
c
c  -- For conversion of other units to molal, an approximation is
c     used that involves the sum of all component concentrations
c     in ppm.  This sum is computed initially in subroutine PREP
c     and must now be adjusted before using it in the ppm to molal
c     conversion equation because the concentration of the sweep
c     component hase changed.  Subtract the former concentration of
c     sweep component and add the new concentration of same.
        cppm = cppm - uvalue(iprob-1)
        cppm = cppm + t(j)
c
        if (uflag.eq.'PPM  ') then
          i = iady(idx(j))
          if (gfw(i).lt.D0MIN) go to 500
          t(j) = t(j)*(1.0d0/(1.0d0-1.0d-6*cppm))/(1.0d3*gfw(i))
          uflag = 'MOL  '
        endif
  500   continue
      end if
c
      write (lunout,5750) 1
      call tstamp
      write (lunout, 9400)
      write (lunout, 9401)
      write (lunout,2000)  iprob, nprob
      if (sweep.eq.'ACTIVITY  ') then
        if (idxx.eq.330) then
          write (lunout,2010) uvalue(iprob)
        else if (idxx.eq.001) then
          write (lunout,2020) uvalue(iprob)
        else
          write (lunout,2030) name(i), uvalue(iprob)
        end if
      else if (sweep.eq.'TOTAL CONC') then
        write (lunout,2040) name(i), t(j)
      end if
      write (lunout,2050)
      write (lunout, 9401)
      write (lunout, 9400)
c
  999 return
 9400 format (/' ---------------------------------------------------',
     *   '----------------------------')
 9401 format (/' !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!',
     *   '!!!!!!!!!!!!!!!!!!!!!!!!!!!!')
 2000 format (' *** This is the beginning of SWEEP NUMBER ',i2,
     *        ' in the series of ',i2,' ***',
     *       /' ---------------------------------------------------',
     *        '----------------------------',
     *       /' ---------------------------------------------------',
     *        '----------------------------',
     *      //' The input for this sweep is identical to the initial',
     *      ' sweep except:')
 2010 format ('   1)  The fixed pH is:  ',f6.2)
 2020 format ('   1)  The fixed Eh is:  ',f6.2)
 2030 format ('   1)  The fixed log activity of the component ' ,a12,
     *        ' is:  ',f6.2)
 2040 format ('   1)  The total concentration of the component ',a12,
     *        ' is:  ',1pe10.3)
 2050 format ('   2)  The log activity guesses for all components',
     *        ' are as computed at',
     *      /,'       the point of FIRST convergence in the previous',
     *        ' problem.')
5750  format ('1',//,' ________________________________________',
     *        '________________________________________',
     *      /,' ______________________________ PART ',i1,' of',
     *        ' OUTPUT FILE ___________________________')
      end
