      subroutine output (lastime)
c
c ******************************************************************
c
c OUTPUT
c
c THIS SUBROUTINE PRINTS THE INPUT DATA AS WELL AS THE RESULTS OF
c THE AQUEOUS SPECIATION AND MASS TRANSFER CALCULATIONS. SATURATION
c INDICIES FOR ALL SOLIDS ARE PRINTED IN SUBROUTINE IAP.
c
c THE ENTRY POINTS: OINCMP,OINSPC,OUTCMP,OUTSPC AND OUTPC HAVE
c ESSENTIALLY THE SAME FUNCTIONS AS IN THE ORIGINAL MINEQL CODE.
c THEY HAVE BEEN MODIFIED ONLY TO ACCEPT HE DIFFERENT VARIABLES
c FROM THE WATEQ DATA.
c
      include 'MINTEQA2.INC'
c
      real*8 alf,alfa,cc1,cc2,cc3,diff,gam,pc,v,sv,sd,totmass,
     *   vprcnt,svprcnt,sdprcnt,dprm123(8),sprm123(8),pprm123(8),
     *   conc123(8)
c
      integer idw123(8)
      character lastime*1
      include 'CONST.INC'
c
c
c INPUT DATA COMPONENTS
c
      entry oincmp
      if (kkthr.eq.2) go to 105
      jj = nnn
      write (lunout,9070)
      write (lunout,9080)
      do 100 j = 1, jj
         i = iady(idx(j))
         write (lunout,9090) idx(j),name(i),x(j),gx(j),t(j)
  100 continue
  105 return
c
c INPUT DATA SPECIES
c
      entry oinspc
c
      write (lunout,5750) 2
      call tstamp
      write (lunout,9100)
      ii = nn(1)+nn(2)+nn(3)+nn(4)+nn(5)+nn(6)
      jj = nnn
      l = 0
      m = 1
      do 130 i = 1, ii
         if (m.ne.i) go to 120
  110    l = l+1
         if (nn(l).eq.0) go to 110
         m = m+nn(l)
         write (lunout,9110)
         write (lunout,9115)
c  -- Write input information pertaining to all species types.
         if (l.eq.1) then
           write (lunout,9121)
         else if (l.eq.2) then
           write (lunout,9122)
         else if (l.eq.3) then
           write (lunout,9123)
         else if (l.eq.4) then
           write (lunout,9127)
         else if (l.eq.5) then
           write (lunout,9128)
         else if (l.eq.6) then
           write (lunout,9126)
         end if
         write (lunout,9130)
  120    continue
         write (lunout,9140) idy(i),name(i),dh(i),gk(i),maxgk(i),mingk(
     *      i),spcz(i),dha(i),dhb(i),gfw(i)
  130 continue
      return
c
c COMPONENT OUTPUT
c
      entry outcmp
      ii = nn(1)+nn(2)+nn(3)+nn(4)+nn(5)+nn(6)
      jj = nnn
      write (lunout,9150)
      do 170 j = 1, jj
         i = iady(idx(j))
         gam = 10.0d0**gamma(i)
c         if (idx(j).eq.999) go to 170
c         write (lunout,9160) idx(j),name(i),t(j),c(i),x(j),gx(j),gam,gk
c     *      (i),y(j)
         write (lunout,9160) idx(j),name(i),t(j),c(i),gx(j),gam,y(j)
  170 continue
      return
c
c SPECIES OUTPUT
c
      entry outspc (lastime)
      if (kkthr.eq.2) go to 205
      ii = nn(1)+nn(2)+nn(3)+nn(4)+nn(5)+nn(6)
      jj = nnn
      l = 0
      m = 1
      do 200 i = 1, ii
         if (m.ne.i) go to 190
  180    l = l+1
         if (nn(l).eq.0) go to 180
         m = m+nn(l)
         write (lunout,9110)
         write (lunout,9115)
c  -- Write output information pertaining to all species types.
         if (l.eq.1) then
           write (lunout,9121)
         else if (l.eq.2) then
           write (lunout,9122)
         else if (l.eq.3) then
           write (lunout,9123)
         else if (l.eq.4) then
           if (lastime.eq.'y') then
             write (lunout,9124)
           else
             write (lunout,9127)
           end if
         else if (l.eq.5) then
           if (lastime.eq.'y') then
             write (lunout,9125)
           else
             write (lunout,9128)
           end if
         else if (l.eq.6) then
           write (lunout,9126)
         end if
         if (l.ge.3) then
            write (lunout,9240)
         else
            write (lunout,9170)
         endif
  190    continue
         if (l.ge.3) then
            if (l.eq.4.and.c(i).lt.0.0d0) c(i) = 0.0d0
            write (lunout,9250) idy(i),name(i),c(i),gc(i),gk(i),dh(i)
         else
            alfa = gc(i)+gamma(i)
            alf = 10.0d0**alfa
            gam = 10.0d0**gamma(i)
            write (lunout,9180) idy(i),name(i),c(i),alf,alfa,gam,gk(i)
         endif
  200 continue
  205 return
c
c OUTPUTS PERCENTAGES
c
      entry outpc (lastime)
      jj = nnn
c
      write (lunout,5750) 4
      call tstamp
c
      write (lunout,9190)
c
      do 390 k = 1, 8
         idw123(k) = 0
  390 continue
      do 400 k = 1, jj
         if (idx(k).eq.330) idw123(1) = 330
         if (idx(k).eq.001) idw123(2) = 001
  400 continue
      idw123(3) = id123(1)
      idw123(4) = id123(2)
      idw123(5) = id123(3)
      idw123(6) = id123(4)
      idw123(7) = id123(5)
      idw123(8) = id123(6)
      i1 = 1
      i2 = nn(1)+nn(2)
      do 230 j = 1, jj
         write (lunout,9110)
         i = iady(idx(j))
         write (lunout,9200) name(i)
c
         v = 0.0d0
         do 210 i = i1, i2
            if (ABS(b(i,j)).le.0.001) go to 210
            v = v+b(i,j)*c(i)
  210    continue
         if (dabs(v).lt.D0MIN) then
           go to 230
         endif
        do 220 i = i1, i2
            if (ABS(b(i,j)).le.0.001) go to 220
            pc = b(i,j)*c(i)/v
c  - Do not include in printing percent distribution if species
c    is less than 1 percent of total component dissolved mass.
            if (pc.lt.0.01d0) go to 220
            pc = pc*100.0d0
            if (pc.gt.1000.0d0) then
               write (lunout,9220) idy(i),name(i)
            else
               write (lunout,9210) pc,idy(i),name(i)
            endif
  220    continue
  230 continue
c
c --- THE FOLLOWING SECTION MODIFIED 04/04/88 BY JD ALLISON.
c --- CALCULATE AND PRINT DISSOLVED, ADSORBED, AND PRECIPITATED
c     MASS TOTALS FOR EACH COMPONENT EXCEPT DON'T BOTHER WITH
c     THE PRECIPITATED TOTALS FOR H2O, H+1, OR E-1.  EXPRESS
c     RESULTS AS PERCENT IN EACH PHASE FOR EACH COMPONENT.
c
      write (lunout,5750) 5
      call tstamp
      if (lastime.eq.'y') then
        write (lunout,9260)
      else
        write (lunout,9261)
      end if
      write (lunout,9270)
c
c --- SET INDICES THAT DEFINE BOUNDARIES OF DISSOLVED SPECIES, THAT I
c     TYPES 1 AND 2, AND PRECIPITATES (TYPE 4) IN THE ARRAYS IDY AND
c
      i0 = nn(1)+nn(2)
      i1 = i0+nn(3)+1
      i2 = i1+nn(4)-1
c
      do 270 j = 1, nnn
         v = 0.0d0
         sv = 0.0d0
         if (idx(j).ge.811.and.idx(j).le.859) go to 270
         do 250 i = 1, i0
            if (ABS(b(i,j)).le.0.001) go to 250
            if (idy(i).ge.8110000.and.idy(i).le.8599999) then
               sv = sv+b(i,j)*c(i)
            else
               v = v+b(i,j)*c(i)
            endif
  250    continue
         sd = 0.0d0
         if (idx(j).gt.002.and.idx(j).ne.330) then
            do 260 i = i1, i2
               if (ABS(b(i,j)).le.0.001) go to 260
               sd = sd+b(i,j)*c(i)
  260       continue
         endif
c
c --- CALCULATE TOTAL MASS IN THE SYSTEM FOR THIS COMPONENT.  THIS
c     MAY BE THE SAME AS WAS INPUT BUT NOT NECESSARILY DUE TO MASS
c     TRANSFER BETWEEN REDOX COUPLES.
c
         totmass = v+sv+sd
c  -- For use in further calculations, i.e., titrations, calclculate
c     the new total dissolved concentrations.  For this purpose,
c     sorbed fraction is considered part of the "dissolved" phase.
c
c --- CALCULATE PERCENT OF TOTAL MASS THAT IS DISSOLVED, ADSORBED AND
c     PRECIPITATED.
c
         if (dabs(totmass).gt.D0MIN) then
            vprcnt = v/totmass*100.0d0
            svprcnt = sv/totmass*100.0d0
            sdprcnt = sd/totmass*100.0d0
         else
            vprcnt = 0.D0
            svprcnt = 0.D0
            sdprcnt = 0.D0
         endif
         n = iady(idx(j))
         write (lunout,9280) idx(j),name(n),v,vprcnt,sv,svprcnt,sd,
     *      sdprcnt
c --- Modify to write the dissolved, sorbed, and precipitated
c     totals in molal and as percent of total to a separate file opened
c     in the main program (on unit 11) ONLY for the
c     component that is first in the component list of the input file.
c     Write the pH as well, all on one line.  The purpose is to allow
c     quick assessment of results for multiple runs.  The id number of
c     that component is assigned to variable IDRESULT in SUBROUTINE
c     INPUT.
         if (lastime.eq.'y') then
           if (n123.gt.0.and.(ntyp123.eq.1.or.ntyp123.eq.2)) then
             if (idx(j).eq.idw123(3)) then
               if (ntyp123.eq.1) then
                dprm123(3) = vprcnt
                sprm123(3) = svprcnt
                pprm123(3) = sdprcnt
               else if (ntyp123.eq.2) then
                dprm123(3) = v
                sprm123(3) = sv
                pprm123(3) = sd
               end if
             else if (idx(j).eq.idw123(4)) then
               if (ntyp123.eq.1) then
                dprm123(4) = vprcnt
                sprm123(4) = svprcnt
                pprm123(4) = sdprcnt
               else if (ntyp123.eq.2) then
                dprm123(4) = v
                sprm123(4) = sv
                pprm123(4) = sd
               end if
             else if (idx(j).eq.idw123(5)) then
               if (ntyp123.eq.1) then
                dprm123(5) = vprcnt
                sprm123(5) = svprcnt
                pprm123(5) = sdprcnt
               else if (ntyp123.eq.2) then
                dprm123(5) = v
                sprm123(5) = sv
                pprm123(5) = sd
               end if
             else if (idx(j).eq.idw123(6)) then
               if (ntyp123.eq.1) then
                dprm123(6) = vprcnt
                sprm123(6) = svprcnt
                pprm123(6) = sdprcnt
               else if (ntyp123.eq.2) then
                dprm123(6) = v
                sprm123(6) = sv
                pprm123(6) = sd
               end if
             else if (idx(j).eq.idw123(7)) then
               if (ntyp123.eq.1) then
                dprm123(7) = vprcnt
                sprm123(7) = svprcnt
                pprm123(7) = sdprcnt
               else if (ntyp123.eq.2) then
                dprm123(7) = v
                sprm123(7) = sv
                pprm123(7) = sd
               end if
             else if (idx(j).eq.idw123(8)) then
               if (ntyp123.eq.1) then
                dprm123(8) = vprcnt
                sprm123(8) = svprcnt
                pprm123(8) = sdprcnt
               else if (ntyp123.eq.2) then
                dprm123(8) = v
                sprm123(8) = sv
                pprm123(8) = sd
               end if
             end if
           end if
         end if
  270 continue
c
      if (ntyp123.eq.3) then
        do 275 i = 1, i0
         do 277 j = 1, n123
           if (idy(i).eq.idw123(2+j)) conc123(2+j) = c(i)
 277     continue
 275    continue
      end if
c
c
c CALCULATE AND PRINT CHARGE BALANCE
c
      cc1 = 0.0d0
      cc2 = 0.0d0
      i0 = nn(1)+nn(2)
c
      do 280 i = 1, i0
         if (spcz(i).gt.0.0d0) then
            cc1 = cc1+spcz(i)*c(i)
         else
            cc2 = cc2-spcz(i)*c(i)
         endif
  280 continue
c
      diff = 0.0d0
      cc3 = cc1+cc2
      if (dabs(cc3).gt.D0MIN) diff = DABS((cc2-cc1)/(cc2+cc1))
      diff = diff*100.0d0
      write (lunout,9020)
      write (lunout,9030) cc1,cc2
      write (lunout,9040) diff
      if (lastime.eq.'y'.and. icoralk.eq.1) write (lunout,9050) noncrb
      if (lastime.eq.'y') then
         write (lunout,9060) xmu
      else
         write (lunout,9061) xmu
      end if
      if (idw123(1).eq.330.and.lastime.eq.'y') then
        write (lunout,9065) -gx(iadx(330))
      end if
      if (idw123(2).eq.001.and. lastime.eq.'y') then
        ehmv = -gx(iadx(001))*(temp+273.16)*1000.0/5040.24
        write (lunout,9066) -gx(iadx(001)), ehmv
      end if
c
      if (iads.gt.1.and.lastime.eq.'y') call adsprnt
c
      if (lastime.eq.'y') then
        if (n123.gt.0) then
           write (lunout,9265) iddate, idtime, fil123
        else
           write (lunout,9266) iddate, idtime
        end if
      end if
c
      if (n123.eq.0 .or. lastime.eq.'n') go to 999
c  -- Write data to file 'fil123' in a format suitable for import
c     into LOTUS 1-2-3  or a compatible program.
      k123 = n123 + 2
      if (ntyp123.eq.1) then
        if (idw123(1).ne.0.and.idw123(2).ne.0) then
         write (lun11,7000) iddate, idtime, idw123(1),
     *                     -gx(iadx(330)),idw123(2), -gx(iadx(001)),
     *                     (idw123(i),dprm123(i),sprm123(i),
     *                      pprm123(i),i=3,k123)
        else if (idw123(1).ne.0.and.idw123(2).eq.0) then
          write (lun11,7001) iddate,idtime, idw123(1),
     *        -gx(iadx(330)), (idw123(i),dprm123(i),sprm123(i),
     *        pprm123(i),i=3,k123)
        else if (idw123(1).eq.0.and.idw123(2).ne.0) then
          write (lun11,7001) iddate,idtime, idw123(2),
     *         -gx(iadx(001)), (idw123(i),dprm123(i),
     *        sprm123(i),pprm123(i),i=3,k123)
        else if (idw123(1).eq.0.and.idw123(2).eq.0) then
          write (lun11,7002) iddate,idtime, (idw123(i),
     *         dprm123(i), sprm123(i),pprm123(i),i=3,k123)
        end if
c
      else if (ntyp123.eq.2) then
        if (idw123(1).ne.0.and.idw123(2).ne.0) then
         write (lun11,7003) iddate, idtime, idw123(1),
     *                     -gx(iadx(330)),idw123(2), -gx(iadx(001)),
     *                     (idw123(i),dprm123(i),sprm123(i),
     *                      pprm123(i),i=3,k123)
        else if (idw123(1).ne.0.and.idw123(2).eq.0) then
          write (lun11,7004) iddate,idtime, idw123(1),
     *        -gx(iadx(330)), (idw123(i),dprm123(i),sprm123(i),
     *        pprm123(i),i=3,k123)
        else if (idw123(1).eq.0.and.idw123(2).ne.0) then
          write (lun11,7004) iddate,idtime, idw123(2),
     *         -gx(iadx(001)), (idw123(i),dprm123(i),
     *        sprm123(i),pprm123(i),i=3,k123)
        else if (idw123(1).eq.0.and.idw123(2).eq.0) then
          write (lun11,7005) iddate,idtime, (idw123(i),
     *         dprm123(i), sprm123(i),pprm123(i),i=3,k123)
        end if
c
      else if (ntyp123.eq.3) then
        if (idw123(1).ne.0.and.idw123(2).ne.0) then
         write (lun11,8000) iddate, idtime, idw123(1),
     *                     -gx(iadx(330)),idw123(2), -gx(iadx(001)),
     *                     (idw123(i), conc123(i),i = 3, k123)
        else if (idw123(1).ne.0.and.idw123(2).eq.0) then
          write (lun11,8001) iddate,idtime, idw123(1),
     *        -gx(iadx(330)), (idw123(i),conc123(i),i=3,k123)
        else if (idw123(1).eq.0.and.idw123(2).ne.0) then
          write (lun11,8001) iddate,idtime, idw123(2),
     *         -gx(iadx(001)), (idw123(i),conc123(i),i=3,k123)
        else if (idw123(1).eq.0.and.idw123(2).eq.0) then
          write (lun11,8002) iddate,idtime, (idw123(i),
     *         conc123(i),i=3,k123)
        end if
c
      end if
  999 return
c
 7000 format (i6,1x,i8,1x,i3,1x,f6.2,
     *        1x,i3,1x,f6.2,6(1x,i3,3(1x,f6.1)))
 7001 format (i6,1x,i8,1x,i3,1x,f6.2,6(1x,i3,3(1x,f6.1)))
 7002 format (i6,1x,i8,1x,6(1x,i3,3(1x,f6.1)))
 7003 format (i6,1x,i8,1x,i3,1x,f6.2,
     *        1x,i3,1x,f6.2,6(1x,i3,3(1x,1pe8.2)))
 7004 format (i6,1x,i8,1x,i3,1x,f6.2,6(1x,i3,3(1x,1pe8.2)))
 7005 format (i6,1x,i8,1x,6(1x,i3,3(1x,1pe8.2)))
 8000 format (i6,1x,i8,1x,i3,1x,f6.2,
     *        1x,i3,1x,f6.2,6(1x,i7,1x,1pe8.2))
 8001 format (i6,1x,i8,1x,i3,1x,f6.2,6(1x,i7,1x,1pe8.2))
 8002 format (i6,1x,i8,1x,6(1x,i7,1pe8.2))
 9020 format (/,'0',5x,'Charge Balance: SPECIATED')
 9030 format ('0',7x,'Sum of CATIONS = ',1pe10.3,' Sum of ANIONS ',
     *   1pe11.3)
 9040 format ('0',7x,'PERCENT DIFFERENCE = ',1pe11.3,2x,
     *   '(ANIONS - CATIONS)/(ANIONS + CATIONS)')
 9050 format ('0',5x,'NON-CARBONATE ALKALINITY       = ',1pe11.3)
 9060 format ('0',5x,'EQUILIBRIUM IONIC STRENGTH (m) = ',1pe11.3)
 9061 format ('0',5x,'PROVISIONAL IONIC STRENGTH (m) = ',1pe11.3)
 9065 format ('0',5x,'EQUILIBRIUM pH                 = ',f7.3)
 9066 format ('0',5x,'EQUILIBRIUM pe                 = ',f7.3,
     *        '   or Eh  = ',f8.2,' mv')
 9265 format ('0',5x,'DATE ID NUMBER:          ',i6,
     *          /,6x,'TIME ID NUMBER:        ',i8,
     *          /,6x,'ACCESSORY OUTPUT FILE: ',a12)
 9266 format ('0',5x,'DATE ID NUMBER:          ',i6,
     *          /,6x,'TIME ID NUMBER:        ',i8)
 9070 format ('0','INPUT DATA BEFORE TYPE MODIFICATIONS')
 9080 format ('0','   ID  ',2x,'    NAME    ',3x,'ACTIVITY GUESS',4x,
     *   'LOG GUESS',2x,' ANAL TOTAL')
 9090 format (' ',i7,2x,a12,7x,1pe10.3,7x,0pf7.3,2x,1pe10.3)
 9100 format ('0',' ALL SPECIES CONSIDERED IN THIS PROBLEM')
 9110 format (' ')
 9115 format (' --------------------------------------------------',
     *        '---------------------------')
 9121 format ('0',' Type I - COMPONENTS AS SPECIES IN SOLUTION')
 9122 format ('0',' Type II - OTHER SPECIES IN SOLUTION OR ADSORBED')
 9123 format ('0',' Type III - SPECIES WITH FIXED ACTIVITY ')
 9127 format ('0',' Type IV - FINITE SOLIDS (presumed present at',
     *            ' equilibrium)')
 9128 format ('0',' Type V - POSSIBLE SOLIDS')
 9126 format ('0',' Type VI - EXCLUDED SPECIES (not included in mole',
     *            ' balance)')
 9124 format ('0',' Type IV - FINITE SOLIDS (present at equilibrium)')
 9125 format ('0',' Type V - UNDERSATURATED SOLIDS (not present at',
     *            ' equilibrium)')
 9130 format ('0','   ID  ',2x,'    NAME    ',2x,'    DH    ',2x,
     *   '    LOGK  ',2x,'MIN LOGK',2x,'MAX LOGK',2x,'  Z  ',1x,
     *   ' DHA ',1x,' DHB ',1x,'   GFW   ')
 9140 format (' ',i7,2x,a12,2x,2(f10.4,2x),2(f8.3,2x),3(f5.2,1x),f9.4
     *   )
 9150 format ('0',' ID  ',2x,'    NAME    ',2x,' ANAL MOL',2x,
     *   ' CALC MOL',2x,'LOG ACTVTY',2x,'   GAMMA  ',2x,' DIFF FXN')
 9160 format (' ',i5,2x,a12,2(1x,1pe10.3),2x,0pf10.5,f12.6,2x
     *   ,1pe10.3)
 9170 format ('0','   ID  ',2x,'    NAME    ',2x,' CALC MOL',2x,
     *   ' ACTIVITY ',2x,'LOG ACTVTY',2x,'  GAMMA  ',2x,' NEW LOGK')
 9180 format (' ',i7,2x,a12,2x,1pe10.3,1x,1pe10.3,2x,0pf10.5,2x,f8.5,
     *             2x,f9.3)
 9190 format (' '//,'                  PERCENTAGE DISTRIBUTION OF',
     *    ' COMPONENTS AMONG',
     *            /,'               TYPE I and TYPE II (dissolved',
     *    ' and adsorbed) species',/)
 9200 format ('+',a12)
 9210 format ('+',14x,f6.1,5x,'PERCENT BOUND IN SPECIES #',i7,3x,a12/
     *   )
 9220 format ('+',14x,'>1000.',5x,'PERCENT BOUND IN SPECIES #',i7,3x,
     *   a12/)
 9240 format ('0','   ID  ',2x,'    NAME    ',2x,' CALC MOL ',4x,
     *   '  LOG MOL ',2x,'NEW LOGK',2x,'   DH   ')
 9250 format (' ',i7,2x,a12,2x,1pe10.3,2x,0pf10.3,2x,0pf9.3,2x,f9.3)
 9260 format (' ',//,16x,'-----------------------------------------',
     *   '-------------',
     *              /,16X,'----------- EQUILIBRATED MASS DISTRIBUTION',
     *   ' -----------')
 9261 format (' ',//,16x,'-----------------------------------------',
     *   '-------------',
     *              /,16X,'----------- PROVISIONAL MASS DISTRIBUTION',
     *   ' -----------')
 9270 format ('0'/,1x,'IDX',5x,'NAME',12x,'DISSOLVED',12x,'SORBED',
     *   12x,'PRECIPITATED',/,23x,'MOL/KG',3x,'PERCENT',4x,'MOL/KG',
     *   3x,'PERCENT',4x,'MOL/KG',3x,'PERCENT'/)
 9280 format (' ',i3,2x,a12,2x,1pe10.3,2x,0pf6.1,2x,1pe10.3,2x,0pf6.1
     *   ,2x,1pe10.3,2x,0pf6.1)
 5750 format ('1',//,' ________________________________________',
     *        '______________________________________',
     *      /,' ______________________________ PART ',i1,' of',
     *        ' OUTPUT FILE _________________________')
      end
