      subroutine pointer
c
c     **************************************************************
c
c  -- The purpose of this routine is to load the indices of all
c     non-zero stoichiometry elements for each species in an
c     array and to store the number of such elements in a
c     corresponding vector.  The array is accessed in Subroutine
c     Solve to avoid the overhead of multiplying or adding
c     non-zero stoichiometries in mass action and related equations
c     by "pointing" to non-zero stoichiometries only.
c
c     **************************************************************
      include 'MINTEQA2.INC'
c
c  -- Re-create the pointer arrays.
c     jmax(i) stores the number of non-zero elements of array "a"
c     for species i.  jpta(i,j) stores the column number address of
c     the jth component which has non-zero stoichiometry in species i.
      nc = nn(1) + nn(2)
      nx = nnn - nn(3) - nn(4)
      do 100 i = 1, nc
        jmax(i) = 0
        do 110 j = 1, nx
c  -- Because 0.001 is the absolute value of the smallest legitimate
c     input stoichiometry and 99.999 is the absolute value of the
c     largest legitimate input stoichiometry, 1e-08 is then the
c     absolute value of the smallest legitimate results from the
c     modification of the stoichiometry arrays above.  Any element whose
c     absolute value is smaller than this is regarded as zero.
          if (abs(b(i,j)) .ge. 1.0e-8) then
            jmax(i) = jmax(i) + 1
            jpta(i,jmax(i)) = j
          end if
 110    continue
 100  continue
c
c     imax(j) stores the number of non-zero elements of array "a"
c     for component j.  ipta(j,i) stores the row number address of
c     the ith species which has non-zero stoichiometry of component j.
      do 120 j = 1, nx
        imax(j) = 0
        do 130 i = 1, nc
          if (abs(b(i,j)) .ge. 1.0e-8) then
            imax(j) = imax(j) + 1
            ipta(j,imax(j)) = i
          end if
 130    continue
 120  continue
c
      return
      end
