      subroutine prep
c
c ******************************************************************
c
c THIS ROUTINE IS CALLED IMMEDIATELY BEFORE THE ITERATIVE LOOP
c IN MAIN.
c
c ITS BASIC FUNCTIONS ARE:
c          1.CORRECT LOGK VALUES FOR TEMPERATURE
c
c          2.CALCULATE DEBYE-HUCKEL CONSTANTS(A&B)
c            AS A FUNCTION OF TEMPERATURE
c
c          3.CONVERT ALL UNITS TO MOLALITY
c
c          4.CALCULATE AN INITIAL CATION-ANION BALANCE
c
c *****************************************************************
c
      include 'MINTEQA2.INC'
c
      real*8 bob1,bob2,bob3,bob4
      real*8 at,bt,cc1,cc2,cc3,ct,diff,dt,e0,et,ft,gt,s1,s2,s3,spz,
     *   vhoff
c
      include 'CONST.INC'
c CORRECT ALL LOGK'S FOR TEMPERATURE
c
      ii = nn(1)+nn(2)+nn(3)+nn(4)+nn(5)+nn(6)
      i0 = nn(1)+1
      do 100 i = i0, ii
         gk(i) = vhoff(gk(i),dh(i))
  100 continue
c
c NOW READ IN THE ANALYTICAL EXPRESSIONS FOR
c LOG K WITH TEMPERATURE.
c
      k1 = 0
  110 read (lun07,9070) idt,at,bt,ct,dt,et,ft,gt
      if (idt.eq.0) k1 = k1+1
      if (k1.eq.2) then
         rewind lun07
         go to 120
      endif
c
      n = iady(idt)
      if (n.eq.0) go to 110
      gk(n) = at+bt*tempk+ct/tempk+dt*dlog10(tempk)+et*(tempk*tempk)+
     *   ft/(tempk*tempk)+gt/dsqrt(tempk)
      go to 110
  120 continue
c
c THE NEXT SECTION OF CODE WHICH COMPUTES THE DEBYE-HUCKEL
c CONSTANTS AS A FUNCTION OF TEMPERATURE WAS TAKEN DIRECTLY
c FROM WATEQ2(BALL ET AL. 1979). THE MATHEMATICS IS DOCUMENTED
c IN TRUESDELL AND JONES(1974).
c
      s1 = 374.11d0-temp
      s2 = s1**(1.0d0/3.0d0)
      bob1 = (1.0d0+0.1342489d0*s2-3.946263d-03*s1)
      bob2 = (3.1975d0-0.3151548d0*s2-1.203374d-3*s1)
      bob3 = (7.48908d-13*s1**4.0d0)
      bob4 = bob2+bob3
      s3 = dsqrt(bob1/bob4)
      if (tempk.lt.373.16d0) then
         cc1 = 87.74d0-temp*(temp*(1.41d-6*temp-9.398d-4)+0.4008d0)
      else
         cc1 = 5321d0/tempk+233.76d0-tempk*(tempk*(8.29d-7*tempk-
     *      1.417d-3)+.9297d0)
      endif
c
c INITIALIZE ADSORPTION CONSTANTS WHICH DEPEND UPON CC1
c
      e0 = 8.876d-09
      ee = dsqrt(8.0d0*cc1*e0*rj*tempk)
c
      cc1 = dsqrt(cc1*tempk)
      aa = 18246d2*s3/cc1**3.0d0
      bb = 50.29d0*s3/cc1
c
c
c CONVERT ALL UNITS TO MOLALITY
c
      ii = nnn
      if (flag.eq.'MEQ/L') then
         do 130 j = 1, ii
            if (idx(j).ge.811.and.idx(j).le.859) go to 130
            if (idx(j).ge.idclf.and.idx(j).le.idcll) go to 130
            i = iady(idx(j))
            spz = abs(spcz(i))
            t(j) = t(j)*gfw(i)/dmax1(1.0d0,spz)
  130    continue
         flag = 'MG/L '
      endif
c
      if (flag.eq.'MG/L ') then
         do 140 j = 1, ii
            if (idx(j).ge.811.and.idx(j).le.859) go to 140
            if (idx(j).ge.idclf.and.idx(j).le.idcll) go to 140
            t(j) = t(j)/dens
  140    continue
         flag = 'PPM  '
      endif
c
      cc1 = 0.0d0
      do 150 j = 1, nnn
         if (idx(j).ge.811.and.idx(j).le.859) go to 150
         if (idx(j).ge.idclf.and.idx(j).le.idcll) go to 150
         cc1 = cc1+t(j)
  150 continue
c
c
      if (flag.eq.'PPM  ') then
         do 160 j = 1, ii
            if (idx(j).ge.811.and.idx(j).le.859) go to 160
            if (idx(j).ge.idclf.and.idx(j).le.idcll) go to 160
            i = iady(idx(j))
            if (gfw(i).lt.D0MIN) go to 160
            t(j) = t(j)*(1.0d0/(1.0d0-1.0d-6*cc1))/(1.0d3*gfw(i))
  160    continue
         flag = 'MOL  '
      endif
      cppm = cc1
c
      ii = nn(1)+nn(2)+1
      i3 = nn(1)+nn(2)+nn(3)
      if (i3.lt.ii) go to 200
      do 190 i = ii, i3
         do 180 j = 1, nnn
            if (idx(j).ne.idy(i)) go to 180
            if (dabs(gx(j)).lt.D0MIN) then
               gx(j) = -gk(i)
               x(j) = 10.0d0**gx(j)
            endif
  180    continue
  190 continue
  200 continue
c
c
c SUM THE CONCENTRATIONS OF ALL SPECIES FOR ACTIVITY
c OF WATER CALCULATIONS
c
      cc1 = 0.0d0
      do 210 j = 1, nnn
         if (idx(j).le.2) go to 210
         if (idx(j).ge.811.and.idx(j).le.859) go to 210
         if (idx(j).ge.idclf.and.idx(j).le.idcll) go to 210
c
c    CHANGED TO CHECK FOR THE ADDITION OF WATER OR e -)
c
         cc3 = t(j)
         cc1 = cc1+cc3
  210 continue
c
c NOW ADD ACTIVITIES OF TYPE 3 AQUEOUS SPECIES
c
      i0 = nn(1)+nn(2)+1
      ii = nn(1)+nn(2)+nn(3)
      if (ii.lt.i0) go to 240
      do 230 i = i0, ii
         do 220 j = 1, nnn
            if (idy(i).ne.idx(j)) go to 220
            if (idx(j).le.2) go to 220
            if (idx(j).ge.811.and.idx(j).le.859) go to 220
            if (idx(j).ge.idclf.and.idx(j).le.idcll) go to 220
            cc3 = 10.0d0**(-gk(i))
            cc1 = cc1+cc3
  220    continue
  230 continue
  240 continue
c
c ***** NEED ERROR CHECK HERE *******
c
      indh2o = iady(2)
      if (cc1.gt.58.823d0) cc1 = 58.823d0
      gk(indh2o) = -dlog10(1.0d0-0.017d0*cc1)
c
c CALCULATE AND PRINT INITIAL CATION-ANION BALANCE
c
      cc1 = 0.0d0
      cc2 = 0.0d0
      tis = 0.0d0
c
      do 250 j = 1, nnn
         i = iady(idx(j))
         if (spcz(i).gt.0.0d0) then
            cc1 = cc1+spcz(i)*t(j)
         else
            cc2 = cc2-spcz(i)*t(j)
         endif
c         if (t(j).gt.0.0d0) then
           tis = tis+t(j)*spcz(i)*spcz(i)
c         end if
  250 continue
      tis = tis*0.5d0
c
      diff = 0.0d0
      cc3 = cc1+cc2
      if (dabs(cc3).gt.D0MIN) diff = DABS((cc2-cc1)/(cc2+cc1))
      diff = diff*100.0d0
c
      write (lunout,9060)
      write (lunout,9030) cc1,cc2
      write (lunout,9040) diff
c
      if (diff.gt.30.0d0.and.icharg.eq.0) then
        ierr = 8
        call error
        go to 999
      end if
c
 999  return
c
c
 9030 format ('0',7x,'Sum of CATIONS= ',1pe10.3,' Sum of ANIONS = ',
     *   1pe10.3)
 9040 format ('0',7x,'PERCENT DIFFERENCE = ',1pe10.3,2x,
     *   '(ANIONS - CATIONS)/(ANIONS + CATIONS)')
 9060 format (/,'0',5x,'Charge Balance: UNSPECIATED')
 9070 format (i7,1x,7(e10.3,1x))
c
      end
