      subroutine simq (z,y,n,nxdim,ierr)
c
c ****************************************************
c
c THIS SUBROUTINE SOLVES THE JACOBIAN MATRIX
c VIA GAUSSIAN ELIMINATION AND BACK SUBSTITUTION.
c
c THIS PROCEDURE IS FASTER THAN GAUSS-JORDAN ELIMINATION
c BY AT LEAST 50%.  (N^3+3N^2-N)/3
c ***************************************************
c
      include 'CONST.INC'
      real*8 z,y,zmax,v
      dimension z(nxdim,nxdim),y(nxdim)
c
c     PROVISION FOR N=1
c
      if (n.ne.1) go to 100
      y(1) = y(1)/z(1,1)
      return
  100 continue
c
c     ELEMENT OF ELIMINATION
c
      n1 = n-1
      do 160 m = 1, n1
         zmax = 0.0d0
         imax = 0
c
c     FIND MAX OF COLUMN
c
         do 110 i = m, n
            if (dabs(z(i,m)).le.zmax) go to 110
            imax = i
            zmax = dabs(z(i,m))
  110    continue
c
c     ERROR RETURN
c
         if (imax.ne.0) go to 120
         ierr = 9
         call error
         go to 999
  120    continue
c
c     ROW INTERCHANGE
c
         if (imax.eq.m) go to 140
         v = y(m)
         y(m) = y(imax)
         y(imax) = v
         do 130 j = m, n
            v = z(m,j)
            z(m,j) = z(imax,j)
            z(imax,j) = v
  130    continue
  140    continue
c
c     DIAGONALIZE
c
         m1 = m+1
         do 150 i = m1, n
            if (dabs(z(i,m)).lt.D0MIN) go to 150
            v = z(i,m)/z(m,m)
            y(i) = y(i)-v*y(m)
            do 155 j = m, n
              z(i,j) = z(i,j) - v * z(m,j)
  155       continue
  150    continue
  160 continue
c
c     BACK SUBSTITUTE
c
      y(n) = y(n)/z(n,n)
      n1 = n-1
      do 180 k = 1, n1
         i = n-k
         i1 = i+1
         do 170 j = i1, n
            y(i) = y(i)-y(j)*z(i,j)
  170    continue
         y(i) = y(i)/z(i,i)
  180 continue
  999 return
      end
