      subroutine solid
c
c *****************************************************
c
c THIS SUBROUTINE MODIFIES THE A,B,T AND GK MATRICES
c FOR THE PRESENCE OF FIXED SOLIDS. THE SUBROUTINE IS
c IDENTICAL TO SUBROUTINE SOLID IN MINEQL(WESTALL ET
c AL 1976) EXCEPT FOR CHANGES IN COMMONBLOCK.
c
c *****************************************************
c
      include 'MINTEQA2.INC'
c
      include 'CONST.INC'
      ll = nn(3) + nn(4)
      if (ll.eq.0) go to 170
      i0 = nn(1)+nn(2)+nn(3)+nn(4)+1
      j0 = nnn+1
c
c --- BEGIN MAIN LOOP
c
      do 150 l = 1, ll
         i0 = i0-1
         j0 = j0-1
c
c FIND JEXC FOR I0
c
         do 100 j = 1, j0
            jj=j0-(j-1)
            if (abs(a(i0,jj)).gt.0.001) go to 110
            if (abs(b(i0,jj)).gt.0.001) go to 110
  100    continue
         ierr = 11
         call error
         go to 999
  110    jexc = j0-(j-1)
c
         if (j0.le.1) then
            ierr = 12
            call error
            go to 999
         endif
         call excol (jexc,j0)
         nxs = j0-1
         ncs = i0-1
c
c MODIFY A,B,T
c
         do 120 i = 1, ncs
            do 125 j = 1, nxs
               if (dabs(b(i0,j)).gt.D0MIN.and.dabs(b(i,j0)).gt.D0MIN)
     *         then
                 b(i,j) = b(i,j)-b(i0,j)*b(i,j0)/b(i0,j0)
               end if
               if (abs(a(i0,j)).gt.D0MIN.and.abs(a(i,j0)).gt.D0MIN)
     *         then
                 a(i,j) = a(i,j)-a(i0,j)*a(i,j0)/a(i0,j0)
               end if
  125       continue
  120    continue
         do 130 j = 1, nxs
            t(j) = t(j)-b(i0,j)*t(j0)/b(i0,j0)
  130    continue
         do 140 i = 1, ncs
            gk(i) = gk(i)-a(i,j0)*gk(i0)/a(i0,j0)
  140    continue
c
c
c --- END OF MAIN LOOP
c
  150 continue
c
c  -- Re-create the pointer arrays.
  170 call pointer
c
  999 return
c
      end
