      subroutine solidx (action,k1)
c
c ********************************************************
c
c THIS SUBROUTINE UMMODIFIES THE A,B,T,GX,AND X MATRICES
c FOLLOWING SUBROUTINE SOLVE. THE SUBROUTINE ALSO
c SELECTS THE TYPE 4 AND 5 SOLIDS WHICH WILL DISSOLVE
c OR PRECIPITATE THIS ITERATION. THIS SUBROUTINE IS
c IDENTICAL TO SUBROUTINE SOLIDX IN MINEQL(WESTALL ET
c AL 1976) EXCEPT FOR CHANGES IN COMMON BLOCK.
c ********************************************************
c
c  -- The input variable k1 is equal to zero the first call
c     to this routine.  k1 is incremented in MAIND for each
c     successive trip through the equilibration loop; i.e.,
c     for each successive call to SOLIDX.  k1 serves as a
c     flag signaling SOLIDX to count the number of initial
c     solids present at a specified finite amount (type 4)
c     and together with the solids print option, to determine
c     when and what to write to the output file.
c
c  -- The output variable kk is set to zero upon entry to this
c     routine and is set equal to -1 if a solid is determined to
c     have dissolved or to +1 if a solid has precipitated.  That
c     result is passed back to the calling routine (MAIND)
c     signaling whether to make another trip through the
c     equilibration loop (necessary if kk is other than 0).
c
      include 'MINTEQA2.INC'
c
c -- THE INCLUDE FILE HAS A PARAMETER STATEMENT THAT SETS BOTH
c    NXDIM AND NYDIM.  (THEIR VALUES DEPEND UPON THE MEMORY
c    CAPACITY OF THE COMPUTER.)  THE INCLUDE STATEMENT ABOVE
c    MUST COME BEFORE THE DIMENSION STATEMENT FOR ARRAYS "CONC"
c    AND "SELECT" SINCE NYDIM IS USED FOR AN ADJUSTABLE ARRAY
c    DIMENSION. 10-15-87 JDA
c
      dimension conc(nydim),select(nydim)
      dimension itype4(20)
c
      real*8 conc,select,spcn,v,vi,vmax,vmin
      character lastime*1, action*12, state*5
      include 'CONST.INC'
c
      action = 'finished    '
c
      if (nn(3)+nn(4).eq.0) go to 190
      ll = nn(3)+nn(4)
      ii = nn(1)+nn(2)
      i0 = nn(1)+nn(2)+1
      j0 = nnn-nn(3)-nn(4)+1
      jj = nnn
      if (k1.eq.0) then
         i4 = nn(1)+nn(2)+nn(3)+nn(4)
         i3 = nn(1)+nn(2)+nn(3)+1
c
c NOW INITIALIZE ARRAYS FOR INITIAL SOLID MASS
c
         ntype4 = 0
         if (i4.ge.i3) then
            do 100 i = i3, i4
               if (c(i).gt.D0MIN) then
                  ntype4 = ntype4+1
                  conc(i) = c(i)
                  itype4(ntype4) = idy(i)
               endif
  100       continue
         endif
      endif
c
c
      ni = nn(1)+nn(2)+nn(3)+nn(4)+nn(5)+nn(6)
      do 110 i = 1, ni
         select(i) = 0.0d0
  110 continue
c
c  Mass balance minus solids
c
      do 120 j = j0, jj
         y(j) = -t(j)
         do 120 i = 1, ii
            y(j) = y(j) + dble(b(i,j))*c(i)
  120 continue
c
c AMOUNT OF SOLIDS
c
      do 180 l = 1, ll
         c(i0) = -y(j0)/dble(b(i0,j0))
c
c PROVISION FOR C=0
c
         if (dabs(c(i0)).lt.D0MIN) then
            gc(i0) = 0.0d0
         else
            gc(i0) = dlog10(DABS(c(i0)))
         endif
c
c
         do 130 k = j0, jj
            y(k) = y(k)+dble(b(i0,k))*c(i0)
  130    continue
c
c UNMODIFY A,B,T,GX,X
c
         nxs = j0-1
         ncs = i0-1
         v = gk(i0)
         do 140 j = 1, nxs
             v = v+dble(a(i0,j))*gx(j)
  140    continue
           gx(j0) = -v/dble(a(i0,j0))
           x(j0) = 10.0d0**(gx(j0))
         do 150 i = 1, ncs
            do 152 j = 1, nxs
               if (dabs(b(i0,j)).gt.D0MIN.and.dabs(b(i,j0)).gt.D0MIN)
     *         then
                 b(i,j) = b(i,j)+b(i0,j)*b(i,j0)/b(i0,j0)
               end if
               if (abs(a(i0,j)).gt.D0MIN.and.abs(a(i,j0)).gt.D0MIN)
     *         then
                 a(i,j) = a(i,j)+a(i0,j)*a(i,j0)/a(i0,j0)
               end if
c  --  Note:  The above operations are to undo modifications done in
c             Subroutine SOLID.  Successive passes thru the SOLID/
c             SOLIDX loop causes numerical dispersion. That is, numbers
c             that should really be treated as zero are on the order of
c             1e-17 or so.  This doesn't hurt anything except that
c             the pointer arrays in which we would like to record
c             only the locations of non-zero elements are made
c             to include these "almost zero" non-zero elements.  So,
c             given 0.001 as the absolute value of the smallest
c             legitimate input stoichiometry, we require that to again
c             be the case after the "unmodifying" step above.  This
c             prevents accumulating errors that lead to dispersion.
               if (abs(b(i,j)).lt.0.001) b(i,j) = 0.0d0
               if (abs(a(i,j)).lt.0.001) a(i,j) = 0.0
  152       continue
  150    continue
         do 160 j = 1, nxs
            t(j) = t(j)+dble(b(i0,j))*t(j0)/dble(b(i0,j0))
  160    continue
         do 170 i = 1, ncs
            gk(i) = gk(i)+dble(a(i,j0))*gk(i0)/dble(a(i0,j0))
  170    continue
c
c NOW ADD THE INITIAL MASS OF A TYPE4 SOLID
c
         c(i0) = c(i0)+conc(i0)
         i0 = i0+1
         j0 = j0+1
  180 continue
  190 continue
c
c  SOLUBILITY PRODUCTS
c
      if (nn(5)+nn(6).eq.0) go to 220
      i0 = nn(1)+nn(2)+nn(3)+nn(4)+1
      ii = nn(1)+nn(2)+nn(3)+nn(4)+nn(5)+nn(6)
      jj = nnn
      do 210 i = i0, ii
         v = gk(i)
         spcn = 0.0d0
         do 200 j = 1, jj
            v = v + a(i,j) * gx(j)
            if (idx(j).ne.002) spcn = spcn + abs(a(i,j))
  200    continue
         gc(i) = v
c
         if (DABS(v).lt.38.D0) then
            c(i) = 10.0d0**v
         else
            c(i) = 0.0d0
         endif
c
         if (spcn.lt.D0MIN) then
            select(i) = gc(i)
         else
            select(i) = gc(i)/spcn
         endif
  210 continue
  220 continue
c
      if (idebug.eq.4) then
         write (lunout,9000)
         write (lunout,9010)
         do 230 i = 1, ii
            write (lunout,9020) i,idx(i),x(i),idy(i),c(i),gk(i),y(i)
  230    continue
      endif
c
c   CHECK FOR DISSOLUTION
c
      if (nn(4).eq.0) go to 290
      imin = 0
      vmin = 0.0d0
      i0 = nn(1)+nn(2)+nn(3)+1
      ii = nn(1)+nn(2)+nn(3)+nn(4)
      do 240 i = i0, ii
         if (c(i).ge.vmin) go to 240
         vmin = c(i)
         imin = i
  240 continue
      if (imin.eq.0) go to 290
c
      if (iprint.eq.3) go to 250
      if (iprint.eq.2.or.iprint.eq.0.and.k1.eq.0) go to 250
      go to 260
  250 continue
      call outcmp
      lastime = 'n'
      call outspc (lastime)
      call outpc (lastime)
      state = 'under'
      call iap (state)
  260 continue
c
      write (lunout,9030) iter,name(imin)
c
      if (ntype4.ne.0) then
         do 280 i = 1, ntype4
            if (itype4(i).eq.idy(imin)) then
               do 270 j = 1, nnn
                 t(j) = t(j) + b(imin,j)*conc(imin)
  270          continue
               conc(imin) = 0.0d0
               ntype4 = ntype4-1
            endif
  280    continue
      endif
c
         conc(imin) = 0.0d0
c
c NOW EXCHANGE ROWS IN THE CONC ARRAY
c
         vi = conc(ii)
         conc(ii) = conc(imin)
         conc(imin) = vi
c
         call exrow (imin,ii)
         nn(5) = nn(5)+1
         nn(4) = nn(4)-1
         idwrite = ii
         call display (14)
         action = 'dissolved   '
         return
  290 continue
c
c CHECK FOR PRECIPITATION
c
      if (nn(5).eq.0) go to 330
      vmax = 0.0d0
      imaxx = 0
      i0 = nn(1)+nn(2)+nn(3)+nn(4)+1
      ii = nn(1)+nn(2)+nn(3)+nn(4)+nn(5)
      do 300 i = i0, ii
         if (select(i).lt.vmax) go to 300
         vmax = select(i)
         imaxx = i
  300 continue
      if (imaxx.eq.0) go to 330
c
      if (iprint.eq.3) go to 310
      if (iprint.eq.2.or.iprint.eq.0.and.k1.eq.0) go to 310
      go to 320
  310 continue
      call outcmp
      lastime = 'n'
      call outspc (lastime)
      call outpc (lastime)
      state = 'over '
      call iap (state)
  320 continue
c
      call tstamp
      write (lunout,9050) iter,name(imaxx)
c
      call exrow (imaxx,i0)
      nn(4) = nn(4)+1
      nn(5) = nn(5)-1
      idwrite = i0
      call display (15)
      action = 'precipitated'
  330 continue
      return
c
 9000 format ('0','DEBUG PRINT IN SUBROUTINE SOLIDX')
 9010 format ('0',' I ',2x,'  IDX  ',2x,'     X    ',2x,'  IDY  ',2x,
     *   '     C    ',2x,'    GK    ',2x,'    Y     ')
 9020 format (' ',i3,2x,i7,2x,1pe10.3,2x,i7,2x,e10.3,2x,0pf9.4,2x,
     *   1pe10.2)
 9030 format ('0','  ITERATIONS= ',i3,':  SOLID ',a12,' DISSOLVES')
 9040 format (' ','VMIN = ',1pe10.3,' IMIN = ',i7)
 9050 format ('0','  ITERATIONS= ',i3,':  SOLID ',a12,' PRECIPITATES'
     *   )
 9060 format (' ','VMAX = ',1pe10.3,' IMAX = ',i7)
c
      end
