      subroutine solve
c
c *********************************************************
c
c THIS SUBROUTINE SOLVES AQUEOUS SPECIATION PROBLEM
c WHICH HAS BEEN MODIFIED FOR SOLIDS IN SUBROUTINE SOLID.
c *********************************************************
c
c
      include 'MINTEQA2.INC'
c
      dimension test(nxdim)
c
      real*8 v,v2,v5,vmax,cnvtest,test,residual,gclig
      character*1 holdis, convrged*1
      include 'CONST.INC'
c
      holdis = 'n'
      if (iads.gt.1) call adsid
c
      nc = nn(1)+nn(2)
      nx = nnn-nn(3)-nn(4)
      if (nx.lt.1) then
        ierr = 12
        call error
        go to 999
      end if
      if (iter.eq.0) k2 = 0
c
c  -- Time stamp the output file
      write (lunout,5750) 3
      call tstamp
      write (lunout,9000)
      write (lunout,9010)
      k2 = k2+1
      ipass = 0
  100 continue
      do 150 i = 1, nx
        if (dabs(x(i)).lt.D0MIN) then
          ierr = 10
          call error
          go to 999
        end if
        do 155 j = 1, nx
          z(i,j) = 0.0d0
  155   continue
  150 continue
c
c COMPLEXES
c
      id1 = idclf*10000
      id2 = idcll*10000 + 9999
      do 120 i = 1, nc
         v = gk(i)
         do 110 k = 1, jmax(i)
            n = jpta(i,k)
            v = v+a(i,n)*gx(n)
  110    continue
c
         if (v.lt.-100.0d0) then
           gc(i) = -100.0d0
         else
           gc(i) = v
         end if
         c(i) = 10.0d0**gc(i)
  120 continue
c
      do 125 i = 1, nc
        if (idy(i).ge.id1 .and. idy(i).le.id2) then
           call composit (i,gclig)
           gc(i) = gclig
           c(i) = 10.d0**gclig
        end if
  125 continue
c
      if (icoralk.ne.0.and.k2.eq.1) call alkcor
c
c -- MODIFIED FOR DIFFUSE LAYER MODEL JDA 10-31-87
c
      if (iads.gt.1) call adinit
c
c
c COMPUTE Z and mass imbalance Y
c
c
      do 160 j = 1, nx
         v = 0.0d0
         do 161 ii = 1, imax(j)
            n = ipta(j,ii)
            v5 = c(n)*b(n,j)
            do 162 kk = 1, jmax(n)
              k = jpta(n,kk)
              z(j,k) = z(j,k) + a(n,k) * v5 / x(k)
  162      continue
           v = v + v5
  161   continue
        y(j) = v - t(j)
  160 continue
c
      if (iads.eq.3) call adscaly
      if (iads.gt.1) call adsjac
c
c CONVERGENCE TEST
c
      convrged = 'y'
      do 210 j = 1, nx
         vmax = dabs(t(j))
         do 170 i = 1, 5
            if (solcon(i).lt.D0MIN) go to 170
            if (j.eq.m2(i).and.iads.eq.3) go to 190
  170    continue
         do 180 k = 1, imax(j)
            n = ipta(j,k)
            v2 = dabs(b(n,j)*c(n))
            if (v2.lt.vmax) go to 180
            vmax = v2
  180    continue
         go to 200
  190    if (vmax.le.1.0d-10) vmax = 1.0d-10
  200    if (vmax.lt.D0MIN) go to 210
         test(j) = dabs(y(j))/vmax
c  --  Require at least 2 iterations no matter what.
         if (test(j).gt.eps.or.iter.le.2) convrged = 'n'
         test(j) = eps*vmax
  210 continue
c
      if (convrged.eq.'y') then
       if (holdis.eq.'y') then
         isopt = 0
         holdis = 'n'
         ipass = 0
         go to 220
       end if
        go to 999
      end if
c
  220 iter = iter+1
c
c OUTPUT ITERATION INFORMATION
c
      iworst = 0
      cnvtest = 0.0d0
      do 230 j = 1, nx
         if (dabs(y(j))-test(j).gt.cnvtest) then
            iworst = j
            residual = dabs(y(j))-test(j)
         endif
  230 continue
      if (iworst.gt.0) then
         i = iady(idx(iworst))
         write (lunout,9020) iter-1,name(i),t(iworst),y(iworst),
     *      gx(iworst), residual
      endif
c
      if (iter.gt.itmax) then
        ierr = 13
        call error
        go to 999
      end if
c
c ITERATE
c
c NOW COMPUTE ACTIVITY COEFFICIENTS AND NEW X(J)
c
      call simq (z,y,nx,nxdim,ierr)
      if (ierr.ne.0) go to 999
      call newx
      if (iter.gt.1.and.isopt.eq.0) call actvty
      ipass = ipass + 1
      if (ipass.gt.12.and.isopt.eq.0) then
        isopt = 1
        holdis = 'y'
      end if
      go to 100
c
 999  return
c
 9000 format ('0'/,
     *   ' PARAMETERS OF THE COMPONENT MOST OUT OF BALANCE:')
 9010 format ('0',5x,'ITER',2x,'    NAME    ',2x,' TOTAL MOL ',2x,
     *   ' DIFF FXN ',2x,'LOG ACTVTY',2x,'  RESIDUAL')
 9020 format (5x,i3,3x,a12,2x,1pe11.3,2x,1pe10.3,2x,0pf10.5,2x,
     *        1pe11.3)
 5750 format ('1',//,' ________________________________________',
     *        '________________________________________',
     *      /,' ______________________________ PART ',i1,' of',
     *        ' OUTPUT FILE ___________________________')
c
      end
