      subroutine adsinit
c
      include 'PRODEFA2.INC'
c
c --  Find out which adsorption algorithm to use.
c
  100 write (lu06,9000) cont1
      read (lu05,9120,err=100) ans
      if (ans.eq.'r'.or.ans.eq.' ') ans = 'R'
      if (ans.ne.'1'.and.ans.ne.'2'.and.ans.ne.'3'.and.ans.ne.'4'.and.
     *    ans.ne.'5'.and.ans.ne.'6'.and.ans.ne.'7'.and.ans.ne.'R') 
     * go to 100
      write (lu03,9000) cont2, ans
c
      if (ans.eq.'R') go to 110
c
      if (ans.eq.'1') iabq = 1
      if (ans.eq.'2') iabq = 2
      if (ans.eq.'3') iabq = 3
      if (ans.eq.'4') iabq = 4
      if (ans.eq.'5') iabq = 5
      if (ans.eq.'6') iabq = 6
      if (ans.eq.'7') iabq = 7
c
c  -- For the triple layer model only:
c     Inform user of the option of specifying that all specifically
c     adsorbed ions contribute to the charge in the "o-plane".  The 
c     option is invoked for each individual reaction as it is specified.
c     Inquire whether this option is to be offered as each reaction is
c     defined or whether the conventional TLM adsorption is to be
c     assumed (H+ and OH- contribute to charge in o-plane; all other
c     ions contibute to beta-plane charge).  Default is tlmo = 'n' 
c     (meaning only H+ and OH- contribute to o-plane charge.  
      if (iabq.eq.6) then
        tlmo = 'n'
 150    write (lu06,9110) cont1 
        read (lu05,9120,err=150) ans
        if (ans.eq.'n') ans = 'N'
        if (ans.eq.'y') ans = 'Y'
        write (lu03,9110) cont2,ans
        if (ans.ne.'N'.and.ans.ne.'Y') go to 150
        if (ans.eq.'Y') tlmo = 'y'
      end if
c
c  -- For all activity models and ion exchange, set iads to 1.
      if (iabq.ge.1.and.iabq.le.4) then
         iads = 1
c
c  -- For CCM, TLM, DLM set iads to 1, 2, or 3 respectively.
      else
         iads = iabq-3
c
      endif
c
c  --  Inform user that a maximum of five adsorbing surfaces may be
c      defined.
c
      write (lu06,9020)
      write (lu03,9020)
      read (lu05,*)
c
      if (iabq.eq.1) then
  200   write (lu06,9030) cont1
        read (lu05,*,err=200) soilkg
        if (soilkg.lt.0.0) go to 200
        write (lu03,9030) cont2,soilkg
        if (soilkg.eq.0.0) then
           iabq = 0
           go to 100 
        end if
      end if

  110 return
c
c
 9000 format (/,'  Select an adsorption algorithm:',
     * /,'    1 = Activity Kd',
     * /,'    2 = Activity Langmuir',
     * /,'    3 = Activity Freundlich',
     * /,'    4 = Ion Exchange Model',
     * /,'    5 = Constant Capacitance Model (CCM)',
     * /,'    6 = Triple Layer Model (TLM)',
     * /,'    7 = Diffuse Layer Model (DLM)',
     * /,'    R = RETURN to EDIT LEVEL 2 Menu',
     * /,a1,'       ENTER CHOICE ([D] = R)  > ',1x,a1)
 9010 format (i1)
 9020 format (/,' __________________________________________________',
     *   '____________________________',/,
     *   '  A maximum of five adsorbing surfaces, each with',
     *   ' one or two types of binding',/,
     *   '  sites may be defined.  Opportunity to define',
     *   ' multiple surfaces is presented',/,
     *   '  in a succession of prompts.  The identifying',
     *   ' surface numbers 1 through 5',/,
     *   '  serve only to distinguish one surface from another',
     *   ' when specifying surface',/,
     *   '  reactions.  There is no intrinsic difference',
     *   ' between surfaces of different',/,
     *   '  identifying numbers.  Similarly, there is no',
     *   ' intrinsic difference between',/,
     *   '  sites 1 and 2 on a surface.  For both surfaces and',
     *   ' sites YOU establish any',/,
     *   '  differences by assigning different characteristics',
     *   ' and parameters for',/,
     *   '  different surfaces and different reactions and',
     *   ' equilibrium constants for',/,
     *   '  the different sites on a surface.',/,
     *   ' __________________________________________________',
     *   '____________________________',/,'   PRESS ENTER TO CONTINUE')
c
 9030 format (/,'  Enter the mass of soil (kg) to which one liter',
     *          ' of solution',
     *  /,a1,' is exposed.  (Enter zero to return to previous prompt.',
     *             ' > ',1pe12.5)
 9110 format (/,' The standard implementation of the triple layer',
     *          ' model allows specifically',
     *        /,' adsorbed H+ and OH- ions to contribute to the',
     *          ' charge on the "o" plane and all',
     *        /,' other specifically adsorbed ions to contribute',
     *          ' to the charge on the "beta"',
     *        /,' plane.  For individual reactions, you may optionally',
     *          ' designate that all ions',
     *        /,' contribute to the "o" plane charge.  (This option is',
     *          ' irrelevant for reactions',
     *        /,' involving only H+.)  Do you want to invoke this',
     *          ' option?  (You will be asked',
     *        /,a1,'about it as each individual reaction is',
     *            ' defined.) (Y,N) >', 1x,a1)
 9120 format (a1)
c
      end
      subroutine adsorb
c
      include 'PRODEFA2.INC'
c
      integer opensurf(10),indxkill(3)
      character fixedcon*15, opt*1
c
      data fixedcon / 'Infinite Supply'/
c
  100 call clrscr (lu06)
c
c  -- Display status: number of currently defined surfaces, number
c     of sites on each, and id numbers/site densities.
c
      write (lu06,9000) numads
      write (lu03,9000) numads
      if (numads.eq.0) then
         write (lu06,9010)
         write (lu03,9010)
      else
         write (lu06,9020)
         write (lu03,9020)
      endif
      do 120 i = 1, 5
         call sitcount (i)
         if (nsites(i).ne.0) then
            if (nsites(i).eq.1) then
               j = 1
               if (kaddr(i,2).ne.0) j = 2
               if (iabq.eq.2.or.iabq.eq.4.or.iabq.ge.5) then
                  write (lu06,9030) i,j,idad(i,j),sitecon(i,j)
                  write (lu03,9030) i,j,idad(i,j),sitecon(i,j)
               else
                  write (lu06,9040) i,j,idad(i,j),fixedcon
                  write (lu03,9040) i,j,idad(i,j),fixedcon
               endif
            elseif (nsites(i).eq.2) then
               do 110 j = 1, nsites(i)
                  if (iabq.eq.2.or.iabq.eq.4.or.iabq.ge.5) then
                     write (lu06,9030) i,j,idad(i,j),sitecon(i,j)
                     write (lu03,9030) i,j,idad(i,j),sitecon(i,j)
                  else
                     write (lu06,9040) i,j,idad(i,j),fixedcon
                     write (lu03,9040) i,j,idad(i,j),fixedcon
                  endif
  110          continue
            endif
         endif
  120 continue
c
c  -- Display main menu of options.
c
  130 write (lu06,9050) cont1
      read (lu05,9130,err=130) opt
      if (opt.eq.'r'.or.opt.eq.' ') opt = 'R'
      if (opt.eq.'c') opt = 'C'
      if (opt.ne.'1'.and.opt.ne.'2'.and.opt.ne.'3'.and.opt.ne.'4'
     *    .and.opt.ne.'5'.and.opt.ne.'R'.and.opt.ne.'C') go to 130
      write (lu03,9050) cont2,opt
c
c  -- If user entered 'R', return unchanged
c
      if (opt.eq.'R') then
        if (numads.eq.0) then
          iabq = 0
          iads = 0
        end if
        go to 300
      end if
c
      if (opt.eq.'C') then
        iabq = 0
        iads = 0
        tlmo = 'n'
        soilkg = 0.0
        numads = 0
        do 135 j = 1, 5
          nsites(j) = 0  
          solcon(j) = 0.0
          ssa(j) = 0.0
          cap1(j) = 0.0
          cap2(j) = 0.0
 135    continue 
        idsite = 0
        isurf = 0
        jsurf = 0
        l = 1  
 137    do 138 j = 1, nt(l)
          if (id(l,j).ge.811.and.id(l,j).le.859) then
            call dltcomp(l,j)
            go to 137
          end if
 138    continue 
        if (l.eq.1) then
           l = 3
           go to 137
        else if (l.eq.3) then
           l = 6
           go to 137
        end if
c
        write (lu06,9065) 
        write (lu03,9065) 
        write (lu06,9090)
        write (lu03,9090)
        read (lu05,*)
        go to 300
c
      end if
      if (opt.ne.'1') go to 150
c
c  -- Add a new surface with a site type but let the user chose option
c     3 to define reactions involving the site.
c  -- Find out how many surfaces are currently  defined and store
c     the index number of each as yet undefined surface in the
c     array jsurf.  This will enable us to reference the first
c     element of jsurf to find the first open surface for use
c     if a new surface is to be added.
c
      jj = 0
      do 140 i = 1, 5
         if (nsites(i).eq.0) then
            jj = jj+1
            opensurf(jj) = i
         endif
  140 continue
      if (numads.ge.5) then
         write (lu06,9060)
         write (lu03,9060)
         write (lu06,9090)
         write (lu03,9090)
         read (lu05,*)
         go to 100
      else
         ksurf = opensurf(1)
      endif
c
c  -- Subrout. surface defines a new surface 'isurf'. "Surface"
c     queries for parameters that characterize the surface such
c     as concentration, specific surface area, capacitance, etc.
c
      call surface (ksurf,irtn)
c
      if (irtn.eq.1) go to 100
      call clrscr (lu06)
c
c  -- For opt = 2, add a new site type on an existing surface.
c
  150 if (opt.ne.'1'.and.opt.ne.'2') go to 180
c
c  -- First ask for the surface index number and test to see that
c     there is an existing suface with that index number.
c     If a new surface has just been defined, these queries and tests
c     are not necessary.
c
      if (opt.eq.'1') go to 170
c
c  -- Get surface index number between 1 and 5.
c
  160 write (lu06,9070) cont1
      read (lu05,*,err=160) ksurf
      if (ksurf.lt.1.or.ksurf.gt.5) go to 160
      write (lu03,9070) cont2,ksurf
c
c  -- Check surface index number to see that the surface it corresponds
c     to has been defined.  If not, inform user and return to main menu.
c
      if (nsites(ksurf).eq.0) then
         write (lu06,9080) ksurf
         write (lu03,9080) ksurf
         write (lu06,9090)
         write (lu03,9090)
         read (lu05,*)
         go to 100
      endif
c
c  -- Check to see that there are less than two sites defined on this
c     surface.  If not, return to main menu.
c
      if (nsites(ksurf).eq.2) then
         write (lu06,9140)
         write (lu03,9140)
         write (lu06,9090)
         write (lu03,9090)
         read (5,*)
         go to 100
      endif
c
c  -- Compute site id number (component number).  Use surface
c     identifying number and ask for site type number (1 or 2) then
c     compute id site id number.  Display the computed number and
c     allow the user to change if it isn't correct.
c
  170 write (lu06,9100) cont1
      read (lu05,*,err=170) jsite
      if (jsite.lt.1.or.jsite.gt.2) go to 170
      write (lu03,9100) cont2,jsite
      idsite = idad(ksurf,jsite)
      k = kaddr(ksurf,jsite)
c
c  -- If the address is non-zero then jsite is a currently defined
c     component so we don't want to define it again.  Report this to
c     user and return to main menu screen.
c
      if (k.ne.0) then
         write (lu06,9110) sitename(jsite),idsite
         write (lu03,9110) sitename(jsite),idsite
         write (lu06,9090)
         write (lu03,9090)
         read (lu05,*)
         go to 100
      endif
c
c
c  -- Define a new site on surface "ksurf".
c
      call site (ksurf,jsite)
      idsite = idad(ksurf,jsite)
c
c  -- Define a new reaction involving the site with id number "idsite"
c     on surface "ksurf".
c
  180 if (opt.ne.'3') go to 220
c
c  -- First ask user for surface and site number and check the validity
c     of the answers.  If a new site has just been defined, these
c     queries are not necessary.
c
c  -- Get surface index number between 1 and 5.
c
  190 write (lu06,9070) cont1
      read (lu05,*,err=190) ksurf
      if (ksurf.lt.1.or.ksurf.gt.5) go to 190
      write (lu03,9070) cont2,ksurf
c
c  -- Check surface index number to see that the surface it corresponds
c     to has been defined.  If not, inform user and return to main menu.
c
      if (nsites(ksurf).eq.0) then
         write (lu06,9080) ksurf
         write (lu03,9080) ksurf
         write (lu06,9090)
         write (lu03,9090)
         read (lu05,*)
         go to 100
      endif
c
c  -- Using the surface identifying number and site type number (1 or 2),
c     compute site id number.  Display the computed number and
c     allow the user to change if it isn't correct.
c
  200 write (lu06,9100) cont1
      read (lu05,*,err=200) jsite
      if (jsite.lt.1.or.jsite.gt.2) go to 200
      write (lu03,9100) cont2,jsite
      idsite = idad(ksurf,jsite)
      k = kaddr(ksurf,jsite)
c
c  -- If the address is zero then jsite is not a currently defined
c     component so we can't add a reaction on it.  Report this to
c     user and return to main menu screen.
c
      if (k.eq.0) then
         write (lu06,9120) sitename(jsite),idsite
         write (lu03,9120) sitename(jsite),idsite
         write (lu06,9090)
         write (lu03,9090)
         read (lu05,*)
         go to 100
      endif
c
c  -- Define the reaction.
c
      call adsreact (ksurf,jsite)
c
c
  220 if (opt.eq.'4') then
  105   write (lu06,9055) cont1
        read (lu05,9130,err=105) ans
        if (ans.eq.'n') ans = 'N'
        if (ans.eq.'y') ans = 'Y'
        if (ans.ne.'n'.and.ans.ne.'N'.and.ans.ne.'y'.and.ans.ne.'Y') go
     *       to 105
        write (lu03,9055) cont2,ans
        nreact = 0 
        if (ans.eq.'Y') then
          call adsfilin (nreact) 
        end if
      else if (opt.eq.'5') then
c
c  -- Delete a currently defined site.  If the deletion would result
c     in zero sites remaining, warn the user that the surface has
c     become non-reactive and give opportunity to abort the deletion.
c     If the user still wants to delete, remove the site and eliminate
c     the surface including all associated parameters but leave the
c     added database elements (previously defined reactions) intact.
c
c  -- First ask user for surface and site number and check the validity
c     of the answers.
c
c  -- Get surface index number between 1 and 5.
c
  230   write (lu06,9070) cont1
        read (lu05,*,err=230) ksurf
        if (ksurf.lt.1.or.ksurf.gt.5) go to 230
        write (lu03,9070) cont2,ksurf
c
c  -- Check surface index number to see that the surface it corresponds
c     to has been defined.  If not, inform user and return to main menu.
c
        if (nsites(ksurf).eq.0) then
           write (lu06,9080) ksurf
           write (lu03,9080) ksurf
           write (lu06,9090)
           write (lu03,9090)
           read (lu05,*)
           go to 100
        endif
c
c  -- Compute site id number (component number).  Use surface
c     identifying number and ask for site index number (1 or 2) then
c     compute id site id number.  Display the computed number and
c     allow the user to change if it isn't correct.
c
  240   write (lu06,9100) cont1
        read (lu05,*,err=240) jsite
        if (jsite.lt.1.or.jsite.gt.2) go to 240
        write (lu03,9100) cont2,jsite
        idsite = idad(ksurf,jsite)
        k = kaddr(ksurf,jsite)
c
c  -- If the address is zero then jsite is not a currently defined
c     component so we can't delete it.  Report this to
c     user and return to main menu screen.
c
        if (k.eq.0) then
           write (lu06,9120) sitename(jsite),idsite
           write (lu03,9120) sitename(jsite),idsite
           write (lu06,9090)
           write (lu03,9090)
           read (lu05,*)
           go to 100
        endif
c
        if (nsites(ksurf).eq.1) then
  250      write (lu06,9150) cont1
           read (lu05,9130,err=250) ans
           if (ans.eq.'n') ans = 'N'
           if (ans.eq.'y') ans = 'Y'
           if (ans.ne.'n'.and.ans.ne.'N'.and.ans.ne.'y'.and.ans.ne.'Y')
     *       go to 250
           write (lu03,9150) cont2,ans
           if (ans.eq.'n'.or.ans.eq.'N') go to 100
c
c  -- Because user answered "yes', reset the ksurf element of solcon,
c     ssa, cap1, cap2 to zero and reduce numads by 1.
c
           solcon(ksurf) = 0.0
           ssa(ksurf) = 0.0
           cap1(ksurf) = 0.0
           cap2(ksurf) = 0.0
c
c  -- Delete the components used for potentials from the component list
c     and the excluded list if present.
c
           l = 1
  260      numkill = 0
           do 270 j = 1, 3
              indxkill(j) = 0
  270      continue
           do 280 j = 1, nt(l)
              if (id(l,j).eq.idadpsi0(ksurf)) then
                 numkill = numkill+1
                 indxkill(numkill) = j
              elseif (id(l,j).eq.idadpsib(ksurf)) then
                 numkill = numkill+1
                 indxkill(numkill) = j
              elseif (id(l,j).eq.idadpsid(ksurf)) then
                 numkill = numkill+1
                 indxkill(numkill) = j
              endif
  280      continue
           do 290 j = 1, numkill
              i = indxkill(j)
              call dltcomp (l,i)
  290      continue
           if (l.eq.1) then
              l = 6
              go to 260
           endif
c
c  -- Reduce number of adsorbing surfaces by 1
c
           numads = numads-1
        endif
c
c  -- Call routine to delete component with address k
        call sitcount (ksurf)
        k = kaddr(ksurf,jsite)
        call dltcomp (1,k)
        kaddr(ksurf,jsite) = 0
        sitecon(ksurf,jsite) = 0.0
        call sitcount (ksurf)
         write (lu06,9090)
         read (lu05,*)
c
c  -- Return to main menu.
c
      end if
      go to 100
c
  300 return
c
 9000 format (' _____________________________ ADSORPTION STATUS __',
     *   '____________________________',//,
     *   '  The following binding-site types are defined for ',i1,
     *   ' surface(s):')
 9010 format (/,'                     ---- NO SURFACES CURRENTLY',
     *   ' DEFINED ----')
 9020 format (/,'  Surface   Site Type Number   Component Number   ',
     *   ' Site Conc  (moles/l) ')
 9030 format (5x,i1,13x,i1,17x,i3,11x,1pe10.3)
 9040 format (5x,i1,13x,i1,17x,i3,11x,a15)
 9050 format (/,' _____________________________ ADSORPTION OPTIONS __',
     *   '_____________________________',/,'  Select an option:',
     * /,'    1 = Add a NEW SURFACE with a site',
     * /,'    2 = ADD a NEW SITE on an currently defined surface',
     * /,'    3 = ADD a NEW REACTION at an currently defined site',
     * /,'    4 = ATTACH an auxillary database of adsorption reactions',
     * /,'    5 = DELETE a currently defined site',
     * /,'    C = CANCEL adsorption option and return',
     * /,'    R = RETURN without changing anything',/,
     */,a1,'      Enter Choice:  ([D] = R) > ',a1)
 9055 format (//,' Do you want to specify that adsorption reactions be',
     *        ' read from an existing',
     *   /,a1,' auxillary database file? > ',1x,a1) 
 9060 format (/,'  There are already five surfaces defined and five',
     *   ' is the maximum.')
 9065 format (/,' *** ALL ADSORPTION SETTINGS CANCELED',
     *        /,'  Any adsorption reactions that you have defined or',
     *          ' added from an auxillary',
     *        /,'  database may be edited or deleted in EDIT LEVEL 3.')
     *    
 9070 format (/,a1,'  Enter the id number (1-5) of the surface to',
     *   ' which this operation pertains > ',1x,i1)
 9080 format (/,'  Surface number ',i1,' does not exist.  You must',
     *   ' add this surface before',/,
     *   '  it can be used in this operation.  See menu.')
 9090 format (/,' Press ENTER to continue')
 9100 format (/,a1,'  Enter the site type number (1 or 2) > ',1x,i1)
 9110 format (/,'  ',a11,' corresponding to component id ',i3,' has',
     *   ' already been defined.')
 9120 format (/,'  ',a11,' corresponding to component id ',i3,' has',
     *   ' not been defined.',/,
     *   '  New sites can be defined.  See next menu.')
 9130 format (a1)
 9140 format (/,'  There are already two types of sites defined on',
     *   ' this surface.')
 9150 format (/,'  There is currently only one type of site defined on',
     *   ' this surface.  If you',/,
     *   '  proceed to delete it, the surface will become',
     *   ' non-reactive and it will',/,
     *   '  automatically be removed along with all associated',
     *   ' parameters.  Any reactions',/,
     *   '  you have defined will remain in this file but',
     *   ' MINTEQA2 will ignore them.',/,a1,
     *   '  Do you want to PROCEED WITH DELETION ?  > ',1x,a1)
c
      end
c
      subroutine adsreact (isurf,jsite)
c
      include 'PRODEFA2.INC'
c
      character title*20,sorbent*5,more*4  
c
      if (isurf.eq.1) sorbent = 'ONE  '
      if (isurf.eq.2) sorbent = 'TWO  '
      if (isurf.eq.3) sorbent = 'THREE'
      if (isurf.eq.4) sorbent = 'FOUR '
      if (isurf.eq.5) sorbent = 'FIVE '
c
      call clrscr (lu06)
      write (lu06,9000) sitename(jsite),sorbent
      write (lu03,9000) sitename(jsite),sorbent
c
c  -- Compute minimum number or reactants in this reaction.
c
c
      idsite = idad(isurf,jsite)
      idlig = idsite
      ipsi0 = idadpsi0(isurf)
      ipsib = idadpsib(isurf)
      ipsid = idadpsid(isurf)
      namlig = adsname(isurf,jsite)
      if (iabq.eq.4) then
c
c  -- For simple ion exchange, ask for name of exchanger and id number
c     of exchangable metal.
         call namesp ('Ion exchanger     ',namlig)
         write (lu06,9040) cont1
         read (lu05,*) idxchger
         write (lu03,9040) cont2,idxchger
         do 100 i = 1, nt(1)
            if (id(1,i).eq.idxchger) naxchger = na(1,i)
  100    continue
      endif
c
      iv = nt(7)
      go to 130
  110 title = 'ADSORPTION REAC`NS'
  120 write (lu06,9020) cont1,more,title,sitename(jsite)
      read (lu05,9010,err=120) ans
      if (ans.eq.'n') ans = 'N'
      if (ans.eq.'y') ans = 'Y'
      write (lu03,9020) cont2,more,title,sitename(jsite),ans
      if (ans.ne.'Y'.and.ans.ne.'N') go to 120
      if (ans.ne.'Y') go to 140
  130 title = reafor(1,iabq)
      iadcmp = idsite
      call catcid (title,2)
      iv = iv+1
      more = 'MORE'
      call writep (lu16,1)
      go to 110
  140 continue
c
      return
c
 9000 format (/' __________ SPECIFICATION OF ADSORPTION REACTIONS ON ',
     *   a11,'__________',/,
     *   ' _____________________________ SURFACE NUMBER ',a5,
     *   '_____________________________')
 9010 format (a1)
 9020 format (/,a1,' Any ',a4,' ',a20,' for ',a11,'? (Y,N) > ',1x,a1)
 9040 format (/,'  Enter the id number of the exchangable metal that',
     *   ' originally occupies the',/,a1,' exchange site > ',1x,i3)
c
      end
c
      subroutine site (isurf,jsite)
c
      include 'PRODEFA2.INC'
c
      character sorbent*5,adsunits*11,nam*20
c
      if (isurf.eq.1) sorbent = 'ONE  '
      if (isurf.eq.2) sorbent = 'TWO  '
      if (isurf.eq.3) sorbent = 'THREE'
      if (isurf.eq.4) sorbent = 'FOUR '
      if (isurf.eq.5) sorbent = 'FIVE '
c
      call clrscr (lu06)
      if (iabq.ne.1.and.iabq.ne.3) then
        write (lu06,9000) sitename(jsite),sorbent
        write (lu03,9000) sitename(jsite),sorbent
      end if
c
      adsunits = flag
c
      idv = idad(isurf,jsite)
      nam = adsname(isurf,jsite)      
c
c  -- All models except Activity Kd and Activity Freundlich require
c     specification of a site concentration or site density (site
c     concentration is infinite so site activity is held invariant
c     for those two models).  Allow user to choose in which units to
c     specify site concentration.
c
      aaa = 0
      bbb = 0
      if (iabq.ne.1.and.iabq.ne.3) then
         adsunits = 'moles/liter'
c
c -- Provide choice of entering adsorption site concentration in
c    moles/liter (isitcon = 1) or moles/gram (isitcon = 2).
c
         if (iabq.ge.5) then
  100       write (lu06,9010) sitename(jsite),sorbent,cont1
            read (lu05,*,err=100) isitcon
            write (lu03,9010) sitename(jsite),sorbent,cont2,isitcon
            if (isitcon.ne.1.and.isitcon.ne.2) go to 100
            if (isitcon.eq.2) adsunits = 'moles/gram'
         endif
c
  110    write (lu06,9020) cont1,sitename(jsite),adsunits
         read (lu05,*,err=110) aaa
         if (aaa.le.0.0) go to 110
         write (lu03,9020) cont2,sitename(jsite),adsunits,aaa
c
c -- If units for site concentration are moles/gram, convert to
c    moles/liter.
         if (isitcon.eq.2) aaa = aaa*solcon(isurf)
         bbb = log10(aaa)
      endif
c
c -- Add component idv to the list of components.
      call speadd (1,idv,nam,aaa,bbb,dmy,dmy,1,1,ifg,1)
      if (iabq.eq.1.or.iabq.eq.3) then
         dmy = 0.0
         ddd = 0.0
c
c -- Add component idv to the type 3 fixed species list.
         call speadd (3,idv,nam,-bbb,bbb,dmy,ddd,1,1,ifg,0)
      endif
c
      return
c
 9000 format (/' ___________________ SPECIFICATION OF BINDING ',a11,
     *   ' ___________________',/,
     *   '         _____________________ SURFACE NUMBER ',a5,
     *   ' _____________________')
 9010 format (//,'  Select units for specifying the concentration of ',
     *   a11,/,' on surface number ',a5,/,
     *   '    1 = (moles of sites)/liter of solution',/,
     *   '    2 = (moles of sites)/gram of adsorbent',/,a1,
     *   '       ENTER CHOICE  > ',i1)
 9020 format (/,a1,' Enter concentration of ',a11,' in ',a11,' > ',e12.5
     *   )
c
      end
c
      subroutine sitcount (isurface)
c
c  -- Count the site types on surface "isurface" by looking for
c     adsorption component id numbers among the id numbers currently
c     defined.
c
      include 'PRODEFA2.INC'
c
      kaddr(isurface,1) = 0
      kaddr(isurface,2) = 0
      nsites(isurface) = 0
      do 100 k = 1, nt(1)
         if (id(1,k).eq.idad(isurface,1)) then
            sitecon(isurface,1) = teq(1,k)
            nsites(isurface) = nsites(isurface)+1
            kaddr(isurface,1) = k
         elseif (id(1,k).eq.idad(isurface,2)) then
            sitecon(isurface,2) = teq(1,k)
            nsites(isurface) = nsites(isurface)+1
            kaddr(isurface,2) = k
         endif
  100 continue
c
      return
      end
c
      subroutine surface (isurf,irtn)
c
      include 'PRODEFA2.INC'
c
      character title*20,sorbent*5
      include 'CONST.INC'
c
      call clrscr (lu06)
c
c  -- Set irtn to 0.  Later, when solcon(i) is requested, if the user
c     responds with 0, it means that a new surface is not wanted
c     after all.  Then, irtn is re-set to 1 and passed back to the
c     calling routine for appropriate action.
c
      irtn = 0
c
      if (isurf.eq.1) sorbent = 'ONE  '
      if (isurf.eq.2) sorbent = 'TWO  '
      if (isurf.eq.3) sorbent = 'THREE'
      if (isurf.eq.4) sorbent = 'FOUR '
      if (isurf.eq.5) sorbent = 'FIVE '
      write (lu06,9000) sorbent
c
      if (iads.eq.1) then
         numads = numads+1
         go to 150
      endif
c
c  DEFINITION ADSORBENT CONCENTRATION FOR DOUBLE AND TRIPLE LAYER MOD
c
  100 write (lu06,9010) cont1
      read (lu05,*,err=100) solcon(isurf)
      if (solcon(isurf).lt.((-1)*R0MIN)) go to 100
      if (abs(solcon(isurf)).lt.R0MIN) then
         irtn = 1
         go to 150
      endif
      numads = numads+1
      write (lu03,9010) cont2,solcon(isurf)
  110 write (lu06,9020) cont1
      read (lu05,*,err=110) ssa(isurf)
      if (ssa(isurf).le.0.) go to 110
      write (lu03,9020) cont2,ssa(isurf)
      if (iads.eq.4) go to 130
c
c  -- Define electrostatic potentials associated with the Constant
c     Capacitance, Triple Layer, and Diffuse Layer Models.
c
  120 write (lu06,9030) cont1
      read (lu05,*,err=120) cap1(isurf)
      write (lu03,9030) cont2,cap1(isurf)
  130 title = adsname(isurf,3)
      bbb = 0.0
      ipsi0 = idadpsi0(isurf)
      call speadd (1,ipsi0,title,dmy,bbb,dmy,dmy,0,1,ifg,1)
      call speadd (6,ipsi0,title,dmy,bbb,dmy,dmy,0,1,ifg,0)
      write (lu06,9040)
      write (lu03,9040)
c
      if (iabq.eq.6) then
         title = adsname(isurf,4)
         bbb = 0.0
         ipsib = idadpsib(isurf)
         call speadd (1,ipsib,title,dmy,bbb,dmy,dmy,0,1,ifg,1)
         call speadd (6,ipsib,title,dmy,bbb,dmy,dmy,0,1,ifg,0)
c
         title = adsname(isurf,5)
         bbb = 0.0
         ipsid = idadpsid(isurf)
         call speadd (1,ipsid,title,dmy,bbb,dmy,dmy,0,1,ifg,1)
         call speadd (6,ipsid,title,dmy,bbb,dmy,dmy,0,1,ifg,0)
         write (lu06,9041)
         write (lu03,9041)
  140    write (lu06,9050) cont1
         read (lu05,*,err=140) cap2(isurf)
         write (lu03,9050) cont2,cap2(isurf)
      endif
      write (lu06,9042)
      write (lu03,9042)
      write (lu06,9210)
      write (lu03,9210)
      read (lu05,*)
      call clrscr (lu06)
c
  150 return
c
 9000 format (///,' ______________ SPECIFICATIONS FOR ADSORBING',
     *   ' SURFACE NUMBER ',a5,' ______________')
 9010 format (/,'  Enter the concentration of solid associated with',
     *   ' this surface (g/l).',/,a1,
     *   ' Enter zero to abort the definition of a new',' surface   > ',
     *   e12.5)
 9020 format (/,'  Enter the specific surface area pertaining to this',/
     *   ,a1,' surface (sq. meters/g) > ',e12.5)
 9030 format (/,a1,' Enter the inner layer capacitance (about 1.4',
     *   ' farads/sq. meter) > ',e12.5)
 9040 format (/'  A guess of zero (volts) has been entered for the',
     *         ' surface potential (psi0)',
     *       /,'  for this surface.')
 9041 format (/'  A guess of zero (volts) has been entered for the',
     *         ' inner and outer Helmholtz',
     *       /,'  potentials (psib and psid respectively) for this',
     *         ' surface.')
 9042 format (/'  All guesses for potentials are entered as the log',
     *         ' activity of the component',
     *       /,'  representing that potential.  You may change these',
     *         ' guesses in EDIT LEVEL 3.')
 9050 format (/,a1,' Enter the outer layer capacitance (about 0.2',
     *   ' farads/sq. meter) > ',e12.5)
 9210 format (/,' Press ENTER to continue')
c
      end
