      subroutine addspe (nty,name,idc,eqx,hrx)
c
c********************************************************************
c FUNCTION:
c     ADDS THERMODYNAMIC DATA AND PARAMETERS FOR ADDED SPECIES NOT
c     IN THE DATA BASE
c INPUT:
c     NTY= TYPE OF SPECIES (1-6)
c     NAME=NAME OF SPECIES BEING ADDED
c     IDC=ID OF SPECIES BEING ADDED
c OUTPUT:
c     DATA FOR NEW SPECIES AS REQUIRED BY TYPE OF SPECIES
c     (STORED IN ADDITION ARRAY AND TYPE ARRAY)
c
      include 'PRODEFA2.INC'
c
      character name*20, oplane*1, test1*1, test2*1
      real*4 stotmp(12), temp1
      include 'CONST.INC'
c
c NAMDS=NAME OF DERIVED SPECIES IN THE REACTION
c IDDS=I. D. NUMBER OF DERIVED SPECIES
c EQR=LOG10(KEQ) FOR DERIVED SPECIES BY CONVENTION OF THERMO.DAT
c IDR(I)=I.D. NUMBER OF ITH COMPONENT IN REACTION
c COER(I)=REACTION COEFFICIENT OF ITH COMPONENT IN REACTION
c NCMPR=NUMBER OF INDEPENDENT COMPONENTS IN REACTIONC
c IFIXER=Y/N FLAG ON FIXATION OF SPECIES
c
c DETERMINE WHETHER SPECIES HAS ALREADY BEEN ADDED TO ADDITION FILE
c
      if (nt(nty).le.0) go to 140
  100 do 130 j = 1, nt(7)
         if (id(7,j).eq.idc) then
  110       write (lu06,9000) cont1,idc
            read (lu05,9170,err=110) ans
            if (ans.eq.'n'.or.ans.eq.' ') ans = 'N'
            if (ans.eq.'y') ans = 'Y'
            if (ans.ne.'Y'.and.ans.ne.'N') go to 110
            write (lu03,9000) cont2,idc,ans
            if (ans.eq.'N') go to 390
  120       write (lu06,9010) cont1
            read (lu05,*,err=120) idc
            if (idc.lt.1.and.idc.gt.9999999) go to 120
            write (lu03,9010) idc
            go to 100
         endif
  130 continue
c NO. IT HASNT. PROCEED TO DEFINE ITS PARAMETERS AND EQUILIBRIUM
c
  140 if (ntysp.eq.1) then
         write (lu06,9020) tit(ntysp)
         write (lu03,9020) tit(ntysp)
      else
         write (lu06,9030) tit(ntysp)
         write (lu03,9030) tit(ntysp)
      endif
      nt(7) = nt(7)+1
      ii = nt(7)
      id(7,ii) = idc
      idds = idc
      if (ntysp.ne.4) call namesp (tit(ntysp),name)
      if (ntysp.eq.4) call namesp (reafor(1,iabq),name)
      na(7,ii) = name
      namds = name
      nt7(nty) = nt7(nty)+1
      nt7(nty) = min0(nt7(nty),nmx7)
      k = nt7(nty)
      index7(nty,k) = ii
      sp7(ii) = 0.
      dha7(ii) = 0.
      dhb7(ii) = 0.
      alk7(ii) = 0.
      gf7(ii) = 0.
      if (ntysp.gt.3) go to 200
      if (ntysp.eq.3) go to 190
  150 write (lu06,9040) cont1
      read (lu05,*,err=150) sp7(ii)
      write (lu03,9040) cont2,sp7(ii)
  160 write (lu06,9050) cont1,'A'
      read (lu05,*,err=160) dha7(ii)
      write (lu03,9050) cont2,'A',dha7(ii)
  170 write (lu06,9050) cont1,'B'
      read (lu05,*,err=170) dhb7(ii)
      write (lu03,9050) cont2,'B',dhb7(ii)
  180 write (lu06,9060) cont1
      read (lu05,*,err=180) alk7(ii)
      write (lu03,9060) cont2,alk7(ii)
  190 write (lu06,9070) cont1
      read (lu05,*,err=190) gf7(ii)
      if (gf7(ii).lt.0) go to 190
      write (lu03,9070) cont2,gf7(ii)
      if (ntysp.eq.1) then
         nt0 = nt0+1
         id0(nt0) = id(7,ii)
         na0(nt0) = na(7,ii)
         gf0(nt0) = gf7(ii)
         ch0(nt0) = sp7(ii)
         eqx = 0.
         call cominc (nty1,id(7,ii),na(7,ii),'N',0)
         go to 380
      endif
c
c --  Set minimum number of components for adsorption reactions
c
  200 do 210 i = 1, 12
         id7(i,ii) = 0
         na7(i,ii) = '                    '
         idb7(i,ii) = 0
         stoic7(i,ii) = 0.0
         stoib7(i,ii) = 0.0
  210 continue
      mnr = 2
      num = 12
      if (iabq.eq.5.or.iabq.eq.7) num = 11
      if (iabq.eq.6) num = 10
      id7(1,ii) = idlig
      na7(1,ii) = namlig
      id7(2,ii) = idmet
      na7(2,ii) = nammet
      if (ntysp.eq.4.and.iabq.eq.4) then
         mnr = 3
         id7(3,ii) = idxchger
         na7(3,ii) = naxchger
      endif
c
c  -- Generate the desired reactions.
      if (iabq.eq.3.and.ntysp.eq.4) then
         call clrscr (lu06)
         write (lu06,9220)
         write (lu03,9220)
         write (lu06,9210)
         write (lu03,9210)
         read (lu05,*)
         call clrscr (lu06)
      endif
  220 n = 0
      m = 0
      do 230 i = 1, 12
         stotmp(i) = 0.0
  230 continue
      ncmp(ii) = 0
      nbcmp(ii) = 0
      nreac = 0
  240 n = n+1
      if (n.gt.num) then
         write (lu06,9080) num
         write (lu03,9080) num
         go to 390
      endif
      if (n.le.mnr) go to 260
  250 call idcomp (4,na7(n,ii),id7(n,ii),jkl)
      if (jkl.eq.-1) go to 390
      if (jkl.eq.0) go to 250
  260 mn = max0(mnr,n)
      call clrscr (lu06)
      if (iabq.eq.3.and.ntysp.eq.4) then
         write (lu06,9100) stoic7(1,ii),na7(1,ii),'  +  ',stoic7(2,ii),
     *      na7(2,ii),'<----->  ',na(7,ii),('  +  ',stoic7(k,ii),na7(k,
     *      ii),k=3,mn)
         write (lu03,9100) stoic7(1,ii),na7(1,ii),'  +  ',stoic7(2,ii),
     *      na7(2,ii),'<----->  ',na(7,ii),('  +  ',stoic7(k,ii),na7(k,
     *      ii),k=3,mn)
         write (lu06,9120)
         write (lu03,9120)
      else
         write (lu06,9090) stoic7(1,ii),na7(1,ii),'  +  ',stoic7(2,ii),
     *      na7(2,ii),'<----->  ',na(7,ii),('  +  ',stoic7(k,ii),na7(k,
     *      ii),k=3,mn)
         write (lu03,9090) stoic7(1,ii),na7(1,ii),'  +  ',stoic7(2,ii),
     *      na7(2,ii),'<----->  ',na(7,ii),('  +  ',stoic7(k,ii),na7(k,
     *      ii),k=3,mn)
         if (cmplig.ne.'y') then
           write (lu06,9140)
           write (lu03,9140)
         else
           write (lu06,9130)
           write (lu03,9130)
         end if
      endif
  270 write (lu06,9150) cont1,na7(n,ii)
      read (lu05,*,err=270) stoic7(n,ii)
c  -- If zero is entered, inform user that all components 
c     have implicitly a stoichiometry of zero unless a non-zero
c     except for those for which a non-zero value is entered.
c     Don't add this component after all -- reduced n by 1
c     and return to ask for other components. 
      if (abs(stoic7(n,ii)).lt.R0MIN) then
        write (lu06,9155) na7(n,ii)
        write (lu03,9155) na7(n,ii)
        n = n - 1
        write (lu06,9210)
        write (lu03,9210)
        read (lu05,*)
        call clrscr (lu06)
        if (n.lt.mnr) then
          go to 240
        else 
          go to 290	 
        end if                
      end if
      write (lu03,9150) cont2,na7(n,ii),stoic7(n,ii)
      if (stoic7(n,ii).gt.0.) nreac = 1
      ncmp(ii) = ncmp(ii)+1
      if (iabq.eq.3.and.ntysp.eq.4) then
         write (lu06,9110) stotmp(1),na7(1,ii),'  +  ',stotmp(2),na7(2,
     *      ii),'<----->  ',na(7,ii),('  +  ',stotmp(k),na7(k,ii),k=3,mn
     *      )
         write (lu03,9110) stotmp(1),na7(1,ii),'  +  ',stotmp(2),na7(2,
     *      ii),'<----->  ',na(7,ii),('  +  ',stotmp(k),na7(k,ii),k=3,mn
     *      )
         write (lu06,9130)
         write (lu03,9130)
  280    write (lu06,9150) cont1,na7(n,ii)
         read (lu05,*,err=280) stotmp(n)
c  -- If zero is entered, inform user that all components 
c     have implicitly a stoichiometry of zero unless a non-zero
c     except for those for which a non-zero value is entered.
c     Don't add this component after all -- reduced n by 1
c     and return to ask for other components. 
         if (abs(stotmp(n)).lt.R0MIN) then
           write (lu06,9155) na7(n,ii)
           write (lu03,9155) na7(n,ii)
           n = n - 1
           write (lu06,9210)
           write (lu03,9210)
           read (lu05,*)
           call clrscr (lu06)
           if (n.lt.mnr) then
             go to 240
           else 
             go to 290	 
           end if                
         end if
         write (lu03,9150) cont2,na7(n,ii),stotmp(n)
      endif
      if (n.lt.mnr) go to 240
c
  290 write (lu06,9160) cont1
      read (lu05,9170,err=290) ans
      if (ans.eq.'n') ans = 'N'
      if (ans.eq.'y') ans = 'Y'
      write (lu03,9160) cont2,ans
      if (ans.ne.'N'.and.ans.ne.'Y') go to 290
      if (ans.eq.'Y') go to 240
      ncmpr = ncmp(ii)
      if (nreac.eq.0) then
         write (lu06,9180)
         write (lu03,9180)
         go to 220
      endif
      if (ntysp.ne.4.or.iabq.lt.5) go to 320
c
c CALCULATE STOICHIOMETERY FOR ELECTROSTATIC COMPONENTS OF ADSORPTION
c
c  -- For the triple layer model only (iabq = 6), the global variable
c     tlmo (value acquired in subroutine adsinit) is a flag indicating
c     whether to query with regard to  contributions to the charge 
c     in the o-plane (tlmo = 'y' means do ask about this for each
c     reaction).  This query is irrelevant for protonation
c     and de-protonantion reactions (only 2 components, one is H+), 
c     so don't ask.   
      if (iabq.eq.6) then
        test1 = 'n'
        test2 = 'n'
        do 305 j = 1, ncmpr
           if (id7(j,ii).eq.330) test1 = 'y'
  305   continue
        if (ncmpr.eq.2.and.test1.eq.'y') test2 = 'y'
c
c  -- If tlmo is set to 'y' and this is not a protonation or
c     de-protonation reaction, ask whether all adsorbed ions 
c     are to contribute to charge in the o-plane (rather than 
c     the beta-plane).
        oplane = 'n'
        if (tlmo.eq.'y'.and.test2.eq.'n') then
 295      write (lu06,9250) cont1 
          read (lu05,9170,err=295) ans
          if (ans.eq.'n') ans = 'N'
          if (ans.eq.'y') ans = 'Y'
          write (lu03,9250) cont2,ans
          if (ans.ne.'N'.and.ans.ne.'Y') go to 295
          if (ans.eq.'Y') oplane = 'y'
        end if
      end if
c
c  -- Calculate the stoichiometry of the electrostatic components.
      n1 = n+1
      n2 = n+2
      id7(n1,ii) = ipsi0
      na7(n1,ii) = 'Xpsi0'
      if (iabq.eq.6.and.oplane.eq.'n') then
         id7(n2,ii) = ipsib
         na7(n2,ii) = 'Xpsib'
      endif
      do 310 n = 1, ncmpr
         do 300 m = 1, nt0
            if (id0(m).ne.id7(n,ii)) go to 300
            if (iabq.eq.5.or.iabq.eq.7.or.
     *          iabq.eq.6.and.oplane.eq.'y') then
               stoic7(n1,ii) = stoic7(n1,ii)+stoic7(n,ii)*ch0(m)
            endif
            if (iabq.eq.6.and.oplane.eq.'n') then
              if (id7(n,ii).eq.330) then
                stoic7(n1,ii) =  stoic7(n1,ii)+ stoic7(n,ii)*ch0(m)
              else if (id7(n,ii).ne.330) then
                stoic7(n2,ii) = stoic7(n2,ii)+stoic7(n,ii)*ch0(m)
              end if
            end if
            go to 310
  300    continue
  310 continue
c
c  -- Adjust the number of components, eliminating those that have
c     a calculated stoichiometry of zero and "scoot" all the non-
c     zero ones to the first elements of the arrays.
      if (iabq.eq.5.or.iabq.eq.7.or.iabq.eq.6.and.oplane.eq.'y') then
         if (abs(stoic7(n1,ii)).gt.R0MIN) then
           ncmpr = ncmpr+1
         else 
           id7(n1,ii) = 0
           na7(n1,ii) = '    '
         end if
      elseif (iabq.eq.6.and.oplane.eq.'n') then
         if (abs(stoic7(n1,ii)).gt.R0MIN.and.abs(stoic7(n2,ii))
     *       .gt.R0MIN) then
           ncmpr = ncmpr+2
         else if (abs(stoic7(n1,ii)).gt.R0MIN.and.abs(stoic7(n2,ii))
     *            .lt.R0MIN) then
           ncmpr = ncmpr+1
           id7(n2,ii) = 0
           na7(n2,ii) = '    '
         else if (abs(stoic7(n1,ii)).lt.R0MIN.and.abs(stoic7(n2,ii))
     *            .gt.R0MIN) then
           ncmpr = ncmpr+1
           stoic7(n1,ii) = stoic7(n2,ii)
           stoic7(n2,ii) = 0.0
           id7(n1,ii) = id7(n2,ii)
           id7(n2,ii) = 0
           na7(n1,ii) = na7(n2,ii)
           na7(n2,ii) = '    '
         else
           id7(n1,ii) = 0
           na7(n1,ii) = '    '
           id7(n2,ii) = 0
           na7(n2,ii) = '    '
         end if       
      endif
c
      ncmp(ii) = ncmpr
  320 ncmpr = ncmp(ii)
      call clrscr (lu06)
      if (iabq.eq.3.and.ntysp.eq.4) then
         write (lu06,9100) stoic7(1,ii),na7(1,ii),'  +  ',stoic7(2,ii),
     *      na7(2,ii),'<----->  ',na(7,ii),('  +  ',stoic7(k,ii),na7(k,
     *      ii),k=3,mn)
         write (lu03,9100) stoic7(1,ii),na7(1,ii),'  +  ',stoic7(2,ii),
     *      na7(2,ii),'<----->  ',na(7,ii),('  +  ',stoic7(k,ii),na7(k,
     *      ii),k=3,mn)
         write (lu06,9110) stotmp(1),na7(1,ii),'  +  ',stotmp(2),na7(2,
     *      ii),'<----->  ',na(7,ii),('  +  ',stotmp(k),na7(k,ii),k=3,mn
     *      )
         write (lu03,9110) stotmp(1),na7(1,ii),'  +  ',stotmp(2),na7(2,
     *      ii),'<----->  ',na(7,ii),('  +  ',stotmp(k),na7(k,ii),k=3,mn
     *      )
      else
         write (lu06,9090) stoic7(1,ii),na7(1,ii),'  +  ',stoic7(2,ii),
     *      na7(2,ii),'<----->  ',na(7,ii),('  +  ',stoic7(k,ii),na7(k,
     *      ii),k=3,mn)
         write (lu03,9090) stoic7(1,ii),na7(1,ii),'  +  ',stoic7(2,ii),
     *      na7(2,ii),'<----->  ',na(7,ii),('  +  ',stoic7(k,ii),na7(k,
     *      ii),k=3,mn)
      endif
c
c MAKE CERTAIN THAT ALL CONTRIBUTING COMPONENTS ARE ENTERED INTO
c    COMPONENT FILE.
c
      do 350 n = 1, ncmpr
         call cominc (nty1,id7(n,ii),na7(n,ii),'N',0)
  350 continue
c
      if (iabq.eq.3.and.ntysp.eq.4) then
         m = 0
         nbcmp(ii) = 0
         do 360 i = 1, ncmp(ii)
            temp1 = abs(stotmp(i) - stoic7(i,ii))
            if (temp1.gt.R0MIN) then
               m = m+1
               stoib7(m,ii) = stotmp(i)
               nbcmp(ii) = nbcmp(ii)+1
               idb7(m,ii) = id7(i,ii)
               nab7(m,ii) = na7(i,ii)
            endif
  360    continue
         write (lu06,9230)
         write (lu03,9230)
      endif
c
c UPDATE THE REACTION FILE
c
      do 370 n = 1, ncmpr
c
c   INSTALL SPECIAL CONDITIONS SOMETIMES REQUIRED OF ADSORPTION REACT
c
         coer(n) = stoic7(n,ii)
         idr(n) = id7(n,ii)
         namer(n) = na7(n,ii)
  370 continue
      ntyr = nty
c
c COMPLETE REACTION ARRAY AND CALCULATE ITS DEGREE OF FREEDOM
c
      call reafil (id(7,ii),0)
c
c NOW GET THERMODYNAMIC PARAMETERS
c
      if (iabq.ne.1.or.ntysp.ne.4) then
        write (lu06,9190)
        write (lu03,9190)
      end if
      call thconst (teq(7,ii),1,1)
      call thconst (thr(7,ii),2,1)
      idds = id(7,ii)
      namds = na(7,ii)
      eqr = teq(7,ii)
      eqx = eqr
      hdr = thr(7,ii)
      hrx = hdr
c
  380 write (lu06,9200) idc,name,eqx
      write (lu03,9200) idc,name,eqx
c
  390 return
c
c
 9000 format (/,a1,' ID= ',i7,' Has Already Been Defined.  ',
     *   'Choose Another ? (Y,N) > ',1x,a1)
 9010 format (/,a1,' Enter Another ID# > ',1x,i8)
 9020 format (' Proceed To Add ',a16,' Not Yet In The Data Base')
 9030 format (' Now Add Reaction Not Yet In Data Base For ',a16)
 9040 format (/,a1,' Enter Charge On Species > ',f5.2)
 9050 format (/,a1,' Enter Debye-Huckel ',a1,' Parameter > ',f5.2)
 9060 format (/,a1,' Enter Alkalinity Factor > ',f5.2)
 9070 format (/,a1,' Enter Molecular Wt. (GFW) > ',f9.4)
 9080 format (' Only ',i2,' User Designated Reactants Can Be',
     *   ' Accomodated')
 9090 format (/,'        THE REACTION THUS FAR CREATED IS :',//,12x,f6.3
     *   ,1x,a8,a5,f6.3,1x,a8,a11,a12,5(/,7x,a5,f6.3,1x,a8,a5,f6.3,1x,a8
     *   ))
 9100 format (/,'  THE REACTION CORRESPONDING TO MASS ACTION THUS',
     *   ' FAR CREATED IS :',//,12x,f6.3,1x,a8,a5,f6.3,1x,a8,a11,a12,5(/
     *   ,7x,a5,f6.3,1x,a8,a5,f6.3,1x,a8))
 9110 format (/,'  THE REACTION CORRESPONDING TO MASS BALANCE THUS',
     *   ' FAR CREATED IS :',//,12x,f6.3,1x,a8,a5,f6.3,1x,a8,a11,a12,5(/
     *   ,7x,a5,f6.3,1x,a8,a5,f6.3,1x,a8))
 9120 format (/,'        >>>>>>>> Specify MASS ACTION stoichiometry',
     *   ' <<<<<<<<')
 9130 format (/,'        >>>>>>> Specify MASS BALANCE stoichiometry',
     *   ' <<<<<<<')
 9140 format (/,'     >>> Specify MASS ACTION and MASS BALANCE',
     *   ' stoichiometry <<<')
 9150 format (/' REACTANTS (entities ordinarily on the left side)',
     *         ' have positive stoichiometry',
     *       /,' PRODUCTS (entities ordinarily on the right side)',
     *         ' have negative stoichiometry.',
     *      //a1,' >>> ENTER the stoichiometry of ',a12,' > ',1x,f6.2)
 9155 format (/' All components implicitly zero stoichiometry unless',
     *         ' you enter a',
     *        /' non-zero value.  COMPONENT ',a12,' NOT ENTERED.')
 9160 format (/,a1,' Are there any other components in this reaction',
     *   ' ? (Y,N) > ',1x,a1)
 9170 format (a1)
 9180 format (' Reaction Does Not Have Any Reactants, Only',
     *   ' Products. Reenter Reaction.')
 9190 format (/' For The Request That Follows, K Must Be',
     *   ' Consistent With Molar Concentrations.')
 9200 format (' ID # ',i7,2x,a20,' Current Log K=',f8.3)
 9210 format (/,' Press ENTER to continue')
 9220 format (////,' --- The Freundlich adsorption reaction demands',
     *   ' that the mass balance',/,
     *   '     stoichiometry differ from the mass action',
     *   ' stoichiometry for at least one',/,
     *   '     component.  If the mass balance and mass',
     *   ' action stoichiometries are',/,
     *   '     identical, the Freundlich model becomes',
     *   ' equivalent to the Kd model.',//,
     *   ' --- The mass action and mass balance',
     *   ' stoichiometries are requested separately',/,
     *   '     below for each component in the reaction.')
 9230 format (/,'  The stoichiometries that pertain to the definition',
     *   ' of K are those which',/,'  correspond to MASS ACTION above.')
 9250 format (/,' You may designate that all ions contribute only to',
     *          ' the o-plane charge for',
     *        /,' this reaction.  (This option is irrelevant for',
     *          ' reactions involving only H+.)',
     *        /,a1,'Do you want to invoke this option? (Y,N) > ',
     *          1x,a1)
c
      end
      subroutine catcid (title,nty)
c
c********************************************************************
c FUNCTION:
c     OBTAIN ID NUMBER AND NAME OF SPECIFIED SPECIES.
c     MAKE CERTAIN THAT SPECIES ARE PLACED IN APPROPRIATE
c     ARRAYS.
c INPUT:
c     TITLE=SPECIFIC DESCRIPTION OF SPECIES
c     NTYSP=CLASSIFICATION INDEX FOR SPECIES, IE 1=COMPONENT,2=AQUEOU
c        SPECIES,3=MINERAL,4=ADSORBED SPECIES,5=REDOX COUPLE,6=GAS
c     NTY=SPECIES TYPE (1-6)
c OUTPUT:
c     STORAGE INTO PROPER NA(NTY,I),ID(NTY,I),TEQ(NTY,I), THR(NTY,I)
c********************************************************************
c CORRECTION HISTORY:
c   DATE                     CORRECTION                      REFERENC
c 10-25-85   CORRECTED HANDLING OF FINITE GASES           BNW 4122 P
c
c********************************************************************
c
      include 'PRODEFA2.INC'
c
c
      integer idigit(9), ntemp(9)
      character title*20,titb*6,name*20,ans2*1,match*1
c
c NMADS=NAME OF DERIVED SPECIES IN THE REACTION
c IDDS=I. D. NUMBER OF DERIVED SPECIES
c EQR=LOG10(KEQ) FOR DERIVED SPECIES BY CONVENTION OF THERMO.DAT
c IDR(I)=I. D. NUMBER OF ITH COMPONENT IN REACTION
c COER(I)=REACTION COEFFICIENT OF ITH COMPONENT IN REACTION
c NCMPR=NUMBER OF INDEPENDENT COMPONENTS IN REACTIONC
c IFIXER=Y/N FLAG ON FIXATION OF SPECIES
c
      character*8 namspe(2)
c
      data titb / 'anion '/
c
      nty1 = nty
      ans2 = '1'
      jkl = 0
c 
c  -- Set logical unit number of database to be searched.
      if (ntysp.eq.5) then
c
c  -- Search REDOX.DBS
         luxx = lu08
      elseif (ntysp.eq.6) then
c
c  -- Search TYPE6.UNF
         luxx = lu09
      else
c
c  -- For normal aqueous species, search THERMO.UNF
         luxx = lu07
c
c  -- For aqueous species involving composit ligands, search 
c     COMPLIG.DBS
        if (cmplig.eq.'y') luxx = lu10
c
      endif
c
      iaa = 1
      ibb = 1
c
c -- For component or adsorbed species (ntysp=1 or 4), skip the initial
c    search of the thermodynamic database because neither type is
c    stored there.
c
      if (ntysp.eq.1.or.ntysp.ge.4.) go to 170
c
c -- For aqueous species (ntysp=2), give user opportunity to change the
c    log K and/or enthalpy of existing entries in the thermodynamic
c    database or define new species to be included as added species.
c
      if ((ntysp.eq.2.or.ntysp.eq.3).and.nty1.ne.6) then
  100    write (lu06,9010) cont1
         read (lu05,9040,err=100) ans2 
         write (lu03,9010) cont2,ans2 
         if (ans2.eq.'r'.or.ans2.eq.' ') ans2 = 'R'
         if (ans2.ne.'R'.and.ans2.ne.'1'.and.ans2.ne.'2') go to 100
         if (ans2.eq.'R') go to 410
         if (ans2.eq.'2') go to 170
      endif
c
c
c  -- Find out if the id number is known; use for search if it is. 
 110  write (lu06,9000) cont1,title
      read (lu05,9040,err=110) ans
      if (ans.eq.'n'.or.ans.eq.' ') ans = 'N'
      if (ans.eq.'y') ans = 'Y'
      write (lu03,9000) cont2,title,ans
      if (ans.ne.'Y'.and.ans.ne.'N') go to 110
      if (ans.eq.'N') go to 170
c
c  BRANCH WHEN ID KNOWN
c
  120 idmin = 1000
      idmax = 9999999
      write (lu06,9050) cont1,tit(ntysp)
      read (lu05,*,err=120) idc
      write (lu03,9050) cont2,tit(ntysp)
      if (idc.lt.idmin.or.idc.gt.idmax) then
         write (lu06,9060) idmin,idmax
         write (lu03,9060) idmin,idmax
         go to 120
      endif
      write (lu03,9050) cont2,tit(ntysp),idc
      if (ans2.eq.'2') go to 350
      call search (nty1,idc,luxx,0,name,eqr,hdr,jkl,ndbase)
      if (nty1.eq.6.and.exclu.eq.'n') go to 410
      if (jkl.le.0.and.ntysp.gt.1.and.nty1.ne.6) then
         write (lu06,9020) tit(ntysp),idc
         write (lu03,9020) tit(ntysp),idc
  130    write (lu06,9030) cont1
         read (lu05,9040,err=130) ans
         if (ans.eq.'n') ans = 'N'
         if (ans.eq.'y') ans = 'Y'
         write (lu03,9030) cont2,ans
         if (ans.ne.'Y'.and.ans.ne.'N') go to 130
         if (ans.eq.'N'.and.(ntysp.eq.2.or.ntysp.eq.3)) then
  140       write (lu06,9200) cont1
            read (lu05,9040,err=140) ans
            write (lu03,9200) cont2,ans
            if (ans.ne.'Y'.and.ans.ne.'N') go to 140
            if (ans.eq.'N') then
               go to 410
            else
               jkl = 0
               go to 170
            endif
         elseif (ans.eq.'N'.and.(ntysp.eq.5.or.ntysp.eq.6)) then
  150       write (lu06,9220) cont1
            read (lu05,9040,err=150) ans
            if (ans.eq.'n') ans = 'N'
            if (ans.eq.'y') ans = 'Y'
            write (lu03,9220) cont2,ans
            if (ans.ne.'Y'.and.ans.ne.'N') go to 150
            if (ans.eq.'N') then
               go to 410
            else
               jkl = 0
               go to 170
            endif
         else
            jkl = 0
            go to 120
         endif
      else
  160    if (nty1.ne.6) then
           write (lu06,9190) cont1
           read (lu05,9040,err=160) ans
           if (ans.eq.'n') ans = 'N'
           if (ans.eq.'y') ans = 'Y'
           write (lu03,9190) cont2,ans
           if (ans.ne.'Y'.and.ans.ne.'N') go to 160
           if (ans.eq.'N') go to 410
         end if
         do 165 j = 1, nt(nty)
            if (idc.eq.id(nty,j)) then
              write (lu06,9195) j,nty,idc
              write (lu03,9195) j,nty,idc
              write (lu06,9105) cont1
              write (lu03,9105) 
              read (lu05,*)
              go to 410
            end if
  165    continue
      endif
      go to (410,200,230,260,290,310), ntysp
  170 go to (180,190,220,260,280,300), ntysp
c
c  BRANCH WHEN COMPONENT REQUESTED
c
  180 call idcomp (1,name,idc,jkl)
      if (jkl.le.0) go to 410
      iaa = 0
      ibb = 0
      if (nty1.eq.6) then
        match = 'n'
        do 182 j = 1, nt(1)
          if (idc.eq.id(1,j)) match = 'y'  
  182   continue
        if (match.eq.'n') then
          write (lu06,5000) name
          write (lu03,5000)
          write (lu06,9105) cont1
          write (lu03,9105) 
          read  (lu05,*) 
          go to 410
        end if
      end if 
      go to 400
c
c
c  BRANCH WHEN AQUEOUS SPECIES REQUESTED
c
  190 call idspec (name,idc,nty1,ifg)
      if (ifg.eq.1) go to 410
      if (ans2.eq.'1') then
         call search (nty1,idc,luxx,1,name,eqr,hdr,jkl,ndbase)
      endif
      if (nty1.eq.6.and.exclu.eq.'n') go to 410
  200 if (jkl.le.0.and.ans2.eq.'1') then
  210    if (nty1.eq.6) then
            write (lu06,5010) 
            write (lu03,5010)
            write (lu06,9105) cont1
            write (lu03,9105)
            read (lu05,*)
            go to 410
         end if
         write (lu06,9210) cont1
         read (lu05,9040,err=210) ans
         if (ans.eq.'n') ans = 'N'
         if (ans.eq.'y') ans = 'Y'
         write (lu03,9210) cont2,ans
         if (ans.ne.'Y'.and.ans.ne.'N') go to 210
         if (ans.eq.'N') then
            go to 410
         else
            idc = idc + ndbase + 1
            jkl = 0
            go to 330
         endif
      elseif (jkl.eq.0.and.ans2.eq.'2') then
         go to 330
      endif
      do 247 j = 1, nt(nty)
         if (idc.eq.id(nty,j)) then
            write (lu06,9195) j,nty,idc
            write (lu03,9195) j,nty,idc
            write (lu06,9105) cont1
            write (lu03,9105) 
            read (lu05,*)
            go to 410
         end if
  247 continue
      if (nty1.eq.6) go to 400
      aaa = 1.0e-35
      bbb = -35.
      go to 390
c
c  BRANCH WHEN MINERAL REQUESTED
c
  220 call idmine (name,idc,idincr,nty1,ifg,ans2)
      if (ifg.eq.1) go to 410
      if (ans2.eq.'1') then
         call search (nty1,idc,luxx,1,name,eqr,hdr,jkl,ndbase)
      end if
      if (nty1.eq.6.and.exclu.eq.'n') go to 410
  230 if (jkl.le.0.and.ans2.eq.'1') then
  240    if (nty1.eq.6) then
            write (lu06,5010) 
            write (lu03,5010)
            write (lu06,9105) cont1
            write (lu03,9105)
            read (lu05,*)
            go to 410
         end if
         write (lu06,9210) cont1
         read (lu05,9040,err=240) ans
         if (ans.eq.'n') ans = 'N'
         if (ans.eq.'y') ans = 'Y'
         write (lu03,9210) cont2,ans
         if (ans.ne.'Y'.and.ans.ne.'N') go to 240
         if (ans.eq.'N') then
            go to 410
         else
            call clrscr (lu06)
            jkl = 0
            write (lu06,9240) titb,titb
            write (lu03,9240) titb,titb
            call idcomp (1,name,idx,idmy)
            if (idmy.eq.-1) then
               ifg = 1
               go to 410
            endif
            namlig = name
            idlig = idx
            idincr = idincr+1
            idc = 99*100000+idmet*100+idincr
            write (lu06,9230) idc
            write (lu03,9230) idc
            go to 330
         endif
      elseif (jkl.eq.0.and.ans2.eq.'2') then
         go to 330
      endif
      do 245 j = 1, nt(nty)
         if (idc.eq.id(nty,j)) then
            write (lu06,9195) j,nty,idc
            write (lu03,9195) j,nty,idc
            write (lu06,9105) cont1
            write (lu03,9105) 
            read (lu05,*)
            go to 410
         end if
  245 continue
      if (nty1.eq.6) go to 400
      if (nty1.eq.5) then
         call thconst (eqr,1,0)
         call thconst (hdr,2,0)
         go to 400
      endif
      ddd = 1.0
      bbb = 0.
      aaa = 0.
      if (nty1.ne.4) go to 390
  250 write (lu06,9080) cont1
      read (lu05,*,err=250) aaa
      if (aaa.lt.0.0.or.aaa.gt.1000) go to 250
      write (lu03,9080) cont2,aaa
      go to 390
c
c  BRANCH WHEN ADSORPTION REACTION REQUESTED
c
  260 call idadso (name,idc,nty1,ifg)
      if (ifg.eq.1) go to 410
      call search (nty1,idc,luxx,1,name,eqr,hdr,jkl,ndbase)
      if (jkl.lt.0) go to 410
      if (jkl.eq.0) go to 330
      if (iabq.eq.1.or.iabq.eq.3) then
         aaa = 0.0
         bbb = 0.0
      endif
      if (iabq.eq.2.or.iabq.eq.4) then
  270    write (lu06,9090) cont1
         read (lu05,9100,err=270) aaa
         if (aaa.le.0.) go to 270
         write (lu03,9090) cont2,aaa
         bbb = 0.0
      endif
      if (iabq.gt.4) then
         aaa = 1.0e-35
         bbb = -35.0
      endif
      bbb = fguess(name,0,bbb)
      go to 390
c
c  BRANCH WHEN REDOX COUPLE REQUESTED
c CHECK TO SEE IF ELECTRON IS ALREADY FIXED
c
  280 call idredx (name,idc,ifg,aaa,bbb)
      if (ifg.eq.1) go to 410
      if (idc.eq.0) then
         jkl = 0
         write (lu06,7800)
         write (lu06,9105) cont1
         write (lu03,9105) 
         read (lu05,*)
       go to 410
      endif
      call search (nty1,idc,luxx,0,name,eqr,hdr,jkl,ndbase)
  290 if (jkl.lt.0) go to 410
      if (jkl.eq.0) then
         namspe(1) = 'OXIDIZED'
         namspe(2) = 'REDUCED '
         go to 330
      endif
      do 248 j = 1, nt(nty)
         if (idc.eq.id(nty,j)) then
            write (lu06,9195) j,nty,idc
            write (lu03,9195) j,nty,idc
            write (lu06,9105) cont1
            write (lu03,9105) 
            read (lu05,*)
            go to 410
         end if
  248 continue
      if (nty1.eq.6) go to 400
      call thconst (eqr,1,0)
      call thconst (hdr,2,0)
      go to 400
c
c BRANCH WHEN GAS REQUESTED
c
  300 call idgasg (name,idc,nty1,ifg)
      jkl = 0
      if (ifg.eq.1) go to 310
      call search (nty1,idc,luxx,0,name,eqr,hdr,jkl,ndbase)
  310 if (jkl.lt.0) go to 410
      if (jkl.eq.0) then
         namspe(1) = 'REACTING'
         namspe(2) = namspe(1)
         go to 410
      endif
      do 242 j = 1, nt(nty)
         if (idc.eq.id(nty,j)) then
            write (lu06,9195) j,nty,idc
            write (lu03,9195) j,nty,idc
            write (lu06,9105) cont1
            write (lu03,9105) 
            read (lu05,*)
            go to 410
         end if
  242 continue
      if (nty1.eq.6) go to 400
c
c  GASES ARE ALWAYS FIXED
c
      if (ndegfr.lt.1) then
         write (lu06,9110) name
         write (lu03,9110)
         go to 410
      endif
  320 write (lu06,9120) cont1,name
      read (lu05,*,err=320) aaa
      if (aaa.le.0.) go to 320
      ddd = aaa
      write (lu03,9120) cont2,name,aaa
      eqr = eqr-log10(aaa)
      write (lu06,9130) eqr
      write (lu03,9130) eqr
      aaa = 0.
      bbb = 0.
      iaa = 1
      ibb = 1
      go to 390
  330 if (nty1.eq.6) then
         write (lu06,9140) tit(ntysp)
         write (lu03,9140) tit(ntysp)
         go to 410
      endif
c 
c  -- Check whether an added species with this id number has already
c     been defined.  If so, increment idc.
      do 333 i = 1, 9
        if (i.le.ndbase) then
           ntemp(i) = 1
        else
           ntemp(i) = 0
        end if
        idigit(i) = 0
 333  continue
      ii = 0
      do 335 i = 1, nt(7)
        id1 = idc/10
        id2 = id(7,i)/10
        if (id1.eq.id2) then
          ii = ii + 1
          idigit(ii) = id(7,i) - id2*10 + 1 
          ntemp(idigit(ii)) = 1
        end if     
  335 continue
      if (ii.ne.0) then
      do 336 i  = 1, 9
        if (idigit(i).ne.0) then
          if (ntemp(idigit(i)).eq.0) then
            idc = id1*10 + idigit(i-1)  
            go to 337
          end if
        end if
  336 continue
      end if
c              
  337 write (lu06,9150) cont1,idc,tit(ntysp)
      read (lu05,9040,err=330) ans
      if (ans.eq.'n') ans = 'N'
      if (ans.eq.'y') ans = 'Y'
      write (lu03,9150) cont2,idc,tit(ntysp),ans
      if (ans.ne.'Y'.and.ans.ne.'N') go to 330
      if (ans.eq.'N') then
  340    write (lu06,9160) cont1
         read (lu05,*,err=340) idi
         write (lu03,9160) cont2,idi
         if (idi.lt.0.or.idi.gt.9) go to 340
         if (idi.gt.0) then
            idc = idc/10
            idc = idc*10+idi
            go to 330
         else
            go to 410
         endif
      endif
  350 if (ntysp.le.4) go to 370
c
c DEFINE SPECIES FOR UNDEFINED REACTION
c
      if (jkl.eq.0) then
         write (lu06,9170) namspe(1)
         write (lu03,9170) namspe(1)
         call idcomp (1,namlig,idlig,jlr)
         if (jlr.eq.0) go to 360
         write (lu06,9170) namspe(2)
         write (lu03,9170) namspe(2)
         call idcomp (1,nammet,idmet,jlr)
         idc = 10000*idmet+10*idlig+5
         if (jlr.ne.0) go to 370
      endif
  360 write (lu06,9180)
      write (lu03,9180)
      go to 410
  370 call addspe (nty1,name,idc,eqr,hdr)
      if (nty1.eq.4) then
  380    write (lu06,9080) cont1
         read (lu05,*,err=380) aaa
         if (aaa.le.0.0.or.aaa.gt.1000) go to 380
         write (lu03,9080) cont2,aaa
         go to 400
      else
         go to 410
      endif
  390 call thconst (eqr,1,0)
      if (ntysp.ne.6) then
        call thconst (hdr,2,0)
      end if
  400 call speadd (nty1,idc,name,eqr,hdr,aaa,ddd,iaa,ibb,ifg,1)
  410 return
c
 9000 format (/,a1,'  Is the id # known for ',a20,'? (Y,N,[D]=N) > ',
     *        1x,a1)
 9010 format (/,'  Choose an option: ',
     *   //,'    1 = Search the thermodynamic database for the',
     *      ' species you want.',
     *    /,'        If it is in the database, display its log K',
     *      ' and enthalpy values for',
     *    /,'        you to change if desired.  If not in the',
     *      ' database, assist you in',
     *    /,'        defining and adding the species.',
     *   //,'    2 = Assist you in defining and adding a species',
     *      ' that you already know',
     *    /,'        is not in the thermodynamic database.',
     *   //,'    R = Return to the previous question.',
     *//,a1,'         ENTER CHOICE  ([D] = R) > ',1x,a1)
 9020 format (/,'  The ',a20,' with id number ',i7,' was not found in',/
     *   ,' the thermodynamic database.')
 9030 format (/,a1,'  Do you want to change the id # and search',
     *   ' again ?  (Y,N) > ',1x,a1)
 9040 format (a1)
 9050 format (/,a1,'  Enter the id number for ',a20,' > ',1x,i8)
 9060 format ('  The id must be between ',i5,' and ',i7)
 9080 format (/,a1,'  Enter the amount of solid in moles/l > ',e12.5)
 9090 format (/,a1,'  Enter the concentration of the adsorbing',
     *   ' sites in moles/kg > ',e12.5)
 9100 format (e15.5)
 9105 format (a1,'  Press ENTER to continue')
 9110 format ('  There are no more degrees of freedom left. ',a20,
     *   ' can not be fixed.')
 9120 format (/,a1,'  Enter the non-zero partial pressure (atm) of ',a20
     *   ,' > ',e12.5)
 9130 format ('  Corrected log K is ',f12.3)
 9140 format ('  No ',a20,' made up of the designated components is',
     *   ' found in the database.')
 9150 format (/,a1,'  Is id =',i10,' acceptable for a new ',a20,
     *   '? (Y,N) > ',1x,a1)
 9160 format (/,'  You may change the last digit in the id #.  Enter',
     *   ' zero to abort definition of',/,a1,
     *   '  new species.  Enter last digit in id #  >',1x,i1)
 9170 format ('  Define ',a8,' aqueous species.')
 9180 format ('  Add all required aqueous components to the data file',
     *   ' before defining reaction.')
 9190 format (/,a1,' Do you want to enter this species ?',' (Y,N) > ',
     *   1x,a1)
 9191 format (/,a1,' Do you want to exclude this species ?',' (Y,N) > ',
     *   1x,a1)
 9195 format (' Line # ',i3,' of TYPE ',i1,' already contains id # ',i7)
 9200 format (/,'  Do you want to conduct a more general search of',
     *   ' the database by specifying',/,a1,
     *   '  the major constituents of the species ? (Y,N)',' > ',1x,a1)
 9210 format (/,'  Do you want to define a new species comprised',
     *   ' at least partly of those',/,a1,
     *   '  constituents you have already specified ? (Y,N)',' > ',1x,a1
     *   )
 9220 format (/,'  Do you want to see a menu displaying currently',
     *   ' available species of this',/,a1,
     *   '  type from the database ? (Y,N) > ',1x,a1)
 9230 format (/,'  The new id number assigned to this species',' is ',i7
     *   ,'.  It begins with 99',/,
     *   '  to identify it as an added solid species.')
 9240 format (/,'              ****** Specify the major ',a6,' or ',a6,
     *   ' donor ******')
 7800 format (//,' NO COMPONENTS THAT CAN TAKE PART IN REDOX REACTIONS',
     *           ' HAVE YET BEEN DEFINED.')
 5000 format (/,' *** The component ',a8,' is not included in',
     *          ' this problem so',
     *        /,'     need not be formally excluded.')
 5010 format (/,' *** Since the species you have described is not in',
     *          ' the thermodynamic database',
     *        /,'     there is no need to formally exclude it.  If',
     *          ' you have specified it earlier',
     *        /,'     as an ADDED species in this input file,', 
     *          ' simply delete it in EDIT LEVEL III.')
      end
