      subroutine idadso (name,idc,nty,ifg)
c
c********************************************************************
c FUNCTION:
c     DEFINES THE ID FOR A NON-COMPONENT ADSORBED SPECIES
c INPUT:
c     NONE
c OUTPUT:
c     NAME=NAME OF ADSORBED SPECIES
c     IDC=CORRESPONDING ID
c     IFG=(0 IF ID IDENTIFIED);(1 IF NOT IDENTIFIED)
c********************************************************************
c CORRECTION HISTORY:
c   DATE                     CORRECTION                      REFERENC
c
c********************************************************************
c
      include 'PRODEFA2.INC'
c
      character name*20,match*1
c
c********************************************************************
c
c
      write (lu06,9000) reafor(1,iabq)
      write (lu03,9000) reafor(1,iabq)
      ifg = 0
c
c --  Obtain id number of principal component in this reaction.
c
      call idcomp (4,name,idc,j)
      if (j.eq.-1) then
         ifg = 1
         go to 120
      endif
      if (j.eq.0) then
         ifg = 0
         go to 120
      endif
c
c --  Use principal component id prefixed with adsorption component id
c     to create adsorption reaction id.
c
      idmet = idc
      nammet = name
      ida = iadcmp
      idc = 10000*ida+10*idc
c
c --  Check to ensure that this id number is unique.
c
  100 match = 'n'
      do 110 i = 1, nt(7)
         if (idc.eq.id(nty,i)) match = 'y'
         if (idc.eq.id(7,i)) match = 'y'
  110 continue
c
c --  If it isn't unique, increment by one and check again.
c
      if (match.eq.'y') then
         idc = idc+1
         go to 100
      endif
      name = reafor(1,iabq)
  120 return
c
c
 9000 format ('      >>>>>>> SPECIFY the MAJOR AQUEOUS REACTANT in ',
     *         a16,' >>>>>>>')
c
      end
c
      subroutine idcomp (m,nam,idx,idj)
c
c********************************************************************
c
c FUNCTION:
c     SELECTS A COMPONENT ID NUMBER BY SEARCHING FILE ON FIRST LETTER
c INPUT:
c     M=COMPONENT CLASSIFICATION;1=AQUEOUS COMPONENT,2=CATION,
c       4=REACTION COMPONENT
c OUTPUT:
c     NAM=NAME OF COMPONENT
c     IDX= ID OF COMPONENT
c     IDJ=FLAG (-1=TERMINATE SEARCH IN EXTERNAL LOOP, 0=NO ID FOUND
c********************************************************************
c CORRECTION HISTORY:
c   DATE                     CORRECTION                      REFERENC
c
c********************************************************************
c
      include 'PRODEFA2.INC'
c
      character nam*20,blet*1,clet*1
      character name*20,namdum*12,locase*1,upcase*1
      integer jo(20),iddum(200)
      dimension name(20),blet(3981),namdum(200)
      dimension locase(26),upcase(26)
      equivalence (na0(1),blet(1))
c
c********************************************************************
c
      data locase / 'a','b','c','d','e','f','g','h','i','j','k','l','m',
     *   'n','o','p','q','r','s','t','u','v','w','x','y','z'/
c
      data upcase / 'A','B','C','D','E','F','G','H','I','J','K','L','M',
     *   'N','O','P','Q','R','S','T','U','V','W','X','Y','Z'/
c
  100 if (agus.eq.'N'.or.agus.eq.'n') go to 140
  110 write (lu06,9000) cont1
      read (lu05,9010,err=110) idx
      if (idx.gt.999) then
         go to 110
      elseif (idx.ge.811.and.idx.le.859) then
         write (lu06,9110) idx
         idj = 0
         go to 250
      endif
      write (lu03,9000) cont2,idx
      if (idx.eq.0) then
         idj = -1
         go to 250
      elseif (idx.lt.0) then
         agus = 'N'        
         go to 140
      endif
      do 120 i = 1, nt0
         if (idx.eq.id0(i)) go to 130
  120 continue
      write (lu06,9020) cont1,idx
      write (lu03,9020) cont2,idx
      go to 140
  130 nam = na0(i)
      idj = i
      go to 250
  140 write (lu06,9030) cont1
      read (lu05,9040,err=140) clet
      write (lu03,9030) cont2,clet
      if (clet.eq.'-') then
         agus = 'Y'
         go to 110
      else if (clet.eq.' ') then
        idj = -1
        go to 250
      end if
      do 160 ialpha = 1, 26
         if (clet.eq.locase(ialpha)) clet = upcase(ialpha)
  160 continue
      idj = 0
      idx = 0
      nam = 'UNDEFINED'
      k = 0
      do 170 i = 1, nt0
         jj = 20*(i-1)+1
         if (blet(jj).ne.clet) go to 170
         if (id0(i).ge.811.and.id0(i).le.859) go to 170
         if (m.eq.2.and.ch0(i).lt.0.0) go to 170
         k = k+1
         jo(k) = i
         name(k) = na0(i)
  170 continue
      if (k.gt.0) go to 220
  180 write (lu06,9050) clet,cont1
      read (lu05,9040,err=180) ans
      if (ans.eq.'n') ans = 'N'
      if (ans.eq.'y') ans = 'Y'
      if (ans.ne.'Y'.and.ans.ne.'y'.and.ans.ne.'N'.and.ans.ne.'n') then
         go to 180
      endif
      write (lu03,9050) clet,cont2,ans
      if (ans.eq.'N'.or.ans.eq.'n') go to 140
c
c  -- Create the subset of user selectable components from the full
c     component set.
c
      ii = 0
      do 190 i = 1, nt0
         if (id0(i).ge.811.and.id0(i).le.859) go to 190
         ii = ii+1
         iddum(ii) = id0(i)
         namdum(ii) = na0(i)
  190 continue	      
      ntdum = ii
c
c  -- Print the subset of user selectable components
c
      jp = 1
      jpage = 72
      jstart = 1
      jstop = 0
      call clrscr (lu06)
      write (lu06,9060)
      write (lu03,9060)
  200 jstop = jstop+4
      if (jstop.gt.ntdum) jstop = ntdum
      write (lu06,9070) (iddum(j),namdum(j),j=jstart,jstop)
      write (lu03,9070) (iddum(j),namdum(j),j=jstart,jstop)
      jstart = jstart+4
      if (jstop.lt.ntdum.and.jstop.lt.jpage) go to 200
      if (jstop.lt.ntdum.and.jstop.eq.jpage) then
  210    write (lu06,9080) cont1
         read (lu05,9040,err=210) ans
         if (ans.eq.'n') ans = 'N'
         if (ans.eq.'y') ans = 'Y'
         if (ans.ne.'Y'.and.ans.ne.'y'.and.ans.ne.'N'.and.ans.ne.'n')
     *       then
            go to 210
         endif
         write (lu03,9080) cont2,ans
         if (ans.eq.'Y'.or.ans.eq.'y') then
            jp = jp+1
            jpage = jp*jpage
            call clrscr (lu06)
            write (lu06,9060)
            write (lu03,9060)
            go to 200
         endif
      endif
      if (agus.eq.'N'.or.agus.eq.'n') then
         go to 140
      else
         go to 110
      endif
  220 write (lu06,9090) (l,name(l),l=1,k)
      write (lu03,9090) (l,name(l),l=1,k)
  230 write (lu06,9100) cont1
      read (lu05,*,err=230) i
      if (i.lt.0.or.i.gt.k) go to 230
      write (lu03,9100) cont2,i
      if (i.ne.0) go to 240
      idj = 0
      go to 100
  240 idj = jo(i)
      idx = id0(idj)
      nam = na0(idj)
  250 return
c
 9000 format (/,' - Enter the ID NUMBER of the COMPONENT:',
     * /,'     To identify the component you want, enter its',
     *   ' 3-digit id number,',        
     * /,'  OR enter a minus one (-1) to switch to component',
     *   ' entry by specifying the',
     * /,'     first letter in the component name,',
     * /,'  OR enter a zero (0) to terminate component entry.',
     * /,a1,'                         ENTER your choice > ',1x,i4)
 9010 format (i4)
 9020 format (/,a1,' Id # ',i3,' is not in the component database',
     *   ' file.  Proceed to specify',/,
     *   ' the desired component by name.')
 9030 format (/,' - Enter the FIRST LETTER for the COMPONENT:',
     * /,'     To identify the component you want, enter the',
     *   ' first letter in its',
     * /,'     chemical symbol (inorganic) or name (organic),',
     * /,'  OR enter a minus one (-1) to switch to component entry',
     *   ' by id number,',
     * /,'  OR press ENTER to terminate component entry.',
     * /,a1,'                         ENTER your choice > ',1x,a1)
 9040 format (a1)
 9050 format (/,'  There is no component name beginning with the',
     *   ' letter "',a1,'" in the database.',/,a1,
     *   ' Do you want to see a list of component names? ','(Y,N) > ',1x
     *   ,a1)
 9060 format (' ',4('Id #',3x,'Name',8x))
 9070 format (' ',4(i3,1x,a12,3x))
 9080 format (a1,'  There are more.  Do you want to see them? (Y,N)',
     *   ' >',1x,a1)
 9090 format (6(5('  ',i3,1x,a8,2x)/))
 9100 format (/,a1,' Select the number of the appropriate component',
     *   ' (0 = NONE) > ',1x,i3)
 9110 format (/,1x,'Component ID number ',i3,' is an adsorption',
     *   ' component.  All adsorption components',/,
     *   '  are added automatically as required in accordance',
     *   ' with the adsorption',/,
     *   '  model you choose and should not be entered here.')
c
      end
c
      subroutine idgasg (name,idc,nty,ifg)
c
c********************************************************************
c
c FUNCTION:
c     FIND THE NAME AND I. D. OF THE WANTED GAS
c INPUT:
c     NONE
c OUTPUT:
c     NAME= NAME OF GAS
c     IDC= I. D. OF GAS
c     IFG=(1 NO ID DEFINED); (0=ID DEFINED)
c
c********************************************************************
c CORRECTION HISTORY:
c   DATE                     CORRECTION                      REFERENC
c
c********************************************************************
c
c
      include 'PRODEFA2.INC'
c
      character name*20
c
      character*12 gasn(50)
      dimension idgas(50)
      data ifirst / 0 /
c
c********************************************************************
c
c      call clrscr (lu06)
      if (ifirst.eq.1) go to 120
c
c READ IN ID AND NAME OF GASES IN GASOUS.DAT
c
      ifirst = 1
      do 100 i = 1, 50
         read (lu09,9000,end=110) idgas(i),gasn(i)
         if (idgas(i).eq.0) go to 110
         read (lu09,*,end=110)
         ngas = i
  100 continue
  110 rewind lu09
  120 ifg = 0
      write (lu06,9005)
      write (lu06,9010) (i,gasn(i),i=1,ngas)
      write (lu03,9010) (i,gasn(i),i=1,ngas)
  130 write (lu06,9020) cont1
      read (lu05,*,err=130) i
      if (i.lt.0.or.i.gt.ngas) go to 130
      write (lu03,9020) cont2,i
      if (i.eq.0) then
         ifg = 1
         go to 160
      endif
      name = gasn(i)
      idc = idgas(i)
      do 140 i = 1, nt(nty)
         if (idc.eq.id(i,nty)) go to 150
  140 continue
      go to 160
  150 ifg = 1
      write (lu06,9030) i,nty,idc
      write (lu03,9030) i,nty,idc
  160 return
c
c
 9000 format (i7,1x,a12)
 9005 format (/,1x,t18,'----  CHOOSE FROM THE FOLLOWING GASES:  ----',/)
 9010 format (4(' ',i2,'-',a12,2x))
 9020 format (/,'  Enter the number corresponding the gas you want.',
     *   ' Enter zero to abort the',/,'  selection of a gas.',/,a1,
     *   '  ENTER CHOICE  > ',1x,i2)
 9030 format (/,'  Entry # ',i3,' of TYPE ',i1,' already contains',
     *   ' ID # ',i7)
c
      end
c
      subroutine idmine (name,idc,idincr,nty,ifg,displ)
c
c********************************************************************
c
c FUNCTION:
c     DEFINES THE ID AND NAME OF A MINERAL
c INPUT:
c     NTY=TYPE OF SPECIES (3-6)
c OUTPUT:
c     NAME=DEFINED NAME
c     IDC=CORRESPONDING I. D.
c     IFG=1 IF MINERAL ALREADY IN FILE
c     displ = Flag indicating whether to display the list of
c            mineral group names from which the user is to pick
c            to define one of the major components or not.
c            Flag indicating that rather than display the list
c            of mineral groups from which the user is expected to
c            choose a two digit group identifier, this routine is
c            to use a group identifier of 99 and is to query both
c            for the major cation and major anion.
c********************************************************************
c CORRECTION HISTORY:
c   DATE                     CORRECTION                      REFERENC
c
c********************************************************************
c
c
      include 'PRODEFA2.INC'
c
c
c
      character*1 displ, match
      character*20 aminer,name
      dimension aminer(23),mingp(23)
      data aminer / 'Elemental','Sulfide','Cyanide','Selenide',
     *  'Antimonide','Oxide or Hydroxide','Multiple Oxide',
     *  'Bromide','Chloride','Fluoride','Iodide','Carbonate',
     *  'Nitrate','Borate','Sulfate','Selenate or Selenite',
     *  'Phosphate','Arsenate','Vanadate','Orthosilicate',
     *  'Chain Silicate','Framework Silicate','Sheet Silicate'/
      data mingp / 01,10,11,12,14,20,30,40,41,42,43,50,51,52,60,61,
     *             70,72,73,80,82,84,86 /
      nmin = 23
c
c
c********************************************************************
c
      ifg = 0
      if (displ.eq.'2') then
         i = 99
         go to 140
      endif
      call clrscr (lu06)
  100 do 110 i = 1, nmin, 3
         ls = i
         le = i+2
         le = min0(le,nmin)
         write (lu06,9000) (mingp(ll),aminer(ll),ll=ls,le)
         write (lu03,9000) (mingp(ll),aminer(ll),ll=ls,le)
  110 continue
  120 write (lu06,9010) cont1
      read (lu05,*,err=120) i
      if (i.lt.0.or.i.gt.99) go to 120
      write (lu03,9010) cont2,i
      if (i.eq.0) then
         ifg = 1
         go to 170
      endif
      do 130 j = 1, nmin
         if (i.eq.mingp(j)) go to 140
  130 continue
      go to 100
  140 call clrscr (lu06)
      write (lu06,9020) 
      write (lu03,9020)
      if (i.eq.1) i = 0
      idc = i*100000
      call idcomp (2,name,idx,idmy)
      if (nty.eq.6) then
        match = 'n'
        do 182 j = 1, nt(1)
          if (idx.eq.id(1,j)) match = 'y'  
  182   continue
        if (match.eq.'n') then
          write (lu06,5000) name
          write (lu03,5000)
          write (lu06,9105) cont1
          write (lu03,9105) 
          read  (lu05,*) 
          ifg = 1
          go to 170
        end if
      end if 
      if (idmy.eq.-1) then
         ifg = 1
         go to 170
      endif
      nammet = name
      idmet = idx
      idc = idc+idx*100
      if (displ.eq.'2') then
         call clrscr (lu06)
         write (lu06,9021) 
         write (lu03,9021) 
         call idcomp (1,name,idx,idmy)
         if (nty.eq.6) then
           match = 'n'
           do 184 j = 1, nt(1)
             if (idx.eq.id(1,j)) match = 'y'  
  184      continue
           if (match.eq.'n') then
             write (lu06,5000) name
             write (lu03,5000)
             write (lu06,9105) cont1
             write (lu03,9105) 
             read  (lu05,*) 
             ifg = 1
             go to 170
           end if
         end if 
         if (idmy.eq.-1) then
            ifg = 1
            go to 170
         endif
         namlig = name
         idlig = idx
         idincr = idincr+1
         idc = 99*100000+idmet*100+idincr
         write (lu06,9040) idc
         write (lu03,9040) idc
      endif
      go to 170
  170 return
c
c
 9000 format (' ',3(i2,1x,a20,1x))
 9010 format (/,'  Enter the number corresponding to the class',
     *   ' to which this mineral belongs.',/,a1,
     *   ' ENTER CHOICE  (0 = none) > ',1x,i2)
 9020 format (/'        >>>>>>>>>  SPECIFY MAJOR CATION  <<<<<<<<<')
 9021 format (/'        >>>>>>>>>  SPECIFY MAJOR ANION   <<<<<<<<<')
 9040 format (/,'  The new id number assigned to this species',' is ',i7
     *   ,'.  It begins with 99',/,
     *   '  to identify it as an added solid species.')
c
 9105 format (a1,'  Press ENTER to continue')
 5000 format (/,' *** The component ',a8,' is not included in',
     *          ' this problem so',
     *        /,'     this species is excluded by default.')
      end
c
      subroutine idredx (name,idc,ifg,aaa,bbb)
c
c********************************************************************
c FUNCTION:
c     FIND THE NAME AND I. D. OF THE WANTED REDOX COUPLE
c INPUT:
c     NONE
c OUTPUT:
c     NAME= NAME OF REDOX COUPLE
c     IDC= I. D. OF REDOX COUPLE
c     IFG=(0,INDEX DEFINED); (1,INDEX NOT DEFINED)
c     AAA=CONCENTRATION OF REDOX PRODUCT COMPONENT
c     BBB=LOG10(ACTIVITY OF REDOX PRODUCT COMPONENT
c********************************************************************
c CORRECTION HISTORY:
c   DATE                     CORRECTION                      REFERENC
c
c********************************************************************
c
      include 'PRODEFA2.INC'
c
      character*20 name,nam1,nam2
      character*12 nardx(50),nardy(50)
      dimension idrdx(50),idrdy(50)
c
c********************************************************************
c
c READ IN ID AND NAME OF REDOX COUPLES IN COUPLE.DAT
c
      nam1 = '                    '
      nam2 = '                    '
      do 100 i = 1, 50
         read (lu08,9000,end=110) idrdx(i),nardx(i)
         if (idrdx(i).eq.0) go to 110
         read (lu08,*,end=110)
         nrdx = i
  100 continue
  110 rewind lu08
      ifg = 0
      idc = 0
      name = ' '
c
c SELECT COUPLES OF INTEREST FROM COMPONENTS ALREADY DEFINED
c     AND COUPLES NOT PREVIOUSLY INCLUDED
c
      nrcm = 0
      do 140 i = 1, nrdx
c
c DISCARD ANY PREVIOUSLY DEFINED COUPLES FROM LIST
c
         if (nt(3).gt.0) then
            do 120 j = 1, nt(3)
               if (idrdx(i).eq.id(3,j)) go to 140
  120       continue
c
         endif
c
c SELECT ONLY COUPLES FOR WHICH AT LEAST ONE OF THE COMPONENTS HAS
c     BEEN DEFINED
c         idx1 = idrdx(i)/10000
c         idx2 = (idrdx(i)-10000*idx1)/10
c         if (nt(1).gt.0) then
c            do 130 j = 1, nt(1)
c               if (idx1.eq.id(1,j).or.idx2.eq.id(1,j)) then
                  nrcm = nrcm+1
                  nardy(nrcm) = nardx(i)
                  idrdy(nrcm) = idrdx(i)
c                  go to 140
c               endif
c  130       continue
c         endif
  140 continue
      if (nrcm.eq.0) then
         ifg = 1
         go to 180
      endif
      write (lu06,9005) 
      write (lu06,9010) (i,nardy(i),i=1,nrcm)
      write (lu03,9010) (i,nardy(i),i=1,nrcm)
  150 write (lu06,9020) cont1
      read (lu05,*,err=150) i
      write (lu03,9020) cont2,i
      if (i.lt.0.or.i.gt.nrcm.and.i.ne.99) go to 150
      if (i.eq.0) then
         ifg = 1
         go to 180
      endif
      name = nardy(i)
      idc = idrdy(i)
      idx1 = idrdy(i)/10000
      idx2 = (idrdy(i)-10000*idx1)/10
      do 160 i = 1, nt0
         if (idx1.eq.id0(i)) nam1 = na0(i)
         if (idx2.eq.id0(i)) nam2 = na0(i)
  160 continue
      call cominc (nty,idx1,nam1,'N',0)
      call cominc (nty,idx2,nam2,'N',0)
      do 170 i = 1, nt(1)
         if (idx2.eq.id(1,i)) then
            aaa = teq(1,i)
            bbb = thr(1,i)
         endif
  170 continue
  180 return
c
c
 9000 format (i7,1x,a12)
 9005 format (/,1x,t15,'----  CHOOSE FROM THE FOLLOWING REDOX',
     *                  ' COUPLES:  ----',/)
 9010 format (4(' ',i3,'-',a12,1x))
 9020 format (/,'  Enter the index corresponding to the couple you',
     *          ' want.  Enter zero to abort',
     *        /,'  the selection of a redox couple.',
     *     /,a1,'     ENTER CHOICE  > ',1x,i2)
c
      end
c
      subroutine idspec (name,idc,nty,ifg)
c
c********************************************************************
c FUNCTION:
c     DEFINES THE ID FOR A AQUEOUS OR ADSORBED SPECIES
c INPUT:
c     NONE
c OUTPUT:
c     NAME=NAME OF SPECIES
c     IDC=CORRESPONDING ID
c     IFG=(0 INDEX DEFINED); (1,INDEX NOT DEFINED)
c
c********************************************************************
c CORRECTION HISTORY:
c   DATE                     CORRECTION                      REFERENC
c
c********************************************************************
c
c
      include 'PRODEFA2.INC'
c
c
      character name*20, match*1
c
c********************************************************************
c
      ifg = 0
      call clrscr (lu06) 
      write (lu06,9000) 
      write (lu03,9000) 
      call idcomp (2,name,idc,j)
      if (nty.eq.6) then
        match = 'n'
        do 182 j = 1, nt(1)
          if (idc.eq.id(1,j)) match = 'y'  
  182   continue
        if (match.eq.'n') then
          write (lu06,5000) name
          write (lu03,5000)
          write (lu06,9105) cont1
          write (lu03,9105) 
          read  (lu05,*) 
          ifg = 1
          go to 999
        end if
      end if 
      if (j.le.0) then
        ifg = 1
        go to 999
      end if
      idmet = idc
      nammet = name
      idc = 10000*idmet
c
 10   call clrscr (lu06) 
      write (lu06,9001) 
      write (lu03,9001) 
c  -- Make user aware of valid id numbers an first letter in names
c     of composit components
      if (cmplig.eq.'y') write (lu06,9005)
c
      call idcomp (3,name,idx,j)
      if (nty.eq.6) then
        match = 'n'
        do 183 j = 1, nt(1)
          if (idx.eq.id(1,j)) match = 'y'  
  183   continue
        if (match.eq.'n') then
          write (lu06,5000) name
          write (lu03,5000)
          write (lu06,9105) cont1
          write (lu03,9105) 
          read  (lu05,*) 
          ifg = 1
          go to 999
        end if
      end if 
      if (j.le.0) then
        ifg = 1
        go to 999
      end if
      idlig = idx
c  -- Reject invalid components selected to represent the composite 
c     ligand.
      if (cmplig.eq.'y'.and.(idlig.lt.145.or.idlig.gt.149)) then
         write (lu06,9007)
         go to 10
      end if
      namlig = name
      idc = 10*idlig+idc
c
c  -- If this is a composite ligand species, reverse usual practice
c     of constructing the 7-digit id with 3-digit cation id leftmost;
c     use the ligand id in leftmost positions.      
      if (cmplig.eq.'y') idc = 10000*idlig + 10 *idmet
      do 100 i = 1, nt(nty)
         if (idc.eq.id(i,nty)) go to 110
  100 continue
      go to 999
  110 ifg = 1
      write (lu06,9010) i,nty,idc
      write (lu03,9010) i,nty,idc
  999 return
c
c
 9000 format (//' __________________________________________________',
     *          '___________________________',
     *         /' -------------------------->>  SPECIFY MAJOR CATION',
     *          '  <<-----------------------')
 9001 format (//' __________________________________________________',
     *          '___________________________',
     *         /' ------------------------>>  SPECIFY OTHER MAJOR IO',
     *          'N  <<----------------------')
 9005 format (/'   >> Valid component names and numbers of ',
     *         ' composite ligands <<,',
     *       /,'  Natural Organic Matter:  DOM  ,  ID # 145',
     *       /,'      -- Generic  --    :  CLIG2,  ID # 146')
 9007 format (/' This is NOT A VALID COMPONENT for a',
     *         ' composite ligand.')
 9010 format (/' Line # ',i3,' of TYPE ',i1,' already contains id # ',i7
     *   )
 9105 format (a1,'  Press ENTER to continue')
 5000 format (/,' *** The component ',a8,' is not included in',
     *          ' this problem so',
     *        /,'     this species is excluded by default.')
c
      end
c
      subroutine namesp (title,name)
c
c********************************************************************
c FUNCTION:
c       DEFINE A NAME FOR A SPECIES
c INPUT:
c       TITLE=DESCRIPTION OF SPECIES
c OUTPUT:
c       NAME=NAME OF SPECIES
c********************************************************************
c CORRECTION HISTORY:
c   DATE                     CORRECTION                      REFERENC
c
c********************************************************************
c
c
      include 'PRODEFA2.INC'
c
      character title*18,name*20
c
c********************************************************************
c
  100 write (lu06,9000) cont1,title
      read (lu05,9010,err=100) name
      write (lu03,9000) cont2,title,name
      return
c
c
 9000 format (/,a1,' Enter Name For ',a18,'. > ',a20)
 9010 format (a20)
c
      end
c
      subroutine reafil (idc,ifg)
c
c********************************************************************
c FUNCTION:
c      COMPLETE REACTION FILE WITH REACTION PRO0DUCT IF INDICATED (IF
c      SET IBLIND=1 IF PRODUCT IS IN THE REACTION SPECIFICATION (IFG=
c      DETERMINE THE NUMBER OF DEGREES OF FREEDOM IN THE REACTION
c INPUT:
c      IDC=I. D. OF REACTION PRODUCT (EXCEPT REDOX)
c      IFG=0 UPDATE PRODUCT IN REACTION AND CALCULATE DEGREES OF FREE
c      IFG=1 UPDATE DEGREES OF FREEDOM ONLY
c OUTPUT:
c      UPDATED REACTION FILE (IFG=0)
c      NDEGFR=NUMBER OF DEGREES OF FREEDOM
c      IBLIND=1 IF PRODUCT IS INCLUDED IN REACTION ARRAY
c      IBLIND=0 IF PRODUCT IS BLIND
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
c SUBROUTINE REAFIL  --  MODIFICATION AND CORRECTION HISTORY:
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
c   DATE                    MODIFICATION OR CORRECTION
c 07-30-87     ADDED NAMED COMMON BLOCK /LUNI/ SO THAT WRITE STATEMEN
c              REFERRING TO UNIT LU03, ETC. WOULD KNOW WHICH UNIT
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
c
      include 'PRODEFA2.INC'
c
      include 'CONST.INC'
c
      character namm*20
      character*1 nans(6)
      data nans / 'N','N','Y','N','Y','Y'/
c
c********************************************************************
c
      if (ifg.eq.1) go to 110
c
c INCLUDE DERIVED COMPONENT AS LAST REACTION SPECIES
c
      if (ntysp.eq.5) then
         if (ncmpr.le.0) go to 140
         iblind = 0
         id1 = idc/10000
         id2 = (idc-id1*10000)/10
c
c CHOOSE COMPONENT OF COUPLE WITH NEGATIVE COEFFICIENT AS DERIVED SPE
c
         in1 = 0
         do 100 i = 1, ncmpr
            if (idr(i).eq.id1.and.coer(i).lt.0.) in1 = i
            if (idr(i).eq.id2.and.coer(i).lt.0.) in1 = i
  100    continue
         if (in1.eq.0) then
            write (lu03,9000) idc,id1,id2
            write (lu06,9000) idc,id1,id2
            go to 140
         endif
         if (in1.eq.ncmpr) go to 110
         item = idr(in1)
         coem = coer(in1)
         namm = namer(in1)
         idr(in1) = idr(ncmpr)
         namer(in1) = namer(ncmpr)
         coer(in1) = coer(ncmpr)
         idr(ncmpr) = item
         coer(ncmpr) = coem
         namer(ncmpr) = namm
         go to 110
      endif
      ncmpr = ncmpr+1
      iblind = 1
      idr(ncmpr) = idc
      ifixer(ncmpr) = nans(ntysp)
      namer(ncmpr) = namds
      coer(ncmpr) = -1.
c
c UPDATE DEGREES OF FREEDOM
c
  110 ndegfr = ncmpr
      if (ifixer(ncmpr).eq.'Y') ndegfr = ndegfr-1
      do 130 i = 1, ncmpr-1
         ifixer(i) = 'N'
         do 120 j = 1, nt(1)
            if (id(1,j).eq.idr(i).and.abs(teq(1,j)).lt.R0MIN) then
               ndegfr = ndegfr-1
               ifixer(i) = 'Y'
            endif
  120    continue
  130 continue
  140 return
c
c
 9000 format (1x,///,' $$$$ WARNING $$$$    $$$$ WARNING $$$$ ',/,
     *   ' REDOX REACTION ',i7,' (COMPONENTS ',i3,' & ',i3,
     *   ') IS WRONG.  ARE YOU SURE THIS IS A',/
     *   ' REDOX REACTION ?  REDOX REACTIONS ARE READ FROM THE',
     *   '  FILE "COUOLD.DBS". ')
c
      end
c
      subroutine search (nty,idc,lu,ifg,name,eqx,hdx,jkl,ndbase)
c
c********************************************************************
c FUNCTION:
c    SEARCHES THERMO.DAT ON IDC FOR MATCHES
c INPUT:
c    NTY= TYPE OF SPECIES OR REACTION BEING SEARCHED
c    IDC=I. D. TO SEARCH
c    IFG=TYPE OF MATCH (IFG=0, EXACT MATCH),(IFG=1, NEAR MATCH)
c    LU= LOGICAL UNIT NUMBER TO READ
c OUTPUT:
c    EQX=LOG10(EQUILIBRIUM CONSTANT FOR MATCHED OR ACCEPTED SPECIES)
c    HDX=ENTHALPY OF REACTION
c    JKL=0, NO MATCH FOUND IN DATA BASE, POS= ACCEPTABLE MATCHES FOUN
c         -1= NO ACCEPTABLE MATCH FOUND
c    NDBASE = THE TOTAL NUMBER OF MATCHING ENTRIES FOUND IN THE DATA
c             BASE  
c********************************************************************
c CORRECTION HISTORY:
c   DATE                     CORRECTION                      REFERENC
c
c********************************************************************
c
      include 'PRODEFA2.INC'
c
      character savn*20,name*20,nsav*20,namds2*12
      real*4    eqx, hdx, coef, saveq, savhr 
      real*8    rtemp, rtemp2, rtemp3, rtemp4, rtemp5, rtemp6, rtemp7,
     *          rtemp8, rtemp9, rtemp10 
      integer*4 isav, ncsav, idsav
      dimension savn(20),isav(20),ncsav(20),nsav(9,20),coef(9,20),
     *          saveq(20),savhr(20),idsav(9,20), rtemp10(13)
c
c     NMADS = Species name
c      IDDS = Species id number
c       EQR = Log K for formation of species from components
c    IDR(I) = Id number of the ith component in the reaction
c   COER(I) = Stoichiometry of the ith component in the reaction
c     NCMPR = The number of components in the reaction
c    IFIXER = Y/N flag as to whether the species should be fixed
c     NAMER = Component name
c********************************************************************
c
c
      luxx = lu
      if (ntysp.eq.3) then
         luxx = lu19
      endif
      rewind luxx
      jkl = 0
      eqx = 0.0
      hdx = 0.0
      if (ntysp.eq.4) go to 220
      icon = 10*ifg
      write (lu06,9000) luxx
      write (lu03,9000) luxx
c
  100 if (luxx.eq.lu07.or.luxx.eq.lu19) then
       read(luxx,end=140) idds,namds2,rtemp8,rtemp9,rtemp,rtemp2,rtemp3,
     * rtemp4,rtemp5,rtemp6,rtemp7,ncmpr,(rtemp10(j),idr(j),j=1,ncmpr)
      else 
       read(luxx,9010,end=140) idds,namds2,rtemp8,rtemp9,rtemp,rtemp2,
     * rtemp3, rtemp4,rtemp5,rtemp6,rtemp7,ncmpr,(rtemp10(j),idr(j),
     * j=1,ncmpr)
      end if
c  
      if (idds.eq.0) go to 130
      if (idc.lt.idds-icon.or.idc.gt.idds+icon) go to 100
      jkl = jkl+1
      namds = namds2
      hdr = sngl(rtemp8)
      eqr = sngl(rtemp9)
      do 400 j = 1, ncmpr
        coer(j) = sngl(rtemp10(j))
400   continue
c 
      savn(jkl) = namds
      isav(jkl) = idds
      saveq(jkl) = eqr
      savhr(jkl) = hdr
      do 120 j = 1, ncmpr
         do 110 jj = 1, nt0
            if (idr(j).ne.id0(jj)) go to 110
            nsav(j,jkl) = na0(jj)
            coef(j,jkl) = coer(j)
            idsav(j,jkl) = idr(j)
            ncsav(jkl) = ncmpr
            go to 120
  110    continue
  120 continue
      if (ifg.eq.0) go to 130
      if (icon.gt.0.and.jkl.lt.21) go to 100
  130 continue
  140 rewind luxx
      if (jkl.gt.0) go to 150
      namds = '                    '
      name = 'EXACT'
      if (ifg.eq.1) name = 'NEAR '
      write (lu06,9020) name,idc
      write (lu03,9020) name,idc
      idds = idc
      go to 210
  150 do 160 i = 1, jkl
         write (lu06,9030) i,isav(i),savn(i),coef(1,i),nsav(1,i),(' + ',
     *      coef(j,i),nsav(j,i),j=2,ncsav(i))
         write (lu03,9030) i,isav(i),savn(i),coef(1,i),nsav(1,i),(' + ',
     *      coef(j,i),nsav(j,i),j=2,ncsav(i))
  160 continue
      jkk = 1
      if (ifg.eq.0) go to 180
  170 write (lu06,9040) cont1
      read (lu05,*,err=170) jkk
      if (jkk.lt.0.or.jkk.gt.jkl) go to 170
      write (lu03,9040) cont2,jkk
      if (jkk.gt.0) go to 180
      ndbase = jkl
      jkl = -1
      go to 220
  180 idds = isav(jkk)
      namds = savn(jkk)
      eqr = saveq(jkk)
      hdr = savhr(jkk)
      ncmpr = ncsav(jkk)
      do 190 i = 1, ncmpr
         idr(i) = idsav(i,jkk)
         namer(i) = nsav(i,jkk)
         coer(i) = coef(i,jkk)
  190 continue
c
c MAKE CERTAIN THAT ALL CONTRIBUTING COMPONENTS ARE ENTERED INTO
c    COMPONENT FILE.
c
      do 200 i = 1, ncmpr
         call cominc (nty,idr(i),namer(i),'N',0)
  200 continue
c
c COMPLETE REACTION AND GET ITS DEGREE OF FREEDOM
c
      ntyr = nty
      call reafil (idds,0)
c
  210 name = namds
      eqx = eqr
      hdx = hdr
      idc = idds
  220 return
c
c
 9000 format (/,'  PATIENCE..Thermodynamic database file ',i3,
     *   ' is being searched !')
 9010 format (i7,1x,a12,2f10.4,2f8.3,3f5.2,f9.4/f5.2,1x,i1,3x,5(f7.3,1x,
     *   i3,3x))
 9020 format (/,' No ',a5,' match found in the database for ID ',i7)
 9030 format (' ',i3,1x,i7,1x,a12,'<-',f5.1,1x,a8,2(a3,f5.1,1x,a8)/3(24x
     *   ,3(a3,f5.1,1x,a8)/))
 9040 format (/,a1,
     *   ' Enter the number aligned with the species you want.',
     *   ' (0 = None of above) > ',1x,i2)
c
      end
c
      subroutine speadd (nty,idc,nam,aaa,bbb,ccc,ddd,iaa,ibb,
     *                   ifg,igfw)
c
c********************************************************************
c FUNCTION:
c     STORES APPROPRIATE VALUES IN NTY ARRAYS
c INPUT:
c     NTY=TYPE OF SPECIES TO STORE
c     IDC= I. D. OF SPECIES
c     NAM=NAME OF SPECIES
c     AAA=TOTAL CONC, NTY=1, OTHERWISE, LOG(KEQ)
c     BBB=ACTIVITY, NTY=1, OTHERWISE, DEL H REACTION
c     CCC  = Gram formula weight when nty =1
c          = Total concentration when nty = 4
c     DDD  = Charge when nty = 1
c          = Activity when nty = 3
c     IMO=FLAG TO ALLOW UPDATE IF ALREADY ENTERED. 1=YES, 0=NO
c     IAA=FLAG TO ENTER AAA
c     IBB=FLAG TO ENTER BBB
c     igfw = A flag indicating whether this routine should search
c            the component database file for the gram-formula
c            weight and charge of a component that is to be added
c            and to enter those values in the gfw and spz arrays.
c            This flag is only relevant when nty = 1.  Also,
c
c                  igfw = 0  means do not search for gfw and spz
c                       = 1  means do search for and add gfw and spz
c
c OUTPUT:
c     IFG=1 IF ARRAY LIMIT HAS BEEN REACHED
c********************************************************************
c CORRECTION HISTORY:
c   DATE                     CORRECTION                      REFERENC
c
c********************************************************************
c
c
      include 'PRODEFA2.INC'
c
      character nam*20
c
c********************************************************************
c
      if (nt(nty).eq.0) go to 110
      do 100 j = 1, nt(nty)
         i = j
         if (idc.eq.id(nty,i)) then
            go to 120
         endif
  100 continue
  110 nt(nty) = incr(nt(nty),nmxx,ifg)
      if (ifg.eq.1) go to 130
      i = nt(nty)
  120 id(nty,i) = idc
      na(nty,i) = nam
      if (nty.eq.1.and.igfw.eq.0) then
         gfw(i) = ccc
         spz(i) = ddd
      else if (nty.eq.1.and.igfw.eq.1) then
         do 125 j = 1, nt0
            if (idc.eq.id0(j)) then
               gfw(i) = gf0(j)
               spz(i) = ch0(j)
               go to 127
            end if
  125    continue
      end if
      if (nty.eq.4) then
         con(i) = ccc
      endif
  127 if (iaa.eq.1) teq(nty,i) = aaa
      if (ibb.eq.1) thr(nty,i) = bbb
  130 return
c
      end
c
c
      subroutine thconst (x,ltype,mtype)
c
c********************************************************************
c FUNCTION:
c     Queries user for thermodynamic constants (equilibrium constant
c     or enthalpy).
c
c INPUT:
c         ltype = Flag indicating type of constant:
c                        1 = log equilibrium constant (log K)
c                        2 = enthalpy
c         mtype = Flag indicating do or do not report current value of
c                 this constant then ask "Do you want to change..."
c                        0 = Do ask about changing the existing value
c                        1 = Do not ask about changing, just ask for
c                            the value
c INPUT/OUTPUT:
c         x = log K or enthalpy value
c
c********************************************************************
c
      include 'PRODEFA2.INC'
c
      real*4 x
      integer ltype, mtype
c
      if (mtype.eq.1) go to 110
c
  100 if (cmplig.ne.'y') then
        if (ltype.eq.1) write (lu06,9000) cont1,x
        if (ltype.eq.2) write (lu06,9002) cont1,x
        read (lu05,9010,err=100) ans
        if (ans.eq.'n') ans = 'N'
        if (ans.eq.'y') ans = 'Y'
        if (ans.ne.'Y'.and.ans.ne.'N') go to 100
        if (ltype.eq.1) write (lu03,9000) cont2,x,ans
        if (ltype.eq.2) write (lu03,9002) cont2,x,ans
        if (ans.ne.'Y') go to 120
      else
  101   if (ltype.eq.1) write (lu06,9006) cont1,x
        if (ltype.eq.2) write (lu06,9008) cont1,x
        read (lu05,9010,err=101) ans
        if (ans.eq.'n') ans = 'N'
        if (ans.eq.'y') ans = 'Y'
        if (ans.ne.'Y'.and.ans.ne.'N') go to 101
        if (ltype.eq.1) write (lu03,9006) cont2,x,ans
        if (ltype.eq.2) write (lu03,9008) cont2,x,ans
        if (ans.ne.'Y') go to 120
      end if   
c
  110 if (ltype.eq.1.and.iabq.eq.1.and.ntysp.eq.4) then
        write (lu06,9015)
        write (lu03,9015)
      end if 
      if (ltype.eq.1.and.cmplig.eq.'y') then
        write (lu06,9018)
        write (lu03,9018)
      end if 
  115 if (cmplig.ne.'y') then
        if (ltype.eq.1) then 
           if (ntysp.eq.4.and.iabq.eq.1) then 
              write (lu06,9024) cont1
              read (lu05,*,err=115) x
              write (lu03,9024) cont2, x
              x = log10 (soilkg*x) 
           else  
              write (lu06,9020) cont1
              read (lu05,*,err=115) x
              write (lu03,9020) cont2, x
           end if
        else if (ltype.eq.2) then
           write (lu06,9021) cont1
           read (lu05,*,err=115) x
           write (lu03,9021) cont2,x
        end if
      else
        if (ltype.eq.1) write (lu06,9022) cont1
        if (ltype.eq.2) write (lu06,9023) cont1
        read (lu05,*,err=115) x
        if (ltype.eq.1) write (lu03,9022) cont2,x
        if (ltype.eq.2) write (lu03,9023) cont2,x
      end if
  120 return
c
c
 9000 format (/,a1,' Do you want to CHANGE the log K value from ',
     *             f9.4,' ? (Y,N) > ',1x,a1)
 9002 format (/,a1,' Do you want to CHANGE the enthalpy value',
     *             ' from ',f11.4,' ? (Y,N) > ',1x,a1)
 9006 format (/,a1,' Do you want to CHANGE the MEAN log K from ',
     *             f9.4,' ? (Y,N) > ',1x,a1)
 9008 format (/,a1,' Do you want to CHANGE the standard dev in log K',
     *             ' from ',f9.4,' ? (Y,N) > ',1x,a1)
 9010 format (a1)
 9015 format (' The distribution coefficient needed for the activity',
     *        ' Kd model is expressed',
     *      /,' in liters/kg.  The number of kg of soil with which one',
     *        ' liter of solution',
     *      /,' is at equilibrium has been entered already and will be',
     *        ' used to normalize',
     *      /,' this value to a mg(sorbed) per mg(dissolved) basis for',
     *        ' use as an equilibrium',
     *      /,' constant in the above reaction.') 
 9018 format (/,' The log K needed for a reaction involving a',   
     *        ' composite ligand is a',
     *      /,' MEAN log K from a Gaussian distribution.  The',
     *        ' distribution is also',      
     *      /,' characterized by its standard deviation in log K',
     *        ' which is stored in the',		 
     *      /,' database in the place normally reserved for',
     *        ' enthalpy.')
 9020 format (/,a1,' Enter the log K value for formation of this',
     *         ' species > ',  e12.5)
 9021 format (/,a1,' Enter the enthalpy for formation of this',
     *         ' species > ',  e12.5)
 9022 format (/,a1,' Enter the MEAN log K value for formation of this',
     *         ' species > ',  e12.5)
 9023 format (/,a1,' Enter the standard deviation in log K > ', 
     *          e12.5)
 9024 format (/,a1,' Enter the distribution coefficient, Kd, for this',
     *         ' metal (l/kg) > ',  e12.5)
c
      end
