      subroutine cacalc (namc,co3,carb,ifgout)
c
c********************************************************************
c FUNCTION: ENTER APPROPRIATE CARBONATE VALUES AND MAKE CONVERSIONS
c  INPUT:
c      IFGIN=0, ALLOWS COMPLETE BYPASS IF NO ENTRIES MADE
c      NAMC=NAME OF CARBONATE
c  OUTPUT:
c      CO3=CONCENTRATION
c      CARB=LOG10(ACTIVITY)
c      NAMC=ALKALINITY, TOTAL CARBON,
c      IFGOUT=1 BYPASS ENTRY INTO SAMPLE FILE
c********************************************************************
c CORRECTION HISTORY:
c   DATE                     CORRECTION                      REFERENC
c********************************************************************
c
c
      include 'PRODEFA2.INC'
c
c
      character namc*22,alkunits*10
      character*1 atic
c
      atic = 'N'
      ifgout = 0
      icoral = 0
      co3m = 1.0e-35
      co3 = co3m
c
      carb = -35.
  100 write (lu06,9000) cont1
      read (lu05,9020,err=100) ans
      if (ans.eq.'n') ans = 'N'
      if (ans.eq.'y') ans = 'Y'
      write (lu03,9000) cont2,ans
      if (ans.ne.'N'.and.ans.ne.'Y') go to 100
      if (ans.eq.'N') then
         ifgout = 1
         go to 140
      endif
c
c CALCULATE ACTIVITY
c
      ahye = 10.**ahyd
      tem1 = 2.133e10*ahye+4.797e16*(ahye*ahye)
      write (lu06,9030)
      write (lu03,9030)
  110 write (lu06,9010) cont1
      read (lu05,9020,err=110) ans
      if (ans.eq.'n') ans = 'N'
      if (ans.eq.'y') ans = 'Y'
      write (lu03,9010) cont2,ans
      if (ans.ne.'N'.and.ans.ne.'Y') go to 110
      if (ans.eq.'N') go to 130
  115 write (lu06,9015) cont1
      read (lu05,*,err=115) ialkty
      write (lu03,9010) cont2,ialkty
      if (ialkty.lt.0.or.ialkty.gt.3) go to 115
      if (ialkty.eq.0) go to 110
      if (ialkty.eq.1) then
        alkunits = 'mg/l CO3-2'
      else if (ialkty.eq.2) then
        alkunits = 'mg/l CaCO3'
      else if (ialkty.eq.3) then
        alkunits = 'eq/l'
      end if
      icoral = 1
  120 write (lu06,9040) cont1,alkunits
      read (lu05,*,err=120) co3
      if (co3.lt.0) go to 120
      write (lu03,9040) cont2,alkunits,co3
      namc = 'Total CO3-2 alkalinity'
      if (ialkty.eq.1 .or. ialkty.eq.2) then
        if (ialkty.eq.2) then
c  -- Convert CaCO3 alkalinity in mg/l to CO3-2 alkalinity in mg/l.
          co3 = 0.59951*co3
        endif
c
c  -- Convert alkalinity in mg/l to molal.
      co3m = co3 *  0.001/(denh2o*59.998)
c
      else
c  -- Convert alkalinity in eq/l (note: CaCO3 eq/l = CO3-2 eq/l)
c     to molal.
      co3m = co3 / 2.0
c
      end if
c
c  -- Convert co3 in molal to whatever units the user has chosen.
c
c     molal:
      if (iflag.eq.1) co3 = co3m
c     mg/l:
      if (iflag.eq.2) co3 = co3m * 1000.0 * 59.998
c     ppm:
      if (iflag.eq.3) co3 = co3m * 1000.0 * 59.998
c     meq/l
      if (iflag.eq.4) co3 = co3m * 1000.0 * denh2o * 2.0
c
      carb = co3m/(1.0+tem1)
      tem = 1.0e-14/ahye-ahye
      if (co3m.lt.tem) then
         tem = 500.0 * tem
         if (ialkty.eq.2) tem = tem * 99.921
         write (lu06,9060) tem,-ahyd
         write (lu03,9060) tem,-ahyd
         go to 110
      endif
      ifgin = 1
      go to 170
  130 write (lu06,9070) cont1
      read (lu05,9020,err=130) atic
      if (atic.eq.'y') atic = 'Y'
      if (atic.eq.'n') atic = 'N'
      if (atic.eq.'Y') then
         go to 150
      else
         write (lu06,9080)
         write (lu03,9080)
      endif
      ifgout = 1
  140 return
  150 write (lu03,9070) cont2,atic
      if (atic.ne.'Y'.and.atic.ne.'N') go to 130
      if (atic.ne.'Y') go to 180
      namc = 'TOTAL CARBON, CO3'
      icoral = 0
  160 write (lu06,9090) cont1,flag
      read (lu05,*,err=160) co3
      if (co3.lt.0) go to 160
      write (lu03,9090) cont2,flag,co3
c
c CALCULATE MOLAL CONCENTRATIONS
c
c     molal:
      if (iflag.eq.1) co3m = co3
c     mg/l:
      if (iflag.eq.2) co3m = co3*8.33333e-5/denh2o
c     ppm:
      if (iflag.eq.3) co3m = co3*8.33333e-5
c     meq/l
      if (iflag.eq.4) co3m = co3*0.0005/denh2o
c
      carb = co3m/(1.+tem1)
      ifgin = 1
  170 carb = log10(carb)
  180 if (ifgin.eq.0.and.atic.eq.'N') ifgout = 1
      return
c
c
 9000 format (/,' Do you want to specify dissolved inorganic carbon',
     *     /,a1,' in this problem ? (Y,N) > ',1x,a1)
 9010 format (/,' You have the option of specifying alkalinity',
     *          ' as a measure of',
     *        /,' dissolved inorganic carbon.  Alternatively, you',
     *          ' may specify dissolved', 
     *        /,' inorganic carbon explicitly.  Your choice will',
     *          ' generally depend upon the way',
     *        /,' carbonate concentration is expressed in the',
     *          ' chemical analysis of the',
     *        /,' sample you are modeling.', 
     *    //,a1,' Do you want to specify alkalinity ? (Y,N) > ',1x,a1)
 9015 format (/,'  Select alkalinity units: ',
     *  /,'   0 = Return to previous question',
     *  /,'   1 = mg/l CO3-2',
     *  /,'   2 = mg/l CaCO3',
     *  /,'   3 = eq/l ',
     *  /,a1,'       ENTER CHOICE  > ',1x,i1)
 9020 format (a1)
 9030 format (/' When alkalinity is specified, no solids are allowed.',
     *         ' (Set EDIT LEVEL I Option 8',
     *        /' to zero and specify no TYPE III,IV, or V solids.)',
     *        /' Also, the titration used to determine alkalinity',
     *         ' is assumed to be to the',
     *        /' pH that is the equivalence point of the',
     *         ' solution).  Otherwise the alkalinity,',
     *        /' factors in the database will not be applicable.')
 9040 format (/,a1,' Enter alkalinity in ',a10,' > ',e10.3)
 9060 format (' Alkalinity must be greater than ',f8.2,/,
     *   ' at a pH of ',f8.2)
 9070 format (/,' Do you want to enter total inorganic carbon as',
     *          ' total dissolved concentration',
     *     /,a1,' of the MINTEQA2 component for inorganic carbon',
     *          ' CO3-2 ? (Y,N) > ',1x,a1)
 9080 format (/,' You have chosen to enter inorganic carbon as',
     *          ' neither alkalinity nor',
     *        /,' total dissolved concentration of CO3-2.')  
 9090 format (/,' Enter total inorganic carbon as total dissolved',
     *   ' concentration of',
     *   /,a1,' CO3-2 in ',a6,' > ',e12.4)
c
      end
c
      subroutine pecalc (namc,cont,act,ifgout)
c
c********************************************************************
c  INPUT:
c      IFGIN=0, ALLOWS COMPLETE BYPASS IF NO ENTRIES MADE
c  OUTPUT:
c      CONT=CONCENTRATION
c      ACT=LOG10(ACTIVITY)
c      IFGOUT=1 BYPASS ENTRY INTO SAMPLE FILE
c********************************************************************
c CORRECTION HISTORY:
c   DATE                     CORRECTION                      REFERENC
c
c********************************************************************
c
c********************************************************************
c
c
c
      include 'PRODEFA2.INC'
c
      real ae,eh,pe
      character namc*20
c
c DEFAULT ELECTRON ACTIVITY AND EH AT PO2=.2
c
      ae = ahyd-20.58
      ifgout = 0
c
  100 write (lu06,9000) cont1
      read (lu05,9010,err=100) ans
      if (ans.eq.' ') ans = 'r'
      if (ans.eq.'R') ans = 'r'
      write (lu03,9000) cont2,ans
      if (ans.ne.'1'.and.ans.ne.'2'.and.ans.ne.'3'.and.ans.ne.'4'
     *    .and.ans.ne.'r') go to 100
      if (ans.eq.'r') go to 130
      if (ans.eq.'1'.or.ans.eq.'3') then
  110 	 write (lu06,9020) cont1
      	 read (lu05,*,err=110) pe
      	 write (lu03,9020) cont2,pe
      	 namc = 'E- (ENTERED AS PE)'
      	 act = -pe
         cont = 0.0
      	 idc = 001
      	 call speadd (1,idc,namc,cont,act,dmy,dmy,1,1,ifg,1)
         if (ans.eq.'1') then
      	   ddd = 0.0
      	   call speadd (ntyfix,idc,namc,-act,dmy,cont,ddd,1,0,ifg,0)
         else if (ans.eq.'3') then
           do 150 i3 = 1, nt(3)
             if (id(3,i3).eq.001) call dltcomp(3,i3)
 150       continue
         end if
c
      else if (ans.eq.'2'.or.ans.eq.'4') then
c
  120   write (lu06,9030) cont1
        read (lu05,*,err=120) eh
        eh = eh/1000.0
        if (eh.gt.2.0.or.eh.lt.-1.0) go to 120
        write (lu03,9030) cont2,eh
        act = -5040.24*eh/(temp+273.16)
        namc = 'E- (ENTERED AS EH)'
        cont = 0.0
        idc = 001
        call speadd (1,idc,namc,cont,act,dmy,dmy,1,1,ifg,1)
        if (ans.eq.'2') then
          ddd = 0.0
          call speadd (ntyfix,idc,namc,-act,dmy,cont,ddd,1,0,ifg,0)
        else if (ans.eq.'4') then
          do 155 i3 = 1, nt(3)
            if (id(3,i3).eq.001) call dltcomp(3,i3)
 155      continue
        end if
c 
      end if
c
 130  ifgout = 1
      return
c
c
 9000 format (/,'  Select redox potential option:',/,
     *   '    1 = Specify EQUILIBRIUM pE ',
     * /,'    2 = Specify EQUILIBRIUM Eh ',
     * /,'    3 = Allow pE/Eh to be computed but specify a guess for',
     *            ' pe',
     * /,'    4 = Allow pE/Eh to be computed but specify a guess for',
     *            ' Eh'
     * /,'    R = Return to previous menu',
     * /,a1,'       ENTER CHOICE ([D] = R) > ',1x,a1)
 9010 format (a1)
 9020 format (/,a1,' Enter pE > ',f8.3)
 9030 format (/,a1,' Enter Eh (millivolts) > ',f8.4)
c
      end
c
      subroutine phcalc (namc,cont,act,ifgout)
c
c********************************************************************
c  INPUT:
c      IFGIN=0, ALLOWS COMPLETE BYPASS IF NO ENTRIES MADE
c  OUTPUT:
c      CONT=CONCENTRATION
c      ACT=LOG10(ACTIVITY)
c      IFGOUT=1 BYPASS ENTRY INTO SAMPLE FILE WHEN IFGIN =0
c********************************************************************
c CORRECTION HISTORY:
c   DATE                     CORRECTION                      REFERENC
c
c********************************************************************
c
      include 'PRODEFA2.INC'
c
      character*20 namc
c
c********************************************************************
c
      call clrscr (lu06)
  100 write (lu06,9000) cont1
      read (lu05,9060,err=100) ans
      if (ans.eq.'R'.or.ans.eq.' ') ans = 'r'
      if (ans.ne.'1'.and.ans.ne.'2'.and.ans.ne.'r') go to 100
      write (lu03,9000) cont2,ans
      if (ans.eq.'r') go to 130
c
c  -- Specify EQUILIBRIUM pH
      if (ans.eq.'1') then
  110   write (lu06,9010) cont1
        read (lu05,*,err=110) ph
        if (ph.lt.0.or.ph.gt.14) go to 110
        write (lu03,9010) cont2,ph
        namc = 'H+1'
        toth = 0.0
        ahyd = -ph
        cont = toth
        act = ahyd
        ddd = 0.0
        idc = 330
        call speadd (1,idc,namc,cont,act,dmy,dmy,1,1,ifg,1)
        call speadd (ntyfix,idc,namc,-act,dmy,cont,ddd,1,0,ifg,0)
c
c  -  Specify total hydrogen concentration
      else if (ans.eq.'2') then
  120   write (lu06,9020) cont1,flag
        read (lu05,*,err=120) toth
        write (lu03,9020) cont2,flag,toth
        ahyd = -7.0
        namc = 'H+1'
        cont = toth
        act = ahyd
        idc = 330
        call speadd (1,idc,namc,cont,act,dmy,dmy,1,1,ifg,1)
        do 150 i3 = 1, nt(3)
           if (id(3,i3).eq.330) call dltcomp(3,i3)
 150    continue
c
      end if
c
  130 ifgout = 1
      return
c
 9000 format (/,'  Select pH option:',
     *       /,'    1 = Specify EQUILIBRIUM pH',
     *       /,'    2 = Allow pH to be computed but specify total',
     *                  ' hydrogen concentration',
     *       /,'    R = Return to previous menu',
     *    /,a1,'       ENTER CHOICE ([D] = R) > ',1x,a1)
 9010 format (/,a1,' Enter the EQUILIBRIUM pH > ',f8.3)
 9020 format (/,a1,' Enter total hydrogen concentration in ',a6,
     *             ' > ',e12.4)
 9060 format (a1)
c
      end
