      subroutine cominc (nty,idc,namf,fixc,ifgin)
c
c********************************************************************
c FUNCTION:
c     PLACE THE COMPONENT
c INPUT:
c     IDC=I. D. OF COMPONENT
c     NAMC=NAME OF COMPONENT
c     FIXC= 'Y'  FIXES COMPONENT, 'N' ALLOWS QUESTION, 'V' MAKES VAR
c     SET TO 'N' ON ENTRY IF UNCERTAIN
c     IFGIN= 0 (DO NOT UPDATE IF ALREADY THERE); 1=UPDATE IF ALREADY
c********************************************************************
c
c CORRECTION HISTORY:
c   DATE                     CORRECTION                      REFERENC
c
c********************************************************************
c
c
      include 'PRODEFA2.INC'
      include 'CONST.INC'
c
      character*20 namc,namf
c
      character*1 fixc
c
c********************************************************************
c
c
      namc = namf
      ifgout = 0
      iii = 0
c
c ADD SPECIES TO FILE WITH A CONCENTRATION OF 1.0E-35
c
      cont = 0.00
      act = -16.
c
c CONVERT ACTIVITY TO MOLALITY UNITS
c
      do 110 i = 1, nt0
         if (idc.ne.id0(i)) go to 110
         iii = i
         go to 120
  110 continue
      go to 180
  120 if (nt(1).gt.0) then
         do 100 i = 1, nt(1)
            if (idc.ne.id(1,i)) go to 100
            if (ifgin.eq.0) go to 180
            cont = teq(1,i)
            act = thr(1,i)
            go to 140
  100    continue
      endif
      if (iflag.eq.1.or.idc.le.2.or.idc.ge.990) go to 130
      if (idc.eq.330.or.idc.eq.140) go to 130
      if (iflag.eq.2) act = act-3.0-log10(gf0(iii))-log10(denh2o)
      if (iflag.eq.3) act = act-3.0-log10(gf0(iii))
      if (iflag.eq.4.and.abs(ch0(iii)).gt.R0MIN) act = act-3.0-
     *   log10(abs(ch0(iii)))-log10(denh2o)
      go to 140
c
c SET ACTIVITY AND CONCENTRATION OF WATER
c
  130 if (idc.eq.002) go to 180
  140 if (fixc.eq.'Y') cont = 0.
      if (idc.eq.330.and.ntysp.eq.1) then 
        call phcalc (namc,cont,act,ifgout)
      else if (idc.eq.001.and.ntysp.eq.1) then
        call pecalc (namc,cont,act,ifgout)
      else if (idc.eq.140.and.ntysp.eq.1) then
        call cacalc (namc,cont,act,ifgout)
      end if 
      if (ifgout.eq.1) go to 180
c
      if (nty.eq.6) then
         write (lu06,5000) 
         write (lu03,5000)
         write (lu06,9105) cont1
         write (lu03,9105)
         read (lu05,*)
         exclu = 'n'
         go to 180
      end if
      call speadd (1,idc,namc,cont,act,dmy,dmy,1,1,ifg,1)
      if (cont.lt.R0MIN) then
        write (lu06,9040) na0(iii)
        write (lu03,9040) na0(iii)
        read (lu05,*)
      end if
  180 return
c
c
 9040 format (/,' ------------------------------------------------',
     *          '-------------------------------', 
     *     /,' Component ',a8,' had not previously been specified.',
     *        '  It has been added at a',
     *       /' total concentration of zero.  You may',
     *        ' change the concentration in EDIT LEVEL 3.',
     *       /' -->  PRESS ENTER TO CONTINUE')
 9105 format (a1,'   Press ENTER to continue')
 5000 format (/,' *** Since not all of the components required for',
     *          ' this species have',
     *        /,'     been specified in this problem, the species is',
     *          ' excluded by default.')
c
      end
c
      subroutine excludee
c
c --  FUNCTION:  Add the electron component to the excluded list
c                if it is not already excluded.  If the electron
c                activity is fixed, don't exclude it.
c********************************************************************
c
      include 'prodefa2.inc'
c
c
      character xclude*1
c
c
c  -- Check to see if the electron is fixed.  This is in preparation to
c     exclude it if it is not fixed.
c
      xclude = 'Y'
      do 100 i = 1, nt(ntyfix)
         if (id(ntyfix,i).eq.001) xclude = 'N'
  100 continue
c
c --  If the electron is not  fixed, check to see if it is a component
c     at all.  If so, see if it is excluded.  If not excluded, make it
c     excluded.
c
      if (xclude.eq.'Y') then
         do 120 i = 1, nt(1)
c
c --  Is the electron a component?  If not, transfer out.
c
            if (id(1,i).ne.001) go to 120
c
c --  If it is already excluded, transfer out.
c
            do 110 k = 1, nt(6)
               if (id(6,k).eq.001) go to 120
  110       continue
c
c --  Make it excluded.
c
            nt(6) = nt(6)+1
            id(6,nt(6)) = 001
            teq(6,nt(6)) = 0.0
            thr(6,nt(6)) = 0.0
            na(6,nt(6)) = 'E-1'
  120    continue
c
      elseif (xclude.eq.'N') then
c
c --  The electron is not to be excluded because it is fixed.  Check to
c     to see if it has already been excluded (perhaps the electron was
c     not fixed before but has now been fixed) and delete it from
c     the excluded list if it is present.
c
         if (nt(6).gt.0) then
            j = 0
            do 130 i = 1, nt(6)
               if (id(6,i).eq.001) j = i
  130       continue
            if (j.eq.nt(6)) then
               nt(6) = nt(6)-1
            elseif (j.gt.0.and.j.lt.nt(6)) then
               nt(6) = nt(6)-1
               do 140 i = j, nt(6)
                  id(6,i) = id(6,i+1)
                  na(6,i) = na(6,i+1)
                  teq(6,i) = teq(6,i+1)
                  thr(6,i) = thr(6,i+1)
  140          continue
            endif
         endif
      endif
c
c
      return
c
      end
c
c
c********************************************************************
c
c
      subroutine fixorder
c
c FUNCTION:
c     Re-orders the type 3 (fixed) list so that components are
c     moved to the last positions in the list.
c OUTPUT:
c     The appropriate arrays in common blocks are re-ordered.
c********************************************************************
c
      include 'prodefa2.inc'
c
      real*4 te,th
      integer idt
      character name*20
      include 'CONST.INC'
c
c -- Order type "ntyfix" (=3) so that component species are at the
c    bottom of the list.  Conponents have id numbers less than 1000.
c
      do 110 i = 1, nt(ntyfix)-1
         if (id(ntyfix,i).lt.1000) then
            idt = id(ntyfix,i)
            te = teq(ntyfix,i)
            th = thr(ntyfix,i)
            name = na(ntyfix,i)
            do 100 j = i, nt(ntyfix)-1
               id(ntyfix,j) = id(ntyfix,j+1)
               teq(ntyfix,j) = teq(ntyfix,j+1)
               thr(ntyfix,j) = thr(ntyfix,j+1)
               na(ntyfix,j) = na(ntyfix,j+1)
  100       continue
            id(ntyfix,nt(ntyfix)) = idt
            teq(ntyfix,nt(ntyfix)) = te
            thr(ntyfix,nt(ntyfix)) = th
            na(ntyfix,nt(ntyfix)) = name
         endif
  110 continue
c
      return
c
      end
c
      subroutine init
c
c  -- Initialize some important variables.  Should be called whenever
c     user switches to modify a different file to prevent values from
c     the previous file being retained.
c
      include 'PRODEFA2.INC'
c READ COMPONENT FILE
c
      rewind lu13
      nt0 = 0
      do 130 i = 1, nmx0
         read (lu13,9070,end=140) id0(i),na0(i),ch0(i),gf0(i)
         if (id0(i).ne.0) nt0 = nt0+1
  130 continue
c -- Initialize adsorption parameters.
  140 continue
c
      do 100 i = 1, 5
         solcon(i) = 0.0
         ssa(i) = 0.0
         cap1(i) = 0.0
         cap2(i) = 0.0
  100 continue
c -- Initialize some other variables and constants.
c
      denh2o = 1.0
      iads = 0
      iabq = 0
      numads = 0
      iflag = 1 
      flag = fla(iflag)
      temp = 25.0
      fions = 0.0
      icoral = 0 
      ibacks = 0 
      idbg = 0
      ichrg = 1
      iprint = 0
      niter = 0
      iparm = 0
      isopt = 0
      kkdav = 1
      kkthr = 1
      idsweep = 0
      sweep = ' '
      nprob = 0  
      agus = 'N'
      do 150 j = 1, 7
         nt(j) = 0
         do 150 i = 1, nmxx
            id(j,i) = 0
            teq(j,i) = 0.0
            thr(j,i) = 0.0
            na(j,i) = '                    '
            gfw(i) = 0.0
            spz(i) = 0.0
  150 continue
      do 170 k = 1, nmx7c
         nt7(k) = 0
         do 160 i = 1, nmx7
            index7(k,i) = 0
            stoic7(k,i) = 0.0
            na7(k,i) = '                    '
            id7(k,i) = 0
            temn7(i) = 0.0
            temx7(i) = 0.0
            sp7(i) = 0.0
            alk7(i) = 0.0
            ncmp(i) = 0
            dha7(i) = 0.0
            dhb7(i) = 0.0
  160    continue
  170 continue
      nt(1) = 1
      id(1,1) = 330
      teq(1,1) = 0.0
      thr(1,1) = -7.0
      na(1,1) = 'H+1'
c
      return
 9070 format (i3,1x,a8,f4.0,22x,f9.4)
      end
c
      subroutine fini (ifail)
c
      include 'PRODEFA2.INC'
      integer ifail
c
      call writep (lu16,1)
      call printp
      ifail = 0
      if (nt(1).gt.0.and.nt(1).lt.nt(3)+nt(4)+1) then
         write (lu06,9390) nt(1),nt(3)+nt(4)
         write (lu03,9390) nt(1),nt(3)+nt(4)
         ifail = 1
         write (lu06,9050)
         write (lu03,9050)
         read (lu05,*)
      elseif (nt(1).eq.0) then
         write (lu06,9400)
         write (lu03,9400)
         ifail = 1
         write (lu06,9050)
         write (lu03,9050)
         read (lu05,*)
      endif
c
      call writep (lu11,0)
      call clrscr (lu06)
c
      return
c
 9050 format (/,' Press ENTER to continue')
 9390 format (/,'                                !!!!!!! ERROR ',
     *   '!!!!!!!',/,'   The problem as defined is over-constrained.',/,
     *   '   There are ',i3,' independent components (TYPE 1)',' and ',
     *   i3,' constraining',/,
     *   '   conditions (TYPES 3 & 4).  Either add more',
     *   ' independent components',/,
     *   '   or reduce the number of fixed or solid species.')
 9400 format (/,'  You have specified no components in this problem.',
     *   '  We just cannot have',/,'  a problem without components.')
c
      end
      subroutine dltcomp (nty1,j)
c
c  -- Subroutine to delete a component from the "nty1" list.
c     This routine also decrements nt(nty1) by 1.  The component
c     to delete is specified by giving its element number j in the
c     two-dimensional array id(nty1,j).  Entries pertaining to the
c     deleted component in related arrays are also deleted.
c
      include 'PRODEFA2.INC'
      k = 0
      do 10 i = 1, n123
        if (id123(i).eq.id(nty1,j)) k = i
  10  continue
      if (k.gt.0.and.k.eq.n123) then
        id123(n123) = 0
        n123 = n123 - 1
      else if (k.gt.0.and.k.lt.n123) then
        n123 = n123 - 1
        do 20 i = k, n123
          id123(i) = id123(i+1)
  20    continue
      end if
c
      n = nt(nty1)
      if (j.eq.n) then
         id(nty1,j) = 0
         na(nty1,j) = '    '
         teq(nty1,j) = 0.0
         thr(nty1,j) = 0.0
         nt(nty1) = nt(nty1)-1
      elseif (j.gt.0.and.j.lt.n) then
         nt(nty1) = nt(nty1)-1
         do 100 i = j, nt(nty1)
            id(nty1,i) = id(nty1,i+1)
            na(nty1,i) = na(nty1,i+1)
            teq(nty1,i) = teq(nty1,i+1)
            thr(nty1,i) = thr(nty1,i+1)
  100    continue
      endif
c
      return
      end
