      subroutine editlvl3
c
c --   FUNCTION:  Displays one screen of entries of type "nty"
c
c     EXAMINE LISTINGS IN TYPE FILES AND MAKE CORRECTIONS AS DESIRED
c INPUT:
c     NTY=TYPE OF FILE (1-7) FILE 7 IS ADDITION FILE
c OUTPUT:
c     CHANGES IN APPROPRIATE COMMON ARRAYS
c********************************************************************
c
c
c CORRECTION HISTORY:
c   DATE                     CORRECTION                      REFERENC
c
c********************************************************************
c
c
c
      include 'prodefa2.inc'
c
      character oparen*1,cparen*1,type*20,morentry*1,imatch*1,
     *         rgflag*3
      real*4 sto
c
      dimension type(7)
      include 'CONST.INC'
c
      data type / 'COMPONENTS      ','AQUEOUS SPECIES ',
     *   'FIXED SPECIES   ','FINITE SOLIDS   ','POSSIBLE SOLIDS ',
     *   'EXCLUDED SPECIES','ADDED SPECIES   '/
c
      oparen = '('
      cparen = ')'
      iprtlmit = 18
c
c  -- The loop over nty starts here (nty1 is alias for nty).
c
      do 530 nty1 = 1, 7
         istart = 1
         iprtntry = 0
         morentry = 'n'
         call clrscr (lu06)
         if (nt(nty1).gt.0) go to 100
         write (lu06,9000) type(nty1),nty1
         write (lu03,9000) type(nty1),nty1
         go to 530
c
c
  100    continue
c
c  -- Check to see that if the electron is a component and the electron
c     activity isn't fixed, then it is excluded.  Exclude it if
c     it isn't already.
c
         call excludee
c
c  -- Check the order of the type 3 (FIXED) list.  Component
c     species should be last in the list.
c
         call fixorder
c
c
c  -- For lists types that have more than 1 entry, check for duplicates.
c
         if (nt(nty1).gt.1) then
            do 140 i = 1, nt(nty1)-1
               do 140 j = i+1, nt(nty1)
                  if (id(nty1,i).eq.id(nty1,j)) then
                     write (lu06,9180) id(nty1,i)
                     write (lu03,9180) id(nty1,i)
                     write (lu06,8010) cont1
                     write (lu03,8010) 
                     read (5,*)
                  endif
  140       continue
         endif
c
c
c  -- The main repeat loop for a screen of entries that is being
c     edited or for displaying successive screens of a given
c     type begins here.
c
  110    call clrscr (lu06)
c
c  -- Inform user that the entries of a given "type" are displayed.
c     for verification or changes.
c
         write (lu06,9020) iprb, type(nty1)
         write (lu03,9020) iprb, type(nty1)
c
c  -- Put the proper headings up for the "type" displayed.
c
         if (nty1.eq.1) then
            write (lu06,9030)
            write (lu03,9030)
         elseif (nty1.eq.4) then
            write (lu06,9050)
            write (lu03,9050)
         elseif (nty1.eq.6) then
            write (lu06,9070)
            write (lu03,9070)
         elseif (nty1.eq.7) then
            write (lu06,9060)
            write (lu03,9060)
         else
            write (lu06,9040)
            write (lu03,9040)
         endif
c
c
c
c  -- Display up to one screen (18 lines) of data for this "type".
c     Note that all entries are one line except Added Species which
c     may be from 2 to 4 lines for each entry.
c
c --  As we enter this do loop, we don't know how many entries to
c     loop through because we don't know the number of stoichiometric
c     pairs in the Added Species.  So, we set the upper index of the
c     loop to the total number of entries for this "type", keep a
c     running total of the lines printed, and break out of the loop
c     when printing the next entry will cause the limit on the number
c     of lines to be exceeded.
c
         istrflag = 0
         lprinted = 0
         do 120 i = istart, nt(nty1)
            if (nty1.eq.4) then
               if ((lprinted+1).gt.iprtlmit) go to 130
               write (lu06,9170) i,id(4,i),na(4,i),con(i),teq(4,i),thr(4
     *            ,i)
               write (lu03,9170) i,id(4,i),na(4,i),con(i),teq(4,i),thr(4
     *            ,i)
               lprinted = lprinted+1
               iprtntry = iprtntry+1
            elseif (nty1.eq.7) then
               if (ncmp(i).le.4) then
                  iprtline = 2
                  if (nbcmp(i).gt.0) iprtline = iprtline+1
                  if ((lprinted+iprtline).gt.iprtlmit) go to 130
                  write (lu06,9090) i,id(7,i),na(7,i),teq(7,i),thr(7,i),
     *               sp7(i),gf7(i),alk7(i)
                  write (lu03,9090) i,id(7,i),na(7,i),teq(7,i),thr(7,i),
     *               sp7(i),gf7(i),alk7(i)
                  write (lu06,9100) (oparen,stoic7(j,i),cparen,id7(j,i),
     *               j=1,ncmp(i))
                  write (lu03,9100) (oparen,stoic7(j,i),cparen,id7(j,i),
     *               j=1,ncmp(i))
                  lprinted = lprinted+iprtline
                  iprtntry = iprtntry+1
               elseif (ncmp(i).ge.5.and.ncmp(i).le.8) then
                  iprtline = 3
                  if (nbcmp(i).gt.0) iprtline = iprtline+1
                  if ((lprinted+iprtline).gt.iprtlmit) go to 130
                  write (lu06,9090) i,id(7,i),na(7,i),teq(7,i),thr(7,i),
     *               sp7(i),gf7(i),alk7(i)
                  write (lu03,9090) i,id(7,i),na(7,i),teq(7,i),thr(7,i),
     *               sp7(i),gf7(i),alk7(i)
                  write (lu06,9110) (oparen,stoic7(j,i),cparen,id7(j,i),
     *               j=1,ncmp(i))
                  write (lu03,9110) (oparen,stoic7(j,i),cparen,id7(j,i),
     *               j=1,ncmp(i))
                  lprinted = lprinted+iprtline
                  iprtntry = iprtntry+1
               elseif (ncmp(i).ge.9.and.ncmp(i).le.12) then
                  iprtline = 4
                  if (nbcmp(i).gt.0) iprtline = iprtline+1
                  if ((lprinted+iprtline).gt.iprtlmit) go to 130
                  write (lu06,9090) i,id(7,i),na(7,i),teq(7,i),thr(7,i),
     *               sp7(i),gf7(i),alk7(i)
                  write (lu03,9090) i,id(7,i),na(7,i),teq(7,i),thr(7,i),
     *               sp7(i),gf7(i),alk7(i)
                  write (lu06,9120) (oparen,stoic7(j,i),cparen,id7(j,i),
     *               j=1,ncmp(i))
                  write (lu03,9120) (oparen,stoic7(j,i),cparen,id7(j,i),
     *               j=1,ncmp(i))
                  lprinted = lprinted+iprtline
                  iprtntry = iprtntry+1
               endif
               if (nbcmp(i).gt.0) then
                  istrflag = 1
                  write (lu06,9140) (oparen,stoib7(j,i),cparen,idb7(j,i)
     *               ,j=1,nbcmp(i))
                  write (lu03,9140) (oparen,stoib7(j,i),cparen,idb7(j,i)
     *               ,j=1,nbcmp(i))
               endif
            elseif (nty1.eq.6) then
               if ((lprinted+1).gt.iprtlmit) go to 130
               write (lu06,9130) i,id(nty1,i),na(nty1,i)
               write (lu03,9130) i,id(nty1,i),na(nty1,i)
               lprinted = lprinted+1
               iprtntry = iprtntry+1
            else if (nty1.eq.1) then
               if ((lprinted+1).gt.iprtlmit) go to 130
               if (reguess(i).eq.'n') then
                 rgflag = 'NO '
               else 
                 rgflag = 'YES'
               end if
               write (lu06,9081) i,id(nty1,i),na(nty1,i),teq(nty1,i),thr
     *            (nty1,i),rgflag
               write (lu03,9081) i,id(nty1,i),na(nty1,i),teq(nty1,i),thr
     *            (nty1,i),rgflag
               lprinted = lprinted+1
               iprtntry = iprtntry+1
            else
               if ((lprinted+1).gt.iprtlmit) go to 130
               write (lu06,9080) i,id(nty1,i),na(nty1,i),teq(nty1,i),thr
     *            (nty1,i)
               write (lu03,9080) i,id(nty1,i),na(nty1,i),teq(nty1,i),thr
     *            (nty1,i)
               lprinted = lprinted+1
               iprtntry = iprtntry+1
            endif
  120    continue
  130    continue

c
c  -- Set flag to indicate there are more entries of this type to
c     be displayed.
c
         if (iprtntry.lt.nt(nty1)) then
            write (lu06,9190)
            morentry = 'y'
         endif
c
c  -- Give opportunity to edit displayed entries by specifying entry
c     number.  Zero means no changes to displayed entries.  If the user
c     specifies the number of existing entries + 1 (nt(nty1)+1), it mean
c     add a new entry.
c
         if (istrflag.eq.1) then
            write (lu06,9380)
            write (lu03,9380)
         else
            write (lu06,9010)
         endif
  150    write (lu06,9200) cont1
         read (lu05,9205,err=150) n
         if (n.lt.0.or.n.gt.nt(nty1)+1) go to 150
c
c  -- Prevent attempt to add new entries of this type if there are
c     more entries yet to be displayed.
c
         if (n.eq.(nt(nty1)+1).and.morentry.eq.'y') then
            write (lu06,9210)
            go to 150
         endif
         write (lu03,9200) cont2,n
  160    if (n.eq.0) then
            if (morentry.eq.'y') then
               istart = iprtntry+1
               morentry = 'n'
               go to 110
            else
               go to 530
            endif
         elseif (n.gt.0.and.n.le.nt(nty1)) then
            call clrscr (lu06)
            iprtntry = istart-1
            if (nty1.eq.1) then
               write (lu06,9030)
               write (lu03,9030)
            elseif (nty1.eq.4) then
               write (lu06,9050)
               write (lu03,9050)
            elseif (nty1.eq.7) then
               write (lu06,9060)
               write (lu03,9060)
            else
               write (lu06,9040)
               write (lu03,9040)
            endif
            i = n
            if (nty1.eq.4) then
               write (lu06,9170) i,id(4,i),na(4,i),con(i),teq(4,i),thr(4
     *            ,i)
               write (lu03,9170) i,id(4,i),na(4,i),con(i),teq(4,i),thr(4
     *            ,i)
            elseif (nty1.eq.6) then
               write (lu06,9130) i,id(nty1,i),na(nty1,i)
               write (lu03,9130) i,id(nty1,i),na(nty1,i)
            elseif (nty1.eq.7) then
               write (lu06,9090) i,id(7,i),na(7,i),teq(7,i),thr(7,i),sp7
     *            (i),gf7(i),alk7(i)
               write (lu03,9090) i,id(7,i),na(7,i),teq(7,i),thr(7,i),sp7
     *            (i),gf7(i),alk7(i)
               if (ncmp(i).le.4) then
                  write (lu06,9100) (oparen,stoic7(j,i),cparen,id7(j,i),
     *               j=1,ncmp(i))
                  write (lu03,9100) (oparen,stoic7(j,i),cparen,id7(j,i),
     *               j=1,ncmp(i))
               elseif (ncmp(i).ge.5.and.ncmp(i).le.8) then
                  write (lu06,9110) (oparen,stoic7(j,i),cparen,id7(j,i),
     *               j=1,ncmp(i))
                  write (lu03,9110) (oparen,stoic7(j,i),cparen,id7(j,i),
     *               j=1,ncmp(i))
               elseif (ncmp(i).ge.9.and.ncmp(i).le.12) then
                  write (lu06,9120) (oparen,stoic7(j,i),cparen,id7(j,i),
     *               j=1,ncmp(i))
                  write (lu03,9120) (oparen,stoic7(j,i),cparen,id7(j,i),
     *               j=1,ncmp(i))
               endif
               if (nbcmp(i).gt.0) then
                  write (lu06,9140) (oparen,stoib7(j,i),cparen,idb7(j,i)
     *               ,j=1,nbcmp(i))
                  write (lu03,9140) (oparen,stoib7(j,i),cparen,idb7(j,i)
     *               ,j=1,nbcmp(i))
               endif
            else if (nty1.eq.1) then
               if (reguess(i).eq.'n') then
                 rgflag = 'NO '
               else 
                 rgflag = 'YES'
               end if
               write (lu06,9081) i,id(nty1,i),na(nty1,i),teq(nty1,i),thr
     *            (nty1,i),rgflag
               write (lu03,9081) i,id(nty1,i),na(nty1,i),teq(nty1,i),thr
     *            (nty1,i),rgflag
            else
               write (lu06,9080) i,id(nty1,i),na(nty1,i),teq(nty1,i),thr
     *            (nty1,i)
               write (lu03,9080) i,id(nty1,i),na(nty1,i),teq(nty1,i),thr
     *            (nty1,i)
            endif
         endif
         iaz = 0
         if (n.eq.(nt(nty1)+1).and.morentry.eq.'n') then
            iaz = 99
            go to 270
         endif
         if (nty1.eq.1) then
  170       write (lu06,9220) cont1
            read (lu05,9205,err=170) iaz
            if (iaz.lt.-1.or.iaz.gt.5) go to 170
            write (lu03,9220) cont2,iaz
         elseif (nty1.eq.4) then
  180       write (lu06,9240) cont1
            read (lu05,9205,err=180) iaz
            if (iaz.lt.-1.or.iaz.gt.5) go to 180
            write (lu03,9240) cont2,iaz
         elseif (nty1.eq.7) then
  190       write (lu06,9250) cont1
            read (lu05,9205,err=190) iaz
            if (iaz.lt.-1.or.iaz.gt.8) go to 190
            write (lu03,9250) cont2,iaz
         else
  200       if (id(nty1,n).le.999) then
              write (lu06,9230) cont1
              read (lu05,9205,err=200) iaz
              if (iaz.lt.-1.or.iaz.gt.4) go to 200
              write (lu03,9230) cont2,iaz
	    else 
              write (lu06,9235) cont1
              read (lu05,9205,err=200) iaz
              if (iaz.lt.-1.or.iaz.gt.4) go to 200
              write (lu03,9235) cont2,iaz
            end if
         endif
c
c  -- Branch on option "iaz" selected.
c
         go to (210,260,280,270,290,520,310,350,370,390), iaz+2
c
c  -- Delete entry number n (iaz = -1).
c
 210     if (nty1.eq.1) then
           k = 0
           do 10 i = 1, n123
             if (id123(i).eq.id(nty1,n)) k = i
  10       continue
           if (k.gt.0.and.k.eq.n123) then
             id123(n123) = 0
             n123 = n123 - 1
           else if (k.gt.0.and.k.lt.n123) then
             n123 = n123 - 1
             do 20 i = k, n123
               id123(i) = id123(i+1)
  20         continue
           end if
         end if
         if (n.eq.nt(nty1)) go to 240
         do 230 i = n, nt(nty1)-1
            id(nty1,i) = id(nty1,i+1)
            na(nty1,i) = na(nty1,i+1)
            teq(nty1,i) = teq(nty1,i+1)
            thr(nty1,i) = thr(nty1,i+1)
            if (nty1.eq.1) then
              gfw(i) = gfw(i+1)
              spz(i) = spz(i+1)
            end if
            if (nty1.eq.4) con(i) = con(i+1)
            if (nty1.eq.7) then
               temn7(i) = temn7(i+1)
               temx7(i) = temx7(i+1)
               sp7(i) = sp7(i+1)
               dha7(i) = dha7(i+1)
               dhb7(i) = dhb7(i+1)
               gf7(i) = gf7(i+1)
               alk7(i) = alk7(i+1)
               ncmp(i) = ncmp(i+1)
               nbcmp(i) = nbcmp(i+1)
               do 220 j = 1, 12
                  id7(j,i) = id7(j,i+1)
                  stoic7(j,i) = stoic7(j,i+1)
                  idb7(j,i) = idb7(j,i+1)
                  stoib7(j,i) = stoib7(j,i+1)
  220          continue
            endif
c
  230    continue
  240    nt(nty1) = nt(nty1)-1
         if (nty1.eq.7) then
  250       write (lu06,9370) cont1
            read (lu05,*,err=250) nty1a
            if (nty1a.lt.1.or.nty1a.gt.4) go to 250
            write (lu03,9370) cont2,nty1a
            nty1a = nty1a+1
            nt7(nty1a) = nt7(nty1a)-1
         endif
c
         go to 110
c
c  -- Come here if you're finished with changes to a screen.
c
  260    go to 110
c
c  --
c
  270    call namesp (type(nty1),na(nty1,n))
         if (iaz.ne.99) go to 160
  280    write (lu06,9260) cont1
         read (lu05,*,err=280) id(nty1,n)
         if (id(nty1,n).lt.0.or.id(nty1,n).gt.9999999) go to 280
         write (lu03,9260) cont2,id(nty1,n)
         if (iaz.ne.99) go to 160
  290    if (nty1.ne.1) then
            if (nty1.eq.3.and.id(nty1,n).le.999) then
  300          write (lu06,9150) cont1
               read (lu06,*,err=300) teq(nty1,n)
               write (lu03,9150) cont2,teq(nty1,n)
            else
               call thconst (teq(nty1,n),1,1)
            endif
            go to 510
         endif
  310    if (nty1.eq.1) then
c
c  -- Option (Y or N) to allow MINTEQA2 to make better activity 
c     guesses prior to first iteration.            
           if (iaz.eq.5) then
              write (lu06,9155) cont1
              read (lu06,9015,err=310) ans
              if (ans.eq.'Y') ans = 'y'   
              if (ans.eq.'N') ans = 'n'
              if (ans.ne.'y'.and.ans.ne.'n') go to 310 
              reguess(n) = ans
              write (lu06,9155) cont2,ans
              if (iaz.ne.99) go to 160
           end if  
c
  320       write (lu06,9270) cont1
            read (lu05,*,err=320) tem
            if (tem.lt.0.and.id(nty1,n).ne.330.and.id(nty1,n).ne.001)
     *          then
               go to 320
            endif
            write (lu03,9270) cont2,tem
            teq(nty1,n) = tem
         elseif (nty1.eq.4) then
  330       write (lu06,9280) cont1
            read (lu05,*,err=330) tem
            if (tem.lt.0) go to 330
            write (lu03,9280) cont2,tem
            con(n) = tem
         elseif (nty1.eq.7) then
  340       write (lu06,9290) cont1
            read (lu05,*,err=340) tem
            write (lu03,9290) cont2,tem
            sp7(n) = tem
         endif
         go to 510
  350    if (nty1.eq.7) then
  360       write (lu06,9300) cont1
            read (lu05,*,err=360) tem
            if (tem.lt.0) go to 360
            write (lu03,9300) cont2,tem
            gf7(n) = tem
         endif
         go to 510
  370    if (nty1.eq.7) then
  380       write (lu06,9310) cont1
            read (lu05,*,err=380) tem
            if (tem.lt.0) go to 380
            write (lu03,9310) cont2,tem
            alk7(n) = tem
         endif
         go to 510
  390    if (nty1.eq.7) then
  400       write (lu06,9340) cont1
            read (lu05,9205,err=400) iopt1
            if (iopt1.lt.0.or.iopt1.gt.2) go to 400
            write (lu03,9340) cont2,iopt1
            if (iopt1.eq.0) go to 510
            if (iopt1.eq.1) then
  410          write (lu06,9320) ncmp(n),cont1
               read (lu06,*,err=410) idnew
               if (idnew.lt.0.or.idnew.gt.999) go to 410
               write (lu03,9320) ncmp(n),cont2,idnew
               if (idnew.eq.0) go to 510
  420          write (lu06,9330) cont1
               read (lu06,*,err=420) sto
               write (lu03,9330) cont2,sto
               jindex = 0
               do 430 j = 1, ncmp(n)
                  if (idnew.eq.id7(j,n)) then
                     jindex = j
                  endif
  430          continue
               if (abs(sto).lt.R0MIN) then
                  if (jindex.ge.1.and.jindex.lt.ncmp(n)) then
                     do 440 j = jindex, ncmp(n)-1
                        id7(j,n) = id7(j+1,n)
                        stoic7(j,n) = stoic7(j+1,n)
  440                continue
                  endif
                  id7(ncmp(n),n) = 0
                  stoic7(ncmp(n),n) = 0.0
                  ncmp(n) = ncmp(n)-1
               else
                  if (jindex.ge.1.and.jindex.le.ncmp(n)) then
                     stoic7(jindex,n) = sto
                  else
                     if (ncmp(n)+1.le.12) then
                        ncmp(n) = ncmp(n)+1
                        id7(ncmp(n),n) = idnew
                        stoic7(ncmp(n),n) = sto
                     else
                        write (lu06,9350)
                        write (lu03,9350)
                        go to 390
                     endif
                  endif
               endif
            else
  450          write (lu06,9320) nbcmp(n),cont1
               read (lu06,*,err=450) idnew
               if (idnew.lt.0.or.idnew.gt.999) go to 450
               write (lu03,9320) nbcmp(n),cont2,idnew
               if (idnew.eq.0) go to 510
  460          write (lu06,9330) cont1
               read (lu06,*,err=460) sto
               write (lu03,9330) cont2,sto
               jindex = 0
               if (nbcmp(n).eq.0) go to 480
               do 470 j = 1, nbcmp(n)
                  if (idnew.eq.idb7(j,n)) then
                     jindex = j
                  endif
  470          continue
  480          if (abs(sto).lt.R0MIN) then
                  if (jindex.ge.1.and.jindex.lt.nbcmp(n)) then
                     do 490 j = jindex, nbcmp(n)-1
                        idb7(j,n) = idb7(j+1,n)
                        stoib7(j,n) = stoib7(j+1,n)
  490                continue
                  endif
                  idb7(nbcmp(n),n) = 0
                  stoib7(nbcmp(n),n) = 0.0
                  nbcmp(n) = nbcmp(n)-1
               else
                  if (jindex.ge.1.and.jindex.le.nbcmp(n)) then
                     stoib7(jindex,n) = sto
                  else
                     if (nbcmp(n)+1.le.3) then
                        imatch = 'n'
                        do 500 ii = 1, ncmp(n)
                           if (idnew.eq.id7(ii,n)) imatch = 'y'
  500                   continue
                        if (imatch.eq.'y') then
                           nbcmp(n) = nbcmp(n)+1
                           idb7(nbcmp(n),n) = idnew
                           stoib7(nbcmp(n),n) = sto
                        else
                           write (lu06,9390)
                           write (lu03,9390)
                           go to 390
                        endif
                     else
                        write (lu06,9360)
                        write (lu03,9360)
                        go to 390
                     endif
                  endif
               endif
            endif
         endif
  510    if (iaz.ne.99) go to 160
  520    if (nty1.ne.1) call thconst (thr(nty1,n),2,1)
         if (nty1.eq.1) thr(nty1,n) = fguess('LOG10(ACTIVITY)     ',1,
     *      thr(nty1,n))
         if (iaz.ne.99) go to 160
         call speadd (nty1,id(nty1,n),na(nty1,n),teq(nty1,n),thr(nty1,n)
     *      ,tem,ddd,1,1,ifg,1)
         if (ifg.eq.1) go to 530
         go to 160
  530 continue
      return
c
c
 9000 format (' No ',a16,' (TYPE ',i1,') have been defined.')
 9010 format (/)
 9015 format (a1)
 9020 format (' ___________________________________________________',
     *   '____________________________',/,
     *   '    ____________________________ EDIT LEVEL III ____',
     *   '_______________PROB # ',i2,'_   ',/,
     *   '       ___________ Verify or change listing of ',a16,
     *   ' __________      ',/)
 9030 format (' Entry',5x,'I.D.',6x,'Name',14x,'Total Conc.',3x,
     *   'Log Act.(GUESS)',3x,'Improve ?')
 9040 format (' Entry',5x,'I.D.',6x,'Name',17x,'Log K',8x,'Enthalpy')
 9050 format (' Entry',5x,'I.D.',6x,'Name',11x,'Concentration',2x,
     *   'Log K',4x,'Enthalpy')
 9060 format (' Entry',5x,'I.D.',8x,'Name',7x,'Log K',3x,'Enthalpy',3x,
     *   'Charge',3x,'gfw',4x,'Alk. Factor')
 9070 format (' Entry',5x,'I.D.',6x,'Name')
 9080 format (' ',i3,4x,i7,3x,a18,1x,1pe12.5,4x,e12.5)
 9081 format (' ',i3,4x,i7,3x,a18,1x,1pe12.5,7x,0pf7.2,10x,a3)
 9090 format (' ',1x,i3,4x,i7,2x,a12,1x,f8.3,2x,f7.2,5x,f4.1,2x,f8.3,4x,
     *   f5.2)
 9100 format ('          Stoichiometry: ',4(a1,f6.3,a1,i3,2x))
 9110 format ('          Stoichiometry: ',4(a1,f6.3,a1,i3,2x),/,
     *   '                         ',4(a1,f6.3,a1,i3,2x))
 9120 format ('          Stoichiometry: ',4(a1,f6.3,a1,i3,2x),/,
     *   '                         ',4(a1,f6.3,a1,i3,2x),/,
     *   '                         ',4(a1,f6.3,a1,i3,2x))
 9130 format (' ',i3,4x,i7,3x,a18)
 9140 format ('         *Stoichiometry: ',3(a1,f6.3,a1,i3,2x))
 9150 format (/,a1,' Enter the negated log activity (usually',
     *             ' a POSITIVE number) > ',f7.3)
 9155 format (/,' Enter Y or N for optional activity guess',
     *          ' refinement in MINTEQA2',
     *        /,a1,' prior to first iteration. > ',1x,a1)
 9170 format (' ',i3,4x,i7,2x,a18,1x,1pe12.5,2x,0pf8.3,2x,f7.2)
 9180 format (/' *** WARNING: Species ID# ',i7,' appears more',
     *   ' than once.',/)
 9190 format ('                   *** MORE ENTRIES TO FOLLOW ***')
 9200 format (a1,' Enter entry # to change or delete (press',
     *   ' ENTER to accept all entries) >',1x,i2)
 9205 format (i2)
 9210 format ('  There are more entries of this type yet to be',
     *   ' displayed.  Please wait until',/,
     *   '  all have been displayed before adding others.')
 9220 format (/,'  Select:',/,'   -1 = Delete this component',
     *   /,'    1 = Change ID number',
     *   /,'    2 = Change name',/,'    3 = Change total concentration',
     *   /,'    4 = Change log activity guess',
     *   /,'    5 = Allow MINTEQA2 to improve the guess BEFORE',
     *             ' iterating',/,a1,
     *   '      Enter choice (Press ENTER to accept all values and',
     *   ' return): > ',i2)
 9230 format (/,'  Select:',/,
     *     '   -1 = Delete this species',
     *   /,'    1 = Change the ID number',
     *   /,'    2 = Change the name',
     *   /,'    3 = Change the log activity (entered as the negative',
     *     ' of the log activity',
     *   /,'    4 = Change the enthalpy',/,a1,
     *   '      Enter choice (Press ENTER to accept all values and',
     *   ' return): > ',i2)

 9235 format (/,'  Select:',/,
     *     '   -1 = Delete this species',
     *   /,'    1 = Change the ID number',
     *   /,'    2 = Change the name',
     *   /,'    3 = Change the log K',
     *   /,'    4 = Change the enthalpy',/,a1,
     *   '      Enter choice (Press ENTER to accept all values and',
     *   ' return): > ',i2)
 9240 format (/,'  Select:',
     *   /,'   -1 = Delete this species',
     *   /,'    1 = Change ID number',
     *   /,'    2 = Change name',
     *   /,'    3 = Change log K',
     *   /,'    4 = Change enthalpy',
     *   /,'    5 = Change amount (concentration)',/,a1,
     *   '      Enter choice (Press ENTER to accept all values and',
     *   ' return): > ',i2)
 9250 format (/,'  Select:',/,'   -1 = Delete this species',
     *   /,'    1 = Change ID number',
     *   /,'    2 = Change name',/,'    3 = Change log K',/,
     *   '    4 = Change enthalpy',/,'    5 = Change charge',/,
     *   '    6 = Change gram formula wt.',/,
     *   '    7 = Change alkalinity factor',/,
     *   '    8 = Change stoichiometry',/,a1,
     *   '      Enter choice (Press ENTER to accept all values and',
     *   ' return): > ',i2)
 9260 format (/,'  Enter the new id number.  Remember that this',
     *   ' id number must be unique within',/,a1,' the database > ',1x,
     *   i8)
 9270 format (/,a1,' Enter the TOTAL dissolved concentration for this',
     *   ' component > ',e12.5)
 9280 format (/,a1,' Enter the amount of this solid in moles > ',e12.5)
 9290 format (/,a1,' Enter the charge on this species > ',e12.5)
 9300 format (/,a1,' Enter the gram formula weight of this species > ',
     *   e12.5)
 9310 format (/,a1,' Enter the alkalinity factor for this species > ',
     *   e12.5)
 9320 format ('  There are ',i2,' components currently in this',
     *   ' reaction.',/,
     *   '  - To change the stoichiometry of a current component',
     *   ' or to add a new',/,
     *   '    component, enter the component id number.  You will',
     *   ' be prompted for the',/,'    stoichiometry.',/,
     *   '  - To delete a current component, enter its id number',
     *   ' then enter zero for its',/,'    stoichiometry.',/,
     *   '  - To return to prior menu without making changes,',
     *   ' enter zero for the id number.',/,a1,
     *   '    ENTER component id > ',i3)
 9330 format (/,a1,'    ENTER stoichiometry > ',f7.3)
 9340 format (/,'  There are two groups of stoichiometry/component id',
     *   ' pairs for each reaction.'/,
     *   '  The main group, which allows up to 12 pairs,',
     *   ' ordinarily represents the',/,
     *   '  stoichiometry of each component for both mass',
     *   ' action and mass balance, these',/,
     *   '  being equal.  Sometimes however, it is useful to',
     *   ' specify a mass balance',/,
     *   '  stoichiometry for one or more components that is',
     *   ' not equal to its mass',/,
     *   '  action counterpart.  The second group of',
     *   ' stoichiometry/component id pairs,',/,
     *   '  which allows up to 3 pairs, represents the mass',
     *   ' balance stoichiometry',/,
     *   '  for those components.  The main group is labeled',
     *   ' "Stoichiometry" in the',/,
     *   '  listing of added species while the second group,',
     *   ' present only in special cases',/,
     *   '  such as a Freundlich adsorption reaction, is',
     *   ' labeled "*Stoichiometry".',//,'  Select an option:',/,
     *   '    1 = Change, add to, delete from Stoichiometry',/,
     *   '    2 = Change, add to, delete from *Stoichiometry',/,a1,
     *   '      Enter choice (Press ENTER to return): > ',i2)
 9350 format (/,'  Sorry, each species is limited to 12 Stoichiometry',
     *   ' components.',/,'  The requested component was NOT added.')
 9360 format (/,'  Sorry, each species is limited to 3 *Stoichiometry',
     *   ' components.',/,'  The requested component was NOT added.')
 9370 format (/,'     To which category does this species belong ?',/,
     *   '        1 = Aqueous or adsorbed species',/,
     *   '        2 = Infinite solid or gas species or redox couple',
     * /,'        3 = Finite solid species',/,
     *   '        4 = Allowed or potential solid species',/,a1,
     *   '         Enter category: > ',i1)
 9380 format (/,'  *Stoichiometry represents the mass balance',
     *   ' stoichiometry for those',/,
     *   '  components whose mass balance and mass action',
     *   ' stoichiometries differ.')
 9390 format (/,'  Only those components whose mass action',
     *   ' stoichiometries have already',/,
     *   '  been defined for this reaction are eligible for',
     *   ' designating as having',/,
     *   '  different mass balance stoichiometry.')
 8010 format (a1,'  Press ENTER to continue')
c
      end
