      subroutine editlvl4
c
c  -- The purpose of this routine is to present the user with options
c     to:
c      1)  Specify that the total concentration or fixed log activity
c          of one component only is to be systematically varied in
c          a series of otherwise identical problems.
c
c      2)  Specify that the equilibrated mass distribution (computed
c          by MINTEQA2) of up to six user selected components (in
c          units of concentration or in percent) OR the equilibrium
c          concentrations of up to six user selected species be written
c          to a user designated file in a format appropriate for import
c          by popular spreadsheet programs.
c
c
      include 'PRODEFA2.INC'
c
  100 call clrscr (lu06)
      write (lu06, 9000) iprb
      write (lu03, 9000) iprb
      write (lu06, 9010) cont1
      read (lu05,9060,err=100) ans
      if (ans.eq.'r') ans = 'R'
      if (ans.ne.'1'.and.ans.ne.'2'.and.ans.ne.'R'.and.ans.ne.' ')
     *    go to 100
      write (lu03,9010) cont2, ans
      if (ans.eq.'1') then
        call sweepr
      else if (ans.eq.'2') then
        call mport123
      else if (ans.eq.'R'.or.ans.eq.' ') then
        go to 999
      end if
      go to 100
  999 return
c
 9000 format (' _____________________________________________________',
     *   '_________________________',/,
     *   '    ____________________________ EDIT LEVEL IV ____',
     *   '______________PROB # ',i2,'_   ',/
     *   '       ________________________ SELECT  OPTION ___________',
     *   '_____________')
 9010 format (//,
     *   '  1 = Specify that the total concentration or fixed log',
     *   ' activity of',
     * /,'      one component only is to be systematically varied in',
     *   ' a series of',
     * /,'      otherwise identical problems.',
     *//,'  2 = Specify that the equilibrated mass distribution',
     *   ' of up to six components,',
     * /,'      OR the equilibrium concentrations of up to six',
     *   ' aqueous species',
     * /,'      be written to a file importable by popular spreadsheet',
     *   ' programs.',
     *//,'  R = Return to MAIN MENU',
     *//,a1,'       ENTER CHOICE ([D] = R) > ',1x,a1)
 9060 format (a1)
c
      end
c
      subroutine sweepr
c
c  -- The purpose of this subroutine is to provide opportunity
c     to specify that the total concentration or fixed log
c     activity of one component be systematically varied through
c     a specified range in a series of MINTEQA2 problems where
c     all other input variables and parameters are constant.
c     pH and pE are entered as pH and pE rather than as fixed
c     log activity (i.e., they are not entered as negative values).
c     A component thus designated will be referred to hereafter as
c     a sweep component and we will refer to sweeping over total
c     concentration or over fixed log activity.
c
c  -- The sweep parameters.  These include:
c     1)  SWEEP OBJECT (total concentration, fixed log activity, pH,
c         or pE),
c     2)  SWEEP VALUES (may be in the form of a starting value,
c         incremental value, and the number of values or as a series
c         of explicitly entered values.
c
      include 'PRODEFA2.INC'
      character namswp*8, nam*20, ans2*1, ans3*1, osweep*10, namx*8,
     *          titl1*29, ctmp*4
      integer icheck
      include 'CONST.INC'
c
c  -- For modification of an existing file, if that file has a
c     sweep component designated, it will be identified only
c     by id number so find out its name.
      namswp = '- NONE -'
      if (isweep.gt.0) then
        do 225 j = 1, nt(1)
          if (id(1,j).eq.idsweep) then
             namswp = na(1,j)
             jsave = j
             go to 226
          end if
  225   continue
  226 	    do 227 k = 1, nt(3)
          if (id(3,k).eq.idsweep) then
             namswp = na(3,k)
             ksave = k
             go to 228
          end if
  227   continue
  228   continue 
        if (sweep.eq.'TOTAL CONC') then
          startval = teq(1,jsave)
        else if (sweep.eq.'ACTIVITY  ') then
          startval = teq(3,ksave)
        end if 
        if (isweep.eq.2) uvalue(1) = startval
      end if
c
c  -- Display currrent status of parameters for this option.
  100 if (idsweep.gt.0.and.sweep.ne.' '.and.nprob.gt.1) 
     *  call swpstat (namswp)
c
c  -- Display menu of options for changing the sweep parameters,
c     cancelling, or simply returning to the previous menu level.
      if (idsweep.le.0) then
        ans = '1'
      else if (idsweep.gt.0.and.sweep.eq.' ') then
        ans = '3'
      else if (idsweep.gt.0.and.sweep.ne.' '.and.nprob.le.1) then
        ans = '2'  
      else 
        write (lu06, 9015) cont1
        read (lu05,9060,err=100) ans
        if (ans.eq.'r') ans = 'R'
        if (ans.eq.'c') ans = 'C'
        if (ans.ne.'1'.and.ans.ne.'2'.and.ans.ne.'3'.and.ans.ne.'C'
     *     .and.ans.ne.'R'.and.ans.ne.' ') go to 100
        write (lu03,9015) cont2, ans
      end if
c
      if (ans.eq.'1') then
c  -- Specify or change the sweep component.
c     Identify the sweep component by calling IDCOMP allowing 
c     specification of the id number or the first letter of its
c     chemical symbol.
  801    call clrscr (lu06)
c  -- Display currrent status of parameters for this option.
         if (idsweep.gt.0.and.sweep.ne.' '.and.nprob.gt.1) 
     *      call swpstat (namswp)
         write (lu06,8015) 
         write (lu03,8015) 
         idj = 0
         call idcomp (1,nam,idx,idj)
         if (idj.eq.(-1)) then
           if (idsweep.eq.0) go to 999
         end if
         namx = nam
c
c  -- Check to be sure that the component specified has already been
c     specified as an AQUEOUS COMPONENT in this problem.  Disallow
c     if not.
         icheck = 0
         jsave = 0
         ksave = 0
         do 130 j = 1, nt(1)
           if (id(1,j).eq.idx) then
              do 135 k = 1, nt(3)
                if (id(3,k).eq.idx) then
                  ksave = k 
                  go to 136            
                end if 
  135         continue
  136         continue 
              jsave = j
              icheck = icheck + 1
              go to 133
           end if
  130    continue
  133    continue
c 
         if (icheck.ne.1) then
           write (lu06,9110) idx,namx
           write (lu03,9110) idx,namx
           write (lu06,9100) cont1
           write (lu03,9100) 
           read (lu05,*)
           go to 100
         end if
c
c  -- Ask whether sweep is to be over total concentration or fixed 
c     equilibrium activity.  If the former, continue.  
c     If the latter, test whether the sweep component is fixed (TYPE 3).
c     If so, set sweep = 'ACTIVITY  ' and continue.  If not, report that
c     user must return to EDIT LEVEL I or II to fix the chosen component
c     before this option can be implemented.  Upon <CR>, 
c     return to main sweep menu with all parameters as before.
c  -- TOTAL CONC or ACTIVITY ?
  901    write (lu06,9300) cont1
         read (lu05,9060,err=901) ans3
         if (ans3.eq.'r') ans3 = 'R'
         if (ans3.ne.'1'.and.ans3.ne.'2'.and.ans3.ne.'R'.and.
     *       ans3.ne.' ') go to 901
         write (lu03,9300) cont2, ans3
c
c  -- Response of '1' means TOTAL CONC
         if (ans3.eq.'1'.or.ans3.eq.' ') then
           sweep = 'TOTAL CONC'
           go to 910
c
c  -- Response of '2' means ACTIVITY
         else if (ans3.eq.'2') then 
c  -- Ksave greater than zero means the specified component is fixed.
           if (ksave.gt.0) then
             sweep = 'ACTIVITY  '
           else     
             write (lu06,8005) 
             write (lu03,8005) 
             write (lu06,9100) cont1
             write (lu03,9100) 
             read (lu05,*)
             go to 100
           end if
c
c  -- Response of 'R' means return to previous query.
         else if (ans3.eq.'R') then 
           go to 801 
         end if
c  -- Report acceptance of component.
  910    idsweep = idx
         namswp = namx
         if (sweep.eq.'TOTAL CONC') then
           startval = teq(1,jsave)
         else if (sweep.eq.'ACTIVITY  ') then
           if (ksave.eq.0) then
             write (lu06,8005) 
             write (lu03,8005) 
             write (lu06,9100) cont1
             write (lu03,9100) 
             read (lu05,*)
             go to 100
           end if
           startval = teq(3,ksave)
         end if 
         if (isweep.eq.2) uvalue(1) = startval
         nprob = 1
c
      else if (ans.eq.'3') then
c  -- Specify or change the sweep object.
         osweep = sweep
 200     call clrscr (lu06)
c  -- Display currrent status of parameters for this option.
         if (idsweep.gt.0.and.sweep.ne.' '.and.nprob.gt.1) 
     *       call swpstat (namswp)
         if (namswp.eq.'- NONE -') then
           write (lu06,8000) 
           write (lu03,8000) 
           write (lu06,9100) cont1
           write (lu03,9100) 
           read (lu05,*)
           go to 100
         end if
c            
         write (lu06,9300) cont1
         read (lu05,9060,err=200) ans2
         if (ans2.eq.'r') ans2 = 'R'
         if (ans2.ne.'1'.and.ans2.ne.'2'.and.ans2.ne.'R') go to 200
         write (lu03,9300) cont2, ans2

c
c  -- Response of '1' means TOTAL CONC
         if (ans2.eq.'1') then
           sweep = 'TOTAL CONC'
           if (sweep.eq.osweep) go to 100
           if (osweep.eq.'ACTIVITY  ') then
             write (lu06,9305)
             write (lu03,9305)
             write (lu06,9100) cont1
             write (lu03,9100) 
             read (lu05,*)
           end if
c
c  -- Response of '2' means ACTIVITY
         else if (ans2.eq.'2') then
           sweep = 'ACTIVITY  '
           if (sweep.eq.osweep) go to 100
           if (ksave.eq.0) then
             sweep = osweep
             write (lu06,8005) 
             write (lu03,8005) 
             write (lu06,9100) cont1
             write (lu03,9100) 
             read (lu05,*)
c             idsweep = 0
c             namswp = '- NONE -'  
             go to 100
           end if
           if (osweep.eq.'TOTAL CONC') then
             write (lu06,9305)
             write (lu03,9305)
             write (lu06,9100) cont1
             write (lu03,9100) 
             read (lu05,*)
           end if
c
c  -- Response of 'R' means return to previous query.
         else if (ans2.eq.'R') then
           go to 100
         end if
c
         if (sweep.eq.'TOTAL CONC') then
           startval = teq(1,jsave)
         else if (sweep.eq.'ACTIVITY  ') then
           startval = teq(3,ksave)
         end if 
c
         if (isweep.eq.2) uvalue(1) = startval
         valinc = 0.0
c
         do 800 i = 2, nprob
           uvalue(i) = 0.0
  800    continue
c 
        nprob = 1 
c
      else if (ans.eq.'2') then
  210    call clrscr (lu06)
c  -- Display current status of parameters for this option.
         if (idsweep.gt.0.and.sweep.ne.' '.and.nprob.gt.1) 
     *      call swpstat (namswp)
         if (namswp.eq.'- NONE -') then
           write (lu06,8000) 
           write (lu03,8000) 
           write (lu06,9100) cont1
           write (lu03,9100) 
           read (lu05,*)
           go to 100
         end if
c  -- Ask how many values to sweep (must be between zero and
c     twenty.  A response of 0 returns to the main sweep menu
c     after notifiying the user that this is equivalent
c     to not sweeping at all and recommends choosing option C
c     from the main sweep menu if that is what is desired.  An entry
c     of 0 does not effect the value of nprob.
         write (lu06,9310) cont1
         read (lu05,*,err=210) itemp
         if (itemp.lt.0.or.itemp.gt.20) go to 210
         write (lu03,9310) cont2, itemp
         if (itemp.le.1) then
           idsweep = 0
           isweep = 0
           nprob = 0
           namswp = '- NONE -'
           go to 999
         end if
         nprob = itemp
c
c  -- Put up menu from which the user is to select the option of
c     specifying the nprob values by entering a new starting value and
c     an incremental value or by entering nprob explicit values.
  220    if (sweep.eq.'TOTAL CONC') then
           titl1 = 'Total Concentration values:'
         else if (sweep.eq.'ACTIVITY  ') then
           if (idsweep.eq.330) then
             titl1 = 'pH values:'
           else if (idsweep.eq.001) then
             titl1 = 'pE values:'
           else 
             titl1 = 'negative log activity values:'
           end if
         end if
         write (lu06,9320) nprob,titl1,cont1
         read (lu05,9060,err=220) ans2
         if (ans2.eq.'r') ans2 = 'R'
         if (ans2.ne.'1'.and.ans2.ne.'2'.and.ans2.ne.'R'.and.
     *       ans2.ne.' ') go to 220
         write (lu03,9320) nprob,titl1,cont2,ans2
         if (ans2.eq.'R') go to 210
c
c  -- Specify values by entering a new starting value and increment.
c     Returns to main sweep menu after these values are acquired.
c  -- Give opportunity to specify or change the starting value and
c     incremental value.
c  -- Confirm the current starting value.
         do 715 j = 1, nt(1)
           if (id(1,j).eq.idsweep) then
             namswp = na(1,j)
             jsave = j
             go to 716
           end if
  715    continue
  716    do 717 k = 1, nt(3)
           if (id(3,k).eq.idsweep) then
             namswp = na(3,k)
             ksave = k
             go to 718
           end if
  717    continue
  718    continue 
         if (sweep.eq.'TOTAL CONC') then
           startval = teq(1,jsave)
         else if (sweep.eq.'ACTIVITY  ') then
           startval = teq(3,ksave)
         end if 
         if (isweep.eq.2) uvalue(1) = startval
c  -- Obtain the new starting value.
         if (sweep.eq.'TOTAL CONC') then
 721       write (lu06,7770) startval,cont1
           read (lu05,9060,err=721) ans3
           if (ans3.eq.'y') ans3 = 'Y'
           if (ans3.eq.'n') ans3 = 'N'
           if (ans3.ne.'Y'.and.ans3.ne.'N') go to 721          
           write (lu03,7770) startval,cont2,ans3
           if (ans3.eq.'Y') then
             uvalue(1) = startval
             go to 722
           end if
 230       write (lu06,9330) cont1
           read (lu05,*,err=230) startval
           if (startval.lt.0.0.and.idsweep.ne.330
     *         .and.idsweep.ne.001) go to 230
           write (lu03,9330) cont2,startval
           uvalue(1) = startval
           act = startval
           if (uvalue(1).gt.0.0) go to 233
  234      write (lu06,9360) cont1,namswp
           read (lu05,*,err=234) act
           if (act.gt.3.0) go to 234
           write (lu03,9360) cont2,namswp
           go to 235
c	  
c --  Compute activity in molal
  233      if (iflag.ne.1) act = 0.001 * uvalue(1)
           if (iflag.eq.2) act = act / (denh2o * gf0(j))
           if (iflag.eq.3) act = act / gf0(j)
           if (iflag.eq.4.and.abs(ch0(j)).gt.R0MIN)
     *         act = act / (denh2o * abs(ch0(j)))
           if (act.gt.R0MIN) then
              act = log10(act)
           else 
              go to 235
           end if
  235      continue
           teq(1,jsave) = uvalue(1)
           thr(1,jsave) = act
  722      continue
         else if (sweep.eq.'ACTIVITY  ') then
           ctmp = 'p[X]'
           if (idsweep.eq.330) ctmp = 'pH' 
           if (idsweep.eq.001) ctmp = 'pE' 
 723       write (lu06,7780) ctmp, startval, cont1
           read (lu05,9060,err=723) ans3
           if (ans3.eq.'y') ans3 = 'Y'
           if (ans3.eq.'n') ans3 = 'N'
           if (ans3.ne.'Y'.and.ans3.ne.'N') go to 723          
           write (lu03,7780) ctmp, startval, cont2, ans3
           if (ans3.eq.'N') then
             uvalue(1) = startval
             go to 724
           end if
  236      write (lu06,9363) cont1, ctmp               
           read (lu05,*,err=236) startval
           write (lu03,9363) cont2, ctmp, startval
           uvalue(1) = startval
           thr(1,jsave) = (-1) * uvalue(1)
           teq(3,ksave) = uvalue(1)
 724       continue
         end if
         if (ans2.eq.'1'.or.ans2.eq.' ') then 
           isweep = 1
c  -- Obtain the incremental value.
 240       write (lu06,9340) cont1
           read (lu05,*,err=240) valinc
           write (lu03,9340) cont2,valinc
           if (abs(valinc).lt.R0MIN) then
             idsweep = 0
             isweep = 0
             nprob = 0
             namswp = '- NONE -'
             go to 999
           end if
c	   
c  -- Specify values by entering them explicitly in a list separating
c     them by commas.
         else if (ans2.eq.'2') then
           isweep = 2
c
           if (sweep.eq.'TOTAL CONC') then
             ctmp = '  '  
 250         write (lu06,9350) nprob-1,ctmp,cont1
             read (lu05,*,err=250) (uvalue(i),i=2,nprob)
             do 500 i = 1, nprob
               if (uvalue(i).lt.0.0.and.idsweep.ne.330
     *           .and.idsweep.ne.001) go to 250
 500         continue
             write (lu03,9350) nprob-1,ctmp,cont2,(uvalue(i),i=2,nprob)
           else if (sweep.eq.'ACTIVITY  ') then
             ctmp = 'p[X]'    
             if (idsweep.eq.330) ctmp = 'pH' 
             if (idsweep.eq.001) ctmp = 'pE' 
 290         write (lu06,9350) nprob-1,ctmp,cont1
             read (lu05,*,err=290) (uvalue(i),i=2,nprob)
             write (lu03,9350) nprob-1,ctmp,cont2,(uvalue(i),i=2,nprob)
           end if
         end if
      else if (ans.eq.'C') then
c  -- Cancel the sweep option, re-set all sweep parameters to initial
c     values.
         sweep =  ' '
         isweep = 0
         idsweep = 0
         nprob = 0
         startval = 0.0
         valinc = 0.0
         do 810 i = 1, 24
           uvalue(i) = 0.0
 810     continue
         namswp = '- NONE -'
         go to 999
c
      else if (ans.eq.'R'.or.ans.eq.' ') then
         if (idsweep.eq.0.or.sweep.eq.' '
     *      .or.(isweep.eq.1.and.abs(valinc).lt.R0MIN)
     *      .or.nprob.eq.0) then
           call clrscr (lu06)
           write (lu06,9090)
           write (lu03,9090)
           write (lu06,9100) cont1
           write (lu03,9100) 
           read (lu05,*)
         end if
c  -- Return to previous menu without making anymore changes.
         go to 999
c
      end if
      go to 100
  999 return
 9015 format (/,'  1 = Change the SWEEP COMPONENT',
     */,'  2 = Change the NUMBER OF VALUES or the VALUES',
     */,'  3 = Change whether the values represent TOTAL DISSOLVED',
     *  ' CONCENTRATION',
     */,'      or FIXED EQUILIBRIUM ACTIVITY (values entered as',
     *  ' negative log activity,',
     */,'      e.g., pH, pE, or in general, p[X])',
     */,'  R = ACCEPT current settings and RETURN to EDIT LEVEL IV',
     *  ' main menu',
     */,'  C = CANCEL current settings and RETURN to EDIT LEVEL IV',
     *  ' main menu',
     */,a1,'       ENTER CHOICE ([D] = R) > ',1x,a1)
 9060 format (a1)
 9090 format (/,' ***** Since not all of the required parameters for',
     *           ' this option have been',
     *        /,' specified, it will NOT be implemented. *****')
 9100 format (a1,'  Press ENTER to continue')
 9110 format (/,' *** Component id number ',i3,' (',a8,') has not',
     *          ' been specified as an',
     *        /,' AQUEOUS COMPONENT in this problem.  RE-SPECIFY but',
     *          ' remember to select',
     *        /,' a component that you have already specified as an',
     *          ' AQUEOUS COMPONENT.',
     *        /,' You may wish to return to EDIT LEVEL II to specify',
     *          ' other AQUEOUS COMPONENTS.')
 9300 format (/,'      Indicate what the values are to represent:',
     *        /,'        1 = Total Concentration',
     *        /,'        2 = Fixed Equilibrium Activity (values',
     *          ' entered as negative log activity,',
     *        /,'            e.g., pH, pE, or in general, p[X])',
     *        /,'        R = Return to previous question,'
     *        /,a1,'          ENTER CHOICE ([D] = 1) > ',1x,a1)
 9305 format (/,' WARNING:  Having changed their meaning, you must',
     *          ' re-specify any previously',
     *        /,' specified VALUES to insure that they are',
     *          ' appropriate.')
 9310 format (/,' Enter the the number of values.  Range: 2 to 20',
     *          ' values;',
     *        /,' An entry of one (1) or zero (0) ABORTS sweep.',
     *     /,a1,'       Enter number of values > ',1x,i2)
 9320 format (/,' Choose the method of entering the ',i2,' ',a29,
     *        /,'   1 = Specify a starting value and a constant',
     *          ' incremental value',
     *        /,'   2 = Specify the values explicitly',
     *        /,'   R = Return to previous question',
     *     /,a1,'     ENTER CHOICE ([D] = 1) > ',1x,a1)
 9330 format (/,a1,' Enter the new starting total concentration > ',
     *        1x,e10.3)
 9340 format (/,' Enter the increment between desired values.',
     *        /,' An entry of zero (0) ABORTS sweep.',
     *     /,a1,'       Enter increment > ',1x,e10.3)
 9350 format (/,' Enter the next ',i2,' successive ',a4,' values',
     *          ' separating them from one another',
     *     /,a1,' with commas or spaces > ',1x,1(1pe10.3))
 9360 format (/,a1,' Enter the starting log activity guess for ',a12, 
     *             ' in MOLAL > ',e12.5)
 9363 format (/,a1,' Enter the starting ',a4,' > ',e12.5)
 8000 format (/,' YOU MUST ENTER A VALID SWEEP COMPONENT ID BEFORE',
     *          ' USING THIS OPTION.')
 8005 format (/,' THE COMPONENT SPECIFIED IS NOT CURRENTLY FIXED.  IF',
     *          ' YOU WISH IT TO BE,',
     *        /,' YOU MAY RETURN TO EDIT LEVEL I OR II AND MAKE',
     *          ' IT SO.') 
 8015 format (/,' SPECIFY THE SWEEP COMPONENT:')
 7770 format (/,' The current starting TOTAL CONCENTRATION is: ',
     *        1pe10.3,
     *        /,a1,' Is this correct ? ',1x,a1)
 7780 format (/,' The current starting ',a4,' is: ',f5.2,
     *        /,a1,' Do you want to change this value? ',1x,a1)
      end							    
      subroutine swpstat (namswp)
c
      include 'PRODEFA2.INC'
      character namswp*8 
c
      call clrscr (lu06)
      continue
      write (lu06, 9000) iprb
      write (lu03, 9000) iprb
      write (lu06,9200) namswp
      write (lu03,9200) namswp
      if (sweep.eq.'ACTIVITY  '.and.idsweep.ne.330.and.idsweep.ne.001)
     * then
         write (lu06,9210)
         write (lu03,9210)
      else if (sweep.eq.'ACTIVITY  '.and.idsweep.eq.330) then
         write (lu06,9220)
         write (lu03,9220)
      else if (sweep.eq.'ACTIVITY  '.and.idsweep.eq.001) then
         write (lu06,9230)
         write (lu03,9230)
      else if (sweep.eq.'TOTAL CONC') then
         write (lu06,9240)
         write (lu03,9240)
      end if
      write (lu06,9250) nprob
      write (lu03,9250) nprob
      if (sweep.eq.'TOTAL CONC') then
        if (isweep.eq.1) then
          write (lu06,9260) startval
          write (lu06,9265) valinc
          write (lu03,9260) startval
          write (lu03,9265) valinc
        else if (isweep.eq.2) then
          write (lu06,9270)
          write (lu06,9275) (uvalue(i),i=1,nprob)
          write (lu03,9270)
          write (lu03,9275) (uvalue(i),i=1,nprob)
        end if
      else if (sweep.eq.'ACTIVITY  ') then
        if (isweep.eq.1) then
          write (lu06,9280) startval
          write (lu06,9285) valinc
          write (lu03,9280) startval
          write (lu03,9285) valinc
        else if (isweep.eq.2) then
          write (lu06,9270)
          write (lu06,9290) (uvalue(i),i=1,nprob)
          write (lu03,9270)
          write (lu03,9290) (uvalue(i),i=1,nprob)
        end if
      end if
      write (lu06,9295)
      write (lu03,9295)
c
      return 
c
 9000 format (' _____________________________________________________',
     *   '_________________________',/,
     *   '    ____________________________ EDIT LEVEL IV ____',
     *   '______________PROB # ',i2,'_   ',/
     *   '       ________________________ SWEEP  UTILITY _________',
     *   '_____________')
 9200 format (/,'       >>>>>>>  CURRENT SETTINGS for Sweep',
     *           ' Component ',a8,'  <<<<<<<')
 9210 format (/,'     Series of values represent:  FIXED LOG ACTIVITY')
 9220 format (/,'     Series of values represent:  pH')
 9230 format (/,'     Series of values represent:  pe')
 9240 format (/,'     Series of values represent:  TOTAL CONCENTRATION')
 9250 format ('     Number of values:           ',i2)
 9260 format ('     Starting value:             ',1pe10.3)
 9265 format ('     Incremental value:          ',1pe10.3)
 9270 format ('                          ------ VALUES ------')
 9275 format (5x,5(2x,1pe10.3)/,5x,5(2x,1pe10.3)/,5x,5(2x,1pe10.3)/,
     *        5x,5(2x,1pe10.3))
 9280 format ('     Starting value:            ',f6.2)
 9285 format ('     Incremental value:         ',f6.2)
 9290 format (5x,6(2x,f6.2)/,5x,6(2x,f6.2)/,5x,6(2x,f6.2),
     *      /,5x,6(2x,f6.2))
 9295 format (/,'       _________________________  OPTIONS  ________',
     *        '_________________')
c
      end
      subroutine mport123
c
c  -- The purpose of this routine is to query the user for the
c     name of the ASCII importable output file to be created
c     (or appended to if it already exists) when MINTEQA2 is
c     executed.  Also, to query the user as to which component(s)
c     should have their equilibrated mass distribution written to
c     this file.  pH and Eh (if applicable) are written automatically
c     by MINTEQA2 when this option is used, so should not be specified
c     here.  The current selections for these parameters are displayed
c     on-screen and the user is given opportunity to change each, to
c     cancel the the procedure so that no importable file is created
c     or, to return to the previous menu without making changes.
c
      include 'PRODEFA2.INC'
      character nam*20
      character*8  nam123(6)
      integer icheck1, icheck3, iadded
c
      
      if (n123.eq.0) then
        call clrscr (lu06)
        write (lu06, 9000) iprb
        write (lu03, 9000) iprb
 20     write (lu06,8000) cont1
        read (lu05,8010,err=20) ans
        if (ans.eq.'R'.or.ans.eq.' ') ans = 'r'
        if (ans.ne.'r'.and.ans.ne.'1'.and.ans.ne.'2'.and.ans.ne.'3') 
     *      go to 20
        write (lu03,8000) cont2, ans
        if (ans.eq.'r') go to 999 
        if (ans.eq.'1') ntyp123 = 1
        if (ans.eq.'2') ntyp123 = 2
        if (ans.eq.'3') ntyp123 = 3
      end if
c
      icheck1 = 0
      nam123(1) = ' '
      nam123(2) = ' '
      nam123(3) = ' '
      nam123(4) = ' '
      nam123(5) = ' '
      nam123(6) = ' '
      if (n123.gt.0.and.(ntyp123.eq.1.or.ntyp123.eq.2)) then
c  -- For modification of an existing file, if that file has
c     components designated for importable output, they will be
c     identified only by id number so find out their names.
        do 225 i = 1, nt0
           if (icheck1.eq.n123) go to 226
           do 227 j = 1, n123
              if (id0(i).eq.id123(j)) then
                 nam123(j) = na0(i)
                 icheck1 = icheck1 + 1
              end if
  227      continue
  225   continue
  226   continue
      end if
c
      if (agus.ne.'Y'.and.agus.ne.'N') agus = 'N'
  100 call clrscr (lu06)
      write (lu06, 9000) iprb
      write (lu03, 9000) iprb
      write (lu06,9010)	fil123
      write (lu03,9010)	fil123
      if (ntyp123.eq.1) then
         write (lu06, 9011) (nam123(i),i=1,n123)
         write (lu03, 9011) (nam123(i),i=1,n123)
      else if (ntyp123.eq.2) then
         write (lu06, 9012) (nam123(i),i=1,n123)
         write (lu03, 9012) (nam123(i),i=1,n123)
      else if (ntyp123.eq.3) then
         write (lu06, 9013) (id123(i),i=1,n123)
         write (lu03, 9013) (id123(i),i=1,n123)
      end if 
      write (lu06,9015) cont1
      read (lu05,9060,err=100) ans
      if (ans.eq.'r'.or.ans.eq.' ') ans = 'R'
      if (ans.eq.'c') ans = 'C'
      if (ans.ne.'1'.and.ans.ne.'2'.and.ans.ne.'C'
     *   .and.ans.ne.'R') go to 100
      write (lu03,9015) cont1
c
      if (ans.eq.'1') then
c  -- Specify or change the filename of the output file to which
c     MINTEQA2 is to write the importable data.
  103   call clrscr (lu06)
        write (lu06, 9020) cont1
        read  (lu05, 9030, err=103) fil123
        write (lu03, 9020) cont2, fil123
        go to 100
c
      else if (ans.eq.'2'.and.(ntyp123.eq.1.or.ntyp123.eq.2)) then
c  -- Specify or change the components whose equilibrated mass
c     distribution is to be written.
  105   id123(1) = 0
        id123(2) = 0
        id123(3) = 0
        id123(4) = 0
        id123(5) = 0
        id123(6) = 0
        nam123(1) = ' '
        nam123(2) = ' '
        nam123(3) = ' '
        nam123(4) = ' '
        nam123(5) = ' '
        nam123(6) = ' '
        call clrscr (lu06)
        write (lu06, 9040) cont1
        read (lu05, *, err=105)  n123
        if (n123.eq.0) go to 100
        if (n123.gt.6) go to 105
        write (lu03, 9040) cont2, n123
        if (agus.eq.'Y') then
  110     call clrscr (lu06)
          if (n123.eq.1) then
            write (lu06, 9050) cont1
            read (lu05, *, err=110)  id123(1)
            write (lu03, 9050) cont2, id123(1)
          else
            write (lu06, 9051) n123,cont1
            read (lu05, *, err=110)  (id123(i), i = 1, n123)
            write (lu03, 9051) n123, cont2, (id123(i), i = 1, n123)
          end if
c
c  -- Find names of components specified.
          icheck1 = 0
          do 125 i = 1, nt0
             if (icheck1.eq.n123) go to 126
             do 127 j = 1, n123
               if (id0(i).eq.id123(j)) then
                  nam123(j) = na0(i)
                  icheck1 = icheck1 + 1
               end if
  127        continue
  125     continue
c  -- At least one of the id numbers specified is not a valid id
c     number.
          write (lu06,9140)
          write (lu03,9140)
          write (lu06,9100) cont1
          read (lu05,*)
          go to 110
  126     continue
c
c
        else if (agus.eq.'N') then
          iadded = 1
          do 120 i = 1, n123
            call clrscr (lu06)
            write (lu06,9070) i,n123
            write (lu03,9070) i,n123
            idj = 0
            call idcomp (1,nam,idx,idj)
            if (idj.eq.(-1)) go to 105
            nam123(i) = nam
c
c  -- Check to be sure that the component specified has already been
c     specified as an AQUEOUS COMPONENT in this problem.  Disallow
c     if not.
            icheck3 = 0
            do 130 j = 1, nt(1)
              if (id(1,j).eq.idx) then
                icheck3 = 1
                go to 133
              end if
  130       continue
  133       if (icheck3.ne.1) then
              write (lu06,9110) idx,nam123(i)
              write (lu03,9110) idx,nam123(i)
              write (lu06,9100) cont1
              read (lu05,*)
              go to 105
            end if
c
c  -- Report acceptance of component.
            write (lu06,9080) idx, nam123(i)
            write (lu03,9080) idx, nam123(i)
            id123(i) = idx
            iadded = iadded + 1
            write (lu06,9100) cont1
            read (lu05,*)
  120     continue
          if (n123.eq.1) then
            write (lu03, 9050) cont2, id123(1)
          else
            write (lu03, 9051) n123, cont2, (id123(i), i = 1, n123)
          end if
        end if
        go to 100
c
      else if (ans.eq.'2'.and.ntyp123.eq.3) then
c  -- Specify or change the species whose equilibrium
c     concentration is to be written.
  106   id123(1) = 0
        id123(2) = 0
        id123(3) = 0
        id123(4) = 0
        id123(5) = 0
        id123(6) = 0
        nam123(1) = ' '
        nam123(2) = ' '
        nam123(3) = ' '
        nam123(4) = ' '
        nam123(5) = ' '
        nam123(6) = ' '
        call clrscr (lu06)
        write (lu06, 9041) cont1
        read (lu05, *, err=106)  n123
        if (n123.eq.0) go to 100
        if (n123.gt.6) go to 106
        write (lu03, 9041) cont2, n123
  111   call clrscr (lu06)
        if (n123.eq.1) then
          write (lu06, 9049) cont1
          read (lu05, *, err=111)  id123(1)
          write (lu03, 9049) cont2, id123(1)
        else
          write (lu06, 9048) n123,cont1
          read (lu05, *, err=111)  (id123(i), i = 1, n123)
          write (lu03, 9048) n123, cont2, (id123(i), i = 1, n123)
        end if
c
c -- Report acceptance of component.
        
        write (lu06,9081) (id123(i), i = 1, n123)
        write (lu03,9081) (id123(i), i = 1, n123)
        write (lu06,9100) cont1
        read (lu05,*)
c
        go to 100
c
      else if (ans.eq.'C') then
c  -- Cancel the importable output option.
        fil123 =  ' '
        n123 = 0
        id123(1) = 0
        id123(2) = 0
        id123(3) = 0
        id123(4) = 0
        id123(5) = 0
        id123(6) = 0
        nam123(1) = ' '
        nam123(2) = ' '
        nam123(3) = ' '
        nam123(4) = ' '
        nam123(5) = ' '
        nam123(6) = ' '
        go to 100
c
      else if (ans.eq.'R') then
        if (n123.eq.0.or.fil123.eq.' ') then
          call clrscr (lu06)
          write (lu06,9090)
          write (lu03,9090)
          write (lu06,9100) cont1
          read (lu05,*)
        end if
c  -- Return to previous menu without making anymore changes.
        go to 999
c
      end if
      go to 100
  999 return
c
 9000 format (' _____________________________________________________',
     *   '_________________________',/,
     *   '    ____________________________ EDIT LEVEL IV ____',
     *   '______________PROB # ',i2,'_   ',/
     *   '       ________________________ IMPORT  UTILITY _________',
     *   '_____________')
 9010 format (//,
     *   '  1 = Filename to which the equilibrated data for',
     *   ' spreadsheet import',
     * /,'      is to be written:  ',a12)
 9011 format (//,'  2 = Currently specified component(s) whose', 
     *           ' equilibrated mass distributions',
     * /,'      (in terms of percent) are to be written:',/,6(3x,a8))
 9012 format (//,'  2 = Currently specified component(s) whose', 
     *           ' equilibrated mass distributions',
     * /,'      (in terms of concentration) are to be',
     *          ' written:',/,6(3x,a8))
 9013 format (//,'  2 = Currently specified species whose equilibrium',
     *   ' concentrations',
     * /,'      are to be written:',/,6(3x,i7))
 9015 format (//,'  C = Cancel current settings and reset so as',
     *          ' to NOT generate importable output',
     *//,'  R = Return to previous menu without changing anything',
     *//,a1,'       ENTER CHOICE  ([D] = R) > ',1x,a1)
 9020 format (/,' Enter the name of the file to which the',
     *          ' importable MINTEQA2 output data is',
     *        /,' to be written.  Use up to 8 characters plus an',
     *          ' optional filename extension',
     *        /,' of up to 3 characters.',
     *     /,a1,'  ENTER FILENAME > ',1x,a12)
 9030 format (a12)
 9040 format (/,' STEP 1 - ENTER THE NUMBER OF COMPONENTS whose',
     *          ' equilibrated mass distributions',
     *     /,a1,' are to be written  (from 1 to 6;  0 to',
     *          ' cancel) > ',1x,i1)
 9041 format (/,' STEP 1 - ENTER THE NUMBER OF SPECIES whose',
     *          ' equilibrium concentrations',
     *     /,a1,' are to be written  (from 1 to 6;  0 to',
     *          ' cancel) > ',1x,i1)
 9050 format (a1,/,' STEP 2 - ENTER THE ID NUMBER corresponding to the',
     *          ' desired component > ',1x,i3)
 9049 format (a1,/,' STEP 2 - ENTER THE ID NUMBER corresponding to the',
     *          ' desired species > ',1x,i7)
 9051 format (/,' STEP 2 -ENTER THE ID NUMBERS (separated by commas)',
     *          ' corresponding to the ',i1,
     *     /,a1,' desired  components > ',6(1x,i3))
 9048 format (/,' STEP 2 -ENTER THE ID NUMBERS (separated by commas)',
     *          ' corresponding to the ',i1,
     *     /,a1,' desired species > ',6(1x,i7))
 9060 format (a1)
 9070 format (/,' STEP 2 - Follow instructions to SPECIFY COMPONENT ',
     *       i1,' of the ',i1,' to be written',
     *        /,' to the importable ASCII file.')
 9080 format (//,' ********************************************',
     *          '*************************',
     *        /,' Component id number ',i3,', ',a8,' is now',
     *          ' flagged for special',
     *        /,' output by MINTEQA2.')
 9090 format (/,' ***** Since not all of the required parameters for',
     *           ' this option have been',
     *        /,' specified, it will NOT be implemented. *****')
 9100 format (a1,'  Press ENTER to continue')
 9110 format (/,' *** Component id number ',i3,' (',a8,') has not',
     *          ' been specified as an AQUEOUS',
     *        /,' COMPONENT in this problem.  Re-specify the number of',
     *          ' components to be written',
     *        /,' to the importable file remembering to include only',
     *          ' those that you have',
     *        /,' already specified as AQUEOUS COMPONENTS.  You may',
     *          ' wish to return to EDIT',
     *        /,' LEVEL II to specify other AQUEOUS COMPONENTS.')
 9140 format (/,' *** At least one of the component id numbers',
     *          ' specified is not a valid',
     *        /,' MINTEQA2 component id number.  Please re-specify.',
     *          ' ***')
 8000 format (/,'  Choose one of these mutually exclusive special',
     *   ' output options:',
     *//,'     1 = Equilibrium mass distribution (in terms of percent)',
     *   ' of up to',
     * /,'         six components',
     *//,'     2 = Equilibrium mass distribution (in terms of',
     *   ' concentration) of up to',
     * /,'         six components',
     *//,'     3 = Equilibrium concentrations of up to six aqueous',
     *   ' species',
     *//,'     R = RETURN to previous menu',
     *//,a1,'         Enter Choice  ([D] = R) > ',a1)
 8010 format (a1)
 9081 format (//,' ********************************************',
     *          '*************************',
     *        /,' The following species are flagged for special',
     *          ' output by MINTEQA2.',
     *        /,' It is the responsibility of the user to ensure',
     *          ' that these are valid',
     *        /,' id numbers: ',/,6(3x,i7))
      end
