      subroutine cprint (nty)
c
c********************************************************************
c
c FUNCTION:
c   PRINTS TYPE SPECIES TO SAMPLQ FILE
c INPUT:
c     NTY=TYPE OF SPECIES IN FILE (1-6)
c OUTPUT:
c     ELEMENTS OF EXTERNAL FILE SAMPLQ
c
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
c SUBROUTINE CPRINT  --  MODIFICATION AND CORRECTION HISTORY
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
c   DATE                    MODIFICATION OR CORRECTION
c
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
c
      include 'PRODEFA2.INC'
c
c
      if (nt(nty).eq.0) go to 110
      if (nty.ne.1) write (lu03,9000,err=120) nty,nt(nty)
      do 100 i = 1, nt(nty)
         if (nty.eq.1) then
            if (reguess(i).eq.'n') reguess(i) = 'N'
            write (lu03,9010,err=120) id(nty,i),teq(nty,i),thr(nty,i),
     *            reguess(i),na(nty,i)
         elseif (nty.eq.4) then
            write (lu03,9030,err=120) id(nty,i),teq(nty,i),thr(nty,i),
     *         con(i),na(nty,i)
         else
            write (lu03,9020,err=120) id(nty,i),teq(nty,i),thr(nty,i),na
     *         (nty,i)
         endif
  100 continue
  110 return
  120 endfile lu03
      go to 110
c
c
 9000 format (' ',i3,1x,i3)
 9010 format (i7,1x,1pe10.3,1x,0pf7.2,1x,a1,20x,'/',a18)
 9020 format (i7,2(2x,f9.4),19x,'/',a18)
 9030 format (i7,2(2x,f9.4),2x,1pe10.3,7x,'/',a18)
c
      end
c
      subroutine cwrite (nty,lu)
c
c********************************************************************
c
c FUNCTION:
c   PRINTS TYPE SPECIES TO SAMPLQ FILE
c INPUT:
c     NTY=TYPE OF SPECIES IN FILE (1-6)
c OUTPUT:
c     ELEMENTS OF EXTERNAL FILE SAMPLQ
c
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
c SUBROUTINE CWRITE  -- MODIFICATION AND CORRECTION HISTORY
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
c   DATE                   MODIFICATION OR CORRECTION
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
c
c
c
      include 'PRODEFA2.INC'
c
c
c********************************************************************
c
      if (nt(nty).eq.0) go to 110
      if (nty.ne.1) write (lu,9000,err=120) nty,nt(nty)
      do 100 i = 1, nt(nty)
         if (nty.eq.1) then
c  -- Don't write the component H2O to the output file.  Depending
c     on the units of concentration, the presence of H2O may screw-up
c     the conversion to molal in MINTEQA2 because that conversion is
c     based on the assumption of infinite dilution and H2O is not
c     dilute in aqueous systems.
            if (id(nty,i).eq.2) go to 100
            if (reguess(i).eq.'n') reguess(i) = 'N'
            write (lu,9010,err=120) id(nty,i),teq(nty,i),thr(nty,i),
     *         reguess(i),na(nty,i)
         elseif (nty.eq.4) then
            write (lu,9030,err=120) id(nty,i),teq(nty,i),thr(nty,i),con(
     *         i),na(nty,i)
         else
            write (lu,9020,err=120) id(nty,i),teq(nty,i),thr(nty,i),
     *         na(nty,i)
         endif
  100 continue
  110 return
  120 endfile lu
      go to 110
c
c
 9000 format (i3,1x,i3)
 9010 format (i7,1x,1pe10.3,1x,0pf7.2,1x,a1,20x,'/',a18)
 9020 format (i7,2(2x,f9.4),19x,'/',a18)
 9030 format (i7,2(2x,f9.4),2x,1pe10.3,7x,'/',a18)
c
      end
c
      subroutine printp
c
c********************************************************************
c FUNCTION:
c   CREATES AN IMAGE OF THE SAMPLE.DAT IN SAMPLQ
c INPUT:
c   NONE
c OUTPUT:
c   SAMPLQ FILE
c********************************************************************
c CORRECTION HISTORY:
c   DATE                     CORRECTION                      REFERENC
c
c********************************************************************
c
      include 'PRODEFA2.INC'
      include 'CONST.INC'
c
c
      write (lu03,9000)
      write (lu03,9010) desc
      write (lu03,9010) carry
      write (lu03,9020) temp,flag,fions,soilkg
      iswp = isweep
      if (idsweep.eq.0.or.sweep.eq.' '
     *    .or.(isweep.eq.1.and.abs(valinc).lt.R0MIN)
     *    .or.nprob.eq.0) then
        iswp = 0 
      end if
      write (lu03,9030) icoral,idbg,ichrg,iprint,niter,iparm,isopt,
     *   ibacks,kkdav,kkthr,iswp,n123,ntyp123
c
c  -- If this problem invokes the option to have MINTEQA2 solve the
c     same problem at a series of total concentrations or fixed
c     activities of one specific component...
      if (iswp.eq.1) then
        write (lu03,9100) sweep, idsweep, nprob
        if (sweep.eq.'ACTIVITY  ') then
          write (lu03,9110) valinc
        else if (sweep.eq.'TOTAL CONC') then
          write (lu03,9120) valinc
        end if
      else if (iswp.eq.2) then
        write (lu03,9100) sweep, idsweep, nprob
        if (sweep.eq.'ACTIVITY  ') then
          write (lu03,9130) (uvalue(i),i=2,nprob)
        else if (sweep.eq.'TOTAL CONC') then
          write (lu03,9140) (uvalue(i),i=2,nprob)
        end if
      end if
c
c  -- If this problem invokes the option to flag certain components for
c     output by MINTEQA2 to a file that can be imported by LOTUS
c     1-2-3 or a similar program...
      if (n123.ne.0) then
        write (lu03,9025) fil123, (id123(i),i=1,n123)
      end if
c
      write (lu03,9040) iads,numads,iabq
      if (iads.eq.0) then
         do 100 i = 1, 5
            if (abs(solcon(i)).gt.R0MIN) then
               isurf = i+80
               write (lu03,9050) solcon(i),ssa(i),cap1(i),cap2(i),isurf
            endif
  100    continue
      endif
      ifs = 0
      do 110 i = 1, 6
         if (nt(i).eq.0) go to 110
         if (i.gt.1.and.ifs.eq.0) then
            write (lu03,9060)
            ifs = 1
         endif
         call cprint (i)
  110 continue
      ifs = 0
      do 130 n = 1, 6
         if (nt7(n).eq.0) go to 130
         if (ifs.eq.0) then
            write (lu03,9060)
            ifs = 1
         endif
         write (lu03,9070) n,nt7(n)
         do 120 k = 1, nt7(n)
            i = index7(n,k)
            write (lu03,9080) id(7,i),na(7,i),thr(7,i),teq(7,i),temn7(i)
     *         ,temx7(i),sp7(i),dha7(i),dhb7(i),gf7(i),alk7(i),ncmp(i),(
     *         stoic7(j,i),id7(j,i),j=1,12),nbcmp(i),(stoib7(j,i),idb7(j
     *         ,i),j=1,3)
c
  120    continue
  130 continue
      write (lu03,9060)
      write (lu03,9060)
      return
c
c
 9000 format ('1')
 9010 format (' ',a66)
 9020 format (' ',f7.2,1x,a7,1x,f6.3,1x,1pe12.5)
 9025 format (' ',a12,6(1x,i7))
 9030 format (' ',13(i1,1x))
 9040 format (' ',i1,3x,i1,3x,i1)
 9050 format (' ',1pe9.3,1x,0pf7.2,1x,f5.3,1x,f5.3,1x,i2)
 9060 format (' ')
 9070 format (' ',i3,1x,i3)
 9080 format (i7,1x,a12,2f10.4,2f8.3,3f5.2,f9.4/f5.2,i2,1x,6(f7.3,1x,i3,
     *   1x)/6(f7.3,1x,i3,1x)/i1,3(f7.3,1x,i3,1x))
 9100 format (' ',a10,1x,i3,1x,i2)
 9110 format (' ',f6.2)
 9120 format (' ',1pe10.3)
 9130 format (' ',6(1x,f6.2))
 9140 format (' ',6(1x,1pe10.3))

c
      end
c
      subroutine readp (lu,irw,iend)
c
c********************************************************************
c FUNCTION:
c     READS SAMPLE.DAT FILE INTO PROGRAM
c INPUT:
c     LU=LOGICAL UNIT TO READ
c     IRW=REWIND BEFORE READING
c OUTPUT:
c     IEND=1 IF END OF FILE HAS BEEN DETECTED
c     APPROPRIATE VALUES IN PROGRAM ARRAYS
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
c SUBROUTINE READP  --  MODIFICATION AND CORRECTION HISTORY:
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
c
c
      include 'PRODEFA2.INC'
c
      real atmp1,atmp2,atmp3,atmp4
c
      iend = 0
      if (irw.eq.1) rewind lu
      read (lu,9000,end=210) desc
      read (lu,9000,end=210) carry
      read (lu,9010,end=210) temp,flag,fions,soilkg
c
c
      read (lu,9020,end=210) icoral,idbg,ichrg,iprint,niter,iparm,
     *                isopt,ibacks,kkdav,kkthr,isweep,n123,
     *                ntyp123
c
c
c  -- If this problem invokes the option to have MINTEQA2 solve the
c     same problem at a series of total concentrations or fixed
c     activities of one specific component...
      idsweep = 0
      if (isweep.eq.1) then
        read (lu,9100,end=210) sweep, idsweep, nprob
        if (sweep.eq.'ACTIVITY  ') then
          read (lu,9110,end=210) valinc
        else if (sweep.eq.'TOTAL CONC') then
          read (lu,9120,end=210) valinc
        end if
      else if (isweep.eq.2) then
        read (lu,9100,end=210) sweep, idsweep, nprob
        if (sweep.eq.'ACTIVITY  ') then
          read (lu,9130,end=210) (uvalue(i),i=2,nprob)
        else if (sweep.eq.'TOTAL CONC') then
          read (lu,9140,end=210) (uvalue(i),i=2,nprob)
        end if
      end if
c
c  -- If this problem invokes the option to flag certain components for
c     output by MINTEQA2 to a file that can be imported by LOTUS
c     1-2-3 or a similar program...
      if (n123.gt.0) then
         read (lu,9025,end=210) fil123,(id123(i),i=1,n123)
      end if
c
      read (lu,9030,end=210) iads,numads,iabq
      if (iads.gt.0) then
         j = 0
  100    j = j+1
         if (j.gt.numads) go to 110
         read (lu,9040,end=210) atmp1,atmp2,atmp3,atmp4,isurf
         jsurf = isurf-80
         solcon(jsurf) = atmp1
         ssa(jsurf) = atmp2
         cap1(jsurf) = atmp3
         cap2(jsurf) = atmp4
         go to 100
  110    continue
      endif
      do 120 i = 1, 7
         nt(i) = 0
  120 continue
c
c READ COMPONENTS
c
      do 130 i = 1, nmxx
         read (lu,9050,end=210) id(1,i),teq(1,i),thr(1,i),
     *                          reguess(i),na(1,i)
         if (reguess(i).eq.'N') reguess(i) = 'n'
         if (id(1,i).eq.idsweep) then
           if (sweep.eq.'TOTAL CONC') startval = teq(1,i)
           if (sweep.eq.'ACTIVITY  ') startval = thr(1,i)
           if (isweep.eq.2) uvalue(1) = startval
         end if 
         if (id(1,i).eq.0) go to 140
         ahyd = -7.0
         if (id(1,i).eq.330 .and. teq(1,i).gt.0.d0)
     *      ahyd = log10(teq(1,i))
         nt(1) = i
c  -- Find the gram formula weight and charge to associate with
c     each component.  Break out of the search loop when these are
c     found.
         do 135 j = 1, nt0
            if (id(1,i).eq.id0(j)) then
               gfw(i) = gf0(j)
               spz(i) = ch0(j)
               go to 130
            end if
  135    continue
  130 continue
  140 ii = 0
c
c READ TYPE MODIFICATONS
c
  150 read (lu,9070,end=210) nty,ndmy
      if (nty.eq.0.or.ndmy.eq.0) go to 170
      if (nty.lt.1.or.nty.gt.6) go to 190
      nt(nty) = ndmy
      do 160 i = 1, ndmy
         if (nty.eq.1) then
            read (lu,9050,end=210) id(nty,i),teq(nty,i),thr(nty,i),
     *         na(nty,i)
         elseif (nty.eq.4) then
            read (lu,9080,end=210) id(nty,i),teq(nty,i),thr(nty,i),con(i
     *         ),na(nty,i)
         else
            read (lu,9060,end=210) id(nty,i),teq(nty,i),thr(nty,i),
     *         na(nty,i)
            if (nty.eq.3 .and. id(3,i).eq.330) ahyd = -1 * teq(3,i)
         endif
  160 continue
      go to 150
c
c READ ADDED REACTIONS NOT IN DATA BASE
c
  170 read (lu,9070,end=210) nty,ndmy
      if (nty.eq.0.or.ndmy.eq.0) go to 200
      if (nty.lt.1.or.nty.gt.6) go to 190
      nt7(nty) = ndmy
      nt(7) = nt(7)+nt7(nty)
      do 180 k = 1, ndmy
         ii = ii+1
         index7(nty,k) = ii
         read (lu,9090,end=210) id(7,ii),na(7,ii),thr(7,ii),teq(7,ii),
     *      temn7(ii),temx7(ii),sp7(ii),dha7(ii),dhb7(ii),gf7(ii),
     *      alk7(ii),ncmp(ii),(stoic7(j,ii),id7(j,ii),j=1,12),nbcmp(ii),
     *      (stoib7(j,ii),idb7(j,ii),j=1,3)
  180 continue
c
      go to 170
  190 write (lu06,9095) nty
      write (lu03,9095) nty
  200 return
  210 iend = 1
      return
c
c
 9000 format (a66)
 9010 format (f5.2,1x,a5,1x,f6.3,1x,e12.5)
 9020 format (13(i1,1x))
 9025 format (a12,6(1x,i7))
 9030 format (i1,3x,i1,3x,i1)
 9040 format (e9.3,1x,f7.2,1x,f5.3,1x,f5.3,1x,i2)
 9050 format (i7,1x,e10.3,1x,f7.2,1x,a1,21x,a18)
 9060 format (i7,2(2x,f9.4),20x,a18)
 9070 format (i3,1x,i3)
 9080 format (i7,2(2x,f9.4),2x,e10.3,8x,a18)
 9090 format (i7,1x,a12,2f10.4,2f8.3,3f5.2,f9.4/f5.2,i2,1x,6(f7.3,1x,i3,
     *   1x)/6(f7.3,1x,i3,1x)/i1,3(f7.3,1x,i3,1x))
 9095 format (' TYPE OF SPECIES READ IS NOT LEGAL:',i5)
 9100 format (a10,1x,i3,1x,i2)
 9110 format (f6.2)
 9120 format (e10.3)
 9130 format (6(1x,f6.2))
 9140 format (6(1x,e10.3))
c
      end
c
      subroutine wradds (nty)
c
c********************************************************************
c FUNCTION: STORE NEWLY CREATED REACTIONS OR SPECIES ON ADDITION FILE
c INPUT:
c     NTY= TYPE OF SPECIES TO CONSIDER STORING
c OUTPUT: A NEW ADDITION FILE
c
      include 'PRODEFA2.INC'
c
      character nad*20
      dimension nn(6),stoicd(12),idd(12),stoibd(3),ibd(3)
      character keep*1,filnam*16
      data ifirst,keep,filnam / 0,'Y','ADDDAT.DAT'/
      iyy = 12
c
c********************************************************************
c
c
c DETERMINE WHETHER ANY ADDED SPECIES TO STORE
c
      if (nt7(nty).eq.0) go to 240
      i = index7(nty,nt7(nty))
  100 write (lu06,9000) cont1
      read (lu05,9010,err=100) keep
      write (lu03,9000) cont2,keep
      if (keep.ne.'Y'.and.keep.ne.'N') go to 100
      if (keep.eq.'N') go to 240
c
c  INITIALIZE ADDITION AND SCRATCH FILES
c
      if (ifirst.ne.0) go to 130
      ifirst = 1
      write (lu06,9020)
      write (lu03,9020)
  110 write (lu06,9030) cont1
      read (lu05,9010,err=110) ans
      if (ans.eq.'n') ans = 'N'
      if (ans.eq.'y') ans = 'Y'
      if (ans.ne.'N'.and.ans.ne.'Y') go to 110
      write (lu03,9030) cont2,ans
      if (ans.eq.'N') go to 240
      if (ans.eq.'Y') then
  120    write (lu06,9040) cont1
         read (lu05,9050,err=120) filnam
c
c CHANGED FORMAT REC
c
         write (lu03,9040) cont2,filnam
      endif
      open (unit=lu17,file=filnam,status='UNKNOWN')
      open (unit=lu18,status='SCRATCH')
c
c  READ OLD FILE, MERGE WITH NEW DEFINITIONS ON SCRATCH FILE
c
  130 iread = 0
      do 140 ii = 1, 6
         nn(ii) = 0
  140 continue
      do 190 ii = 1, 6
         iflgi = 0
  150    if (iread.eq.0) then
            read (lu17,9060,end=170) iddd,nad,thrd,teqd,temxd,temnd,spd,
     *         dhad,dhbd,gfd
            if (ii.ne.1) read (lu17,9070,end=170) alkd,ndmpd,(stoicd(l),
     *         idd(l),l=1,iyy),nbmpd,(stoibd(l),ibd(l),l=1,3)
         endif
  160    if (iddd.eq.0) then
            if (ii.ne.nty) go to 180
            if (iflgi.eq.1) go to 180
            nn(ii) = nn(ii)+1
            write (lu18,9060) id(7,i),na(7,i),thr(7,i),teq(7,i),temn7(i)
     *         ,temx7(i),sp7(i),dha7(i),dhb7(i),gf7(i)
            if (ii.ne.1) write (lu18,9070) alk7(i),ncmp(i),(stoic7(j,i),
     *         id7(j,i),j=1,iyy),nbcmp(i),(stoib7(j,i),idb7(j,i),j=1,3)
            go to 180
         endif
         nn(ii) = nn(ii)+1
         if (ii.eq.nty.and.iddd.eq.id(7,i)) then
            iflgi = 1
            write (lu18,9060) id(7,i),na(7,i),thr(7,i),teq(7,i),temn7(i)
     *         ,temx7(i),sp7(i),dha7(i),dhb7(i),gf7(i)
            if (ii.ne.1) write (lu18,9070) alk7(i),ncmp(i),(stoic7(j,i),
     *         id7(j,i),j=1,iyy),nbcmp(i),(stoib7(j,i),idb7(j,i),j=1,3)
         else
            write (lu18,9060) iddd,nad,thrd,teqd,temxd,temnd,spd,dhad,
     *         dhbd,gfd
            if (ii.ne.1) write (lu18,9070) alkd,ndmpd,(stoicd(l),idd(l),
     *         l=1,iyy),nbmpd,(stoibd(l),ibd(l),l=1,3)
         endif
         go to 150
  170    iread = 1
         iddd = 0
         go to 160
  180    iddd = 0
c
  190 continue
      endfile lu18
      rewind lu17
      rewind lu18
c
c TRANSFER MERGED FILE TO ADDDAT.DAT
c
      do 220 ii = 1, 6
  200    read (lu18,9060,end=230) iddd,nad,thrd,teqd,temxd,temnd,spd,
     *      dhad,dhbd,gfd
         if (ii.ne.1) read (lu18,9070,end=230) alkd,ndmpd,(stoicd(l),idd
     *      (l),l=1,iyy),nbmpd,(stoibd(l),ibd(l),l=1,3)
         if (iddd.eq.0) go to 210
         write (lu17,9060) iddd,nad,thrd,teqd,temxd,temnd,spd,dhad,dhbd,
     *      gfd
         if (ii.ne.1) write (lu17,9070) alkd,ndmpd,(stoicd(l),idd(l),l=1
     *      ,iyy),nbmpd,(stoibd(l),ibd(l),l=1,3)
         go to 200
  210    iddd = 0
c
  220 continue
  230 endfile lu17
      rewind lu17
      rewind lu18
  240 return
c
c
 9000 format (/,a1,' Want To Save This Added Reaction In A File',
     *   ' For Later Use ? (Y,N) > ',1x,a1)
 9010 format (a1)
 9020 format (' The Addition File Will Contain',' Contents Of'/
     *   ' An Old Addition File (Normally "ADDDAT.DAT")',
     *   ' Plus Reactions Added In This Run'//' ***CAUTION: Any Old',
     *   ' Reactions With Same ID# As New Will Be Erased.'/)
 9030 format (/,a1,' Want To Add To Or Substitute In The Old',
     *   '"ADDDAT.DAT" File? (Y,N) > ',1x,a1)
 9040 format (/,a1,' Enter Name Of Add`n File (UP TO 16 ',
     *   ' Characters > ',1x,a16)
 9050 format (a16)
 9060 format (i7,1x,a12,2f10.4,2f8.3,3f5.2,f9.4)
 9070 format (f5.2,i2,1x,6(f7.3,1x,i3,1x)/6(f7.3,1x,i3,1x),i1,3(f7.3,1x,
     *   i3,1x))
c
      end
c
      subroutine writep (lu,irw)
c
c********************************************************************
c FUNCTION:
c   CREATES SAMPLE.DAT FILE INCLUDING HEADING VALUES
c INPUT:
c   LU=LOGICAL UNIT TO WRITE ON
c   IRW=0 DO NOT REWIND BEFORE WRITING
c   IRW=1 REWIND BEFORE WRITING
c   NTYSP=USED TO PRINT ONLY ONE BLANK LINE FOR END OF FILE WHEN ADSO
c         IS BEING CONSIDERED
c OUTPUT:
c   SAMPLE.DAT FILE
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
c SUBROUTINE WRITEP  --  MODIFICATION AND CORRECTION HISTORY:
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
c   DATE                      MODIFICATION OR CORRECTION
c
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
c
      include 'PRODEFA2.INC'
c
      character added*3
      include 'CONST.INC'
c
      added = 'no'
      if (irw.eq.1) rewind lu
      write (lu,9000,err=160) desc
      write (lu,9000,err=160) carry
      write (lu,9010,err=160) temp,flag,fions,soilkg
      iswp = isweep
      if (idsweep.eq.0.or.sweep.eq.' '
     *    .or.(isweep.eq.1.and.abs(valinc).lt.R0MIN)
     *    .or.nprob.eq.0) then
        iswp = 0 
      end if
      write (lu,9020,err=160) icoral,idbg,ichrg,iprint,niter,iparm,
     *   isopt,ibacks,kkdav,kkthr,iswp,n123,ntyp123
c
c  -- If this problem invokes the option to have MINTEQA2 solve the
c     same problem at a series of total concentrations or fixed
c     activities of one specific component...
      if (iswp.eq.1) then
        write (lu,9100,err=160) sweep, idsweep, nprob
        if (sweep.eq.'ACTIVITY  ') then
          write (lu,9110,err=160) valinc
        else if (sweep.eq.'TOTAL CONC') then
          write (lu,9120,err=160) valinc
        end if
      else if (iswp.eq.2) then
        write (lu,9100,err=160) sweep, idsweep, nprob
        if (sweep.eq.'ACTIVITY  ') then
          write (lu,9130,err=160) (uvalue(i),i=2,nprob)
        else if (sweep.eq.'TOTAL CONC') then
          write (lu,9140,err=160) (uvalue(i),i=2,nprob)
        end if
      end if
c
c  -- If this problem invokes the option to flag certain components for
c     output by MINTEQA2 to a file that can be imported by LOTUS
c     1-2-3 or a similar program...
      if (n123.ne.0) then
        write (lu,9025,err=160) fil123, (id123(i),i=1,n123)
      end if
c
      write (lu,9030,err=160) iads,numads,iabq
      if (iads.gt.0) then
         do 100 isurf = 1, 5
            call sitcount (isurf)
            if (nsites(isurf).ne.0) then
               jsurf = isurf+80
               write (lu,9040,err=160) solcon(isurf),ssa(isurf),
     *            cap1(isurf),cap2(isurf),jsurf
            endif
  100    continue
      endif
      ifs = 0
      nwrit = 0
      do 110 i = 1, 6
         if (nt(i).eq.0) go to 110
         nwrit = nwrit+1
         if (i.gt.1.and.ifs.eq.0) then
            write (lu,9050)
            ifs = 1
         endif
         call cwrite (i,lu)
  110 continue
c
c  -- If there are no type modification entries following the component
c     but there are added species, write an extra blank line between
c     the end of the component list and the added species.
c
      do 120 i = 1, 6
         if (nt7(i).eq.0) go to 120
         added = 'yes'
  120 continue
      if (ifs.eq.0.and.added.eq.'yes') write (lu,9050)
c
      ifs = 0
      do 140 n = 1, 6
         if (nt7(n).eq.0) go to 140
         added = 'yes'
         if (ifs.eq.0) then
            write (lu,9050)
            ifs = 1
         endif
         write (lu,9060,err=160) n,nt7(n)
c
         do 130 k = 1, nt7(n)
            i = index7(n,k)
            write (lu,9070,err=160) id(7,i),na(7,i),thr(7,i),teq(7,i),
     *         temn7(i),temx7(i),sp7(i),dha7(i),dhb7(i),gf7(i),alk7(i),
     *         ncmp(i),(stoic7(j,i),id7(j,i),j=1,12),nbcmp(i),(stoib7(j,
     *         i),idb7(j,i),j=1,3)
c
  130    continue
  140 continue
c
c  -- This is a check for added reactions so that the output file will
c     end with the proper number of blank lines.
c
      if (added.eq.'yes') go to 150
      write (lu,9080)
      if (nwrit.eq.1.and.nt(1).ne.0) write (lu,9050)
      go to 160
  150 write (lu,9050)
  160 if (irw.eq.1) endfile lu
      return
c
c
 9000 format (a66)
 9010 format (f5.2,1x,a5,1x,f6.3,1x,1pe12.5)
 9020 format (13(i1,1x))
 9025 format (a12,6(1x,i7))
 9030 format (i1,3x,i1,3x,i1)
 9040 format (1pe9.3,1x,0pf7.2,1x,f5.3,1x,f5.3,1x,i2)
 9050 format (1x,' ')
 9060 format (i3,1x,i3)
 9070 format (i7,1x,a12,2f10.4,2f8.3,3f5.2,f9.4/f5.2,i2,1x,6(f7.3,1x,i3,
     *   1x)/6(f7.3,1x,i3,1x)/i1,3(f7.3,1x,i3,1x))
 9080 format (1x,' '/' ')
 9100 format (a10,1x,i3,1x,i2)
 9110 format (f6.2)
 9120 format (1pe10.3)
 9130 format (6(1x,f6.2))
 9140 format (6(1x,1pe10.3))
c
      end
c
      subroutine adsfilin (nrct)
c
c  -- Reads an auxillary database file containing adsorption reactions
c     which are incorporated into the current and all subsequent 
c     problems as added reactions.
c
      include 'PRODEFA2.INC'      
      character adsfil*16
c  
c  -- Ask for name of auxillary file and open same with status old.
   10 write (lu06,9000) cont1
      read (lu05,9050,err=10) adsfil
      if (adsfil.eq.'R'.or.adsfil.eq.'r') go to 999
      write (lu03,9000) cont2,adsfil
      lu02 = 02
      open (unit=lu02,file=adsfil,status='old',err=15)
c  -- Report failure to find specified file and give opportunity to 
c     specify another filename or return.
      go to 20
   15 write (lu06,9010) 
      write (lu03,9010) 
      go to 10
c  -- When specified file is successfully opened, read same.  If nty
c     does not equal 2 or nreact equals 0, report error and return. 
c     If nreact plus the number of added reactions already
c     defined is greater than 50, read reactions from this file
c     only until the total number of added reactions is 50.
   20 read (lu02,9070,end=205) nty,nreact
      if (nreact.eq.0) then
        write (lu06,9110) 
        write (lu03,9110) 
        write (lu06,9100) cont1
        write (lu03,9100) 
        read (lu05,*)
        go to 999
      else if (nty.ne.2) then
        write (lu06,9095) nty
        write (lu03,9095) nty
        write (lu06,9100) cont1
        write (lu03,9100) 
        read (lu05,*)
        go to 999
      end if 
c
c  -- The total number of added reactions that can be defined is 50.
c     Make sure that the sum of existing reactions plus those in this
c     file does not exceed 50.
      n = 50 - nt(7)
      if (n.le.0) then
        write (lu06,9105) 
        write (lu03,9105) 
        write (lu06,9100) cont1
        write (lu03,9100) 
        read (lu05,*)
        go to 999
      end if
      if (n.lt.nreact) nreact = n
      do 100 i = 1, nreact
         nt(7) = nt(7) + 1
         ii = nt(7)
         nt7(nty) = nt7(nty)+1
         k = nt7(nty)
         index7(nty,k) = ii
         read (lu02,9090,end=210) id(7,ii),na(7,ii),thr(7,ii),teq(7,ii),
     *      temn7(ii),temx7(ii),sp7(ii),dha7(ii),dhb7(ii),gf7(ii),
     *      alk7(ii),ncmp(ii),(stoic7(j,ii),id7(j,ii),j=1,12),nbcmp(ii),
     *      (stoib7(j,ii),idb7(j,ii),j=1,3)
  100 continue
c
      nrct = i-1
      write (lu06,9125) nrct, adsfil
      write (lu03,9125) nrct, adsfil
      write (lu06,9100) cont1
      write (lu03,9100) 
      read (lu05,*)
      go to 999
  205 write (lu06,9120) 
      write (lu03,9120)
      write (lu06,9100) cont1
      write (lu03,9100) 
      read (lu05,*)
      go to 999 
  210 write (lu06,9115) i-1
      write (lu03,9115) i-1
      write (lu06,9100) cont1
      write (lu03,9100) 
      read (lu05,*)
      nt(7) = nt(7) - 1
      ii = nt(7)
      nt7(nty) = nt7(nty) - 1
      k = nt7(nty)
      index7(nty,k) = ii
      nrct = i - 1
  999 return
c
 9000 format (/,' ENTER the FILENAME of the adsorption database',
     *        ' file. ',
     *   /,a1,' Enter R or r to return. > ',1x,a16)
 9010 format (' The specified file does not exist. Specify another',
     *        ' or return.') 
 9050 format (a16)
 9070 format (i3,1x,i3)
 9090 format (i7,1x,a12,2f10.4,2f8.3,3f5.2,f9.4/f5.2,i2,1x,6(f7.3,1x,i3,
     *   1x)/6(f7.3,1x,i3,1x)/i1,3(f7.3,1x,i3,1x))
 9095 format (' The species in this file are TYPE ',i1,' not TYPE 2.')
 9100 format (a1,'  Press ENTER to continue')
 9105 format (' The maximum allowable number of added reactions is 50',
     *        ' and you have defined',
     *      /,' that many already.  Species from auxillary file not',
     *        ' added.')  
 9110 format (' The number of reactions parameter in this file is',
     *        ' zero.')
 9115 format (' Error reading the auxillary file.  Only the first ',i2,
     *        ' reactions were added.')
 9120 format (' Error reading the first line of the auxillary file.',
     *        ' No reactions were added.')
 9125 format (1x,i2,' reactions have been added from the file ',a16)
c
      end
