      program prodefa2
c
c *********************************************************************
c
c
c     Version 3.11   Release date: 12/01/91
c
c Purpose: THIS PROGRAM INTERACTIVELY SETS UP PROBLEMS TO BE RUN BY
c          MINTEQA2.
c
c **********************************************************************
c ** IMPORTANT note regarding known machine dependencies in this code:
c    There is only one section of code in the PRODEFA2 package
c    that contains machine dependendent statements.  It occurs 
c    in PRODEFA2.FOR and is delineated with the characters "CHANGE ME".  
c    Search for these (without the quotes) and follow the instructions
c    given there for compiling on the VAX or IBM PC.  
c
c
c -- Some helpful information :
c    There are two kinds of type classification variables used in this
c    program.  These are key variables used to guide program flow by
c    means of "if" and "branched go to" statements.  The classification
c    variable "ntysp" is used to distinguish 6 different types of 
c    chemical entities or species.  The other classification variable, 
c    "nty", is used to distinguish functional rather than chemical 
c    entities and is analogous to the "types" used in MINTEQ .  Note 
c    that both classification types are used over the same set of data,
c    so a species may chemically be ntysp = 4 (adsorbed species) and
c    fuctionally (as pertains to these computations) nty = 2 (aqueous).
c    Note that ntysp is passed among subprograms through named common
c    block in 'PRODEFA2.INC' while nty is usually passed in the argument
c    list of the calling subprogram.
c
c             ntysp = 1  -->  Component species
c                   = 2  -->  Aqueous species
c                   = 3  -->  Mineral species
c                   = 4  -->  Adsorbed species
c                   = 5  -->  Redox species
c                   = 6  -->  Gas species
c
c
c             nty   = 1  -->  Component
c                   = 2  -->  Aqueous
c                   = 3  -->  Fixed
c                   = 4  -->  Finite solid
c                   = 5  -->  Potenial solid
c                   = 6  -->  Excluded
c                   = 7  -->  Added
c
c    There is a counter variable, nt(a 7 element array), associated
c    with the nty variable.  Its values are such that
c
c             nt(1) = the number of entries of type 1 (component)
c             nt(2) = the number of entries of type 2 (aqueous)
c             nt(3) = the number of entries of type 3 (fixed)
c             nt(4) = the number of entries of type 4 (finite solid)
c             nt(5) = the number of entries of type 5 (potential solid)
c             nt(6) = the number of entries of type 6 (excluded)
c             nt(7) = the number of entries of type 7 (added)
c
c    Note that the nt array is shared among subprograms by named common.
c **********************************************************************
c
      include 'PRODEFA2.INC'
c
      character title*20,sample*16,tmpdesc*66
      character version*4,verdate*8,minteq0*14
      character infil*16,modfile*1, edit*1, skip14*1
      integer oldflag
      include 'CONST.INC'
c
c********************************************************************
c
c -- Assign program name, version number, version release date, and
c    name and version of MINTEQ for which this program can build input
c    files.
c
      version = '3.11'
      verdate = '12-01-91'
      minteq0 = 'MINTEQA2 v3.11'
c
      call minval
c********************************************************************
c
c       DEFINE INPUT/OUTPUT UNITS
c
c********************************************************************
c
      lu03 = 3
      lu04 = 4
      lu05 = 5
      lu06 = 6
      lu07 = 7
      lu08 = 8
      lu09 = 9
      lu10 = 10
      lu11 = 11
      lu12 = 12
      lu13 = 13
      lu14 = 14
      lu16 = 16
      lu17 = 17
      lu18 = 18
      lu19 = 19
c
c********************************************************************
c          DATA INITILIZATION
c********************************************************************
c
      desc = ' '
      carry = ' '
      irog = 0
      ntyfix = 3
      cont1 = '$'
      cont2 = ' '
      agus = ' '
      fil123 =  ' '
      id123(1) = 0
      id123(2) = 0
      id123(3) = 0
      n123 = 0
      do 3 i = 1,50
       reguess(i) = 'y'
  3   continue
c
c -- The following title assignments are according to the ntysp chemical
c    classification.
c
      tit(1) = 'COMPONENT SPECIES'
      tit(2) = 'AQUEOUS SPECIES'
      tit(3) = 'MINERAL SPECIES'
      tit(4) = 'ADSORBED SPECIES'
      tit(5) = 'REDOX SPECIES'
      tit(6) = 'GASEOUS SPECIES'
c
c --  Establish component ID numbers for two binding sites and three
c     electrostatic terms for adsorbent 1.
c
      idad(1,1) = 811
      idad(1,2) = 812
      idadpsi0(1) = 813
      idadpsib(1) = 814
      idadpsid(1) = 815
c
c --  Establish component ID numbers for two binding sites and three
c     electrostatic terms for adsorbent 2.
c
      idad(2,1) = 821
      idad(2,2) = 822
      idadpsi0(2) = 823
      idadpsib(2) = 824
      idadpsid(2) = 825
c
c --  Establish component ID numbers for two binding sites and three
c     electrostatic terms for adsorbent 3.
c
      idad(3,1) = 831
      idad(3,2) = 832
      idadpsi0(3) = 833
      idadpsib(3) = 834
      idadpsid(3) = 835
c
c --  Establish component ID numbers for two binding sites and three
c     electrostatic terms for adsorbent 4.
c
      idad(4,1) = 841
      idad(4,2) = 842
      idadpsi0(4) = 843
      idadpsib(4) = 844
      idadpsid(4) = 845
c
c --  Establish component ID numbers for two binding sites and three
c     electrostatic terms for adsorbent 5.
c
      idad(5,1) = 851
      idad(5,2) = 852
      idadpsi0(5) = 853
      idadpsib(5) = 854
      idadpsid(5) = 855
c
c  -- Name the 2 different site types.
c
      sitename(1) = 'Site Type 1'
      sitename(2) = 'Site Type 2'
c
c  -- Assign names to all sites
c
      adsname(1,1) = 'ADS1TYP1'
      adsname(1,2) = 'ADS1TYP2'
      adsname(1,3) = 'ADS1PSIo'
      adsname(1,4) = 'ADS1PSIb'
      adsname(1,5) = 'ADS1PSId'
c
      adsname(2,1) = 'ADS2TYP1'
      adsname(2,2) = 'ADS2TYP2'
      adsname(2,3) = 'ADS2PSIo'
      adsname(2,4) = 'ADS2PSIb'
      adsname(2,5) = 'ADS2PSId'
c
      adsname(3,1) = 'ADS3TYP1'
      adsname(3,2) = 'ADS3TYP2'
      adsname(3,3) = 'ADS3PSIo'
      adsname(3,4) = 'ADS3PSIb'
      adsname(3,5) = 'ADS3PSId'
c
      adsname(4,1) = 'ADS4TYP1'
      adsname(4,2) = 'ADS4TYP2'
      adsname(4,3) = 'ADS4PSIo'
      adsname(4,4) = 'ADS4PSIb'
      adsname(4,5) = 'ADS4PSId'
c
      adsname(5,1) = 'ADS5TYP1'
      adsname(5,1) = 'ADS5TYP1'
      adsname(5,3) = 'ADS5PSIo'
      adsname(5,4) = 'ADS5PSIb'
      adsname(5,5) = 'ADS5PSId'
c
c --  Set flags pertaining to units for concentration.
c
      fla(1) = 'MOLAL'
      fla(2) = 'MG/L '
      fla(3) = 'PPM  '
      fla(4) = 'MEQ/L'
c
      reafor(1,1) = 'ADSORP`N PRODUCT'
      reafor(1,2) = 'ADSORP`N PRODUCT'
      reafor(1,3) = 'ADSORP`N PRODUCT'
      reafor(1,4) = 'ION EXCHANGER-M2'
      reafor(1,5) = 'ADSORP`N PRODUCT'
      reafor(1,6) = 'ADSORP`N PRODUCT'
      reafor(1,7) = 'ADSORP`N PRODUCT'
      reafor(2,1) = 'FIXED ADS. SITE '
      reafor(2,2) = 'VARIA. ADS. SITE'
      reafor(2,3) = 'FIXED ADS. SITE '
      reafor(2,4) = 'ION EXCHANGER-M1'
      reafor(2,5) = 'ADSO. SITE (SOH)'
      reafor(2,6) = 'ADSO. SITE (SOH)'
      reafor(2,7) = 'ADSO. SITE (SOH)'
      reafor(3,1) = 'AQUEOUS SPECIES '
      reafor(3,2) = 'AQUEOUS SPECIES '
      reafor(3,3) = 'AQUEOUS SPECIES '
      reafor(3,4) = '                '
      reafor(3,5) = 'AQUEOUS SPECIES '
      reafor(3,6) = 'AQUEOUS SPECIES '
      reafor(3,7) = 'AQUEOUS SPECIES '
      reafor(4,1) = '                '
      reafor(4,2) = '                '
      reafor(4,3) = '                '
      reafor(4,4) = '                '
      reafor(4,5) = 'ELECTROST. XPSIO'
      reafor(4,6) = 'ELECTROST. XPSIO'
      reafor(4,7) = 'ELECTROST. XPSIO'
      reafor(5,1) = '                '
      reafor(5,2) = '                '
      reafor(5,3) = '                '
      reafor(5,4) = '                '
      reafor(5,5) = '                '
      reafor(5,6) = 'ELECTROST.XPSIB '
      reafor(5,7) = '                '
c
c         LIMITS ON NUMBERS OF TYPES
c
      nmx0 =  999
      nmxx =   50
      nmx7 =   50
      nmx7c =   6
      imod =    0
c
c
c
c********************************************************************
c            OPEN STATEMENTS FOR THERMODYNAMIC DATABASES
c                    AND INPUT / OUTPUT FILES
c********************************************************************
c --  The general thermodynamic database --
      open (unit=lu07,file='thermo.unf',status='old',form='unformatted')
c
c --  The solids database - 
      open (unit=lu19,file='type6.unf',status='old',form='unformatted')
c      
c --  The database of redox reactions --
      open (unit=lu08,file='redox.dbs',status='old')
c
c --  The database of composite ligand reactions --
      open (unit=lu10,file='complig.dbs',status='old')
c
c --  The database of gases --
      open (unit=lu09,file='gases.dbs',status='old')
c
c --  The component database --
      open (unit=lu13,file='comp.dbs',status='old')
c
c --  The output file that will contain a log of PRODEFA2's queries
c     and the user's responses --
      open (unit=lu03,file='sample.que',status='unknown')
c
c
      call clrscr (lu06)
      write (lu06,9000) version,verdate,minteq0
      write (lu03,9000) version,verdate,minteq0
      write (lu06,9010)
      write (lu03,9010)
c
c
      write (lu06,9020)
      write (lu03,9020)
  120 write (lu06,9040) cont1
      read (lu05,9050,err=120) infil
      if (infil.eq.'X'.or.infil.eq.'x') then
  122   write (lu06,9410) cont1
        read (lu05,9060,err=122) ans
        if (ans.eq.'n') ans = 'N'
        if (ans.eq.'y') ans = 'Y'
        if (ans.ne.'N'.and.ans.ne.'Y') go to 122
        write (lu03,9410) cont2,ans
        if (ans.eq.'Y') go to 799
        go to 120
      end if
      sample = infil
      write (lu03,9040) cont2,sample
c
c
  190 call init
      call clrscr (lu06)
      imod = 0
      infil = ' '
      write (lu06,9100) cont1
      read (lu05,9050,err=190) infil
      write (lu03,9100) cont2, infil
      if (infil.eq.'R' .or. infil.eq.'r') go to 120
      if (infil.eq.' ') then
        modfile = 'N'
      else
        modfile = 'Y'
        open (unit=lu04,file=infil,status='OLD',err=205)
        open (unit=lu14,status='SCRATCH')
c
c COPY INPUT FILE TO SCRATCH FILE SO THAT THE NEW FILE CAN HAVE
c    SAME NAME
c
        rewind lu04
        rewind lu14
        go to 207
  205   write (lu06,9115)
        write (lu03,9115)
        go to 190
  207   call readp (lu04,0,iend)
        if (iend.ne.1) then
          call writep (lu14,0)
          go to 207
        end if
        endfile lu14
        rewind lu14
        close (unit=lu04)
      endif
c    --------------------------------------------------------------
c    CHANGE ME
c    If this program is to be compiled for the IBM PC, use the OPEN
c    statement without carriagecontrol specifier.  If compiling on
c    the VAX, use the statement with carriagecontrol.  Comment the
c    unused statement out.  This is the ONLY difference between the
c    PC and VAX PRODEFA2.
c
c  -- ATTENTION!  ATTENTION!  ATTENTION!  ATTENTION!  ATTENTION!
c  -- TO COMPILE ON THE VAX, COMMENT OUT THE NEXT EXECUTABLE LINE AND
c        REMOVE COMMENT DELIMITERS FROM THE NEXT TWO LINES.
c  -- TO COMPILE ON THE PC, REMOVE COMMENT DELIMITERS FROM THE NEXT
c        EXECUTABLE LINE AND COMMENT OUT THE NEXT TWO LINES.
      open (unit=lu11,file=sample,status='UNKNOWN')
c      open (unit=lu11,file=sample,status='UNKNOWN',
c     *       carriagecontrol='list')
c     --------------------------------------------------------------
c
      open (unit=lu16,file='LAST.DAT',status='UNKNOWN')
      iprb = 0
      skip14 = 'n'
 5000 iprb = iprb + 1
      if (modfile.eq.'N'.and.iprb.eq.1) go to 250
      if (modfile.eq.'N') go to 250
      if (skip14.eq.'n') call readp (lu14,0,iend)
      if (iend.eq.1) skip14 ='y'
c     
c SET UP ADSORPTION PARAMETERS
c
      do 220 i = 1, 5
         nsites(i) = 0
  220 continue
      do 230 i = 1, nt(1)
         if (id(1,i).eq.811) nsites(1) = max0(nsites(1),1)
         if (id(1,i).eq.812) nsites(1) = 2
         if (id(1,i).eq.821) nsites(2) = max0(nsites(2),1)
         if (id(1,i).eq.822) nsites(2) = 2
         if (id(1,i).eq.831) nsites(3) = max0(nsites(3),1)
         if (id(1,i).eq.832) nsites(3) = 2
         if (id(1,i).eq.841) nsites(4) = max0(nsites(4),1)
         if (id(1,i).eq.842) nsites(4) = 2
         if (id(1,i).eq.851) nsites(5) = max0(nsites(5),1)
         if (id(1,i).eq.852) nsites(5) = 2
  230 continue
c
c UPDATE CONCENTRATION FLAG
c
         do 240 i = 1, 4
            if (flag.eq.fla(i)) iflag = i
  240    continue
c
c                    ********   EDIT   LEVEL   ONE   ********
c  -- Return to here to display current settings of titles, program flag
c     temperature, ionic strength, units of concentration, etc.  The use
c     is given opportunity to change these settings.
c
  250    continue
         call editlvl1 (imod)
         if (imod.gt.0) go to 275
c
  260    call excludee
         call fixorder	        
c
c
  270    call clrscr (lu06)
         write (lu06,9120) iprb, cont1
         read (lu05,9060,err=270) edit
         if (edit.eq.'m') edit = 'M'
         if (edit.eq.'x') edit = 'X'
         write (lu03,9120) iprb, cont2, edit
         if (edit.ne.'1'.and.edit.ne.'2'.and.edit.ne.'3'
     *     .and.edit.ne.'4'.and.edit.ne.'M'.and.edit.ne.'X') go to 270
         call clrscr (lu06)
         if (edit.eq.'X') then
            call fini (ifail)
            if (ifail.eq.1) then
  721         write (lu06,9410) cont1
              read (lu05,9060,err=721) ans
              if (ans.eq.'n') ans = 'N'
              if (ans.eq.'y') ans = 'Y'
              if (ans.ne.'N'.and.ans.ne.'Y') go to 721
              write (lu03,9410) cont2,ans
              if (ans.eq.'Y') then
                go to 799
              else 
                rewind lu16
                rewind lu11
                go to 270 
              end if
            end if
            go to 799
         elseif (edit.eq.'1') then
            go to 250
         elseif (edit.eq.'2') then
            imod = 0
            go to 460
         elseif (edit.eq.'3') then
            call editlvl3
            go to 270
         elseif (edit.eq.'4') then
            call editlvl4
            go to 270
         elseif (edit.eq.'M') then
            call clrscr (lu06)
  271       write (lu06,9600) iprb, iprb+1, iprb+1, cont1
            read (lu05,9060,err=271) ans
            if (ans.eq.'r') ans = 'R'
            if (ans.ne.' '.and.ans.ne.'R') go to 271
            write (lu03,9600) iprb, iprb+1, iprb+1, cont2, ans
            if (ans.eq.'R') go to 270
            call fini (ifail)
            if (ifail.eq.1) then
  722         write (lu06,9410) cont1
              read (lu05,9060,err=722) ans
              if (ans.eq.'n') ans = 'N'
              if (ans.eq.'y') ans = 'Y'
              if (ans.ne.'N'.and.ans.ne.'Y') go to 722
              write (lu03,9410) cont2,ans
              if (ans.eq.'Y') then
                go to 799
              else 
                go to 270
              end if
            end if
            go to 5000
         endif
  275    if (imod.eq.99) go to 190
         go to (290,310,330,320,350,550,400,410,390,440,450,
     *          540,560,565,250), imod
c
c** DEFINE LINES 1 AND 2 OF PROBLEM DEFINITION FILE AND TRANSFER TO F
c
  290    continue
         call clrscr (lu06)
  300    write (lu06,9130) '1'
         read (lu05,9140,err=300) tmpdesc
         if (tmpdesc.eq.'r') tmpdesc = 'R'
         if (tmpdesc.ne.' '.and.tmpdesc.ne.'R') desc = tmpdesc
         if (iprb.eq.1.and.tmpdesc.eq.'R') go to 190
         write (lu03,9130) '1', desc
c
         if (imod.eq.1)  go to 250
  310    continue
         write (lu06,9130) '2'
         read (lu05,9140,err=310) carry
         if (carry.eq.'r') carry = 'R'
         write (lu03,9130) '2', carry
         if (iprb.eq.1.and.carry.eq.'R') go to 300
         if (imod.eq.2) go to 250
c
c  -- Select units of concentration.  First check whether there are
c     any currently defined components (perhaps there are if this is
c     a modification of an existing file or if the user has
c     chosen to change units after specifying several components).
c
c --  If there are currently defined components and:
c     - If their total concentrations are given in molal, inform the
c       user that the conversion to any other units (mg/l, ppm,
c       or meq/l) is done with the assumption that molarity is a
c       sufficient approximation for molality.
c
c     - If their total concentrations are given in mg/l, ppm, or meq/l
c       and the user wishes to change to molal, the switch to molal
c       must be done after all components have been defined and the
c       complete chemistry is known to PRODEFA2.
c
c  -- Perform no conversion of any kind on adsorption site or
c     electrostatic concentrations or on the electron and prevent
c     their contribution to the calculation of any conversion factor.
c
c  -- In general, the conversion formulas are identical to those
c     in MINTEQA2.
c
  320    continue
         oldflag = iflag
         write (lu06,9150) cont1
         read (lu05,9060,err=320) ans
         if (ans.eq.' ') ans = '1'
         if (ans.ne.'1'.and.ans.ne.'2'.and.ans.ne.'3'.and.ans.ne.'4')
     *        go to 320
         write (lu03,9150) cont2,iflag
         if (ans.eq.'1'.or.ans.eq.' ') then
           iflag = 1
         else if (ans.eq.'2') then
           iflag = 2
         else if (ans.eq.'3') then
           iflag = 3
         else if (ans.eq.'4') then
           iflag = 4
         end if
         if (iflag.eq.oldflag) go to 250
c  -- If there are no currently defined components, update the units
c     flag and proceed.
         if (nt(1).eq.0) go to 329
c
c  -- Conversion of molal to any other unit can be done only with the
c     assumption that molarity is a sufficient approximation for molality.
         if (oldflag.eq.1) then
           write (lu06,9151)
           write (lu03,9151)
  321      write (lu06,9152) cont1
           read (lu05,9060,err=321) ans
           if (ans.eq.'n') ans = 'N'
           if (ans.eq.'y'.or.ans.eq.' ') ans = 'Y'
           write (lu03,9152) cont2, ans
           if (ans.ne.'N'.and.ans.ne.'Y') go to 321
           if (ans.eq.'N') go to 250
           do 322 i = 1, nt(1)
              if (id(1,i).le.002.or.(id(1,i).ge.811.and.id(1,i).le.859)
     *           .or.(id(1,i).ge.145.and.id(1,i).le.149)) go to 322
              if (teq(1,i).eq.0.0) go to 322
c
             if (iflag.eq.2) then
c  -- Convert molarity to mg/l.
               teq(1,i) = teq(1,i) * 1000.0 * gfw(i)
c
             else if (iflag.eq.3) then
c  -- Convert molarity to ppm.
               teq(1,i) = teq(1,i) * 1000.0 * gfw(i) / denh2o
c
             else if (iflag.eq.4) then
c  -- Convert molarity to meq/l.
               teq(1,i) = teq(1,i) * 1000.0 * max1(1.0,abs(spz(i)))
c
             end if
  322      continue
           go to 329
c
         else if (oldflag.ne.1.and.iflag.ne.1) then
c
           do 323 i = 1, nt(1)
              if (id(1,i).le.002.or.(id(1,i).ge.811.and.id(1,i).le.859)
     *           .or.(id(1,i).ge.145.and.id(1,i).le.149)) go to 323
              if (teq(1,i).eq.0.0) go to 323
c
             if (oldflag.eq.2.and.iflag.eq.3) then
c  -- Convert mg/l to ppm
               teq(1,i) = teq(1,i) / denh2o
c
             else if (oldflag.eq.2.and.iflag.eq.4) then
c  -- Convert mg/l to meq/l
               teq(1,i) = teq(1,i) * max1(1.0,abs(spz(i))) / gfw(i)
c
             else if (oldflag.eq.3.and.iflag.eq.2) then
c  -- Convert ppm to mg/l
               teq(1,i) = teq(1,i) * denh2o
c
             else if (oldflag.eq.3.and.iflag.eq.4) then
c  -- Convert ppm to meq/l
               teq(1,i) = teq(1,i) * max1(1.0,abs(spz(i))) * denh2o
     *                  / gfw(i)
c
             else if (oldflag.eq.4.and.iflag.eq.2) then
c  -- Convert meq/l to mg/l
               teq(1,i) = teq(1,i) * gfw(i) / max1(1.0,abs(spz(i)))
c
             else if (oldflag.eq.4.and.iflag.eq.3.and.nt(1).ne.0) then
c  -- Convert meq/l to ppm
               teq(1,i) = teq(1,i) * gfw(i) / max1(1.00,abs(gfw(i)))
     *                   / denh2o
c
             end if
  323      continue
c
c  -- Conversion of any other unit to molal can be done only before
c     any components are defined or after all components are defined.
         else if (oldflag.ne.1.and.iflag.eq.1) then
           write (lu06,9153)
           write (lu03,9153)
  331      write (lu06,9152) cont1
           read (lu05,9060,err=331) ans
           if (ans.eq.'n') ans = 'N'
           if (ans.eq.'y'.or.ans.eq.' ') ans = 'Y'
           write (lu03,9152) cont2, ans
           if (ans.ne.'N'.and.ans.ne.'Y') go to 331
           if (ans.eq.'N') go to 250
           if (oldflag.le.3) then
             cc1 = 0.0
             do 324 i = 1, nt(1)
              if (id(1,i).le.002.or.(id(1,i).ge.811.and.id(1,i).le.859)
     *           .or.(id(1,i).ge.145.and.id(1,i).le.149)) go to 324
              if (teq(1,i).eq.0.0) go to 324
               cc1 =  cc1 + teq(1,i)
  324        continue
             if (oldflag.eq.2) then
               cfactor = (1.0 - cc1 *  1.0e-06 / denh2o)* denh2o
             else if (oldflag.eq.3) then
               cfactor = 1.0 - cc1 *  1.0e-06
             end if
             do 326 i = 1, nt(1)
              if (id(1,i).le.002.or.(id(1,i).ge.811.and.id(1,i).le.859)
     *           .or.(id(1,i).ge.145.and.id(1,i).le.149)) go to 326
              if (teq(1,i).eq.0.0) go to 326
               teq(1,i) = teq(1,i) / cfactor / gfw(i) / 1000.0
  326        continue
           else
             cc1 = 0.0
             do 327 i = 1, nt(1)
              if (id(1,i).le.002.or.(id(1,i).ge.811.and.id(1,i).le.859)
     *           .or.(id(1,i).ge.145.and.id(1,i).le.149)) go to 327
              if (teq(1,i).eq.0.0) go to 327
               cc1 = cc1 + teq(1,i) * gfw(i) /
     *               max1(1.0,abs(spz(i))) / denh2o
  327        continue
             cfactor = 1.0 - cc1 * 1.0e-06
             do 328 i = 1, nt(1)
              if (id(1,i).le.002.or.(id(1,i).ge.811.and.id(1,i).le.859)
     *           .or.(id(1,i).ge.145.and.id(1,i).le.149)) go to 328
              if (teq(1,i).eq.0.0) go to 328
               teq(1,i) = teq(1,i) / max1(1.0,abs(spz(i)))
     *                    / cfactor / denh2o / 1000.0
  328        continue
           end if
         end if
  329    flag = fla(iflag)
         if (imod.eq.4) go to 250
  330    continue
         write (lu06,9160) cont1
         read (lu05,*,err=330) temp
         if (temp.le.0.or.temp.gt.100) go to 330
         write (lu03,9160) cont2,temp
         if (imod.eq.3) go to 250
  340    continue
  350    continue
         write (lu06,9170) cont1
         read (lu05,9060,err=340) ans
         if (ans.eq.'n'.or.ans.eq.' ') ans = 'N'
         if (ans.eq.'y') ans = 'Y'
         write (lu03,9170) cont2,ans
         if (ans.ne.'Y'.and.ans.ne.'N') go to 350
         if (ans.eq.'N') go to 370
  360    write (lu06,9180) cont1
         read (lu05,*,err=360) fions
         if (fions.lt.0.0) go to 360
         write (lu03,9180) cont2,fions
         isopt = 1
         go to 380
  370    fions = 0.0
         isopt = 0
  380    call writep (lu16,1)
         if (imod.eq.5) go to 250
c
c** NUMBER OF ITERATIONS
c
  390    write (lu06,9190) cont1
c
         read (lu05,9060,err=390) ans
         if (ans.eq.' ') ans = '0'
         if (ans.ne.'0'.and.ans.ne.'1'.and.ans.ne.'2'.and.ans.ne.'3')
     *      go to 390
         write (lu03,9190) cont2,ans
         if (ans.eq.'0') then
           niter = 0
         else if (ans.eq.'1') then
           niter = 1
         else if (ans.eq.'2') then
           niter = 2
         else if (ans.eq.'3') then
           niter = 3
         end if
         call writep (lu16,1)
         if (imod.eq.9) go to 250
  400    continue
         write (lu06,9210) cont1
         read (lu05,9060,err=400) ans
         if (ans.eq.'N'.or.ans.eq.' ') ans = 'n'
         if (ans.eq.'Y') ans = 'n'
         write (lu03,9210) cont2,ans
         if (ans.ne.'n'.and.ans.ne.'y') go to 400
         ichrg = 0
         if (ans.eq.'n') ichrg = 1
         call writep (lu16,1)
         if (imod.eq.7) go to 250
  410    continue
         write (lu06,9220) cont1
         read (lu05,9060,err=410) ans
         if (ans.eq.'N'.or.ans.eq.' ') ans = 'n'
         if (ans.eq.'Y') ans = 'y'
         write (lu03,9220) cont2,ans
         if (ans.ne.'n'.and.ans.ne.'y') go to 410
         iprint = 0
         if (ans.eq.'n') go to 430
  420    write (lu06,9230) cont1
         read (lu05,9060,err=420) ans
         if (ans.eq.'R') ans = 'r' 
         if (ans.ne.'1'.and.ans.ne.'2'.and.ans.ne.'r'.and.
     *       ans.ne.' ') go to 420
         write (lu03,9230) cont2,ans
         if (ans.eq.'r'.or.ans.eq.' ') then
           go to 410
         else if (ans.eq.'1') then
           iprint = 1
         else if (ans.eq.'2') then
           iprint = 2
         end if   
  430    call writep (lu16,1)
         if (imod.eq.8) go to 250
         idbg = 0
         call writep (lu16,1)
c
         ibacks = 0
  440    continue
         write (lu06,9240) cont1
         read (lu05,9060,err=440) ans
         if (ans.eq.' ') ans = '1'
         if (ans.ne.'1'.and.ans.ne.'2') go to 440
         write (lu03,9240) cont2, ans
         if (ans.eq.'1') then
           kkdav = 1
         else if (ans.eq.'2') then
           kkdav = 2
         end if   
         call writep (lu16,1)
         if (imod.eq.10) go to 250
  450    continue
         write (lu06,9250) cont1
         read (lu05,9060,err=450) ans
         if (ans.eq.'R') ans = 'r'
         if (ans.eq.' ') ans = '2'
         if (ans.ne.'1'.and.ans.ne.'2'.and.ans.ne.'3'.and.
     *       ans.ne.'r') go to 450
         write (lu03,9250) cont2, ans
         if (ans.eq.'r'.and.imod.eq.11) then
           go to 451
         else if (ans.eq.'r'.and.imod.ne.11) then
           go to 440
         end if
         if (ans.eq.'1') then
            kkthr = 0
         else if (ans.eq.'2') then
            kkthr = 1
         else if (ans.eq.'3') then
            kkthr = 2
         end if
         call writep (lu16,1)
  451    if (imod.eq.11) go to 250
c
         if (ans.eq.'R') agus = ' '
  460    call editlvl2
         go to 260
c   DEFINE HYDROGEN CONTENT
c** PH, TOTH
c
  540    continue
         call clrscr (lu06)
         title = 'H+1'
         ntysp = 1
         iupdat = 0
         if (imod.eq.12) iupdat = 1
         call cominc (nty,330,title,'N',iupdat)
         go to 250
c
c** DEFINE CARBONATE CONTENT
c
  550    continue
         call clrscr (lu06)
         title = 'CARBONATE'
         ntysp = 1
         iupdat = 0
         if (imod.eq.6) iupdat = 1
         call cominc (nty,140,title,'N',iupdat)
         call writep (lu16,1)
         go to 250
c
c    DEFINE REDOX POTENTIAL
c
  560    call clrscr (lu06)
         title = 'E-       '
         ntysp = 1
         iupdat = 0
         if (imod.eq.13) iupdat = 1
         call cominc (nty,1,title,'N',iupdat)
         go to 250
c
c  --  Change the number of kg of soil for the Activity Kd model.
  565    call clrscr (lu06)
         if (iabq.eq.1) then
  566      write (lu06,9031) cont1
           read (lu05,*,err=566) soilkg
           if (soilkg.lt.0.0) go to 566
          write (lu03,9031) cont2,soilkg
         end if
         go to 250
c
  799 continue
      close (unit=lu11)
      write (lu06,*) '[0m'
      call clrscr (lu06)
      if (ifail.eq.0) write (lu06,9420) sample
      if (ifail.eq.0) write (lu03,9420) sample
      if (iprb.gt.1) write (lu06,9430)
      if (iprb.gt.1) write (lu03,9430)
      stop
c
c
 9000 format (/,'         _______________________________________',
     *   '________________________',/,
     *   '         *                                      ',
     *   '                       *',/,
     *   '         *                       P R O D E F A 2',
     *   '                       *',/,
     *   '         *                                      ',
     *   '                       *',/,
     *   '         *                    Version ',a4,' ',a8,
     *   '                    *',/,
     *   '         *                                      ',
     *   '                       *',/,
     *   '         *       PRODEFA2 is an interactive program',
     *   ' used to build      *',/,
     *   '         *                input files for ',a14,'.',
     *   '              *',/,
     *   '         *                                      ',
     *   '                       *',/,
     *   '         _______________________________________',
     *   '________________________')
 9010 format (/,'        If you encounter errors, please print the',
     *   ' file named SAMPLE.QUE ',/,
     *   '        or copy it to a diskette and send along with',
     *   ' a description of the',/,
     *   '        problem you were attempting to model to:',
     *   ' Jerry D. Allison,',/,
     *   '        USEPA Environmental Research Lab, College',
     *   ' Station Rd., Athens, GA 30613.')
 9020 format (//,'        In responding to prompts, use: Y or y = Yes,',
     *           ' N or n = No,',
     * /,'        R or r = Return to previous prompt (where',
     *   ' applicable).',
     * /,'        [D]=  the default choice obtained by pressing ENTER.')
 9040 format (/,'        Enter the name of the MINTEQA2 input file to',
     *          ' be created.',
     * /,'        Use up to 8 characters PLUS from 0 to 3 characters',
     *          ' for an extension.',
     * /,a1,'        ENTER FILENAME (enter "X" to exit PRODEFA2) > ',
     *   a16)
 9050 format (a16)
 9060 format (a1)
 9100 format (/,' If you want to use an existing MINTEQA2 input',
     *          ' file as a "seed" file to be',
     *        /,' copied into PRODEFA2 and modified, enter the',
     *          ' filename.  Otherwise: ',
     *        /,'  --  Enter an R to return to the previous question,',
     *          ' or',
     *        /,'  --  Simply press ENTER to start a new file from',
     *          ' scratch.',
     *    //,a1,' ENTER filename, R, or press ENTER > ',1x,a16)
 9115 format (/,'  The file specified does not exist.')
 9120 format (' _________________ M A I N  M E N U:  S E L E C T  O P',
     *   ' T I O N _____PROB # ',i2,'__',//,
     *   '     1 = EDIT LEVEL I  (Change ionic strength, pH,',
     *   ' Eh, temperature, adsorption',/,
     *   '         parameters, number of iterations,',
     *   ' precipitation options, etc.)',//,
     *   '     2 = EDIT LEVEL II  (Specify components, gas,',
     *   ' redox, aqueous, and mineral',/,
     *   '         species, adsorption sites and reactions,',
     *   ' add new species of all types)',//,
     *   '     3 = EDIT LEVEL III  (Check, individually edit all',
     *   ' entries)',//,
     *   '     4 = EDIT LEVEL IV  (Sweep a range of pH, pE, or',
     *   ' dissolved concentration;',/,
     *   '         Designate an auxillary MINTEQA2 output file to',
     *   ' receive equilibrated',/,
     *   '         output for spreadsheet import.)',//,
     *   '     M = MULTI-PROBLEM GENERATOR',//,
     *   '     X = EXIT  (Write the current problem to',
     *   ' the new MINTEQA2 input file',/,
     *   '         and EXIT PROGRAM)',//,
     *a1,'       ENTER CHOICE  > ',1x,a1)
 9130 format (/,'  Enter problem title (',a1,' of 2 lines),',
     *        / '   OR press ENTER to omit title,',
     *        /,'   OR enter "R" to return to previous prompt: ',
     *        /,1x,a66)
 9140 format (a66)
 9150 format (/,'  Select units for concentration.  Because these are',
     *   ' dilute solutions,',/
     *   '  you can approximate molal concentrations with molar',
     *   ' concentrations',/'  with negligible error.',/,'    1 = molal'
     *   ,/,'    2 = mg/l ',/,'    3 = ppm ',/,'    4 = meq/l ',/,a1,
     *   '     ENTER CHOICE  ([D] = 1) > ',1x,a1)
 9151 format (/,'  For conversion from molality to any other unit,',
     *          ' it is assumed that'
     *        /,'  molarity is a sufficient approximation for',
     *          ' molality.',
     *        /,'  This assumption is generally good for the dilute',
     *          ' solutions for which',
     *        /,'  MINTEQA2 is valid.')
 9152 format (/,a1,'  Do you want to proceed with the conversion ?',
     *             ' (Y,N,[D]=Y) > ',1x,a1)
 9153 format (/,'  For conversion of any other units to molality, you',
     *          ' must wait until',
     *        /,'  all aqueous components have been specified.  If you',
     *          ' have other components',
     *        /,'  specify those in the currently defined',
     *          ' concentration units,'
     *        /,'  then proceed with this option.')
 9160 format (/,a1,
     *   ' Enter the temperature between 0 and 100 degrees C. > ',f6.2)
 9170 format (/,a1,' Should the ionic strength be fixed? (Y,N,[D]=N) > '
     *         ,1x,a1)
 9180 format (/,a1,' Enter fixed ionic strength (molal) > ',f10.3)
 9190 format (/,'  Select maximum number of iterations: ',/,
     *   '    0 =  40 iterations ',/,'    1 =  10 iterations ',/,
     *   '    2 = 100 iterations ',/,'    3 = 200 iterations ',/,a1,
     *   '       ENTER CHOICE  ([D] = 0) > ',1x,a1)
 9210 format (/,a1,' Terminate if initial charge imbalance exceeds ',
     *   '30% ? (Y,N,[D]=N) > ',1x,a1)
 9220 format (/,a1,' Are all oversaturated solids to be allowed to',
     *   ' precipitate? (Y,N,[D]=N) > ',1x,a1)
 9230 format (/'  Select the solids output print option:',
     *      /,'    1 = Only after the final answer is reached',
     *      /,'    2 = Each time a mineral precipitates or dissolves',
     *      /,'    R = Return to previous question',/,
     *   /,a1,'       ENTER CHOICE ([D] = R) > ',1x,a1)
 9240 format (/,'  Select an activity coefficient algorithm:',
     *        /,'    1 = Davies Equation ',
     *        /,'    2 = Extended Debye-Huckel ',
     *     /,a1,'       ENTER CHOICE ([D] = 1) >  ',1x,a1)
 9250 format (/'  Select the output option:',
     *  /,'    1 = FULL',
     *  /,'    2 = INTERMEDIATE (omit some of the thermodynamic data',
     *  /,'        read from the database:  uncorrected log K values,',
     *           ' gfw, etc.)',
     *  /,'    3 = ABBREVIATED (mass distribution at equilibrium only)',
     *  /,'    R = Return to previous question',
     *  /,a1,'       ENTER CHOICE ([D] = 2) > ',1x,a1)
 9410 format (/,a1,'  Do you want to exit from the program ?',
     *   ' (Y,N) > ',a1)
 9420 format (' A Problem File Named ',a12,' Has Now Been Generated.'/
     *   ' It Can Be Modified By This Same Program By Recalling It ',
     *   'As The Old File.')
 9430 format (' The last problem of this multi-problem set is in ',
     *   ' file "LAST.DAT"')
 9600 format (/,' Press ENTER to write PROBLEM ',i2,' to the new',
     *          ' MINTEQA2 input file and to generate',
     *        /,' an identical PROBLEM ',i2,' for further',
     *          ' modification or, if you are using',
     *        /,' a multi-problem "seed" file, to read PROBLEM ',i2,
     *          ' from there.',
     *     /,a1,' (ENTER R or r to return to previous menu.) > ',1x,a1)
 9031 format (/,'  Enter the mass of soil (kg) to which one liter',
     *          ' of solution',
     *  /,a1,' is exposed.  > ',1pe12.5)
      end
