      SUBROUTINE AQ2REA
     I                  (MESSFL,SUCIFL)
C
C     + + + PURPOSE + + +
C     routine to read in existing QUAL2E input sequence
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER     MESSFL,SUCIFL
C
C     + + + ARGUMENT DEFINITIONS + + +
C     MESSFL - unit number for message file
C     SUCIFL - input number for input file
C     TBUFF  - buffer to read in input file
C     RETCOD - return code, 0 - no problems,
C              non 0 - number indicates which table error occured on
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'CQ2VAL.INC'
C
C     + + + LOCAL VARIABLES + + +
      INTEGER     I,I8,J,K,L,LEN,SCLU,SGRP,RETCOD
      REAL        R1,R2,RX(20),CTHEVL,RNONE
      CHARACTER*1 TCHR(4),ENDA(4),LTHET(8),LOCA(4),TEMP(4),BODCHR(1)
C
C     + + + FUNCTIONS + + +
      INTEGER     STRFND
C
C     + + + EXTERNALS + + +
      EXTERNAL   STRFND, ZIPR, PRNTXI, GETTXT, PMXCNW
C
C     + + + DATA INITIALIZATIONS + + +
      DATA ENDA/'E','N','D','A'/
      DATA LOCA/'L','O','C','A'/
      DATA TEMP/'T','E','M','P'/
C
C     + + + READ FORMATS + + +
1000  FORMAT (80A1)
1010  FORMAT (21X,59A1)
1011  FORMAT (9X,3A1,36X,4A1,4X,4A1)
1012  FORMAT (9X,3A1,9X,A1)
1020  FORMAT (25X,F10.0,35X,F10.0)
1030  FORMAT (4A1,28X,F7.0,34X,F7.0)
1040  FORMAT (4A1,5X,8A1,1X,F8.0)
1050  FORMAT (4A1,11X,F5.0,4X,16A1,10X,F10.0,10X,F10.0)
1060  FORMAT (4A1,21X,F5.0,5X,F5.0,F10.0,6F5.0)
1070  FORMAT (4A1,21X,F5.0,10X,20F2.0)
1080  FORMAT (4A1,11X,F5.0,2X,F8.0,5F10.0)
1085  FORMAT (4A1,11X,F5.0,4X,8F7.0)
1090  FORMAT (4A1,11X,F5.0,3F8.0,F4.0,3F8.0)
1100  FORMAT (4A1,15X,F5.0,8F7.0)
1140  FORMAT (4A1,15X,F5.0,2F7.0,7F6.0)
1160  FORMAT (4A1,16X,F5.0,9X,16A1,3(5X,F5.0))
1170  FORMAT (4A1,10X,F5.0,16A1,F9.0,6F6.0)
1180  FORMAT (4A1,11X,F5.0,9F6.0)
1190  FORMAT (4A1,10X,F5.0,12A1,F5.0,F8.0,6F6.0)
1210  FORMAT (4A1,15X,F5.0,6F6.0)
1230  FORMAT (4A1,36X,3F8.0,F6.0,1X,F8.0)
1240  FORMAT (10X,14I5)
C
C     + + + END SPECIFICATIONS + + +
C
      LEN  = 4
      I8   = 8
      SCLU = 5
      RNONE= -999.
C
C     reading input sequence
      SGRP= 13
      I= 1
      CALL PMXCNW (MESSFL,SCLU,SGRP,I,I,I,J)
C
C     read titles form 1
      RETCOD= 1
      READ (SUCIFL,1010,ERR=900) QTITLE
      READ (SUCIFL,1010,ERR=900) BNAME
      DO 10 I= 1,11
        IF (I.LE.3.OR.I.EQ.11) THEN
          K= I
          IF (K.EQ.11) K= 4
          READ (SUCIFL,1011,ERR=900) (CSOPT(J,I),J=1,3),
     1            (CNAME(J,K),J=1,4),(CUNITS(J,K),J=1,4)
        ELSE IF (I.EQ.5) THEN
C         need to see which type of BOD simulation
          READ (SUCIFL,1012,ERR= 900) (CSOPT(J,I),J=1,3),BODCHR
          IF (BODCHR(1).EQ.'5') THEN
C           5-DAY
            BODOPT= 2
          ELSE
C           ultimate BOD
            BODOPT= 1
          END IF
        ELSE
          READ (SUCIFL,1011,ERR=900) (CSOPT(J,I),J=1,3)
C         skip blank titles
          IF (I.EQ.7.OR.I.EQ.8) READ (SUCIFL,1000,ERR=900)
        END IF
        NSOPT(I)= 2
        IF (CSOPT(1,I).EQ.'Y') NSOPT(I)= 1
 10   CONTINUE
      READ (SUCIFL,1000,ERR=900)
C
C     read form 2
      RETCOD= 2
      DO 20 I= 1,7
        READ (SUCIFL,1000,ERR=900) TCHR(1)
        NPOPT(I)= 1
        IF (TCHR(1).EQ.'N') NPOPT(I)= 2
        IF ((I.EQ.4.OR.I.EQ.5).AND.TCHR(1).EQ.'D') NPOPT(I)= 2
 20   CONTINUE
C     ***** need to add something here for missing cards ***
      DO 25 I= 1,10
        READ (SUCIFL,1020,ERR=900) R1,R2
        IF (I.GE.5) THEN
          J= (I-5)* 2+ 1
          PCRVL(J)  = R1
          PCRVL(J+1)= R2
        ELSE IF (I.GT.2) THEN
          J= (I-2)* 2+ 2
          PCIVL(J)  = R1
          PCIVL(J+1)= R2
        ELSE IF (I.EQ.2) THEN
C         no is 2 internally except for METFLG
          METFLG  = R1
          PCIVL(3)= R2
          IF (PCIVL(3).EQ.0) PCIVL(3)= 2
        ELSE
          PCIVL(1)  = R1
          IF (PCIVL(1).EQ.0) PCIVL(1)= 2
          PCRVL(13) = R2
        END IF
 25   CONTINUE
      MAXITR= PCRVL(3)
      READ (SUCIFL,1000,ERR=900)
C
C     read from 3
      RETCOD= 3
      I     = 0
 30   CONTINUE
        I= I+ 1
        J= (I-1)* 2+ 1
        READ (SUCIFL,1030,ERR=900) TCHR,GPARM(J),GPARM(J+1)
        J= STRFND(LEN,TCHR,LEN,ENDA)
      IF (I.LT.11.AND.J.EQ.0) GO TO 30
      IF (J.EQ.0) READ (SUCIFL,1000,ERR=900)
C
C     read form 4
      RETCOD= 4
      I= 0
 40   CONTINUE
        I= I+ 1
        READ (SUCIFL,1040,ERR=900) TCHR,LTHET,CTHEVL
        J= 152
        K= 8
        THEIND(I)= 0
        L= STRFND(J,NTHET,K,LTHET)
        IF (L.GT.0) THEN
C         THETA name found, set index and value
          K= 1+ (L-1)/8
          THEIND(I)= K
          THEVAL(K)= CTHEVL
        ELSE
C         not a valid THETA name, dont count it
          I= I- 1
        END IF
        LEN= 4
        J= STRFND(LEN,TCHR,LEN,ENDA)
      IF (I.LT.20.AND.J.EQ.0) GO TO 40
      IF (J.EQ.0) READ (SUCIFL,1000,ERR=900)
C
C     read form 5
      RETCOD= 5
      I     = 0
 50   CONTINUE
        I= I+ 1
        READ (SUCIFL,1050,ERR=900) TCHR,DAT2(1,I),(RCHNAM(J,I),J=1,16),
     1                             DAT2(2,I),DAT2(3,I)
        J= STRFND(LEN,TCHR,LEN,ENDA)
      IF (I.LT.MXRCH.AND.J.EQ.0) GO TO 50
      IF (J.EQ.0) READ (SUCIFL,1000,ERR=900)
C
C     read form 6
      RETCOD= 6
      I     = 0
 60   CONTINUE
        I= I+ 1
        READ (SUCIFL,1060,ERR=900) TCHR,DAT3R(1,I),R1,(DAT3R(J,I),J=2,8)
        J= STRFND(LEN,TCHR,LEN,ENDA)
        IF (J.EQ.0) DAT3I(I)= R1
        IF (J.GT.0 .AND. I.EQ.1) THEN
C         no data to be read, reset needed values
          DAT3R(1,I)= 1.
        END IF
      IF (I.LT.MXRCH.AND.J.EQ.0) GO TO 60
      IF (J.EQ.0) READ (SUCIFL,1000,ERR=900)
C
C     read form 7
      RETCOD= 7
      I     = 0
 70   CONTINUE
        I= I+ 1
        READ (SUCIFL,1070,ERR=900) TCHR,R1,RX
        NCMPEL(I)= R1
        DO 75 J= 1,NCMPEL(I)
          CMPELF(J,I)= RX(J)
 75     CONTINUE
        J= STRFND(LEN,TCHR,LEN,ENDA)
      IF (I.LT.MXRCH.AND.J.EQ.0) GO TO 70
      IF (J.EQ.0) READ (SUCIFL,1000,ERR=900)
C
C     read form 8
      RETCOD= 8
      I     = 0
 80   CONTINUE
        I= I+ 1
        READ (SUCIFL,1080,ERR=900) TCHR,(DAT5(J,I),J=1,7)
        J= STRFND(LEN,TCHR,LEN,ENDA)
      IF (I.LT.MXRCH.AND.J.EQ.0) GO TO 80
      IF (J.EQ.0) READ (SUCIFL,1000,ERR=900)
C
C     read form 8a
      RETCOD= 8
      I     = 0
      READ (SUCIFL,1000,ERR=900) TCHR
      K= STRFND(LEN,TCHR,LEN,TEMP)
      IF (K.GT.0) THEN
C       5A data exists, start reading it
        BACKSPACE SUCIFL
 85     CONTINUE
          I= I+ 1
          READ (SUCIFL,1085,ERR=900) TCHR,(DAT5A(J,I),J=1,8)
          J= STRFND(LEN,TCHR,LEN,ENDA)
          K= STRFND(LEN,TCHR,LEN,TEMP)
        IF (I.LT.MXRCH.AND.J.EQ.0.AND.K.EQ.1) GO TO 85
        IF (J.EQ.0) READ (SUCIFL,1000,ERR=900)
        IF (I.GT.1.AND.I.LT.MXRCH) THEN
C         only one line in input sequence, fill in remaining reaches
          DO 89 K= I,MXRCH
            DO 87 J= 1,8
              DAT5A(J,K)= DAT5A(J,1)
 87         CONTINUE
 89       CONTINUE
        END IF
      ELSE
C       TEMP not found - no 5A data
        IF (STRFND(LEN,TCHR,LEN,ENDA).EQ.0) THEN
C         no ENDATA5A found
          BACKSPACE SUCIFL
        END IF
        DAT5A(1,1)= RNONE
C       indicate Local Clim to be used
        CLDAT(1,1)= 1.0
      END IF
C
C     read form 9
      RETCOD= 9
      I     = 0
 90   CONTINUE
        I= I+ 1
        READ (SUCIFL,1090,ERR=900) TCHR,(DAT6(J,I),J=1,8)
        J= STRFND(LEN,TCHR,LEN,ENDA)
        IF (J.GT.0 .AND. I.EQ.1) THEN
C         no data values read, reset needed values
          DAT6(1,I)= 1.0
          DAT6(2,I)= 0.23
          DAT6(5,I)= 3.0
        END IF
      IF (I.LT.MXRCH.AND.J.EQ.0) GO TO 90
      IF (J.EQ.0) READ (SUCIFL,1000,ERR=900)
C
C     read form 10
      RETCOD= 10
      I     = 0
100   CONTINUE
        I= I+ 1
        READ (SUCIFL,1100,ERR=900) TCHR,(DAT6A(J,I),J=1,9)
        J= STRFND(LEN,TCHR,LEN,ENDA)
        IF (J.GT.0 .AND. I.EQ.1) THEN
C         no data values to be read, reset needed values
          DAT6A(1,I)= 1.0
          DAT6A(2,I)= 0.2
          DAT6A(4,I)= 0.2
        END IF
      IF (I.LT.MXRCH.AND.J.EQ.0) GO TO 100
      IF (J.EQ.0) READ (SUCIFL,1000,ERR=900)
C
C     read form 11
      RETCOD= 11
      I     = 0
110   CONTINUE
        I= I+ 1
        READ (SUCIFL,1100,ERR=900) TCHR,(DAT6B(J,I),J=1,8)
        J= STRFND(LEN,TCHR,LEN,ENDA)
        IF (J.GT.0 .AND. I.EQ.1) THEN
C         no data values to be read, reset needed values
          DAT6B(1,I)= 1.0
          DAT6B(2,I)= 10.0
          DAT6B(3,I)= 0.6
          DAT6B(4,I)= 0.04
        END IF
      IF (I.LT.MXRCH.AND.J.EQ.0) GO TO 110
      IF (J.EQ.0) READ (SUCIFL,1000,ERR=900)
C
C     read form 12
      RETCOD= 12
      I     = 0
120   CONTINUE
        I= I+ 1
        READ (SUCIFL,1100,ERR=900) TCHR,(DAT7(J,I),J=1,9)
        J= STRFND(LEN,TCHR,LEN,ENDA)
        IF (J.GT.0 .AND. I.EQ.1) THEN
C         no data values read, reset needed values
          DAT7(1,I)= 1.0
          DAT7(2,I)= 70.0
        END IF
      IF (I.LT.MXRCH.AND.J.EQ.0) GO TO 120
      IF (J.EQ.0) READ (SUCIFL,1000,ERR=900)
C
C     read form 13
      RETCOD= 13
      I     = 0
130   CONTINUE
        I= I+ 1
        READ (SUCIFL,1100,ERR=900) TCHR,(DAT7A(J,I),J=1,8)
        J= STRFND(LEN,TCHR,LEN,ENDA)
        IF (J.GT.0 .AND. I.EQ.1) THEN
C         no data values read, reset needed values
          DAT7A(1,I)= 1.0
        END IF
      IF (I.LT.MXRCH.AND.J.EQ.0) GO TO 130
      IF (J.EQ.0) READ (SUCIFL,1000,ERR=900)
C
C     read form 14
      RETCOD= 14
      I     = 0
140   CONTINUE
        I= I+ 1
        READ (SUCIFL,1140,ERR=900) TCHR,(DAT8(J,I),J=1,10)
        J= STRFND(LEN,TCHR,LEN,ENDA)
        IF (J.GT.0 .AND. I.EQ.1) THEN
C         no data values read, reset needed values
          DAT8(1,I)= 1.0
          DAT8(3,I)= 70.0
        END IF
      IF (I.LT.MXRCH.AND.J.EQ.0) GO TO 140
      IF (J.EQ.0) READ (SUCIFL,1000,ERR=900)
C
C     read form 15
      RETCOD= 15
      I     = 0
150   CONTINUE
        I= I+ 1
        READ (SUCIFL,1100,ERR=900) TCHR,(DAT8A(J,I),J=1,8)
        J= STRFND(LEN,TCHR,LEN,ENDA)
        IF (J.GT.0 .AND. I.EQ.1) THEN
C         no data values read, reset needed values
          DAT8A(1,I)= 1.0
        END IF
      IF (I.LT.MXRCH.AND.J.EQ.0) GO TO 150
      IF (J.EQ.0) READ (SUCIFL,1000,ERR=900)
C
C     read form 16
      RETCOD= 16
      I     = 0
160   CONTINUE
        I= I+ 1
        READ (SUCIFL,1160,ERR=900) TCHR,DAT9(1,I),
     1    (JUNNAM(J,I),J=1,16),(DAT9(J,I),J=2,4)
        J= STRFND(LEN,TCHR,LEN,ENDA)
      IF (I.LT.MXJUN.AND.J.EQ.0) GO TO 160
      IF (J.EQ.0) READ (SUCIFL,1000,ERR=900)
C
C     read form 17
      RETCOD= 17
      I     = 0
170   CONTINUE
        I= I+ 1
        READ (SUCIFL,1170,ERR=900) TCHR,DAT10(1,I),
     1    (HDWNAM(J,I),J=1,16),(DAT10(K,I),K=2,8)
        J= STRFND(LEN,TCHR,LEN,ENDA)
        IF (J.GT.0 .AND. I.EQ.1) THEN
C         no data values read, reset needed values
          DAT10(1,I)= 1.0
          DAT10(3,I)= 70.0
        END IF
      IF (I.LT.MXHDW.AND.J.EQ.0) GO TO 170
      IF (J.EQ.0) READ (SUCIFL,1000,ERR=900)
C
C     read form 18
      RETCOD= 18
      I     = 0
180   CONTINUE
        I= I+ 1
        READ (SUCIFL,1180,ERR=900) TCHR,(DAT10A(J,I),J=1,10)
        J= STRFND(LEN,TCHR,LEN,ENDA)
        IF (J.GT.0 .AND. I.EQ.1) THEN
C         no data values read, reset needed values
          DAT10A(1,I)= 1.0
        END IF
      IF (I.LT.MXHDW.AND.J.EQ.0) GO TO 180
      IF (J.EQ.0) READ (SUCIFL,1000,ERR=900)
C
C     read form 19
      RETCOD= 19
      I     = 0
190   CONTINUE
        I= I+ 1
        READ (SUCIFL,1190,ERR=900) TCHR,DAT11(1,I),
     1    (PTLNAM(J,I),J=1,12),(DAT11(K,I),K=2,9)
        J= STRFND(LEN,TCHR,LEN,ENDA)
        IF (J.GT.0 .AND. I.EQ.1) THEN
C         no data values read, reset needed values
          DAT11(1,I)= 1.0
          DAT11(4,I)= 70.0
        END IF
      IF (I.LT.MXPTL.AND.J.EQ.0) GO TO 190
      IF (J.EQ.0) READ (SUCIFL,1000,ERR=900)
C
C     read form 20
      RETCOD= 20
      I     = 0
200   CONTINUE
        I= I+ 1
        READ (SUCIFL,1180,ERR=900) TCHR,(DAT11A(J,I),J=1,10)
        J= STRFND(LEN,TCHR,LEN,ENDA)
        IF (J.GT.0 .AND. I.EQ.1) THEN
C         no data values read, reset needed values
          DAT11A(1,I)= 1.0
        END IF
      IF (I.LT.MXPTL.AND.J.EQ.0) GO TO 200
      IF (J.EQ.0) READ (SUCIFL,1000,ERR=900)
C
C     read form 21
      RETCOD= 21
      I     = 0
210   CONTINUE
        I= I+ 1
        READ (SUCIFL,1210,ERR=900) TCHR,(DAT12(J,I),J=1,7)
        J= STRFND(LEN,TCHR,LEN,ENDA)
        IF (J.GT.0 .AND. I.EQ.1) THEN
C         no data values read, reset needed values
          DAT12(1,I)= 1.0
          DAT12(3,I)= -999.0
          DAT12(4,I)= 1.25
          DAT12(5,I)= 1.0
        END IF
      IF (I.LT.MXDAM.AND.J.EQ.0) GO TO 210
      DAT12(1,I)= I
      IF (J.EQ.0) READ (SUCIFL,1000,ERR=900)
C
C     read form 22
      RETCOD= 22
      READ (SUCIFL,1100,ERR=900) TCHR,R1,DAT13
      IF (STRFND(LEN,TCHR,LEN,ENDA).EQ.0) THEN
C       read ENDDATA card
        READ (SUCIFL,1000,ERR=900)
      ELSE
C       no data values read, reset needed values
        DAT13(1)= 70.0
      END IF
      READ (SUCIFL,1100,ERR=900) TCHR,R1,DAT13A
      IF (STRFND(LEN,TCHR,LEN,ENDA).EQ.0) READ (SUCIFL,1000,ERR=900)
C
C     read form 23
      RETCOD= 23
      I     = 0
      READ (SUCIFL,1230,ERR=900,END=800) TCHR,(CLDAT(K,1),K=2,6)
      J= STRFND(LEN,TCHR,LEN,LOCA)
      IF (J.NE.0 .AND. NPOPT(4).EQ.1 .AND. DAT5A(1,1).LT.-900) THEN
C       steady state and DAT5A not defined - put LOCAL CLIM in 5A
        DO 235 J= 1,NUMRCH
          DAT5A(1,J)= J
          DAT5A(2,J)= PCRVL(11)
          DAT5A(3,J)= PCRVL(12)
          DO 233 K= 2,6
            DAT5A(K+2,J)= CLDAT(K,1)
 233      CONTINUE
 235    CONTINUE
      END IF
      IF (J.EQ.0) BACKSPACE SUCIFL
C
C     read from 24
      RETCOD= 24
      I     = 0
240   CONTINUE
        I= I+ 1
        READ (SUCIFL,1240,ERR=900,END=800) PLTSTR(I)
        IF (PLTSTR(I).GT.0) THEN
C         add another plot to total
          NUMPLT= NUMPLT+ 1
        ELSE
C         no more plots
          I= MXPLT
        END IF
        READ (SUCIFL,1240,ERR=900,END=800) (PLTRCH(J,I),J=1,NUMRCH)
      IF (I.LT.MXPLT) GO TO 240
C
800   CONTINUE
      RETCOD= 0
      GO TO 950
C
900   CONTINUE
C       read error
        SCLU= 5
        SGRP= 15
        CALL PRNTXI(MESSFL,SCLU,SGRP,RETCOD)
        BACKSPACE SUCIFL
C       READ (SUCIFL,1000) TBUFF
        J= 80
C       CALL PRTSCR (J,TBUFF)
950   CONTINUE
C
      RETURN
      END
