      SUBROUTINE AQ2WRT
     I                  (MESSFL,OFL)
C
C     + + + PURPOSE + + +
C     routine to write out a qual2 input sequence
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER   MESSFL,OFL
C
C     + + + ARGUMENT DEFINITIONS + + +
C     MESSFL - unit number for message file
C     OFL    - unit number for output file
C     TBUFF  - buffer to write out file
C
C     + + + COMMON BLOCKS + + +
      INCLUDE 'CQ2VAL.INC'
C
C     + + + LOCAL VARIABLES + + +
      INTEGER     I,J,K,L,N,JUST,SCLU,SGRP,LEN,M,I14,I80,IN1,I7
      REAL        R1,R2
      DOUBLE PRECISION D1,D2
      CHARACTER*1 NO(3),BLNK,TBUFF(80)
C
C     + + + FUNCTIONS + + +
      INTEGER   LENSTR, STRFND
C
C     + + + INTRINSICS + + +
      INTRINSIC   MOD
C
C     + + + EXTERNALS + + +
      EXTERNAL   LENSTR, STRFND, GETTXT, CHRCHR, CHRINS
      EXTERNAL   DECCHR, INTCHR, ZIPC, PMXCNW
C
C     + + + DATA INITIALIZATIONS + + +
      DATA NO/'N','O',' '/
      DATA BLNK/' '/
C
C     + + + OUTPUT FORMATS + + +
2000  FORMAT (80A1)
C
C     + + + END SPECIFICATIONS + + +
C
      JUST=  0
      IN1 = -1
      I7  =  7
      I14 = 14
      I80 = 80
C
C     writing input sequence to disk
      SCLU= 5
      SGRP= 14
      I= 1
      CALL PMXCNW (MESSFL,SCLU,SGRP,I,I,I,J)
C
      SCLU= 6
C     forms 1-3
      N= 0
      DO 20 I= 1,46
        LEN= 80
        CALL GETTXT (MESSFL,SCLU,I,LEN,TBUFF)
        IF (I.EQ.1) THEN
          L= 59
          CALL CHRCHR (L,QTITLE,TBUFF(22))
        ELSE IF (I.EQ.2) THEN
          L= 59
          CALL CHRCHR (L,BNAME,TBUFF(22))
        ELSE IF (I.NE.10.AND.I.NE.12.AND.I.LE.15) THEN
          N= N+ 1
          IF (I.EQ.7.AND.CSOPT(1,N).EQ.'Y') THEN
C           see which type of BOD simulation
            IF (BODOPT.EQ.2) THEN
C             ultimate, get different message from message file
              J  = 93
              LEN= 80
              CALL GETTXT (MESSFL,SCLU,J,LEN,TBUFF)
            END IF
          END IF
          L= 3
          IF (CSOPT(1,N).EQ.'Y') THEN
C           put 'YES' in right justified
            CALL CHRCHR (L,CSOPT(1,N),TBUFF(10))
          ELSE
C           put 'NO' in right justified
            K= 1
            J= STRFND(L,CSOPT(1,N),K,'N')
            CALL CHRCHR (L-1,CSOPT(J,N),TBUFF(11))
          END IF
          IF (N.LE.3.OR.N.EQ.11) THEN
            L= 4
            J= N
            IF (J.EQ.11) J=4
            CALL CHRCHR (L,CNAME(1,J),TBUFF(49))
            CALL CHRCHR (L,CUNITS(1,J),TBUFF(57))
          END IF
        ELSE IF (I.GE.17.AND.I.LE.23) THEN
          J= I- 16
          IF (NPOPT(J).EQ.2) THEN
C           add no
            DO 10 L= 1,3
              CALL CHRINS (I80,L,NO(L),TBUFF)
 10         CONTINUE
          END IF
        ELSE IF (I.GE.24.AND.I.LE.33) THEN
          IF (I.EQ.24) THEN
            R1= PCIVL(1)
            IF (R1.GT.1.0) R1= 0.
            R2= PCRVL(13)
          ELSE IF (I.EQ.25) THEN
            R1= PCIVL(2)
            IF (R1.GT.1.0) R1= 0.
            R2= PCIVL(3)
            IF (R2.GT.1.0) R2= 0.
          ELSE IF (I.EQ.26) THEN
            R1= NUMRCH
            R2= NUMJUN
          ELSE IF (I.EQ.27) THEN
            R1= NUMHDW
            R2= NUMPTL
          ELSE IF (I.GE.28) THEN
            J= (I-28)* 2+ 1
            R1= PCRVL(J)
            R2= PCRVL(J+1)
          END IF
          L= 10
          IF (J.EQ.9) THEN
C           need double precision for this field
            D1= R1
            CALL DPRCHR (D1,L,JUST,K,TBUFF(26))
            D2= R2
            CALL DPRCHR (D2,L,JUST,K,TBUFF(71))
          ELSE
            CALL DECCHR (R1,L,JUST,K,TBUFF(26))
            CALL DECCHR (R2,L,JUST,K,TBUFF(71))
          END IF
        ELSE IF (I.GE.35.AND.I.LE.45) THEN
          J= (I-35)* 2+ 1
          L= 7
          CALL DECCHR (GPARM(J),L,JUST,K,TBUFF(33))
          J= J+ 1
          CALL DECCHR (GPARM(J),L,JUST,K,TBUFF(74))
        END IF
        WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
  20  CONTINUE
C
C     form 4 - theta
      IF (THEIND(1).NE.0) THEN
        M  = 47
        LEN= 80
        CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
        I= 1
  40    CONTINUE
          J= THEIND(I)
          L= 8
          CALL CHRCHR (L,NTHET(1,J),TBUFF(10))
          L= 8
          CALL DECCHR (THEVAL(J),L,JUST,K,TBUFF(19))
          WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
          I= I+ 1
        IF (THEIND(I).GT.0) GO TO 40
      END IF
      M  = 48
      LEN= 80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(LEN,TBUFF))
C
C     form 5 - rch id
      M  = 49
      LEN= 80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      DO 50 I= 1,NUMRCH
        L= 5
        CALL DECCHR (DAT2(1,I),L,JUST,K,TBUFF(16))
        L= 16
        CALL CHRCHR (L,RCHNAM(1,I),TBUFF(25))
        L= 10
        CALL DECCHR (DAT2(2,I),L,JUST,K,TBUFF(51))
        CALL DECCHR (DAT2(3,I),L,JUST,K,TBUFF(70))
        WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
 50   CONTINUE
      M  = 50
      LEN= 80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
C
      IF (NPOPT(3).EQ.1) THEN
C       form 6 - flow augmentation
        M  = 51
        LEN= 80
        CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
        DO 60 I= 1,NUMRCH
          L= 5
          CALL DECCHR (DAT2(1,I),L,JUST,K,TBUFF(26))
          CALL INTCHR (DAT3I(I),L,JUST,K,TBUFF(36))
          DO 58 J= 1,6
            CALL DECCHR (DAT3R(J+2,I),L,JUST,K,TBUFF(J*L+46))
 58       CONTINUE
          L= 10
          CALL DECCHR (DAT3R(2,I),L,JUST,K,TBUFF(41))
          WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
 60     CONTINUE
      END IF
      M  = 52
      LEN= 80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
C
C     form 7 - comp el flag fld
      M  = 53
      LEN= 80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      DO 70 I= 1,NUMRCH
        L= 40
        CALL ZIPC (L,BLNK,TBUFF(41))
        L= 5
        CALL DECCHR (DAT2(1,I),L,JUST,K,TBUFF(16))
        CALL INTCHR (NCMPEL(I),L,JUST,K,TBUFF(26))
        L= 2
        DO 65 J=1,NCMPEL(I)
          CALL INTCHR (CMPELF(J,I),L,JUST,K,TBUFF(39+J*L))
 65     CONTINUE
        WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
 70   CONTINUE
      M  = 54
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
C
C     form 8 - hydraulic data
      M  = 55
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      DO 80 I= 1,NUMRCH
        L= 5
        CALL DECCHR (DAT5(1,I),L,JUST,K,TBUFF(16))
        L= 10
        DO 75 J= 2,7
          CALL DECCHR (DAT5(J,I),L,JUST,K,TBUFF(1+J*L))
 75     CONTINUE
        WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
 80   CONTINUE
      M  = 56
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
C
      IF (NPOPT(4).EQ.1 .AND. CLDAT(1,1).LT.1.0E-3) THEN
C       form 8a - temp and local clim. data
        M  = 91
        LEN= I80
        CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
        DO 85 I= 1,NUMRCH
          L= 5
          CALL DECCHR (DAT5A(1,I),L,JUST,K,TBUFF(16))
          L= 7
          DO 87 J= 2,8
            CALL DECCHR (DAT5A(J,I),L,JUST,K,TBUFF(11+J*L))
 87       CONTINUE
          WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
 85     CONTINUE
C+++++
        M  = 92
        LEN= I80
        CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
        WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
C+++++
      END IF
C+++++
C      M  = 92
C      LEN= I80
C      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
C      WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
C+++++
C     form 9 - bod/do coefficients
      M  = 57
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      DO 90 I= 1,NUMRCH
        L= 5
        CALL DECCHR (DAT6(1,I),L,JUST,K,TBUFF(16))
        L= 8
        CALL DECCHR (DAT6(2,I),L,JUST,K,TBUFF(21))
        CALL DECCHR (DAT6(3,I),L,JUST,K,TBUFF(29))
        CALL DECCHR (DAT6(4,I),L,JUST,K,TBUFF(37))
        CALL DECCHR (DAT6(6,I),L,JUST,K,TBUFF(49))
        CALL DECCHR (DAT6(7,I),L,JUST,K,TBUFF(57))
        CALL DECCHR (DAT6(8,I),L,JUST,K,TBUFF(65))
        L= 4
        CALL DECCHR (DAT6(5,I),L,JUST,K,TBUFF(45))
        WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
 90   CONTINUE
      M  = 58
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
C
      IF (CSOPT(1,6).EQ.'Y' .OR. CSOPT(1,7).EQ.'Y' .OR.
     1                           CSOPT(1,8).EQ.'Y') THEN
C       form 10 - n and p coefficients
        M  = 59
        LEN= I80
        CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
        DO 100 I= 1,NUMRCH
          L= 5
          CALL DECCHR (DAT6A(1,I),L,JUST,K,TBUFF(20))
          L= 7
          DO 95 J= 2,9
            CALL DECCHR (DAT6A(J,I),L,JUST,K,TBUFF(11+J*L))
 95       CONTINUE
          WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
100     CONTINUE
      END IF
      M  = 60
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
C
      IF (CSOPT(1,6).EQ.'Y' .OR. CSOPT(1,7).EQ.'Y' .OR.
     1    CSOPT(1,8).EQ.'Y' .OR. CSOPT(1,10).EQ.'Y' .OR.
     2                           CSOPT(1,11).EQ.'Y') THEN
C       form 11 - algae/other coefficients
        M  = 61
        LEN= I80
        CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
        DO 110 I= 1,NUMRCH
          L= 5
          CALL DECCHR (DAT6B(1,I),L,JUST,K,TBUFF(20))
          L= 7
          DO 105 J= 2,8
            CALL DECCHR (DAT6B(J,I),L,JUST,K,TBUFF(11+J*L))
105       CONTINUE
          WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
110     CONTINUE
      END IF
      M  = 62
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
C
C     form 12 - initial conditions - 1
      M  = 63
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      DO 120 I= 1,NUMRCH
        L= 5
        CALL DECCHR (DAT7(1,I),L,JUST,K,TBUFF(20))
        L= 7
        DO 115 J= 2,9
          CALL DECCHR (DAT7(J,I),L,JUST,K,TBUFF(11+J*L))
115     CONTINUE
        WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
120   CONTINUE
      M  = 64
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
C
C     form 13 - initial conditions - 2
      M  = 65
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      DO 130 I= 1,NUMRCH
        L= 5
        CALL DECCHR (DAT7A(1,I),L,JUST,K,TBUFF(20))
        L= 7
        DO 125 J= 2,8
          CALL DECCHR (DAT7A(J,I),L,JUST,K,TBUFF(11+J*L))
125     CONTINUE
        WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
130   CONTINUE
      M  = 66
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
C
C     form 14 - incremental flow - 1
      M  = 67
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      DO 140 I= 1,NUMRCH
        L= 5
        CALL DECCHR (DAT8(1,I),L,JUST,K,TBUFF(20))
        L= 7
        CALL DECCHR (DAT8(2,I),L,JUST,K,TBUFF(25))
        CALL DECCHR (DAT8(3,I),L,JUST,K,TBUFF(32))
        L= 6
        DO 135 J= 4,10
           IF (J.EQ.10) THEN
              CALL DECCHX (DAT8(J,I),L,I7,IN1,TBUFF(15+J*L))
           ELSE
              CALL DECCHR (DAT8(J,I),L,JUST,K,TBUFF(15+J*L))
           ENDIF
135     CONTINUE
        WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
140   CONTINUE
      M  = 68
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
C
C     form 15 - incremental flow - 2
      M  = 69
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      DO 150 I= 1,NUMRCH
        L= 5
        CALL DECCHR (DAT8A(1,I),L,JUST,K,TBUFF(20))
        L= 7
        DO 145 J= 2,8
          CALL DECCHR (DAT8A(J,I),L,JUST,K,TBUFF(11+J*L))
145     CONTINUE
        WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
150   CONTINUE
      M  = 70
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
C
C     form 16 - stream junction data
      M  = 71
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      DO 160 I= 1,NUMJUN
        L= 5
        CALL DECCHR (DAT9(1,I),L,JUST,K,TBUFF(21))
        CALL DECCHR (DAT9(2,I),L,JUST,K,TBUFF(56))
        CALL DECCHR (DAT9(3,I),L,JUST,K,TBUFF(66))
        CALL DECCHR (DAT9(4,I),L,JUST,K,TBUFF(76))
        L= 16
        CALL CHRCHR (L,JUNNAM(1,I),TBUFF(35))
        WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
160   CONTINUE
      M  = 72
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
C
C     form 17 - headwater 1
      M  = 73
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      DO 170 I= 1,NUMHDW
        L= 5
        CALL DECCHR (DAT10(1,I),L,JUST,K,TBUFF(15))
        L= 16
        CALL CHRCHR (L,HDWNAM(1,I),TBUFF(20))
        L= 9
        CALL DECCHR (DAT10(2,I),L,JUST,K,TBUFF(36))
        L= 6
        DO 165 J= 2,7
          CALL DECCHR (DAT10(J+1,I),L,JUST,K,TBUFF(33+J*L))
165     CONTINUE
        WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
170   CONTINUE
      M  = 74
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
C
C     form 18 - headwater - 2
      M  = 75
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      DO 180 I= 1,NUMHDW
        L= 5
        CALL DECCHR (DAT10(1,I),L,JUST,K,TBUFF(15))
        L= 6
        DO 175 J= 1,9
C          CALL DECCHR (DAT10A(J+1,I),L,JUST,K,TBUFF(15+J*L))
           IF (J.EQ.2) THEN
              CALL DECCHX (DAT10A(J+1,I),L,I7,IN1,TBUFF(15+J*L))
           ELSE
              CALL DECCHR (DAT10A(J+1,I),L,JUST,K,TBUFF(15+J*L))
           ENDIF
175     CONTINUE
        WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
180   CONTINUE
      M= 76
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
C
C     form 19 - point load and withdrawal - 1
      M= 77
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      DO 190 I= 1,NUMPTL
        L= 5
        CALL DECCHR (DAT11(1,I),L,JUST,K,TBUFF(15))
        L= 12
        CALL CHRCHR (L,PTLNAM(1,I),TBUFF(20))
        L= 5
        CALL DECCHR (DAT11(2,I),L,JUST,K,TBUFF(32))
        L= 8
        CALL DECCHR (DAT11(3,I),L,JUST,K,TBUFF(37))
        L= 6
        DO 185 J= 3,8
          CALL DECCHR (DAT11(J+1,I),L,JUST,K,TBUFF(27+J*L))
185     CONTINUE
        WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
190   CONTINUE
      M  = 78
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
C
C     form 20 - point load and withdrawal - 2
      M  = 79
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      DO 200 I= 1,NUMPTL
        L= 5
        CALL DECCHR (DAT11(1,I),L,JUST,K,TBUFF(16))
        L= 6
        DO 195 J= 1,9
          IF (J.EQ.2) THEN
             CALL DECCHX (DAT11A(J+1,I),L,I7,IN1,TBUFF(15+J*L))
          ELSE
             CALL DECCHR (DAT11A(J+1,I),L,JUST,K,TBUFF(15+J*L))
          ENDIF
195     CONTINUE
        WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
200   CONTINUE
      M  = 80
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
C
C     form 21 - dam reaeration coefficients
      M  = 81
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      I= 1
      IF (DAT12(2,I).GT.0.0) THEN
210     CONTINUE
          L= 5
          CALL DECCHR (DAT12(1,I),L,JUST,K,TBUFF(20))
          L= 6
          DO 215 J= 1,6
            CALL DECCHR (DAT12(J+1,I),L,JUST,K,TBUFF(19+J*L))
215       CONTINUE
          WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
          I= I+ 1
        IF (DAT12(2,I).GT.0.0.AND.I.LE.MXDAM) GO TO 210
      END IF
      M  = 82
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
C
      IF (PCIVL(1).EQ.1.OR.DAT13(1).GT.0.0) THEN
C       form 22 - downstream boundary - 1
        M  = 83
        LEN= I80
        CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
        L= 7
        DO 220 J= 1,8
           IF (J.EQ.8) THEN
              CALL DECCHX (DAT13(J),L,I7,IN1,TBUFF(18+J*L))
           ELSE
              CALL DECCHR (DAT13(J),L,JUST,K,TBUFF(18+J*L))
           ENDIF
220     CONTINUE
        WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
      END IF
      M  = 84
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
      IF (PCIVL(1).EQ.1.OR.DAT13A(1).GT.0.0) THEN
C       form 22a - downstream boundary - 2
        M  = 85
        LEN= I80
        CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
        L= 7
        DO 225 J= 1,7
          CALL DECCHR (DAT13A(J),L,JUST,K,TBUFF(18+J*L))
225     CONTINUE
        WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
      END IF
      M  = 86
      LEN= I80
      CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
      WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
C
C     form 23, Local Climatology
      IF (CLDAT(1,1).GT.0.9) THEN
C       local clim used
        M  = 87
        LEN= I80
        CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
        L  = 8
        CALL DECCHR (CLDAT(2,1),L,JUST,K,TBUFF(41))
        CALL DECCHR (CLDAT(3,1),L,JUST,K,TBUFF(49))
        CALL DECCHR (CLDAT(4,1),L,JUST,K,TBUFF(57))
        L  = 6
        CALL DECCHR (CLDAT(5,1),L,JUST,K,TBUFF(65))
        L  = 9
        CALL DECCHR (CLDAT(6,1),L,JUST,K,TBUFF(71))
        WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
      END IF
C     form 24 reach plot
      IF (NUMPLT.GT.0) THEN
        DO 240 I= 1,NUMPLT
          M  = 88
          LEN= I80
          CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
          L= 5
          CALL INTCHR (PLTSTR(I),L,JUST,K,TBUFF(11))
          WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
          M  = 89
          LEN= I80
          CALL GETTXT (MESSFL,SCLU,M,LEN,TBUFF)
          L= 5
          N= 11
          DO 235 J=1,NUMRCH
            CALL INTCHR (PLTRCH(J,I),L,JUST,K,TBUFF(N))
            N= N+ L
            IF (MOD(J,I14).EQ.0.OR.J.EQ.NUMRCH) THEN
              WRITE (OFL,2000) (TBUFF(K),K=1,LENSTR(I80,TBUFF))
              LEN= 70
              N  = 11
              CALL ZIPC (LEN,BLNK,TBUFF(N))
            END IF
 235      CONTINUE
 240    CONTINUE
      END IF
C
      RETURN
      END
