      SUBROUTINE AQUTIL
     I                  (MESSFL)
C
C     ##################################################################
C     # Purpose:                                                       #
C     # Modify, re-initialize, and/or save to file TERM.DAT system     #
C     # specification and/or terminal definition file parameters.      #
C     #----------------------------------------------------------------#
C     # Author: D. Disney, Computer Scientist                          #
C     #         Computer Sciences Corporation (CSC)                    #
C     # Site:   US EPA Environmental Research Lab, Athens, GA.         #
C     #----------------------------------------------------------------#
C     # System Specific Statements:  Execute a search string operation #
C     # for the string CVAX/PC.                                        #
C     #----------------------------------------------------------------#
C     # Maintenance History:                                           #
C     # Date: Friday, 17 January 1992.  Time: 08:47:56.                #
C     #     o initial coding                                           #
C     ##################################################################
C
C     +++++ Parameter specifications +++++++++++++++++++++++++++++++++++
C
C     +++++ Parameters:
C
C     +++++ Common blocks.
C           NOTE: To link the AQUAL2 program, it is assumed that the user
C           has the ANNIE-IDE library files (.LIB)
C            - on drive E: in sub-directory \AIDE for the PC
C            - in sub-directory [CEAM.TESTAREA.ANNIEIDE] on current
C              default drive for the VAX
C           Compilation of this file (AQUTIL.FOR) assumes that the user has
C           the ANNIE-IDE FORTRAN source code files PMXPRM.INC and CUSRPM.INC
C            - on drive E: in sub-directory \AIDE\AIDECODE for the PC
C            - in sub-directory [CEAM.TESTAREA.ANNIEIDE] on current
C              default drive for the VAX
C
      INCLUDE 'AQUTIL.INC'
CVAX/PC
      INCLUDE 'E:\AIDE\LIB2.0\SRC\AIDE\PMXPRM.INC'
      INCLUDE 'E:\AIDE\LIB2.0\SRC\AIDE\CUSRPM.INC'
CVAX      INCLUDE '[CEAM.TESTAREA.ANNIEIDE]PMXPRM.INC'
CVAX      INCLUDE '[CEAM.TESTAREA.ANNIEIDE]CUSRPM.INC'
CVAX/PC
C
C     +++++ Local variables:
C
      INTEGER*2    NUMPRM
      PARAMETER   (NUMPRM=3)
C
      INTEGER*4    I,I0,I1,I2,I64,I80,J,K,SCLU,SGRP,RESP,DONFG,INUM,
     1             RNUM,CNUM,CLEN,IRET,TDATFL,RETCOD,PRTFLG,REVFOR,
     2             REVBAK,IOSTAT
      INTEGER*4    IVAL(1),CVAL(4,3)
      REAL*4       RVAL(1)
      CHARACTER*1  BLANK
      CHARACTER*1  FLNAME(64)
      CHARACTER*1  TBUFF(80)
      CHARACTER*4  CGPRMS(NUMPRM)
      CHARACTER*5  CLRSET
      CHARACTER*6  PRMNAM
      CHARACTER*44 CPRMVL
      CHARACTER*80 TBUFFT
C
      EQUIVALENCE (TBUFF(1),TBUFFT)
C
C     +++++ Definitions for selected local variables:
C
C           I,J,K - general use integer variables
CI0,I1,I2,I64,I80 - integer constants with value zero (0), 1, 2, 64, 80
C       SCLU,SGRP - MESSAGE.WDM screen cluster and group numbers
C           RESP  - MESSAGE.WDM menu response number
C           DONFG - processing complete flag; return to previous screen/menu
C  INUM,RNUM,CNUM - number of integer, real, character responses
C            CLEN - length of character item
C            IRET - data entry screen return code
C          TDATFL - TERM.DAT file unit number
C          RETCOD - open file return code
C          PRTFLG - print or screen display flag
C       IVAL,RVAL - array containing integer, real responses
C            CVAL - array containing information about char. responses
C           TBUFF - char. string containing char. responses (TBUFF.EQ.TBUFFT)
C           BLANK - character with constant value of space (ASCII 032)
C           CGPRMS- array of local TERM.DAT parameters, excluding colors, that
C                   can be changed by user with this subroutine.  Initial
C                   values assigned from UPARMS, as read from TERM.DAT, or
C                   assigned default values:
C                   CGPRMS(1) - <Enter>/<CR> key attribute
C                   CGPRMS(2) - GKS graphics support
C                   CGPRMS(3) - user experience level
C           FLNAME- char array containing terminal def file name (TERM.DAT)
C           TBUFFT- char string containing char. responses (TBUFF.EQ.TBUFFT)
C           CLRSET- color set name
C           REVFOR- reverse foreground color
C           REVBAK- reverse background color
C           PRMNAM- parameter name written to TERM.DAT file
C           CPRMVL- character parameter value written to TERM.DAT file
C
C     +++++ Dummy arguments:
C
      INTEGER MESSFL
C
C     +++++ Argument definitions for dummy arguments:
C
C           MESSFL - input FORTRAN unit number for MESSAGE.WDM message file.
C
C     +++++ Functions:
C
C     +++++ External subroutines:
C
      EXTERNAL QRESP, ZWNSET, ZSTCMA, ZIPC, CHRCHR, QRESPX, ZGTRET,
     1         QFOPFN, PMXCNW, ZCOLOR, COLINI
C
C     +++++ Save arguments:
C
C     +++++ Data Statements:
C
C     +++++ FORMAT statement specifications:
C           Input:
  999 FORMAT (A1)
C           Output:
 1000 FORMAT (A6,1X,I10)
 1010 FORMAT (A6,1X,A44)
C
C     +++++ End specifications +++++++++++++++++++++++++++++++++++++++++
C
C     Initialize local variables.
C
C     Assign constant values.
      BLANK  = ' '
      IRET   = 0
      RESP   = 0
      DONFG  = 0
      I0     = 0
      I1     = 1
      I2     = 2
      I64    = 64
      I80    = 80
      INUM   = I1
      RNUM   = I1
      REVFOR = I0
      REVBAK = I0
      CNUM   = 4
      CLEN   = 0
      RETCOD = 0
      TDATFL = 0
      IVAL(1)= 0
      RVAL(1)= 0.0
      PRMNAM = BLANK
      CPRMVL = BLANK
      PRTFLG = 0
      CLRSET = BLANK
C
      DO 5 I = 1,NUMPRM
    5    CGPRMS(I) = BLANK
C
C     Clear the TERM.DAT file name buffer.
      CALL ZIPC
     I          (I64,BLANK,
     O                     FLNAME)         
C
C     Load terminal definition file name.
      FLNAME(1) = 'T'
      FLNAME(2) = 'E'
      FLNAME(3) = 'R'
      FLNAME(4) = 'M'
      FLNAME(5) = '.'
      FLNAME(6) = 'D'
      FLNAME(7) = 'A'
      FLNAME(8) = 'T'
C
C     Set cluster number for utility text, menus, data entry screens.
      SCLU = 23
C
C     Set default or existing values from TERM.DAT file. Set color first;
C     30 is standard foreground; 34 is standard background indicator.
      IF (UPARMS(30).EQ.15.AND.UPARMS(34).EQ. 9) THEN
         CLRSET = 'USA  '
      ELSE IF (UPARMS(30).EQ.10.AND.UPARMS(34).EQ. 6) THEN
              CLRSET = 'EARTH'
       ELSE IF (UPARMS(30).EQ.14.AND.UPARMS(34).EQ.10) THEN
               CLRSET = 'YUPIE'
        ELSE IF (UPARMS(30).EQ.10.AND.UPARMS(34).EQ. 9) THEN
                CLRSET = 'PREPE'
         ELSE IF (UPARMS(30).EQ.15.AND.UPARMS(34).EQ. 5) THEN
                 CLRSET = 'YUCKE'
          ELSE IF (UPARMS(30).EQ.11.AND.UPARMS(34).EQ. 1) THEN
                  CLRSET = 'WATER'
           ELSE IF (UPARMS(30).EQ.14.AND.UPARMS(34).EQ. 1) THEN
                   CLRSET = 'BEST '
            ELSE IF (UPARMS(30).EQ. 0.AND.UPARMS(34).EQ. 7) THEN
                    CLRSET = 'REVER'
             ELSE IF (UPARMS(30).EQ. 7.AND.UPARMS(34).EQ. 0) THEN
                     CLRSET = 'DULL '
      ENDIF
C
C     Set default <Enter>/<CR> key attribute; 9 is key attribute
C     indicator.
      IF (UPARMS(9).EQ.1) THEN
         CGPRMS(1) = 'NONE'
      ELSE IF (UPARMS(9).EQ.2) THEN
              CGPRMS(1) = 'DOWN'
           ELSE IF (UPARMS(9).EQ.3) THEN
                   CGPRMS(1) = 'NEXT'
      ENDIF
C
C     Set GKS support flag; 16 is flag attribute indicator.
      IF (UPARMS(16).EQ.1) THEN
         CGPRMS(2) = 'YES '
      ELSE IF (UPARMS(16).EQ.2) THEN
              CGPRMS(2) = 'NO  '
      ENDIF
C
C     Set user experience level flag; 45 is user level indicator.
      IF (UPARMS(45).EQ.0) THEN
         CGPRMS(3) = 'LOTS'
      ELSE IF (UPARMS(45).EQ.2) THEN
              CGPRMS(3) = 'NONE'
      ENDIF
C
C $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
C $   The 10 CONTINUE statement begins the processing loop.            $
C $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
C
   10 CONTINUE
C
      SGRP = 1
C
C     Make 'PREV' option unavailable.
      I = 4
      CALL ZSTCMA
     I            (I,I0)
C
C     Display the options menu on the screen.
      CALL QRESP
     I           (MESSFL,SCLU,SGRP,
     O                             RESP)
C
      IF (RESP.EQ.1) THEN
C        Modify TERM.DAT file.
C        Make 'PREV' option available.
         I = 4
         CALL ZSTCMA
     I               (I,I1)
C        Make 'INTRPT' option available.
         I = 16
         CALL ZSTCMA
     I               (I,I1)
C
C        Set the screen group to display data screen.
         SGRP = 2
C        Clear the data buffer for initial and return values.
         CALL ZIPC
     I             (I80,BLANK,
     O                        TBUFF)         
         TBUFFT = BLANK
C
         CLEN = 5
C        Load data into data buffer.
         CALL CHRCHR
     I               (CLEN,CLRSET,
     O                            TBUFF(1))
         CLEN = 4
         CALL CHRCHR
     I               (CLEN,CGPRMS(1),
     O                               TBUFF(6))
         CALL CHRCHR
     I               (CLEN,CGPRMS(2),
     O                               TBUFF(10))
         CALL CHRCHR
     I               (CLEN,CGPRMS(3),
     O                               TBUFF(14))
C
C        Display the data entry screen.  Current values are in TBUFF.
         CALL QRESPX
     I               (MESSFL,SCLU,SGRP,INUM,RNUM,CNUM,
     M                                                IVAL,RVAL,CVAL,
     M                                                            TBUFF)
C        Get return value from data entry screen.
         CALL ZGTRET
     O               (IRET)
C
C        Make 'PREV' option unavailable.
         I= 4
         CALL ZSTCMA
     I               (I,I0)
C        Make 'INTRPT' option unavailable.
         I= 16
         CALL ZSTCMA
     I               (I,I0)
C
C        If data entry screen return code=7, interupt (don't save) changes.
         IF (IRET.EQ.7.OR.
     1      (IRET.EQ.2.AND.
     2      (TBUFFT(1:1).EQ.'n'.OR.TBUFFT(1:1).EQ.BLANK))) GO TO 9990
C
C        Determine if user changed any of the 4 items on the data screen.
         IF (CLRSET   .NE.  TBUFFT(1:5)) CHGFLG(1) = 'Y'
         IF (CGPRMS(1).NE.  TBUFFT(6:9)) CHGFLG(2) = 'Y'
         IF (CGPRMS(2).NE.TBUFFT(10:13)) CHGFLG(3) = 'Y'
         IF (CGPRMS(3).NE.TBUFFT(14:17)) CHGFLG(4) = 'Y'
C
         IF (CHGFLG(1).EQ.'Y'.OR.CHGFLG(2).EQ.'Y'.OR.
     1       CHGFLG(3).EQ.'Y'.OR.CHGFLG(4).EQ.'Y')    THEN
C           If user changed at least one of the items, reset default system
C           specification and terminal definition parameters.
C           Display status message.
            SGRP = 3
            CALL PMXCNW
     I                  (MESSFL,SCLU,SGRP,I1,I1,I1,
     O                                             J)
C
C           Reset default terminal definition parameters.  Colors:
            IF (CHGFLG(1).EQ.'Y') THEN
              IF (TBUFFT(1:5).EQ.'DULL ') THEN
                 UPARMS(30) =  7
                 UPARMS(34) =  0
                 REVFOR     =  0
                 REVBAK     =  7
              ELSE IF (TBUFFT(1:5).EQ.'USA  ') THEN
                      UPARMS(30) = 15
                      UPARMS(34) =  9
                      REVFOR     = 15
                      REVBAK     = 12
               ELSE IF (TBUFFT(1:5).EQ.'EARTH') THEN
                       UPARMS(30) = 10
                       UPARMS(34) =  6
                       REVFOR     = 15
                       REVBAK     = 14
                ELSE IF (TBUFFT(1:5).EQ.'YUPIE') THEN
                        UPARMS(30) = 14
                        UPARMS(34) = 10
                        REVFOR     = 15
                        REVBAK     =  1
                 ELSE IF (TBUFFT(1:5).EQ.'PREPE') THEN
                         UPARMS(30) = 10
                         UPARMS(34) =  9
                         REVFOR     = 15
                         REVBAK     = 10
                  ELSE IF (TBUFFT(1:5).EQ.'YUCKE') THEN
                          UPARMS(30) = 15
                          UPARMS(34) =  5
                          REVFOR     = 14
                          REVBAK     =  2
                   ELSE IF (TBUFFT(1:5).EQ.'WATER') THEN
                           UPARMS(30) = 11
                           UPARMS(34) =  1
                           REVFOR     = 15
                           REVBAK     =  3
                    ELSE IF (TBUFFT(1:5).EQ.'BEST ') THEN
                            UPARMS(30) = 14
                            UPARMS(34) =  1
                            REVFOR     = 15 
                            REVBAK     = 10
                         ELSE 
C                           REVER selected by user.
                            UPARMS(30) = 0
                            UPARMS(34) = 7
                            REVFOR     = 7
                            REVBAK     = 0
              ENDIF
C             Get data back from buffer.
              CLEN = 5
              CALL CHRCHR
     I                    (CLEN,TBUFF(1),
     O                                   CLRSET)
C
C             Set the foreground and background colors for DATA then
C             INSTRUCT windows.
C             ZCOLOR argument list=(ITYPE,BORD,FCOL,BCOL,RFCOL,RBCOL)
C             I2         - defines terminal type (2=PC)
C             I1         - border color code
C             UPARMS(30) - foreground text color
C             UPARMS(34) - background text color
C             REVFOR     - foreground reverse video color
C             REVBAK     - background reverse video color
              CALL ZCOLOR
     I                    (I2,I1,UPARMS(30),UPARMS(34),REVFOR,REVBAK)
C
              CALL COLINI
            ENDIF
C
C           Set default <Enter>/<CR> key attribute; 9 is key attribute
C           indicator.
            IF (CHGFLG(2).EQ.'Y') THEN
               IF (TBUFFT(6:9).EQ.'NONE') THEN
                  UPARMS(9) = 1
               ELSE IF (TBUFFT(6:9).EQ.'DOWN') THEN
                       UPARMS(9) = 2            
                    ELSE
C                      NEXT selected by user.
                       UPARMS(9) = 3
               ENDIF
C              Get data back from buffer.
               CLEN = 4
               CALL CHRCHR
     I                     (CLEN,TBUFF(6),
     O                                    CGPRMS(1))
            ENDIF
C
C           Set GKS support flag; 16 is flag attribute indicator.
            IF (CHGFLG(3).EQ.'Y') THEN
               IF (TBUFFT(10:13).EQ.'YES ') THEN
                  UPARMS(16) = 1
               ELSE
C                 NO selected by user.
                  UPARMS(16) = 2
               ENDIF
C              Get data back from buffer.
               CLEN = 4
               CALL CHRCHR
     I                     (CLEN,TBUFF(10),
     O                                     CGPRMS(2))
            ENDIF
C
C           Set user experience level flag; 45 is user level indicator.
            IF (CHGFLG(4).EQ.'Y') THEN
               IF (TBUFFT(14:17).EQ.'LOTS') THEN
                   UPARMS(45) = 0
               ELSE
C                  NONE selected by user.
                   UPARMS(45) = 2
               ENDIF
C              Get data back from buffer.
               CLEN = 4
               CALL CHRCHR
     I                     (CLEN,TBUFF(14),
     O                                     CGPRMS(3))
            ENDIF
C
         ENDIF
C
      ELSE IF (RESP.EQ.2) THEN
C             User has selected to return to UTILITY/Setup menu.
              DONFG= 1
C
C             Check to see any changes were made to data entry screen.
              IF (CHGFLG(1).EQ.'Y'.OR.CHGFLG(2).EQ.'Y'.OR.
     1            CHGFLG(3).EQ.'Y'.OR.CHGFLG(4).EQ.'Y')    THEN
C                Make 'PREV' option unavailable.
                 I = 4
                 CALL ZSTCMA
     I                       (I,I0)
C
C                Display Yes/No menu to ask user if he/she would like to
C                make changes permanent and save them to TERM.DAT file.
                 SGRP = 4
                 CALL QRESP
     I                      (MESSFL,SCLU,SGRP,
     O                                        RESP)
C
C                If user selected not to save changes, return to UTILITY/
C                Setup menu.
                 IF (RESP.EQ.2) GO TO 9990
C
C                User has choosen to make changes permanent.  Determine if
C                TERM.DAT file already exists.
C                Prepare to open the TERM.DAT file.
                 SGRP = 9
C                 
                 CALL QFOPFN
     I                       (MESSFL,SCLU,SGRP,FLNAME,PRTFLG,
     O                                                    TDATFL,RETCOD)
C
                 IF (RETCOD.EQ.I0) THEN
C                   TERM.DAT file opened successfully.
C                   Ask if user wishes to modify existing file.
                    SGRP = 6
C
C                   Make 'PREV' option unavailable.
                    I = 4
                    CALL ZSTCMA
     I                          (I,I0)
C
C                   Display Yes/No options menu on the screen to ask user
C                   if he/she would like to modify existing TERM.DAT file.
                    CALL QRESP
     I                         (MESSFL,SCLU,SGRP,
     O                                           RESP)

C                   If user selected not to save changes to existing
C                   TERM.DAT file; return to UTILITY/Setup menu.
                    IF (RESP.EQ.2) GO TO 9000
C
C                   User has choosen to save changes to existing TERM.DAT
C                   file.  Move record pointer past last logical record in
C                   file but before end-of-file marker (EOF).
CMS - COMMENT OUT FOR PC
CMS                    WRITE (TDATFL,*)
CMS - COMMENT OUT FOR PC
C
CPC - COMMENT OUT FOR VAX AND MSPS
C   90               READ (UNIT=TDATFL,FMT=999,END=100)
C                    GO TO 90
C  100               BACKSPACE (UNIT=TDATFL)
CPC - COMMENT OUT FOR VAX AND MSPS
CVAX/PC - COMMENT OUT FOR MSPS
C                    BACKSPACE (UNIT=TDATFL)
CVAX/PC - COMMENT OUT FOR MSPS
CPC - COMMENT OUT FOR MSPS
C                    READ (UNIT=TDATFL,FMT=999)
CPC - COMMENT OUT FOR MSPS
C
                 ELSE
C                 
CVAX/PC
C                   TERM.DAT file not found and opened.  Create new file.
                    OPEN (UNIT=TDATFL,FILE='TERM.DAT',STATUS='NEW',
     1                    ACCESS='SEQUENTIAL',FORM='FORMATTED',
     2                    IOSTAT=IOSTAT,BLANK='NULL',ERR=9991)
CVAX     3                    CARRIAGECONTROL='LIST')
CVAX/PC
C                 
                 ENDIF
C
C                Display status message.
                 SGRP = 7
                 CALL PMXCNW
     I                       (MESSFL,SCLU,SGRP,I1,I1,I1,
     O                                                  J)
C
C                Write new system specification and/or terminal definition
C                parameter(s) to TERM.DAT file.  Colors:
                 IF (CHGFLG(1).EQ.'Y') THEN
                    PRMNAM = 'CLRFRS'
                    WRITE (TDATFL,1000) PRMNAM, UPARMS(30)
                    PRMNAM = 'CLRBKS'
                    WRITE (TDATFL,1000) PRMNAM, UPARMS(34)
                 ENDIF    
C
C                <Enter>/<CR> key attribute:
                 IF (CHGFLG(2).EQ.'Y') THEN
                    PRMNAM = 'MENCRA'
                    IF (UPARMS(9).EQ.1) CPRMVL = 'NONE'
                    IF (UPARMS(9).EQ.2) CPRMVL = 'DOWN'
                    IF (UPARMS(9).EQ.3) CPRMVL = 'NEXT'
                    WRITE (TDATFL,1010) PRMNAM, CPRMVL
                 ENDIF    
C
C                GKS support flag:
                 IF (CHGFLG(3).EQ.'Y') THEN
                    PRMNAM = 'GRAPHS'
                    IF (UPARMS(16).EQ.1) CPRMVL = 'YES '
                    IF (UPARMS(16).EQ.2) CPRMVL = 'NO  '
                    WRITE (TDATFL,1010) PRMNAM, CPRMVL
                 ENDIF
C
C                User experience level flag:
                 IF (CHGFLG(4).EQ.'Y') THEN
                    PRMNAM = 'USRLEV'
                    WRITE (TDATFL,1000) PRMNAM, UPARMS(45)
                 ENDIF
C
 9000            CONTINUE
C                Close TERM.DAT file.
                 CLOSE (UNIT=TDATFL,IOSTAT=IOSTAT,STATUS='KEEP')
C
              ENDIF
C
           ENDIF
C
 9990 CONTINUE
C
C     Continue processing or return to Main Option Menu?
C     Test "done processing" flag.
C
      IF (DONFG.EQ.0) GO TO 10
C
C $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
C $   GO TO 10 statement ends processing loop begun with 10 CONTINUE   $
C $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
C
      DONFG = 0
      GO TO 9999
C
 9991 CONTINUE
C
C     Make 'PREV' option unavailable.
      I= 4
      CALL ZSTCMA (I,I0)
C     Make 'INTRPT' option unavailable.
      I= 16
      CALL ZSTCMA (I,I0)
C
      SGRP   = 8
C
C     Display status message for FORTRAN OPEN statement error.
      CALL PMXCNW
     I            (MESSFL,SCLU,SGRP,I1,I1,I0,
     O                                       J)
C
 9999 CONTINUE
      RETURN
      END
