      SUBROUTINE CHRCHK (MESSFL,SCLU,IVRCNT,INVRNM,
     M                   USRNAM,
     O                   IND)
C
C     + + + PURPOSE + + +
C     routine to search through INVRNM array for a user input
C     variable code to see if it exists and to make sure there
C     are no conflicting responses
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER     MESSFL,SCLU,IVRCNT,IND
      CHARACTER*1 INVRNM(8,IVRCNT),USRNAM(8)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     MESSFL - Fortran unit number for message file
C     SCLU   - cluster number on message file
C     IVRCNT - number of variable codes in INVRNM array
C     INVRNM - character array holding variable codes from INVAR.DAT
C     USRNAM - variable code input by user
C     IND    - index number in INVRNM array,
C              0 indicates conflicting values
C
C     + + + LOCAL VARIABLES + + +
      INTEGER     I,K,K1,L,I0,I8,DONE,CURIND,CONFLG,CHK,LEN,
     1            SGRP,INIT,IWRT,DONFG
      CHARACTER*1 BLNK,COMMA,TMPNAM(8),TBUFF(80)
C
C     + + + FUNCTIONS + + +
      INTEGER     LENSTR
C
C     + + + EXTERNALS + + +
      EXTERNAL    LENSTR, CHRCHR, QUPCAS, ZBLDWR, PMXCNW, ZIPC
C
C     + + + END SPECIFICATIONS + + +
C
      I0   = 0
      I8   = 8
      BLNK = ' '
      COMMA= ','
C
      LEN= LENSTR(I8,USRNAM)
      IF (LEN.EQ.0) THEN
C       user input blanks
        IND= 0
      ELSE
C       user did not input blanks, what is the variable code
        IND   = 0
        DONE  = 0
        INIT  = 1
        IWRT  = -1
        CONFLG= 0
        CURIND= 0
C       make input code upper case for comparison
        CALL QUPCAS (I8,USRNAM)
        CALL CHRCHR (I8,USRNAM,TMPNAM)
 10     CONTINUE
          CURIND= CURIND+ 1
          IF (CURIND.LE.IVRCNT) THEN
C           check strings
            K= 0
 20         CONTINUE
              K  = K+ 1
              CHK= 0
              IF (INVRNM(K,CURIND).EQ.USRNAM(K)) CHK= 1
              IF (CHK.EQ.1) THEN
                IF (K.EQ.I8) THEN
C                 sure unique match
                  IND = CURIND
                  DONE= 1
                ELSE
                  K1= K+ 1
                  IF (K1.GT.LEN) THEN
C                   end of users input, possible match
                    IF (IND.EQ.0) THEN
C                     first match, save index
                      IND= CURIND
C                     save rest of name
                      I= I8- K
                      CALL CHRCHR (I,INVRNM(K1,CURIND),TMPNAM(K1))
                    ELSE
C                     conflict match, write out first name
                      IF (CONFLG.LE.1) THEN
C                       init conflicting buffer
                        L= 80
                        CALL ZIPC (L,BLNK,TBUFF)
                        IF (CONFLG.EQ.0) CONFLG= 1
                      END IF
                      L= LENSTR(I8,INVRNM(1,IND))
                      CALL CHRCHR (L,INVRNM(1,IND),TBUFF(CONFLG))
                      TBUFF(CONFLG+L)= COMMA
                      IND   = CURIND
                      CONFLG= CONFLG+ L+ 2
                      IF (CONFLG.GT.69) THEN
C                       need a new line for conflicting values
                        IF (INIT.EQ.1) THEN
C                         first write, write 'conflicting' message
                          SGRP= 53
                          CALL PMXCNW (MESSFL,SCLU,SGRP,I8,INIT,IWRT,L)
                          INIT= 0
                        END IF
                        CALL ZBLDWR (CONFLG-2,TBUFF,INIT,IWRT,DONFG)
                        CONFLG= 1
                      END IF
                    END IF
C                   force exit from iner loop
                    K= 9
                  END IF
                END IF
              END IF
            IF (CHK.EQ.1.AND.K.LT.8.AND.DONE.EQ.0) GO TO 20
          ELSE
            DONE= 1
          END IF
        IF (DONE.EQ.0) GO TO 10
C
        IF (CONFLG.GT.0) THEN
C         conflict of response, print last one
          IF (INIT.EQ.1) THEN
C           first write, write 'conflicting' message
            SGRP= 53
            CALL PMXCNW (MESSFL,SCLU,SGRP,I8,INIT,IWRT,L)
            INIT= 0
          END IF
C         put last conflicting value in buffer
          L= LENSTR(I8,INVRNM(1,IND))
          CALL CHRCHR (L,INVRNM(1,IND),TBUFF(CONFLG))
          CONFLG= CONFLG+ L
          CALL ZBLDWR (CONFLG,TBUFF,INIT,IWRT,DONFG)
          IND= 0
        ELSE IF (IND.EQ.0) THEN
C         not a valid code, try again
          SGRP= 54
          CALL PMXCNW (MESSFL,SCLU,SGRP,I8,INIT,IWRT,L)
        END IF
C
        IF (IND.GT.0) THEN
C         save whole name
          I= 8
          CALL CHRCHR (I,TMPNAM,USRNAM)
        END IF
      END IF
C
      RETURN
      END
