      SUBROUTINE CHRSRT (INVRFL,
     O                   INVRNM,IVRCNT,VARPOS)
C
C     + + + PURPOSE + + +
C     routine to sort variable codes from INVAR.DAT file
C     for input in UNCAS section of ANNIE/QUAL2E
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER     INVRFL,IVRCNT,VARPOS(150)
      CHARACTER*1 INVRNM(8,150)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     INVRFL - unit number for INVAR.DAT file
C     INVRNM - character array for variable codes
C     IVRCNT - counter of number of variables codes input
C     VARPOS - bubble sort pointer for input variable codes
C
C     + + + LOCAL VARIABLES + + +
      INTEGER     I,I4,I8
      CHARACTER*1 HELP(4),BLNK(1)
C
C     + + + EXTERNALS + + +
      EXTERNAL   Q2BSRT, CHRCHR, ZIPC
C
C     + + + DATA INITIALIZATIONS + + +
      DATA HELP/'H','E','L','P'/
C
C     + + + INPUT FORMATS + + +
 1000 FORMAT (35X,8A1)
C
C     + + + END SPECIFICATIONS + + +
C
      I4= 4
      I8= 8
      BLNK(1)= ' '
C     dummy reads to skip first two lines at top of INVAR.DAT
      READ (INVRFL,1000) (INVRNM(I,1),I=1,8)
      READ (INVRFL,1000) (INVRNM(I,1),I=1,8)
C     put 'HELP' into first INVRNM space
      CALL ZIPC (I8,BLNK(1),INVRNM)
      CALL CHRCHR (I4,HELP,INVRNM)
C
      IVRCNT= 1
 10   CONTINUE
C       read in all variable codes from file
        IVRCNT= IVRCNT+ 1
        READ (INVRFL,1000,END=12) (INVRNM(I,IVRCNT),I=1,8)
      IF (INVRNM(1,IVRCNT).NE.' ') GO TO 10
C
 12   CONTINUE
C     sort input variable codes alphabetically
      CALL Q2BSRT (INVRNM,IVRCNT,
     O             VARPOS)
C
      RETURN
      END
