      SUBROUTINE LCLREA (MXTIM,LCLFIL,
     M                   RETCOD,
     O                   NROWS,CLDTM,CLDAT)
C
C     + + + PURPOSE + + +
C     routine to read in old local climatological data
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER     MXTIM,LCLFIL,RETCOD,NROWS,
     1            CLDTM(4,MXTIM)
      REAL        CLDAT(6,MXTIM)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     MXTIM - maximum number of iterations
C     LCLFIL - local clim file unit number
C     RETCOD - return code
C     NROWS  - number of rows of data (iterations)
C     CLDTM  - day, month, year, hour data
C     CLDAT  - climatological data
C
C     + + + LOCAL VARIABLES + + +
      INTEGER     I,J,LEN
      CHARACTER*1 FCHRS(4),LOCA(4)
C
C     + + + FUNCTIONS + + +
      INTEGER     STRFND
C
C     + + + EXTERNALS + + +
      EXTERNAL    STRFND
C
C     + + + DATA INITIALIZATIONS + + +
      DATA LOCA/'L','O','C','A'/
C
C     + + + INPUT FORMAT + + +
 1000 FORMAT (4A1,13X,I2,I3,I3,I5,F10.0,5F8.0)
C
C     + + + END SPECIFICATIONS + + +
C
      NROWS= 0
      LEN  = 4
 10   CONTINUE
C       read until no more data
        NROWS= NROWS+ 1
        READ (LCLFIL,1000,ERR=90) FCHRS,CLDTM(2,NROWS),CLDTM(3,NROWS),
     1        CLDTM(1,NROWS),CLDTM(4,NROWS),(CLDAT(J,NROWS),J=1,6)
        I= STRFND(LEN,FCHRS,LEN,LOCA)
      IF (NROWS.LT.MXTIM.AND.I.NE.0) GO TO 10
      NROWS= NROWS- 1
      GO TO 95
C
 90   CONTINUE
C       read error
        RETCOD= 1
C
 95   CONTINUE
C
      RETURN
      END
