      SUBROUTINE LCLWRT (MESSFL,SCLU,LCLFIL,NROWS,CLDTM,CLDAT)
C
C     + + + PURPOSE + + +
C     routine to write out local climatological file
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER     MESSFL,SCLU,LCLFIL,NROWS,CLDTM(4,NROWS)
      REAL        CLDAT(6,NROWS)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     MESSFL - unit number for message file
C     SCLU   - screen cluster number on message file
C     LCLFIL - unit number for local clim data
C     NROWS  - number of iterations
C     CLDTM  - day, month, year, hour data
C     CLDAT  - local clim data
C
C     + + + LOCAL VARIABLES + + +
      INTEGER     I,J,K,L,LEN,JUST,SGRP
      CHARACTER*1 TBUFF(80),BLNK
C
C     + + + FUNCTIONS + + +
      INTEGER     LENSTR
C
C     + + + EXTERNALS + + +
      EXTERNAL    ZIPC, GETTXT, INTCHR, DECCHR, LENSTR
C
C     + + + OUTPUT FORMAT + + +
 2000 FORMAT (80A1)
C
C     + + + END SPECIFICATIONS + + +
C
      LEN = 80
      BLNK= ' '
      JUST= 0
      CALL ZIPC(LEN,BLNK,TBUFF)
C
      DO 20 I= 1,NROWS
C       write out data for each iteration
        L   = 80
        SGRP= 13
        CALL GETTXT (MESSFL,SCLU,SGRP,L,TBUFF)
        L   = 2
        CALL INTCHR (CLDTM(2,I),L,JUST,K,TBUFF(18))
        CALL INTCHR (CLDTM(3,I),L,JUST,K,TBUFF(21))
        CALL INTCHR (CLDTM(1,I),L,JUST,K,TBUFF(24))
        CALL INTCHR (CLDTM(4,I),L,JUST,K,TBUFF(29))
        L   = 8
        DO 10 J= 1,6
          CALL DECCHR (CLDAT(J,I),L,JUST,K,TBUFF(25+J*L))
 10     CONTINUE
        WRITE (LCLFIL,2000) (TBUFF(K),K=1,LENSTR(LEN,TBUFF))
        L   = 80
        CALL ZIPC (L,BLNK,TBUFF)
 20   CONTINUE
C     write blank line to signal end of file
      WRITE (LCLFIL,2000) TBUFF
C
      RETURN
      END
