      SUBROUTINE MPCD
     I                (MESSFL,SCLU,METFLG,
     M                 NPOPT,PCIVL,PCRVL,MAXITR)
C
C     + + + PURPOSE + + +
C     routine to process input for form 2
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER   MESSFL,SCLU,METFLG,NPOPT(7),PCIVL(3)
      REAL      PCRVL(13),MAXITR
C
C     + + + ARGUMENT DEFINITIONS + + +
C     MESSFL - unit number for message file
C     SCLU   - cluster number on message file
C     METFLG - flag indicating metric units, 0 - no, 1 - yes
C     NPOPT  - array for first 7 options on form 2
C     PCIVL  - integer array of program control data on form 2
C     PCRVL  - real array of program control data on form 2
C     MAXITR - maximum number of iterations
C
C     + + + LOCAL VARIABLES + + +
      INTEGER     SGRP,I,I1,LEN,RNUM,CNUM,IVAL(1),CVAL(9,3)
      REAL        RVAL(13)
      DOUBLE PRECISION DVAL(2)
      CHARACTER*1 SCHRBF(170),BLNK
C
C     + + + EXTERNALS + + +
      EXTERNAL   QRESCZ, PRNTXT, ZIPC
C
C     + + + END SPECIFICATIONS + + +
C
      I1  = 1
      BLNK= ' '
      LEN = 170
      CALL ZIPC (LEN,BLNK,SCHRBF)
C
      RVAL(1)= PCRVL(1)
      RVAL(2)= PCRVL(13)
      IF (NPOPT(4).EQ.2) THEN
C       not steady state, set time step and route time values
        RVAL(3)= PCRVL(3)
        RVAL(5)= 0.
      ELSE
C       steady state, no time step
        RVAL(3) = 0.0
        RVAL(5) = PCRVL(3)
      END IF
      RVAL(4)= PCRVL(4)
      DO 10 I= 5,12
        RVAL(I+1)= PCRVL(I)
 10   CONTINUE
      DO 20 I= 1,7
        CVAL(I,1)= NPOPT(I)
 20   CONTINUE
      CVAL(8,1)= PCIVL(1)
      CVAL(9,1)= PCIVL(3)
      SGRP= 3+ METFLG
      RNUM= 13
      CNUM= 9
      CALL QRESCZ (MESSFL,SCLU,SGRP,I1,RNUM,I1,CNUM,I1,I1,LEN,
     M             IVAL,RVAL,DVAL,CVAL,SCHRBF)
      PCRVL(13)= RVAL(2)
      IF (NPOPT(4).EQ.2) THEN
C       not steady state, set time step and route time values
        PCRVL(1)= RVAL(1)
        PCRVL(3)= RVAL(3)
      ELSE
C       steady state, set max iterations
        PCRVL(1)= 0
        PCRVL(3)= RVAL(5)
      END IF
      MAXITR= PCRVL(3)
      PCRVL(4) = RVAL(4)
      DO 30 I= 5,12
        PCRVL(I)= RVAL(I+1)
 30   CONTINUE
      DO 40 I= 1,7
        NPOPT(I) = CVAL(I,1)
 40   CONTINUE
      PCIVL(1)= CVAL(8,1)
      PCIVL(3)= CVAL(9,1)
C
      RETURN
      END
