      SUBROUTINE OBSREA (MESSFL,SCLU,OBDOFL,MAXPLT,MAXLOC,
     O                   DOTITL,NUMPLT,NUMLOC,DODAT,RETCOD)
C
C     + + + PURPOSE + + +
C     routine to read in observed DO data
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER     MESSFL,SCLU,OBDOFL,MAXPLT,MAXLOC,NUMPLT,
     1            NUMLOC(MAXPLT),RETCOD
      REAL        DODAT(4,MAXLOC)
      CHARACTER*1 DOTITL(70)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     MESSFL - unit number for message file
C     SCLU   - screen cluster number for observed DO cluster on message file
C     OBDOFL - unit number for observed DO file
C     MAXPLT - maximum number of plots
C     DOTITL - title of DO data
C     MAXLOC - max number of locations
C     NUMPLT - number of plots
C     NUMLOC - number of locations for each plot
C     DODAT  - DO data array
C     RETCOD - return code for error trapping
C
C     + + + LOCAL VARIABLES + + +
      INTEGER     SGRP,I,J,K,LEN,DATPOS
      CHARACTER*1 FCHR(4),NUM(4),BLNK(4),TBUFF(80)
C
C     + + + FUNCTIONS + + +
      INTEGER     STRFND
C
C     + + + EXTERNALS + + +
      EXTERNAL    STRFND, PRNTXI
C
C     + + + DATA INITIALIZATIONS + + +
      DATA NUM/'N','U','M',' '/
      DATA BLNK/' ',' ',' ',' '/
C
C     + + + INPUT FORMATS + + +
1000  FORMAT (10X,70A1)
1010  FORMAT (4A1,6X,I4)
1020  FORMAT (4A1,6X,4F10.0)
C
C     + + + END SPECIFICATIONS + + +
C
C     read DO title and number of plots
      RETCOD= 1
      READ (OBDOFL,1000,ERR=900) DOTITL
C
C     read DO data for 1 to NUMPLT
      LEN   = 4
      NUMPLT= 1
      DATPOS= 1
      RETCOD= 2
C     read number of locations
      READ (OBDOFL,1010,ERR=900) FCHR,NUMLOC(NUMPLT)
      J= STRFND(LEN,FCHR,LEN,BLNK)
      IF (J.EQ.0) THEN
 20     CONTINUE
          RETCOD= 3
          DO 30 I= 1,NUMLOC(NUMPLT)
C           read DO data for each location
            READ (OBDOFL,1020,ERR=900) FCHR,
     1                                 (DODAT(K,(DATPOS-1)+I),K=1,4)
            J= STRFND(LEN,FCHR,LEN,NUM)
 30       CONTINUE
          RETCOD= 2
C         read number of locations
          NUMPLT= NUMPLT+ 1
          READ (OBDOFL,1010,ERR=900) FCHR,NUMLOC(NUMPLT)
          DATPOS= DATPOS+ NUMLOC(NUMPLT-1)
          J= STRFND(LEN,FCHR,LEN,BLNK)
        IF (J.EQ.0) GO TO 20
      END IF
C
      RETCOD= 0
      GO TO 950
C
 900  CONTINUE
C       read error
        SGRP= 10
        CALL PRNTXI (MESSFL,SCLU,SGRP,RETCOD)
        BACKSPACE OBDOFL
        READ (OBDOFL,1000) TBUFF
        I= 80
C       CALL PRTSCR (I,TBUFF)
C
 950  CONTINUE
C
      RETURN
      END
