      SUBROUTINE QEINCO
     I                  (MESSFL,NUMRCH,METFLG,SCNAME,
     M                   DAT7,DAT7A)
C
C     + + + PURPOSE + + +
C     modify initial conditions
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER   MESSFL,NUMRCH,METFLG
      REAL      DAT7(9,NUMRCH),DAT7A(8,NUMRCH)
      CHARACTER SCNAME*(*)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     MESSFL - Fortran unit number for message file
C     NUMRCH - number of reaches
C     METFLG - input metric units flag
C     SCNAME - screen name showing path used to get here
C     DAT7   - array of first set of initial conditions
C     DAT7A  - array of second set of initial conditions
C
C     + + + LOCAL VARIABLES + + +
      INTEGER     I1,SCLU,SGRP,RNUM,IVAL(1,200),CVAL(1,3,200),IPOS,IRET
C      INTEGER     I1,SCLU,SGRP,RNUM,IVAL(1,50),CVAL(1,3,50),IPOS,IRET
      CHARACTER*1 TBUFF(80,200),DASH
C      CHARACTER*1 TBUFF(80,50),DASH
C
C     + + + INTRINSICS + + +
      INTRINSIC   INDEX
C
C     + + + EXTERNALS + + +
      EXTERNAL    QRESCN, ZGTRET, ZWNSET
C
C     + + + END SPECIFICATIONS + + +
C
      I1  = 1
      DASH= '-'
      SCLU= 9
C
 10   CONTINUE
C       loop back here if user selects 'prev' from 2nd screen
        RNUM= 9
C       first set of initial conditions
        CALL ZWNSET (SCNAME)
        SGRP= 14+ METFLG
        CALL QRESCN (MESSFL,SCLU,SGRP,I1,RNUM,I1,NUMRCH,I1,
     M               IVAL,DAT7,CVAL,TBUFF)
C
C       get user exit command
        CALL ZGTRET (IRET)
        IF (IRET.EQ.1) THEN
C         user selected 'next', continue
          IPOS= INDEX(SCNAME,DASH)+ 1
          SCNAME(IPOS:IPOS)= '2'
          CALL ZWNSET (SCNAME)
          RNUM= 8
C         second set of initial conditions
          SGRP= 16
          CALL QRESCN (MESSFL,SCLU,SGRP,I1,RNUM,I1,NUMRCH,I1,
     M                 IVAL,DAT7A,CVAL,TBUFF)
C         get user exit command
          CALL ZGTRET (IRET)
          IF (IRET.EQ.2) SCNAME(IPOS:IPOS)= '1'
        ELSE
C         reset user exit command
          IRET= 1
        END IF
      IF (IRET.EQ.2) GO TO 10
C
      RETURN
      END
