      SUBROUTINE QEPRPL
     I                  (MESSFL,NUMRCH,SCNAME,MXPLT,MXRCH,
     M                   NUMPLT,PLTSTR,PLTRCH)
C
C     + + + PURPOSE + + +
C     modify print/plot data
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER   MESSFL,NUMRCH,MXPLT,MXRCH,
     1          NUMPLT,PLTSTR(MXPLT),PLTRCH(MXRCH,MXPLT)
      CHARACTER SCNAME*(*)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     MESSFL - Fortran unit number for message file
C     NUMRCH - number of reaches
C     SCNAME - screen name showing path used to get here
C     MXPLT  - maximum number of plots
C     MXRCH  - maximum number of reaches
C     NUMPLT - number of plots
C     PLTSTR - starting reach for each plot
C     PLTRCH - array of reaches to be plotted for each plot
C
C     + + + LOCAL VARIABLES + + +
      INTEGER      I,J,I0,I1,SCLU,SGRP,MXLIN,IWRT,IMIN,IMAX,IDEF,
     1             IRET,IPOS,CLEN,ISCR,FSTRCH,LMXRCH,INUM,CNUM,
     2             IVAL(3),CVAL(25,3)
      REAL         RVAL(1)
      CHARACTER*1  TBUFF(80),DASH
      CHARACTER*20 LSCNAM
C
C     + + + INTRINSICS + + +
      INTRINSIC    INDEX
C
C     + + + EXTERNALS + + +
      EXTERNAL     QRESPI, ZGTRET, ZWNSET, PMXTXI, ZMNSST
      EXTERNAL     QRSPUI, ZIPI, QRESPM
C
C     + + + END SPECIFICATIONS + + +
C
      I0  = 0
      I1  = 1
      SCLU= 9
      DASH= '-'
C
 10   CONTINUE
        SGRP= 4
C       how many plots
        CALL ZWNSET (SCNAME)
        CALL QRESPI (MESSFL,SCLU,SGRP,NUMPLT)
C
C       get user exit command
        CALL ZGTRET(IRET)
        IF (IRET.EQ.1) THEN
C         user selected 'next', get starting reach for each plot
          I= 0
 15       CONTINUE
C           get message indicating which plot (dont write yet)
            I= I+ 1
            SGRP = 5
            IWRT = -1
            MXLIN= 50
            CALL PMXTXI (MESSFL,SCLU,SGRP,MXLIN,I1,IWRT,
     I                   I1,I)
C           save message for next screen
            CALL ZMNSST
C           set window name for this screen
            IPOS= INDEX(SCNAME,DASH)
            CLEN= LEN(SCNAME)
            LSCNAM= SCNAME(1:IPOS)//' start '//SCNAME(IPOS+12:CLEN)
            CALL ZWNSET (LSCNAM)
C           first reach in plot, set min, max, def
            IMIN= 1
            IMAX= NUMRCH
            IDEF= 1
            SGRP= 6
            CALL QRSPUI (MESSFL,SCLU,SGRP,IMIN,IMAX,IDEF,
     M                   PLTSTR(I))
            IF (PLTSTR(I).GT.1) THEN
              DO 20 J= 1,PLTSTR(I)-1
                PLTRCH(J,I)= 0
 20           CONTINUE
            END IF
            IF (PLTRCH(PLTSTR(I),I).EQ.0) THEN
C             first time defining plots, initialize
              DO 30 J= PLTSTR(I),NUMRCH
                PLTRCH(J,I)= J
 30           CONTINUE
            END IF
C           get user exit command
            CALL ZGTRET(IRET)
            IF (IRET.EQ.2 .AND. I.GT.1) THEN
C             room to go back to previous plot definitions
              I= I- 1
              IRET= 1
            END IF
            IF (IRET.EQ.1) THEN
C             user wants to continue
              ISCR= 1
 35           CONTINUE
C               get message indicating which reaches may be modified
                SGRP= 7
                IWRT= -1
                INUM= 3
                IVAL(1)= I
                IVAL(2)= PLTSTR(I)
                IVAL(3)= NUMRCH
                CALL PMXTXI (MESSFL,SCLU,SGRP,MXLIN,I1,IWRT,INUM,IVAL)
                IF (NUMRCH.GT.25 .AND. ISCR.EQ.1) THEN
C                 display message on how to edit reaches not on this screen
                  SGRP= 20
                  IF (NUMRCH.GE.50) IVAL(3)=50
                  CALL PMXTXI (MESSFL,SCLU,SGRP,MXLIN,
     1                         -I1,IWRT,I1,IVAL(3))
C                 only do first 25 reaches on first screen
                  LMXRCH= 25
                ELSE IF (NUMRCH.GT.50 .AND. ISCR.EQ.2) THEN
C                 display message on how to edit reaches not on this screen
                  SGRP= 22
                  IF (NUMRCH.GE.75) IVAL(3)=75
                  CALL PMXTXI (MESSFL,SCLU,SGRP,MXLIN,
     1                         -I1,IWRT,I1,IVAL(3))
                  LMXRCH= 50
                ELSE IF (NUMRCH.GT.75 .AND. ISCR.EQ.3) THEN
C                 display message on how to edit reaches not on this screen
                  SGRP= 24
                  IF (NUMRCH.GE.100) IVAL(3)=100
                  CALL PMXTXI (MESSFL,SCLU,SGRP,MXLIN,
     1                         -I1,IWRT,I1,IVAL(3))
                  LMXRCH= 75
                ELSE IF (NUMRCH.GT.100 .AND. ISCR.EQ.4) THEN
C                 display message on how to edit reaches not on this screen
                  SGRP= 26
                  IF (NUMRCH.GE.125) IVAL(3)=125
                  CALL PMXTXI (MESSFL,SCLU,SGRP,MXLIN,
     1                         -I1,IWRT,I1,IVAL(3))
                  LMXRCH= 100
                ELSE IF (NUMRCH.GT.125 .AND. ISCR.EQ.5) THEN
C                 display message on how to edit reaches not on this screen
                  SGRP= 28
                  IF (NUMRCH.GE.150) IVAL(3)=150
                  CALL PMXTXI (MESSFL,SCLU,SGRP,MXLIN,
     1                         -I1,IWRT,I1,IVAL(3))
                  LMXRCH= 125
                ELSE IF (NUMRCH.GT.150 .AND. ISCR.EQ.6) THEN
C                 display message on how to edit reaches not on this screen
                  SGRP= 30
                  IF (NUMRCH.GE.175) IVAL(3)=175
                  CALL PMXTXI (MESSFL,SCLU,SGRP,MXLIN,
     1                         -I1,IWRT,I1,IVAL(3))
                  LMXRCH= 150
                ELSE IF (NUMRCH.GT.175 .AND. ISCR.EQ.7) THEN
C                 display message on how to edit reaches not on this screen
                  SGRP= 32
                  IF (NUMRCH.GE.200) IVAL(3)=200
                  CALL PMXTXI (MESSFL,SCLU,SGRP,MXLIN,
     1                         -I1,IWRT,I1,IVAL(3))
                  LMXRCH= 175
                ELSE
                  LMXRCH= NUMRCH
                END IF
C               save message for next screen
                CALL ZMNSST
                CNUM= 25
                CALL ZIPI (3*CNUM,I1,CVAL)
                IF (ISCR.EQ.1) THEN
                  FSTRCH= PLTSTR(I)
                  K= FSTRCH- 1
                ELSE IF (ISCR.EQ.2) THEN
                  FSTRCH= 26
                  K= 0
                ELSE IF (ISCR.EQ.3) THEN
                  FSTRCH= 51
                  K= 0
                ELSE IF (ISCR.EQ.4) THEN
                  FSTRCH= 76
                  K= 0
                ELSE IF (ISCR.EQ.5) THEN
                  FSTRCH= 101
                  K= 0
                ELSE IF (ISCR.EQ.6) THEN
                  FSTRCH= 126
                  K= 0
                ELSE IF (ISCR.EQ.7) THEN
                  FSTRCH= 151
                  K= 0
                ELSE
                  FSTRCH= 176
                  K= 0
                END IF
                DO 40 J= FSTRCH,LMXRCH
                  K= K+ 1
                  IF (PLTRCH(J,I).GT.0) THEN
C                   this reach is on, set CVAL
                    CVAL(K,1)= 2
                  END IF
 40             CONTINUE
C               turn off which reaches?
                LSCNAM= SCNAME(1:IPOS)//' define '//SCNAME(IPOS+12:CLEN)
                CALL ZWNSET (LSCNAM)
                IF (ISCR.EQ.1) THEN
                  SGRP= 8
                ELSE IF (ISCR.EQ.2) THEN
                  SGRP= 21
                ELSE IF (ISCR.EQ.3) THEN
                  SGRP= 23
                ELSE IF (ISCR.EQ.4) THEN
                  SGRP= 25
                ELSE IF (ISCR.EQ.5) THEN
                  SGRP= 27
                ELSE IF (ISCR.EQ.6) THEN
                  SGRP= 29
                ELSE IF (ISCR.EQ.7) THEN
                  SGRP= 31
                ELSE
                  SGRP= 33
                END IF
                CALL QRESPM (MESSFL,SCLU,SGRP,I1,I1,CNUM,
     M                       IVAL,RVAL,CVAL,TBUFF)
C               get user exit command value
                CALL ZGTRET (IRET)
                IF (ISCR.EQ.1) THEN
                  K= FSTRCH- 1
                ELSE
                  K= 0
                END IF
                DO 50 J= FSTRCH,LMXRCH
C                 only update reaches allowed
                  K= K+ 1
                  IF (CVAL(K,1).EQ.2) THEN
C                   this reach is on, set PLTRCH
                    PLTRCH(J,I)= J
                  ELSE
C                   turn off reach
                    PLTRCH(J,I)= 0
                  END IF
 50             CONTINUE
                IF (IRET.EQ.2) THEN
C                 user wants previous screen
                  ISCR= ISCR- 1
C                 may need to back up one plot definition
                  IF (ISCR.EQ.0) I= I- 1
                  IRET= 1
                ELSE IF (LMXRCH.LT.NUMRCH) THEN
C                 more reaches to define
                  ISCR= ISCR+ 1
                ELSE
C                 last screen of reaches and user wants 'next' screen
                  ISCR= 0
                END IF
              IF (ISCR.NE.0) GO TO 35
            END IF
          IF (I.LT.NUMPLT .AND. IRET.EQ.1) GO TO 15
        ELSE 
C         reset exit command value
          IRET= 1
        END IF
      IF (IRET.EQ.2) GO TO 10
C
      RETURN
      END
